-- MySQL dump 10.13  Distrib 8.0.44, for Linux (x86_64)
--
-- Host: localhost    Database: panahan_turnament_new
-- ------------------------------------------------------
-- Server version	8.0.44

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `bracket_champions`
--

DROP TABLE IF EXISTS `bracket_champions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bracket_champions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `kegiatan_id` int NOT NULL,
  `category_id` int NOT NULL,
  `scoreboard_id` int NOT NULL,
  `champion_id` int NOT NULL,
  `runner_up_id` int DEFAULT NULL,
  `third_place_id` int DEFAULT NULL,
  `bracket_size` int NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_champion` (`kegiatan_id`,`category_id`,`scoreboard_id`),
  KEY `idx_kegiatan` (`kegiatan_id`),
  KEY `idx_category` (`category_id`),
  KEY `idx_scoreboard` (`scoreboard_id`),
  KEY `idx_champion` (`champion_id`),
  KEY `idx_runner_up` (`runner_up_id`),
  KEY `idx_third_place` (`third_place_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bracket_champions`
--

LOCK TABLES `bracket_champions` WRITE;
/*!40000 ALTER TABLE `bracket_champions` DISABLE KEYS */;
INSERT INTO `bracket_champions` VALUES (1,12,2,18,81,79,NULL,16,'2025-10-14 09:30:10','2025-10-17 11:37:28'),(2,12,2,16,72,73,NULL,16,'2025-10-14 11:21:11',NULL);
/*!40000 ALTER TABLE `bracket_champions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bracket_matches`
--

DROP TABLE IF EXISTS `bracket_matches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bracket_matches` (
  `id` int NOT NULL AUTO_INCREMENT,
  `kegiatan_id` int NOT NULL,
  `category_id` int NOT NULL,
  `scoreboard_id` int NOT NULL,
  `match_id` varchar(50) NOT NULL,
  `winner_id` int DEFAULT NULL,
  `loser_id` int DEFAULT NULL,
  `bracket_size` int NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_match` (`kegiatan_id`,`category_id`,`scoreboard_id`,`match_id`),
  KEY `idx_kegiatan` (`kegiatan_id`),
  KEY `idx_category` (`category_id`),
  KEY `idx_scoreboard` (`scoreboard_id`),
  KEY `idx_winner` (`winner_id`),
  KEY `idx_loser` (`loser_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bracket_matches`
--

LOCK TABLES `bracket_matches` WRITE;
/*!40000 ALTER TABLE `bracket_matches` DISABLE KEYS */;
INSERT INTO `bracket_matches` VALUES (1,12,2,18,'final',81,79,16,'2025-10-14 09:30:10','2025-10-17 11:37:28'),(2,12,2,18,'third-place',79,77,16,'2025-10-14 11:19:13','2025-10-14 11:30:56'),(3,12,2,16,'final',72,73,16,'2025-10-14 11:21:11',NULL),(4,12,2,16,'third-place',76,81,16,'2025-10-14 11:21:16',NULL);
/*!40000 ALTER TABLE `bracket_matches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `min_age` int NOT NULL,
  `max_age` int NOT NULL,
  `gender` enum('Laki-laki','Perempuan','Campuran') COLLATE utf8mb4_general_ci DEFAULT 'Campuran',
  `max_participants` int DEFAULT '32',
  `status` enum('active','inactive') COLLATE utf8mb4_general_ci DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Official',0,1000,'Campuran',16,'active','2025-08-16 04:37:59','2025-09-08 06:06:21'),(2,'Shortbow NON Pelajar Putra jarak 20m',0,1000,'Laki-laki',16,'active','2025-08-16 04:37:59','2025-08-27 05:28:05'),(3,'Shortbow NON Pelajar Putri jarak 20m',0,1000,'Perempuan',16,'active','2025-08-16 04:37:59','2025-08-27 05:29:50'),(4,'Shortbow Pelajar Putra SD 1-3 jarak 5m',6,9,'Laki-laki',16,'active','2025-08-16 04:37:59','2025-08-27 05:30:02'),(5,'Shortbow Pelajar Putra SD 4-6 jarak 7m',10,12,'Laki-laki',32,'active','2025-08-16 04:37:59','2025-08-18 06:03:09'),(6,'Shortbow Pelajar Putra SMA jarak 15m',15,18,'Laki-laki',32,'active','2025-08-16 04:37:59','2025-08-27 05:30:12'),(7,'Shortbow Pelajar Putri SMA jarak 15m',15,18,'Perempuan',32,'active','2025-08-16 04:37:59','2025-08-27 05:30:21'),(8,'Shortbow Pelajar Putra SMP jarak 10m',12,15,'Laki-laki',32,'active','2025-08-16 04:37:59','2025-08-27 05:30:33'),(10,'Shortbow Pelajar Putri SD 1-3 jarak 5m',6,9,'Perempuan',16,'active','2025-08-16 04:48:56','2025-08-27 05:30:52'),(11,'Shortbow Pelajar Putri SD 4-6 jarak 7m',10,12,'Perempuan',16,'active','2025-08-16 04:48:56','2025-08-18 06:07:43'),(12,'Shortbow Pelajar Putri SMA jarak 10m',15,18,'Perempuan',16,'active','2025-08-16 04:48:56','2025-08-27 05:31:04'),(13,'Shortbow Pemula Putra jarak 3m',0,15,'Laki-laki',16,'active','2025-08-16 04:48:56','2025-12-08 08:19:17'),(14,'Shortbow Pemula Putri jarak 3m',4,6,'Perempuan',32,'active','2025-08-16 04:48:56','2025-08-27 05:31:37'),(36,'ppp',1,11,'Campuran',32,'active','2025-08-26 23:05:20','2025-08-26 23:05:20'),(37,'r',1,11,'Campuran',32,'active','2025-08-27 05:29:16','2025-08-27 05:29:16'),(38,'Shortbow Pelajar Putri SMP jarak 10m',12,15,'Campuran',32,'active','2025-08-28 08:31:05','2025-08-28 08:31:05'),(39,'Umum Putra 30 Meter',16,100,'Campuran',32,'active','2025-09-26 06:55:20','2025-09-26 06:55:20'),(40,'Umum Putri 20 Meter',10,100,'Campuran',32,'active','2025-09-26 06:56:32','2025-09-26 06:56:32'),(41,'50 Meter Dewasa',0,100,'Campuran',32,'active','2025-10-14 08:32:16','2025-10-14 08:32:16'),(42,'5 Meter Anak',0,10,'Campuran',32,'active','2025-10-14 08:33:30','2025-10-14 08:33:30'),(43,'7 Meter Anak',0,12,'Campuran',32,'active','2025-10-14 08:36:37','2025-10-14 08:36:37'),(44,'10 meter anak',0,15,'Campuran',32,'active','2025-10-14 08:36:49','2025-10-14 08:36:49'),(45,'15 Meter Anak',0,15,'Campuran',32,'active','2025-10-14 08:37:07','2025-10-14 08:37:07'),(46,'40 Meter',0,100,'Campuran',32,'active','2025-10-21 03:18:52','2025-10-21 03:18:52'),(47,'70 Meter',0,100,'Campuran',32,'active','2025-10-21 03:19:12','2025-10-21 03:19:12'),(48,'50 Meter',0,1000,'Campuran',32,'active','2025-12-03 03:36:12','2025-12-03 03:36:12'),(49,'Shortbow Pemula Putri jarak 3m',0,15,'Campuran',32,'active','2025-12-08 23:18:18','2025-12-08 23:18:18'),(51,'TES',0,40,'Laki-laki',0,'active','2026-01-08 01:54:21','2026-01-08 01:54:21'),(52,'10 Meter Putra',0,50,'Laki-laki',0,'active','2026-01-09 07:13:10','2026-01-09 07:13:10'),(53,'10 Meter Putri',0,50,'Perempuan',0,'active','2026-01-09 07:13:24','2026-01-09 07:13:24'),(54,'20 Meter Putra',0,99,'Laki-laki',0,'active','2026-01-09 07:15:54','2026-01-09 07:15:54'),(55,'20 Meter Putri',0,99,'Perempuan',0,'active','2026-01-09 07:16:06','2026-01-09 07:16:06'),(56,'30 Meter Putri',0,99,'Campuran',0,'active','2026-01-09 07:16:28','2026-01-09 07:16:28');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elimination_results`
--

DROP TABLE IF EXISTS `elimination_results`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elimination_results` (
  `id` int NOT NULL AUTO_INCREMENT,
  `match_id` int NOT NULL,
  `kegiatan_id` int NOT NULL,
  `category_id` int NOT NULL,
  `round_name` varchar(50) NOT NULL,
  `participant1_id` int NOT NULL,
  `participant2_id` int DEFAULT NULL,
  `winner_id` int DEFAULT NULL,
  `participant1_set1` int DEFAULT '0',
  `participant1_set2` int DEFAULT '0',
  `participant1_set3` int DEFAULT '0',
  `participant1_set4` int DEFAULT '0',
  `participant1_set5` int DEFAULT '0',
  `participant2_set1` int DEFAULT '0',
  `participant2_set2` int DEFAULT '0',
  `participant2_set3` int DEFAULT '0',
  `participant2_set4` int DEFAULT '0',
  `participant2_set5` int DEFAULT '0',
  `participant1_set_points` int DEFAULT '0',
  `participant2_set_points` int DEFAULT '0',
  `is_completed` tinyint DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_match` (`match_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `elimination_results`
--

LOCK TABLES `elimination_results` WRITE;
/*!40000 ALTER TABLE `elimination_results` DISABLE KEYS */;
/*!40000 ALTER TABLE `elimination_results` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kegiatan`
--

DROP TABLE IF EXISTS `kegiatan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kegiatan` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nama_kegiatan` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kegiatan`
--

LOCK TABLES `kegiatan` WRITE;
/*!40000 ALTER TABLE `kegiatan` DISABLE KEYS */;
INSERT INTO `kegiatan` VALUES (11,'Panahan 2025'),(12,'Latihan Bersama Internal '),(13,'Latihan Bersama1'),(14,'Latihan Setiap Minggu'),(16,'Latihan Bersama');
/*!40000 ALTER TABLE `kegiatan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kegiatan_kategori`
--

DROP TABLE IF EXISTS `kegiatan_kategori`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kegiatan_kategori` (
  `id` int NOT NULL AUTO_INCREMENT,
  `kegiatan_id` int NOT NULL,
  `category_id` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=186 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kegiatan_kategori`
--

LOCK TABLES `kegiatan_kategori` WRITE;
/*!40000 ALTER TABLE `kegiatan_kategori` DISABLE KEYS */;
INSERT INTO `kegiatan_kategori` VALUES (91,11,1),(92,11,2),(93,11,3),(94,11,13),(95,11,14),(96,11,4),(97,11,10),(98,11,5),(99,11,11),(100,11,8),(101,11,38),(102,11,6),(103,11,7),(104,11,12),(107,12,2),(108,12,3),(138,14,1),(139,14,47),(140,14,46),(141,14,45),(142,14,44),(143,14,43),(144,14,42),(145,14,48),(146,14,2),(147,14,3),(148,14,39),(149,11,1),(150,11,49),(151,11,13),(152,11,2),(153,11,3),(154,11,10),(155,11,4),(156,11,11),(157,11,5),(158,11,38),(159,11,8),(160,11,6),(161,11,7),(162,11,12),(173,16,52),(174,16,53),(175,16,54),(176,16,55),(177,16,56),(178,16,46),(179,16,48),(180,16,43),(181,16,47),(182,16,39),(183,13,3),(184,13,40),(185,13,39);
/*!40000 ALTER TABLE `kegiatan_kategori` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `match_results`
--

DROP TABLE IF EXISTS `match_results`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `match_results` (
  `id` int NOT NULL AUTO_INCREMENT,
  `match_id` int NOT NULL,
  `set_number` int DEFAULT NULL,
  `player1_score` int DEFAULT '0',
  `player2_score` int DEFAULT '0',
  `duration_minutes` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_general_ci,
  `winner_id` int NOT NULL,
  `loser_id` int DEFAULT NULL,
  `score1` int NOT NULL DEFAULT '0',
  `score2` int NOT NULL DEFAULT '0',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `match_results`
--

LOCK TABLES `match_results` WRITE;
/*!40000 ALTER TABLE `match_results` DISABLE KEYS */;
INSERT INTO `match_results` VALUES (1,4,NULL,0,0,NULL,NULL,18,19,4,1,'2025-10-02 01:23:16');
/*!40000 ALTER TABLE `match_results` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `matches`
--

DROP TABLE IF EXISTS `matches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `matches` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tournament_id` int NOT NULL,
  `category_id` int NOT NULL,
  `round_name` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `match_number` int NOT NULL,
  `player1_id` int DEFAULT NULL,
  `player2_id` int DEFAULT NULL,
  `winner_id` int DEFAULT NULL,
  `scheduled_time` datetime DEFAULT NULL,
  `actual_start_time` datetime DEFAULT NULL,
  `actual_end_time` datetime DEFAULT NULL,
  `court_venue` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` enum('scheduled','in_progress','completed','cancelled','bye') COLLATE utf8mb4_general_ci DEFAULT 'scheduled',
  `notes` text COLLATE utf8mb4_general_ci,
  `referee_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `matches`
--

LOCK TABLES `matches` WRITE;
/*!40000 ALTER TABLE `matches` DISABLE KEYS */;
INSERT INTO `matches` VALUES (1,1,10,'Round 1',1,2,NULL,NULL,'2025-09-01 09:30:00',NULL,NULL,'Court 2','scheduled',NULL,'Wasit B','2025-08-16 04:53:16','2025-08-16 04:53:16'),(2,1,11,'Round 1',1,3,NULL,NULL,'2025-09-01 10:00:00',NULL,NULL,'Court 1','scheduled',NULL,'Wasit A','2025-08-16 04:53:16','2025-08-16 04:53:16'),(3,1,12,'Round 1',1,4,NULL,NULL,'2025-09-01 10:30:00',NULL,NULL,'Court 2','scheduled',NULL,'Wasit B','2025-08-16 04:53:16','2025-08-16 04:53:16'),(4,1,13,'Round 1',1,5,NULL,NULL,'2025-09-01 11:00:00',NULL,NULL,'Court 1','scheduled',NULL,'Wasit C','2025-08-16 04:53:16','2025-08-16 04:53:16'),(5,1,14,'Round 1',1,NULL,NULL,NULL,'2025-09-01 11:30:00',NULL,NULL,'Court 2','scheduled',NULL,'Wasit C','2025-08-16 04:53:16','2025-08-16 04:53:16');
/*!40000 ALTER TABLE `matches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `participants`
--

DROP TABLE IF EXISTS `participants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `participants` (
  `id` int NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `birthdate` date NOT NULL,
  `gender` enum('Laki-laki','Perempuan') COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `address` text COLLATE utf8mb4_general_ci,
  `emergency_contact` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `emergency_phone` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` enum('active','inactive','banned') COLLATE utf8mb4_general_ci DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `participants`
--

LOCK TABLES `participants` WRITE;
/*!40000 ALTER TABLE `participants` DISABLE KEYS */;
INSERT INTO `participants` VALUES (1,'Ahmad Fauzi','2010-05-15','Laki-laki','ahmad.fauzi@email.com','08123456789',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(2,'Siti Nurhaliza','2011-08-20','Perempuan','siti.nurhaliza@email.com','08234567890',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(3,'Budi Santoso','2008-03-10','Laki-laki','budi.santoso@email.com','08345678901',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(4,'Dewi Sartika','2009-12-05','Perempuan','dewi.sartika@email.com','08456789012',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(5,'Rafi Ahmad','2006-07-18','Laki-laki','rafi.ahmad@email.com','08567890123',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(6,'Maya Putri','2007-11-25','Perempuan','maya.putri@email.com','08678901234',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(7,'Doni Pratama','1995-04-12','Laki-laki','doni.pratama@email.com','08789012345',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(9,'test','2025-08-08','Laki-laki','test@test.com','0812345','-','-','-',NULL,'active','2025-08-18 05:38:10','2025-08-18 05:38:10'),(1,'Ahmad Fauzi','2010-05-15','Laki-laki','ahmad.fauzi@email.com','08123456789',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(2,'Siti Nurhaliza','2011-08-20','Perempuan','siti.nurhaliza@email.com','08234567890',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(3,'Budi Santoso','2008-03-10','Laki-laki','budi.santoso@email.com','08345678901',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(4,'Dewi Sartika','2009-12-05','Perempuan','dewi.sartika@email.com','08456789012',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(5,'Rafi Ahmad','2006-07-18','Laki-laki','rafi.ahmad@email.com','08567890123',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(6,'Maya Putri','2007-11-25','Perempuan','maya.putri@email.com','08678901234',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(7,'Doni Pratama','1995-04-12','Laki-laki','doni.pratama@email.com','08789012345',NULL,NULL,NULL,NULL,'active','2025-08-16 04:53:15','2025-08-16 04:53:15'),(9,'test','2025-08-08','Laki-laki','test@test.com','0812345','-','-','-',NULL,'active','2025-08-18 05:38:10','2025-08-18 05:38:10');
/*!40000 ALTER TABLE `participants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `peserta`
--

DROP TABLE IF EXISTS `peserta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `peserta` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nama_peserta` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `tanggal_lahir` date DEFAULT NULL,
  `jenis_kelamin` enum('Laki-laki','Perempuan') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `asal_kota` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `nama_club` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sekolah` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `kelas` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `nomor_hp` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bukti_pembayaran` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `kegiatan_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_kg` (`kegiatan_id`)
) ENGINE=InnoDB AUTO_INCREMENT=674 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `peserta`
--

LOCK TABLES `peserta` WRITE;
/*!40000 ALTER TABLE `peserta` DISABLE KEYS */;
INSERT INTO `peserta` VALUES (9,'jihan','2013-02-05','Perempuan','Samarinda','Airlangga Club','Airlangga','9','0874445778686',NULL,38,9,'2026-01-12 05:51:32','2026-01-12 05:51:32'),(14,'Elsa','2008-01-02','Perempuan','Purwakarta','Panther Archery','SMK 11','12','0816213719','20250902071355_68b69933a6e26.png',3,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(15,'abu zikri','2005-06-07','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','08152812168','20250903083406_68b7fd7e4f22f.jpeg',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(16,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','20250903083731_68b7fe4b440b9.png',2,11,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(17,'siko','2005-06-12','Laki-laki','Samarinda','independent','-','-','0865464563635','20250903083937_68b7fec9efa12.png',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(18,'Achmed FS','2003-03-20','Laki-laki','Samarinda','Dhiya Rabbany Archery Mu\'Minin Kalimantan','-','-','08231331344','20250903084107_68b7ff23c1bc0.png',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(20,'Andhi Trisnaputra','2004-12-27','Laki-laki','Samarinda','NFH ARCHERY','-','-','08168137181','20250903084421_68b7ffe52a1e2.png',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(21,'Pandhu Dhitya AA','2003-12-28','Laki-laki','Samarinda','Fakarchery','-','-','0816813618','20250903084712_68b800908a6c1.png',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(22,'Didin Wahyudin','2006-01-30','Laki-laki','Samarinda','Didin Wahyudin','-','-','08121318113','20250903084819_68b800d3c6ffa.png',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(23,'Selviansyah','2003-12-28','Laki-laki','Samarinda','Perdana kaltim','-','-','08816311391','20250903085020_68b8014c33491.png',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(24,'Muhammad Arkhan Khalfani','2020-01-04','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','08121836113','20250904010824_68b8e6882dc66.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(25,'Ukkasyah','2020-01-04','Laki-laki','Samarinda','FAKARCHERY','-','-','081213781813','20250904010929_68b8e6c9079c0.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(26,'Muhammad Taqiyuddin Abdillah El-Haq','2020-01-28','Laki-laki','Bontang','Al Izzah Archery','-','-','08162183611','20250904011042_68b8e71289bc5.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(27,'Rifqi Muhammad Hamasi','2020-03-05','Laki-laki','Samarinda','FAKARCHERY','-','-','08713161134','20250904011147_68b8e753124a6.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(28,'Habibi Muhammad Al Fatih','2020-03-04','Laki-laki','Samarinda','Cakrawala Kaki Langit Archery','-','-','081868813741','20250904011403_68b8e7db458ab.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(29,'Muhammad Abdullah','2020-07-08','Laki-laki','Kutai Kartanegara','Ibadurrahaman Archery Club','-','-','0818319713','20250904011453_68b8e80de6c45.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(30,'Zahid Hamizan Rabbani','2020-01-29','Laki-laki','Samarinda','Cakrawala Kaki Langit Archery','-','-','081368163817','20250904011536_68b8e838e770a.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(32,'Muammar Bilal Ibrahim','2020-02-03','Laki-laki','Samarinda','FAKARCHERY','-','-','08813816381','20250904011827_68b8e8e343202.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(33,'Muhammad fahri','2020-02-04','Laki-laki','Samarinda','Tunas harapan archery club','-','-','0871638171','20250904011913_68b8e911d6c4e.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(34,'Uwais Hanif Ibrahim','2020-07-08','Laki-laki','Samarinda','FAKARCHERY','-','-','08613617131','20250904012000_68b8e94006cbb.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(35,'Muhammad Sayyid Musyaffa','2020-07-08','Laki-laki','Samarinda','Tunas harapan archery club','-','-','0981831871','20250904012246_68b8e9e69b0b5.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(36,'Khalif Abdurrahman','2020-01-29','Laki-laki','Samarinda','FAKARCHERY','-','-','08813618731','20250904012426_68b8ea4ab7a72.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(37,'Muhammad Rayandra Putra Pratama','2019-02-12','Laki-laki','Samarinda','Tunas harapan archery club','-','-','0817318631','20250904012639_68b8eacf6011d.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(38,'MUHAMMAD AIDIL SAPUTRARANI','2020-07-08','Laki-laki','Samarinda','NFH ARCHERY','-','-','0817368813','20250904012724_68b8eafcb380d.png',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(39,'Annisa Shafa Hendriawanti','2020-02-04','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','08137197391','20250904012943_68b8eb872bff1.png',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(40,'Maudy Aulia Azzahra','2020-01-28','Perempuan','Samarinda','FAKARCHERY','-','-','08183183191','20250904013033_68b8ebb946547.png',1,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(41,'Dzakiyyah shofiy','2020-10-13','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','081381711314','20250904013129_68b8ebf1db128.png',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(42,'Farzana Qiana','2019-02-05','Perempuan','Samarinda','FAKARCHERY','-','-','08183619713','20250904013335_68b8ec6fbf904.png',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(43,'Halimatussa\'diah','2020-06-09','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','08183619731','20250904013436_68b8ecac4228f.png',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(44,'Bilqis Azizah Azzahra','2019-01-29','Perempuan','Samarinda','FAKARCHERY','-','-','08131971937','20250904014646_68b8ef86db990.jpeg',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(45,'Hafizah Adiibah','2018-01-02','Perempuan','Samarinda','Al Azhar Archery','-','-','089970876537','20250904015203_68b8f0c39c12e.jpeg',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(46,'Yunia Sharawy Saputrarani','2019-06-29','Perempuan','Samarinda','NFH ARCHERY','-','-','083877895232','20250904015528_68b8f190cbe06.jpeg',1,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(47,'Rayta Havva Huri Hayyuna','2020-06-24','Perempuan','Samarinda','Cakrawala Kaki Langit Archery','-','-','083877563241','20250904015822_68b8f23ea34a0.jpeg',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(48,'Delisha Almahyra','2019-08-14','Perempuan','Penajam','Prabu Archery','-','-','083812512188','20250904020038_68b8f2c69a370.jpeg',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(49,'Maryam Farzana Arrahman','2020-10-13','Perempuan','Samarinda','Cakrawala Kaki Langit Archery','-','-','0813719713','20250904022357_68b8f83d8f9ee.png',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(50,'Daisha Arsyila','2019-03-06','Perempuan','Penajam','Prahu Archery','-','-','08135173141','20250904025007_68b8fe5fbac91.png',1,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(51,'Alifa Putri Zhafirah Dirgahayu','2019-11-20','Perempuan','Samarinda','Cakrawala Kaki Langit Archery','-','-','081638168179','20250904025058_68b8fe9244644.png',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(52,'Khairunnisa nur Aprilia','2020-02-04','Perempuan','Samarinda','Rantau Archery','-','-','08193719317','20250904025213_68b8fedde0167.png',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(53,'Raline Mecca El Jasmine','2020-01-28','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','08761639179','20250904025316_68b8ff1c6d978.png',14,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(54,'Muhammad Al Abbasy Langit Firdaus','2016-03-17','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','0884616139','20250904025910_68b9007eb6225.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(55,'Musa','2016-06-07','Laki-laki','Muara Barak','Al-Muhajirin Archery Club','-','-','0871063193','20250904030032_68b900d07e678.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(56,'Faidhan Audisepta djatmiko','2016-03-09','Laki-laki','Samarinda','Khidir Archery Club','-','-','08916819194','20250904030119_68b900ffe5b4d.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(57,'Muhammad Daffa Ibnu Hafidz','2016-06-08','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','08715236186','20250904030234_68b9014a721b7.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(58,'Muhammad Atid Abidzar','2016-03-09','Laki-laki','Muara Barak','Al-Muhajirin Archery Club','-','-','0864183618','20250904030743_68b9027f0eb98.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(59,'Masdavi Fairel Aldebaran','2016-02-09','Laki-laki','Samarinda','MIN 2 Samarinda','-','-','081636139','20250904031033_68b903292345e.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(60,'Adlan Bilal Habibie','2016-02-09','Laki-laki','Samarinda','Al - Azhar Archery','-','-','0816248168','20250904031135_68b90367531b7.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(61,'ADLAN BILAL HABIBIE','2018-02-20','Laki-laki','Samarinda','Al - Azhar Archery','-','-','089912817111','20250904032504_68b90690849ee.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(62,'Muhammad Izat Nabhan','2016-03-09','Laki-laki','Muara Badak','Al-Muhajirin Archery Club','-','-','0877121113111','20250904032623_68b906df9ed06.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(63,'Mohammad Hasbillah','2016-10-27','Laki-laki','Balikpapan','Minu Archery','-','-','083613671361','20250904032717_68b907155cb4b.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(64,'Arsakha Aurellio Shakeel','2016-12-15','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','083165361521','20250904032929_68b907996f07c.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(65,'Atharizz Calief Abdillah','2016-04-07','Laki-laki','Samarinda','Ar Rajwa Archery Club','-','-','08413131313','20250904033026_68b907d2f0f24.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(66,'Sayyid Yusuf Halim','2016-12-08','Laki-laki','Balikpapan','Minu Archery','-','-','0864743554678','20250904033137_68b90819a62d1.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(67,'Nuzul Repandi','2016-07-28','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','08267251762','20250904033255_68b90867a5da4.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(68,'Fayyadh Hanifur Rahman','2016-02-11','Laki-laki','Samarinda','Ar Rajwa Archery Club','-','-','0867138171','20250904064330_68b93512b0cfd.png',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(69,'Edwin','2008-06-08','Laki-laki','Samarinda','Airlangga Club','-','-','08168163198','20250908035928_68be54a08ed02.png',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(70,'jijah','2008-11-03','Perempuan','Samarinda','Pova Archery','SMK 11 Samarinda','XII TKJ','08178614141','20250908060803_68be72c3e960f.png',1,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(71,'Purnomo','2000-06-12','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0899193193','20250925075446_68d4f546277c3.jpeg',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(72,'Gusti','1993-08-19','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0889623729','20250925075523_68d4f56be8dc0.jpeg',2,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(74,'Syam','2025-09-02','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','20250925075620_68d4f5a4a0dee.jpeg',2,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(75,'Mas Sakur','2025-09-17','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','20250925075657_68d4f5c953d38.jpeg',2,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(76,'Aldi','2025-09-10','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','20250925075742_68d4f5f68e4ce.jpeg',2,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(77,'Burhanuddin','2024-02-28','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0821128311','20250925075817_68d4f61922eb2.jpeg',2,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(78,'Muhammad Rosyid Fadhilah','2013-09-07','Laki-laki','Samarinda','Gold Archery Samarinda','Pondok Abu Bakar','-','08565280359','20250925075857_68d4f64192a10.jpeg',2,12,'2026-01-08 08:40:35','2026-01-12 02:41:01'),(79,'Pak Tontro','2025-02-05','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812345161','20250925075932_68d4f6641b6e3.jpeg',2,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(80,'Syarifuddin','1970-12-30','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','082320040021','20250925080003_68d4f683a9c83.jpeg',2,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(81,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','20250925080033_68d4f6a15675d.jpeg',2,12,'2026-01-08 08:40:35','2026-01-08 14:54:28'),(82,'Ngaisah','2025-03-06','Perempuan','Samarinda','Gold Archery Samarinda','-','-','0821128311','20250925080125_68d4f6d53f218.jpeg',3,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(83,'Rina','2024-06-04','Perempuan','Samarinda','Gold Archery Samarinda','-','-','0821128311','20250925080202_68d4f6faa876c.jpeg',3,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(84,'Rina','2025-09-11','Perempuan','Samarinda','Gold Archery Samarinda','-','-','0899193193','20250925080225_68d4f71127a11.jpeg',3,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(85,'Fitri','2025-02-04','Perempuan','Samarinda','Gold Archery Samarinda','-','-','0812334411','20250925080307_68d4f73bddd55.jpeg',3,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(86,'Mila','2022-03-09','Perempuan','Samarinda','Gold Archery Samarinda','-','-','08771219211','20250925080347_68d4f76324674.jpeg',3,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(87,'Widya','2025-09-03','Perempuan','Samarinda','Gold Archery Samarinda','-','-','0812345161','20250925080419_68d4f783a6f27.jpeg',3,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(88,'Wida','2025-09-04','Perempuan','Samarinda','Gold Archery Samarinda','-','-','08123456789','20250925080447_68d4f79f41067.jpeg',3,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(89,'Zulfa','2025-09-18','Perempuan','Samarinda','Gold Archery Samarinda','-','-','08123456789','20250925080518_68d4f7bee21d2.jpeg',3,12,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(90,'Syam','2025-09-02','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','20251012221319_68ec27ff5be59.png',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(95,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','',2,12,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(96,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','',1,11,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(97,'Rudi','1988-05-26','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08123456780','',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(98,'Tontro','2000-05-26','Laki-laki','asdawdsd','awdasdasd','adawdsdas','wqsda2ws','08123456780','',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(99,'Udin','2000-05-26','Laki-laki','asdawdsd','awdasdasd','adawdsdas','wqsda2ws','08123456780','',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(101,'Alam','1980-05-26','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08123456780','20250926084336_68d652387e6e8.jpg',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(102,'Romi','1996-11-23','Laki-laki','Sama','Gold Archery Samarinda','','','08521516484','20250926084420_68d6526499241.jpg',39,13,'2026-01-08 08:40:35','2026-01-09 08:08:43'),(104,'Annas Muta Arif','1988-12-21','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','+62 853-4559-9937','20250926084607_68d652cfcbb01.jpg',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(105,'Ryo','2000-05-26','Laki-laki','asdawdsd','awdasdasd','adawdsdas','wqsda2ws','08123456780','20250926084639_68d652ef2d0c3.jpg',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(106,'Moktar','2000-05-26','Laki-laki','asdawdsd','awdasdasd','adawdsdas','wqsda2ws','08123456780','20250926084724_68d6531c0ad7f.jpg',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(114,'Wilda','2000-05-26','Perempuan','asdawdsd','awdasdasd','adawdsdas','wqsda2ws','08123456780','20250926085225_68d65449b0e10.jpg',40,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(119,'Iskandar','1981-09-28','Laki-laki','Samarinda','Basilica','-','-','','',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(120,'Syahril','2000-09-28',NULL,NULL,NULL,NULL,NULL,NULL,'',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(121,'Helva','2000-01-01',NULL,NULL,NULL,NULL,NULL,NULL,'',40,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(122,'Purnomo','2000-06-12','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0899193193','',39,13,'2026-01-08 08:40:35','2026-01-09 08:09:13'),(123,'Nisa','2000-09-28',NULL,NULL,NULL,NULL,NULL,NULL,'',40,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(124,'Imam','1989-09-28','Laki-laki','Samarinda','Basilica','-','-','','',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(125,'Mus','2000-09-28',NULL,NULL,NULL,NULL,NULL,NULL,'',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(126,'Abdullah','1983-09-28','Laki-laki','Samarinda','Basilica','-','-','','',39,13,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(127,'Sania','2000-01-22','Perempuan','','Gold Archery Samarinda','','','08132341231','',40,13,'2026-01-08 08:40:35','2026-01-09 08:09:34'),(128,'Abdan Khairu tsabit','2013-02-05','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','1 SMP','085332603769','',44,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(132,'Faith RIzky Naufal .A','2013-07-05','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','-','085332603769','',43,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(133,'Muhammad Labib Haidar','2014-07-04','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','-','085247460860','',43,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(134,'Muhammad Rosyid Fadhilah','2013-09-07','Laki-laki','Samarinda','Gold Archery Samarinda','Pondok Abu Bakar','-','08565280359','',44,14,'2026-01-08 08:40:35','2026-01-12 02:41:01'),(135,'Muhammad Rosyid Fadhilah','2013-09-07','Laki-laki','Samarinda','Gold Archery Samarinda','Pondok Abu Bakar','-','08565280359','',45,14,'2026-01-08 08:40:35','2026-01-12 02:41:01'),(136,'Tsabita Rumaisha Assariy','2015-05-12','Perempuan','Samarinda','Gold Archery Samarinda','-','-','85654277634','',42,14,'2026-01-08 08:40:35','2026-01-12 05:39:41'),(137,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','',1,14,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(138,'Suci Ashari Ambarwati','2014-07-13','Perempuan','Samarinda','Gold Archery Samarinda','SD Islam Bunga Bangsa','5','82157111329','',43,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(139,'Hanum Salsabila Murti','2017-03-26','Perempuan','Samarinda','Gold Archery Samarinda','SD Islam Bunga Bangsa','2 SD','082157111329','',42,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(140,'Nur Syifa Fahmi','2013-11-10','Perempuan','Samarinda','Gold Archery Samarinda','SD Normal Islam','6','85654277634','',43,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(141,'Faidha Zharufa Arisha Sumantri','2014-09-17','Perempuan','Samarinda','Gold Archery Samarinda','SDI Bunga Bangsa','5','081328881895','',43,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(142,'Naifa Aisyah Nerdha Sumantri','2016-01-12','Perempuan','Samarinda','Gold Archery Samarinda','SDI Bunga Bangsa','3','081328881895','',42,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(143,'Auna Asy Syifa Syakur','2016-02-01','Perempuan','Samarinda','Gold Archery Samarinda','Baitul Izah','3','085654277634','',42,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(144,'Syailendra Adma Wijaya','2013-05-11','Laki-laki','Samarinda','Gold Archery Samarinda','MTS Normal Islam Samarinda','','08115926697','',43,14,'2026-01-08 08:40:35','2026-01-12 02:30:56'),(145,'Fitri Khairiah','1997-10-14','Perempuan','Samarinda','Gold Archery Samarinda','-','-','08115823381','',3,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(147,'Purwanto Ketua GAS','1981-01-19','Laki-laki','Samarinda','Gold Archery Samarinda','Sekolah Rakyat','-','08125372066','',1,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(148,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(149,'Zainal','1980-06-10','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','082320040021','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(150,'Zainal','1980-06-10','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','082320040021','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(151,'Zainal','1980-06-10','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','082320040021','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(152,'Zainal','1980-06-10','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','082320040021','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(153,'Purwanto Ketua GAS','1981-01-19','Laki-laki','Samarinda','Gold Archery Samarinda','Sekolah Rakyat','-','08125372066','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(154,'Purwanto Ketua GAS','1981-01-19','Laki-laki','Samarinda','Gold Archery Samarinda','Sekolah Rakyat','-','08125372066','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(155,'Purwanto Ketua GAS','1981-01-19','Laki-laki','Samarinda','Gold Archery Samarinda','Sekolah Rakyat','-','08125372066','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(156,'Purwanto Ketua GAS','1981-01-19','Laki-laki','Samarinda','Gold Archery Samarinda','Sekolah Rakyat','-','08125372066','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(157,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','',46,14,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(158,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','',47,14,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(159,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','',2,14,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(160,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','',39,14,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(161,'Abu Syamil','1988-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(162,'Abu Syamil','1988-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(163,'Abu Syamil','1988-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(164,'Abu Syamil','1988-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(165,'Abdullah','1982-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(166,'Abdullah','1982-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(167,'Abdullah','1982-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(168,'Abdullah','1982-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(169,'Daeng Syahril','1980-12-12','Laki-laki','Anggana','Basilica','-','-','082320040021','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(170,'Daeng Syahril','1980-12-12','Laki-laki','Anggana','Basilica','-','-','082320040021','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(171,'Daeng Syahril','1980-12-12','Laki-laki','Anggana','Basilica','-','-','082320040021','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(172,'Daeng Syahril','1980-12-12','Laki-laki','Anggana','Basilica','-','-','082320040021','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(173,'Iskandar','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(174,'Iskandar','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(175,'Iskandar','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(176,'Iskandar','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(177,'Mustaid','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(178,'Mustaid','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(179,'Mustaid','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(180,'Mustaid','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(181,'Imam','1988-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(182,'Imam','1988-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(183,'Imam','1988-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(184,'Imam','1988-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(185,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','',46,14,'2026-01-08 08:40:35','2026-01-08 14:54:28'),(186,'Burhanuddin','2024-02-28','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0821128311','',46,14,'2026-01-08 08:40:35','2026-01-08 14:55:36'),(187,'Rudi','1988-05-26','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08123456780','',46,14,'2026-01-08 08:40:35','2026-01-09 08:08:11'),(188,'Gusti','1993-08-19','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0889623729','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(189,'Alam','1980-10-16','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(190,'Syam','2025-09-02','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(191,'Aldi','2025-09-10','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(192,'Romi','1996-11-23','Laki-laki','Sama','Gold Archery Samarinda','','','08521516484','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(193,'Romi','1996-11-23','Laki-laki','Sama','Gold Archery Samarinda','','','08521516484','',47,14,'2026-01-08 08:40:35','2026-01-09 08:08:43'),(194,'Kang Zain','1995-10-17','Laki-laki','Samarinda','Zain Archery','-','-','0818313719','20251201022159_692cfbc77225c.png',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(195,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','20251203033900_692fb0d4d1f7b.jpg',48,14,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(196,'Abdullah','1982-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','20251203034023_692fb127ee133.jpg',48,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(197,'Aldi','2025-09-10','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','20251203034113_692fb15951fc6.jpg',48,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(198,'Rudi','1988-05-26','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08123456780','20251203034204_692fb18cd862c.jpg',48,14,'2026-01-08 08:40:35','2026-01-09 08:08:11'),(199,'Daeng Syahril','1980-12-12','Laki-laki','Anggana','Basilica','-','-','082320040021','20251203034235_692fb1ab00b16.jpg',48,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(200,'Iskandar','1980-12-12','Laki-laki','Samarinda','Basilica','-','-','082320040021','20251203035606_692fb4d63c187.jpg',48,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(201,'Sukri','1982-12-06','Laki-laki','Samarinda','Basilica','J','J','08546454248445','',46,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(202,'Sukri','1982-12-06','Laki-laki','Samarinda','Basilica','J','J','08546454248445','',48,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(203,'Sukri','1982-12-06','Laki-laki','Samarinda','Basilica','J','J','08546454248445','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(204,'Sukri','1982-12-06','Laki-laki','Samarinda','Basilica','J','J','08546454248445','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(205,'Sukri','1982-12-06','Laki-laki','Samarinda','Basilica','J','J','08546454248445','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(206,'Alam','1980-10-16','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','',48,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(207,'Alam','1980-10-16','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','',47,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(208,'Alam','1980-10-16','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','',2,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(209,'Alam','1980-10-16','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0812334411','',39,14,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(210,'Arshaka Ayman Zaid Saswanto','2018-07-06','Laki-laki','Samarinda','Rumah Belajar Archery Club','Tk Islam Nurul Huda','B besar','085332439909','20251208081635_693689632caef.jpg',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(212,'Muhammad Zeeshan Almahdi','2019-06-11','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','8791739181','20251208215600_69374970e3398.jpg',13,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(213,'Halimatussa\'diah','2020-06-09','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','08183619731','20251208231902_69375ce69745b.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(214,'Yunia Sharawy Saputrarani','2019-06-29','Perempuan','Samarinda','NFH ARCHERY','-','-','083877895232','20251208231936_69375d085e804.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(215,'Dzakiyyah shofiy','2020-10-13','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','081381711314','20251208232018_69375d3290c6b.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(216,'Raline Mecca El Jasmine','2020-01-28','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','08761639179','20251208232049_69375d5157ace.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(217,'Daisha Arsyila','2019-03-06','Perempuan','Penajam','Prahu Archery','-','-','08135173141','20251208232144_69375d8817530.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(218,'Maudy Aulia Azzahra','2020-01-28','Perempuan','Samarinda','FAKARCHERY','-','-','08183183191','20251208232329_69375df1778a8.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(219,'Adiva','2018-02-21','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','082934239','20251209011114_69377732f1077.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(220,'Hafizah Adiibah','2018-01-02','Perempuan','Samarinda','Al Azhar Archery','-','-','089970876537','20251209011145_6937775100b4f.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(221,'Khairunnisa nur Aprilia','2020-02-04','Perempuan','Samarinda','Rantau Archery','-','-','08193719317','20251209011215_6937776f9f0f5.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(222,'Alifa Putri Zhafirah Dirgahayu','2019-11-20','Perempuan','Samarinda','Cakrawala Kaki Langit Archery','-','-','081638168179','20251209011246_6937778e7253b.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(223,'Bilqis Azizah Azzahra','2019-01-29','Perempuan','Samarinda','FAKARCHERY','-','-','08131971937','20251209011315_693777abae915.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(224,'Farzana Qiana','2019-02-05','Perempuan','Samarinda','FAKARCHERY','-','-','08183619713','20251209011353_693777d1b91cb.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(225,'Delisha Almahrya','2019-07-17','Perempuan','Samarinda','Prahu Archery','-','-','081702810','20251209011612_6937785c07fae.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(226,'Annisa Shafa Hendriawanti','2020-02-04','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','08137197391','20251209011646_6937787ee836e.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(227,'Rayta Havva Huri Hayyuna','2020-06-24','Perempuan','Samarinda','Cakrawala Kaki Langit Archery','-','-','083877563241','20251209011705_6937789173221.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(228,'Maryam Farzana Arrahman','2020-10-13','Perempuan','Samarinda','Cakrawala Kaki Langit Archery','-','-','0813719713','20251209011737_693778b11303e.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(229,'Affiya Tsabita Ahnaf','2016-04-09','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','82154901336','20251209012441_69377a59570de.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(230,'Maryam','2017-08-27','Perempuan','Kutai Kartanegara','Ibadurrahaman Archery Club','-','-','81347227521','20251209012626_69377ac2d92ba.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(231,'Alisbha Sabiya Adeeva Fatiha Humaira','2016-11-24','Perempuan','Samarinda','NFH ARCHERY','-','-','82159495812','20251209013022_69377baede219.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(232,'Arsyila Fatimah','2016-03-04','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','85246790560','20251209013217_69377c218630f.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(233,'Shafiyyah Putri Satria','2017-03-06','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','81254770009','20251209014612_69377f6412672.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(234,'Azkiya Qaireen Elmulyanto','2017-03-04','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251209015533_6937819511023.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(235,'Zaskia Khaira H','2017-01-19','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209015818_6937823a39e8b.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(236,'Nauri Salsabila','2016-04-06','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209020020_693782b426085.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(237,'Fella Qaireen','2016-08-19','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','8156577076','20251209020200_69378318019b5.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(238,'Ranasya Najma Oktarianti','2016-10-25','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','81254061569','20251209020420_693783a4f3465.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(239,'Tsabita Rumaisha Assariy','2015-05-12','Perempuan','Samarinda','Gold Archery Samarinda','-','-','85654277634','',10,11,'2026-01-08 08:40:35','2026-01-12 07:09:52'),(240,'Halimatussa\'diah','2020-06-09','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','08183619731','',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(241,'TItih Nurul Hasanah','2017-01-08','Perempuan','Penajam','Al Muzammil Archery','-','-','81254666555','20251209021409_693785f196ca9.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(242,'Adeeva Aqila Nahdmi','2017-07-06','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','85251818552','20251209062518_6937c0ce052f8.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(243,'Auren Adonia Inonu','2016-05-11','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','81258021389','20251209062654_6937c12ecb550.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(244,'Adzkiya Shakila Shareen','2017-02-01','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','81348512242','20251209062944_6937c1d8f04fe.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(245,'Khansa Maisarah Kurniawan','2017-05-06','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','81350204555','20251209063131_6937c243e493a.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(246,'Azrina Gazala Falihah','2016-08-30','Perempuan','Sangata Utara','Al Azzam Rimayah Club','-','-','85252486687','20251209063532_6937c334bb45e.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(247,'Raisha Fakhira Ahmad','2016-03-17','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251209063737_6937c3b1de50e.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(248,'Daisha Arsyila','2019-03-06','Perempuan','Penajam','Prahu Archery','-','-','08135173141','20251209063813_6937c3d5cb5fa.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(249,'Zaskia Aqila Zahra','2016-10-28','Perempuan','Bontang','Al Izzah Archery','-','-','82153592169','20251209063927_6937c41feca80.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(250,'Aqila Putri Karunia Rasti','2016-11-11','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251209064213_6937c4c5ed921.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(251,'Raesha Azzahra Qianti Shanum','2018-04-24','Perempuan','Penajam','Al Muzammil Archery','-','-','81254666555','20251209064356_6937c52c3e55c.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(252,'Windriya Tiara Ayudia','2016-03-25','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209064800_6937c62004d5a.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(253,'Zhafirah Ramadhani','2016-06-19','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209064913_6937c66979249.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(254,'Bunga Amelia Putri','2016-04-26','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251209065103_6937c6d7333cb.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(255,'Hanum Salsabila Murti','2017-03-26','Perempuan','Samarinda','Gold Archery Samarinda','SD Islam Bunga Bangsa','2 SD','082157111329','20251209065152_6937c7086856a.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(256,'Auna Asy Syifa Syakur','2016-02-01','Perempuan','Samarinda','Gold Archery Samarinda','Baitul Izah','3','085654277634','20251209065258_6937c74a6df37.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(257,'Qheyla Syabilla','2016-04-23','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','8991223698','20251209065513_6937c7d1409bf.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(258,'Aisyah Qotrunnada','2017-07-03','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209065844_6937c8a44b588.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(259,'Dzakiyyah shofiy','2020-10-13','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','081381711314','20251209065933_6937c8d5593b6.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(260,'Sheza Raiqa Adlia','2017-01-08','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251209070159_6937c96717afd.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(261,'Atifa Naura Mahira','2017-12-17','Perempuan','Muara Badak','Al-Muhajirin Archery Club','-','-','085248820062','20251209070636_6937ca7c7a1ab.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(262,'Alisyah Bilqis Sakhi','2016-07-25','Perempuan','Penajam','Al Muzammil Archery','-','-','81254666555','20251209071157_6937cbbd71faf.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(263,'Assyifa Nur Tazkiyah','2016-12-06','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','81368997543','20251209071409_6937cc41d291a.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(264,'Khumaira Putri Defalin','2017-07-17','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209071801_6937cd2938b60.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(265,'Shafiyyah Ibtisamah Alifah','2016-11-21','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209072003_6937cda35ff49.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(266,'Naifa Aisyah Nerdha Sumantri','2016-01-12','Perempuan','Samarinda','Gold Archery Samarinda','SDI Bunga Bangsa','3','081328881895','20251209072154_6937ce12087a9.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(267,'Shakila Khairina Adha','2017-01-09','Perempuan','Penajam','Prahu Archery','-','-','81254666555','20251209072843_6937cfab3b898.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(268,'Medina Nur Syahidah','2016-04-10','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','81258055534','20251209081952_6937dba87dd3d.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(269,'Medina Humaira Azzahra','2018-02-13','Perempuan','Samarinda','Fakarchery','-','-','81258008408','20251209082143_6937dc1738e00.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(270,'Haiga Sophia Az Zahra','2017-11-07','Perempuan','Samarinda','Fakarchery','-','-','85250814219','20251209082306_6937dc6a92ad5.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(271,'Yumma Fariha Husniyah','2015-12-14','Perempuan','Samarinda','sdit Ar Risallah','-','-','81345075486','20251209082502_6937dcde50829.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(272,'Nabilah Shakilah Arsyad','2016-03-23','Perempuan','Penajam','Al Muzammil Archery','-','-','81254666555','20251209082629_6937dd35ec380.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(273,'Myesha Mufidah Abulatif Yahya','2014-05-05','Perempuan','Samarinda','Khidir Archery Club','-','-','82346855111','20251209082901_6937ddcd91e28.jpg',49,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(275,'Alesha Kylieluna','2017-07-08','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209083431_6937df17e2457.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(276,'Hafizah Adiibah','2018-01-02','Perempuan','Samarinda','Al Azhar Archery','-','-','089970876537','20251209083613_6937df7d5e92c.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(277,'Alivna Hilya Zia','2018-09-20','Perempuan','Samarinda','SD Muhammadiyah 3 Samarinda','-','-','85250506920','20251209083919_6937e0376006f.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(278,'Azkayra Zulaikha Afsheen','2019-04-25','Perempuan','Balikpapan','Ma\'rifah Archery','-','-','81802770334','20251209084331_6937e13311744.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(279,'Shafiyyah Izzatul Wafa','2017-07-13','Perempuan','Samarinda','SAS','-','-','081623161','20251209085058_6937e2f268ec0.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(280,'Asiyah Rania A','2017-02-20','Perempuan','Bontang','Al Izzah Archery','-','-','82220090101','20251209085306_6937e372d2e84.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(281,'Aerilyn Bilvania Cintakirana','2018-05-23','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251209112907_69380803bd4ec.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(282,'Enni Firahmatin Wibisono','2018-01-21','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251209113019_6938084b8d4ff.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(283,'Kanaya Nur Ashila','2017-03-22','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209113304_693808f00eb0c.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(284,'Anisa Ghina Shakirah','2018-05-01','Perempuan','Penajam','Al Muzammil Archery','-','-','81254666555','20251209113452_6938095ce8dda.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(285,'Nusyaibah Bahira','2018-12-09','Perempuan','Bontang','Al Izzah Archery','-','-','81347370384','20251209113634_693809c25971f.jpg',10,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(286,'Affiya Tsabita Ahnaf','2016-04-09','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','82154901336','20251209115725_69380ea59082f.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(287,'Lutfi Waibah Putri Lupita','2014-08-05','Perempuan','Bontang','Waqqash Archery Bontang','-','-','82149896949','20251209120132_69380f9c0d20c.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(288,'Denayu Kheiza Ashila Nur Arief','2014-05-20','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251209120449_69381061a43f5.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(289,'Syakira Faiha Ahmad','2014-05-11','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251209120724_693810fc0e2da.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(290,'Shakeela Putri Satria','2014-08-24','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','81254770009','20251209120940_69381184b6200.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(291,'Aisyah Afiqna Nur Hidayad','2012-03-29','Perempuan','Samarinda','NFH ARCHERY','-','-','82159495812','20251209121138_693811facc109.jpg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(292,'N Aulia S','2013-12-13','Perempuan','Samarinda','independent','-','-','8972272700','20251209121304_693812502e401.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(293,'Alisbha Sabiya Adeeva Fatiha Humaira','2016-11-24','Perempuan','Samarinda','NFH ARCHERY','-','-','82159495812','20251209121419_6938129baf544.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(294,'Muhammad Ridwan','2016-12-06','Laki-laki','Samarinda','NFH ARCHERY','-','-','82159495812','20251209124832_69381aa0422bf.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(295,'Nasya Aqila Anindya','2013-10-30','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251209222700_6938a23487d83.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(296,'Alfina Azzahra','2015-07-13','Perempuan','Samarinda','Fakarchery','-','-','82156338712','20251209224809_6938a729a2025.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(297,'Medhina Levana AA','2015-10-22','Perempuan','Samarinda','Fakarchery','-','-','85250067139','20251209224944_6938a788d563f.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(298,'Anindita Keisha Zahra','2015-07-06','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251209225117_6938a7e57c8f4.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(299,'Arsyila Fatimah','2016-03-04','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','85246790560','20251209225221_6938a825c9ae3.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(300,'Nas Alika Ilmi Kaisara','2013-07-31','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','82244190549','20251209225414_6938a8962f659.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(301,'Devanya Zakiyah Adlia','2015-06-01','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251209225533_6938a8e5a8478.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(302,'Azkiya Qaireen Elmulyanto','2017-03-04','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251209225743_6938a9676e96a.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(303,'Nawalia Mayza','2014-05-22','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','85349496768','20251209225847_6938a9a7e2c17.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(304,'Nur Syifa Fahmi','2013-11-10','Perempuan','Samarinda','Gold Archery Samarinda','SD Normal Islam','6','85654277634','20251209230028_6938aa0c0de36.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(305,'Maryam','2017-08-27','Perempuan','Kutai Kartanegara','Ibadurrahaman Archery Club','-','-','81347227521','20251209230115_6938aa3b9533c.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(306,'Rabiatul Nurjannah','2014-09-03','Perempuan','Samarinda','NFH ARCHERY','-','-','82159495812','20251209230252_6938aa9c3d6be.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(307,'Nursyifa Zakiyya Puspandari','2013-10-22','Perempuan','Balikpapan','Ma\'rifah Archery','-','-','81802770334','20251209230407_6938aae7cca6f.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(308,'Mecca Lunetta','2015-10-22','Perempuan','Samarinda','Fakarchery','-','-','85250067139','20251209230524_6938ab340305d.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(309,'Adzkiya Shakila Shareen','2017-02-01','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','81348512242','20251209230652_6938ab8cc8248.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(310,'Zhafirah Tsabita Azzahra','2013-10-04','Perempuan','Samarinda','Individu','-','-','81346474628','20251209230823_6938abe788e86.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(311,'Thisa','2014-10-11','Perempuan','Samarinda','Sehati Achery Club','-','-','82250271155','20251209230948_6938ac3c54bcf.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(312,'Fathiya Adenaya Hadi','2014-07-16','Perempuan','Balikpapan','Cahaya Ilmu Archery','-','-','81254979220','20251209231112_6938ac90a9322.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(313,'Zahrana Khadijah Princess Mecca At Tahira','2015-02-18','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','0881192719','20251209231339_6938ad232cfd0.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(314,'Ashilah Diantoro','2013-10-02','Perempuan','Samarinda','Fakarchery','-','-','85246781227','20251209231459_6938ad737f03f.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(315,'Nesrien Hanin','2014-10-25','Perempuan','Kutai Kartanegara','Ibadurrahaman Archery Club','-','-','085347789897','20251209231657_6938ade9ea11c.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(316,'Nur Aisyah','2015-08-11','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251209231805_6938ae2d8547c.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(317,'Naima Nur Afifah','2013-08-12','Perempuan','Anggana','SD Muhammadiyah','-','-','081347640458','20251209231947_6938ae933e2fc.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(318,'Ameera Zahra','2015-11-11','Perempuan','Samarinda','Fakarchery','-','-','8134646262','20251209232100_6938aedcb6fe8.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(319,'Tsabita Rumaisha Assariy','2015-05-12','Perempuan','Samarinda','Gold Archery Samarinda','-','-','85654277634','20251209232226_6938af327fce4.jpg',11,11,'2026-01-08 08:40:35','2026-01-12 07:09:52'),(320,'Muhammad Naafi','2017-01-19','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','085345462525','20251210002532_6938bdfc49e78.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(321,'Arshaka Ayman Zaid Saswanto','2018-07-06','Laki-laki','Samarinda','Rumah Belajar Archery Club','Tk Islam Nurul Huda','B besar','085332439909','20251210002725_6938be6d4d0aa.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(322,'Muhammad Aqsho Qory Ahnaf','2017-06-26','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','085246518008','20251210003949_6938c155755e0.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(323,'Abdullooh','2018-09-05','Laki-laki','Balikpapan','Cahaya Ilmu Archery Club','-','-','082154653907','',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(324,'Muhammad Ridho Apriliyanto','2016-04-03','Laki-laki','Samarinda','NFH ARCHERY','-','-','082159495812','20251210005402_6938c4aace694.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(325,'Puri Maulida Oktaviani','2013-10-20','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210011827_6938ca639bddd.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(326,'Halimatussa\'diah','2020-06-09','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','08183619731','20251210011929_6938caa1c0bd8.png',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(327,'Hafiza Khaira Lubna','2013-09-19','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','85330330997','20251210012159_6938cb37c4162.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(328,'Oriana Dzaqirah Anindita','2014-04-23','Perempuan','Balikpapan','Minu Archery','-','-','81802770334','20251210012359_6938cbafd0daf.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(329,'Ainul Mardhiyyah','2015-05-28','Perempuan','Bontang','Al Izzah Archery','-','-','81347370384','20251210012540_6938cc143bc44.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(330,'Suci Ashari Ambarwati','2014-07-13','Perempuan','Samarinda','Gold Archery Samarinda','SD Islam Bunga Bangsa','5','82157111329','20251210012630_6938cc4627205.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(331,'Fella Qaireen','2016-08-19','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','8156577076','20251210012722_6938cc7acace2.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(332,'Azka Hafiz Pratama','2016-03-10','Laki-laki','Samarinda','Rantau Archery','-','-','082150636457','20251210012946_6938cd0abe7ba.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(333,'Raisya Afifa Farhana','2014-11-15','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','8125489636','20251210012953_6938cd11ea1db.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(334,'Hazanah Nur Hanan','2013-05-09','Perempuan','Bontang','Al Izzah Archery','-','-','82148486148','20251210013152_6938cd88c5445.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(335,'Muhammad Raffa Alfarizqi','2017-06-10','Laki-laki','Samarinda','Al - Azhar Archery','-','-','087888076899','20251210013205_6938cd957caae.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(336,'Alima Aisyaturridha','2015-04-08','Perempuan','Penajam','Al Muzammil Archery','-','-','81254666555','20251210013329_6938cde97b0a5.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(337,'Izzatul Mayla Nafizah','2015-02-02','Perempuan','Bontang','Al Izzah Archery','-','-','85250224457','20251210013452_6938ce3c95b6b.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(338,'Faristhaa Aurelia Zhafira','2013-11-09','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','085332439909','20251210013618_6938ce920701a.jpg',11,11,'2026-01-08 08:40:35','2026-01-12 05:46:26'),(339,'Bunga Amelia Putri','2016-04-26','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251210013723_6938ced3e46cd.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(340,'Aysar Abdullah Ismaladi','2017-04-29','Laki-laki','Samarinda','Cakrawala Kaki Langit Archery','-','-','0895380001378','20251210013918_6938cf46104d8.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(341,'Shofie Diana Salsabila','2014-03-18','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','8125393659','20251210013922_6938cf4a0f5c3.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(342,'Adeeva Aqila Nahdmi','2017-07-06','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','85251818552','20251210014011_6938cf7b25325.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(343,'Raifatih Abdurrahman','2016-09-30','Laki-laki','Balikpapan','Cahaya Ilmu Archery','-','-','089518478147','20251210014346_6938d05243aa6.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(344,'Lakeisha Saufa Azzahra','2014-07-25','Perempuan','Bontang','Al Izzah Archery','-','-','895329960534','20251210015353_6938d2b1df666.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(345,'Muhammad Arsyad Al Fathir','2017-03-22','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','081253720335','20251210015555_6938d32b2ba4e.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(346,'Martsheally Bintang Nuraini','2015-03-03','Perempuan','Samarinda','Sehati Achery Club','-','-','85752206834','20251210015715_6938d37b27f63.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(347,'Na \'Imah Kanza Azzahra','2014-02-06','Perempuan','Anggana','SD Muhammadiyah 1 Anggana','-','-','81347640458','20251210020027_6938d43b6c4d0.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(348,'Auren Adonia Inonu','2016-05-11','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','81258021389','20251210020145_6938d4898cfd3.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(349,'Shireen Hafizah Khayyirah Lubna','2014-08-30','Perempuan','Samarinda','Fakarchery','-','-','81346462627','20251210020334_6938d4f649e25.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(350,'Eny Syahirah','2012-12-12','Perempuan','Tenggarong','Ibadurrahaman Archery Club','-','-','85362003937','20251210020503_6938d54f65fdb.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(351,'Khairunnisa Novia Sari','2015-08-11','Perempuan','Balikpapan','Ma\'rifah Archery','-','-','81802770334','20251210020813_6938d60d902af.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(352,'Rara','2015-02-17','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','0810283910','20251210021029_6938d695545e4.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(353,'Syabil Ahza Zahra','2013-08-13','Perempuan','Anggana','SD Muhammadiyah','-','-','081347640458','20251210021147_6938d6e3c25c9.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(354,'Qheyla Syabilla','2016-04-23','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','8991223698','',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(355,'Keisha Nazmi Az-Zahra','2014-12-18','Perempuan','Samarinda','Cakrawala Kaki Langit Archery','-','-','895380001378','20251210021440_6938d790ad889.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(356,'Ken Fathiya Haura El Hazima','2014-08-17','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','81347541552','20251210021839_6938d87f8e4f6.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(357,'Azrina Gazala Falihah','2016-08-30','Perempuan','Sangata Utara','Al Azzam Rimayah Club','-','-','85252486687','20251210021923_6938d8abd0691.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(358,'Mannaf Alfarizqi','2016-06-30','Laki-laki','Bontang','Waqqash Archery Bontang','-','-','081346433743','20251210022011_6938d8db48c8e.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(359,'Maryam Hana Humaira','2014-10-14','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','08128161','20251210022100_6938d90ce0fcf.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(360,'Muhammad Afkar Alqadr','2016-06-22','Laki-laki','Samarinda','Ar Rajwa Archery Club','-','-','082299490028','20251210022204_6938d94cd732c.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(361,'Haura Azkiyyha','2015-10-19','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251210022216_6938d9583e952.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(362,'Alena Zahwa Athifa','2013-10-05','Perempuan','Samarinda','Rantau Archery','-','-','82150636457','20251210022346_6938d9b2e436d.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(363,'El Thariq Gibraltar','2016-05-24','Laki-laki','Balikpapan','Cahaya Ilmu Archery','-','-','089567387368','20251210023006_6938db2e3dfeb.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(364,'Salman Al Farizi','2016-10-25','Laki-laki','Penajam','Prabu Archery','-','-','081254666555','20251210023549_6938dc85d4d62.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(365,'Faidha Zharufa Arisha Sumantri','2014-09-17','Perempuan','Samarinda','Gold Archery Samarinda','SDI Bunga Bangsa','5','081328881895','20251210023750_6938dcfe1a69d.jpg',38,11,'2026-01-08 08:40:35','2026-01-12 07:15:01'),(366,'Syakira Alifa Rasyadani','2014-06-19','Perempuan','Samarinda','Archery Cordova','-','-','81287936503','20251210023908_6938dd4cbd893.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(367,'Akbar Fatih Ash Shiddiq','2016-12-28','Laki-laki','Bontang','Al Izzah Archery','-','-','08525054339','20251210023934_6938dd664ffd5.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(368,'Anisa Aqilah Azzahra','2015-07-08','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','0818218717','20251210024046_6938ddae73aad.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(369,'Zahra Talita Syahla','2013-12-10','Perempuan','Samarinda','Individu','-','-','8115591213','20251210024221_6938de0dc4656.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(370,'Raisa  Athaya Al-Jumu\'ah','2015-03-04','Perempuan','Samarinda','Kholid Bin Walid Archery Club','-','-','85350104397','20251210024407_6938de77e9abf.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(371,'Muhammad Taqiyuddin Abdillah El-Haq','2020-01-28','Laki-laki','Bontang','Al Izzah Archery','-','-','08162183611','20251210024619_6938defbe4c45.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(372,'Andi Farah Fathiyah Rahman','2013-12-22','Perempuan','Samarinda','Khidir Archery Club','-','-','85246885405','20251210024936_6938dfc0e36e0.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(373,'Azril Al Hafidz','2018-02-07','Laki-laki','Samarinda','Rantau Archery','-','-','082150636457','20251210024955_6938dfd3d6972.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(374,'Claudya Valentina Anggraini','2014-02-13','Perempuan','Samarinda','Cakrawala Kaki Langit Archery','-','-','895380001378','20251210025058_6938e012f3ceb.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(375,'Sultan Muhammad Alvarendra','2016-10-30','Laki-laki','Samarinda','Cakrawala Kaki Langit Archery','-','-','082150636457','20251210025204_6938e0549407d.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(376,'Cut Munifah Karimah','2014-10-01','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','81253194063','20251210025214_6938e05e7c9f3.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(377,'Aqila Riski Apriliani','2013-09-04','Perempuan','Bontang','Waqqash Archery Bontang','-','-','85350553533','20251210025323_6938e0a39b285.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(378,'Sumayyah Haura Avicenna','2015-08-20','Perempuan','Bontang','Al Izzah Archery','-','-','82220090101','20251210025430_6938e0e6331c3.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(379,'Ukkasyah','2020-01-04','Laki-laki','Samarinda','FAKARCHERY','-','-','081213781813','20251210025450_6938e0fa27894.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(380,'Maryam Haniyn Sholihah','2015-06-07','Perempuan','Bontang','Waqqash Archery Bontang','-','-','85350553533','20251210025533_6938e125a825e.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(381,'Ahmad Zainu Zein Fahri','2016-04-09','Laki-laki','Samarinda','Rantau Archery','-','-','082150636457','20251210025659_6938e17b90ffe.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(382,'Khalif Abdurrahman','2020-01-29','Laki-laki','Samarinda','FAKARCHERY','-','-','08813618731','20251210030053_6938e26551885.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(383,'Habib Aldebaran','2016-03-12','Laki-laki','Penajam','Al Muzammil Archery','-','-','081254666555','20251210030235_6938e2cb6aa3d.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(384,'Abidzar Muhammad Alfais','2018-06-27','Laki-laki','Samarinda','Fakarchery','-','-','082255774573','20251210030441_6938e34970272.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(385,'Muhammad Al Khalifi Pratama','2016-07-22','Laki-laki','Samarinda','Rantau Archery','-','-','082150636457','20251210030656_6938e3d0ae873.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(386,'Syatir Al Ayyubi','2018-07-06','Laki-laki','Samarinda','Ar Rajwa Archery Club','-','-','085350024444','20251210031018_6938e49a6e721.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(387,'Hanan Muhammad Sasmoyo','2018-11-29','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','081250509540','20251210031157_6938e4fdd45f6.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(388,'Raheesh Muhammad Arisena','2019-09-01','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','087774487100','20251210031333_6938e55dc6481.jpeg',4,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(389,'Aisyah Arsaa Rabbani','2012-06-14','Perempuan','Bontang','Waqqash Archery Bontang','-','-','085350553533','20251210054927_693909e76188e.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(390,'Syakira Faiha Ahmad','2014-05-11','Perempuan','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251210055425_69390b113a45b.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(391,'Aisha Labiba Trisnaputra','2011-04-05','Perempuan','Samarinda','NFH ARCHERY','-','-','081310928339','20251210055712_69390bb8ae008.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(392,'Aqila Riski Apriliani','2013-09-04','Perempuan','Bontang','Waqqash Archery Bontang','-','-','85350553533','20251210055921_69390c39158c8.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(393,'Alfina Azzahra','2015-07-13','Perempuan','Samarinda','Fakarchery','-','-','82156338712','20251210060143_69390cc7e778c.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(394,'Ahmad Naufal','2015-05-05','Laki-laki','Bontang','Waqqash Archery Bontang','-','-','85350553533','20251210060305_69390d192f492.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(395,'Calista Nesha Fauni Ardian P.','2011-01-03','Perempuan','Samarinda','Rantau Archery','-','-','082150636457','20251210060342_69390d3e3f66e.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(396,'Shakeela Putri Satria','2014-08-24','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','81254770009','20251210060515_69390d9bda1c5.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(397,'Afiq Syawal Akbar','2015-07-28','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251210060614_69390dd6470aa.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(398,'Radit','2014-10-06','Laki-laki','Samarinda','NFH ARCHERY','-','-','82159495812','20251210060709_69390e0dd4803.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(399,'Denayu Khanza Ashila Nur Arief','2011-11-26','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','085332439909','20251210060742_69390e2e25b35.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(400,'Mubarok','2013-01-06','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251210060758_69390e3e7e09f.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(401,'Denayu Kheiza Ashila Nur Arief','2014-05-20','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210060838_69390e6617b3c.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(402,'Muhammad Rifai','2014-12-28','Laki-laki','Samarinda','NFH ARCHERY','-','-','82159495812','20251210060915_69390e8b64239.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(403,'M.Naim Basyar Muchtaf','2013-01-17','Laki-laki','Samarinda','NFH ARCHERY','-','-','82159495812','20251210061605_6939102502475.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(404,'Raden Khaizan Arsy Nur Arief','2014-12-21','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210062107_6939115388e4d.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(405,'Faidhan Audisepta djatmiko','2016-03-09','Laki-laki','Samarinda','Khidir Archery Club','-','-','08916819194','20251210062207_6939118f0aa4e.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(406,'Abdurrahman','2014-07-25','Laki-laki','Kutai Timur','Al Azzam Rimayah Club','-','-','85250774004','20251210062907_693913337910d.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(407,'Aurelia','2010-06-05','Perempuan','Muara Jawa','Arrimayah Nurul Islam Horseback Archery','-','-','082236266414','20251210063221_693913f5e944a.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(408,'Muhammad Al Abbasy Langit Firdaus','2016-03-17','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','0884616139','20251210063719_6939151f2936c.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(409,'Muhammad Aqsho Qory Ahnaf','2017-06-26','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','085246518008','20251210063806_6939154e20709.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(410,'Pranaja Natha Narendra','2013-12-12','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','81333033620','20251210063929_693915a1ac5a3.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(411,'Lutfi Waiba Putri Lupita','2010-12-23','Perempuan','Bontang','Waqqash Archery Bontang','-','-','085350553533','20251210064023_693915d717cf8.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(412,'Zaky Al Fahrizi','2013-04-09','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210064024_693915d8f39bf.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(413,'Muhammad Sidiq Hendriawan','2014-12-13','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','85391773253','20251210064125_69391615a6f54.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(414,'Maryam Haniyn Sholihah','2015-06-07','Perempuan','Bontang','Waqqash Archery Bontang','-','-','85350553533','20251210064141_69391625623a9.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(415,'Faith RIzky Naufal .A','2013-07-05','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','-','085332603769','20251210064836_693917c47cf0e.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(416,'Abdan Khairu tsabit','2013-02-05','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','1 SMP','085332603769','20251210064858_693917da15bfe.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(417,'Anindyo Almer Dzaky Saswanto','2013-10-19','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210065002_6939181acd476.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(418,'Nayla Prasasty','2013-08-02','Perempuan','Balikpapan','Minu Archery','-','-','081802770334','20251210065041_69391841cac01.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(419,'Maliq Al Ghony','2014-08-23','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','82216130924','20251210065109_6939185d2af87.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(420,'Syailendra Adma Wijaya','2013-05-11','Laki-laki','Samarinda','Gold Archery Samarinda','MTS Normal Islam Samarinda','','08115926697','20251210065148_69391884163eb.jpg',5,11,'2026-01-08 08:40:35','2026-01-12 02:30:56'),(421,'Nawalia Mayza','2014-05-22','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','85349496768','20251210065207_693918970752d.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(422,'Wistara Kayana Zahid','2013-11-15','Laki-laki','Samarinda','Rantau Archery','-','-','82150636457','20251210065335_693918efde8f8.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(423,'Aisyah Afiqa Nur Hidayad','2012-03-29','Perempuan','Samarinda','NFH ARCHERY','-','-','082159495812','20251210065419_6939191b38fc1.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(424,'Muhammad Rafa Al Ghazali','2014-06-21','Laki-laki','Samarinda','sdit Ar Risallah','-','-','85250729362','20251210065510_6939194e836a6.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(425,'Alisbha Sabiya Adeeva Fatiha Humaira','2016-11-24','Perempuan','Samarinda','NFH ARCHERY','-','-','82159495812','20251210065607_693919875d593.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(426,'Anindita Keisha Zahra','2015-07-06','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210065747_693919eb0d682.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(427,'Reyand Naufal Syah','2014-07-09','Laki-laki','Samarindda','Arrimayah Nurul Islam Horseback Archery','-','-','0818628713','20251210065817_69391a091c6ed.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(428,'Muhammad Daffa Ibnu Hafidz','2016-06-08','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','08715236186','20251210065853_69391a2d2422c.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(429,'N Aulia S','2013-12-13','Perempuan','Samarinda','independent','-','-','8972272700','20251210070023_69391a878097c.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(430,'Mohammad Hasbillah','2016-10-27','Laki-laki','Balikpapan','Minu Archery','-','-','083613671361','20251210070132_69391acc13c56.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(431,'Naurah Aqilah','2012-04-06','Perempuan','Muara Jawa','Arrimayah Nurul Islam Horseback Archery','-','-','082251697159','20251210070316_69391b34b7251.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(432,'Muhammad Azka Rachmayadi','2014-06-30','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','8115851688','20251210070414_69391b6ec029a.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(433,'Medhina Levana AA','2015-10-22','Perempuan','Samarinda','Fakarchery','-','-','85250067139','20251210070530_69391bba6e9e0.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(434,'Abid Alfarizqi Wibowo','2015-04-13','Laki-laki','Bontang','Al Izzah Archery','-','-','85250021372','20251210070546_69391bca24600.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(435,'Muhammad Labib Haidar','2014-07-04','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','-','085247460860','20251210070638_69391bfec867e.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(436,'Fayyadh Hanifur Rahman','2016-02-11','Laki-laki','Samarinda','Ar Rajwa Archery Club','-','-','0867138171','20251210070730_69391c32d4bae.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(437,'Rabiatul Nurjannah','2014-09-03','Perempuan','Samarinda','NFH ARCHERY','-','-','82159495812','20251210070855_69391c874de72.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(438,'Abidah Nazmi Zarifa','2011-12-28','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','082148907519','20251210071138_69391d2a8d13d.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(439,'Athaya Afrizal Pratama','2015-11-04','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210071305_69391d8199cbe.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(440,'Nadia Rasida','2010-12-23','Perempuan','Bontang','Waqqash Archery Bontang','-','-','085350553533','20251210071347_69391dab28ea4.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(441,'Atharizz Calief Abdillah','2016-04-07','Laki-laki','Samarinda','Ar Rajwa Archery Club','-','-','08413131313','20251210071349_69391dad86e7c.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(442,'Muhammad Iqbal Nur Fadillah','2014-04-19','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210071800_69391ea8dcecc.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(443,'Masdavi Faa\'iq Al Adib','2013-11-08','Laki-laki','Samarinda','MIN 2 Samarinda','-','-','85252314013','20251210071919_69391ef70b336.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(444,'Muhammad Khalev El Azam','2015-11-06','Laki-laki','Samarinda','Daud Archery','-','-','81346496246','20251210072037_69391f4555c1a.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(445,'Athaa Isytahar Qasthalani','2013-02-08','Laki-laki','Samarinda','Fakarchery','-','-','85250814219','20251210072216_69391fa851b58.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(446,'Daehan Fairuz El Fatih','2015-07-09','Laki-laki','Samarinda','Daud Archery','-','-','85821352365','20251210072347_69392003b6251.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(447,'Muhammad Azzam Rasyid','2015-04-12','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','85251818552','20251210072451_693920436eaee.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(448,'Hanif Zhafran Zayyan','2015-12-06','Laki-laki','Penajam','Al Muzammil Archery','-','-','81254666555','20251210072644_693920b42ea9a.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(449,'Sayyid Yusuf Halim','2016-12-08','Laki-laki','Balikpapan','Minu Archery','-','-','0864743554678','20251210072721_693920d92344d.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(450,'Savaraz Khalil Milzam','2015-09-13','Laki-laki','Samarinda','Ar Rajwa Archery Club','-','-','85350024444','20251210073134_693921d6d7d1e.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(451,'Muhammad Afkar Alqadr','2015-06-22','Laki-laki','Samarinda','Ar Rajwa Archery Club','-','-','82299490028','20251210073409_693922717d9ad.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(452,'Abdullah Fabregas','2014-09-07','Laki-laki','Balikpapan','Cahaya Ilmu Archery Club','-','-','81231620608','20251210073521_693922b959647.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(453,'Aditya Nouval Agustin','2014-05-05','Laki-laki','Samarinda','Rantau Archery','-','-','82150636457','20251210073657_6939231954cfc.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(454,'Andi Althafarizqi Rahman','2015-07-14','Laki-laki','Samarinda','Khidir Archery Club','-','-','85246885405','20251210074125_6939242586f4c.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(455,'Ahmad Muflih Abulatif Yahya','2014-09-09','Laki-laki','Samarinda','Khidir Archery Club','-','-','82346855111','20251210074232_69392468631b3.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(456,'Muhammad Rizky Fathurrahman','2014-06-07','Laki-laki','Samarinda','Akademi Horsebow Sejati','-','-','83805562292','20251210074335_693924a78d180.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(457,'Hanif Abdurrohman','2013-11-07','Laki-laki','Samarinda','SAS','-','-','8115823381','20251210074445_693924edd8be9.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(458,'Mannaf Alfarizqi','2016-06-30','Laki-laki','Bontang','Waqqash Archery Bontang','-','-','081346433743','20251210074607_6939253f42d75.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(459,'Muhammad Bagas Abdul Rashiff','2014-01-11','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','82213170979','20251210074735_69392597bd403.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(460,'Dhirgham Haidar Arhab','2013-05-16','Laki-laki','Sanga Sanga','KAC 99','-','-','82250819536','20251210133058_69397612c9d10.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(461,'Muhammad Faiz Arju Yafie','2013-01-02','Laki-laki','Samarinda','Muhammadiyah Integrared School (MINDS) Archery','-','-','8125587393','20251210133536_693977280b588.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(462,'Ahmad Naufal','2015-05-05','Laki-laki','Bontang','Waqqash Archery Bontang','-','-','85350553533','20251210133634_69397762db45b.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(463,'Muhammad Rosyid Fadhilah','2013-09-07','Laki-laki','Samarinda','Gold Archery Samarinda','Pondok Abu Bakar','-','08565280359','20251210133705_69397781e30dd.jpg',8,11,'2026-01-08 08:40:35','2026-01-12 02:41:01'),(464,'Raden Khaizan Arsy Nur Arief','2014-12-21','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210135127_69397adfb4eb7.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(465,'Radit','2014-10-06','Laki-laki','Samarinda','NFH ARCHERY','-','-','82159495812','20251210135935_69397cc7e6672.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(466,'Afiq Syawal Akbar','2015-07-28','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251210140843_69397eeb5d72b.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(467,'M.Naim Basyar Muchtaf','2013-01-17','Laki-laki','Samarinda','NFH ARCHERY','-','-','82159495812','20251210145604_69398a04e253f.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(468,'Athaya Afrizal Pratama','2015-11-04','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210145648_69398a30ad265.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(469,'Hafiza Khaira Lubna','2013-09-19','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','85330330997','20251210145739_69398a63ab92d.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(470,'Ernanda Wijayanto','2012-02-22','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251210145833_69398a99714b2.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(471,'Lathief Akmal El Azzam','2013-06-06','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','85391347003','20251210145951_69398ae79c3ad.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(472,'Pranaja Natha Narendra','2013-12-12','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','81333033620','20251210150037_69398b15b6a79.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(473,'Sabrina Septiana Widya Astuthy','2011-09-22','Perempuan','Bontang','Waqqash Archery Bontang','-','-','085350553533','20251210150126_69398b4623c77.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(474,'Syarezia Albie','2012-01-05','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','085246920929','20251210150218_69398b7accfd5.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(475,'Muhammad Daffa Ibnu Hafidz','2016-06-08','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','08715236186','20251210150306_69398baa0e956.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(476,'Rizky Anggraini','2011-10-01','Perempuan','Samarinda','Muhammadiyah Integrared School (MINDS) Archery','-','-','085319330785','20251210150421_69398bf5db107.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(477,'Muhammad Rafi Ilham','2011-03-29','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251210150505_69398c21c5b5a.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(478,'Ahmad Fikri Khoirullah','2012-06-13','Laki-laki','Samarinda','Madina Archery','-','-','08186917271','20251210150653_69398c8d55b20.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(479,'Mecca Lunetta AA','2013-10-22','Perempuan','Samarinda','Fakarchery','-','-','085250067139','20251210150659_69398c93ed782.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(480,'Muhammad Dzakky Alkhairy','2012-10-19','Laki-laki','Samarinda','Al Azzam Rimayah Club','-','-','85252486687','20251210150842_69398cfaa79e0.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(481,'Nas Alika Ilmi Kaisara','2013-07-31','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','82244190549','20251210150844_69398cfc2f349.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(482,'Ibrahim Abey Fahlefi','2013-01-18','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','895402481883','20251210150955_69398d438c337.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(483,'Mohammad Hasbillah','2016-10-27','Laki-laki','Balikpapan','Minu Archery','-','-','083613671361','20251210151111_69398d8f84cc3.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(484,'Syifa Jamilah Muthmainah','2012-12-11','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','081347333033','20251210151117_69398d958a9e7.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(485,'Anang Nurwahyudi','2011-03-28','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251210151233_69398de16e5f2.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(486,'Arshaka Ayman Zaid Saswanto','2018-07-06','Laki-laki','Samarinda','Rumah Belajar Archery Club','Tk Islam Nurul Huda','B besar','085332439909','20251210151354_69398e32ebc55.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(487,'Intan Mulya','2010-03-13','Perempuan','Samarinda','Dhiya Rabbany Archery Mu\'Minin Kalimantan','-','-','0895408440504','20251210151513_69398e813e590.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(488,'Anindyo Almer Dzaky Saswanto','2013-10-19','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210151906_69398f6ad0ca3.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(489,'Zaky Al Fahrizi','2013-04-09','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210152213_693990258eee5.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(490,'Khidhir Helmi','2012-08-28','Laki-laki','Samarinda','Madina Archery','-','-','081244355212','20251210152634_6939912a0ea33.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(491,'Maritza Ratifa Azka','2012-04-16','Perempuan','Bontang','Al Izzah Archery','-','-','085806730683','20251210152643_693991338188b.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(492,'Reyand Naufal Syah','2014-07-09','Laki-laki','Samarindda','Arrimayah Nurul Islam Horseback Archery','-','-','0818628713','20251210152714_69399152dd1ac.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(493,'Muhammad Azka Rachmayadi','2014-06-30','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','8115851688','20251210152810_6939918aa246c.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(494,'Putri Nayla Huzna','2012-01-23','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','085246826300','20251210152948_693991ec87156.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(495,'Nurazizah','2010-10-26','Perempuan','Balikpapan','Spagrat Archery','-','-','081802770334','20251210153140_6939925c95a67.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(496,'Nur Rahma','2011-08-20','Perempuan','Balikpapan','Spagrat Archery','-','-','081802770334','20251210153313_693992b9a8068.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(497,'Muhammad Al Abbasy Langit Firdaus','2016-03-17','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','0884616139','20251210214049_6939e8e18c510.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(498,'Athaa Isytahar Qasthalani','2013-02-08','Laki-laki','Samarinda','Fakarchery','-','-','85250814219','20251210214248_6939e958ada09.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(499,'M. Rayyan Atallah','2011-01-19','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','811584090','20251210214442_6939e9ca33e74.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(500,'Rasya Ganendra Arka Pratama','2012-07-16','Laki-laki','Samarinda','SMP Islamic Centre Samarinda','-','-','8115510507','20251210214607_6939ea1fa1ff4.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(501,'Masdavi Faa\'iq Al Adib','2013-11-08','Laki-laki','Samarinda','MIN 2 Samarinda','-','-','85252314013','20251210214654_6939ea4e815fc.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(502,'Muhammad Azzam Rasyid','2015-04-12','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','85251818552','20251210214800_6939ea904f3da.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(503,'Roshan Akram Ubaidillah','2011-10-08','Laki-laki','Samarinda','Mumtaza Panahan','-','-','85249714782','20251210214921_6939eae13507f.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(504,'Furqon Ardian Noor','2011-09-16','Laki-laki','Balikpapan','Spagrat Archery','-','-','81802770334','20251210215120_6939eb58a2c26.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(505,'Muhammad Rizky Zailani','2011-09-15','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251210215241_6939eba998f37.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(506,'Muhammad Alfian Fadhil','2011-12-09','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','85391347003','20251210215435_6939ec1b0b3b0.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(507,'Muhammad Iqbal Nur Fadillah','2014-04-19','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251210215655_6939eca71eace.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(508,'Muhammad Umar Faruq','2010-10-10','Laki-laki','Samarinda','Madina Archery','-','-','8125364195','20251210215839_6939ed0f7c102.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(509,'Tegar Dwi Prasetya','2011-12-31','Laki-laki','Samarinda','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251210220004_6939ed640b27f.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(510,'Muhammad Rummi Al Ayyubi','2011-01-05','Laki-laki','Samarinda','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251210220111_6939eda7eff13.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(511,'Muhammad Jahriansyah','2012-07-04','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251210220225_6939edf100dcd.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(512,'Haris Abidus Sholehudin','2012-10-06','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251210220336_6939ee383b190.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(513,'Muhammad Revan Setiawan','2012-06-22','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251210220432_6939ee70c1f52.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(514,'Riski Khoirul Fadillah','2011-03-24','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251210220543_6939eeb784d62.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(515,'Sholihul Fathan','2012-10-12','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','85347010987','20251210220638_6939eeee2a8b7.jpg',8,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(516,'Aliya Nursalma Lahjie','2012-01-22','Perempuan','Samarinda','Dhiya Rabbany Archery Mu\'Minin Kalimantan','-','-','085822332134','20251211003535_693a11d7ea39e.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(517,'Maulida Sakinah','2011-02-20','Perempuan','Samarinda','Dhiya Rabbany Archery Mu\'Minin Kalimantan','-','-','082191982233','20251211003744_693a12584d885.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(518,'Shafa Salsabila Hamid','2011-05-17','Perempuan','Samarinda','Muhammadiyah Integrared School (MINDS) Archery','-','-','081346611909','20251211003943_693a12cf541b3.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(519,'Khalisha Aila Syafiqa','2012-11-08','Perempuan','Samarinda','Muhammadiyah Integrared School (MINDS) Archery','-','-','085250293353','20251211004145_693a134979f72.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(520,'Nur Aisyah','2015-08-11','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251211005121_693a1589582b1.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(521,'Zhafirah Tsabita Azzahra','2013-10-04','Perempuan','Samarinda','Individu','-','-','81346474628','20251211005236_693a15d4b3e8e.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(522,'Fakhrunnisa','2010-10-09','Perempuan','Penajam','Al Muzammil Archery','-','-','081254666555','20251211005609_693a16a9271cf.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(523,'Difa Salsabilla Azzahra','2012-10-13','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','085250858668','20251211005819_693a172b18de8.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(524,'Raisya Afifa Farhana','2014-11-15','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','8125489636','20251211010053_693a17c54c5d1.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(525,'Hana Zalfa Zahirah','2011-04-18','Perempuan','Penajam','Al Muzammil Archery','-','-','081254666555','20251211010223_693a181f8bb21.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(526,'Ameera Zahra','2015-11-11','Perempuan','Samarinda','Fakarchery','-','-','8134646262','20251211010522_693a18d2a4484.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(527,'Ashilah Diantoro','2013-10-02','Perempuan','Samarinda','Fakarchery','-','-','85246781227','20251211010641_693a192183877.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(528,'Shofie Diana Salsabila','2014-03-18','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','8125393659','20251211010748_693a196492ebc.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(529,'Najwa Mikayla Yusira','2012-12-06','Perempuan','Samarinda','Darussalam Archery Club','-','-','082255264664','20251211011005_693a19ed4e93e.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(530,'Haristang','1980-05-05','Laki-laki','Polma','Waqqash Archery Bontang','-','-','85350553533','20251211011137_693a1a4995362.jpg',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(531,'Salwa Aqila Oktavia','2011-05-10','Perempuan','Samarinda','Al-Mahsyar Nurul Iman Archery Club','-','-','085246261208','20251211011137_693a1a49d38f3.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(532,'Friyan Ari Kusuma','1993-03-29','Laki-laki','Samarinda','Fakarchery','-','-','81545746617','20251211011237_693a1a8592974.jpg',2,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(533,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113','20251211011312_693a1aa812164.jpg',2,11,'2026-01-08 08:40:35','2026-01-10 22:48:52'),(534,'Nur Asifa Salsa Meilani','2012-05-29','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','085250894234','20251211011424_693a1af09eb42.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(535,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','20251211011554_693a1b4abb57c.jpg',2,11,'2026-01-08 08:40:35','2026-01-08 14:54:28'),(536,'Shireen Hafizah Khayyirah Lubna','2014-08-30','Perempuan','Samarinda','Fakarchery','-','-','81346462627','20251211011725_693a1ba51e2a5.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(537,'Oriana Dzaqirah Anindita','2014-04-23','Perempuan','Balikpapan','Minu Archery','-','-','81802770334','20251211011902_693a1c06be537.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(538,'Burhanuddin','2024-02-28','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','0821128311','20251211012314_693a1d022c64b.jpg',2,11,'2026-01-08 08:40:35','2026-01-08 14:55:36'),(539,'Aqila Putri Karunia Rasti','2016-11-11','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251211012345_693a1d216acc8.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(540,'Tania Mulia','2013-10-10','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','085250858668','20251211012710_693a1deeb20e4.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(541,'Intan Nur Aisya Putri','2011-01-04','Perempuan','Samarinda','Dhiya Rabbany Archery Mu\'Minin Kalimantan','-','-','081253278744','20251211012841_693a1e49c11c7.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(542,'Nazwa Balqis Arlya','2012-01-15','Perempuan','Samarinda','Muhammadiyah Integrared School (MINDS) Archery','-','-','082153978962','20251211013018_693a1eaa6d1a7.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(543,'Tasya Nur Kholifah','2011-06-09','Perempuan','Penajam','Al Muzammil Archery','-','-','081254666555','20251211013149_693a1f050cef6.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(544,'Faristhaa Aurelia Zhafira','2013-11-09','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','085332439909','20251211013446_693a1fb686102.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(545,'Tsuraya Zahirah Burhan','2011-09-30','Perempuan','Samarinda','Al-Mahsyar Nurul Iman Archery Club','-','-','081241118391','20251211013619_693a201310c90.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(546,'Zaina Azzahira','2012-10-20','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','082148907519','20251211014157_693a21656b26a.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(547,'Puri Maulida Oktaviani','2013-10-20','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251211014329_693a21c151914.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(548,'Azrina Gazala Falihah','2016-08-30','Perempuan','Sangata Utara','Al Azzam Rimayah Club','-','-','85252486687','20251211014804_693a22d4401af.jpeg',38,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(549,'Aisyah Arsaa Rabbani','2012-06-14','Perempuan','Bontang','Waqqash Archery Bontang','-','-','085350553533','20251211020617_693a271986053.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(550,'Denayu Khanza Ashila Nur Arief','2011-11-26','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','085332439909','20251211020810_693a278a18271.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(552,'Aisha Labiba Trisnaputra','2011-04-05','Perempuan','Samarinda','NFH ARCHERY','-','-','081310928339','20251211021009_693a2801c9179.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(553,'Abdulah Akhyar Muttaqin','2009-02-03','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','082255518297','20251211021111_693a283ff1923.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(554,'Asya Alika Ramadhan','2007-07-17','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','085332439909','20251211021330_693a28ca77ba8.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(555,'Aurelia','2010-06-05','Perempuan','Muara Jawa','Arrimayah Nurul Islam Horseback Archery','-','-','082236266414','20251211021439_693a290fc91d5.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(556,'Abidah Nazmi Zarifa','2011-12-28','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','082148907519','20251211021646_693a298e62b25.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(557,'Denayu Kheiza Ashila Nur Arief','2014-05-20','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251211021747_693a29cbaf0c6.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(558,'Nayla Prasasty','2013-08-02','Perempuan','Balikpapan','Minu Archery','-','-','081802770334','20251211021850_693a2a0a81f02.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(560,'Naurah Aqilah','2010-04-06','Perempuan','Muara Jawa','Arrimayah Nurul Islam Horseback Archery','-','-','082251697159','20251211022237_693a2aedb2816.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(561,'Putri Nayla Huzna','2012-01-23','Perempuan','Samarinda','AL AZHAR ARCHERY','-','-','085246826300','20251211022343_693a2b2f20927.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(562,'Nur Rahma','2011-08-20','Perempuan','Balikpapan','Spagrat Archery','-','-','081802770334','20251211022414_693a2b4e4b2d8.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(563,'Syifa Jamilah Muthmainah','2012-12-11','Perempuan','Balikpapan','Akademi Horsebow Sejati','-','-','081347333033','20251211022506_693a2b827aa70.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(564,'Shalzabilla Putri Lazim','2008-04-03','Perempuan','Samarinda','Al-Katum Horsebow Academy','-','-','081345278183','20251211022743_693a2c1fbe49c.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(565,'Sabrina Septiana Widya Astuthy','2011-09-22','Perempuan','Bontang','Waqqash Archery Bontang','-','-','085350553533','20251211022823_693a2c471cba6.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(566,'Dhirgham Haidar Arhab','2013-05-16','Laki-laki','Sanga Sanga','KAC 99','-','-','82250819536','20251211022832_693a2c5063445.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(567,'Lathief Akmal El Azzam','2013-06-06','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','85391347003','20251211022914_693a2c7ac0154.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(568,'Maizatu Shofiyya','2007-12-22','Perempuan','Samarinda','Al-Katum Horsebow Academy','-','-','081649527324','20251211023013_693a2cb503d35.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(569,'Alissya Nazwa Maulidya','2009-03-27','Perempuan','Samarinda','Al-Katum Horsebow Academy','-','-','085787922067','20251211023134_693a2d0654a43.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(570,'Nurazizah','2010-10-26','Perempuan','Balikpapan','Spagrat Archery','-','-','081802770334','20251211023202_693a2d221fa2f.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(571,'Maritza Ratifa Azka','2012-04-16','Perempuan','Bontang','Al Izzah Archery','-','-','085806730683','20251211023251_693a2d531666f.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(572,'Muhammad Rosyid Fadhilah','2013-09-07','Laki-laki','Samarinda','Gold Archery Samarinda','Pondok Abu Bakar','-','08565280359','20251211023322_693a2d721ba41.jpg',6,11,'2026-01-08 08:40:35','2026-01-12 02:41:01'),(573,'Tsuraya Zahirah Burhan','2011-09-30','Perempuan','Samarinda','Al-Mahsyar Nurul Iman Archery Club','-','-','081241118391','20251211023331_693a2d7b8208d.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(574,'Athifa Utari','2009-01-16','Perempuan','Samarinda','Darussalam Archery Club','-','-','082353060502','20251211023545_693a2e0179e10.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(575,'Fabian Huda','2008-04-13','Laki-laki','Samarinda','Al-Katum Horsebow Academy','-','-','82153523434','20251211023610_693a2e1aa75aa.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(576,'Putri Puspithasari','2007-07-31','Perempuan','Samarinda','Al-Katum Horsebow Academy','-','-','0895602788732','20251211023700_693a2e4cc3698.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(577,'Muhammad Rossi Reyhan','2009-07-13','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','81347333033','20251211023748_693a2e7ca7f87.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(578,'Mubarok','2013-01-06','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251211023831_693a2ea703428.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(579,'Safa Alya Agustina','2009-12-14','Perempuan','Balikpapan','Ma\'rifah Archery','-','-','081802770334','20251211023838_693a2eaedd779.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(580,'Dhiyaa\'ul Fais','2009-10-25','Laki-laki','Balikpapan','BG Archery','-','-','85182726340','20251211024006_693a2f06076c4.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(581,'Annisa Septiana Ramadhani','2008-09-10','Perempuan','Balikpapan','Ma\'rifah Archery','-','-','081802770334','20251211024031_693a2f1f1aad4.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(582,'Alfyan','2007-03-30','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251211024123_693a2f53998fa.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(583,'Salwa Aqila Oktavia','2010-05-10','Perempuan','Samarinda','Al-Mahsyar Nurul Iman Archery Club','-','-','085246261208','20251211024306_693a2fbaea1c0.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(584,'Muhammad Rafi Ilham','2011-03-29','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251211024344_693a2fe0562f2.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(585,'Difa Salsabilla Azzahra','2012-10-13','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','085250858668','20251211024349_693a2fe5cee45.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(586,'Vanissa Bunga Azhara','2008-09-10','Perempuan','Balikpapan','Ma\'rifah Archery','-','-','081802770334','20251211024508_693a30346702f.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(587,'Aditya Faridz Maulana','2008-04-30','Laki-laki','Tenggarong','Al-Katum Horsebow Academy','-','-','8283856275011','20251211024512_693a3038b7a2c.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(588,'Arman Maulana','2009-12-16','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251211024610_693a30723397e.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(589,'Nurruhama','2007-09-30','Perempuan','Samarinda','Nurul Amin','-','-','082152061522','20251211024631_693a3087ae883.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(590,'Puri Maulida Oktaviani','2013-10-20','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251211024723_693a30bbddaf1.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(591,'Faristhaa Aurelia Zhafira','2013-11-09','Perempuan','Samarinda','Rumah Belajar Archery Club','-','-','085332439909','20251211024818_693a30f24baf3.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(592,'Zaina Azzahira','2012-10-20','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','082148907519','20251211024849_693a31114504e.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(593,'Nur Asifa Salsa Meilani','2012-05-29','Perempuan','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','085250894234','20251211024945_693a3149a4f1e.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(594,'Jihan Janeeta Gamsir','2009-03-11','Perempuan','Samarinda','Nurul Amin','-','-','081349390059','20251211025105_693a3199b2a16.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(595,'Zadat','2009-06-25','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251211025308_693a3214c2225.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(596,'Khanza Luthfiyah Indiyani','2010-03-18','Perempuan','Balikpapan','Sumayyah Grand Archery','-','-','085248099003','20251211025325_693a3225ecfb2.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(597,'Anindyo Almer Dzaky Saswanto','2013-10-19','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251211025435_693a326be9818.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(598,'Selvira Aulia','2009-06-24','Perempuan','Kutai Kartanegara','Sitti Aminah','-','-','089514859787','20251211025503_693a328744278.jpeg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(599,'Raffi Ahmad','2009-01-25','Laki-laki','Kukar','Arrimayah Nurul Islam Horseback Archery','-','-','82236266414','20251211033032_693a3ad833b70.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(600,'Zaky Al Fahrizi','2013-04-09','Laki-laki','Samarinda','Rumah Belajar Archery Club','-','-','85332439909','20251211033414_693a3bb6184e8.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(601,'Muhammad Dzakky Alkhairy','2012-10-19','Laki-laki','Samarinda','Al Azzam Rimayah Club','-','-','85252486687','20251211033440_693a3bd04912e.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(602,'Muhammad Rizky Zailani','2011-09-15','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251211033514_693a3bf2db109.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(603,'Muhammad Alfian Fadhil','2011-12-09','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','85391347003','20251211033558_693a3c1e26f42.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(604,'Furqon Ardian Noor','2011-09-16','Laki-laki','Balikpapan','Spagrat Archery','-','-','81802770334','20251211033637_693a3c45466bd.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(605,'Muhammad Alvarizam Annabi','2009-06-17','Laki-laki','Samarinda','SMP Islamic Centre Samarinda','-','-','08172612123','20251211033843_693a3cc3934ba.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(606,'Muhammad Afgan Al-Farizi','2009-09-10','Laki-laki','Samarinda','SD Muhammadiyah 4','-','-','85787334171','20251211033953_693a3d09d29b8.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(607,'Khidhir Helmi','2012-08-28','Laki-laki','Samarinda','Madina Archery','-','-','081244355212','20251211034020_693a3d2483a37.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(608,'Haris Abidus Sholehudin','2012-10-06','Laki-laki','Tenggarong','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251211034048_693a3d4043cc1.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(609,'Tegar Dwi Prasetya','2011-12-31','Laki-laki','Samarinda','Al-Mahsyar Nurul Iman Archery Club','-','-','85250894234','20251211034119_693a3d5f4abf2.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(610,'Ahmad Fikri Khoirullah','2012-06-13','Laki-laki','Samarinda','Madina Archery','-','-','08186917271','20251211034150_693a3d7e3d204.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(611,'Farras Wiraditya Pradana','2010-03-16','Laki-laki','Balikpapan','Akademi Horsebow Sejati','-','-','0882019368226','20251211034248_693a3db8e16f0.jpg',6,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(612,'Aisyah Afiqa Nur Hidayad','2012-03-29','Perempuan','Samarinda','NFH ARCHERY','-','-','082159495812','20251211065512_693a6ad0c1687.jpg',11,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(613,'Muhammad Naafi','2017-01-19','Laki-laki','Samarinda','AL AZHAR ARCHERY','-','-','085345462525','20251211150706_693ade1ad864f.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(614,'Arshaka Ayman Zaid Saswanto','2018-07-06','Laki-laki','Samarinda','Rumah Belajar Archery Club','Tk Islam Nurul Huda','B besar','085332439909','20251211151044_693adef43129e.jpg',5,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(615,'Zahra Zyvlani Nirwasita','2008-10-15','Perempuan','-','Ma\'rifah Archery','-','-','086971819','20251217205740_69431944460ac.jpg',7,11,'2026-01-08 08:40:35','2026-01-08 08:40:35'),(616,'A. Abbas','2003-01-08','Laki-laki','','Basilica','','','08123456789','',46,14,'2026-01-08 08:43:01','2026-01-12 08:53:18'),(617,'Ambo Logo','2002-01-08','Laki-laki','','Basilica','','','08123456778','',46,14,'2026-01-08 08:44:18','2026-01-08 08:44:18'),(618,'Rudi','1988-05-26','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08123456780','',2,14,'2026-01-08 13:47:17','2026-01-09 08:08:11'),(619,'Dirno','2000-03-09','Laki-laki','','Gold Archery Samarinda','','','081323451231','',2,14,'2026-01-08 15:03:02','2026-01-08 15:03:02'),(620,'Sania','2000-01-22','Perempuan','','Gold Archery Samarinda','','','08132341231','',3,14,'2026-01-08 15:31:57','2026-01-08 15:31:57'),(621,'Mila','2001-04-05','Perempuan','','Gold Archery Samarinda','','','0812092378432','',3,14,'2026-01-08 15:32:30','2026-01-08 15:32:30'),(622,'Rini','2002-09-12','Perempuan','','Gold Archery Samarinda','','','0812938102831','',3,14,'2026-01-08 15:33:12','2026-01-08 15:33:12'),(623,'Muhammad Rosyid Fadhilah','2012-01-07','Laki-laki','Samarinda','Gold Archery Samarinda','Pondok Abu Bakar','-','08565280359','',52,16,'2026-01-09 07:42:56','2026-01-09 07:42:56'),(624,'Faith RIzky Naufal .A','2013-07-05','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','-','085332603769','',52,16,'2026-01-09 07:45:11','2026-01-09 07:45:11'),(626,'Muhammad Labib Haidar','2014-07-04','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','-','085247460860','',52,16,'2026-01-09 07:46:11','2026-01-09 07:46:11'),(627,'Farhan','2012-01-06','Laki-laki','','Gold Archery Samarinda','','','081254312021','',52,16,'2026-01-09 07:46:57','2026-01-09 07:46:57'),(628,'rio','2012-01-01','Laki-laki','','Gold Archery Samarinda','','','081234567891','',52,16,'2026-01-09 07:47:22','2026-01-09 07:47:22'),(629,'jaisy','2012-01-01','Laki-laki','','Gold Archery Samarinda','','','081234567891','',52,16,'2026-01-09 07:47:44','2026-01-09 07:47:44'),(630,'ibad','2012-01-01','Laki-laki','','Gold Archery Samarinda','','','081234567891','',52,16,'2026-01-09 07:48:07','2026-01-09 07:48:07'),(631,'kaizan','2012-01-01','Laki-laki','','Gold Archery Samarinda','','','081234567891','',52,16,'2026-01-09 07:48:30','2026-01-09 07:48:30'),(632,'Abdan Khairu tsabit','2013-02-05','Laki-laki','Samarinda','Gold Archery Samarinda','SMP IT Cordova','1 SMP','085332603769','',52,16,'2026-01-09 07:48:49','2026-01-09 07:48:49'),(633,'Nur Syifa Fahmi','2013-11-10','Perempuan','Samarinda','Gold Archery Samarinda','SD Normal Islam','6','85654277634','',53,16,'2026-01-09 07:52:42','2026-01-09 07:52:42'),(634,'Suci Ashari Ambarwati','2014-07-13','Perempuan','Samarinda','Gold Archery Samarinda','SD Islam Bunga Bangsa','5','82157111329','',53,16,'2026-01-09 07:52:58','2026-01-09 07:52:58'),(635,'Tsabita Rumaisha Assariy','2015-05-12','Perempuan','Samarinda','Gold Archery Samarinda','-','-','85654277634','',53,16,'2026-01-09 07:53:22','2026-01-12 07:09:52'),(636,'Kinan','2012-01-01','Perempuan','','Gold Archery Samarinda','','','081234567891','',53,16,'2026-01-09 08:00:29','2026-01-09 08:00:29'),(637,'Faidha Zharufa Arisha Sumantri','2014-09-17','Perempuan','Samarinda','Gold Archery Samarinda','SDI Bunga Bangsa','5','081328881895','',53,16,'2026-01-09 08:00:54','2026-01-12 07:15:01'),(638,'Raisyah','2012-01-01','Perempuan','','Gold Archery Samarinda','','','081234567891','',53,16,'2026-01-09 08:01:18','2026-01-09 08:01:18'),(639,'Auna Asy Syifa Syakur','2016-02-01','Perempuan','Samarinda','Gold Archery Samarinda','Baitul Izah','3','085654277634','',53,16,'2026-01-09 08:01:31','2026-01-09 08:01:31'),(640,'Hanum Salsabila Murti','2017-03-26','Perempuan','Samarinda','Gold Archery Samarinda','SD Islam Bunga Bangsa','2 SD','082157111329','',43,16,'2026-01-09 08:02:23','2026-01-09 08:02:23'),(641,'Hanifa','2014-01-05','Perempuan','','Gold Archery Samarinda','','','081234567891','',43,16,'2026-01-09 08:03:10','2026-01-09 08:03:10'),(642,'Devani','2014-01-01','Perempuan','','Gold Archery Samarinda','','','081234567891','',43,16,'2026-01-09 08:03:36','2026-01-09 08:03:36'),(643,'Naifa Aisyah Nerdha Sumantri','2016-01-12','Perempuan','Samarinda','Gold Archery Samarinda','SDI Bunga Bangsa','3','081328881895','',43,16,'2026-01-09 08:03:58','2026-01-09 08:03:58'),(644,'Rovi','2014-01-05','Perempuan','','Gold Archery Samarinda','','','081234567891','',43,16,'2026-01-09 08:05:33','2026-01-09 08:05:33'),(645,'Chayra','2014-01-01','Perempuan','','Gold Archery Samarinda','','','081234567891','',43,16,'2026-01-09 08:05:51','2026-01-09 08:19:21'),(646,'Arga','2014-01-05','Laki-laki','','Gold Archery Samarinda','','','081234567891','',43,16,'2026-01-09 08:06:14','2026-01-09 08:06:14'),(647,'Zico','2014-01-05','Perempuan','','Gold Archery Samarinda','','','081234567891','',43,16,'2026-01-09 08:06:35','2026-01-09 08:06:35'),(648,'Hana','2014-01-05','Perempuan','Samarinda','Gold Archery Samarinda','-','-','08123456789','',43,16,'2026-01-09 08:06:53','2026-01-09 08:06:53'),(649,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','',54,16,'2026-01-10 09:07:56','2026-01-10 09:07:56'),(650,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','',46,16,'2026-01-10 09:07:56','2026-01-10 09:07:56'),(651,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','',48,16,'2026-01-10 09:07:56','2026-01-10 09:07:56'),(652,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','',47,16,'2026-01-10 09:07:56','2026-01-10 09:07:56'),(653,'Muhammad Husin','2002-03-25','Laki-laki','Samarinda','Gold Archery Samarinda','Unmul','-','85212966602','',39,16,'2026-01-10 09:07:56','2026-01-10 09:07:56'),(669,'Priyo','2003-01-03','Laki-laki','Samarinda','Gold Archery Samarinda','-','-','08618613113',NULL,54,16,'2026-01-10 22:48:52','2026-01-10 22:48:52'),(670,'Pudji','2002-01-01','Laki-laki','','Gold Archery Samarinda','','','085225842584','',54,16,'2026-01-10 22:53:06','2026-01-10 22:53:06'),(671,'test','2012-01-01','Laki-laki','','Airlangga Club','','','081208120812','',44,14,'2026-01-12 02:09:56','2026-01-12 02:09:56'),(672,'Syailendra Adma Wijaya','2013-05-11','Laki-laki','Samarinda','Gold Archery Samarinda','MTS Normal Islam Samarinda','','08115926697',NULL,52,16,'2026-01-12 02:30:56','2026-01-12 02:30:56');
/*!40000 ALTER TABLE `peserta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `peserta_rounds`
--

DROP TABLE IF EXISTS `peserta_rounds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `peserta_rounds` (
  `id` int NOT NULL AUTO_INCREMENT,
  `peserta_id` int NOT NULL,
  `score_board_id` int NOT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `peserta_rounds`
--

LOCK TABLES `peserta_rounds` WRITE;
/*!40000 ALTER TABLE `peserta_rounds` DISABLE KEYS */;
INSERT INTO `peserta_rounds` VALUES (1,110,27,NULL),(2,116,27,NULL),(3,121,27,NULL),(4,114,27,NULL),(5,111,27,NULL),(6,113,27,NULL),(7,108,27,NULL),(8,115,27,NULL),(9,123,27,NULL),(10,127,27,NULL),(11,109,27,NULL),(12,126,25,1),(13,99,25,0),(14,101,25,1),(15,98,25,0),(16,95,25,1),(17,93,25,0),(18,104,25,1),(19,120,25,0),(20,96,25,1),(21,105,25,0),(22,91,25,0),(23,97,25,1),(24,100,25,0),(25,107,25,1),(26,124,25,0),(27,102,25,1),(28,119,25,1),(29,122,25,0),(30,94,25,1),(31,90,25,0),(32,106,25,0),(33,103,25,1),(34,125,25,1),(35,92,25,0),(36,126,29,0),(37,101,29,NULL),(38,95,29,NULL),(39,104,29,NULL),(40,96,29,NULL),(41,97,29,NULL),(42,107,29,NULL),(43,102,29,NULL),(44,119,29,NULL),(45,94,29,NULL),(46,103,29,NULL),(47,125,29,NULL);
/*!40000 ALTER TABLE `peserta_rounds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qualification_scores`
--

DROP TABLE IF EXISTS `qualification_scores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qualification_scores` (
  `id` int NOT NULL AUTO_INCREMENT,
  `peserta_id` int NOT NULL,
  `kegiatan_id` int NOT NULL,
  `category_id` int NOT NULL,
  `rambahan` int DEFAULT '1',
  `series_1` int DEFAULT '0',
  `series_2` int DEFAULT '0',
  `series_3` int DEFAULT '0',
  `series_4` int DEFAULT '0',
  `series_5` int DEFAULT '0',
  `series_6` int DEFAULT '0',
  `total_score` int DEFAULT '0',
  `total_x` int DEFAULT '0',
  `total_10` int DEFAULT '0',
  `ranking` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_qualification` (`peserta_id`,`kegiatan_id`,`category_id`,`rambahan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qualification_scores`
--

LOCK TABLES `qualification_scores` WRITE;
/*!40000 ALTER TABLE `qualification_scores` DISABLE KEYS */;
/*!40000 ALTER TABLE `qualification_scores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rankings_source`
--

DROP TABLE IF EXISTS `rankings_source`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rankings_source` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `ranking` int NOT NULL,
  `nama_peserta` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `nama_club` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `asal_kota` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `total_score` int DEFAULT '0',
  `total_participants` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=440 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rankings_source`
--

LOCK TABLES `rankings_source` WRITE;
/*!40000 ALTER TABLE `rankings_source` DISABLE KEYS */;
INSERT INTO `rankings_source` VALUES (1,'Shortbow Pemula Putra (2018) - Jarak 3m',1,'Arshaka Ayman Zaid Saswanto','Rumah Belajar Archery Club','Samarinda',348,16,'2026-01-06 04:50:35'),(2,'Shortbow Pemula Putra (2018) - Jarak 3m',2,'MUHAMMAD AIDIL SAPUTRARANI','NFH Archery','Samarinda',308,16,'2026-01-06 04:50:35'),(3,'Shortbow Pemula Putra (2018) - Jarak 3m',3,'Muhammad Taqiyuddin Abdillah El-Haq','Al- Izzah Archery','Bontang',305,16,'2026-01-06 04:50:35'),(4,'Shortbow Pemula Putra (2018) - Jarak 3m',4,'Muhammad Abdullah','Ibadurrahaman Archery Club','Kutai Kartanegara',284,16,'2026-01-06 04:50:35'),(5,'Shortbow Pemula Putra (2018) - Jarak 3m',5,'Khalif Abdurrahman','FAKARCHERY','Samarinda',281,16,'2026-01-06 04:50:35'),(6,'Shortbow Pemula Putra (2018) - Jarak 3m',6,'Ukkasyah','FAKARCHERY','Samarinda',274,16,'2026-01-06 04:50:35'),(7,'Shortbow Pemula Putra (2018) - Jarak 3m',7,'Muhammad Arkhan Khalfani','AL AZHAR ARCHERY','Samarinda',270,16,'2026-01-06 04:50:35'),(8,'Shortbow Pemula Putra (2018) - Jarak 3m',8,'MUHAMMAD ZEESHAN ALMAHDI','AL AZHAR ARCHERY','Samarinda',266,16,'2026-01-06 04:50:35'),(9,'Shortbow Pemula Putra (2018) - Jarak 3m',9,'Muhammad Sayyid Musyaffa','Tunas Harapan Archery Club','Samarinda',265,16,'2026-01-06 04:50:35'),(10,'Shortbow Pemula Putra (2018) - Jarak 3m',10,'Rifqi Muhammad Hamasi','FAKARCHERY','Samarinda',236,16,'2026-01-06 04:50:35'),(11,'Shortbow Pemula Putra (2018) - Jarak 3m',11,'Muammar Bilal Ibrahim','FAKARCHERY','Samarinda',230,16,'2026-01-06 04:50:35'),(12,'Shortbow Pemula Putra (2018) - Jarak 3m',12,'Muhammad fahri','Tunas harapan archery club','Samarinda',211,16,'2026-01-06 04:50:35'),(13,'Shortbow Pemula Putra (2018) - Jarak 3m',13,'Uwais Hanif Ibrahim','FAKARCHERY','Samarinda',191,16,'2026-01-06 04:50:35'),(14,'Shortbow Pemula Putra (2018) - Jarak 3m',14,'Muhammad Rayandra Putra Pratan','Tunas Harapan Archery Club','Samarinda',187,16,'2026-01-06 04:50:35'),(15,'Shortbow Pemula Putra (2018) - Jarak 3m',15,'Habibi Muhammad Al Fatih','Cakrawala Kaki Langit Archery','Samarinda',178,16,'2026-01-06 04:50:35'),(16,'Shortbow Pemula Putra (2018) - Jarak 3m',16,'Zahid Hamizan Rabbani','Cakrawala Kaki Langit Archery','Samarinda',0,16,'2026-01-06 04:50:35'),(17,'Shortbow Pemula Putri (2018) - Jarak 3m',1,'Halimatussa\'diah','AL AZHAR ARCHERY','Samarinda',340,16,'2026-01-06 04:50:35'),(18,'Shortbow Pemula Putri (2018) - Jarak 3m',2,'YUINA SHARAWY SAPUTRARANI','NFH ARCHERY','Samarinda',331,16,'2026-01-06 04:50:35'),(19,'Shortbow Pemula Putri (2018) - Jarak 3m',3,'Dzakiyyah shofiy','Akademi Horsebow Sejati','Balikpapan',322,16,'2026-01-06 04:50:35'),(20,'Shortbow Pemula Putri (2018) - Jarak 3m',4,'Raline Mecca El Jasmine','AL AZHAR ARCHERY','Samarinda',320,16,'2026-01-06 04:50:35'),(21,'Shortbow Pemula Putri (2018) - Jarak 3m',5,'Daisha Arsyila','Prahu Archery','Penajam',312,16,'2026-01-06 04:50:35'),(22,'Shortbow Pemula Putri (2018) - Jarak 3m',6,'MAUDY AULIA AZZAHRA','FAKARCHERY','Samarinda',290,16,'2026-01-06 04:50:35'),(23,'Shortbow Pemula Putri (2018) - Jarak 3m',7,'Adiva','AL AZHAR ARCHERY','Samarinda',290,16,'2026-01-06 04:50:35'),(24,'Shortbow Pemula Putri (2018) - Jarak 3m',8,'Hafizah Adiibah','Al Azhar Archery','Samarinda',281,16,'2026-01-06 04:50:35'),(25,'Shortbow Pemula Putri (2018) - Jarak 3m',9,'Khairunnisa nur Aprilia','RANTAU ARCHERY','Samarinda',249,16,'2026-01-06 04:50:35'),(26,'Shortbow Pemula Putri (2018) - Jarak 3m',10,'Alifa Putri Zhafirah Dirgahayu','Cakrawala Kaki Langit Archery','Samarinda',247,16,'2026-01-06 04:50:35'),(27,'Shortbow Pemula Putri (2018) - Jarak 3m',11,'Bilqis Azizah Azzahra','FAKARCHERY','Samarinda',242,16,'2026-01-06 04:50:35'),(28,'Shortbow Pemula Putri (2018) - Jarak 3m',12,'Farzana Qiana','FAKARCHERY','Samarinda',176,16,'2026-01-06 04:50:35'),(29,'Shortbow Pemula Putri (2018) - Jarak 3m',13,'Delisha Almahyra','Prabu Archery','Penajam',170,16,'2026-01-06 04:50:35'),(30,'Shortbow Pemula Putri (2018) - Jarak 3m',14,'Annisa Shafa Hendriawanti','Akademi Horsebow Sejati','Balikpapan',135,16,'2026-01-06 04:50:35'),(31,'Shortbow Pemula Putri (2018) - Jarak 3m',15,'Rayta Havva Huri Hayyuna','Cakrawala Kaki Langit Archery','Samarinda',133,16,'2026-01-06 04:50:35'),(32,'Shortbow Pemula Putri (2018) - Jarak 3m',16,'Maryam Farzana Arrahman','Cakrawala Kaki Langit Archery','Samarinda',97,16,'2026-01-06 04:50:35'),(33,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',1,'MUHAMMAD RIDWAN','NFH ARCHERY','Samarinda',603,42,'2026-01-06 04:50:35'),(34,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',2,'Atharizz Calief Abdillah','Ar Rajwaa Archery Club','Samarinda',598,42,'2026-01-06 04:50:35'),(35,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',3,'Faidhan Audisepta djatmiko','Khidir Archery Club','Samarinda',597,42,'2026-01-06 04:50:35'),(36,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',4,'Mohammad Hasbillah','Minu Archery','Balikpapan',582,42,'2026-01-06 04:50:35'),(37,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',5,'Muhammad Naafi','AL AZHAR ARCHERY','Samarinda',574,42,'2026-01-06 04:50:35'),(38,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',6,'Arshaka Ayman Zaid Saswanto','Rumah Belajar Archery Club','Samarinda',571,42,'2026-01-06 04:50:35'),(39,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',7,'Muhammad Al Abbasy Langit Firda','Akademi Horsebow Sejati','Balikpapan',568,42,'2026-01-06 04:50:35'),(40,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',8,'M u s a','Al-Muhajirin Archery Club','Muara Badak',567,42,'2026-01-06 04:50:35'),(41,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',9,'Muhammad Daffa Ibnu Hafidz','Akademi Horsebow Sejati','Balikpapan',565,42,'2026-01-06 04:50:35'),(42,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',10,'Muhammad Aqsho Qory Ahnaf','AL AZHAR ARCHERY','Samarinda',565,42,'2026-01-06 04:50:35'),(43,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',11,'Sayyid Yusuf Halim','Minu Archery','Balikpapan',564,42,'2026-01-06 04:50:35'),(44,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',12,'Abdullooh','Cahaya Ilmu Archery Club','Balikpapan',560,42,'2026-01-06 04:50:35'),(45,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',13,'Fayyadh Hanifur Rahman','Ar Rajwaa Archery Club','Samarinda',558,42,'2026-01-06 04:50:35'),(46,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',14,'MUHAMMAD RIDHO APRILIYANTO','NFH ARCHERY','Samarinda',552,42,'2026-01-06 04:50:35'),(47,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',15,'Azka Hafiz Pratama','RANTAU ARCHERY','Samarinda',538,42,'2026-01-06 04:50:35'),(48,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',16,'Muhammad raffa alfarizqi','Al azhar archery','Samarinda',534,42,'2026-01-06 04:50:35'),(49,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',17,'Aysar Abdullah Ismaladi','Cakrawala Kaki Langit Archery','Samarinda',529,42,'2026-01-06 04:50:35'),(50,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',18,'Raifatih abdurrahman','Cahaya Ilmu Archery','Balikpapan',526,42,'2026-01-06 04:50:35'),(51,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',19,'Muhammad Arsyad Al Fathir','AL AZHAR ARCHERY','Samarinda',517,42,'2026-01-06 04:50:35'),(52,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',20,'Arsakha Aurellio Shakeel','AL AZHAR ARCHERY','Samarinda',508,42,'2026-01-06 04:50:35'),(53,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',21,'Mannaf Alfarizqi','Waqqash Archery Bontang','Bontang',508,42,'2026-01-06 04:50:35'),(54,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',22,'Muhammad Afkar Alqadr','Arrajwaa Archery Club','Samarinda',503,42,'2026-01-06 04:50:35'),(55,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',23,'EL Thariq Gibraltar','Cahaya Ilmu','Balikpapan',493,42,'2026-01-06 04:50:35'),(56,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',24,'Masdavi Fairel Aldebaran','MIN 2 Samarinda','Samarinda',492,42,'2026-01-06 04:50:35'),(57,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',25,'Salman Al Farizi','Prabu Archery','Penajam',485,42,'2026-01-06 04:50:35'),(58,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',26,'Akbar Fatih Ash Shiddiq','Al Izzah Archery','Bontang',469,42,'2026-01-06 04:50:35'),(59,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',27,'Muhammad Izzat Nabhan','Al-Muhajirin Archery Club','Muara Badak',452,42,'2026-01-06 04:50:35'),(60,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',28,'Muhammad Atid Abidzar','Al-Muhajirin Archery Club','Muara Badak',449,42,'2026-01-06 04:50:35'),(61,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',29,'Muhammad Taqiyuddin Abdillah El-Haq','Al Izzah Archery','Bontang',447,42,'2026-01-06 04:50:35'),(62,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',30,'ADLAN BILAL HABIBIE','Al - Azhar Archery','Samarinda',435,42,'2026-01-06 04:50:35'),(63,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',31,'Azril Al Hafidz','RANTAU ARCHERY','Samarinda',423,42,'2026-01-06 04:50:35'),(64,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',32,'Sultan Muhammad Alvarendra','Cakrawala Kaki Langit Archery','Samarinda',419,42,'2026-01-06 04:50:35'),(65,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',33,'Ukkasyah','FAKARCHERY','Samarinda',401,42,'2026-01-06 04:50:35'),(66,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',34,'Ahmad Zainu Zein Fahri','RANTAU ARCHERY','Samarinda',389,42,'2026-01-06 04:50:35'),(67,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',35,'Khalif Abdurrahman','FAKARCHERY','Samarinda',353,42,'2026-01-06 04:50:35'),(68,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',36,'Habib Aldebaran','Al Muzammil Archery','Penajam',350,42,'2026-01-06 04:50:35'),(69,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',37,'ABIDZAR MUHAMMAD ALFAIS','FAKARCHERY','Samarinda',340,42,'2026-01-06 04:50:35'),(70,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',38,'M. al khalifi pratama','RANTAU ARCHERY','Samarinda',330,42,'2026-01-06 04:50:35'),(71,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',39,'Nuzul Repandi','AL AZHAR ARCHERY','Samarinda',329,42,'2026-01-06 04:50:35'),(72,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',40,'Syatir Al Ayyubi','Ar Rajwaa Archery Club','Samarinda',318,42,'2026-01-06 04:50:35'),(73,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',41,'Hanan Muhammad Sasmoyo','AL AZHAR ARCHERY','Samarinda',317,42,'2026-01-06 04:50:35'),(74,'Shortbow Pelajar SD Kelas 1-2-3 Putra - Jarak 5m',42,'RAHEESH MUHAMMAD ARISENA','AL AZHAR ARCHERY','Samarinda',271,42,'2026-01-06 04:50:35'),(75,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',1,'Affiya Tsabita Ahnaf','Akademi Horsebow Sejati','Balikpapan',601,56,'2026-01-06 04:50:35'),(76,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',2,'Maryam','Ibadurrahaman Archery Club','Kutai Kartanegara',597,56,'2026-01-06 04:50:35'),(77,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',3,'ALISHBA SABIYA ADEEVA FATIHA','NFH ARCHERY','Samarinda',596,56,'2026-01-06 04:50:35'),(78,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',4,'ARSYILA FATIMAH','AL AZHAR ARCHERY','Samarinda',589,56,'2026-01-06 04:50:35'),(79,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',5,'Shafiyyah Putri Satria','Akademi Horsebow Sejati','Balikpapan',588,56,'2026-01-06 04:50:35'),(80,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',6,'Azkiya Qaireen ElmuIyanto','Rumah Belajar Archery Club','Samarinda',584,56,'2026-01-06 04:50:35'),(81,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',7,'Nauri Salsabila','Rantau Archery','Samarinda',576,56,'2026-01-06 04:50:35'),(82,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',8,'Zaskia khaira H','RANTAU ARCHERY','Samarinda',573,56,'2026-01-06 04:50:35'),(83,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',9,'FELLA QAIREEN','AL AZHAR ARCHERY','Samarinda',572,56,'2026-01-06 04:50:35'),(84,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',10,'Ranasya Najma Oktarianti','AL AZHAR ARCHERY','Samarinda',564,56,'2026-01-06 04:50:35'),(85,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',11,'Tsabita','Gold Archery Samarinda','Samarinda',559,56,'2026-01-06 04:50:35'),(86,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',12,'Halimatussa\'diah','AL AZHAR ARCHERY','Samarinda',558,56,'2026-01-06 04:50:35'),(87,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',13,'Titih Nurul Hasanah','Al Muzammil Archery','Penajam',554,56,'2026-01-06 04:50:35'),(88,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',14,'Adeeva Aqila Nahdmi','AL AZHAR ARCHERY','Samarinda',550,56,'2026-01-06 04:50:35'),(89,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',15,'Auren Adonia inonu','AL AZHAR ARCHERY','Samarinda',544,56,'2026-01-06 04:50:35'),(90,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',16,'Adzkiya Shakila Shareen','AL AZHAR ARCHERY','Samarinda',537,56,'2026-01-06 04:50:35'),(91,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',17,'Khansa Maisarah Kurniawan','Akademi Horsebow Sejati','Balikpapan',532,56,'2026-01-06 04:50:35'),(92,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',18,'AZRINA GAZALA FALIHAH','AL AZZAM RIMAYAH CLUB','Sangatta Utara',524,56,'2026-01-06 04:50:35'),(93,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',19,'Raisha Fakhira Ahmad','Ar Rajwaa Archery Club','Samarinda',521,56,'2026-01-06 04:50:35'),(94,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',20,'Daisha Arsyila','Prabu Archery','Penajam',520,56,'2026-01-06 04:50:35'),(95,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',21,'Zaskia Aqila Zahra','Al Izzah Archery','Bontang',520,56,'2026-01-06 04:50:35'),(96,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',22,'Aqila Putri Karunia Rasti','Rumah Belajar Archery Club','Samarinda',517,56,'2026-01-06 04:50:35'),(97,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',23,'Raesha Azzahra Qianti Shanum','Al Muzammil Archery','Penajam',516,56,'2026-01-06 04:50:35'),(98,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',24,'windriya tiara ayudia','RANTAU ARCHERY','Samarinda',515,56,'2026-01-06 04:50:35'),(99,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',25,'Zhafirah Ramadhani','RANTAU ARCHERY','Samarinda',515,56,'2026-01-06 04:50:35'),(100,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',26,'Bunga Amelia Putri','Ar Rajwaa Archery Club','Samarinda',514,56,'2026-01-06 04:50:35'),(101,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',27,'Hanum Salsabila Murti','Gold Archery Samarinda','Samarinda',512,56,'2026-01-06 04:50:35'),(102,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',28,'Auna Asy Syifa Syakur','Gold Archery Samarinda','Samarinda',504,56,'2026-01-06 04:50:35'),(103,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',29,'Qheyla Syabilla','Akademi Horsebow Sejati','Balikpapan',499,56,'2026-01-06 04:50:35'),(104,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',30,'Aisyah qotrunnada','RANTAU ARCHERY','Samarinda',494,56,'2026-01-06 04:50:35'),(105,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',31,'Dzakiyyah shofiy','Akademi Horsebow Sejati','Balikpapan',487,56,'2026-01-06 04:50:35'),(106,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',32,'Sheza Raiqa Adlia','Ar Rajwaa Archery Club','Samarinda',487,56,'2026-01-06 04:50:35'),(107,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',33,'Atifa Naura Mahira','Al-Muhajirin Archery Club','Muara Badak',486,56,'2026-01-06 04:50:35'),(108,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',34,'Alisyah Bilqis Sakhi','Al Muzammil','Penajam',483,56,'2026-01-06 04:50:35'),(109,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',35,'Assyifa Nur Tazkiyah','Ar Rajwaa Archery Club','Samarinda',481,56,'2026-01-06 04:50:35'),(110,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',36,'Khumaira Putri Defalin','RANTAU ARCHERY','Samarinda',477,56,'2026-01-06 04:50:35'),(111,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',37,'Shafiyyah lbtisamah Alifah','RANTAU ARCHERY','Samarinda',477,56,'2026-01-06 04:50:35'),(112,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',38,'Naifa Aisyah Nerdha Sumantri','Gold Archery Samarinda','Samarinda',477,56,'2026-01-06 04:50:35'),(113,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',39,'Shakila Khairina Adha','Prahu Archery','Penajam',470,56,'2026-01-06 04:50:35'),(114,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',40,'Medina Nur Syahidah','AL AZHAR ARCHERY','Samarinda',468,56,'2026-01-06 04:50:35'),(115,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',41,'Medina Humaira Azzahra','FAKARCHERY','Samarinda',429,56,'2026-01-06 04:50:35'),(116,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',42,'Hagia Sophia Az Zahra','FAKARCHERY','Samarinda',424,56,'2026-01-06 04:50:35'),(117,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',43,'Yumna Fariha Husniyah','Sdit Ar Risallah','Samarinda',417,56,'2026-01-06 04:50:35'),(118,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',44,'Nabilah Shakilah Arsyad','Al Muzammil Archery','Penajam',413,56,'2026-01-06 04:50:35'),(119,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',45,'Myesha Mufidah Abulatif Yahya','Khidir Archery Club','Samarinda',410,56,'2026-01-06 04:50:35'),(120,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',46,'Alesha Kylieluna','RANTAU ARCHERY','Samarinda',408,56,'2026-01-06 04:50:35'),(121,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',47,'Hafizah Adiibah','AL Azhar Archery','Samarinda',403,56,'2026-01-06 04:50:35'),(122,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',48,'Alivna Hilya Zia','SD Muhammadiyah 3 Samarinda','Samarinda',363,56,'2026-01-06 04:50:35'),(123,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',49,'Azkayra Zulaikha Afsheen','Ma\'rifah Archery','Balikpapan',359,56,'2026-01-06 04:50:35'),(124,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',50,'Shafiyyah Izzatul Wafa','SAS','Samarinda',356,56,'2026-01-06 04:50:35'),(125,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',51,'Asiyah Rania A','Al Izzah Archery','Bontang',342,56,'2026-01-06 04:50:35'),(126,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',52,'Aerilyn Billvania Cintakirana','Ar Rajwaa Archery Club','Samarinda',338,56,'2026-01-06 04:50:35'),(127,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',53,'Enni Firahmatin Wibisono','Ar Rajwaa Archery Club','Samarinda',326,56,'2026-01-06 04:50:35'),(128,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',54,'Kanaya Nur Ashila','RANTAU ARCHERY','Samarinda',307,56,'2026-01-06 04:50:35'),(129,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',55,'Anisa Ghina Shakirah','Al Muzammil Archery','Penajam',283,56,'2026-01-06 04:50:35'),(130,'Shortbow Pelajar SD Kelas 1-2-3 Putri - Jarak 5m',56,'Nusyaibah Bahira','Al Izzah Archery','Bontang',219,56,'2026-01-06 04:50:35'),(131,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',1,'Ahmad Naufal','Waqqash Archery Bontang','Bontang',602,52,'2026-01-06 04:50:35'),(132,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',2,'Afiq Syawal Akbar','Arrimayah Nurul Islam Horseba','Kukar',594,52,'2026-01-06 04:50:35'),(133,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',3,'Radit','NFH ARCHERY','Samarinda',588,52,'2026-01-06 04:50:35'),(134,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',4,'Mubarok','Arrimayah Nurul Islam Horseba','Kukar',586,52,'2026-01-06 04:50:35'),(135,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',5,'MUHAMMAD RIFAI','NFH ARCHERY','Samarinda',585,52,'2026-01-06 04:50:35'),(136,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',6,'M.NAIM BASYAR MUCHTAF','NFH ARCHERY','Samarinda',582,52,'2026-01-06 04:50:35'),(137,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',7,'Raden Khaizan Arsy Nur Arief','Rumah Belajar Archery Club','Samarinda',578,52,'2026-01-06 04:50:35'),(138,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',8,'Faidhan Audisepta Djatmiko','Khidir Archery Club','Samarinda',575,52,'2026-01-06 04:50:35'),(139,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',9,'ABDURRAHMAN','AL-Azzam Rimayah Club','KUTAI TIMUR',571,52,'2026-01-06 04:50:35'),(140,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',10,'Muhammad Al Abbasy Langit Firda','Akademi Horsebow Sejati','Balikpapan',570,52,'2026-01-06 04:50:35'),(141,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',11,'Muhammad Aqsho Qory Ahnaf','AL AZHAR ARCHERY','Samarinda',570,52,'2026-01-06 04:50:35'),(142,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',12,'Pranaja Natha Narendra','AL AZHAR ARCHERY','Samarinda',569,52,'2026-01-06 04:50:35'),(143,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',13,'Zaky Al Fahrizi','Rumah Belajar Archery Club','Samarinda',565,52,'2026-01-06 04:50:35'),(144,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',14,'Muhammad Sidiq Hendriawan','Akademi Horsebow Sejati','Balikpapan',563,52,'2026-01-06 04:50:35'),(145,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',15,'Faith Rizky Naufal .A','Gold Archery Samarinda','Samarinda',555,52,'2026-01-06 04:50:35'),(146,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',16,'Abdan Khairu Tsabit','Gold Archery Samarinda','Samarinda',554,52,'2026-01-06 04:50:35'),(147,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',17,'Anindyo Almer Dzaky Saswanto','Rumah Belajar Archery Club','Samarinda',553,52,'2026-01-06 04:50:35'),(148,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',18,'Maliq Al Ghony','AL AZHAR ARCHERY','Samarinda',551,52,'2026-01-06 04:50:35'),(149,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',19,'Syailendra Adma Wijaya','Gold Archery Samarinda','Samarinda',550,52,'2026-01-06 04:50:35'),(150,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',20,'Wistara Kayana Zahid','RANTAU ARCHERY','Samarinda',548,52,'2026-01-06 04:50:35'),(151,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',21,'Muhammad Rafa Al Ghazali','SD it arisalah','Samarinda',541,52,'2026-01-06 04:50:35'),(152,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',22,'Reynand Naufal syah','Arrimayah Nurul Islam','Kukar',541,52,'2026-01-06 04:50:35'),(153,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',23,'Muhammad Naafi','AL AZHAR ARCHERY','Samarinda',536,52,'2026-01-06 04:50:35'),(154,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',24,'Arshaka Ayman Zaid Saswanto','Rumah Belajar Archery Club','Samarinda',536,52,'2026-01-06 04:50:35'),(155,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',25,'Muhammad Daffa Ibnu Hafidz','Akademi Horsebow Sejati','Balikpapan',535,52,'2026-01-06 04:50:35'),(156,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',26,'Mohammad Hasbillah','Minu Archery','Balikpapan',535,52,'2026-01-06 04:50:35'),(157,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',27,'Muhammad Azka Rachmayadi','AL AZHAR ARCHERY','Samarinda',535,52,'2026-01-06 04:50:35'),(158,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',28,'Abid Alfarizqi Wibowo','Al-Izzah Archery','Bontang',535,52,'2026-01-06 04:50:35'),(159,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',29,'Muhammad Labib Haidar','Gold Archery Samarinda','Samarinda',533,52,'2026-01-06 04:50:35'),(160,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',30,'Fayyadh Hanifur Rahman','Ar Rajwaa Archery Club','Samarinda',533,52,'2026-01-06 04:50:35'),(161,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',31,'Athaya Afrizal Pratama','Rumah Belajar Archery Club','Samarinda',530,52,'2026-01-06 04:50:35'),(162,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',32,'Atharizz Calief Abdillah','Ar Rajwaa Archery Club','Samarinda',516,52,'2026-01-06 04:50:35'),(163,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',33,'Muhammad Iqbal Nur Fadillah','Rumah Belajar Archery Club','Samarinda',512,52,'2026-01-06 04:50:35'),(164,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',34,'Masdavi Faa\'iq Al Adib','MIN 2 Samarinda','Samarinda',508,52,'2026-01-06 04:50:35'),(165,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',35,'Muhammad khalev El azam','Daud archery','Samarinda',508,52,'2026-01-06 04:50:35'),(166,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',36,'Athaa Isytahar Qasthalani','FAKARCHERY','Samarinda',497,52,'2026-01-06 04:50:35'),(167,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',37,'Daehan fairuz El fatih','Daud archery','Samarinda',496,52,'2026-01-06 04:50:35'),(168,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',38,'Muhammad Azzam Rasyid','AL AZHAR ARCHERY','Samarinda',483,52,'2026-01-06 04:50:35'),(169,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',39,'Hanif Zhafran Zayyan','Al Muzammil Archery','Penajam',474,52,'2026-01-06 04:50:35'),(170,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',40,'Sayyid Yusuf Halim','Minu Archery','Balikpapan',468,52,'2026-01-06 04:50:35'),(171,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',41,'Savaraz Khalil Milzam','Ar Rajwaa Archery Club','Samarinda',455,52,'2026-01-06 04:50:35'),(172,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',42,'Muhammad Afkar Alqadr','Arrajwaa Archery Club','Samarinda',446,52,'2026-01-06 04:50:35'),(173,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',43,'Abdullah Fabregas','CAHAYA ILMU ARCHERY CLUB','Balikpapan',442,52,'2026-01-06 04:50:35'),(174,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',44,'Aditya nouval Agustin','RANTAU ARCHERY','Samarinda',433,52,'2026-01-06 04:50:35'),(175,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',45,'Andi Althafarizqi Rahman','Khidir archery club','Samarinda',426,52,'2026-01-06 04:50:35'),(176,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',46,'Ahmad Muflih Abulatif Yahya','Khidir archery club','Samarinda',415,52,'2026-01-06 04:50:35'),(177,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',47,'Muhammad Rizky Fathurrahman','Akademi Horsebow Sejati','Balikpapan',406,52,'2026-01-06 04:50:35'),(178,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',48,'Hanif Abdurrohman','SAS','Samarinda',396,52,'2026-01-06 04:50:35'),(179,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',49,'MANNAF ALFARIZQI','Waqqash Archery Bontang','Bontang',372,52,'2026-01-06 04:50:35'),(180,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',50,'Muhammad Bagas abdul rashiff','AL AZHAR ARCHERY','Samarinda',280,52,'2026-01-06 04:50:35'),(181,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',51,'Muhammad khalev al azam','Daud archery','Samarinda',0,52,'2026-01-06 04:50:35'),(182,'Shortbow Pelajar SD Kelas 4-5-6 Putra - Jarak 7m',52,'Daehan fairuz El fatih','Daud archery','Samarinda',0,52,'2026-01-06 04:50:35'),(183,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',1,'Affiya Tsabita Ahnaf','Akademi Horsebow Sejati','Balikpapan',593,76,'2026-01-06 04:50:35'),(184,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',2,'LUTFI WAIBA PUTRI LUPITA','Waqqash Archery Bontang','BONTANG',589,76,'2026-01-06 04:50:35'),(185,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',3,'Denayu Kheiza Ashila Nur Arief','Rumah Belajar Archery Club','Samarinda',582,76,'2026-01-06 04:50:35'),(186,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',4,'Shakeela Putri Satria','Akademi Horsebow Sejati','Balikpapan',573,76,'2026-01-06 04:50:35'),(187,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',5,'AISYAH AFIQA NUR HIDAYAD','NFH ARCHERY','Samarinda',572,76,'2026-01-06 04:50:35'),(188,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',6,'N Aulia S','Independent','Samarinda',570,76,'2026-01-06 04:50:35'),(189,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',7,'ALISHBA SABIYA ADEEVA FATIHA','NFH ARCHERY','Samarinda',568,76,'2026-01-06 04:50:35'),(190,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',8,'Adibah khansa adryssin','Al izzah archery','Bontang',568,76,'2026-01-06 04:50:35'),(191,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',9,'Nasya Aqila Anindya','RANTAU ARCHERY','Samarinda',565,76,'2026-01-06 04:50:35'),(192,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',10,'Alfina Azzahra','FAKARCHERY','Samarinda',558,76,'2026-01-06 04:50:35'),(193,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',11,'Medhina Levana AA','FAKARCHERY','Samarinda',552,76,'2026-01-06 04:50:35'),(194,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',12,'Anindita Keisha Zahra','Rumah Belajar Archery Club','Samarinda',552,76,'2026-01-06 04:50:35'),(195,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',13,'ARSYILA FATIMAH','AL AZHAR ARCHERY','Samarinda',551,76,'2026-01-06 04:50:35'),(196,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',14,'Nas Alka Ilmi Kaisara','AL AZHAR ARCHERY','Samarinda',547,76,'2026-01-06 04:50:35'),(197,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',15,'Devanya Zakiyah Adlia','Ar Rajwaa Archery Club','Samarinda',545,76,'2026-01-06 04:50:35'),(198,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',16,'Azkiya Qaireen ElmuIyanto','Rumah Belajar Archery Club','Samarinda',543,76,'2026-01-06 04:50:35'),(199,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',17,'Nawalia Mayza','Akademi Horsebow Sejati','Balikpapan',542,76,'2026-01-06 04:50:35'),(200,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',18,'Ranasya Najma Oktarianti','AL AZHAR ARCHERY','Samarinda',539,76,'2026-01-06 04:50:35'),(201,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',19,'Nur Syifa Fahmi','Gold Archery Samarinda','Samarinda',539,76,'2026-01-06 04:50:35'),(202,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',20,'Maryam','Ibadurrahaman Archery Club','Kutai Kartanegara',538,76,'2026-01-06 04:50:35'),(203,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',21,'RABIATUL NURJANNAH','NFH ARCHERY','Samarinda',536,76,'2026-01-06 04:50:35'),(204,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',22,'Nursyifa Zakiyya Puspandari','Ma\'rifah Archery','Balikpapan',531,76,'2026-01-06 04:50:35'),(205,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',23,'Mecca Lunetta','FAKARCHERY','Samarinda',531,76,'2026-01-06 04:50:35'),(206,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',24,'Adzkiya Shakila Shareen','AL AZHAR ARCHERY','Samarinda',529,76,'2026-01-06 04:50:35'),(207,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',25,'Zhafirah Tsabita Azzahra','Individu','Samarinda',529,76,'2026-01-06 04:50:35'),(208,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',26,'Thisa','Sehati Archery club','Samarinda',528,76,'2026-01-06 04:50:35'),(209,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',27,'Fathiya Adenaya Hadi','Cahaya Ilmu Archery','Balikpapan',525,76,'2026-01-06 04:50:35'),(210,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',28,'Zahrana Khadijah princess Mecca','al azhar archery','Samarinda',517,76,'2026-01-06 04:50:35'),(211,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',29,'Ashilah Diantoro','FAKARCHERY','Samarinda',517,76,'2026-01-06 04:50:35'),(212,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',30,'Nesrien Hanin','Ibadurrahaman Archery Club','Kutai Kartanegara',517,76,'2026-01-06 04:50:35'),(213,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',31,'Nur Aisyoh','Rumah Belajar Archery Club','Samarinda',515,76,'2026-01-06 04:50:35'),(214,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',32,'Naima Nur Afifah','SD Muhammadiyah','Anggana',514,76,'2026-01-06 04:50:35'),(215,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',33,'Ameera Zahra','FAKARCHERY','Samarinda',512,76,'2026-01-06 04:50:35'),(216,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',34,'Tsabita Rumaisha Assarly','Gold Archery Samarinda','Samarinda',511,76,'2026-01-06 04:50:35'),(217,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',35,'Puri Maulida Oktaviani','Rumah Belajar Archery Club','Samarinda',505,76,'2026-01-06 04:50:35'),(218,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',36,'Halimatussa\'diah','AL AZHAR ARCHERY','Samarinda',494,76,'2026-01-06 04:50:35'),(219,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',37,'Hafiza Khaira lubna','AL AZHAR ARCHERY','Samarinda',492,76,'2026-01-06 04:50:35'),(220,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',38,'Oriana Dzaqirah Anindita','Minu Archery','Balikpapan',490,76,'2026-01-06 04:50:35'),(221,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',39,'Ainul Mardhiyyah','Al izzah Archery','Bontang',490,76,'2026-01-06 04:50:35'),(222,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',40,'Suci Ashari Ambarwati','Gold Archery Samarinda','Samarinda',486,76,'2026-01-06 04:50:35'),(223,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',41,'FELLA QAIREEN','AL AZHAR ARCHERY','Samarinda',484,76,'2026-01-06 04:50:35'),(224,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',42,'Raisya Afifa Farhana','Akademi Horsebow Sejati','Balikpapan',483,76,'2026-01-06 04:50:35'),(225,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',43,'Hazanah nur hanan','Al izzah Archery','Bontang',480,76,'2026-01-06 04:50:35'),(226,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',44,'Alima Aisyaturridha','Al Muzammil Archery','Penajam',480,76,'2026-01-06 04:50:35'),(227,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',45,'Izzatul Mayla Nafizah','AL AZHAR ARCHERY','Samarinda',470,76,'2026-01-06 04:50:35'),(228,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',46,'Farishtaa Aurelia Zhafira','Rumah Belajar Archery Club','Samarinda',469,76,'2026-01-06 04:50:35'),(229,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',47,'Bunga Amelia Putri','Ar Rajwaa Archery Club','Samarinda',464,76,'2026-01-06 04:50:35'),(230,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',48,'Shofie Diana Salsabila','AL AZHAR ARCHERY','Samarinda',462,76,'2026-01-06 04:50:35'),(231,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',49,'Adeeva Aqila Nahdmi','AL AZHAR ARCHERY','Samarinda',461,76,'2026-01-06 04:50:35'),(232,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',50,'Lakeisha Saufa Azzahra','Al Muzammil Archery','Penajam',452,76,'2026-01-06 04:50:35'),(233,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',51,'Martsheilly Bintang Nuraini','Sehati Archery Club','Samarinda',446,76,'2026-01-06 04:50:35'),(234,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',52,'Na \'imah Kanza Azzahra','SD Muhammadiyah 1 Anggana','Anggana',445,76,'2026-01-06 04:50:35'),(235,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',53,'Auren Adonia inonu','AL AZHAR ARCHERY','Samarinda',442,76,'2026-01-06 04:50:35'),(236,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',54,'Shireen Hafizah Khayyirah Lubna','FAKARCHERY','Samarinda',438,76,'2026-01-06 04:50:35'),(237,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',55,'Eny Syahirah','Ibadurrahman Archery club','Tenggarong Seberang',415,76,'2026-01-06 04:50:35'),(238,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',56,'Khairunnisa Novia Sari','Ma\'rifah Archery','Balikpapan',414,76,'2026-01-06 04:50:35'),(239,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',57,'Rara','Ar Rajwaa Archery Club','Samarinda',414,76,'2026-01-06 04:50:35'),(240,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',58,'Syabil Ahza Zahra','SD Muhammadiyah','Anggana',412,76,'2026-01-06 04:50:35'),(241,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',59,'Qheyla Syabilla','AHS','Balikpapan',410,76,'2026-01-06 04:50:35'),(242,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',60,'Keisha Nazmi Az-Zahra','Cakrawala Kaki Langit Archery','Samarinda',408,76,'2026-01-06 04:50:35'),(243,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',61,'Ken fathiya haura el hazima','AL AZHAR ARCHERY','Samarinda',406,76,'2026-01-06 04:50:35'),(244,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',62,'AZRINA GAZALA FALIHAH','AL azzam rimayah club','Sangatta Utara',400,76,'2026-01-06 04:50:35'),(245,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',63,'MARYAM HANA HUMAIRA','AL AZHAR ARCHERY','Samarinda',397,76,'2026-01-06 04:50:35'),(246,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',64,'Haura Azkiyyha','Ar Rajwaa Archery','Samarinda',381,76,'2026-01-06 04:50:35'),(247,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',65,'Alena Zahwa Athifa','RANTAU ARCHERY','Samarinda',379,76,'2026-01-06 04:50:35'),(248,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',66,'Faidha Zharufa Arisha Sumantri','Gold Archery Samarinda','Samarinda',376,76,'2026-01-06 04:50:35'),(249,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',67,'Syakira Alifa Rasyidah','Archery Cordova','Samarinda',368,76,'2026-01-06 04:50:36'),(250,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',68,'ANISA AQILAH AZZARAH','AL AZHAR ARCHERY','Samarinda',360,76,'2026-01-06 04:50:36'),(251,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',69,'Zahra Talita Syahla','Individu','Samarinda',348,76,'2026-01-06 04:50:36'),(252,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',70,'Raisa Atheya Al-Jumu\'ah','Kholid bin Walid Archery Club','Sangasanga',344,76,'2026-01-06 04:50:36'),(253,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',71,'Andi Farah Fathiyah Rahman','Khidir archery club','Samarinda',270,76,'2026-01-06 04:50:36'),(254,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',72,'Claudya Valentina Anggraini','Cakrawala','Samarinda',0,76,'2026-01-06 04:50:36'),(255,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',73,'Cut Munifah Karimah','Ar Rajwaa Archery Club','Samarinda',0,76,'2026-01-06 04:50:36'),(256,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',74,'AQILA RISKI APRILIANI','Waqqash Archery Bontang','Bontang',0,76,'2026-01-06 04:50:36'),(257,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',75,'Sumayyah Haura Avicenna','Al izzah Archery','Bontang',0,76,'2026-01-06 04:50:36'),(258,'Shortbow Pelajar SD Kelas 4-5-6 Putri - Jarak 7m',76,'MARYAM HANIYN SHOLIHAH','Waqqash Archery Bontang','Bontang',0,76,'2026-01-06 04:50:36'),(259,'Shortbow Pelajar SMP Putra - Jarak 10m',1,'Dhirgham Haidar arhab','KAC 99','Sanga sanga',585,45,'2026-01-06 04:50:36'),(260,'Shortbow Pelajar SMP Putra - Jarak 10m',2,'Muhammad Faiz Arju Yafie','Muhammadiyah Integrared Sch','Samarinda',573,45,'2026-01-06 04:50:36'),(261,'Shortbow Pelajar SMP Putra - Jarak 10m',3,'Ahmad Naufal','Waqqash Archery Bontang','Bontang',570,45,'2026-01-06 04:50:36'),(262,'Shortbow Pelajar SMP Putra - Jarak 10m',4,'Muhammad Rosyid Fadhilah','Gold Archery Samarinda','Samarinda',569,45,'2026-01-06 04:50:36'),(263,'Shortbow Pelajar SMP Putra - Jarak 10m',5,'Raden Khaizan Arsy Nur Arief','Rumah Belajar Archery Club','Samarinda',554,45,'2026-01-06 04:50:36'),(264,'Shortbow Pelajar SMP Putra - Jarak 10m',6,'RADIT','NFH ARCHERY','Samarinda',550,45,'2026-01-06 04:50:36'),(265,'Shortbow Pelajar SMP Putra - Jarak 10m',7,'Afiq Syawal Akbar','Arrimayah Nurul Islam Horseba','Kukar',548,45,'2026-01-06 04:50:36'),(266,'Shortbow Pelajar SMP Putra - Jarak 10m',8,'M.NAIM BASYAR MUCHTAF','NFH ARCHERY','Samarinda',543,45,'2026-01-06 04:50:36'),(267,'Shortbow Pelajar SMP Putra - Jarak 10m',9,'Athaya Afrizal Pratama','Rumah Belajar Archery Club','Samarinda',535,45,'2026-01-06 04:50:36'),(268,'Shortbow Pelajar SMP Putra - Jarak 10m',10,'Ernanda Wijayanto','Arrimayah Nurul Islam Horseba','Kukar',530,45,'2026-01-06 04:50:36'),(269,'Shortbow Pelajar SMP Putra - Jarak 10m',11,'Lathief Akmal EL Azzam','AL AZHAR ARCHERY','Samarinda',529,45,'2026-01-06 04:50:36'),(270,'Shortbow Pelajar SMP Putra - Jarak 10m',12,'PRANAJA NATHA NARENDRA','AL AZHAR ARCHERY','Samarinda',524,45,'2026-01-06 04:50:36'),(271,'Shortbow Pelajar SMP Putra - Jarak 10m',13,'Syarezia Albie','Akademi Horsebow Sejati','Balikpapan',511,45,'2026-01-06 04:50:36'),(272,'Shortbow Pelajar SMP Putra - Jarak 10m',14,'Muhammad Daffa Ibnu Hafidz','Akademi Horsebow Sejati','Balikpapan',510,45,'2026-01-06 04:50:36'),(273,'Shortbow Pelajar SMP Putra - Jarak 10m',15,'MUHAMMAD RAFI ILHAM','AL-MAHSYAR NURUL IMAN','TENGGARONG',507,45,'2026-01-06 04:50:36'),(274,'Shortbow Pelajar SMP Putra - Jarak 10m',16,'Ahmad Fikri Khoirullah','Madina archery','Samarinda',507,45,'2026-01-06 04:50:36'),(275,'Shortbow Pelajar SMP Putra - Jarak 10m',17,'MUHAMMAD DZAKKY ALKHAIRY','Al azzam Rimayah Club','Sangatta Kutai Tim',505,45,'2026-01-06 04:50:36'),(276,'Shortbow Pelajar SMP Putra - Jarak 10m',18,'Ibrahim Abey Fahlefi','Akademi Horsebow Sejati','Balikpapan',500,45,'2026-01-06 04:50:36'),(277,'Shortbow Pelajar SMP Putra - Jarak 10m',19,'Mohammad Hasbillah','Minu Archery','Balikpapan',494,45,'2026-01-06 04:50:36'),(278,'Shortbow Pelajar SMP Putra - Jarak 10m',20,'Anang Nurwahyudi','Arrimayah Nurul Islam Horseba','Kukar',494,45,'2026-01-06 04:50:36'),(279,'Shortbow Pelajar SMP Putra - Jarak 10m',21,'Anindyo Almer Dzaky Saswanto','Rumah Belajar Archery Club','Samarinda',492,45,'2026-01-06 04:50:36'),(280,'Shortbow Pelajar SMP Putra - Jarak 10m',22,'Zaky Al Fahrizi','Rumah Belajar Archery Club','Samarinda',485,45,'2026-01-06 04:50:36'),(281,'Shortbow Pelajar SMP Putra - Jarak 10m',23,'Khidhir Helmi','Madina archery','Samarinda',484,45,'2026-01-06 04:50:36'),(282,'Shortbow Pelajar SMP Putra - Jarak 10m',24,'Reynand Naufal syah','Arrimayah Nurul Islam','Kukar',483,45,'2026-01-06 04:50:36'),(283,'Shortbow Pelajar SMP Putra - Jarak 10m',25,'Muhammad Azka Rachmayadi','AL AZHAR ARCHERY','Samarinda',482,45,'2026-01-06 04:50:36'),(284,'Shortbow Pelajar SMP Putra - Jarak 10m',26,'Arshaka Ayman Zaid Saswanto','Rumah Belajar Archery Club','Samarinda',479,45,'2026-01-06 04:50:36'),(285,'Shortbow Pelajar SMP Putra - Jarak 10m',27,'Muhammad Al Abbasy Langit Firda','Akademi Horsebow Sejati','Balikpapan',466,45,'2026-01-06 04:50:36'),(286,'Shortbow Pelajar SMP Putra - Jarak 10m',28,'Athaa Isytahar Qasthalani','FAKARCHERY','Samarinda',460,45,'2026-01-06 04:50:36'),(287,'Shortbow Pelajar SMP Putra - Jarak 10m',29,'M. Rayyan Atallah','AL AZHAR ARCHERY','Samarinda',453,45,'2026-01-06 04:50:36'),(288,'Shortbow Pelajar SMP Putra - Jarak 10m',30,'Rasya Ganendra Arka Pratama','SMP Islamic Centre Samarinda','Samarinda',452,45,'2026-01-06 04:50:36'),(289,'Shortbow Pelajar SMP Putra - Jarak 10m',31,'Masdavi Faa\'iq Al Adib','MIN 2 Samarinda','Samarinda',446,45,'2026-01-06 04:50:36'),(290,'Shortbow Pelajar SMP Putra - Jarak 10m',32,'Muhammad Azzam Rasyid','AL AZHAR ARCHERY','Samarinda',411,45,'2026-01-06 04:50:36'),(291,'Shortbow Pelajar SMP Putra - Jarak 10m',33,'Roshan Akram Ubaidillah','Mumtaza Panahan','Samarinda',410,45,'2026-01-06 04:50:36'),(292,'Shortbow Pelajar SMP Putra - Jarak 10m',34,'Furqon ardian noor','Spagrat Archery','Balikpapan',409,45,'2026-01-06 04:50:36'),(293,'Shortbow Pelajar SMP Putra - Jarak 10m',35,'Muhammad Rizky Zailani','AL-Mahsyar Nurul Iman Archery','Tenggarong',405,45,'2026-01-06 04:50:36'),(294,'Shortbow Pelajar SMP Putra - Jarak 10m',36,'Muhammad Alfian Fadhil','AL AZHAR ARCHERY','Samarinda',396,45,'2026-01-06 04:50:36'),(295,'Shortbow Pelajar SMP Putra - Jarak 10m',37,'Muhammad Iqbal Nur Fadillah','Rumah Belajar Archery Club','Samarinda',382,45,'2026-01-06 04:50:36'),(296,'Shortbow Pelajar SMP Putra - Jarak 10m',38,'Muhammad Umar Faruq','Madina archery','Samarinda',370,45,'2026-01-06 04:50:36'),(297,'Shortbow Pelajar SMP Putra - Jarak 10m',39,'Tegar Dwi Prasetya','AL-Mahsyar Nurul Iman Archery','Samarinda',350,45,'2026-01-06 04:50:36'),(298,'Shortbow Pelajar SMP Putra - Jarak 10m',40,'MUHAMMAD RUMMI AL AYYUBI','AL-MAHSYAR NURUL IMAN','SAMARINDA',329,45,'2026-01-06 04:50:36'),(299,'Shortbow Pelajar SMP Putra - Jarak 10m',41,'Muhammad Jahriansyah','AL-Mahsyar Nurul Iman Archery','Tenggarong',329,45,'2026-01-06 04:50:36'),(300,'Shortbow Pelajar SMP Putra - Jarak 10m',42,'Haris Abidus Sholehudin','AL-MAHSYAR NURUL IMAN','TENGGARONG',316,45,'2026-01-06 04:50:36'),(301,'Shortbow Pelajar SMP Putra - Jarak 10m',43,'Muhammad Revan Setiawan','AL-Mahsyar Nurul Iman Archery','Samarinda',307,45,'2026-01-06 04:50:36'),(302,'Shortbow Pelajar SMP Putra - Jarak 10m',44,'RISKI KHOIRUL FADILLAH','AL-MAHSYAR NURUL IMAN','TENGGARONG',217,45,'2026-01-06 04:50:36'),(303,'Shortbow Pelajar SMP Putra - Jarak 10m',45,'Sholihul Fathan','Akademi Horsebow Sejati','Balikpapan',0,45,'2026-01-06 04:50:36'),(304,'Shortbow Pelajar SMP Putri - Jarak 10m',1,'AISYAH ARSAA RABBANI','Waqqash Archery Bontang','BONTANG',582,62,'2026-01-06 04:50:36'),(305,'Shortbow Pelajar SMP Putri - Jarak 10m',2,'Syakira Faiha Ahmad','Ar Rajwaa Archery Club','Samarinda',561,62,'2026-01-06 04:50:36'),(306,'Shortbow Pelajar SMP Putri - Jarak 10m',3,'Aisha Labiba Trisnaputra','NFH ARCHERY','Samarinda',547,62,'2026-01-06 04:50:36'),(307,'Shortbow Pelajar SMP Putri - Jarak 10m',4,'AQILA RISKI APRILIA','Waqqash Archery Bontang','Bontang',541,62,'2026-01-06 04:50:36'),(308,'Shortbow Pelajar SMP Putri - Jarak 10m',5,'Alfina Azzahra','FAKARCHERY','Samarinda',534,62,'2026-01-06 04:50:36'),(309,'Shortbow Pelajar SMP Putri - Jarak 10m',6,'Calista Nesha Fauni Ardian P','RANTAU ARCHERY','Samarinda',531,62,'2026-01-06 04:50:36'),(310,'Shortbow Pelajar SMP Putri - Jarak 10m',7,'Shakeela Putri Satria','Akademi Horsebow Sejati','Balikpapan',530,62,'2026-01-06 04:50:36'),(311,'Shortbow Pelajar SMP Putri - Jarak 10m',8,'Denayu Khanza Ashila Nur Arief','Rumah Belajar Archery Club','Samarinda',529,62,'2026-01-06 04:50:36'),(312,'Shortbow Pelajar SMP Putri - Jarak 10m',9,'AURELIA','Arrimayah Nurul Islam','Muara jawa',525,62,'2026-01-06 04:50:36'),(313,'Shortbow Pelajar SMP Putri - Jarak 10m',10,'Denayu Kheiza Ashila Nur Arief','Rumah Belajar Archery Club','Samarinda',524,62,'2026-01-06 04:50:36'),(314,'Shortbow Pelajar SMP Putri - Jarak 10m',11,'LUTFI WAIBA PUTRI LUPITA','Waqqash Archery Bontang','Bontang',524,62,'2026-01-06 04:50:36'),(315,'Shortbow Pelajar SMP Putri - Jarak 10m',12,'Nayla Prasasty','Minu Archery','Balikpapan',521,62,'2026-01-06 04:50:36'),(316,'Shortbow Pelajar SMP Putri - Jarak 10m',13,'MARYAM HANIYN SHOLIHAH','Waqqash Archery Bontang','Bontang',521,62,'2026-01-06 04:50:36'),(317,'Shortbow Pelajar SMP Putri - Jarak 10m',14,'Nawalia Mayza','Akademi Horsebow Sejati','Balikpapan',515,62,'2026-01-06 04:50:36'),(318,'Shortbow Pelajar SMP Putri - Jarak 10m',15,'AISYAH AFIQA NUR HIDAYAD','NFH ARCHERY','Samarinda',515,62,'2026-01-06 04:50:36'),(319,'Shortbow Pelajar SMP Putri - Jarak 10m',16,'Anindita Keisha Zahra','Rumah Belajar Archery Club','Samarinda',512,62,'2026-01-06 04:50:36'),(320,'Shortbow Pelajar SMP Putri - Jarak 10m',17,'N Aulia S','Independent','Samarinda',512,62,'2026-01-06 04:50:36'),(321,'Shortbow Pelajar SMP Putri - Jarak 10m',18,'ALISHBA SABIYA ADEEVA FATIHA','NFH ARCHERY','Samarinda',511,62,'2026-01-06 04:50:36'),(322,'Shortbow Pelajar SMP Putri - Jarak 10m',19,'Naurah Aqilah','Arrimayah Nurul Islam','Muara jawa',503,62,'2026-01-06 04:50:36'),(323,'Shortbow Pelajar SMP Putri - Jarak 10m',20,'Medhina Levana AA','FAKARCHERY','Samarinda',502,62,'2026-01-06 04:50:36'),(324,'Shortbow Pelajar SMP Putri - Jarak 10m',21,'RABIATUL NURJANNAH','NFH ARCHERY','Samarinda',495,62,'2026-01-06 04:50:36'),(325,'Shortbow Pelajar SMP Putri - Jarak 10m',22,'Abidah Nazmi Zarifa','AL-Mahsyar Nurul Iman Archery','Tenggarong',492,62,'2026-01-06 04:50:36'),(326,'Shortbow Pelajar SMP Putri - Jarak 10m',23,'NADIA RASIDA 23 12 2010','Waqqash Archery Bontang','BONTANG',491,62,'2026-01-06 04:50:36'),(327,'Shortbow Pelajar SMP Putri - Jarak 10m',24,'Hafiza Khaira lubna','AL AZHAR ARCHERY','Samarinda',485,62,'2026-01-06 04:50:36'),(328,'Shortbow Pelajar SMP Putri - Jarak 10m',25,'Sabrina Septiana Widya Astuthy','Waqqash Archery Bontang','Bontang',484,62,'2026-01-06 04:50:36'),(329,'Shortbow Pelajar SMP Putri - Jarak 10m',26,'Rizky Anggraini','Muhammadiyah Integrated Sch','Samarinda',466,62,'2026-01-06 04:50:36'),(330,'Shortbow Pelajar SMP Putri - Jarak 10m',27,'Mecco Lunetta AA','FAKARCHERY','Samarinda',465,62,'2026-01-06 04:50:36'),(331,'Shortbow Pelajar SMP Putri - Jarak 10m',28,'Nas Alka Ilmi Kaisara','AL AZHAR ARCHERY','Samarinda',457,62,'2026-01-06 04:50:36'),(332,'Shortbow Pelajar SMP Putri - Jarak 10m',29,'Syifa jamilah muthmainah','Akademi Horsebow Sejati','Balikpapan',444,62,'2026-01-06 04:50:36'),(333,'Shortbow Pelajar SMP Putri - Jarak 10m',30,'Intan Mulya','Dhiya\' Rabbany Archery Mu\'min','Samarinda',444,62,'2026-01-06 04:50:36'),(334,'Shortbow Pelajar SMP Putri - Jarak 10m',31,'Maritza ratifa azka','Al Izzah Archery','Bontang',435,62,'2026-01-06 04:50:36'),(335,'Shortbow Pelajar SMP Putri - Jarak 10m',32,'PUTRI NAYLA HUZNA','AL AZHAR ARCHERY','Samarinda',428,62,'2026-01-06 04:50:36'),(336,'Shortbow Pelajar SMP Putri - Jarak 10m',33,'Nurazizah','Spagrat Archery','Balikpapan',428,62,'2026-01-06 04:50:36'),(337,'Shortbow Pelajar SMP Putri - Jarak 10m',34,'Nur Rahma','Spagrat Archery','Balikpapan',425,62,'2026-01-06 04:50:36'),(338,'Shortbow Pelajar SMP Putri - Jarak 10m',35,'Aliya Nursalma Lahjie','Dhiya\' Rabbany Archery Mu\'min','Samarinda',424,62,'2026-01-06 04:50:36'),(339,'Shortbow Pelajar SMP Putri - Jarak 10m',36,'Maulida Sakinah','Ma\'rifah Archery','Balikpapan',422,62,'2026-01-06 04:50:36'),(340,'Shortbow Pelajar SMP Putri - Jarak 10m',37,'Shafa Salsabila Hamid','Muhammadiyah Integrated Sch','Samarinda',420,62,'2026-01-06 04:50:36'),(341,'Shortbow Pelajar SMP Putri - Jarak 10m',38,'Khalisha Aila Syafiqa','Muhammadiyah integrated sch','Samarinda',407,62,'2026-01-06 04:50:36'),(342,'Shortbow Pelajar SMP Putri - Jarak 10m',39,'Nur Aisyah','Rumah Belajar Archery Club','Samarinda',404,62,'2026-01-06 04:50:36'),(343,'Shortbow Pelajar SMP Putri - Jarak 10m',40,'Zhafirah Tsabita Azzahra','Individu','Samarinda',402,62,'2026-01-06 04:50:36'),(344,'Shortbow Pelajar SMP Putri - Jarak 10m',41,'Fakhrunnisa','Al Muzammil','Penajam',399,62,'2026-01-06 04:50:36'),(345,'Shortbow Pelajar SMP Putri - Jarak 10m',42,'DIFA SALSABILLA AZZAHRA','AL-MAHSYAR NURUL IMAN','TENGGARONG',394,62,'2026-01-06 04:50:36'),(346,'Shortbow Pelajar SMP Putri - Jarak 10m',43,'Raisya Afifa Farhana','Akademi Horsebow Sejati','Balikpapan',392,62,'2026-01-06 04:50:36'),(347,'Shortbow Pelajar SMP Putri - Jarak 10m',44,'Hana Zalfa Zahirah','Al Muzammil Archery','Penajam',391,62,'2026-01-06 04:50:36'),(348,'Shortbow Pelajar SMP Putri - Jarak 10m',45,'Ameera Zahra','FAKARCHERY','Samarinda',378,62,'2026-01-06 04:50:36'),(349,'Shortbow Pelajar SMP Putri - Jarak 10m',46,'Ashilah Diantoro','FAKARCHERY','Samarinda',378,62,'2026-01-06 04:50:36'),(350,'Shortbow Pelajar SMP Putri - Jarak 10m',47,'Shofie Diana Salsabila','AL AZHAR ARCHERY','Samarinda',359,62,'2026-01-06 04:50:36'),(351,'Shortbow Pelajar SMP Putri - Jarak 10m',48,'NAJWA MIKAYLA YUSIRA','Darussalam Archery Club','Samarinda',353,62,'2026-01-06 04:50:36'),(352,'Shortbow Pelajar SMP Putri - Jarak 10m',49,'SALWA AQILA OKATIVA','AL-MAHSYAR NURUL IMAN AR','SAMARINDA',348,62,'2026-01-06 04:50:36'),(353,'Shortbow Pelajar SMP Putri - Jarak 10m',50,'NUR ASIFA SALSA MEILANI','AL-MAHSYAR NURUL IMAN AR','TENGGARONG',324,62,'2026-01-06 04:50:36'),(354,'Shortbow Pelajar SMP Putri - Jarak 10m',51,'Shireen Hafizah Khayyirah Lubna','FAKARCHERY','Samarinda',311,62,'2026-01-06 04:50:36'),(355,'Shortbow Pelajar SMP Putri - Jarak 10m',52,'Oriana Dzaqirah Anindita','Minu Archery','Balikpapan',306,62,'2026-01-06 04:50:36'),(356,'Shortbow Pelajar SMP Putri - Jarak 10m',53,'AQILA KARUNIA PUTRI RASTI','Rumah Belajar Archery Club','Samarinda',288,62,'2026-01-06 04:50:36'),(357,'Shortbow Pelajar SMP Putri - Jarak 10m',54,'Tania Mulia','Dhiya\' Rabbany Archery Club','Tenggarong',281,62,'2026-01-06 04:50:36'),(358,'Shortbow Pelajar SMP Putri - Jarak 10m',55,'Intan Nur Aisya Putri','Dhiya\' Rabbany Archery Kaliman','Samarinda',264,62,'2026-01-06 04:50:36'),(359,'Shortbow Pelajar SMP Putri - Jarak 10m',56,'Nazwa Balqis Ariya','Muhammadiyah Integrated Sch','Samarinda',257,62,'2026-01-06 04:50:36'),(360,'Shortbow Pelajar SMP Putri - Jarak 10m',57,'Tasya Nur Kholifah','Al Muzammil Archery','Penajam',251,62,'2026-01-06 04:50:36'),(361,'Shortbow Pelajar SMP Putri - Jarak 10m',58,'Faristhaa Aurelia Zhafira','Rumah Belajar Archery Club','Samarinda',250,62,'2026-01-06 04:50:36'),(362,'Shortbow Pelajar SMP Putri - Jarak 10m',59,'TSURAYA ZAHIRAH BURHAN','AL-MAHSYAR NURUL IMAN AR','SAMARINDA',244,62,'2026-01-06 04:50:36'),(363,'Shortbow Pelajar SMP Putri - Jarak 10m',60,'Zaina Azzahira','Al-Mahsyar Nurul Iman Archery Club','Tenggarong',239,62,'2026-01-06 04:50:36'),(364,'Shortbow Pelajar SMP Putri - Jarak 10m',61,'Puri Maulida Oktaviani','Rumah Belajar Archery Club','Samarinda',221,62,'2026-01-06 04:50:36'),(365,'Shortbow Pelajar SMP Putri - Jarak 10m',62,'Azrina Gazala Falihah','Al azzam rimayah club','Sangatta utara',182,62,'2026-01-06 04:50:36'),(366,'Shortbow Pelajar SMA Putra - Jarak 15m',1,'ABDULAH AKHYAR MUTTAQIN','AL AZHAR ARCHERY','Samarinda',529,27,'2026-01-06 04:50:36'),(367,'Shortbow Pelajar SMA Putra - Jarak 15m',2,'Dhirgham Haidar arhab','KAC 99','Sanga sanga',510,27,'2026-01-06 04:50:36'),(368,'Shortbow Pelajar SMA Putra - Jarak 15m',3,'Lathief Akmal EL Azzam','AL AZHAR ARCHERY','Samarinda',499,27,'2026-01-06 04:50:36'),(369,'Shortbow Pelajar SMA Putra - Jarak 15m',4,'Muhammad Rosyid Fadhilah','Gold Archery Samarinda','Samarinda',497,27,'2026-01-06 04:50:36'),(370,'Shortbow Pelajar SMA Putra - Jarak 15m',5,'fabian huda','Al-katum Horsebow Academi','Samarinda',488,27,'2026-01-06 04:50:36'),(371,'Shortbow Pelajar SMA Putra - Jarak 15m',6,'Muhammad Rossi Reyhan','Akademi Horsebow Sejati','Balikpapan',441,27,'2026-01-06 04:50:36'),(372,'Shortbow Pelajar SMA Putra - Jarak 15m',7,'mubarok','Arrimayah Nurul Islam Horseba','Kukar',438,27,'2026-01-06 04:50:36'),(373,'Shortbow Pelajar SMA Putra - Jarak 15m',8,'Dhiyaa\'ul Fais','BG Archery','Balikpapan',432,27,'2026-01-06 04:50:36'),(374,'Shortbow Pelajar SMA Putra - Jarak 15m',9,'Alfyan','Arrimayah Nurul Islam Horseba','Kukar',419,27,'2026-01-06 04:50:36'),(375,'Shortbow Pelajar SMA Putra - Jarak 15m',10,'MUHAMMAD RAFI ILHAM','AL-MAHSYAR NURUL IMAN','TENGGARONG',414,27,'2026-01-06 04:50:36'),(376,'Shortbow Pelajar SMA Putra - Jarak 15m',11,'ADITYA FARIDZ MAULANA','AL KATUM HORSEBOW ACADE','SAMARINDA',408,27,'2026-01-06 04:50:36'),(377,'Shortbow Pelajar SMA Putra - Jarak 15m',12,'Arman Maulana','Arrimayah Nurul Islam Horseba','Kukar',398,27,'2026-01-06 04:50:36'),(378,'Shortbow Pelajar SMA Putra - Jarak 15m',13,'Zadat','Arrimayah Nurul Islam Horseba','Kukar',397,27,'2026-01-06 04:50:36'),(379,'Shortbow Pelajar SMA Putra - Jarak 15m',14,'Anindyo Almer Dzaky Saswanto','Rumah Belajar Archery Club','Samarinda',390,27,'2026-01-06 04:50:36'),(380,'Shortbow Pelajar SMA Putra - Jarak 15m',15,'Raffi Ahmad','Arrimayah Nurul Islam Horseba','Kukar',374,27,'2026-01-06 04:50:36'),(381,'Shortbow Pelajar SMA Putra - Jarak 15m',16,'Zaky Al Fahrizi','Rumah Belajar Archery Club','Samarinda',345,27,'2026-01-06 04:50:36'),(382,'Shortbow Pelajar SMA Putra - Jarak 15m',17,'Muhammad Dzakky Alkhairy','Al Azzam Rimayah Club','SANGATTA UTARA',329,27,'2026-01-06 04:50:36'),(383,'Shortbow Pelajar SMA Putra - Jarak 15m',18,'Muhammad Rizky Zailani','AL-Mahsyar Nurul Iman Archery','Tenggarong',326,27,'2026-01-06 04:50:36'),(384,'Shortbow Pelajar SMA Putra - Jarak 15m',19,'Muhammad Alfian Fadhil','AL AZHAR ARCHERY','Samarinda',323,27,'2026-01-06 04:50:36'),(385,'Shortbow Pelajar SMA Putra - Jarak 15m',20,'Furqon Ardian Noor','Spagrat Archey','Balikpapan',292,27,'2026-01-06 04:50:36'),(386,'Shortbow Pelajar SMA Putra - Jarak 15m',21,'MUHAMMAD ALVARIZAM ANNABI','SMP ISLAMIC CENTER','Samarinda',265,27,'2026-01-06 04:50:36'),(387,'Shortbow Pelajar SMA Putra - Jarak 15m',22,'Muhammad Afgan Al-Farizi','SD Muhammadiyah 4','Samarinda',203,27,'2026-01-06 04:50:36'),(388,'Shortbow Pelajar SMA Putra - Jarak 15m',23,'Khidhir Helmi','Madina archery','Samarinda',196,27,'2026-01-06 04:50:36'),(389,'Shortbow Pelajar SMA Putra - Jarak 15m',24,'HARIS ABIDUS SHOLEHUDIN','AL-MAHSYAR NURUL IMAN AR','TENGGARONG',185,27,'2026-01-06 04:50:36'),(390,'Shortbow Pelajar SMA Putra - Jarak 15m',25,'TEGAR DWI PRASETYA','AL-MAHSYAR NURUL IMAN AR','SAMARINDA',174,27,'2026-01-06 04:50:36'),(391,'Shortbow Pelajar SMA Putra - Jarak 15m',26,'Ahmad Fikri Khoirullah','Madina archery','Samarinda',147,27,'2026-01-06 04:50:36'),(392,'Shortbow Pelajar SMA Putra - Jarak 15m',27,'Farras wiraditya Pradana','Akademi Horsebow Sejati','Balikpapan',0,27,'2026-01-06 04:50:36'),(393,'Shortbow Pelajar SMA Putri - Jarak 15m',1,'AISYAH ARSAA RABBANI','Waqqash Archery Bontang','Bontang',530,35,'2026-01-06 04:50:36'),(394,'Shortbow Pelajar SMA Putri - Jarak 15m',2,'Denayu Khanza Ashila Nur Arief','Rumah Belajar Archery Club','Samarinda',503,35,'2026-01-06 04:50:36'),(395,'Shortbow Pelajar SMA Putri - Jarak 15m',3,'Aisha Labiba Trisnaputra','NFH ARCHERY','Samarinda',493,35,'2026-01-06 04:50:36'),(396,'Shortbow Pelajar SMA Putri - Jarak 15m',4,'Asya Alika Ramadhan','Rumah Belajar Archery Club','Samarinda',461,35,'2026-01-06 04:50:36'),(397,'Shortbow Pelajar SMA Putri - Jarak 15m',5,'Aurelia','Ar Rimayah Nurul Islam Horseb','Muara Jawa',421,35,'2026-01-06 04:50:36'),(398,'Shortbow Pelajar SMA Putri - Jarak 15m',6,'Denayu Kheiza Ashila Nur Arief','Rumah Belajar Archery Club','Samarinda',387,35,'2026-01-06 04:50:36'),(399,'Shortbow Pelajar SMA Putri - Jarak 15m',7,'Nayla prasasty','Minu Archery','Balikpapan',385,35,'2026-01-06 04:50:36'),(400,'Shortbow Pelajar SMA Putri - Jarak 15m',8,'Zahra Zylvani Nirwasita','Ma\'rifah Archery','Balikpapan',384,35,'2026-01-06 04:50:36'),(401,'Shortbow Pelajar SMA Putri - Jarak 15m',9,'Naurah Aqilah','Arrimayah Nurul Islam','Muara jawa',383,35,'2026-01-06 04:50:36'),(402,'Shortbow Pelajar SMA Putri - Jarak 15m',10,'Abidah Nazmi Zarifa','Al-Mahsyar Nurul Iman Archery','Tenggarong',382,35,'2026-01-06 04:50:36'),(403,'Shortbow Pelajar SMA Putri - Jarak 15m',11,'PUTRI NAYLA HUZNA','AL AZHAR ARCHERY','Samarinda',362,35,'2026-01-06 04:50:36'),(404,'Shortbow Pelajar SMA Putri - Jarak 15m',12,'Nur Rahma','Spagrat Archery','Balikpapan',359,35,'2026-01-06 04:50:36'),(405,'Shortbow Pelajar SMA Putri - Jarak 15m',13,'Syifa jamilah muthmainah','Akademi Horsebow Sejati','Balikpapan',353,35,'2026-01-06 04:50:36'),(406,'Shortbow Pelajar SMA Putri - Jarak 15m',14,'SHALZABILLA PUTRI LAZIM','AL-KATUM HORSEBOW ACADE','Samarinda',351,35,'2026-01-06 04:50:36'),(407,'Shortbow Pelajar SMA Putri - Jarak 15m',15,'Sabrina Septiana Widya Astuthy','Waqqash Archery Bontang','Bontang',344,35,'2026-01-06 04:50:36'),(408,'Shortbow Pelajar SMA Putri - Jarak 15m',16,'Alissya Nazwa maulidya','AL-KATUM HORSEBOW ACADE','Samarinda',321,35,'2026-01-06 04:50:36'),(409,'Shortbow Pelajar SMA Putri - Jarak 15m',17,'Nurazizah','Spagrat Archery','Balikpapan',315,35,'2026-01-06 04:50:36'),(410,'Shortbow Pelajar SMA Putri - Jarak 15m',18,'MAIZATU SHOFIYYA','AL KATUM HORSEBOW ACADE','Samarinda',302,35,'2026-01-06 04:50:36'),(411,'Shortbow Pelajar SMA Putri - Jarak 15m',19,'Maritza ratifa azka','Al Izzah Archery','Bontang',299,35,'2026-01-06 04:50:36'),(412,'Shortbow Pelajar SMA Putri - Jarak 15m',20,'TSURAYA ZAHIRAH BURHAN','AL-MAHSYAR NURUL IMAN AR','Samarinda',297,35,'2026-01-06 04:50:36'),(413,'Shortbow Pelajar SMA Putri - Jarak 15m',21,'Athifa Utari','Darussalam Archery Club','Samarinda',296,35,'2026-01-06 04:50:36'),(414,'Shortbow Pelajar SMA Putri - Jarak 15m',22,'Putri Puspithasari','AL-KATUM HORSEBOW ACADE','Samarinda',291,35,'2026-01-06 04:50:36'),(415,'Shortbow Pelajar SMA Putri - Jarak 15m',23,'Safa Alya Agustina','Ma\'rifah Archery','Balikpapan',287,35,'2026-01-06 04:50:36'),(416,'Shortbow Pelajar SMA Putri - Jarak 15m',24,'Annisa Septiana Ramadhani','Ma\'rifah Archery','Balikpapan',266,35,'2026-01-06 04:50:36'),(417,'Shortbow Pelajar SMA Putri - Jarak 15m',25,'SALWA AQILA OKTAVIA','AL-MAHSYAR NURUL IMAN AR','Samarinda',237,35,'2026-01-06 04:50:36'),(418,'Shortbow Pelajar SMA Putri - Jarak 15m',26,'DIFA SALSABILLA AZZAHRA','AL-MAHSYAR NURUL IMAN AR','TENGGARONG',235,35,'2026-01-06 04:50:36'),(419,'Shortbow Pelajar SMA Putri - Jarak 15m',27,'Vanissa Bunga Azhara','Ma\'rifah Archery','Balikpapan',229,35,'2026-01-06 04:50:36'),(420,'Shortbow Pelajar SMA Putri - Jarak 15m',28,'Nurruhama','Nurul Amin','Samarinda',193,35,'2026-01-06 04:50:36'),(421,'Shortbow Pelajar SMA Putri - Jarak 15m',29,'Puri Maulida Oktaviani','Rumah Belajar Archery Club','Samarinda',175,35,'2026-01-06 04:50:36'),(422,'Shortbow Pelajar SMA Putri - Jarak 15m',30,'Faristhaa Aurelia Zhafira','Rumah Belajar Archery Club','Samarinda',153,35,'2026-01-06 04:50:36'),(423,'Shortbow Pelajar SMA Putri - Jarak 15m',31,'Zaina Azzahira','Al-Mahsyar Nurul Iman Archery Club','Tenggarong',145,35,'2026-01-06 04:50:36'),(424,'Shortbow Pelajar SMA Putri - Jarak 15m',32,'NUR ASIFA SALSA MEILANI','AL-MAHSYAR NURUL IMAN','TENGGARONG',142,35,'2026-01-06 04:50:36'),(425,'Shortbow Pelajar SMA Putri - Jarak 15m',33,'jihan janeeta gamsir','Nurul Amin','Samarinda',0,35,'2026-01-06 04:50:36'),(426,'Shortbow Pelajar SMA Putri - Jarak 15m',34,'Khanza luthfiyah indiyani','Sumayyah grand archery','Balikpapan',0,35,'2026-01-06 04:50:36'),(427,'Shortbow Pelajar SMA Putri - Jarak 15m',35,'Selvira Aulia','Sitti Aminah','Kutai Kartanegara',0,35,'2026-01-06 04:50:36'),(428,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',1,'HARISTANG','Waqqash Archery Bontang','Polmas',521,12,'2026-01-06 04:50:36'),(429,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',2,'Friyan Ari Kusuma','FAKARCHERY','Samarinda',459,12,'2026-01-06 04:50:36'),(430,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',3,'Priyo','Gold Archery Samarinda','Samarinda',428,12,'2026-01-06 04:50:36'),(431,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',4,'Selviansyah','Perdana kaltim','Samarinda',425,12,'2026-01-06 04:50:36'),(432,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',5,'Didin Wahyudin','Granada Scout Archery Indones','Samarinda',412,12,'2026-01-06 04:50:36'),(433,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',6,'Muhammad Husin','Gold Archery Samarinda','Samarinda',402,12,'2026-01-06 04:50:36'),(434,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',7,'BURHANUDDIN','Gold Archery Samarinda','Samarinda',402,12,'2026-01-06 04:50:36'),(435,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',8,'Abu Zikri','Arrimayah Nurul Islam Horseba','Kukar',370,12,'2026-01-06 04:50:36'),(436,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',9,'Pandhu Dhitya AA','FAKARCHERY','Samarinda',357,12,'2026-01-06 04:50:36'),(437,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',10,'Andhi Trisnaputra','NFH ARCHERY','Samarinda',257,12,'2026-01-06 04:50:36'),(438,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',11,'Siko','Independent','Samarinda',0,12,'2026-01-06 04:50:36'),(439,'Shortbow NON Pelajar (Umum) Putra - Jarak 20m',12,'Achmed FS','Dhiya Rabbany Archery Mu\'Mini','Samarinda',0,12,'2026-01-06 04:50:36');
/*!40000 ALTER TABLE `rankings_source` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `score`
--

DROP TABLE IF EXISTS `score`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `score` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `category_id` int NOT NULL,
  `kegiatan_id` int NOT NULL,
  `peserta_id` int NOT NULL,
  `score` varchar(11) COLLATE utf8mb4_general_ci NOT NULL,
  `session` varchar(11) COLLATE utf8mb4_general_ci NOT NULL,
  `arrow` varchar(11) COLLATE utf8mb4_general_ci NOT NULL,
  `score_board_id` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_kb` (`score_board_id`),
  KEY `idx_ps` (`peserta_id`),
  KEY `idx_kg` (`kegiatan_id`),
  KEY `idx_score_peserta` (`peserta_id`),
  KEY `idx_score_kegiatan` (`kegiatan_id`)
) ENGINE=InnoDB AUTO_INCREMENT=37026 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `score`
--

LOCK TABLES `score` WRITE;
/*!40000 ALTER TABLE `score` DISABLE KEYS */;
INSERT INTO `score` VALUES (43,2,11,15,'1','1','1',8),(44,2,11,15,'2','1','2',8),(45,2,11,15,'3','1','3',8),(46,2,11,15,'10','2','1',8),(47,2,11,15,'x','2','2',8),(48,2,11,15,'3','2','3',8),(49,2,11,18,'10','1','1',8),(50,2,11,18,'5','1','2',8),(51,2,11,18,'10','1','3',8),(52,2,11,18,'x','2','1',8),(53,2,11,18,'x','2','2',8),(54,2,11,18,'x','2','3',8),(55,2,11,20,'x','1','1',8),(56,2,11,20,'x','1','2',8),(57,2,11,20,'x','1','3',8),(58,2,11,20,'x','2','1',8),(59,2,11,20,'x','2','2',8),(60,2,11,20,'5','2','3',8),(61,2,11,15,'x','3','1',8),(62,2,12,76,'1','1','1',12),(63,2,12,76,'2','1','2',12),(64,2,12,76,'m','1','3',12),(65,2,12,76,'6','1','4',12),(66,2,12,76,'1','1','5',12),(67,2,12,76,'3','1','6',12),(68,2,12,76,'3','2','1',12),(69,2,12,76,'3','2','2',12),(70,2,12,76,'4','2','3',12),(71,2,12,76,'3','2','4',12),(72,2,12,76,'1','2','5',12),(73,2,12,76,'1','2','6',12),(74,2,12,76,'3','3','1',12),(75,2,12,76,'3','3','2',12),(76,2,12,76,'4','3','3',12),(77,2,12,76,'5','3','4',12),(78,2,12,76,'6','3','5',12),(79,2,12,76,'5','3','6',12),(80,2,12,76,'1','4','1',12),(81,2,12,76,'1','4','2',12),(82,2,12,76,'1','4','3',12),(83,2,12,76,'2','4','4',12),(84,2,12,76,'3','4','5',12),(85,2,12,76,'4','4','6',12),(86,2,12,76,'6','5','1',12),(87,2,12,76,'6','5','2',12),(88,2,12,76,'6','5','3',12),(89,2,12,76,'6','5','4',12),(90,2,12,76,'2','5','5',12),(91,2,12,76,'1','5','6',12),(92,2,12,76,'4','6','1',12),(93,2,12,76,'5','6','2',12),(94,2,12,76,'3','6','3',12),(95,2,12,76,'2','6','4',12),(96,2,12,76,'1','6','5',12),(97,2,12,76,'1','6','6',12),(98,2,12,76,'1','7','1',12),(99,2,12,76,'5','7','2',12),(100,2,12,76,'6','7','3',12),(101,2,12,76,'1','7','4',12),(102,2,12,76,'5','7','5',12),(103,2,12,76,'6','7','6',12),(104,2,12,77,'4','1','1',12),(105,2,12,77,'2','1','2',12),(106,2,12,77,'4','1','3',12),(107,2,12,77,'3','1','4',12),(108,2,12,77,'4','1','5',12),(109,2,12,77,'4','1','6',12),(110,2,12,77,'1','2','1',12),(111,2,12,77,'4','2','2',12),(112,2,12,77,'5','2','3',12),(113,2,12,77,'4','2','4',12),(114,2,12,77,'3','2','5',12),(115,2,12,77,'4','2','6',12),(116,2,12,77,'6','3','2',12),(117,2,12,77,'5','3','1',12),(118,2,12,77,'6','3','3',12),(119,2,12,77,'5','3','4',12),(120,2,12,77,'4','3','5',12),(121,2,12,77,'3','3','6',12),(122,2,12,77,'2','4','1',12),(123,2,12,77,'3','4','2',12),(124,2,12,77,'4','4','3',12),(125,2,12,77,'4','4','4',12),(126,2,12,77,'3','4','5',12),(127,2,12,77,'2','4','6',12),(128,2,12,77,'4','5','1',12),(129,2,12,77,'3','5','2',12),(130,2,12,77,'5','5','4',12),(131,2,12,77,'4','5','3',12),(132,2,12,77,'4','5','5',12),(133,2,12,77,'3','5','6',12),(134,2,12,77,'2','6','1',12),(135,2,12,77,'4','6','2',12),(136,2,12,77,'5','6','3',12),(137,2,12,77,'6','6','4',12),(138,2,12,77,'5','6','5',12),(139,2,12,77,'4','6','6',12),(140,2,12,77,'3','7','1',12),(141,2,12,77,'4','7','2',12),(142,2,12,77,'3','7','3',12),(143,2,12,77,'4','7','4',12),(144,2,12,77,'4','7','5',12),(145,2,12,77,'3','7','6',12),(146,2,12,72,'4','1','1',12),(147,2,12,72,'4','1','2',12),(148,2,12,72,'4','1','3',12),(149,2,12,72,'4','1','4',12),(150,2,12,72,'4','1','5',12),(151,2,12,72,'4','1','6',12),(152,2,12,72,'4','2','1',12),(153,2,12,72,'4','2','2',12),(154,2,12,72,'4','2','3',12),(155,2,12,72,'4','2','4',12),(156,2,12,72,'4','2','5',12),(157,2,12,72,'4','2','6',12),(158,2,12,72,'4','3','1',12),(159,2,12,72,'4','3','2',12),(160,2,12,72,'4','3','3',12),(161,2,12,72,'4','3','4',12),(162,2,12,72,'4','3','5',12),(163,2,12,72,'4','3','6',12),(164,2,12,72,'4','4','1',12),(165,2,12,72,'4','4','2',12),(166,2,12,72,'4','4','3',12),(167,2,12,72,'3','4','4',12),(168,2,12,72,'3','4','5',12),(169,2,12,72,'3','4','6',12),(170,2,12,72,'3','5','1',12),(171,2,12,72,'3','5','2',12),(172,2,12,72,'3','5','3',12),(173,2,12,72,'3','5','4',12),(174,2,12,72,'3','5','5',12),(175,2,12,72,'3','5','6',12),(176,2,12,72,'2','6','1',12),(177,2,12,72,'2','6','2',12),(178,2,12,72,'2','6','3',12),(179,2,12,72,'2','6','4',12),(180,2,12,72,'2','6','5',12),(181,2,12,72,'2','6','6',12),(182,2,12,72,'2','7','1',12),(183,2,12,72,'1','7','2',12),(184,2,12,72,'1','7','3',12),(185,2,12,72,'1','7','4',12),(186,2,12,72,'1','7','5',12),(187,2,12,72,'1','7','6',12),(188,2,12,81,'3','1','1',12),(189,2,12,81,'3','1','2',12),(190,2,12,81,'3','1','3',12),(191,2,12,81,'2','1','4',12),(192,2,12,81,'5','1','5',12),(193,2,12,81,'4','1','6',12),(194,2,12,81,'3','2','1',12),(195,2,12,81,'2','2','2',12),(196,2,12,81,'4','2','4',12),(197,2,12,81,'5','2','3',12),(198,2,12,81,'3','2','6',12),(199,2,12,81,'3','2','5',12),(200,2,12,81,'3','3','1',12),(201,2,12,81,'3','3','2',12),(202,2,12,81,'3','3','3',12),(203,2,12,81,'3','3','4',12),(204,2,12,81,'3','3','5',12),(205,2,12,81,'3','3','6',12),(206,2,12,81,'3','4','1',12),(207,2,12,81,'3','4','2',12),(208,2,12,81,'3','4','3',12),(209,2,12,81,'3','4','4',12),(210,2,12,81,'3','4','5',12),(211,2,12,81,'3','4','6',12),(212,2,12,81,'2','5','1',12),(213,2,12,81,'2','5','2',12),(214,2,12,81,'2','5','3',12),(215,2,12,81,'2','5','4',12),(216,2,12,81,'2','5','5',12),(217,2,12,81,'2','5','6',12),(218,2,12,81,'2','6','1',12),(219,2,12,81,'2','6','2',12),(220,2,12,81,'2','6','3',12),(221,2,12,81,'2','6','4',12),(222,2,12,81,'2','6','5',12),(223,2,12,81,'2','6','6',12),(224,2,12,81,'2','7','1',12),(225,2,12,81,'2','7','2',12),(226,2,12,81,'2','7','3',12),(227,2,12,81,'2','7','4',12),(228,2,12,81,'2','7','5',12),(229,2,12,81,'2','7','6',12),(230,2,12,75,'6','1','1',12),(231,2,12,75,'6','1','2',12),(232,2,12,75,'6','1','3',12),(233,2,12,75,'6','1','4',12),(234,2,12,75,'6','1','5',12),(235,2,12,75,'6','1','6',12),(236,2,12,75,'6','2','1',12),(237,2,12,75,'6','2','2',12),(238,2,12,75,'6','2','3',12),(239,2,12,75,'6','2','4',12),(240,2,12,75,'6','2','5',12),(241,2,12,75,'6','2','6',12),(242,2,12,75,'6','3','1',12),(243,2,12,75,'6','3','2',12),(244,2,12,75,'6','3','3',12),(245,2,12,75,'6','3','4',12),(246,2,12,75,'6','3','5',12),(247,2,12,75,'6','3','6',12),(248,2,12,75,'6','4','1',12),(249,2,12,75,'6','4','2',12),(250,2,12,75,'6','4','3',12),(251,2,12,75,'6','4','4',12),(252,2,12,75,'6','4','5',12),(253,2,12,75,'6','4','6',12),(254,2,12,75,'6','5','1',12),(255,2,12,75,'6','5','2',12),(256,2,12,75,'6','5','3',12),(257,2,12,75,'6','5','4',12),(258,2,12,75,'6','5','5',12),(259,2,12,75,'6','5','6',12),(260,2,12,75,'6','6','1',12),(261,2,12,75,'6','6','2',12),(262,2,12,75,'6','6','3',12),(263,2,12,75,'6','6','4',12),(264,2,12,75,'6','6','5',12),(265,2,12,75,'6','6','6',12),(266,2,12,75,'6','7','1',12),(267,2,12,75,'6','7','2',12),(268,2,12,75,'6','7','3',12),(269,2,12,75,'6','7','4',12),(270,2,12,75,'6','7','5',12),(271,2,12,75,'6','7','6',12),(272,2,12,79,'5','1','1',12),(273,2,12,79,'5','1','2',12),(274,2,12,79,'5','1','3',12),(275,2,12,79,'5','1','4',12),(276,2,12,79,'5','1','5',12),(277,2,12,79,'5','1','6',12),(278,2,12,79,'5','2','1',12),(279,2,12,79,'5','2','2',12),(280,2,12,79,'5','2','3',12),(281,2,12,79,'5','2','4',12),(282,2,12,79,'5','2','5',12),(283,2,12,79,'5','2','6',12),(284,2,12,79,'5','3','1',12),(285,2,12,79,'5','3','2',12),(286,2,12,79,'5','3','3',12),(287,2,12,79,'5','3','4',12),(288,2,12,79,'5','3','5',12),(289,2,12,79,'5','3','6',12),(290,2,12,79,'5','4','1',12),(291,2,12,79,'5','4','2',12),(292,2,12,79,'5','4','3',12),(293,2,12,79,'5','4','4',12),(294,2,12,79,'5','4','5',12),(295,2,12,79,'5','4','6',12),(296,2,12,79,'5','5','1',12),(297,2,12,79,'5','5','2',12),(298,2,12,79,'5','5','3',12),(299,2,12,79,'5','5','4',12),(300,2,12,79,'5','5','5',12),(301,2,12,79,'5','5','6',12),(302,2,12,79,'5','6','1',12),(303,2,12,79,'5','6','2',12),(304,2,12,79,'5','6','3',12),(305,2,12,79,'5','6','4',12),(306,2,12,79,'5','6','5',12),(307,2,12,79,'5','6','6',12),(308,2,12,79,'5','7','1',12),(309,2,12,79,'5','7','2',12),(310,2,12,79,'5','7','3',12),(311,2,12,79,'5','7','4',12),(312,2,12,79,'5','7','5',12),(313,2,12,79,'5','7','6',12),(314,2,12,80,'4','1','1',12),(315,2,12,80,'4','1','2',12),(316,2,12,80,'4','1','3',12),(317,2,12,80,'4','1','4',12),(318,2,12,80,'5','1','5',12),(319,2,12,80,'5','1','6',12),(320,2,12,80,'5','2','1',12),(321,2,12,80,'5','2','2',12),(322,2,12,80,'4','2','3',12),(323,2,12,80,'4','2','4',12),(324,2,12,80,'4','2','5',12),(325,2,12,80,'3','2','6',12),(326,2,12,80,'3','3','1',12),(327,2,12,80,'3','3','2',12),(328,2,12,80,'3','3','3',12),(329,2,12,80,'3','3','4',12),(330,2,12,80,'5','3','5',12),(331,2,12,80,'5','3','6',12),(332,2,12,80,'5','4','1',12),(333,2,12,80,'5','4','2',12),(334,2,12,80,'5','4','3',12),(335,2,12,80,'5','4','4',12),(336,2,12,80,'4','4','5',12),(337,2,12,80,'4','4','6',12),(338,2,12,80,'4','5','1',12),(339,2,12,80,'4','5','2',12),(340,2,12,80,'6','5','3',12),(341,2,12,80,'6','5','4',12),(342,2,12,80,'6','5','5',12),(343,2,12,80,'6','5','6',12),(344,2,12,80,'6','6','1',12),(345,2,12,80,'6','6','2',12),(346,2,12,80,'6','6','3',12),(347,2,12,80,'6','6','4',12),(348,2,12,80,'6','6','5',12),(349,2,12,80,'6','6','6',12),(350,2,12,80,'6','7','1',12),(351,2,12,80,'6','7','2',12),(352,2,12,80,'6','7','3',12),(353,2,12,80,'6','7','4',12),(354,2,12,80,'6','7','5',12),(355,2,12,80,'6','7','6',12),(356,2,12,73,'6','1','1',12),(357,2,12,73,'6','1','2',12),(358,2,12,73,'6','1','3',12),(359,2,12,73,'6','1','4',12),(360,2,12,73,'6','1','5',12),(361,2,12,73,'6','1','6',12),(362,2,12,73,'6','2','1',12),(363,2,12,73,'6','2','2',12),(364,2,12,73,'6','2','3',12),(365,2,12,73,'6','2','4',12),(366,2,12,73,'6','2','5',12),(367,2,12,73,'6','2','6',12),(368,2,12,73,'6','3','1',12),(369,2,12,73,'6','3','2',12),(370,2,12,73,'6','3','3',12),(371,2,12,73,'6','3','4',12),(372,2,12,73,'6','3','5',12),(373,2,12,73,'6','3','6',12),(374,2,12,73,'6','4','1',12),(375,2,12,73,'6','4','2',12),(376,2,12,73,'6','4','3',12),(377,2,12,73,'6','4','4',12),(378,2,12,73,'6','4','5',12),(379,2,12,73,'6','4','6',12),(380,2,12,73,'5','5','1',12),(381,2,12,73,'5','5','2',12),(382,2,12,73,'5','5','3',12),(383,2,12,73,'5','5','4',12),(384,2,12,73,'5','5','5',12),(385,2,12,73,'5','5','6',12),(386,2,12,73,'5','6','1',12),(387,2,12,73,'5','6','2',12),(388,2,12,73,'5','6','3',12),(389,2,12,73,'5','6','4',12),(390,2,12,73,'5','6','5',12),(391,2,12,73,'5','6','6',12),(392,2,12,73,'0','7','1',12),(393,2,12,73,'0','7','2',12),(394,2,12,73,'0','7','3',12),(395,2,12,73,'0','7','4',12),(396,2,12,73,'4','7','5',12),(397,2,12,73,'4','7','6',12),(398,2,12,71,'5','1','1',12),(399,2,12,71,'5','1','2',12),(400,2,12,71,'5','1','3',12),(401,2,12,71,'5','1','4',12),(402,2,12,71,'5','1','5',12),(403,2,12,71,'5','1','6',12),(404,2,12,71,'5','2','1',12),(405,2,12,71,'5','2','2',12),(406,2,12,71,'5','2','3',12),(407,2,12,71,'5','2','4',12),(408,2,12,71,'5','2','5',12),(409,2,12,71,'5','2','6',12),(410,2,12,71,'5','3','1',12),(411,2,12,71,'5','3','2',12),(412,2,12,71,'5','3','3',12),(413,2,12,71,'4','3','4',12),(414,2,12,71,'4','3','5',12),(415,2,12,71,'4','3','6',12),(416,2,12,71,'4','4','1',12),(417,2,12,71,'4','4','2',12),(418,2,12,71,'4','4','3',12),(419,2,12,71,'3','4','4',12),(420,2,12,71,'3','4','5',12),(421,2,12,71,'3','4','6',12),(422,2,12,71,'3','5','1',12),(423,2,12,71,'3','5','2',12),(424,2,12,71,'3','5','3',12),(425,2,12,71,'3','5','4',12),(426,2,12,71,'2','5','5',12),(427,2,12,71,'2','5','6',12),(428,2,12,71,'2','6','1',12),(429,2,12,71,'2','6','2',12),(430,2,12,71,'2','6','3',12),(431,2,12,71,'2','6','4',12),(432,2,12,71,'6','6','5',12),(433,2,12,71,'6','6','6',12),(434,2,12,71,'6','7','1',12),(435,2,12,71,'6','7','2',12),(436,2,12,71,'6','7','3',12),(437,2,12,71,'6','7','4',12),(438,2,12,71,'6','7','5',12),(439,2,12,71,'6','7','6',12),(440,2,12,78,'5','1','1',12),(441,2,12,78,'5','1','2',12),(442,2,12,78,'5','1','3',12),(443,2,12,78,'5','1','4',12),(444,2,12,78,'5','1','5',12),(445,2,12,78,'4','1','6',12),(446,2,12,78,'4','2','1',12),(447,2,12,78,'4','2','2',12),(448,2,12,78,'4','2','3',12),(449,2,12,78,'5','2','4',12),(450,2,12,78,'3','2','5',12),(451,2,12,78,'3','2','6',12),(452,2,12,78,'3','3','1',12),(453,2,12,78,'3','3','2',12),(454,2,12,78,'3','3','3',12),(455,2,12,78,'3','3','4',12),(456,2,12,78,'3','3','6',12),(457,2,12,78,'4','3','5',12),(458,2,12,78,'5','4','1',12),(459,2,12,78,'5','4','2',12),(460,2,12,78,'5','4','3',12),(461,2,12,78,'5','4','4',12),(462,2,12,78,'4','4','5',12),(463,2,12,78,'4','4','6',12),(464,2,12,78,'4','5','1',12),(465,2,12,78,'4','5','2',12),(466,2,12,78,'4','5','3',12),(467,2,12,78,'4','5','4',12),(468,2,12,78,'3','5','5',12),(469,2,12,78,'3','5','6',12),(470,2,12,78,'3','6','1',12),(471,2,12,78,'3','6','2',12),(472,2,12,78,'3','6','3',12),(473,2,12,78,'3','6','4',12),(474,2,12,78,'2','6','5',12),(475,2,12,78,'3','6','6',12),(476,2,12,78,'2','7','1',12),(477,2,12,78,'3','7','2',12),(478,2,12,78,'2','7','3',12),(479,2,12,78,'3','7','4',12),(480,2,12,78,'2','7','5',12),(481,2,12,78,'3','7','6',12),(482,2,12,74,'4','1','1',12),(483,2,12,74,'4','1','2',12),(484,2,12,74,'4','1','3',12),(485,2,12,74,'4','1','4',12),(486,2,12,74,'4','1','5',12),(487,2,12,74,'4','1','6',12),(488,2,12,74,'4','2','1',12),(489,2,12,74,'4','2','2',12),(490,2,12,74,'4','2','3',12),(491,2,12,74,'4','2','4',12),(492,2,12,74,'4','2','5',12),(493,2,12,74,'4','2','6',12),(494,2,12,74,'4','3','1',12),(495,2,12,74,'4','3','2',12),(496,2,12,74,'4','3','3',12),(497,2,12,74,'4','3','4',12),(498,2,12,74,'4','3','5',12),(499,2,12,74,'4','3','6',12),(500,2,12,74,'4','4','1',12),(501,2,12,74,'4','4','2',12),(502,2,12,74,'4','4','3',12),(503,2,12,74,'4','4','4',12),(504,2,12,74,'4','4','5',12),(505,2,12,74,'4','4','6',12),(506,2,12,74,'4','5','1',12),(507,2,12,74,'4','5','2',12),(508,2,12,74,'4','5','3',12),(509,2,12,74,'4','5','4',12),(510,2,12,74,'4','5','5',12),(511,2,12,74,'4','5','6',12),(512,2,12,74,'4','6','1',12),(513,2,12,74,'4','6','2',12),(514,2,12,74,'4','6','3',12),(515,2,12,74,'4','6','4',12),(516,2,12,74,'4','6','5',12),(517,2,12,74,'4','6','6',12),(518,2,12,74,'4','7','1',12),(519,2,12,74,'4','7','2',12),(520,2,12,74,'4','7','3',12),(521,2,12,74,'4','7','4',12),(522,2,12,74,'4','7','5',12),(523,2,12,74,'4','7','6',12),(524,2,11,22,'','1','1',13),(526,2,12,76,'2','1','2',16),(527,2,12,76,'5','1','3',16),(528,2,12,76,'x','2','1',16),(529,2,12,76,'m','2','2',16),(530,2,12,76,'x','2','3',16),(532,2,12,76,'4','1','1',17),(533,2,12,76,'2','1','2',17),(534,2,12,76,'2','1','3',17),(535,2,12,76,'2','1','4',17),(536,2,12,76,'1','1','5',17),(537,2,12,76,'m','1','6',17),(538,2,12,76,'1','2','1',17),(539,2,12,76,'1','2','2',17),(540,2,12,76,'2','2','3',17),(541,2,12,76,'6','2','4',17),(542,2,12,76,'6','2','5',17),(543,2,12,76,'6','2','6',17),(544,2,12,76,'5','3','1',17),(545,2,12,76,'5','3','2',17),(546,2,12,76,'5','3','3',17),(547,2,12,76,'5','3','4',17),(548,2,12,76,'5','3','5',17),(549,2,12,76,'5','3','6',17),(550,2,12,76,'2','4','1',17),(551,2,12,76,'m','4','2',17),(552,2,12,76,'m','4','3',17),(553,2,12,76,'m','4','4',17),(554,2,12,76,'m','4','5',17),(555,2,12,76,'m','4','6',17),(556,2,12,76,'3','5','1',17),(557,2,12,76,'2','5','2',17),(558,2,12,76,'4','5','3',17),(559,2,12,76,'4','5','4',17),(560,2,12,76,'3','5','5',17),(561,2,12,76,'2','5','6',17),(562,2,12,76,'2','6','1',17),(563,2,12,76,'2','6','2',17),(564,2,12,76,'1','6','3',17),(565,2,12,76,'m','6','4',17),(566,2,12,76,'m','6','5',17),(567,2,12,76,'m','6','6',17),(568,2,12,76,'2','7','1',17),(569,2,12,76,'m','7','2',17),(570,2,12,77,'10','2','3',16),(571,2,12,76,'1','7','3',17),(572,2,12,76,'2','7','4',17),(573,2,12,76,'3','7','5',17),(574,2,12,76,'2','7','6',17),(575,2,12,77,'10','4','2',16),(576,2,12,77,'3','1','1',17),(577,2,12,77,'5','1','2',17),(578,2,12,77,'5','1','3',17),(579,2,12,77,'5','1','4',17),(580,2,12,77,'5','1','5',17),(581,2,12,77,'5','1','6',17),(582,2,12,77,'0','1','1',16),(583,2,12,72,'0','1','1',16),(584,2,12,81,'0','1','1',16),(585,2,12,75,'0','1','1',16),(586,2,12,79,'0','1','1',16),(587,2,12,80,'0','1','1',16),(588,2,12,73,'0','1','1',16),(589,2,12,71,'0','1','1',16),(590,2,12,78,'0','1','1',16),(591,2,12,74,'0','1','1',16),(592,2,12,72,'0','1','1',17),(593,2,12,81,'0','1','1',17),(594,2,12,75,'0','1','1',17),(595,2,12,79,'0','1','1',17),(596,2,12,80,'0','1','1',17),(597,2,12,73,'0','1','1',17),(598,2,12,71,'0','1','1',17),(599,2,12,78,'0','1','1',17),(600,2,12,74,'0','1','1',17),(601,40,13,110,'1','1','1',18),(602,40,13,111,'2','1','1',18),(603,40,13,112,'6','1','1',18),(604,40,13,108,'3','1','1',18),(605,40,13,109,'1','1','1',18),(606,40,13,115,'6','1','1',18),(607,40,13,113,'1','1','1',18),(608,40,13,114,'3','1','1',18),(609,40,13,116,'3','1','1',18),(610,40,13,110,'2','1','2',18),(611,40,13,110,'3','1','3',18),(612,40,13,110,'4','1','4',18),(613,40,13,110,'5','1','5',18),(614,40,13,110,'m','1','6',18),(615,40,13,110,'m','2','1',18),(616,40,13,110,'m','2','2',18),(617,40,13,110,'4','2','3',18),(618,40,13,110,'6','2','4',18),(619,40,13,110,'2','2','5',18),(620,40,13,110,'1','2','6',18),(621,40,13,110,'3','3','1',18),(622,40,13,110,'2','3','2',18),(623,40,13,110,'m','3','3',18),(624,40,13,110,'1','3','4',18),(625,40,13,110,'1','3','5',18),(626,40,13,110,'4','3','6',18),(627,40,13,110,'3','4','1',18),(628,40,13,110,'4','4','2',18),(629,40,13,110,'4','4','3',18),(630,40,13,110,'2','4','5',18),(631,40,13,110,'6','4','4',18),(632,40,13,110,'6','4','6',18),(633,40,13,110,'m','5','1',18),(634,40,13,110,'1','5','2',18),(635,40,13,110,'2','5','3',18),(636,40,13,110,'4','5','4',18),(637,40,13,110,'2','5','5',18),(638,40,13,110,'1','5','6',18),(639,40,13,110,'m','6','1',18),(640,40,13,110,'1','6','2',18),(641,40,13,110,'m','6','3',18),(642,40,13,110,'m','6','4',18),(643,40,13,110,'6','6','5',18),(644,40,13,110,'6','6','6',18),(645,40,13,110,'1','7','1',18),(646,40,13,110,'2','7','2',18),(647,40,13,110,'2','7','3',18),(648,40,13,110,'3','7','4',18),(649,40,13,110,'6','7','5',18),(650,40,13,110,'6','7','6',18),(651,40,13,111,'3','2','1',18),(652,40,13,111,'4','3','1',18),(653,40,13,111,'5','4','1',18),(654,40,13,111,'6','5','1',18),(655,40,13,111,'1','6','1',18),(656,40,13,111,'1','7','1',18),(657,40,13,111,'m','1','2',18),(658,40,13,111,'1','2','2',18),(659,40,13,111,'1','3','2',18),(660,40,13,111,'2','4','2',18),(661,40,13,111,'4','5','2',18),(662,40,13,111,'4','6','2',18),(663,3,12,85,'x','6','3',19),(664,40,13,111,'6','7','2',18),(665,40,13,111,'2','1','3',18),(666,40,13,111,'4','2','3',18),(667,40,13,111,'m','3','3',18),(668,40,13,111,'1','4','3',18),(669,40,13,111,'2','5','3',18),(670,40,13,111,'2','6','3',18),(671,40,13,111,'2','7','3',18),(672,40,13,111,'m','1','4',18),(673,40,13,111,'m','2','4',18),(674,40,13,111,'6','3','4',18),(675,40,13,111,'6','4','4',18),(676,40,13,111,'6','5','4',18),(677,40,13,111,'6','6','4',18),(678,40,13,111,'2','7','4',18),(679,40,13,111,'3','1','5',18),(680,40,13,111,'4','2','5',18),(681,40,13,111,'m','3','5',18),(682,40,13,111,'m','5','5',18),(683,40,13,111,'6','4','5',18),(684,40,13,111,'m','6','5',18),(685,40,13,111,'1','7','5',18),(686,40,13,111,'4','1','6',18),(687,40,13,111,'4','2','6',18),(688,40,13,111,'5','3','6',18),(689,40,13,111,'6','4','6',18),(690,40,13,111,'2','5','6',18),(691,40,13,111,'1','6','6',18),(692,40,13,111,'4','7','6',18),(693,40,13,112,'m','1','2',18),(694,40,13,112,'2','1','3',18),(695,40,13,112,'m','1','4',18),(696,40,13,112,'m','1','5',18),(697,40,13,112,'5','1','6',18),(698,40,13,112,'1','2','1',18),(699,40,13,112,'2','2','2',18),(700,40,13,112,'3','2','3',18),(701,40,13,112,'5','2','4',18),(702,40,13,112,'m','2','5',18),(703,40,13,112,'m','2','6',18),(704,40,13,112,'4','3','1',18),(705,40,13,112,'2','3','2',18),(706,40,13,112,'3','3','3',18),(707,40,13,112,'1','3','4',18),(708,40,13,112,'m','3','5',18),(709,40,13,112,'2','3','6',18),(710,40,13,112,'m','4','1',18),(711,40,13,112,'m','4','3',18),(712,40,13,112,'2','4','2',18),(713,40,13,112,'5','4','4',18),(714,40,13,112,'5','4','5',18),(715,40,13,112,'5','4','6',18),(716,40,13,112,'1','5','1',18),(717,40,13,112,'3','5','2',18),(718,40,13,112,'3','5','3',18),(719,40,13,112,'m','5','4',18),(720,40,13,112,'5','5','5',18),(721,40,13,112,'3','5','6',18),(722,40,13,112,'6','6','1',18),(723,40,13,112,'6','6','2',18),(724,40,13,112,'m','6','3',18),(725,40,13,112,'5','6','4',18),(726,40,13,112,'1','6','5',18),(727,40,13,112,'4','6','6',18),(728,40,13,112,'m','7','1',18),(729,40,13,112,'m','7','2',18),(730,40,13,112,'m','7','3',18),(731,40,13,112,'6','7','4',18),(732,40,13,112,'3','7','5',18),(733,40,13,112,'4','7','6',18),(734,40,13,108,'4','1','2',18),(735,40,13,108,'1','1','3',18),(736,40,13,108,'2','1','4',18),(737,40,13,108,'4','1','5',18),(738,40,13,108,'3','1','6',18),(739,40,13,108,'3','2','1',18),(740,40,13,108,'4','2','2',18),(741,40,13,108,'1','2','3',18),(742,40,13,108,'4','2','4',18),(743,40,13,108,'2','2','5',18),(744,40,13,108,'6','2','6',18),(745,40,13,108,'2','3','1',18),(746,40,13,108,'4','3','2',18),(747,40,13,108,'5','3','3',18),(748,40,13,108,'6','3','4',18),(749,40,13,108,'6','3','5',18),(750,40,13,108,'2','3','6',18),(751,40,13,108,'3','4','1',18),(752,40,13,108,'5','4','2',18),(753,40,13,108,'6','4','3',18),(754,40,13,108,'2','4','4',18),(755,40,13,108,'5','4','5',18),(756,40,13,108,'3','4','6',18),(757,40,13,108,' m','5','1',18),(758,40,13,108,'1','5','2',18),(759,40,13,108,'m','5','3',18),(760,40,13,108,'6','5','4',18),(761,40,13,108,'2','5','5',18),(762,40,13,108,'6','5','6',18),(763,40,13,108,'2','7','1',18),(764,40,13,108,'m','6','1',18),(765,40,13,108,'1','6','2',18),(766,40,13,108,'1','7','2',18),(767,40,13,108,'3','6','3',18),(768,40,13,108,'4','7','3',18),(769,40,13,108,'m','6','4',18),(770,40,13,108,'2','7','4',18),(771,40,13,108,'4','7','5',18),(772,40,13,108,'6','6','5',18),(773,40,13,108,'6','6','6',18),(774,40,13,108,'6','7','6',18),(775,40,13,109,'2','1','2',18),(776,40,13,109,'2','1','3',18),(777,40,13,109,'2','1','4',18),(778,40,13,109,'4','1','5',18),(779,40,13,109,'m','1','6',18),(781,40,13,109,'6','2','1',18),(782,40,13,109,'2','2','2',18),(783,40,13,109,'2','2','3',18),(784,40,13,109,'m','2','4',18),(785,40,13,109,'2','2','5',18),(786,40,13,109,'1','2','6',18),(787,40,13,109,'2','3','1',18),(788,40,13,109,'6','3','2',18),(789,40,13,109,'6','3','3',18),(790,40,13,109,'3','3','4',18),(791,40,13,109,'5','3','5',18),(792,40,13,109,' m','3','6',18),(793,40,13,109,'2','4','1',18),(794,40,13,109,'3','4','2',18),(795,40,13,109,'5','4','3',18),(796,40,13,109,'5','4','4',18),(797,40,13,109,'6','4','5',18),(798,40,13,109,' m','4','6',18),(800,40,13,109,'6','5','1',18),(801,40,13,109,'6','5','2',18),(802,40,13,109,'3','5','3',18),(803,40,13,109,'m','5','4',18),(804,40,13,109,'1','5','5',18),(805,40,13,109,'3','5','6',18),(806,40,13,109,'2','6','1',18),(807,40,13,109,'4','6','2',18),(808,40,13,109,'5','6','3',18),(809,40,13,109,'m','6','4',18),(810,40,13,109,'1','6','5',18),(811,40,13,109,'4','6','6',18),(812,40,13,109,'2','7','1',18),(813,40,13,109,'2','7','2',18),(814,40,13,109,'4','7','3',18),(815,40,13,109,'6','7','4',18),(816,40,13,109,'6','7','5',18),(817,40,13,109,'m','7','6',18),(818,40,13,115,'4','1','2',18),(819,40,13,115,'m','1','3',18),(820,40,13,115,'3','1','4',18),(821,40,13,115,'4','1','5',18),(822,40,13,115,'m','1','6',18),(823,40,13,115,'2','2','1',18),(824,40,13,115,'3','2','2',18),(825,40,13,115,'5','2','3',18),(826,40,13,115,'6','2','4',18),(827,40,13,115,' m','2','5',18),(828,40,13,115,'6','2','6',18),(829,40,13,115,'m','3','1',18),(830,40,13,115,'6','3','2',18),(831,40,13,115,'3','3','3',18),(832,40,13,115,'5','3','4',18),(834,40,13,115,'2','3','5',18),(835,40,13,115,'5','3','6',18),(836,40,13,115,'5','4','1',18),(837,40,13,115,'7','4','2',18),(838,40,13,115,'4','4','3',18),(839,40,13,115,'6','4','4',18),(840,40,13,115,'7','4','5',18),(841,40,13,115,'3','4','6',18),(842,40,13,115,'m','5','1',18),(843,40,13,115,'3','5','2',18),(844,40,13,115,'m','5','3',18),(846,40,13,115,'4','5','4',18),(847,40,13,115,'3','5','5',18),(848,40,13,115,'5','5','6',18),(849,40,13,115,'5','6','1',18),(850,40,13,115,'4','6','2',18),(851,40,13,115,'1','6','3',18),(852,40,13,115,'1','6','4',18),(853,40,13,115,'1','6','5',18),(855,40,13,115,'5','6','6',18),(856,40,13,115,'6','7','1',18),(857,40,13,115,'m','7','2',18),(858,40,13,115,'2','7','3',18),(859,40,13,115,'4','7','4',18),(860,40,13,115,'2','7','5',18),(861,40,13,115,'6','7','6',18),(862,40,13,116,'4','1','2',18),(863,40,13,116,'5','1','3',18),(864,40,13,116,'5','1','4',18),(865,40,13,116,'m','1','5',18),(866,40,13,116,'m','1','6',18),(867,40,13,116,'2','2','1',18),(868,40,13,116,'3','2','2',18),(869,40,13,116,'5','2','3',18),(870,40,13,116,'6','2','4',18),(872,40,13,116,'1','2','6',18),(873,40,13,116,'m','2','5',18),(874,40,13,116,'1','3','1',18),(875,40,13,116,'3','3','2',18),(876,40,13,116,'5','3','3',18),(877,40,13,116,'6','3','4',18),(878,40,13,116,'6','3','5',18),(880,40,13,116,'2','4','1',18),(881,40,13,116,'3','4','2',18),(882,40,13,116,'5','4','3',18),(883,40,13,116,'m','4','4',18),(884,40,13,116,'2','4','5',18),(886,40,13,116,'1','4','6',18),(887,40,13,116,'6','3','6',18),(888,40,13,116,'m','5','1',18),(889,40,13,116,'m','5','2',18),(890,40,13,116,'4','5','3',18),(891,40,13,116,'4','5','4',18),(892,40,13,116,'3','5','5',18),(893,40,13,116,'2','5','6',18),(894,40,13,116,'2','6','1',18),(895,40,13,116,'1','6','2',18),(896,40,13,116,'1','6','3',18),(897,40,13,116,'5','6','4',18),(898,40,13,116,'5','6','5',18),(899,40,13,116,'6','6','6',18),(900,40,13,116,'1','7','1',18),(901,40,13,116,'1','7','2',18),(902,40,13,116,'1','7','3',18),(903,40,13,116,'m','7','4',18),(904,40,13,116,'2','7','5',18),(905,40,13,116,'4','7','6',18),(906,40,13,114,'3','1','2',18),(907,40,13,114,'3','1','3',18),(908,40,13,114,'5','1','4',18),(909,40,13,114,'m','1','5',18),(910,40,13,114,'1','1','6',18),(911,40,13,114,'2','2','1',18),(912,40,13,114,'4','2','2',18),(913,40,13,114,'5','2','3',18),(914,40,13,114,'1','2','5',18),(915,40,13,114,'1','2','4',18),(916,40,13,114,'6','2','6',18),(917,40,13,114,'2','3','1',18),(918,40,13,114,'3','3','2',18),(919,40,13,114,'4','3','3',18),(921,40,13,114,'1','3','5',18),(922,40,13,114,'6','3','4',18),(923,40,13,114,'5','3','6',18),(924,40,13,114,'m','4','1',18),(925,40,13,114,'m','4','2',18),(926,40,13,114,'m','4','3',18),(927,40,13,114,'1','4','4',18),(928,40,13,114,'2','4','5',18),(929,40,13,114,'5','4','6',18),(930,40,13,114,'1','5','1',18),(931,40,13,114,'m','5','2',18),(932,40,13,114,'1','5','3',18),(933,40,13,114,'3','5','4',18),(934,40,13,114,'3','5','5',18),(935,40,13,114,'5','5','6',18),(936,40,13,114,'6','6','1',18),(937,40,13,114,'6','6','2',18),(938,40,13,114,'6','6','3',18),(939,40,13,114,'1','6','4',18),(940,40,13,114,'1','6','5',18),(941,40,13,114,'m','6','6',18),(942,40,13,114,'1','7','1',18),(943,40,13,114,'6','7','2',18),(944,40,13,114,'m','7','3',18),(945,40,13,114,'1','7','4',18),(946,40,13,114,'5','7','5',18),(947,40,13,114,'5','7','6',18),(948,40,13,113,'3','1','2',18),(949,40,13,113,'6','1','3',18),(950,40,13,113,'6','1','4',18),(951,40,13,113,'6','1','5',18),(952,40,13,113,'6','1','6',18),(953,40,13,113,'m','2','1',18),(954,40,13,113,'m','2','2',18),(955,40,13,113,'1','2','3',18),(956,40,13,113,'4','2','4',18),(957,40,13,113,'5','2','5',18),(958,40,13,113,'6','2','6',18),(959,40,13,113,'1','3','1',18),(960,40,13,113,'2','3','2',18),(961,40,13,113,'2','3','3',18),(962,40,13,113,'2','3','4',18),(963,40,13,113,'2','3','5',18),(964,40,13,113,'2','3','6',18),(965,40,13,113,'6','4','1',18),(966,40,13,113,'6','4','2',18),(967,40,13,113,'6','4','3',18),(968,40,13,113,'1','4','4',18),(969,40,13,113,'m','4','5',18),(970,40,13,113,'6','4','6',18),(971,40,13,113,'2','5','1',18),(972,40,13,113,'1','5','2',18),(973,40,13,113,'4','5','3',18),(974,40,13,113,'m','5','4',18),(975,40,13,113,'1','5','5',18),(976,40,13,113,'m','5','6',18),(977,40,13,113,'2','6','1',18),(978,40,13,113,'3','6','2',18),(979,40,13,113,'5','6','3',18),(980,40,13,113,'5','6','4',18),(981,40,13,113,'5','6','5',18),(982,40,13,113,'5','6','6',18),(983,40,13,113,'6','7','1',18),(984,40,13,113,'6','7','2',18),(985,40,13,113,'6','7','3',18),(986,40,13,113,'6','7','4',18),(987,40,13,113,'m','7','5',18),(989,40,13,113,'m','7','6',18),(991,2,11,18,'m','1','1',15),(992,2,11,20,'m','1','1',15),(993,2,11,22,'m','1','1',15),(994,2,11,69,'m','1','1',15),(995,2,11,535,'m','1','1',15),(996,2,11,21,'m','1','1',15),(997,2,11,16,'m','1','1',15),(998,2,11,23,'m','1','1',15),(999,2,11,17,'m','1','1',15),(1000,2,11,15,'m','1','1',14),(1001,2,11,18,'m','1','1',14),(1002,2,11,20,'m','1','1',14),(1003,2,11,22,'m','1','1',14),(1004,2,11,69,'m','1','1',14),(1005,2,11,535,'m','1','1',14),(1006,2,11,21,'m','1','1',14),(1007,2,11,16,'m','1','1',14),(1008,2,11,23,'m','1','1',14),(1009,2,11,17,'m','1','1',14),(1010,2,11,15,'m','1','1',9),(1011,2,11,18,'m','1','1',9),(1012,2,11,20,'m','1','1',9),(1013,2,11,22,'m','1','1',9),(1014,2,11,69,'m','1','1',9),(1015,2,11,535,'m','1','1',9),(1016,2,11,21,'m','1','1',9),(1017,2,11,16,'m','1','1',9),(1018,2,11,23,'m','1','1',9),(1019,2,11,17,'m','1','1',9),(1020,2,11,22,'m','1','1',8),(1021,2,11,69,'m','1','1',8),(1022,2,11,535,'m','1','1',8),(1023,2,11,21,'m','1','1',8),(1024,2,11,16,'m','1','1',8),(1025,2,11,23,'m','1','1',8),(1026,2,11,17,'m','1','1',8),(1036,40,13,110,'1','1','1',19),(1037,40,13,110,'m','2','1',19),(1038,40,13,110,'4','1','4',19),(1039,40,13,110,'2','1','2',19),(1040,40,13,110,'m','1','6',19),(1041,40,13,110,'5','1','5',19),(1042,40,13,110,'3','1','3',19),(1043,40,13,110,'m','2','2',19),(1044,40,13,110,'4','2','3',19),(1045,40,13,110,'6','2','4',19),(1046,40,13,110,'2','2','5',19),(1047,40,13,110,'1','2','6',19),(1048,40,13,110,'3','3','1',19),(1049,40,13,110,'2','3','2',19),(1050,40,13,110,'m','3','3',19),(1051,40,13,110,'1','3','4',19),(1052,40,13,110,'1','3','5',19),(1053,40,13,110,'4','3','6',19),(1054,40,13,110,'3','4','1',19),(1055,40,13,110,'4','4','2',19),(1056,40,13,110,'4','4','3',19),(1057,40,13,110,'6','4','4',19),(1058,40,13,110,'2','4','5',19),(1059,40,13,110,'6','4','6',19),(1060,40,13,110,'m','5','1',19),(1061,40,13,110,'1','5','2',19),(1062,40,13,110,'2','5','3',19),(1064,40,13,110,'4','5','4',19),(1065,40,13,110,'2','5','5',19),(1066,40,13,110,'1','5','6',19),(1067,40,13,110,'m','6','1',19),(1068,40,13,110,'1','6','2',19),(1069,40,13,110,'m','6','3',19),(1070,40,13,110,'m','6','4',19),(1071,40,13,110,'6','7','5',19),(1072,40,13,110,'1','7','1',19),(1073,40,13,110,'6','6','5',19),(1074,40,13,110,'2','7','2',19),(1075,40,13,110,'6','6','6',19),(1076,40,13,110,'2','7','3',19),(1077,40,13,110,'3','7','4',19),(1078,40,13,110,'6','7','6',19),(1079,40,13,111,'2','1','1',19),(1080,40,13,111,'m','1','2',19),(1081,40,13,111,'2','1','3',19),(1082,40,13,111,'m','1','4',19),(1083,40,13,111,'3','1','5',19),(1084,40,13,111,'4','1','6',19),(1085,40,13,111,'3','2','1',19),(1086,40,13,111,'1','2','2',19),(1087,40,13,111,'4','2','3',19),(1088,40,13,111,'4','3','1',19),(1089,40,13,111,'4','2','5',19),(1090,40,13,111,'m','2','4',19),(1091,40,13,111,'4','2','6',19),(1092,40,13,111,'1','3','2',19),(1093,40,13,111,'m','3','3',19),(1094,40,13,111,'6','3','4',19),(1095,40,13,111,'m','3','5',19),(1096,40,13,111,'5','3','6',19),(1098,40,13,111,'5','4','1',19),(1099,40,13,111,'2','4','2',19),(1100,40,13,111,'1','4','3',19),(1101,40,13,111,'6','4','4',19),(1102,40,13,111,'6','4','5',19),(1103,40,13,111,'6','4','6',19),(1104,40,13,111,'6','5','1',19),(1105,40,13,111,'4','5','2',19),(1106,40,13,111,'2','5','3',19),(1107,40,13,111,'6','5','4',19),(1108,40,13,111,'m','5','5',19),(1109,40,13,111,'2','5','6',19),(1110,40,13,111,'1','6','1',19),(1111,40,13,111,'4','6','2',19),(1112,40,13,111,'2','6','3',19),(1113,40,13,111,'6','6','4',19),(1114,40,13,111,'m','6','5',19),(1115,40,13,111,'1','6','6',19),(1116,40,13,111,'1','7','1',19),(1117,40,13,111,'6','7','2',19),(1118,40,13,111,'2','7','3',19),(1119,40,13,111,'2','7','4',19),(1120,40,13,111,'1','7','5',19),(1121,40,13,111,'4','7','6',19),(1122,40,13,112,'6','1','1',19),(1123,40,13,112,'m','1','2',19),(1125,40,13,112,'2','1','3',19),(1126,40,13,112,'m','1','4',19),(1127,40,13,112,'m','1','5',19),(1128,40,13,112,'5','1','6',19),(1129,40,13,112,'1','2','1',19),(1130,40,13,112,'2','2','2',19),(1131,40,13,112,'3','2','3',19),(1132,40,13,112,'5','2','4',19),(1133,40,13,112,'m','2','5',19),(1134,40,13,112,'m','2','6',19),(1135,40,13,112,'4','3','1',19),(1136,40,13,112,'2','3','2',19),(1137,40,13,112,'3','3','3',19),(1138,40,13,112,'1','3','4',19),(1139,40,13,112,'m','3','5',19),(1140,40,13,112,'2','3','6',19),(1141,40,13,112,'m','4','1',19),(1142,40,13,112,'2','4','2',19),(1143,40,13,112,'m','4','3',19),(1144,40,13,112,'5','4','4',19),(1145,40,13,112,'5','4','5',19),(1146,40,13,112,'5','4','6',19),(1147,40,13,112,'1','5','1',19),(1148,40,13,112,'3','5','2',19),(1149,40,13,112,'3','5','3',19),(1150,40,13,112,'m','5','4',19),(1151,40,13,112,'5','5','5',19),(1152,40,13,112,'3','5','6',19),(1153,40,13,112,'1','6','5',19),(1154,40,13,112,'6','6','1',19),(1155,40,13,112,'m','6','3',19),(1156,40,13,112,'6','6','2',19),(1157,40,13,112,'5','6','4',19),(1158,40,13,112,'4','6','6',19),(1159,40,13,112,'m','7','1',19),(1160,40,13,112,'m','7','2',19),(1161,40,13,112,'m','7','3',19),(1162,40,13,112,'6','7','4',19),(1163,40,13,112,'3','7','5',19),(1164,40,13,112,'4','7','6',19),(1165,40,13,108,'3','1','1',19),(1166,40,13,108,'4','1','2',19),(1167,40,13,108,'1','1','3',19),(1168,40,13,108,'2','1','4',19),(1169,40,13,108,'4','1','5',19),(1170,40,13,108,'3','1','6',19),(1171,40,13,108,'3','2','1',19),(1172,40,13,108,'4','2','2',19),(1173,40,13,108,'1','2','3',19),(1174,40,13,108,'4','2','4',19),(1175,40,13,108,'2','2','6',19),(1177,40,13,108,'2','2','5',19),(1178,40,13,108,'2','3','1',19),(1180,40,13,108,'5','3','3',19),(1181,40,13,108,'4','3','2',19),(1182,40,13,108,'6','3','4',19),(1183,40,13,108,'6','3','5',19),(1184,40,13,108,'2','3','6',19),(1185,40,13,108,'3','4','1',19),(1186,40,13,108,'5','4','2',19),(1187,40,13,108,'6','4','3',19),(1189,40,13,108,'5','4','5',19),(1191,40,13,108,'3','4','6',19),(1192,40,13,108,'2','4','4',19),(1193,40,13,108,'m','5','1',19),(1194,40,13,108,'1','5','2',19),(1195,40,13,108,'m','5','3',19),(1196,40,13,108,'6','5','4',19),(1197,40,13,108,'2','5','5',19),(1198,40,13,108,'6','5','6',19),(1199,40,13,108,'m','6','1',19),(1201,40,13,108,'1','6','2',19),(1202,40,13,108,'3','6','3',19),(1203,40,13,108,'6','6','5',19),(1204,40,13,108,'6','6','6',19),(1205,40,13,108,'m','6','4',19),(1206,40,13,108,'2','7','1',19),(1207,40,13,108,'1','7','2',19),(1208,40,13,108,'4','7','3',19),(1210,40,13,108,'2','7','4',19),(1211,40,13,108,'4','7','5',19),(1212,40,13,108,'6','7','6',19),(1214,40,13,109,'1','1','1',19),(1215,40,13,109,'2','1','2',19),(1216,40,13,109,'2','1','3',19),(1217,40,13,109,'2','1','4',19),(1218,40,13,109,'4','1','5',19),(1219,40,13,109,'m','1','6',19),(1220,40,13,109,'6','2','1',19),(1221,40,13,109,'2','2','2',19),(1222,40,13,109,'2','2','3',19),(1223,40,13,109,'m','2','4',19),(1224,40,13,109,'2','2','5',19),(1225,40,13,109,'1','2','6',19),(1226,40,13,109,'2','3','1',19),(1227,40,13,109,'6','3','2',19),(1228,40,13,109,'6','3','3',19),(1229,40,13,109,'3','3','4',19),(1230,40,13,109,'5','3','5',19),(1231,40,13,109,'5','4','3',19),(1232,40,13,109,'m','3','6',19),(1233,40,13,109,'3','4','2',19),(1234,40,13,109,'2','4','1',19),(1235,40,13,109,'5','4','4',19),(1236,40,13,109,'6','4','5',19),(1237,40,13,109,'m','4','6',19),(1238,40,13,109,'6','5','1',19),(1239,40,13,109,'6','5','2',19),(1241,40,13,109,'3','5','3',19),(1242,40,13,109,'m','5','4',19),(1243,40,13,109,'1','5','5',19),(1244,40,13,109,'3','5','6',19),(1245,40,13,109,'2','6','1',19),(1246,40,13,109,'4','6','2',19),(1247,40,13,109,'5','6','3',19),(1248,40,13,109,'m','6','4',19),(1249,40,13,109,'1','6','5',19),(1250,40,13,109,'4','6','6',19),(1251,40,13,109,'2','7','1',19),(1252,40,13,109,'2','7','2',19),(1253,40,13,109,'4','7','3',19),(1254,40,13,109,'6','7','4',19),(1255,40,13,109,'6','7','5',19),(1256,40,13,109,'m','7','6',19),(1257,40,13,115,'6','1','1',19),(1258,40,13,115,'4','1','2',19),(1259,40,13,115,'m','1','3',19),(1260,40,13,115,'3','1','4',19),(1261,40,13,115,'4','1','5',19),(1262,40,13,115,'m','1','6',19),(1263,40,13,115,'2','2','1',19),(1264,40,13,115,'3','2','2',19),(1265,40,13,115,'5','2','3',19),(1266,40,13,115,'6','2','4',19),(1267,40,13,115,'m','2','5',19),(1269,40,13,115,'6','2','6',19),(1270,40,13,115,'m','3','1',19),(1271,40,13,115,'6','3','2',19),(1272,40,13,115,'3','3','3',19),(1273,40,13,115,'5','3','4',19),(1274,40,13,115,'2','3','5',19),(1275,40,13,115,'5','3','6',19),(1276,40,13,115,'5','4','1',19),(1277,40,13,115,'7','4','2',19),(1278,40,13,115,'4','4','3',19),(1279,40,13,115,'6','4','4',19),(1283,40,13,115,'7','4','5',19),(1284,40,13,115,'3','4','6',19),(1285,40,13,115,'m','5','1',19),(1288,40,13,115,'3','5','2',19),(1289,40,13,115,'m','5','3',19),(1290,40,13,115,'4','5','4',19),(1291,40,13,115,'3','5','5',19),(1292,40,13,115,'5','5','6',19),(1293,40,13,115,'5','6','1',19),(1294,40,13,115,'4','6','2',19),(1295,40,13,115,'1','6','3',19),(1296,40,13,115,'1','6','4',19),(1297,40,13,115,'1','6','5',19),(1298,40,13,115,'5','6','6',19),(1299,40,13,115,'6','7','6',19),(1300,40,13,115,'6','7','1',19),(1301,40,13,115,'m','7','2',19),(1302,40,13,115,'2','7','3',19),(1303,40,13,115,'4','7','4',19),(1304,40,13,115,'2','7','5',19),(1305,40,13,113,'1','1','1',19),(1306,40,13,113,'6','1','3',19),(1307,40,13,113,'3','1','2',19),(1308,40,13,113,'6','1','4',19),(1309,40,13,113,'6','1','5',19),(1310,40,13,113,'6','1','6',19),(1311,40,13,113,'m','2','1',19),(1312,40,13,113,'m','2','2',19),(1313,40,13,113,'1','2','3',19),(1314,40,13,113,'4','2','4',19),(1315,40,13,113,'5','2','5',19),(1316,40,13,113,'6','2','6',19),(1317,40,13,113,'1','3','1',19),(1318,40,13,113,'2','3','2',19),(1319,40,13,113,'2','3','3',19),(1320,40,13,113,'6','4','3',19),(1321,40,13,113,'2','3','4',19),(1322,40,13,113,'2','3','6',19),(1323,40,13,113,'2','3','5',19),(1324,40,13,113,'6','4','2',19),(1325,40,13,113,'6','4','1',19),(1326,40,13,113,'1','4','4',19),(1327,40,13,113,'m','4','5',19),(1328,40,13,113,'6','4','6',19),(1329,40,13,113,'2','5','1',19),(1330,40,13,113,'1','5','2',19),(1331,40,13,113,'4','5','3',19),(1332,40,13,113,'m','5','4',19),(1333,40,13,113,'1','5','5',19),(1334,40,13,113,'m','5','6',19),(1336,40,13,113,'2','6','1',19),(1337,40,13,113,'3','6','2',19),(1338,40,13,113,'5','6','3',19),(1339,40,13,113,'5','6','4',19),(1340,40,13,113,'5','6','5',19),(1342,40,13,113,'5','6','6',19),(1343,40,13,113,'6','7','2',19),(1344,40,13,113,'6','7','1',19),(1345,40,13,113,'6','7','3',19),(1346,40,13,113,'6','7','4',19),(1347,40,13,113,'m','7','5',19),(1348,40,13,113,'m','7','6',19),(1349,40,13,114,'3','1','1',19),(1350,40,13,114,'3','1','2',19),(1351,40,13,114,'3','1','3',19),(1352,40,13,114,'5','1','4',19),(1353,40,13,114,'m','1','5',19),(1354,40,13,114,'1','1','6',19),(1355,40,13,114,'2','2','1',19),(1356,40,13,114,'5','2','3',19),(1357,40,13,114,'4','2','2',19),(1358,40,13,114,'1','2','4',19),(1359,40,13,114,'1','2','5',19),(1360,40,13,114,'6','2','6',19),(1361,40,13,114,'2','3','1',19),(1362,40,13,114,'3','3','2',19),(1363,40,13,114,'4','3','3',19),(1364,40,13,114,'6','3','4',19),(1365,40,13,114,'1','3','5',19),(1366,40,13,114,'5','3','6',19),(1367,40,13,114,'m','4','1',19),(1368,40,13,114,'m','4','2',19),(1369,40,13,114,'m','4','3',19),(1370,40,13,114,'1','4','4',19),(1371,40,13,114,'2','4','5',19),(1372,40,13,114,'5','4','6',19),(1373,40,13,114,'1','5','1',19),(1374,40,13,114,'m','5','2',19),(1375,40,13,114,'1','5','3',19),(1376,40,13,114,'3','5','4',19),(1377,40,13,114,'3','5','5',19),(1378,40,13,114,'5','5','6',19),(1379,40,13,114,'6','6','1',19),(1380,40,13,114,'6','6','2',19),(1381,40,13,114,'6','6','3',19),(1382,40,13,114,'1','6','4',19),(1384,40,13,114,'m','7','3',19),(1385,40,13,114,'1','6','5',19),(1386,40,13,114,'1','7','1',19),(1387,40,13,114,'6','7','2',19),(1388,40,13,114,'m','6','6',19),(1389,40,13,114,'1','7','4',19),(1390,40,13,114,'5','7','5',19),(1391,40,13,114,'5','7','6',19),(1392,40,13,116,'3','1','1',19),(1393,40,13,116,'4','1','2',19),(1394,40,13,116,'5','1','3',19),(1395,40,13,116,'5','1','4',19),(1396,40,13,116,'m','1','5',19),(1397,40,13,116,'m','1','6',19),(1398,40,13,116,'2','2','1',19),(1399,40,13,116,'3','2','2',19),(1400,40,13,116,'5','2','3',19),(1401,40,13,116,'6','2','4',19),(1403,40,13,116,'m','2','5',19),(1404,40,13,116,'1','2','6',19),(1405,40,13,116,'1','3','1',19),(1406,40,13,116,'3','3','2',19),(1407,40,13,116,'5','3','3',19),(1408,40,13,116,'6','3','4',19),(1409,40,13,116,'6','3','5',19),(1410,40,13,116,'6','3','6',19),(1411,40,13,116,'2','4','1',19),(1412,40,13,116,'3','4','2',19),(1413,40,13,116,'5','4','3',19),(1414,40,13,116,'m','4','4',19),(1415,40,13,116,'2','4','5',19),(1416,40,13,116,'1','4','6',19),(1417,40,13,116,'m','5','1',19),(1418,40,13,116,'m','5','2',19),(1419,40,13,116,'4','5','3',19),(1420,40,13,116,'4','5','4',19),(1421,40,13,116,'3','5','5',19),(1422,40,13,116,'2','5','6',19),(1423,40,13,116,'2','6','1',19),(1424,40,13,116,'1','6','2',19),(1425,40,13,116,'1','6','3',19),(1426,40,13,116,'5','6','4',19),(1427,40,13,116,'5','6','5',19),(1428,40,13,116,'6','6','6',19),(1429,40,13,116,'1','7','1',19),(1430,40,13,116,'1','7','2',19),(1431,40,13,116,'1','7','3',19),(1432,40,13,116,'m','7','4',19),(1433,40,13,116,'2','7','5',19),(1434,40,13,116,'4','7','6',19),(1435,39,13,101,'0','1','1',20),(1436,39,13,16,'0','1','1',20),(1437,39,13,104,'0','1','1',20),(1438,39,13,96,'0','1','1',20),(1439,39,13,538,'0','1','1',20),(1440,39,13,100,'0','1','1',20),(1441,39,13,94,'0','1','1',20),(1442,39,13,106,'0','1','1',20),(1443,39,13,92,'0','1','1',20),(1444,39,13,103,'0','1','1',20),(1445,39,13,90,'0','1','1',20),(1446,39,13,102,'0','1','1',20),(1447,39,13,107,'0','1','1',20),(1448,39,13,97,'0','1','1',20),(1449,39,13,105,'0','1','1',20),(1450,39,13,93,'0','1','1',20),(1451,39,13,98,'0','1','1',20),(1452,39,13,99,'0','1','1',20),(1453,39,13,101,'3','1','1',21),(1455,39,13,104,'0','1','1',21),(1456,39,13,96,'0','1','1',21),(1457,39,13,538,'0','1','1',21),(1458,39,13,100,'0','1','1',21),(1459,39,13,94,'0','1','1',21),(1460,39,13,106,'0','1','1',21),(1461,39,13,92,'0','1','1',21),(1462,39,13,103,'0','1','1',21),(1463,39,13,90,'0','1','1',21),(1464,39,13,102,'0','1','1',21),(1465,39,13,107,'0','1','1',21),(1466,39,13,97,'0','1','1',21),(1467,39,13,105,'0','1','1',21),(1468,39,13,93,'0','1','1',21),(1469,39,13,98,'0','1','1',21),(1470,39,13,99,'0','1','1',21),(1471,39,13,101,'2','1','2',21),(1472,39,13,101,'m','1','3',21),(1473,39,13,101,'1','2','1',21),(1474,39,13,101,'3','2','2',21),(1475,39,13,101,'5','2','3',21),(1476,39,13,101,'3','3','1',21),(1477,39,13,101,'4','3','2',21),(1478,39,13,101,'4','3','3',21),(1479,39,13,101,'3','4','1',21),(1480,39,13,101,'3','4','2',21),(1481,39,13,101,'2','4','3',21),(1482,39,13,101,'6','5','1',21),(1483,39,13,101,'4','5','2',21),(1484,39,13,101,'2','5','3',21),(1485,39,13,101,'m','6','2',21),(1486,39,13,101,'2','6','1',21),(1487,39,13,101,'3','6','3',21),(1488,39,13,101,'3','7','1',21),(1489,39,13,101,'2','7','2',21),(1490,39,13,101,'5','7','3',21),(1491,39,13,101,'5','8','3',21),(1493,39,13,101,'2','8','1',21),(1494,39,13,101,'m','9','1',21),(1495,39,13,101,'m','9','2',21),(1496,39,13,101,'3','8','2',21),(1497,39,13,101,'m','9','3',21),(1500,39,13,16,'m','1','1',21),(1501,39,13,16,'4','1','2',21),(1502,39,13,16,'7','1','3',21),(1503,39,13,16,'6','2','1',21),(1504,39,13,16,'5','2','2',21),(1505,39,13,16,'4','2','3',21),(1506,40,13,118,'0','1','1',19),(1507,40,13,117,'0','1','1',19),(1508,40,13,110,'0','1','1',22),(1509,40,13,121,'0','1','1',22),(1510,40,13,111,'0','1','1',22),(1511,40,13,112,'0','1','1',22),(1512,40,13,108,'0','1','1',22),(1513,40,13,109,'0','1','1',22),(1514,40,13,117,'0','1','1',22),(1515,40,13,115,'0','1','1',22),(1516,40,13,113,'0','1','1',22),(1517,40,13,114,'0','1','1',22),(1518,40,13,116,'0','1','1',22),(1519,39,13,101,'0','1','1',23),(1520,39,13,16,'0','1','1',23),(1521,39,13,104,'0','1','1',23),(1522,39,13,96,'0','1','1',23),(1523,39,13,538,'0','1','1',23),(1524,39,13,100,'0','1','1',23),(1525,39,13,119,'0','1','1',23),(1526,39,13,94,'0','1','1',23),(1527,39,13,106,'0','1','1',23),(1528,39,13,92,'0','1','1',23),(1529,39,13,103,'0','1','1',23),(1530,39,13,90,'0','1','1',23),(1531,39,13,122,'0','1','1',23),(1532,39,13,102,'0','1','1',23),(1533,39,13,107,'0','1','1',23),(1534,39,13,97,'0','1','1',23),(1535,39,13,105,'0','1','1',23),(1536,39,13,120,'0','1','1',23),(1537,39,13,93,'0','1','1',23),(1538,39,13,98,'0','1','1',23),(1539,39,13,99,'0','1','1',23),(1540,39,13,101,'0','1','1',24),(1541,39,13,16,'0','1','1',24),(1542,39,13,104,'3','1','1',24),(1543,39,13,96,'0','1','1',24),(1544,39,13,538,'0','1','1',24),(1545,39,13,100,'4','1','1',24),(1546,39,13,119,'0','1','1',24),(1547,39,13,94,'0','1','1',24),(1548,39,13,106,'0','1','1',24),(1549,39,13,92,'4','1','1',24),(1550,39,13,103,'0','1','1',24),(1551,39,13,90,'0','1','1',24),(1552,39,13,122,'0','1','1',24),(1553,39,13,102,'0','1','1',24),(1554,39,13,107,'0','1','1',24),(1555,39,13,97,'0','1','1',24),(1556,39,13,105,'0','1','1',24),(1557,39,13,120,'0','1','1',24),(1558,39,13,93,'0','1','1',24),(1559,39,13,98,'0','1','1',24),(1560,39,13,99,'0','1','1',24),(1561,39,13,104,'3','1','2',24),(1562,39,13,104,'3','1','3',24),(1563,39,13,104,'1','1','4',24),(1564,39,13,104,'m','1','5',24),(1565,39,13,104,'m','1','6',24),(1566,39,13,92,'3','1','2',24),(1567,39,13,92,'m','1','3',24),(1568,39,13,92,'m','1','4',24),(1569,39,13,92,'m','1','5',24),(1570,39,13,92,'m','1','6',24),(1571,39,13,92,'m','2','2',24),(1572,39,13,92,'m','2','1',24),(1573,39,13,92,'m','2','3',24),(1574,39,13,92,'m','2','4',24),(1575,39,13,92,'m','2','5',24),(1576,39,13,92,'m','2','6',24),(1577,39,13,100,'4','2','1',24),(1578,39,13,100,'1','2','2',24),(1579,39,13,104,'4','2','1',24),(1580,39,13,104,'1','2','2',24),(1581,39,13,101,'0','1','1',25),(1583,39,13,104,'3','1','1',25),(1585,39,13,538,'0','1','1',25),(1586,39,13,100,'4','1','1',25),(1587,39,13,124,'6','1','1',25),(1589,39,13,94,'0','1','1',25),(1590,39,13,106,'0','1','1',25),(1591,39,13,92,'4','1','1',25),(1592,39,13,103,'0','1','1',25),(1598,39,13,105,'0','1','1',25),(1601,39,13,98,'0','1','1',25),(1603,39,13,104,'3','1','2',25),(1604,39,13,104,'3','1','3',25),(1605,39,13,104,'1','1','4',25),(1606,39,13,104,'m','1','5',25),(1607,39,13,104,'m','1','6',25),(1608,39,13,104,'4','2','1',25),(1609,39,13,104,'1','2','2',25),(1610,39,13,104,'m','2','3',25),(1611,39,13,104,'3','3','1',25),(1612,39,13,104,'2','3','2',25),(1613,39,13,104,'2','3','3',25),(1614,39,13,104,'1','3','4',25),(1615,39,13,104,'m','3','5',25),(1616,39,13,104,'m','3','6',25),(1617,39,13,124,'m','1','2',25),(1618,39,13,124,'4','2','1',25),(1619,39,13,124,'1','2','2',25),(1620,39,13,124,'m','2','3',25),(1621,39,13,92,'3','1','2',25),(1622,39,13,92,'m','1','3',25),(1623,39,13,92,'m','1','4',25),(1624,39,13,92,'m','1','5',25),(1625,39,13,92,'m','1','6',25),(1626,39,13,92,'m','2','6',25),(1627,39,13,92,'m','2','5',25),(1628,39,13,92,'m','2','3',25),(1629,39,13,92,'m','2','4',25),(1630,39,13,92,'m','2','1',25),(1631,39,13,92,'m','2','2',25),(1632,39,13,92,'2','3','1',25),(1633,39,13,92,'3','3','2',25),(1634,39,13,92,'2','3','3',25),(1635,39,13,92,'2','3','4',25),(1636,39,13,92,'1','3','5',25),(1637,39,13,92,'m','3','6',25),(1638,39,13,100,'4','2','1',25),(1639,39,13,100,'1','2','2',25),(1640,39,13,100,'6','3','1',25),(1642,40,13,121,'0','1','1',26),(1643,40,13,111,'0','1','1',26),(1644,40,13,108,'0','1','1',26),(1645,40,13,123,'0','1','1',26),(1646,40,13,109,'0','1','1',26),(1647,40,13,115,'0','1','1',26),(1648,40,13,113,'0','1','1',26),(1649,40,13,114,'0','1','1',26),(1650,40,13,116,'0','1','1',26),(1651,39,13,92,'4','4','1',25),(1652,39,13,92,'3','4','2',25),(1653,39,13,92,'3','4','3',25),(1654,39,13,92,'3','4','4',25),(1655,39,13,92,'2','4','5',25),(1656,39,13,92,'m','4','6',25),(1657,39,13,100,'3','4','1',25),(1658,39,13,100,'2','4','2',25),(1660,39,13,90,'m','1','1',25),(1661,39,13,90,'m','1','2',25),(1662,39,13,90,'m','1','3',25),(1663,39,13,90,'m','1','4',25),(1664,39,13,90,'m','1','5',25),(1665,39,13,90,'m','1','6',25),(1666,39,13,90,'4','2','1',25),(1667,39,13,90,'4','2','2',25),(1668,39,13,90,'m','2','3',25),(1669,39,13,90,'m','2','4',25),(1670,39,13,90,'m','2','5',25),(1671,39,13,90,'m','2','6',25),(1672,39,13,90,'3','3','1',25),(1673,39,13,90,'1','4','1',25),(1674,39,13,90,'m','3','2',25),(1675,39,13,90,'m','3','3',25),(1676,39,13,90,'m','3','4',25),(1677,39,13,90,'m','3','5',25),(1678,39,13,90,'m','3','6',25),(1679,39,13,104,'3','4','1',25),(1680,39,13,104,'3','4','2',25),(1681,39,13,104,'3','4','3',25),(1682,39,13,104,'2','4','4',25),(1683,39,13,104,'2','4','5',25),(1684,39,13,104,'m','4','6',25),(1685,39,13,104,'4','5','1',25),(1686,39,13,104,'2','5','2',25),(1687,39,13,104,'2','5','3',25),(1688,39,13,104,'1','5','4',25),(1689,39,13,104,'m','5','5',25),(1690,39,13,104,'1','5','6',25),(1691,39,13,124,'m','3','1',25),(1692,39,13,124,'4','4','1',25),(1693,39,13,124,'3','4','2',25),(1694,39,13,124,'1','4','3',25),(1695,39,13,124,'m','4','4',25),(1696,39,13,124,'m','4','5',25),(1697,39,13,124,'m','4','6',25),(1698,39,13,92,'6','5','1',25),(1699,39,13,92,'m','5','2',25),(1700,39,13,92,'m','5','3',25),(1701,39,13,92,'m','5','4',25),(1702,39,13,92,'m','5','5',25),(1704,39,13,100,'5','5','1',25),(1705,39,13,100,'4','5','2',25),(1706,39,13,100,'3','5','3',25),(1707,39,13,90,'m','4','2',25),(1708,39,13,90,'m','4','3',25),(1709,39,13,90,'m','4','4',25),(1710,39,13,90,'m','4','5',25),(1711,39,13,90,'m','4','6',25),(1712,39,13,90,'4','5','1',25),(1713,39,13,90,'m','5','2',25),(1714,39,13,90,'m','5','3',25),(1715,39,13,90,'m','5','4',25),(1716,39,13,90,'m','5','5',25),(1717,39,13,125,'2','1','1',25),(1718,39,13,124,'3','5','1',25),(1719,39,13,124,'3','5','2',25),(1720,39,13,124,'2','5','3',25),(1721,39,13,124,'4','5','4',25),(1722,39,13,124,'m','5','5',25),(1724,39,13,104,'3','6','1',25),(1725,39,13,104,'2','6','2',25),(1726,39,13,104,'2','6','3',25),(1727,39,13,104,'1','6','4',25),(1728,39,13,104,'1','6','5',25),(1729,39,13,104,'1','6','6',25),(1730,39,13,92,'5','6','1',25),(1731,39,13,92,'3','6','2',25),(1732,39,13,92,'2','6','3',25),(1733,39,13,92,'2','6','4',25),(1734,39,13,92,'1','6','5',25),(1735,39,13,92,'m','6','6',25),(1736,39,13,100,'3','6','1',25),(1737,39,13,100,'3','6','2',25),(1738,39,13,100,'1','6','3',25),(1739,39,13,90,'5','6','1',25),(1740,39,13,90,'m','6','2',25),(1741,39,13,90,'m','6','3',25),(1742,39,13,90,'m','6','4',25),(1743,39,13,90,'m','6','5',25),(1744,39,13,90,'m','6','6',25),(1745,39,13,125,'1','1','2',25),(1746,39,13,125,'m','1','3',25),(1747,39,13,125,'m','1','4',25),(1748,39,13,125,'m','1','5',25),(1749,39,13,125,'m','1','6',25),(1752,39,13,125,'1','2','2',25),(1753,39,13,125,'2','2','1',25),(1754,39,13,125,'m','2','3',25),(1755,39,13,125,'m','2','4',25),(1756,39,13,125,'m','2','5',25),(1757,39,13,125,'m','2','6',25),(1758,39,13,125,'4','3','1',25),(1759,39,13,125,'3','3','2',25),(1760,39,13,90,'4','7','1',25),(1761,39,13,90,'3','7','2',25),(1762,39,13,90,'m','7','3',25),(1763,39,13,90,'m','7','4',25),(1764,39,13,90,'m','7','5',25),(1765,39,13,90,'m','7','6',25),(1766,39,13,125,'1','3','3',25),(1767,39,13,125,'1','3','4',25),(1768,39,13,125,'m','3','5',25),(1769,39,13,125,'m','3','6',25),(1771,39,13,125,'3','4','1',25),(1772,39,13,125,'2','4','2',25),(1773,39,13,125,'2','4','3',25),(1774,39,13,125,'m','4','4',25),(1775,39,13,125,'m','4','6',25),(1776,39,13,125,'m','4','5',25),(1777,39,13,125,'3','5','1',25),(1779,39,13,125,'2','5','3',25),(1780,39,13,125,'3','5','2',25),(1781,39,13,125,'m','5','4',25),(1782,39,13,125,'m','5','6',25),(1783,39,13,125,'m','5','5',25),(1784,39,13,125,'1','6','1',25),(1785,39,13,125,'1','6','2',25),(1786,39,13,125,'1','6','3',25),(1787,39,13,125,'4','6','4',25),(1788,39,13,125,'m','6','5',25),(1789,39,13,125,'m','6','6',25),(1790,39,13,125,'1','7','1',25),(1791,39,13,125,'m','7','2',25),(1792,39,13,125,'m','7','3',25),(1793,39,13,125,'m','7','4',25),(1794,39,13,125,'m','7','5',25),(1795,39,13,125,'m','7','6',25),(1796,39,13,120,'3','1','1',25),(1797,39,13,120,'m','1','2',25),(1798,39,13,120,'m','1','3',25),(1799,39,13,120,'m','1','4',25),(1800,39,13,120,'m','1','5',25),(1801,39,13,120,'m','1','6',25),(1802,39,13,120,'1','2','1',25),(1803,39,13,120,'5','3','1',25),(1804,39,13,120,'1','4','1',25),(1805,39,13,120,'1','5','1',25),(1806,39,13,120,'5','6','1',25),(1807,39,13,120,'4','7','1',25),(1808,39,13,120,'1','2','2',25),(1809,39,13,120,'2','3','2',25),(1810,39,13,120,'2','4','2',25),(1811,39,13,120,'2','5','2',25),(1812,39,13,120,'4','6','2',25),(1813,39,13,120,'3','7','2',25),(1814,39,13,120,'3','2','3',25),(1815,39,13,120,'1','3','3',25),(1816,39,13,120,'3','4','3',25),(1817,39,13,120,'4','5','3',25),(1818,39,13,120,'2','6','3',25),(1819,39,13,120,'2','7','3',25),(1820,39,13,120,'m','2','4',25),(1821,39,13,120,'m','3','4',25),(1822,39,13,120,'4','4','4',25),(1823,39,13,120,'5','5','4',25),(1824,39,13,120,'2','6','4',25),(1825,39,13,120,'2','7','4',25),(1826,39,13,120,'m','2','5',25),(1827,39,13,120,'m','3','5',25),(1828,39,13,120,'3','4','5',25),(1829,39,13,120,'1','5','5',25),(1830,39,13,120,'m','6','5',25),(1831,39,13,120,'m','2','6',25),(1832,39,13,120,'m','3','6',25),(1833,39,13,120,'m','4','6',25),(1834,39,13,120,'m','5','6',25),(1835,39,13,120,'m','6','6',25),(1836,39,13,120,'m','7','6',25),(1837,39,13,120,'m','7','5',25),(1838,39,13,99,'5','1','1',25),(1839,39,13,99,'2','1','2',25),(1840,39,13,99,'m','1','3',25),(1841,39,13,99,'m','1','4',25),(1843,39,13,99,'1','1','5',25),(1844,39,13,99,'m','1','6',25),(1845,39,13,99,'1','2','1',25),(1846,39,13,99,'1','2','2',25),(1847,39,13,99,'3','2','3',25),(1848,39,13,99,'m','2','4',25),(1849,39,13,99,'m','2','5',25),(1850,39,13,99,'m','2','6',25),(1851,39,13,99,'4','3','1',25),(1853,39,13,99,'3','3','2',25),(1854,39,13,99,'2','3','3',25),(1855,39,13,99,'m','3','4',25),(1856,39,13,99,'m','3','5',25),(1857,39,13,99,'m','3','6',25),(1858,39,13,99,'2','4','2',25),(1859,39,13,99,'m','4','3',25),(1860,39,13,99,'m','4','4',25),(1861,39,13,99,'m','4','5',25),(1862,39,13,99,'m','4','6',25),(1863,39,13,99,'2','5','1',25),(1864,39,13,99,'m','5','2',25),(1865,39,13,99,'m','5','3',25),(1866,39,13,99,'m','5','4',25),(1867,39,13,99,'m','5','5',25),(1868,39,13,99,'m','5','6',25),(1869,39,13,99,'1','6','1',25),(1870,39,13,99,'4','7','1',25),(1871,39,13,99,'m','6','2',25),(1872,39,13,99,'m','7','2',25),(1873,39,13,99,'m','6','3',25),(1874,39,13,99,'m','7','3',25),(1875,39,13,99,'m','6','4',25),(1876,39,13,99,'m','7','4',25),(1877,39,13,99,'m','6','5',25),(1878,39,13,99,'m','7','5',25),(1879,39,13,99,'m','7','6',25),(1880,39,13,99,'m','6','6',25),(1881,39,13,100,'m','7','2',25),(1882,39,13,100,'m','7','1',25),(1883,39,13,100,'m','7','3',25),(1884,39,13,100,'m','7','4',25),(1885,39,13,100,'m','7','5',25),(1886,39,13,100,'m','7','6',25),(1887,39,13,124,'2','6','1',25),(1889,39,13,124,'1','6','2',25),(1890,39,13,104,'6','7','1',25),(1891,39,13,104,'4','7','2',25),(1892,39,13,104,'2','7','3',25),(1893,39,13,104,'2','7','4',25),(1894,39,13,104,'1','7','5',25),(1895,39,13,104,'m','7','6',25),(1896,39,13,92,'3','7','1',25),(1897,39,13,92,'2','7','2',25),(1898,39,13,92,'1','7','3',25),(1899,39,13,92,'m','7','4',25),(1900,39,13,92,'m','7','5',25),(1901,39,13,92,'m','7','6',25),(1902,40,13,110,'4','1','1',26),(1903,40,13,110,'3','1','2',26),(1904,40,13,110,'2','1','3',26),(1906,40,13,110,'4','2','1',26),(1907,40,13,110,'2','2','2',26),(1908,40,13,110,'5','3','1',26),(1909,40,13,110,'4','3','2',26),(1910,40,13,110,'3','3','3',26),(1911,40,13,110,'2','3','4',26),(1912,39,13,96,'3','1','1',25),(1913,39,13,96,'2','1','2',25),(1914,39,13,96,'1','1','3',25),(1915,40,13,110,'4','4','1',26),(1916,39,13,96,'m','1','4',25),(1917,39,13,96,'m','1','5',25),(1918,40,13,110,'2','4','2',26),(1919,39,13,96,'m','1','6',25),(1920,39,13,96,'2','2','1',25),(1921,39,13,96,'2','2','2',25),(1922,39,13,96,'m','2','3',25),(1923,39,13,96,'m','2','4',25),(1924,40,13,110,'4','5','1',26),(1925,39,13,96,'m','2','5',25),(1926,39,13,96,'m','2','6',25),(1927,40,13,110,'3','5','2',26),(1928,40,13,110,'1','5','3',26),(1929,39,13,96,'2','3','1',25),(1930,39,13,96,'2','3','2',25),(1931,39,13,96,'1','3','3',25),(1932,40,13,110,'2','6','1',26),(1933,39,13,96,'m','3','4',25),(1935,40,13,110,'M','6','2',26),(1936,39,13,96,'m','3','5',25),(1937,40,13,110,'M','6','3',26),(1938,39,13,96,'m','3','6',25),(1939,39,13,96,'2','4','1',25),(1940,39,13,96,'1','4','2',25),(1941,39,13,96,'1','4','3',25),(1942,39,13,96,'1','4','4',25),(1943,39,13,96,'m','4','5',25),(1944,39,13,96,'m','4','6',25),(1945,39,13,96,'4','5','1',25),(1946,39,13,96,'1','5','2',25),(1947,39,13,96,'m','5','3',25),(1948,39,13,96,'m','5','4',25),(1949,39,13,96,'m','5','5',25),(1950,39,13,96,'m','5','6',25),(1951,39,13,96,'m','6','6',25),(1952,39,13,96,'m','6','5',25),(1953,39,13,96,'m','6','4',25),(1954,39,13,96,'m','6','3',25),(1955,40,13,121,'0','1','1',19),(1956,40,13,123,'0','1','1',19),(1957,39,13,96,'m','6','2',25),(1958,39,13,96,'m','6','1',25),(1959,39,13,96,'2','7','1',25),(1960,39,13,96,'1','7','2',25),(1961,39,13,96,'m','7','3',25),(1962,39,13,96,'m','7','5',25),(1963,39,13,96,'m','7','6',25),(1964,39,13,96,'m','7','4',25),(1965,40,13,110,'4','1','1',27),(1966,40,13,121,'3','1','1',27),(1967,40,13,111,'4','1','1',27),(1968,40,13,108,'0','1','1',27),(1969,40,13,123,'0','1','1',27),(1970,40,13,109,'0','1','1',27),(1971,40,13,115,'0','1','1',27),(1972,40,13,113,'4','1','1',27),(1973,40,13,114,'0','1','1',27),(1974,40,13,116,'3','1','1',27),(1975,40,13,110,'3','1','2',27),(1976,40,13,110,'2','1','3',27),(1977,40,13,110,'4','2','1',27),(1978,40,13,110,'2','2','2',27),(1979,40,13,110,'5','3','1',27),(1980,40,13,110,'4','3','2',27),(1981,40,13,110,'3','3','3',27),(1982,40,13,110,'2','3','4',27),(1983,40,13,110,'4','4','1',27),(1984,40,13,110,'2','4','2',27),(1985,40,13,110,'4','5','1',27),(1986,40,13,110,'3','5','2',27),(1987,40,13,110,'1','5','3',27),(1988,40,13,110,'2','6','1',27),(1989,40,13,110,'2','7','1',27),(1990,40,13,110,'2','7','2',27),(1991,40,13,121,'1','1','2',27),(1992,40,13,121,'5','2','1',27),(1993,40,13,121,'1','2','2',27),(1994,40,13,121,'3','3','1',27),(1995,40,13,121,'3','4','1',27),(1996,40,13,113,'2','1','2',27),(1997,40,13,113,'1','1','3',27),(1998,40,13,113,'2','2','1',27),(1999,40,13,113,'2','2','2',27),(2000,40,13,113,'3','2','3',27),(2001,40,13,113,'3','3','1',27),(2002,40,13,113,'3','3','2',27),(2003,40,13,113,'2','3','3',27),(2004,40,13,113,'1','3','4',27),(2005,40,13,113,'4','4','1',27),(2006,40,13,113,'1','4','2',27),(2007,40,13,113,'2','5','1',27),(2008,40,13,113,'2','6','1',27),(2009,40,13,113,'3','6','2',27),(2010,40,13,113,'4','2','4',27),(2011,40,13,116,'1','1','2',27),(2012,40,13,116,'1','1','3',27),(2013,40,13,116,'2','2','1',27),(2014,40,13,116,'1','2','2',27),(2015,40,13,116,'6','3','1',27),(2016,40,13,116,'1','3','2',27),(2017,40,13,116,'1','3','3',27),(2018,40,13,116,'4','4','1',27),(2019,40,13,116,'3','4','2',27),(2020,40,13,116,'2','4','3',27),(2021,40,13,116,'2','4','4',27),(2022,40,13,116,'1','4','5',27),(2023,40,13,116,'3','5','1',27),(2024,40,13,116,'4','5','2',27),(2025,40,13,116,'6','6','1',27),(2026,40,13,116,'3','6','2',27),(2027,40,13,116,'3','7','1',27),(2028,40,13,116,'4','7','2',27),(2029,39,13,126,'5','1','1',25),(2030,39,13,126,'2','1','2',25),(2033,39,13,126,'2','1','4',25),(2034,39,13,126,'2','1','3',25),(2035,40,13,116,'1','5','3',27),(2036,39,13,126,'1','1','5',25),(2037,39,13,126,'m','1','6',25),(2038,39,13,126,'3','2','1',25),(2039,39,13,126,'2','2','2',25),(2040,39,13,126,'2','2','3',25),(2041,39,13,126,'m','2','4',25),(2042,39,13,126,'m','2','5',25),(2043,39,13,126,'m','2','6',25),(2045,40,13,115,'3','2','1',27),(2046,40,13,115,'1','3','1',27),(2047,40,13,115,'4','4','1',27),(2048,39,13,126,'3','3','1',25),(2049,39,13,126,'3','3','2',25),(2050,39,13,126,'3','3','3',25),(2051,40,13,115,'1','6','1',27),(2052,39,13,126,'2','3','4',25),(2053,39,13,126,'1','3','5',25),(2055,40,13,115,'1','7','1',27),(2056,40,13,115,'2','6','2',27),(2057,39,13,126,'m','3','6',25),(2058,39,13,126,'3','4','1',25),(2059,39,13,126,'2','4','2',25),(2060,39,13,126,'2','4','3',25),(2061,40,13,123,'2','2','1',27),(2062,39,13,126,'1','4','4',25),(2063,40,13,123,'2','2','2',27),(2064,39,13,126,'m','4','5',25),(2065,39,13,126,'m','4','6',25),(2066,39,13,126,'3','5','1',25),(2067,40,13,123,'4','6','1',27),(2068,39,13,126,'3','5','2',25),(2069,39,13,126,'m','5','3',25),(2070,39,13,126,'m','5','4',25),(2071,39,13,126,'m','5','5',25),(2072,39,13,126,'m','5','6',25),(2073,40,13,123,'1','7','1',27),(2074,40,13,123,'2','7','2',27),(2075,40,13,123,'2','7','3',27),(2076,40,13,123,'4','7','4',27),(2077,39,13,126,'6','6','1',25),(2078,39,13,126,'3','6','2',25),(2079,39,13,126,'4','6','3',25),(2080,40,13,111,'2','1','2',27),(2081,39,13,126,'3','6','4',25),(2082,40,13,111,'1','1','3',27),(2083,39,13,126,'m','6','5',25),(2084,40,13,111,'3','2','1',27),(2085,40,13,111,'3','2','2',27),(2086,40,13,111,'2','2','3',27),(2087,40,13,111,'1','2','4',27),(2088,40,13,111,'6','3','1',27),(2089,40,13,111,'3','3','2',27),(2090,40,13,111,'3','3','3',27),(2091,40,13,111,'2','3','4',27),(2092,40,13,111,'1','3','5',27),(2093,39,13,126,'m','6','6',25),(2094,39,13,126,'4','7','1',25),(2095,40,13,111,'2','4','1',27),(2096,40,13,111,'2','4','2',27),(2097,39,13,126,'4','7','2',25),(2098,40,13,111,'2','4','3',27),(2099,39,13,126,'3','7','3',25),(2100,39,13,126,'1','7','4',25),(2101,40,13,111,'5','5','1',27),(2102,40,13,111,'4','5','2',27),(2103,39,13,126,'m','7','5',25),(2104,39,13,126,'m','7','6',25),(2105,40,13,111,'1','5','3',27),(2106,40,13,111,'4','6','1',27),(2107,40,13,111,'2','6','2',27),(2108,40,13,111,'6','7','1',27),(2109,40,13,111,'4','7','2',27),(2110,40,13,111,'2','7','3',27),(2111,40,13,111,'2','7','4',27),(2112,39,13,102,'m','1','1',25),(2113,40,13,111,'2','7','5',27),(2114,39,13,102,'m','1','2',25),(2115,39,13,102,'m','1','4',25),(2116,39,13,102,'m','1','3',25),(2117,40,13,111,'1','7','6',27),(2118,39,13,102,'m','1','5',25),(2119,39,13,102,'m','1','6',25),(2120,39,13,102,'4','2','1',25),(2121,39,13,102,'m','2','2',25),(2122,39,13,102,'m','2','3',25),(2123,39,13,102,'m','2','4',25),(2124,39,13,102,'m','2','5',25),(2125,39,13,102,'m','2','6',25),(2126,39,13,102,'m','3','1',25),(2127,39,13,102,'m','3','2',25),(2128,39,13,102,'m','3','4',25),(2129,39,13,102,'m','3','3',25),(2130,39,13,102,'m','3','5',25),(2131,39,13,102,'m','3','6',25),(2132,40,13,109,'4','2','1',27),(2133,40,13,109,'3','3','1',27),(2134,39,13,102,'4','4','1',25),(2135,39,13,102,'1','4','2',25),(2136,40,13,109,'1','4','1',27),(2137,39,13,102,'m','4','3',25),(2138,39,13,102,'m','4','4',25),(2139,40,13,109,'2','5','1',27),(2140,39,13,102,'m','4','5',25),(2141,39,13,102,'m','4','6',25),(2142,40,13,109,'2','5','2',27),(2143,39,13,102,'3','5','1',25),(2144,40,13,109,'3','5','3',27),(2145,39,13,102,'m','5','2',25),(2146,39,13,102,'m','5','3',25),(2147,39,13,102,'m','5','4',25),(2148,39,13,102,'m','5','5',25),(2149,39,13,102,'m','5','6',25),(2150,40,13,109,'4','7','1',27),(2151,40,13,109,'4','7','2',27),(2153,40,13,109,'2','7','3',27),(2154,39,13,102,'3','6','2',25),(2155,39,13,102,'3','6','1',25),(2156,39,13,102,'m','6','3',25),(2157,39,13,102,'m','6','4',25),(2158,39,13,102,'m','6','5',25),(2159,39,13,102,'m','6','6',25),(2160,39,13,102,'2','7','1',25),(2161,39,13,102,'m','7','2',25),(2162,39,13,102,'m','7','3',25),(2163,39,13,102,'m','7','4',25),(2164,39,13,102,'m','7','5',25),(2165,39,13,102,'m','7','6',25),(2166,39,13,97,'1','1','1',25),(2167,39,13,97,'m','1','2',25),(2168,39,13,97,'m','1','3',25),(2169,39,13,97,'m','1','4',25),(2170,39,13,97,'m','1','5',25),(2171,39,13,97,'m','1','6',25),(2172,39,13,97,'4','2','1',25),(2173,39,13,97,'1','2','2',25),(2174,39,13,97,'m','2','3',25),(2175,39,13,97,'m','2','4',25),(2176,39,13,97,'m','2','5',25),(2177,39,13,97,'m','2','6',25),(2178,39,13,97,'2','3','1',25),(2179,39,13,97,'m','3','2',25),(2180,39,13,97,'m','3','3',25),(2181,39,13,97,'m','3','4',25),(2182,39,13,97,'m','3','5',25),(2183,39,13,97,'m','3','6',25),(2184,39,13,97,'m','4','1',25),(2185,39,13,97,'m','4','3',25),(2186,39,13,97,'m','4','4',25),(2187,39,13,97,'m','4','2',25),(2188,39,13,97,'m','4','5',25),(2189,39,13,97,'m','4','6',25),(2190,40,13,127,'M','1','1',27),(2191,40,13,127,'2','1','2',27),(2192,40,13,127,'2','1','3',27),(2193,40,13,127,'2','1','4',27),(2194,40,13,127,'2','2','1',27),(2195,40,13,127,'1','2','2',27),(2196,40,13,127,'4','2','3',27),(2197,40,13,127,'1','3','1',27),(2198,40,13,127,'1','3','2',27),(2199,40,13,127,'1','3','3',27),(2200,40,13,127,'5','3','4',27),(2201,39,13,97,'2','5','1',25),(2202,39,13,97,'m','5','2',25),(2203,39,13,97,'m','5','3',25),(2204,40,13,127,'3','4','1',27),(2205,39,13,16,'4','1','1',25),(2206,40,13,127,'3','4','2',27),(2207,39,13,97,'m','5','5',25),(2208,39,13,97,'m','5','6',25),(2209,39,13,97,'m','5','4',25),(2210,40,13,127,'3','5','1',27),(2211,39,13,16,'4','1','2',25),(2212,40,13,127,'1','5','2',27),(2213,39,13,97,'5','6','1',25),(2214,39,13,97,'2','6','2',25),(2215,40,13,127,'2','6','1',27),(2216,39,13,97,'1','6','3',25),(2218,39,13,97,'m','6','4',25),(2219,39,13,97,'m','6','5',25),(2220,39,13,97,'m','6','6',25),(2221,39,13,16,'1','2','1',25),(2222,39,13,16,'4','2','2',25),(2223,39,13,97,'1','7','1',25),(2224,39,13,16,'6','2','3',25),(2225,39,13,97,'m','7','2',25),(2226,39,13,16,'3','2','4',25),(2227,39,13,97,'m','7','3',25),(2228,39,13,16,'3','2','5',25),(2229,39,13,97,'m','7','4',25),(2230,39,13,16,'2','2','6',25),(2231,39,13,16,'2','3','1',25),(2232,39,13,16,'3','3','2',25),(2233,39,13,16,'3','3','3',25),(2234,39,13,16,'3','4','1',25),(2235,39,13,16,'4','5','1',25),(2236,39,13,16,'2','5','2',25),(2237,39,13,16,'2','5','3',25),(2238,39,13,97,'m','7','5',25),(2239,39,13,97,'m','7','6',25),(2240,39,13,16,'2','6','1',25),(2241,39,13,16,'1','6','2',25),(2242,39,13,16,'3','7','1',25),(2243,39,13,16,'2','7','2',25),(2244,39,13,122,'4','1','1',25),(2245,39,13,122,'2','1','2',25),(2246,39,13,122,'m','1','3',25),(2247,39,13,122,'m','1','4',25),(2248,39,13,122,'m','1','5',25),(2249,39,13,122,'m','1','6',25),(2250,39,13,122,'2','2','1',25),(2251,39,13,122,'m','2','2',25),(2252,39,13,122,'m','2','3',25),(2253,39,13,122,'m','2','4',25),(2254,39,13,122,'m','2','5',25),(2255,39,13,122,'m','2','6',25),(2256,39,13,122,'2','3','1',25),(2257,39,13,122,'m','3','2',25),(2258,39,13,122,'m','3','3',25),(2259,39,13,122,'m','3','4',25),(2260,39,13,107,'4','1','1',25),(2261,39,13,122,'m','3','5',25),(2262,39,13,122,'m','3','6',25),(2263,39,13,122,'1','4','1',25),(2264,39,13,122,'m','4','2',25),(2266,39,13,122,'m','4','3',25),(2267,39,13,122,'m','4','4',25),(2268,39,13,122,'m','4','5',25),(2269,39,13,122,'m','4','6',25),(2270,39,13,122,'3','5','1',25),(2271,39,13,122,'1','5','2',25),(2272,39,13,122,'m','5','3',25),(2273,39,13,122,'m','5','4',25),(2274,39,13,122,'m','5','5',25),(2275,39,13,122,'m','5','6',25),(2276,39,13,119,'4','1','1',25),(2277,39,13,119,'1','1','2',25),(2278,39,13,122,'4','6','1',25),(2279,39,13,119,'4','2','1',25),(2280,39,13,119,'2','2','2',25),(2281,39,13,122,'2','6','2',25),(2282,39,13,119,'2','2','3',25),(2283,39,13,122,'2','6','3',25),(2284,39,13,119,'3','3','1',25),(2285,39,13,122,'m','6','4',25),(2286,39,13,122,'m','6','5',25),(2287,39,13,122,'m','6','6',25),(2288,39,13,119,'6','4','1',25),(2289,39,13,119,'2','4','2',25),(2290,39,13,119,'1','4','3',25),(2291,39,13,119,'4','5','1',25),(2292,39,13,119,'6','6','1',25),(2293,39,13,119,'3','6','2',25),(2294,39,13,119,'1','6','3',25),(2295,39,13,119,'3','7','1',25),(2296,39,13,119,'1','7','2',25),(2297,39,13,93,'2','1','1',25),(2298,39,13,93,'1','4','1',25),(2299,39,13,93,'1','5','1',25),(2300,39,13,93,'1','6','1',25),(2301,39,13,126,'0','1','1',28),(2302,39,13,101,'0','1','1',28),(2303,39,13,16,'0','1','1',28),(2304,39,13,104,'0','1','1',28),(2305,39,13,96,'0','1','1',28),(2306,39,13,538,'0','1','1',28),(2307,39,13,100,'0','1','1',28),(2308,39,13,124,'0','1','1',28),(2309,39,13,119,'0','1','1',28),(2310,39,13,94,'0','1','1',28),(2311,39,13,106,'0','1','1',28),(2312,39,13,125,'0','1','1',28),(2313,39,13,92,'0','1','1',28),(2314,39,13,103,'0','1','1',28),(2315,39,13,90,'0','1','1',28),(2316,39,13,122,'0','1','1',28),(2317,39,13,102,'0','1','1',28),(2318,39,13,107,'0','1','1',28),(2319,39,13,97,'0','1','1',28),(2320,39,13,105,'0','1','1',28),(2321,39,13,120,'0','1','1',28),(2322,39,13,93,'0','1','1',28),(2323,39,13,98,'0','1','1',28),(2324,39,13,99,'0','1','1',28),(2325,39,13,126,'0','1','1',29),(2326,39,13,101,'0','1','1',29),(2327,39,13,16,'0','1','1',29),(2328,39,13,104,'0','1','1',29),(2329,39,13,96,'0','1','1',29),(2330,39,13,97,'0','1','1',29),(2331,39,13,107,'0','1','1',29),(2332,39,13,102,'0','1','1',29),(2333,39,13,119,'0','1','1',29),(2334,39,13,94,'0','1','1',29),(2335,39,13,103,'0','1','1',29),(2336,39,13,125,'0','1','1',29),(2338,2,11,15,'m','1','1',15),(2339,2,11,17,'x','1','1',31),(2340,2,11,17,'x','1','2',31),(2341,2,11,23,'x','1','1',31),(2342,2,11,21,'10','1','1',31),(2343,2,11,69,'9','1','1',31),(2344,2,11,22,'x','1','1',31),(2345,46,14,165,'7','1','1',32),(2346,46,14,165,'7','1','2',32),(2347,46,14,187,'1','1','1',32),(2348,46,14,165,'2','1','3',32),(2349,46,14,165,'2','1','4',32),(2350,46,14,165,'5','1','5',32),(2351,46,14,165,'5','1','6',32),(2352,46,14,187,'1','1','2',32),(2353,46,14,165,'M','1','7',32),(2354,46,14,187,'5','1','3',32),(2355,46,14,161,'7','1','1',32),(2356,46,14,161,'7','1','2',32),(2357,46,14,187,'3','1','4',32),(2358,46,14,161,'1','1','3',32),(2359,46,14,161,'6','1','4',32),(2360,46,14,161,'3','1','5',32),(2361,46,14,161,'3','1','6',32),(2362,46,14,161,'1','1','7',32),(2363,46,14,187,'7','1','5',32),(2364,46,14,189,'8','1','1',32),(2366,46,14,187,'M','1','7',32),(2367,46,14,189,'4','1','2',32),(2368,46,14,189,'1','1','3',32),(2369,46,14,187,'1','1','6',32),(2370,46,14,189,'M','1','4',32),(2371,46,14,189,'M','1','5',32),(2372,46,14,189,'M','1','6',32),(2373,46,14,189,'M','1','7',32),(2374,46,14,191,'5','1','1',32),(2375,46,14,191,'3','1','2',32),(2376,46,14,190,'1','1','1',32),(2377,46,14,191,'1','1','3',32),(2378,46,14,190,'2','1','2',32),(2379,46,14,191,'M','1','4',32),(2380,46,14,191,'M','1','5',32),(2381,46,14,190,'2','1','3',32),(2382,46,14,191,'M','1','6',32),(2383,46,14,191,'M','1','7',32),(2384,46,14,190,'3','1','4',32),(2385,46,14,186,'2','1','1',32),(2386,46,14,186,'1','1','2',32),(2387,46,14,190,'2','1','5',32),(2388,46,14,186,'1','1','3',32),(2389,46,14,186,'1','1','4',32),(2390,46,14,190,'M','1','6',32),(2391,46,14,190,'M','1','7',32),(2392,46,14,186,'M','1','5',32),(2393,46,14,186,'M','1','6',32),(2394,46,14,186,'M','1','7',32),(2395,46,14,153,'M','1','1',32),(2396,46,14,153,'M','1','2',32),(2397,46,14,153,'M','1','3',32),(2398,46,14,153,'M','1','4',32),(2399,46,14,153,'2','1','5',32),(2401,46,14,153,'4','1','6',32),(2402,46,14,153,'1','1','7',32),(2403,46,14,157,'9','1','1',32),(2404,46,14,188,'7','1','1',32),(2405,46,14,188,'1','1','2',32),(2406,46,14,188,'3','1','3',32),(2407,46,14,188,'5','1','4',32),(2408,46,14,188,'1','1','5',32),(2409,46,14,188,'M','1','6',32),(2410,46,14,188,'M','1','7',32),(2411,46,14,185,'5','1','1',32),(2413,46,14,185,'4','1','2',32),(2415,46,14,185,'3','1','3',32),(2416,46,14,185,'1','1','4',32),(2417,46,14,185,'2','1','5',32),(2418,46,14,185,'M','1','6',32),(2419,46,14,185,'M','1','7',32),(2420,46,14,157,'7','1','2',32),(2421,46,14,157,'1','1','3',32),(2422,46,14,157,'M','1','4',32),(2423,46,14,157,'4','1','5',32),(2424,46,14,157,'2','1','6',32),(2425,46,14,157,'3','1','7',32),(2426,46,14,165,'9','2','1',32),(2427,46,14,165,'3','2','2',32),(2428,46,14,165,'1','2','3',32),(2429,46,14,165,'1','2','4',32),(2430,46,14,165,'1','2','5',32),(2431,46,14,165,'1','2','6',32),(2432,46,14,190,'1','2','1',32),(2433,46,14,165,'7','2','7',32),(2434,46,14,190,'M','2','2',32),(2435,46,14,190,'M','2','3',32),(2436,46,14,190,'M','2','4',32),(2437,46,14,190,'M','2','5',32),(2438,46,14,190,'M','2','6',32),(2439,46,14,190,'M','2','7',32),(2440,46,14,189,'8','2','1',32),(2441,46,14,189,'8','2','2',32),(2442,46,14,189,'7','2','3',32),(2443,46,14,189,'1','2','4',32),(2444,46,14,187,'10','2','1',32),(2445,46,14,189,'M','2','5',32),(2446,46,14,189,'M','2','6',32),(2447,46,14,189,'M','2','7',32),(2448,46,14,187,'1','2','2',32),(2449,46,14,191,'1','2','1',32),(2450,46,14,187,'M','2','3',32),(2451,46,14,191,'4','2','2',32),(2452,46,14,191,'4','2','3',32),(2453,46,14,191,'1','2','4',32),(2454,46,14,191,'7','2','5',32),(2455,46,14,191,'M','2','6',32),(2456,46,14,191,'M','2','7',32),(2457,46,14,187,'M','2','4',32),(2458,46,14,186,'7','2','1',32),(2459,46,14,187,'4','2','5',32),(2460,46,14,186,'7','2','2',32),(2461,46,14,186,'3','2','3',32),(2462,46,14,187,'M','2','6',32),(2463,46,14,187,'M','2','7',32),(2464,46,14,186,'1','2','4',32),(2465,46,14,186,'1','2','5',32),(2466,46,14,186,'M','2','6',32),(2467,46,14,186,'M','2','7',32),(2468,46,14,188,'1','2','1',32),(2469,46,14,188,'1','2','2',32),(2470,46,14,153,'2','2','1',32),(2471,46,14,188,'1','2','3',32),(2472,46,14,153,'5','2','2',32),(2473,46,14,188,'3','2','4',32),(2474,46,14,153,'4','2','3',32),(2475,46,14,188,'3','2','5',32),(2476,46,14,188,'M','2','6',32),(2477,46,14,188,'M','2','7',32),(2478,46,14,153,'4','2','4',32),(2479,46,14,153,'2','2','5',32),(2480,46,14,153,'M','2','6',32),(2481,46,14,153,'M','2','7',32),(2482,46,14,161,'3','2','1',32),(2483,46,14,161,'3','2','2',32),(2484,46,14,161,'3','2','3',32),(2485,46,14,161,'9','2','4',32),(2486,46,14,161,'7','2','5',32),(2487,46,14,157,'M','2','1',32),(2488,46,14,161,'1','2','6',32),(2489,46,14,157,'M','2','2',32),(2490,46,14,161,'M','2','7',32),(2491,46,14,157,'1','2','3',32),(2492,46,14,157,'1','2','4',32),(2493,46,14,185,'M','2','1',32),(2494,46,14,157,'7','2','5',32),(2495,46,14,157,'4','2','6',32),(2496,46,14,157,'3','2','7',32),(2497,46,14,185,'3','2','2',32),(2498,46,14,185,'2','2','3',32),(2499,46,14,185,'2','2','4',32),(2500,46,14,185,'1','2','5',32),(2501,46,14,185,'2','2','6',32),(2502,46,14,185,'4','2','7',32),(2503,46,14,165,'9','3','1',32),(2504,46,14,165,'9','3','2',32),(2505,46,14,165,'7','3','3',32),(2506,46,14,165,'6','3','4',32),(2507,46,14,165,'4','3','5',32),(2508,46,14,165,'1','3','6',32),(2509,46,14,165,'M','3','7',32),(2510,46,14,161,'9','3','1',32),(2511,46,14,161,'7','3','2',32),(2512,46,14,161,'7','3','3',32),(2513,46,14,161,'7','3','4',32),(2514,46,14,153,'M','3','1',32),(2515,46,14,153,'M','3','2',32),(2516,46,14,153,'M','3','3',32),(2517,46,14,153,'M','3','4',32),(2518,46,14,161,'3','3','5',32),(2519,46,14,161,'5','3','6',32),(2521,46,14,153,'10','3','5',32),(2522,46,14,161,'2','3','7',32),(2523,46,14,153,'3','3','6',32),(2524,46,14,153,'2','3','7',32),(2525,46,14,187,'M','3','2',32),(2526,46,14,187,'M','3','1',32),(2527,46,14,187,'M','3','3',32),(2528,46,14,187,'M','3','4',32),(2529,46,14,189,'5','3','1',32),(2530,46,14,189,'4','3','2',32),(2531,46,14,189,'3','3','3',32),(2532,46,14,189,'3','3','4',32),(2533,46,14,189,'2','3','5',32),(2535,46,14,187,'6','3','7',32),(2537,46,14,189,'M','3','7',32),(2538,46,14,187,'M','3','6',32),(2539,46,14,191,'6','3','1',32),(2540,46,14,191,'6','3','2',32),(2541,46,14,191,'3','3','3',32),(2542,46,14,189,'1','3','6',32),(2543,46,14,191,'3','3','4',32),(2544,46,14,191,'M','3','5',32),(2546,46,14,191,'M','3','6',32),(2547,46,14,191,'M','3','7',32),(2549,46,14,157,'M','3','1',32),(2550,46,14,186,'6','3','1',32),(2551,46,14,186,'2','3','2',32),(2552,46,14,186,'M','3','3',32),(2553,46,14,186,'M','3','4',32),(2554,46,14,186,'M','3','5',32),(2555,46,14,186,'M','3','6',32),(2556,46,14,186,'M','3','7',32),(2557,46,14,157,'2','3','3',32),(2558,46,14,157,'2','3','4',32),(2559,46,14,188,'3','3','1',32),(2560,46,14,157,'3','3','5',32),(2561,46,14,188,'4','3','2',32),(2562,46,14,157,'2','3','6',32),(2563,46,14,188,'3','3','3',32),(2564,46,14,188,'2','3','4',32),(2565,46,14,157,'M','3','2',32),(2566,46,14,188,'1','3','5',32),(2567,46,14,188,'M','3','6',32),(2568,46,14,188,'M','3','7',32),(2569,46,14,185,'1','3','1',32),(2570,46,14,157,'3','3','7',32),(2571,46,14,185,'2','3','2',32),(2572,46,14,185,'3','3','3',32),(2573,46,14,185,'2','3','4',32),(2574,46,14,185,'4','3','5',32),(2575,46,14,185,'7','3','6',32),(2576,46,14,185,'8','3','7',32),(2577,46,14,190,'7','3','1',32),(2578,46,14,190,'7','3','2',32),(2579,46,14,190,'4','3','3',32),(2580,46,14,190,'M','3','4',32),(2581,46,14,190,'M','3','5',32),(2582,46,14,190,'M','3','6',32),(2583,46,14,190,'M','3','7',32),(2584,46,14,165,'8','4','1',32),(2585,46,14,165,'5','4','2',32),(2586,46,14,165,'5','4','3',32),(2588,46,14,165,'5','4','4',32),(2589,46,14,165,'3','4','5',32),(2590,46,14,165,'2','4','6',32),(2591,46,14,165,'1','4','7',32),(2592,46,14,161,'7','4','1',32),(2593,46,14,161,'1','4','2',32),(2594,46,14,161,'1','4','3',32),(2595,46,14,161,'1','4','4',32),(2596,46,14,161,'4','4','5',32),(2597,46,14,189,'7','4','1',32),(2598,46,14,161,'4','4','6',32),(2599,46,14,189,'7','4','2',32),(2600,46,14,189,'2','4','3',32),(2601,46,14,189,'1','4','4',32),(2602,46,14,189,'M','4','5',32),(2603,46,14,189,'M','4','6',32),(2604,46,14,189,'M','4','7',32),(2605,46,14,161,'M','4','7',32),(2606,46,14,190,'7','4','1',32),(2607,46,14,190,'1','4','2',32),(2608,46,14,190,'2','4','3',32),(2609,46,14,190,'3','4','4',32),(2611,46,14,190,'M','4','6',32),(2612,46,14,190,'M','4','7',32),(2613,46,14,187,'4','3','5',32),(2614,46,14,186,'10','4','1',32),(2615,46,14,186,'1','4','2',32),(2616,46,14,186,'1','4','3',32),(2617,46,14,186,'M','4','4',32),(2618,46,14,186,'M','4','5',32),(2619,46,14,186,'M','4','6',32),(2620,46,14,186,'M','4','7',32),(2621,46,14,188,'1','4','1',32),(2622,46,14,188,'4','4','2',32),(2623,46,14,188,'7','4','3',32),(2624,46,14,188,'M','4','4',32),(2625,46,14,188,'M','4','5',32),(2626,46,14,188,'M','4','6',32),(2627,46,14,188,'M','4','7',32),(2628,46,14,190,'3','4','5',32),(2629,46,14,185,'M','4','1',32),(2631,46,14,185,'1','4','2',32),(2633,46,14,187,'2','4','1',32),(2634,46,14,185,'1','4','3',32),(2635,46,14,185,'6','4','4',32),(2636,46,14,187,'5','4','2',32),(2637,46,14,185,'2','4','5',32),(2638,46,14,187,'4','4','3',32),(2640,46,14,185,'8','4','6',32),(2641,46,14,185,'5','4','7',32),(2642,46,14,187,'M','4','4',32),(2643,46,14,187,'M','4','5',32),(2644,46,14,187,'M','4','6',32),(2645,46,14,187,'M','4','7',32),(2646,46,14,157,'M','4','1',32),(2647,46,14,157,'M','4','2',32),(2648,46,14,153,'2','4','1',32),(2649,46,14,153,'3','4','2',32),(2650,46,14,153,'4','4','3',32),(2651,46,14,153,'4','4','4',32),(2652,46,14,153,'6','4','5',32),(2653,46,14,157,'2','4','3',32),(2654,46,14,153,'M','4','6',32),(2655,46,14,153,'M','4','7',32),(2656,46,14,157,'3','4','4',32),(2657,46,14,157,'5','4','5',32),(2658,46,14,157,'5','4','6',32),(2659,46,14,157,'8','4','7',32),(2660,46,14,191,'3','4','1',32),(2661,46,14,191,'3','4','2',32),(2662,46,14,191,'1','4','3',32),(2663,46,14,191,'M','4','4',32),(2664,46,14,191,'M','4','5',32),(2665,46,14,191,'M','4','6',32),(2666,46,14,191,'M','4','7',32),(2667,46,14,190,'9','5','1',32),(2668,46,14,190,'4','5','2',32),(2669,46,14,191,'1','5','1',32),(2670,46,14,191,'1','5','2',32),(2671,46,14,190,'4','5','3',32),(2672,46,14,191,'7','5','3',32),(2674,46,14,190,'M','5','4',32),(2675,46,14,191,'M','5','5',32),(2676,46,14,190,'M','5','5',32),(2677,46,14,191,'M','5','6',32),(2678,46,14,190,'M','5','6',32),(2679,46,14,191,'3','5','7',32),(2680,46,14,190,'M','5','7',32),(2681,46,14,187,'1','5','1',32),(2682,46,14,187,'1','5','2',32),(2683,46,14,187,'1','5','3',32),(2684,46,14,187,'4','5','4',32),(2685,46,14,186,'2','5','1',32),(2686,46,14,187,'4','5','5',32),(2687,46,14,187,'5','5','6',32),(2688,46,14,186,'1','5','2',32),(2689,46,14,186,'1','5','3',32),(2690,46,14,186,'1','5','4',32),(2691,46,14,187,'2','5','7',32),(2692,46,14,186,'1','5','5',32),(2693,46,14,186,'M','5','6',32),(2694,46,14,186,'M','5','7',32),(2695,46,14,157,'M','5','1',32),(2696,46,14,157,'2','5','2',32),(2697,46,14,157,'3','5','3',32),(2698,46,14,157,'1','5','4',32),(2699,46,14,157,'3','5','5',32),(2700,46,14,157,'4','5','6',32),(2701,46,14,157,'5','5','7',32),(2702,46,14,191,'1','5','4',32),(2703,46,14,189,'4','5','1',32),(2704,46,14,189,'3','5','2',32),(2706,46,14,189,'1','5','3',32),(2708,46,14,187,'1','6','3',32),(2709,46,14,189,'1','5','4',32),(2710,46,14,187,'4','6','4',32),(2711,46,14,189,'1','5','5',32),(2712,46,14,187,' M','6','6',32),(2713,46,14,189,'M','5','7',32),(2714,46,14,189,'M','5','6',32),(2715,46,14,187,'M','6','7',32),(2716,46,14,161,'7','5','1',32),(2717,46,14,161,'1','5','2',32),(2718,46,14,161,'4','5','3',32),(2719,46,14,161,'5','5','4',32),(2721,46,14,161,'M','5','5',32),(2722,46,14,161,'M','5','6',32),(2723,46,14,161,'M','5','7',32),(2724,46,14,165,'4','5','2',32),(2725,46,14,165,'5','5','1',32),(2726,46,14,165,'3','5','3',32),(2727,46,14,165,'2','5','4',32),(2728,46,14,165,'2','5','5',32),(2729,46,14,165,'1','5','6',32),(2730,46,14,165,'M','5','7',32),(2731,46,14,188,'2','5','1',32),(2732,46,14,188,'1','5','2',32),(2733,46,14,188,'7','5','3',32),(2734,46,14,188,'4','5','4',32),(2735,46,14,188,'M','5','5',32),(2736,46,14,188,'M','5','6',32),(2737,46,14,188,'M','5','7',32),(2738,46,14,185,'1','5','1',32),(2739,46,14,185,'1','5','2',32),(2740,46,14,185,'3','5','3',32),(2741,46,14,185,'5','5','4',32),(2742,46,14,185,'1','5','5',32),(2743,46,14,185,'M','5','6',32),(2744,46,14,185,'M','5','7',32),(2745,46,14,165,'7','6','1',32),(2746,46,14,165,'5','6','2',32),(2747,46,14,165,'4','6','3',32),(2748,46,14,165,'2','6','4',32),(2749,46,14,165,'1','6','5',32),(2750,46,14,165,'1','6','6',32),(2751,46,14,165,'1','6','7',32),(2752,46,14,190,'M','6','1',32),(2753,46,14,189,'4','6','1',32),(2754,46,14,157,'M','6','1',32),(2755,46,14,189,'5','6','2',32),(2756,46,14,190,'1','6','2',32),(2757,46,14,189,'2','6','3',32),(2758,46,14,189,'1','6','4',32),(2759,46,14,190,'1','6','3',32),(2760,46,14,189,'1','6','5',32),(2761,46,14,189,'M','6','6',32),(2762,46,14,190,'1','6','4',32),(2764,46,14,190,'M','6','5',32),(2765,46,14,190,'M','6','6',32),(2766,46,14,189,'1','6','7',32),(2767,46,14,190,'1','6','7',32),(2768,46,14,191,'2','6','1',32),(2769,46,14,191,'4','6','2',32),(2770,46,14,191,'3','6','3',32),(2771,46,14,191,'M','6','4',32),(2772,46,14,191,'M','6','5',32),(2773,46,14,191,'M','6','6',32),(2774,46,14,191,'M','6','7',32),(2775,46,14,187,'3','7','1',32),(2776,46,14,187,'3','7','2',32),(2777,46,14,186,'4','6','1',32),(2778,46,14,186,'2','6','2',32),(2779,46,14,186,'1','6','3',32),(2780,46,14,187,'2','7','3',32),(2781,46,14,186,'1','6','4',32),(2782,46,14,187,'2','7','4',32),(2783,46,14,186,'M','6','5',32),(2784,46,14,186,'M','6','6',32),(2785,46,14,186,'M','6','7',32),(2786,46,14,187,'7','7','5',32),(2787,46,14,187,'M','7','6',32),(2788,46,14,187,'M','7','7',32),(2789,46,14,188,'2','6','1',32),(2790,46,14,188,'3','6','2',32),(2791,46,14,188,'5','6','3',32),(2792,46,14,188,'4','6','4',32),(2793,46,14,188,'3','6','5',32),(2794,46,14,188,'M','6','6',32),(2795,46,14,188,'M','6','7',32),(2796,46,14,161,'2','6','1',32),(2797,46,14,161,'2','6','2',32),(2798,46,14,161,'3','6','3',32),(2799,46,14,161,'4','6','4',32),(2800,46,14,161,'2','6','5',32),(2801,46,14,161,'1','6','6',32),(2802,46,14,161,'M','6','7',32),(2804,46,14,153,'2','6','1',32),(2805,46,14,153,'4','6','2',32),(2806,46,14,153,'7','6','3',32),(2807,46,14,153,'7','6','4',32),(2808,46,14,153,'2','6','5',32),(2809,46,14,185,'1','6','1',32),(2810,46,14,153,'M','6','6',32),(2811,46,14,153,'M','6','7',32),(2812,46,14,153,'2','5','1',32),(2813,46,14,153,'2','5','2',32),(2814,46,14,153,'4','5','3',32),(2816,46,14,153,'4','5','4',32),(2817,46,14,153,'5','5','5',32),(2818,46,14,185,'5','6','2',32),(2819,46,14,185,'M','6','3',32),(2820,46,14,153,'1','5','6',32),(2821,46,14,153,'1','5','7',32),(2822,46,14,185,'M','6','4',32),(2823,46,14,157,'2','6','2',32),(2824,46,14,157,'2','6','3',32),(2825,46,14,185,'1','6','5',32),(2826,46,14,157,'3','6','4',32),(2828,46,14,157,'7','6','5',32),(2829,46,14,185,'1','6','6',32),(2830,46,14,185,'1','6','7',32),(2831,46,14,157,'7','6','6',32),(2832,46,14,157,'8','6','7',32),(2833,46,14,165,'7','7','1',32),(2834,46,14,165,'5','7','2',32),(2835,46,14,165,'5','7','3',32),(2836,46,14,165,'3','7','4',32),(2837,46,14,165,'2','7','5',32),(2838,46,14,165,'2','7','6',32),(2839,46,14,165,'1','7','7',32),(2840,46,14,186,'4','7','1',32),(2841,46,14,186,'3','7','2',32),(2842,46,14,186,'1','7','3',32),(2843,46,14,186,'1','7','4',32),(2844,46,14,186,'1','7','5',32),(2845,46,14,161,'1','7','1',32),(2846,46,14,161,'1','7','2',32),(2847,46,14,161,'7','7','3',32),(2848,46,14,161,'1','7','4',32),(2849,46,14,161,'4','7','5',32),(2850,46,14,161,'3','7','6',32),(2851,46,14,161,'M','7','7',32),(2852,46,14,186,'1','7','6',32),(2853,46,14,191,'4','7','1',32),(2854,46,14,191,'3','7','2',32),(2855,46,14,190,'1','7','1',32),(2856,46,14,191,'2','7','3',32),(2857,46,14,190,'2','7','2',32),(2858,46,14,191,'1','7','4',32),(2859,46,14,191,'1','7','5',32),(2860,46,14,190,'3','7','3',32),(2861,46,14,191,'M','7','6',32),(2862,46,14,191,'M','7','7',32),(2863,46,14,190,'7','7','4',32),(2864,46,14,190,'M','7','5',32),(2865,46,14,190,'M','7','6',32),(2866,46,14,190,'M','7','7',32),(2867,46,14,188,'2','7','1',32),(2868,46,14,188,'3','7','2',32),(2869,46,14,188,'5','7','3',32),(2870,46,14,188,'6','7','4',32),(2871,46,14,188,'2','7','5',32),(2872,46,14,188,'7','7','6',32),(2873,46,14,188,'M','7','7',32),(2874,46,14,186,'M','7','7',32),(2875,46,14,153,'2','7','1',32),(2876,46,14,153,'2','7','2',32),(2877,46,14,153,'4','7','3',32),(2878,46,14,153,'1','7','4',32),(2879,46,14,153,'M','7','5',32),(2880,46,14,185,'1','7','1',32),(2881,46,14,153,'M','7','6',32),(2882,46,14,153,'M','7','7',32),(2883,46,14,187,'7','6','1',32),(2884,46,14,185,'7','7','2',32),(2885,46,14,187,'2','6','2',32),(2886,46,14,185,'9','7','3',32),(2887,46,14,185,'M','7','4',32),(2888,46,14,185,'M','7','5',32),(2889,46,14,185,'M','7','6',32),(2890,46,14,187,'M','6','5',32),(2891,46,14,185,'4','7','7',32),(2892,46,14,157,'M','7','1',32),(2893,46,14,157,'M','7','2',32),(2894,46,14,189,'8','7','1',32),(2895,46,14,189,'5','7','2',32),(2896,46,14,189,'1','7','3',32),(2897,46,14,189,'1','7','4',32),(2898,46,14,189,'1','7','5',32),(2899,46,14,157,'1','7','3',32),(2900,46,14,157,'2','7','4',32),(2901,46,14,157,'4','7','5',32),(2902,46,14,157,'4','7','6',32),(2903,46,14,189,'1','7','6',32),(2904,46,14,189,'M','7','7',32),(2905,46,14,157,'2','7','7',32),(2907,46,14,165,'7','1','2',33),(2908,46,14,165,'7','1','3',33),(2909,46,14,165,'3','1','4',33),(2910,46,14,173,'9','1','1',33),(2911,46,14,165,'1','1','5',33),(2912,46,14,165,'1','1','6',33),(2913,46,14,173,'4','1','2',33),(2914,46,14,165,'1','1','7',33),(2915,46,14,173,'1','1','3',33),(2916,46,14,173,'1','1','4',33),(2917,46,14,173,'1','1','5',33),(2918,46,14,191,'1','1','2',33),(2919,46,14,191,'7','1','3',33),(2920,46,14,191,'7','1','4',33),(2921,46,14,173,'M','1','6',33),(2922,46,14,191,'M','1','5',33),(2923,46,14,191,'M','1','6',33),(2924,46,14,173,'M','1','7',33),(2925,46,14,191,'M','1','7',33),(2926,46,14,187,'7','1','1',33),(2927,46,14,187,'8','1','2',33),(2928,46,14,187,'M','1','3',33),(2929,46,14,187,'M','1','4',33),(2930,46,14,185,'8','1','1',33),(2931,46,14,187,'M','1','5',33),(2932,46,14,187,'M','1','6',33),(2933,46,14,185,'9','1','2',33),(2934,46,14,187,'M','1','7',33),(2935,46,14,185,'1','1','3',33),(2936,46,14,161,'7','1','1',33),(2937,46,14,161,'1','1','2',33),(2938,46,14,161,'1','1','3',33),(2939,46,14,161,'1','1','4',33),(2940,46,14,161,'2','1','5',33),(2941,46,14,161,'M','1','6',33),(2942,46,14,161,'M','1','7',33),(2943,46,14,188,'1','1','1',33),(2944,46,14,188,'2','1','2',33),(2945,46,14,188,'5','1','3',33),(2946,46,14,188,'2','1','4',33),(2947,46,14,188,'2','1','5',33),(2948,46,14,188,'7','1','6',33),(2949,46,14,188,'M','1','7',33),(2950,46,14,191,'1','1','1',33),(2951,46,14,189,'9','1','1',33),(2952,46,14,189,'7','1','2',33),(2953,46,14,189,'3','1','3',33),(2954,46,14,189,'1','1','4',33),(2955,46,14,189,'1','1','5',33),(2956,46,14,185,'M','1','4',33),(2957,46,14,189,'M','1','6',33),(2958,46,14,185,'M','1','5',33),(2959,46,14,185,'M','1','6',33),(2960,46,14,185,'M','1','7',33),(2961,46,14,189,'M','1','7',33),(2962,46,14,157,'M','1','1',33),(2963,46,14,157,'M','1','2',33),(2964,46,14,157,'7','1','3',33),(2965,46,14,157,'1','1','4',33),(2966,46,14,157,'1','1','5',33),(2967,46,14,157,'2','1','6',33),(2968,46,14,157,'2','1','7',33),(2969,46,14,165,'10','2','1',33),(2970,46,14,165,'8','2','2',33),(2971,46,14,165,'7','2','3',33),(2972,46,14,165,'4','2','4',33),(2973,46,14,165,'3','2','5',33),(2974,46,14,165,'1','2','6',33),(2975,46,14,165,'M','2','7',33),(2976,46,14,161,'9','2','1',33),(2977,46,14,161,'9','2','2',33),(2978,46,14,161,'8','2','3',33),(2979,46,14,161,'1','2','4',33),(2980,46,14,161,'6','2','5',33),(2981,46,14,161,'5','2','6',33),(2982,46,14,189,'5','2','1',33),(2983,46,14,161,'4','2','7',33),(2984,46,14,189,'4','2','2',33),(2985,46,14,191,'9','2','1',33),(2986,46,14,189,'3','2','3',33),(2987,46,14,191,'7','2','2',33),(2988,46,14,191,'2','2','3',33),(2989,46,14,189,'1','2','4',33),(2990,46,14,191,'3','2','4',33),(2991,46,14,191,'2','2','5',33),(2992,46,14,191,'M','2','6',33),(2993,46,14,191,'M','2','7',33),(2994,46,14,189,'M','2','5',33),(2995,46,14,189,'M','2','6',33),(2996,46,14,185,'M','2','1',33),(2997,46,14,185,'1','2','2',33),(2999,46,14,189,'2','2','7',33),(3001,46,14,185,'10','2','4',33),(3002,46,14,185,'1','2','5',33),(3003,46,14,173,'1','2','1',33),(3004,46,14,185,'4','2','6',33),(3005,46,14,173,'1','2','2',33),(3006,46,14,185,'6','2','7',33),(3007,46,14,173,'1','2','3',33),(3008,46,14,173,'1','2','4',33),(3009,46,14,173,'1','2','5',33),(3010,46,14,173,'M','2','6',33),(3011,46,14,173,'M','2','7',33),(3013,46,14,187,'10','2','1',33),(3014,46,14,187,'10','2','2',33),(3015,46,14,187,'2','2','3',33),(3016,46,14,187,'7','2','4',33),(3017,46,14,187,'1','2','5',33),(3018,46,14,187,'M','2','6',33),(3019,46,14,187,'M','2','7',33),(3020,46,14,188,'1','2','1',33),(3021,46,14,188,'4','2','2',33),(3022,46,14,188,'4','2','3',33),(3023,46,14,188,'5','2','4',33),(3024,46,14,188,'4','2','5',33),(3025,46,14,188,'7','2','6',33),(3026,46,14,188,'9','2','7',33),(3027,46,14,185,'10','2','3',33),(3028,46,14,157,'1','2','1',33),(3029,46,14,157,'1','2','2',33),(3030,46,14,157,'1','2','3',33),(3031,46,14,157,'1','2','4',33),(3032,46,14,157,'2','2','6',33),(3033,46,14,157,'4','2','7',33),(3034,46,14,157,'1','2','5',33),(3035,46,14,165,'10','1','1',33),(3036,46,14,161,'8','3','1',33),(3037,46,14,161,'5','3','2',33),(3038,46,14,173,'10','3','1',33),(3039,46,14,161,'1','3','3',33),(3040,46,14,173,'7','3','2',33),(3041,46,14,161,'1','3','4',33),(3042,46,14,161,'1','3','5',33),(3043,46,14,161,'M','3','6',33),(3044,46,14,173,'4','3','3',33),(3045,46,14,161,'M','3','7',33),(3046,46,14,173,'M','3','4',33),(3048,46,14,191,'7','3','1',33),(3049,46,14,191,'5','3','2',33),(3050,46,14,191,'6','3','3',33),(3051,46,14,173,'1','3','5',33),(3052,46,14,191,'6','3','4',33),(3053,46,14,173,'M','3','6',33),(3054,46,14,191,'2','3','5',33),(3055,46,14,173,'M','3','7',33),(3056,46,14,191,'M','3','6',33),(3057,46,14,189,'7','3','1',33),(3058,46,14,189,'1','3','2',33),(3059,46,14,189,'1','3','3',33),(3060,46,14,189,'1','3','4',33),(3061,46,14,189,'M','3','5',33),(3062,46,14,189,'M','3','6',33),(3063,46,14,189,'M','3','7',33),(3064,46,14,188,'1','3','1',33),(3065,46,14,165,'8','3','1',33),(3066,46,14,188,'2','3','2',33),(3067,46,14,165,'8','3','2',33),(3068,46,14,165,'8','3','3',33),(3069,46,14,188,'1','3','3',33),(3070,46,14,165,'7','3','4',33),(3071,46,14,188,'1','3','4',33),(3072,46,14,165,'4','3','5',33),(3073,46,14,188,'10','3','5',33),(3074,46,14,165,'1','3','6',33),(3075,46,14,188,'M','3','6',33),(3076,46,14,165,'M','3','7',33),(3077,46,14,188,'M','3','7',33),(3078,46,14,157,'M','3','1',33),(3079,46,14,157,'1','3','2',33),(3080,46,14,185,'M','3','1',33),(3081,46,14,185,'1','3','2',33),(3082,46,14,185,'1','3','3',33),(3083,46,14,185,'1','3','4',33),(3084,46,14,157,'3','3','3',33),(3085,46,14,157,'4','3','4',33),(3086,46,14,185,'9','3','5',33),(3087,46,14,157,'4','3','5',33),(3088,46,14,185,'9','3','6',33),(3089,46,14,157,'6','3','6',33),(3090,46,14,185,'M','3','7',33),(3091,46,14,157,'5','3','7',33),(3092,46,14,187,'10','3','1',33),(3093,46,14,187,'9','3','2',33),(3094,46,14,187,'6','3','3',33),(3095,46,14,187,'1','3','4',33),(3096,46,14,187,'1','3','5',33),(3097,46,14,187,'M','3','6',33),(3098,46,14,187,'M','3','7',33),(3099,46,14,165,'9','4','1',33),(3100,46,14,165,'7','4','2',33),(3101,46,14,165,'7','4','3',33),(3102,46,14,165,'7','4','4',33),(3104,46,14,165,'7','4','5',33),(3105,46,14,165,'3','4','6',33),(3106,46,14,165,'1','4','7',33),(3107,46,14,173,'9','4','1',33),(3108,46,14,173,'5','4','2',33),(3109,46,14,173,'5','4','3',33),(3110,46,14,161,'7','4','1',33),(3111,46,14,161,'7','4','2',33),(3112,46,14,161,'1','4','3',33),(3113,46,14,173,'3','4','4',33),(3114,46,14,161,'1','4','4',33),(3115,46,14,161,'1','4','5',33),(3116,46,14,173,'1','4','5',33),(3117,46,14,173,'1','4','6',33),(3118,46,14,161,'2','4','6',33),(3119,46,14,161,'M','4','7',33),(3121,46,14,191,'10','4','1',33),(3122,46,14,191,'8','4','2',33),(3123,46,14,191,'7','4','3',33),(3124,46,14,191,'2','4','4',33),(3125,46,14,191,'3','4','5',33),(3126,46,14,157,'1','4','1',33),(3127,46,14,191,'1','4','6',33),(3128,46,14,157,'1','4','2',33),(3129,46,14,191,'M','4','7',33),(3130,46,14,191,'M','3','7',33),(3131,46,14,157,'2','4','3',33),(3132,46,14,157,'2','4','4',33),(3133,46,14,185,'1','4','1',33),(3134,46,14,185,'1','4','2',33),(3135,46,14,157,'5','4','5',33),(3136,46,14,157,'6','4','6',33),(3137,46,14,157,'8','4','7',33),(3138,46,14,185,'8','4','3',33),(3139,46,14,189,'7','4','1',33),(3140,46,14,189,'3','4','2',33),(3141,46,14,185,'8','4','4',33),(3142,46,14,189,'3','4','3',33),(3143,46,14,185,'4','4','5',33),(3144,46,14,189,'2','4','4',33),(3145,46,14,185,'2','4','6',33),(3146,46,14,189,'3','4','5',33),(3147,46,14,185,'6','4','7',33),(3148,46,14,189,'1','4','6',33),(3149,46,14,189,'M','4','7',33),(3150,46,14,188,'1','4','1',33),(3151,46,14,188,'6','4','2',33),(3152,46,14,188,'5','4','3',33),(3153,46,14,188,'M','4','4',33),(3154,46,14,188,'M','4','5',33),(3155,46,14,188,'M','4','6',33),(3156,46,14,188,'M','4','7',33),(3157,46,14,187,'5','4','1',33),(3158,46,14,187,'1','4','2',33),(3159,46,14,187,'1','4','3',33),(3160,46,14,187,'M','4','4',33),(3161,46,14,187,'M','4','5',33),(3162,46,14,187,'M','4','6',33),(3163,46,14,187,'M','4','7',33),(3164,46,14,173,'1','4','7',33),(3165,46,14,161,'9','5','1',33),(3166,46,14,161,'9','5','2',33),(3167,46,14,161,'8','5','3',33),(3168,46,14,161,'4','5','4',33),(3169,46,14,161,'1','5','5',33),(3170,46,14,161,'1','5','6',33),(3171,46,14,161,'1','5','7',33),(3172,46,14,173,'3','5','1',33),(3173,46,14,165,'9','5','1',33),(3174,46,14,173,'1','5','2',33),(3175,46,14,165,'8','5','2',33),(3176,46,14,173,'1','5','3',33),(3177,46,14,165,'7','5','3',33),(3178,46,14,173,'1','5','4',33),(3179,46,14,165,'7','5','4',33),(3180,46,14,173,'1','5','5',33),(3181,46,14,165,'7','5','5',33),(3182,46,14,165,'4','5','6',33),(3183,46,14,173,'M','5','6',33),(3184,46,14,165,'M','5','7',33),(3185,46,14,173,'M','5','7',33),(3186,46,14,191,'9','5','1',33),(3187,46,14,191,'7','5','2',33),(3188,46,14,191,'1','5','3',33),(3189,46,14,157,'M','5','1',33),(3190,46,14,191,'1','5','4',33),(3191,46,14,157,'M','5','2',33),(3192,46,14,191,'1','5','5',33),(3193,46,14,157,'M','5','3',33),(3194,46,14,191,'2','5','6',33),(3195,46,14,191,'M','5','7',33),(3196,46,14,157,'1','5','4',33),(3197,46,14,157,'4','5','5',33),(3198,46,14,157,'9','5','6',33),(3199,46,14,157,'7','5','7',33),(3200,46,14,185,'8','5','1',33),(3201,46,14,185,'7','5','2',33),(3202,46,14,185,'2','5','3',33),(3203,46,14,185,'4','5','4',33),(3204,46,14,185,'4','5','5',33),(3205,46,14,185,'1','5','6',33),(3206,46,14,188,'M','5','1',33),(3207,46,14,188,'1','5','2',33),(3208,46,14,185,'1','5','7',33),(3209,46,14,188,'3','5','3',33),(3210,46,14,188,'3','5','4',33),(3211,46,14,188,'M','5','5',33),(3212,46,14,188,'M','5','6',33),(3213,46,14,188,'M','5','7',33),(3214,46,14,189,'2','5','1',33),(3215,46,14,189,'1','5','2',33),(3216,46,14,189,'1','5','3',33),(3217,46,14,189,'7','5','4',33),(3218,46,14,189,'M','5','5',33),(3219,46,14,189,'M','5','6',33),(3220,46,14,189,'M','5','7',33),(3221,46,14,187,'8','5','1',33),(3222,46,14,187,'8','5','2',33),(3223,46,14,187,'7','5','3',33),(3224,46,14,187,'1','5','4',33),(3225,46,14,187,'M','5','5',33),(3226,46,14,187,'M','5','6',33),(3227,46,14,187,'M','5','7',33),(3228,46,14,173,'5','6','1',33),(3229,46,14,173,'6','6','2',33),(3230,46,14,173,'2','6','3',33),(3231,46,14,165,'10','6','1',33),(3232,46,14,173,'1','6','4',33),(3233,46,14,165,'6','6','2',33),(3234,46,14,165,'4','6','3',33),(3235,46,14,173,'M','6','5',33),(3236,46,14,165,'1','6','4',33),(3237,46,14,173,'M','6','6',33),(3238,46,14,165,'1','6','5',33),(3239,46,14,173,'M','6','7',33),(3240,46,14,165,'1','6','6',33),(3241,46,14,165,'1','6','7',33),(3242,46,14,161,'9','6','1',33),(3243,46,14,161,'9','6','2',33),(3244,46,14,188,'1','6','1',33),(3245,46,14,161,'8','6','3',33),(3246,46,14,188,'8','6','2',33),(3247,46,14,161,'7','6','4',33),(3248,46,14,188,'8','6','3',33),(3249,46,14,161,'3','6','5',33),(3250,46,14,161,'5','6','6',33),(3251,46,14,188,'8','6','4',33),(3252,46,14,161,'1','6','7',33),(3253,46,14,188,'1','6','5',33),(3254,46,14,188,'M','6','6',33),(3255,46,14,191,'9','6','1',33),(3256,46,14,188,'M','6','7',33),(3257,46,14,191,'10','6','2',33),(3258,46,14,191,'4','6','3',33),(3259,46,14,191,'1','6','4',33),(3260,46,14,191,'1','6','5',33),(3262,46,14,191,'M','6','7',33),(3263,46,14,189,'8','6','1',33),(3264,46,14,189,'3','6','2',33),(3265,46,14,189,'1','6','3',33),(3266,46,14,189,'1','6','4',33),(3267,46,14,191,'1','6','6',33),(3268,46,14,189,'M','6','5',33),(3269,46,14,189,'M','6','6',33),(3270,46,14,189,'M','6','7',33),(3271,46,14,185,'M','6','1',33),(3272,46,14,185,'M','6','2',33),(3273,46,14,187,'M','6','2',33),(3274,46,14,187,'M','6','3',33),(3275,46,14,185,'1','6','3',33),(3276,46,14,185,'7','6','4',33),(3277,46,14,185,'2','6','5',33),(3278,46,14,185,'6','6','6',33),(3279,46,14,187,'M','6','1',33),(3280,46,14,187,'3','6','6',33),(3281,46,14,187,'1','6','7',33),(3282,46,14,187,'4','6','5',33),(3283,46,14,185,'M','6','7',33),(3284,46,14,157,'M','6','1',33),(3285,46,14,157,'1','6','2',33),(3286,46,14,157,'2','6','3',33),(3287,46,14,157,'3','6','4',33),(3288,46,14,157,'4','6','5',33),(3289,46,14,157,'6','6','6',33),(3290,46,14,157,'8','6','7',33),(3292,46,14,186,'7','1','2',35),(3293,46,14,186,'7','1','3',35),(3294,46,14,186,'3','1','4',35),(3295,46,14,186,'2','1','5',35),(3296,46,14,186,'4','1','6',35),(3301,46,14,186,'8','1','1',35),(3302,46,14,165,'10','1','1',35),(3303,46,14,165,'8','1','2',35),(3304,46,14,165,'8','1','3',35),(3305,46,14,165,'8','1','4',35),(3306,46,14,165,'8','1','5',35),(3307,46,14,165,'8','1','6',35),(3308,46,14,165,'6','1','7',35),(3309,46,14,165,'1','1','8',35),(3313,46,14,188,'6','1','2',35),(3314,46,14,188,'6','1','3',35),(3315,46,14,188,'1','1','4',35),(3317,46,14,186,'1','1','7',35),(3319,46,14,186,'1','1','9',35),(3320,46,14,186,'1','1','8',35),(3321,46,14,187,'8','1','3',35),(3322,46,14,187,'7','1','4',35),(3324,46,14,187,'1','1','6',35),(3325,46,14,187,'6','1','7',35),(3326,46,14,190,'1','1','1',35),(3327,46,14,190,'1','1','2',35),(3328,46,14,190,'2','1','3',35),(3329,46,14,187,'1','1','8',35),(3330,46,14,190,'6','1','4',35),(3331,46,14,190,'4','1','5',35),(3332,46,14,190,'M','1','6',35),(3333,46,14,190,'M','1','7',35),(3334,46,14,190,'M','1','8',35),(3335,46,14,190,'M','1','9',35),(3336,46,14,191,'5','1','1',35),(3337,46,14,191,'7','1','2',35),(3338,46,14,191,'1','1','3',35),(3339,46,14,191,'1','1','4',35),(3342,46,14,189,'8','1','1',35),(3343,46,14,189,'5','1','2',35),(3345,46,14,153,'2','1','1',35),(3346,46,14,153,'1','1','2',35),(3347,46,14,189,'3','1','3',35),(3348,46,14,189,'3','1','4',35),(3349,46,14,189,'2','1','5',35),(3350,46,14,153,'8','1','3',35),(3351,46,14,189,'1','1','6',35),(3352,46,14,153,'1','1','4',35),(3353,46,14,189,'1','1','7',35),(3354,46,14,153,'10','1','5',35),(3355,46,14,189,'M','1','8',35),(3356,46,14,189,'M','1','9',35),(3357,46,14,153,'2','1','6',35),(3358,46,14,153,'1','1','7',35),(3359,46,14,157,'1','1','3',35),(3360,46,14,157,'1','1','4',35),(3361,46,14,157,'4','1','5',35),(3362,46,14,157,'4','1','6',35),(3363,46,14,157,'6','1','7',35),(3364,46,14,157,'8','1','8',35),(3365,46,14,157,'9','1','9',35),(3366,46,14,192,'1','1','1',35),(3367,46,14,192,'1','1','2',35),(3368,46,14,192,'1','1','4',35),(3369,46,14,192,'1','1','3',35),(3370,46,14,192,'3','1','5',35),(3371,46,14,192,'3','1','6',35),(3372,46,14,192,'M','1','8',35),(3373,46,14,192,'M','1','9',35),(3374,46,14,192,'M','1','7',35),(3376,46,14,190,'3','2','2',35),(3377,46,14,190,'3','2','3',35),(3378,46,14,190,'6','2','4',35),(3379,46,14,190,'1','2','5',35),(3380,46,14,190,'8','2','6',35),(3381,46,14,190,'1','2','7',35),(3382,46,14,190,'M','2','8',35),(3383,46,14,190,'M','2','9',35),(3385,46,14,189,'7','2','2',35),(3386,46,14,189,'1','2','3',35),(3387,46,14,189,'M','2','4',35),(3388,46,14,189,'M','2','5',35),(3390,46,14,189,'M','2','7',35),(3391,46,14,189,'M','2','8',35),(3392,46,14,189,'M','2','9',35),(3393,46,14,186,'8','2','1',35),(3394,46,14,186,'7','2','2',35),(3395,46,14,186,'3','2','3',35),(3396,46,14,186,'1','2','4',35),(3397,46,14,186,'1','2','5',35),(3398,46,14,186,'1','2','6',35),(3399,46,14,186,'1','2','7',35),(3400,46,14,186,'M','2','8',35),(3401,46,14,186,'M','2','9',35),(3402,46,14,188,'1','1','1',35),(3403,46,14,188,'3','2','1',35),(3404,46,14,188,'4','2','2',35),(3405,46,14,188,'6','2','3',35),(3406,46,14,188,'2','2','4',35),(3407,46,14,188,'1','2','5',35),(3408,46,14,188,'2','2','6',35),(3409,46,14,188,'8','2','7',35),(3410,46,14,189,'1','2','1',35),(3411,46,14,187,'2','1','5',35),(3412,46,14,187,'1','1','9',35),(3413,46,14,189,'M','2','6',35),(3414,46,14,190,'1','2','1',35),(3415,46,14,157,'M','2','1',35),(3416,46,14,157,'M','2','2',35),(3417,46,14,157,'M','2','3',35),(3418,46,14,165,'8','2','1',35),(3419,46,14,165,'8','2','2',35),(3420,46,14,165,'8','2','3',35),(3421,46,14,165,'8','2','4',35),(3422,46,14,165,'8','2','5',35),(3423,46,14,165,'7','2','6',35),(3424,46,14,157,'1','2','4',35),(3425,46,14,157,'3','2','5',35),(3426,46,14,165,'1','2','7',35),(3427,46,14,157,'4','2','6',35),(3428,46,14,165,'1','2','8',35),(3429,46,14,157,'3','2','7',35),(3430,46,14,157,'6','2','8',35),(3431,46,14,157,'10','2','9',35),(3432,46,14,191,'4','2','1',35),(3433,46,14,191,'3','2','2',35),(3434,46,14,191,'7','2','3',35),(3435,46,14,191,'8','2','4',35),(3436,46,14,191,'10','2','5',35),(3437,46,14,153,'7','2','1',35),(3438,46,14,153,'4','2','2',35),(3439,46,14,191,'1','2','6',35),(3440,46,14,153,'3','2','3',35),(3441,46,14,191,'1','2','7',35),(3442,46,14,191,'1','2','8',35),(3443,46,14,153,'2','2','4',35),(3444,46,14,191,'M','2','9',35),(3445,46,14,153,'1','2','5',35),(3446,46,14,153,'1','2','6',35),(3447,46,14,153,'1','2','7',35),(3449,46,14,192,'1','2','1',35),(3450,46,14,192,'9','2','2',35),(3451,46,14,192,'10','2','3',35),(3453,46,14,192,'M','2','4',35),(3454,46,14,192,'M','2','5',35),(3455,46,14,192,'M','2','6',35),(3456,46,14,192,'M','2','7',35),(3457,46,14,192,'M','2','8',35),(3458,46,14,192,'M','2','9',35),(3459,46,14,190,'1','3','1',35),(3460,46,14,190,'1','3','2',35),(3461,46,14,190,'2','3','3',35),(3462,46,14,190,'6','3','4',35),(3463,46,14,190,'M','3','5',35),(3464,46,14,190,'M','3','6',35),(3465,46,14,190,'M','3','7',35),(3466,46,14,190,'M','3','8',35),(3467,46,14,190,'M','3','9',35),(3468,46,14,188,'1','3','1',35),(3469,46,14,188,'2','3','2',35),(3470,46,14,188,'4','3','3',35),(3471,46,14,189,'10','3','1',35),(3472,46,14,189,'8','3','2',35),(3473,46,14,189,'7','3','3',35),(3474,46,14,188,'3','3','4',35),(3475,46,14,189,'5','3','4',35),(3476,46,14,188,'6','3','5',35),(3477,46,14,188,'1','3','6',35),(3478,46,14,188,'1','3','7',35),(3479,46,14,189,'5','3','5',35),(3480,46,14,189,'1','3','6',35),(3481,46,14,189,'1','3','7',35),(3482,46,14,188,'4','3','9',35),(3483,46,14,189,'1','3','8',35),(3484,46,14,189,'M','3','9',35),(3485,46,14,187,'4','2','3',35),(3486,46,14,187,'2','2','4',35),(3487,46,14,187,'2','2','5',35),(3488,46,14,187,'1','2','6',35),(3489,46,14,187,'1','2','7',35),(3490,46,14,187,'1','2','8',35),(3491,46,14,187,'2','2','9',35),(3492,46,14,165,'8','3','1',35),(3493,46,14,165,'7','3','2',35),(3494,46,14,165,'5','3','3',35),(3495,46,14,157,'M','3','1',35),(3496,46,14,165,'4','3','4',35),(3497,46,14,165,'3','3','5',35),(3498,46,14,165,'2','3','6',35),(3499,46,14,157,'1','3','2',35),(3500,46,14,165,'1','3','7',35),(3501,46,14,157,'1','3','3',35),(3502,46,14,157,'3','3','4',35),(3503,46,14,157,'4','3','5',35),(3504,46,14,157,'4','3','6',35),(3505,46,14,157,'4','3','7',35),(3506,46,14,165,'1','3','8',35),(3507,46,14,157,'5','3','8',35),(3508,46,14,157,'6','3','9',35),(3509,46,14,165,'4','3','9',35),(3510,46,14,186,'8','3','1',35),(3511,46,14,186,'4','3','2',35),(3512,46,14,186,'3','3','3',35),(3513,46,14,191,'7','3','1',35),(3514,46,14,186,'3','3','4',35),(3515,46,14,191,'4','3','2',35),(3516,46,14,191,'5','3','3',35),(3517,46,14,186,'2','3','5',35),(3518,46,14,186,'2','3','6',35),(3519,46,14,186,'1','3','7',35),(3520,46,14,186,'1','3','8',35),(3521,46,14,191,'3','3','4',35),(3522,46,14,191,'3','3','5',35),(3523,46,14,191,'1','3','6',35),(3524,46,14,191,'1','3','7',35),(3525,46,14,191,'M','3','8',35),(3526,46,14,191,'M','3','9',35),(3527,46,14,192,'1','3','1',35),(3528,46,14,192,'1','3','2',35),(3529,46,14,192,'2','3','3',35),(3530,46,14,192,'2','3','4',35),(3531,46,14,192,'3','3','5',35),(3532,46,14,192,'3','3','6',35),(3533,46,14,192,'6','3','7',35),(3534,46,14,192,'7','3','8',35),(3535,46,14,192,'M','3','9',35),(3536,46,14,190,'1','4','1',35),(3537,46,14,190,'1','4','2',35),(3538,46,14,190,'6','4','3',35),(3539,46,14,190,'5','4','4',35),(3540,46,14,190,'8','4','5',35),(3541,46,14,190,'M','4','6',35),(3542,46,14,190,'M','4','7',35),(3543,46,14,190,'M','4','8',35),(3544,46,14,190,'M','4','9',35),(3545,46,14,189,'7','4','1',35),(3546,46,14,189,'6','4','2',35),(3547,46,14,189,'2','4','3',35),(3548,46,14,189,'2','4','4',35),(3549,46,14,189,'2','4','5',35),(3550,46,14,189,'1','4','6',35),(3551,46,14,189,'1','4','7',35),(3552,46,14,189,'M','4','8',35),(3553,46,14,189,'M','4','9',35),(3554,46,14,165,'9','4','1',35),(3555,46,14,165,'8','4','2',35),(3556,46,14,165,'7','4','3',35),(3557,46,14,165,'7','4','4',35),(3558,46,14,165,'6','4','5',35),(3559,46,14,165,'4','4','6',35),(3560,46,14,165,'3','4','7',35),(3561,46,14,165,'2','4','8',35),(3563,46,14,165,'M','4','9',35),(3564,46,14,191,'7','4','1',35),(3565,46,14,191,'9','4','2',35),(3566,46,14,191,'1','4','3',35),(3567,46,14,191,'4','4','4',35),(3568,46,14,191,'5','4','5',35),(3569,46,14,191,'6','4','6',35),(3570,46,14,191,'2','4','7',35),(3571,46,14,191,'M','4','8',35),(3572,46,14,191,'M','4','9',35),(3573,46,14,187,'7','3','1',35),(3574,46,14,187,'7','3','2',35),(3575,46,14,187,'1','3','3',35),(3576,46,14,187,'1','3','4',35),(3577,46,14,187,'5','3','5',35),(3578,46,14,187,'M','3','6',35),(3579,46,14,187,'M','3','7',35),(3580,46,14,187,'M','3','8',35),(3581,46,14,187,'M','3','9',35),(3582,46,14,157,'10','4','1',35),(3583,46,14,157,'9','4','2',35),(3584,46,14,157,'6','4','3',35),(3585,46,14,157,'3','4','4',35),(3586,46,14,157,'3','4','5',35),(3587,46,14,157,'1','4','6',35),(3588,46,14,157,'1','4','8',35),(3589,46,14,157,'1','4','7',35),(3590,46,14,157,'M','4','9',35),(3591,46,14,153,'4','4','1',35),(3592,46,14,153,'4','4','2',35),(3593,46,14,153,'2','4','3',35),(3594,46,14,153,'1','4','4',35),(3595,46,14,153,'1','4','5',35),(3596,46,14,153,'M','4','6',35),(3597,46,14,153,'M','4','8',35),(3598,46,14,153,'M','4','9',35),(3599,46,14,153,'M','4','7',35),(3601,46,14,153,'7','3','2',35),(3602,46,14,153,'8','3','3',35),(3603,46,14,153,'6','3','4',35),(3604,46,14,153,'4','3','5',35),(3605,46,14,153,'9','3','6',35),(3606,46,14,153,'M','3','8',35),(3607,46,14,188,'1','4','2',35),(3608,46,14,188,'1','4','3',35),(3609,46,14,188,'4','4','4',35),(3610,46,14,188,'8','4','5',35),(3611,46,14,188,'1','4','6',35),(3612,46,14,188,'M','4','7',35),(3613,46,14,188,'M','4','9',35),(3614,46,14,188,'M','4','8',35),(3615,46,14,186,'10','4','1',35),(3616,46,14,186,'5','4','2',35),(3617,46,14,186,'5','4','3',35),(3618,46,14,186,'4','4','4',35),(3619,46,14,186,'2','4','5',35),(3620,46,14,186,'1','4','6',35),(3621,46,14,186,'1','4','7',35),(3622,46,14,186,'1','4','8',35),(3623,46,14,186,'M','4','9',35),(3624,46,14,190,'3','5','1',35),(3625,46,14,190,'1','5','2',35),(3626,46,14,190,'M','5','3',35),(3627,46,14,190,'M','5','4',35),(3628,46,14,190,'M','5','5',35),(3629,46,14,190,'M','5','6',35),(3630,46,14,190,'M','5','7',35),(3631,46,14,190,'M','5','8',35),(3632,46,14,190,'M','5','9',35),(3633,46,14,165,'10','5','1',35),(3634,46,14,165,'8','5','2',35),(3635,46,14,189,'4','5','1',35),(3636,46,14,165,'7','5','3',35),(3637,46,14,189,'4','5','2',35),(3638,46,14,165,'3','5','4',35),(3639,46,14,189,'1','5','3',35),(3640,46,14,189,'1','5','4',35),(3641,46,14,189,'1','5','5',35),(3642,46,14,189,'1','5','6',35),(3643,46,14,189,'M','5','7',35),(3644,46,14,189,'M','5','8',35),(3645,46,14,189,'M','5','9',35),(3646,46,14,165,'M','5','5',35),(3647,46,14,165,'M','5','6',35),(3648,46,14,165,'1','5','7',35),(3649,46,14,165,'1','5','8',35),(3650,46,14,165,'1','5','9',35),(3651,46,14,187,'7','4','1',35),(3652,46,14,187,'4','4','2',35),(3653,46,14,157,'M','5','1',35),(3654,46,14,187,'1','4','3',35),(3655,46,14,157,'1','5','2',35),(3656,46,14,187,'M','4','4',35),(3657,46,14,187,'M','4','5',35),(3658,46,14,157,'1','5','3',35),(3659,46,14,187,'M','4','6',35),(3660,46,14,157,'1','5','4',35),(3661,46,14,187,'M','4','7',35),(3662,46,14,187,'M','4','8',35),(3663,46,14,187,'M','4','9',35),(3664,46,14,157,'7','5','5',35),(3665,46,14,157,'7','5','6',35),(3666,46,14,157,'2','5','7',35),(3667,46,14,157,'4','5','8',35),(3668,46,14,157,'M','5','9',35),(3669,46,14,153,'2','5','1',35),(3670,46,14,153,'1','5','2',35),(3671,46,14,153,'1','5','3',35),(3672,46,14,153,'1','5','4',35),(3673,46,14,153,'3','5','5',35),(3674,46,14,153,'3','5','6',35),(3675,46,14,153,'4','5','7',35),(3676,46,14,153,'M','5','8',35),(3677,46,14,153,'M','5','9',35),(3678,46,14,186,'9','5','1',35),(3679,46,14,186,'8','5','2',35),(3680,46,14,186,'7','5','3',35),(3681,46,14,191,'7','5','1',35),(3682,46,14,191,'7','5','2',35),(3683,46,14,186,'6','5','4',35),(3684,46,14,191,'2','5','3',35),(3685,46,14,186,'5','5','5',35),(3686,46,14,191,'1','5','4',35),(3687,46,14,191,'1','5','5',35),(3688,46,14,191,'M','5','6',35),(3689,46,14,186,'3','5','6',35),(3690,46,14,191,'M','5','7',35),(3691,46,14,186,'1','5','7',35),(3692,46,14,186,'1','5','8',35),(3693,46,14,191,'M','5','8',35),(3694,46,14,186,'M','5','9',35),(3695,46,14,191,'M','5','9',35),(3696,46,14,188,'8','5','1',35),(3697,46,14,188,'10','5','2',35),(3698,46,14,188,'3','5','3',35),(3699,46,14,188,'3','5','4',35),(3700,46,14,188,'1','5','5',35),(3701,46,14,188,'1','5','6',35),(3702,46,14,188,'M','5','7',35),(3703,46,14,188,'M','5','8',35),(3704,46,14,188,'M','5','9',35),(3705,46,14,190,'1','6','1',35),(3706,46,14,190,'1','6','2',35),(3707,46,14,190,'4','6','3',35),(3708,46,14,190,'4','6','4',35),(3709,46,14,191,'7','6','1',35),(3710,46,14,191,'7','6','2',35),(3711,46,14,191,'4','6','3',35),(3712,46,14,190,'7','6','5',35),(3713,46,14,191,'1','6','4',35),(3714,46,14,190,'7','6','6',35),(3715,46,14,191,'1','6','5',35),(3716,46,14,191,'M','6','6',35),(3717,46,14,191,'M','6','7',35),(3718,46,14,190,'M','6','7',35),(3719,46,14,191,'M','6','8',35),(3720,46,14,190,'M','6','8',35),(3721,46,14,191,'M','6','9',35),(3722,46,14,190,'M','6','9',35),(3723,46,14,189,'5','6','1',35),(3724,46,14,189,'4','6','2',35),(3725,46,14,187,'7','5','1',35),(3726,46,14,189,'4','6','3',35),(3727,46,14,187,'3','5','2',35),(3728,46,14,187,'5','5','3',35),(3729,46,14,189,'3','6','4',35),(3730,46,14,187,'1','5','4',35),(3731,46,14,187,'1','5','5',35),(3732,46,14,189,'1','6','5',35),(3733,46,14,187,'1','5','6',35),(3734,46,14,189,'1','6','6',35),(3735,46,14,187,'1','5','7',35),(3736,46,14,189,'1','6','7',35),(3737,46,14,189,'1','6','8',35),(3738,46,14,187,'1','5','8',35),(3739,46,14,189,'M','6','9',35),(3740,46,14,187,'M','5','9',35),(3741,46,14,157,'1','6','1',35),(3742,46,14,165,'7','6','1',35),(3743,46,14,157,'1','6','2',35),(3744,46,14,165,'7','6','2',35),(3745,46,14,157,'1','6','3',35),(3746,46,14,165,'7','6','3',35),(3747,46,14,165,'3','6','4',35),(3748,46,14,165,'2','6','5',35),(3749,46,14,165,'1','6','6',35),(3750,46,14,157,'1','6','4',35),(3751,46,14,165,'1','6','7',35),(3752,46,14,165,'1','6','8',35),(3753,46,14,165,'1','6','9',35),(3754,46,14,157,'3','6','5',35),(3755,46,14,157,'6','6','6',35),(3756,46,14,157,'5','6','7',35),(3757,46,14,157,'8','6','8',35),(3758,46,14,157,'M','6','9',35),(3759,46,14,186,'8','6','1',35),(3760,46,14,186,'5','6','2',35),(3761,46,14,186,'3','6','3',35),(3762,46,14,186,'1','6','4',35),(3763,46,14,186,'1','6','5',35),(3764,46,14,186,'1','6','6',35),(3765,46,14,186,'1','6','7',35),(3766,46,14,186,'M','6','8',35),(3767,46,14,186,'M','6','9',35),(3768,46,14,153,'2','6','1',35),(3769,46,14,153,'5','6','2',35),(3770,46,14,153,'5','6','3',35),(3771,46,14,153,'8','6','4',35),(3772,46,14,153,'1','6','5',35),(3773,46,14,153,'1','6','6',35),(3774,46,14,153,'1','6','7',35),(3775,46,14,153,'1','6','8',35),(3776,46,14,153,'M','6','9',35),(3777,46,14,188,'8','6','1',35),(3778,46,14,188,'6','6','2',35),(3779,46,14,188,'4','6','3',35),(3780,46,14,188,'4','6','4',35),(3781,46,14,188,'1','6','5',35),(3782,46,14,188,'M','6','6',35),(3783,46,14,188,'M','6','7',35),(3784,46,14,188,'M','6','8',35),(3785,46,14,188,'M','6','9',35),(3786,46,14,190,'8','7','1',35),(3787,46,14,190,'8','7','2',35),(3788,46,14,165,'9','7','1',35),(3789,46,14,190,'1','7','3',35),(3790,46,14,165,'8','7','2',35),(3791,46,14,190,'1','7','4',35),(3792,46,14,165,'8','7','3',35),(3793,46,14,165,'7','7','4',35),(3794,46,14,190,'1','7','5',35),(3795,46,14,165,'7','7','5',35),(3796,46,14,165,'6','7','6',35),(3797,46,14,165,'5','7','7',35),(3798,46,14,190,'M','7','6',35),(3799,46,14,165,'5','7','8',35),(3800,46,14,190,'M','7','7',35),(3801,46,14,190,'M','7','8',35),(3802,46,14,190,'M','7','9',35),(3803,46,14,165,'M','7','9',35),(3804,46,14,189,'5','7','1',35),(3805,46,14,189,'5','7','2',35),(3807,46,14,191,'2','7','1',35),(3808,46,14,191,'4','7','2',35),(3809,46,14,191,'1','7','3',35),(3810,46,14,191,'1','7','4',35),(3811,46,14,189,'4','7','3',35),(3812,46,14,191,'M','7','5',35),(3813,46,14,189,'2','7','4',35),(3814,46,14,191,'M','7','6',35),(3815,46,14,189,'2','7','5',35),(3816,46,14,191,'M','7','7',35),(3817,46,14,191,'M','7','8',35),(3818,46,14,189,'1','7','6',35),(3819,46,14,191,'M','7','9',35),(3820,46,14,189,'2','7','7',35),(3821,46,14,189,'1','7','8',35),(3823,46,14,189,'M','7','9',35),(3824,46,14,186,'6','7','1',35),(3825,46,14,186,'5','7','2',35),(3826,46,14,186,'4','7','3',35),(3827,46,14,186,'3','7','4',35),(3828,46,14,186,'3','7','5',35),(3829,46,14,157,'10','7','1',35),(3830,46,14,186,'3','7','6',35),(3831,46,14,157,'9','7','2',35),(3832,46,14,186,'2','7','7',35),(3833,46,14,157,'7','7','3',35),(3834,46,14,186,'M','7','8',35),(3835,46,14,157,'1','7','4',35),(3836,46,14,186,'M','7','9',35),(3837,46,14,157,'1','7','5',35),(3838,46,14,157,'1','7','6',35),(3839,46,14,157,'2','7','7',35),(3840,46,14,157,'4','7','8',35),(3841,46,14,157,'6','7','9',35),(3842,46,14,153,'1','7','1',35),(3843,46,14,153,'8','7','2',35),(3844,46,14,153,'1','7','3',35),(3845,46,14,153,'6','7','4',35),(3846,46,14,153,'2','7','5',35),(3847,46,14,153,'3','7','6',35),(3848,46,14,153,'1','7','7',35),(3849,46,14,153,'M','7','8',35),(3850,46,14,153,'M','7','9',35),(3851,46,14,187,'5','6','1',35),(3852,46,14,187,'2','6','2',35),(3853,46,14,187,'1','6','3',35),(3854,46,14,187,'1','6','4',35),(3855,46,14,187,'1','6','5',35),(3856,46,14,187,'M','6','6',35),(3857,46,14,187,'M','6','7',35),(3858,46,14,187,'M','6','8',35),(3859,46,14,187,'M','6','9',35),(3860,46,14,188,'7','7','1',35),(3861,46,14,188,'8','7','2',35),(3862,46,14,188,'8','7','3',35),(3863,46,14,188,'8','7','4',35),(3864,46,14,188,'3','7','5',35),(3865,46,14,188,'M','7','6',35),(3866,46,14,188,'M','7','7',35),(3867,46,14,188,'M','7','8',35),(3868,46,14,188,'M','7','9',35),(3882,2,11,15,'x','3','3',8),(3883,2,11,15,'x','3','2',8),(3884,2,11,15,'x','4','1',8),(3885,2,11,18,'x','3','1',8),(3886,2,11,18,'x','3','2',8),(3887,2,11,18,'x','3','3',8),(3888,2,11,20,'x','3','1',8),(3889,2,11,20,'x','3','2',8),(3890,2,11,20,'x','3','3',8),(3891,2,11,22,'x','1','2',8),(3892,2,11,22,'x','1','3',8),(3893,2,11,22,'x','2','1',8),(3894,2,11,22,'x','2','2',8),(3895,2,11,22,'x','2','3',8),(3896,2,11,17,'x','1','2',8),(3897,2,11,17,'x','1','3',8),(3898,2,11,17,'x','2','1',8),(3899,2,11,17,'x','2','2',8),(3900,2,11,17,'x','2','3',8),(3901,2,11,17,'x','3','1',8),(3902,2,11,17,'x','3','2',8),(3903,2,11,17,'x','3','3',8),(3904,2,11,17,'x','4','2',8),(3905,2,11,17,'x','4','1',8),(3906,2,12,76,'8','1','1',38),(3907,2,12,76,'10','1','2',38),(3908,2,12,76,'x','1','3',38),(3909,46,14,165,'9','1','1',39),(3910,46,14,165,'1','1','2',39),(3911,46,14,165,'8','1','3',39),(3912,46,14,165,'7','2','1',39),(3913,46,14,165,'10','2','2',39),(3914,46,14,165,'8','2','3',39),(3917,2,11,15,'x','4','2',8),(3918,2,11,15,'x','4','3',8),(3919,46,14,165,'4','1','1',40),(3920,46,14,165,'4','1','2',40),(3921,46,14,165,'1','1','3',40),(3922,46,14,165,'M','1','4',40),(3923,46,14,165,'M','1','5',40),(3924,46,14,165,'M','1','6',40),(3925,46,14,165,'M','1','7',40),(3926,46,14,165,'3','2','1',40),(3927,46,14,165,'2','2','2',40),(3928,46,14,165,'2','2','3',40),(3929,46,14,165,'1','2','4',40),(3930,46,14,165,'M','2','5',40),(3931,46,14,165,'M','2','6',40),(3932,46,14,165,'M','2','7',40),(3933,46,14,165,'5','3','1',40),(3934,46,14,165,'3','3','2',40),(3935,46,14,165,'3','3','3',40),(3936,46,14,165,'M','3','4',40),(3937,46,14,165,'M','3','5',40),(3938,46,14,165,'M','3','6',40),(3939,46,14,165,'M','3','7',40),(3940,46,14,165,'6','4','1',40),(3941,46,14,165,'2','4','2',40),(3942,46,14,165,'M','4','3',40),(3943,46,14,165,'M','4','4',40),(3944,46,14,165,'M','4','5',40),(3945,46,14,165,'M','4','6',40),(3946,46,14,165,'M','4','7',40),(3947,46,14,165,'1','5','1',40),(3948,46,14,165,'1','5','2',40),(3949,46,14,165,'1','5','3',40),(3950,46,14,165,'1','5','4',40),(3951,46,14,165,'1','5','5',40),(3952,46,14,165,'M','5','6',40),(3953,46,14,165,'M','5','7',40),(3954,46,14,169,'3','1','1',40),(3955,46,14,169,'2','1','2',40),(3956,46,14,169,'M','1','3',40),(3957,46,14,169,'M','1','4',40),(3958,46,14,169,'M','1','5',40),(3959,46,14,169,'M','1','6',40),(3960,46,14,169,'M','1','7',40),(3961,46,14,169,'M','2','1',40),(3962,46,14,169,'M','2','2',40),(3963,46,14,169,'M','2','3',40),(3964,46,14,169,'M','2','4',40),(3965,46,14,169,'M','2','5',40),(3966,46,14,169,'M','2','6',40),(3967,46,14,169,'M','2','7',40),(3968,46,14,169,'2','3','1',40),(3969,46,14,169,'1','3','2',40),(3970,46,14,169,'M','3','3',40),(3971,46,14,169,'M','3','4',40),(3972,46,14,169,'M','3','5',40),(3973,46,14,169,'M','3','6',40),(3974,46,14,169,'M','3','7',40),(3975,46,14,169,'4','4','1',40),(3976,46,14,169,'3','4','2',40),(3977,46,14,169,'2','4','3',40),(3978,46,14,169,'1','4','4',40),(3979,46,14,169,'1','4','5',40),(3980,46,14,169,'1','4','6',40),(3981,46,14,169,'M','4','7',40),(3982,46,14,169,'5','5','1',40),(3983,46,14,169,'3','5','2',40),(3984,46,14,169,'2','5','3',40),(3985,46,14,169,'M','5','4',40),(3986,46,14,169,'M','5','5',40),(3987,46,14,169,'M','5','6',40),(3988,46,14,169,'M','5','7',40),(3989,46,14,161,'4','1','1',40),(3990,46,14,161,'2','1','2',40),(3991,46,14,161,'2','1','3',40),(3992,46,14,161,'1','1','4',40),(3993,46,14,161,'1','1','5',40),(3994,46,14,161,'M','1','6',40),(3995,46,14,161,'M','1','7',40),(3996,46,14,161,'2','2','1',40),(3997,46,14,161,'1','2','2',40),(3998,46,14,161,'M','2','3',40),(3999,46,14,161,'M','2','4',40),(4000,46,14,161,'M','2','5',40),(4001,46,14,161,'M','2','6',40),(4002,46,14,161,'M','2','7',40),(4003,46,14,161,'3','3','1',40),(4004,46,14,161,'1','3','2',40),(4005,46,14,161,'1','3','3',40),(4006,46,14,161,'M','3','4',40),(4007,46,14,161,'m','3','5',40),(4008,46,14,161,'M','3','6',40),(4009,46,14,161,'M','3','7',40),(4010,46,14,161,'5','4','1',40),(4011,46,14,161,'3','4','2',40),(4012,46,14,161,'M','4','3',40),(4013,46,14,161,'M','4','4',40),(4014,46,14,161,'M','4','5',40),(4015,46,14,161,'M','4','6',40),(4016,46,14,161,'M','4','7',40),(4017,46,14,161,'3','5','1',40),(4018,46,14,161,'M','5','2',40),(4019,46,14,161,'M','5','3',40),(4020,46,14,161,'M','5','4',40),(4021,46,14,161,'M','5','5',40),(4022,46,14,161,'M','5','6',40),(4023,46,14,161,'M','5','7',40),(4024,46,14,185,'2','1','1',40),(4025,46,14,185,'4','2','1',40),(4026,46,14,185,'2','3','1',40),(4027,46,14,185,'2','3','2',40),(4028,46,14,185,'4','4','1',40),(4029,46,14,185,'3','4','2',40),(4030,46,14,185,'2','4','3',40),(4031,46,14,185,'2','5','1',40),(4032,46,14,185,'2','5','2',40),(4033,46,14,185,'M','1','2',40),(4034,46,14,185,'M','1','3',40),(4035,46,14,185,'M','1','4',40),(4036,46,14,185,'M','1','5',40),(4037,46,14,185,'M','1','6',40),(4038,46,14,185,'M','1','7',40),(4039,46,14,185,'M','2','2',40),(4040,46,14,185,'M','2','3',40),(4041,46,14,185,'M','2','4',40),(4042,46,14,185,'M','2','5',40),(4043,46,14,185,'M','2','6',40),(4044,46,14,185,'M','2','7',40),(4045,46,14,185,'M','3','3',40),(4046,46,14,185,'M','3','4',40),(4047,46,14,185,'M','3','5',40),(4048,46,14,185,'M','3','6',40),(4049,46,14,185,'M','3','7',40),(4050,46,14,185,'M','4','4',40),(4051,46,14,185,'M','4','5',40),(4052,46,14,185,'M','4','6',40),(4053,46,14,185,'M','4','7',40),(4054,46,14,185,'M','5','3',40),(4055,46,14,185,'M','5','4',40),(4056,46,14,185,'M','5','5',40),(4057,46,14,185,'M','5','6',40),(4058,46,14,185,'M','5','7',40),(4059,46,14,189,'4','1','1',40),(4060,46,14,189,'2','1','2',40),(4061,46,14,189,'M','1','3',40),(4062,46,14,189,'M','1','4',40),(4063,46,14,189,'M','1','5',40),(4064,46,14,189,'M','1','6',40),(4065,46,14,189,'M','1','7',40),(4066,46,14,189,'2','2','1',40),(4067,46,14,189,'M','2','2',40),(4068,46,14,189,'M','2','3',40),(4069,46,14,189,'M','2','4',40),(4070,46,14,189,'M','2','5',40),(4072,46,14,189,'M','2','6',40),(4073,46,14,189,'M','2','7',40),(4074,46,14,189,'6','3','1',40),(4075,46,14,189,'1','3','2',40),(4076,46,14,189,'1','4','1',40),(4077,46,14,189,'M','3','3',40),(4078,46,14,189,'M','3','4',40),(4079,46,14,189,'M','3','5',40),(4080,46,14,189,'M','3','6',40),(4081,46,14,189,'M','3','7',40),(4082,46,14,189,'M','4','2',40),(4083,46,14,189,'M','4','3',40),(4084,46,14,189,'M','4','4',40),(4085,46,14,189,'M','4','5',40),(4087,46,14,189,'M','4','6',40),(4088,46,14,189,'M','4','7',40),(4089,46,14,189,'M','5','1',40),(4090,46,14,189,'M','5','2',40),(4091,46,14,189,'M','5','3',40),(4092,46,14,189,'M','5','4',40),(4093,46,14,189,'M','5','5',40),(4094,46,14,189,'M','5','6',40),(4095,46,14,189,'M','5','7',40),(4096,46,14,157,'1','1','1',40),(4097,46,14,157,'M','1','2',40),(4098,46,14,157,'M','1','3',40),(4099,46,14,157,'M','1','4',40),(4100,46,14,157,'M','1','5',40),(4101,46,14,157,'M','1','6',40),(4102,46,14,157,'M','1','7',40),(4103,46,14,157,'5','2','1',40),(4104,46,14,157,'4','2','2',40),(4105,46,14,157,'M','2','3',40),(4106,46,14,157,'M','2','4',40),(4107,46,14,157,'M','2','5',40),(4108,46,14,157,'M','2','6',40),(4109,46,14,157,'M','2','7',40),(4110,46,14,157,'2','3','1',40),(4111,46,14,157,'1','3','2',40),(4112,46,14,157,'M','3','3',40),(4113,46,14,157,'M','3','4',40),(4114,46,14,157,'M','3','5',40),(4115,46,14,157,'M','3','6',40),(4116,46,14,157,'M','3','7',40),(4117,46,14,157,'2','5','1',40),(4118,46,14,157,'M','4','1',40),(4119,46,14,157,'M','4','2',40),(4121,46,14,157,'M','4','3',40),(4122,46,14,157,'M','4','4',40),(4123,46,14,157,'M','4','5',40),(4124,46,14,157,'M','4','6',40),(4125,46,14,157,'M','4','7',40),(4126,46,14,157,'M','5','2',40),(4127,46,14,157,'M','5','3',40),(4128,46,14,157,'M','5','4',40),(4129,46,14,157,'M','5','5',40),(4130,46,14,157,'M','5','6',40),(4131,46,14,157,'M','5','7',40),(4132,46,14,190,'4','3','1',40),(4133,46,14,190,'4','4','1',40),(4134,46,14,190,'4','5','1',40),(4135,46,14,190,'1','5','2',40),(4136,46,14,190,'M','1','1',40),(4137,46,14,190,'M','1','2',40),(4138,46,14,190,'M','1','3',40),(4139,46,14,190,'M','1','4',40),(4140,46,14,190,'M','1','5',40),(4141,46,14,190,'M','1','6',40),(4142,46,14,190,'M','1','7',40),(4143,46,14,190,'M','2','1',40),(4144,46,14,190,'M','2','2',40),(4145,46,14,190,'M','2','3',40),(4146,46,14,190,'M','2','4',40),(4147,46,14,190,'M','2','5',40),(4148,46,14,190,'M','2','6',40),(4149,46,14,190,'M','2','7',40),(4150,46,14,190,'M','3','2',40),(4151,46,14,190,'M','3','3',40),(4152,46,14,190,'M','3','4',40),(4153,46,14,190,'M','3','5',40),(4154,46,14,190,'M','3','6',40),(4155,46,14,190,'M','3','7',40),(4156,46,14,190,'M','4','2',40),(4157,46,14,190,'M','4','3',40),(4158,46,14,190,'M','4','4',40),(4159,46,14,190,'M','4','5',40),(4160,46,14,190,'M','4','6',40),(4161,46,14,190,'M','4','7',40),(4162,46,14,190,'M','5','3',40),(4163,46,14,190,'M','5','4',40),(4164,46,14,190,'M','5','5',40),(4165,46,14,190,'M','5','6',40),(4166,46,14,190,'M','5','7',40),(4167,46,14,165,'10','1','1',41),(4168,46,14,165,'10','1','2',41),(4169,46,14,165,'9','1','3',41),(4170,46,14,165,'7','1','4',41),(4171,46,14,165,'7','1','5',41),(4172,46,14,165,'4','1','6',41),(4173,46,14,165,'1','1','7',41),(4174,46,14,165,'1','1','8',41),(4175,46,14,165,'M','1','9',41),(4176,46,14,165,'10','2','1',41),(4177,46,14,165,'9','2','2',41),(4178,46,14,165,'8','2','3',41),(4179,46,14,165,'8','2','4',41),(4180,46,14,165,'8','2','5',41),(4181,46,14,165,'7','2','6',41),(4182,46,14,165,'1','2','7',41),(4183,46,14,165,'1','2','8',41),(4184,46,14,165,'M','2','9',41),(4185,46,14,165,'9','3','2',41),(4186,46,14,165,'8','3','3',41),(4187,46,14,165,'8','3','4',41),(4188,46,14,165,'7','3','5',41),(4189,46,14,165,'7','3','6',41),(4190,46,14,165,'2','3','7',41),(4191,46,14,165,'1','3','8',41),(4192,46,14,165,'M','3','9',41),(4193,46,14,165,'10','4','1',41),(4194,46,14,165,'9','4','2',41),(4195,46,14,165,'8','4','3',41),(4196,46,14,165,'8','4','4',41),(4197,46,14,165,'7','4','5',41),(4199,46,14,165,'1','4','7',41),(4200,46,14,165,'1','4','8',41),(4201,46,14,165,'1','4','9',41),(4202,46,14,165,'1','4','6',41),(4203,46,14,165,'10','5','1',41),(4204,46,14,165,'9','5','2',41),(4205,46,14,165,'8','5','3',41),(4206,46,14,165,'7','5','4',41),(4207,46,14,165,'4','5','5',41),(4208,46,14,165,'1','5','6',41),(4209,46,14,165,'1','5','7',41),(4210,46,14,165,'1','5','8',41),(4211,46,14,165,'1','5','9',41),(4212,46,14,165,'9','6','1',41),(4213,46,14,165,'8','6','2',41),(4214,46,14,165,'8','6','3',41),(4215,46,14,165,'7','6','4',41),(4216,46,14,165,'7','6','5',41),(4217,46,14,165,'4','6','6',41),(4218,46,14,165,'1','6','7',41),(4219,46,14,165,'1','6','8',41),(4220,46,14,165,'1','6','9',41),(4221,46,14,165,'9','7','1',41),(4222,46,14,165,'9','7','2',41),(4223,46,14,165,'8','7','3',41),(4224,46,14,165,'7','7','4',41),(4225,46,14,165,'7','7','5',41),(4226,46,14,165,'6','7','6',41),(4227,46,14,165,'2','7','7',41),(4228,46,14,165,'1','7','8',41),(4229,46,14,165,'1','7','9',41),(4230,46,14,186,'10','1','1',41),(4231,46,14,186,'9','1','2',41),(4232,46,14,186,'8','1','3',41),(4233,46,14,186,'6','1','4',41),(4234,46,14,186,'5','1','5',41),(4235,46,14,186,'4','1','6',41),(4236,46,14,186,'4','1','7',41),(4237,46,14,186,'2','1','8',41),(4238,46,14,186,'M','1','9',41),(4239,46,14,186,'8','2','1',41),(4240,46,14,186,'8','2','2',41),(4241,46,14,186,'7','2','3',41),(4242,46,14,186,'3','2','4',41),(4243,46,14,186,'1','2','5',41),(4244,46,14,186,'1','2','6',41),(4245,46,14,186,'1','2','7',41),(4246,46,14,186,'M','2','8',41),(4247,46,14,186,'M','2','9',41),(4248,46,14,186,'9','3','1',41),(4249,46,14,186,'7','3','2',41),(4250,46,14,186,'7','3','3',41),(4251,46,14,186,'7','3','4',41),(4252,46,14,186,'6','3','5',41),(4253,46,14,186,'5','3','6',41),(4254,46,14,186,'4','3','7',41),(4255,46,14,186,'4','3','8',41),(4256,46,14,186,'1','3','9',41),(4257,46,14,186,'8','4','1',41),(4258,46,14,186,'7','4','2',41),(4259,46,14,186,'5','4','3',41),(4260,46,14,186,'3','4','4',41),(4261,46,14,186,'3','4','5',41),(4262,46,14,186,'2','4','6',41),(4263,46,14,186,'1','4','7',41),(4264,46,14,186,'1','4','8',41),(4265,46,14,186,'M','4','9',41),(4266,46,14,186,'7','5','1',41),(4267,46,14,186,'7','5','2',41),(4268,46,14,186,'7','5','3',41),(4269,46,14,186,'6','5','4',41),(4270,46,14,186,'3','5','5',41),(4271,46,14,186,'1','5','6',41),(4272,46,14,186,'1','5','7',41),(4273,46,14,186,'M','5','8',41),(4274,46,14,186,'M','5','9',41),(4275,46,14,186,'9','6','1',41),(4276,46,14,186,'8','6','2',41),(4277,46,14,186,'7','6','3',41),(4278,46,14,186,'3','6','4',41),(4279,46,14,186,'3','6','5',41),(4280,46,14,186,'2','6','6',41),(4281,46,14,186,'1','6','7',41),(4283,46,14,186,'M','6','9',41),(4284,46,14,186,'M','6','8',41),(4285,46,14,186,'8','7','1',41),(4286,46,14,186,'4','7','2',41),(4287,46,14,186,'3','7','3',41),(4288,46,14,186,'2','7','4',41),(4289,46,14,186,'1','7','5',41),(4290,46,14,186,'1','7','6',41),(4291,46,14,186,'1','7','7',41),(4292,46,14,186,'1','7','8',41),(4293,46,14,186,'M','7','9',41),(4294,46,14,194,'9','1','1',41),(4295,46,14,194,'8','1','2',41),(4296,46,14,194,'8','1','3',41),(4297,46,14,194,'7','1','4',41),(4298,46,14,194,'6','1','5',41),(4299,46,14,194,'5','1','6',41),(4300,46,14,194,'4','1','7',41),(4301,46,14,194,'4','1','8',41),(4302,46,14,194,'1','1','9',41),(4303,46,14,194,'10','2','1',41),(4304,46,14,194,'10','2','2',41),(4305,46,14,194,'9','2','3',41),(4306,46,14,194,'8','2','4',41),(4307,46,14,194,'7','2','5',41),(4308,46,14,194,'4','2','6',41),(4309,46,14,194,'2','2','7',41),(4310,46,14,194,'1','2','8',41),(4311,46,14,194,'1','2','9',41),(4312,46,14,194,'10','3','1',41),(4313,46,14,194,'9','3','2',41),(4314,46,14,194,'8','3','3',41),(4315,46,14,194,'7','3','4',41),(4316,46,14,194,'5','3','5',41),(4317,46,14,194,'4','3','6',41),(4318,46,14,194,'1','3','7',41),(4319,46,14,194,'1','3','8',41),(4320,46,14,194,'1','3','9',41),(4321,46,14,194,'10','4','1',41),(4322,46,14,194,'8','4','2',41),(4323,46,14,194,'8','4','3',41),(4324,46,14,194,'7','4','4',41),(4325,46,14,194,'7','4','5',41),(4326,46,14,194,'6','4','6',41),(4327,46,14,194,'3','4','7',41),(4328,46,14,194,'1','4','8',41),(4329,46,14,194,'1','4','9',41),(4330,46,14,191,'6','1','3',41),(4331,46,14,191,'7','1','1',41),(4332,46,14,191,'7','1','2',41),(4333,46,14,191,'5','1','4',41),(4334,46,14,191,'2','1','5',41),(4335,46,14,191,'1','1','6',41),(4336,46,14,191,'1','1','7',41),(4337,46,14,191,'1','1','8',41),(4338,46,14,191,'M','1','9',41),(4339,46,14,191,'3','2','1',41),(4340,46,14,191,'3','2','2',41),(4341,46,14,191,'3','2','3',41),(4342,46,14,191,'3','2','4',41),(4343,46,14,191,'1','2','5',41),(4344,46,14,191,'1','2','6',41),(4345,46,14,191,'1','2','7',41),(4346,46,14,191,'1','2','8',41),(4347,46,14,191,'M','2','9',41),(4348,46,14,191,'5','3','1',41),(4349,46,14,191,'4','3','2',41),(4350,46,14,191,'3','3','3',41),(4351,46,14,191,'1','3','4',41),(4352,46,14,191,'1','3','5',41),(4353,46,14,191,'1','3','6',41),(4354,46,14,191,'M','3','7',41),(4355,46,14,191,'M','3','8',41),(4356,46,14,191,'M','3','9',41),(4357,46,14,191,'7','4','1',41),(4358,46,14,191,'7','4','2',41),(4359,46,14,191,'7','4','3',41),(4360,46,14,191,'7','4','4',41),(4361,46,14,191,'5','4','5',41),(4362,46,14,191,'4','4','6',41),(4363,46,14,191,'3','4','7',41),(4364,46,14,191,'1','4','8',41),(4365,46,14,191,'1','4','9',41),(4366,46,14,191,'10','5','1',41),(4367,46,14,191,'5','5','2',41),(4368,46,14,191,'4','5','3',41),(4369,46,14,191,'3','5','4',41),(4370,46,14,191,'3','5','5',41),(4371,46,14,191,'2','5','6',41),(4372,46,14,191,'2','5','7',41),(4373,46,14,191,'1','5','8',41),(4374,46,14,191,'1','5','9',41),(4375,46,14,191,'8','6','1',41),(4376,46,14,191,'5','6','2',41),(4377,46,14,191,'2','6','3',41),(4378,46,14,191,'2','6','4',41),(4379,46,14,191,'1','6','5',41),(4380,46,14,191,'1','6','6',41),(4381,46,14,191,'1','6','7',41),(4382,46,14,191,'M','6','8',41),(4383,46,14,191,'M','6','9',41),(4384,46,14,191,'9','7','1',41),(4385,46,14,191,'4','7','2',41),(4386,46,14,191,'3','7','3',41),(4387,46,14,191,'2','7','4',41),(4388,46,14,191,'1','7','5',41),(4389,46,14,191,'1','7','6',41),(4390,46,14,191,'1','7','7',41),(4391,46,14,191,'1','7','8',41),(4392,46,14,191,'M','7','9',41),(4393,46,14,185,'M','1','3',41),(4394,46,14,185,'7','1','1',41),(4395,46,14,185,'1','1','2',41),(4396,46,14,185,'M','1','4',41),(4397,46,14,185,'M','1','5',41),(4398,46,14,185,'M','1','6',41),(4399,46,14,185,'M','1','7',41),(4400,46,14,185,'M','1','8',41),(4401,46,14,185,'M','1','9',41),(4402,46,14,185,'8','2','1',41),(4403,46,14,185,'8','2','2',41),(4404,46,14,185,'8','2','3',41),(4405,46,14,185,'4','2','4',41),(4406,46,14,185,'3','2','5',41),(4407,46,14,185,'1','2','6',41),(4408,46,14,185,'M','2','7',41),(4409,46,14,185,'M','2','8',41),(4410,46,14,185,'M','2','9',41),(4411,46,14,185,'1','3','7',41),(4412,46,14,185,'5','3','3',41),(4413,46,14,185,'4','3','4',41),(4414,46,14,185,'7','3','1',41),(4415,46,14,185,'6','3','2',41),(4416,46,14,185,'1','3','6',41),(4417,46,14,185,'1','3','5',41),(4418,46,14,185,'M','3','8',41),(4419,46,14,185,'M','3','9',41),(4420,46,14,185,'7','4','1',41),(4421,46,14,185,'6','4','2',41),(4422,46,14,185,'6','4','3',41),(4423,46,14,185,'6','4','4',41),(4424,46,14,185,'5','4','5',41),(4425,46,14,185,'5','4','6',41),(4426,46,14,185,'3','4','7',41),(4427,46,14,185,'M','4','8',41),(4428,46,14,185,'M','4','9',41),(4429,46,14,185,'8','5','1',41),(4430,46,14,185,'6','5','2',41),(4431,46,14,185,'4','5','3',41),(4432,46,14,185,'3','5','4',41),(4434,46,14,185,'2','5','5',41),(4435,46,14,185,'1','5','6',41),(4436,46,14,185,'1','5','7',41),(4437,46,14,185,'M','5','8',41),(4438,46,14,185,'M','5','9',41),(4439,46,14,185,'4','6','1',41),(4440,46,14,185,'M','6','2',41),(4441,46,14,185,'M','6','3',41),(4442,46,14,185,'M','6','4',41),(4443,46,14,185,'M','6','5',41),(4444,46,14,185,'M','6','6',41),(4445,46,14,185,'M','6','7',41),(4446,46,14,185,'M','6','8',41),(4447,46,14,185,'M','6','9',41),(4448,46,14,185,'8','7','1',41),(4449,46,14,185,'7','7','2',41),(4450,46,14,185,'7','7','3',41),(4451,46,14,185,'6','7','4',41),(4452,46,14,185,'4','7','5',41),(4453,46,14,185,'4','7','6',41),(4454,46,14,185,'2','7','7',41),(4455,46,14,185,'1','7','8',41),(4456,46,14,185,'M','7','9',41),(4457,46,14,190,'7','1','1',41),(4458,46,14,190,'3','1','2',41),(4459,46,14,190,'1','1','3',41),(4460,46,14,190,'M','1','4',41),(4461,46,14,190,'M','1','5',41),(4462,46,14,190,'M','1','6',41),(4463,46,14,190,'M','1','7',41),(4464,46,14,190,'M','1','8',41),(4465,46,14,190,'M','1','9',41),(4466,46,14,190,'4','2','1',41),(4467,46,14,190,'1','2','2',41),(4468,46,14,190,'1','2','3',41),(4469,46,14,190,'1','2','4',41),(4470,46,14,190,'1','2','5',41),(4471,46,14,190,'M','2','6',41),(4472,46,14,190,'M','2','7',41),(4473,46,14,190,'M','2','8',41),(4474,46,14,190,'M','2','9',41),(4475,46,14,190,'7','3','1',41),(4477,46,14,190,'6','3','3',41),(4478,46,14,190,'4','3','4',41),(4479,46,14,190,'M','3','5',41),(4480,46,14,190,'M','3','6',41),(4481,46,14,190,'M','3','7',41),(4482,46,14,190,'M','3','8',41),(4483,46,14,190,'M','3','9',41),(4484,46,14,190,'7','3','2',41),(4485,46,14,190,'3','4','1',41),(4486,46,14,190,'1','4','2',41),(4487,46,14,190,'1','4','3',41),(4488,46,14,190,'M','4','4',41),(4489,46,14,190,'M','4','5',41),(4490,46,14,190,'M','4','6',41),(4491,46,14,190,'M','4','7',41),(4492,46,14,190,'M','4','8',41),(4493,46,14,190,'M','4','9',41),(4494,46,14,190,'7','5','1',41),(4495,46,14,190,'6','5','2',41),(4496,46,14,190,'1','5','3',41),(4497,46,14,190,'M','5','4',41),(4498,46,14,190,'M','5','5',41),(4499,46,14,190,'M','5','6',41),(4500,46,14,190,'M','5','7',41),(4501,46,14,190,'M','5','8',41),(4502,46,14,190,'M','5','9',41),(4503,46,14,190,'6','6','1',41),(4504,46,14,190,'5','6','2',41),(4505,46,14,190,'1','6','3',41),(4506,46,14,190,'1','6','4',41),(4507,46,14,190,'M','6','5',41),(4508,46,14,190,'M','6','6',41),(4509,46,14,190,'M','6','7',41),(4510,46,14,190,'M','6','8',41),(4511,46,14,190,'M','6','9',41),(4512,46,14,190,'1','7','1',41),(4513,46,14,190,'1','7','2',41),(4514,46,14,190,'1','7','3',41),(4515,46,14,190,'M','7','4',41),(4516,46,14,190,'M','7','5',41),(4517,46,14,190,'M','7','6',41),(4518,46,14,190,'M','7','7',41),(4519,46,14,190,'M','7','8',41),(4520,46,14,190,'M','7','9',41),(4521,46,14,165,'9','3','1',41),(4522,46,14,165,'4','1','1',42),(4523,46,14,165,'4','1','2',42),(4524,46,14,165,'1','1','3',42),(4525,46,14,165,'M','1','4',42),(4526,46,14,165,'M','1','5',42),(4527,46,14,165,'M','1','6',42),(4528,46,14,165,'M','1','7',42),(4529,46,14,165,'3','2','1',42),(4530,46,14,165,'2','2','2',42),(4531,46,14,165,'2','2','3',42),(4532,46,14,165,'1','2','4',42),(4533,46,14,165,'M','2','5',42),(4534,46,14,165,'M','2','6',42),(4535,46,14,165,'M','2','7',42),(4536,46,14,165,'5','3','1',42),(4537,46,14,165,'3','3','2',42),(4538,46,14,165,'3','3','3',42),(4539,46,14,165,'M','3','4',42),(4540,46,14,165,'M','3','5',42),(4541,46,14,165,'M','3','6',42),(4542,46,14,165,'M','3','7',42),(4543,46,14,165,'6','4','1',42),(4544,46,14,165,'2','4','2',42),(4545,46,14,165,'M','4','3',42),(4546,46,14,165,'M','4','4',42),(4547,46,14,165,'M','4','5',42),(4548,46,14,165,'M','4','6',42),(4549,46,14,165,'M','4','7',42),(4550,46,14,165,'1','5','1',42),(4551,46,14,165,'1','5','2',42),(4552,46,14,165,'1','5','3',42),(4553,46,14,165,'1','5','4',42),(4554,46,14,165,'1','5','5',42),(4555,46,14,165,'M','5','6',42),(4556,46,14,165,'M','5','7',42),(4557,46,14,169,'3','1','1',42),(4558,46,14,169,'2','1','2',42),(4559,46,14,169,'M','1','3',42),(4560,46,14,169,'M','1','4',42),(4561,46,14,169,'M','1','5',42),(4562,46,14,169,'M','1','6',42),(4563,46,14,169,'M','1','7',42),(4564,46,14,169,'M','2','1',42),(4565,46,14,169,'M','2','2',42),(4566,46,14,169,'M','2','3',42),(4567,46,14,169,'M','2','4',42),(4568,46,14,169,'M','2','5',42),(4569,46,14,169,'M','2','6',42),(4570,46,14,169,'M','2','7',42),(4571,46,14,169,'2','3','1',42),(4572,46,14,169,'1','3','2',42),(4573,46,14,169,'M','3','3',42),(4574,46,14,169,'M','3','4',42),(4575,46,14,169,'M','3','5',42),(4576,46,14,169,'M','3','6',42),(4577,46,14,169,'M','3','7',42),(4578,46,14,169,'4','4','1',42),(4579,46,14,169,'3','4','2',42),(4580,46,14,169,'2','4','3',42),(4581,46,14,169,'1','4','4',42),(4582,46,14,169,'1','4','5',42),(4583,46,14,169,'1','4','6',42),(4584,46,14,169,'M','4','7',42),(4585,46,14,169,'5','5','1',42),(4586,46,14,169,'3','5','2',42),(4587,46,14,169,'2','5','3',42),(4588,46,14,169,'M','5','4',42),(4589,46,14,169,'M','5','5',42),(4590,46,14,169,'M','5','6',42),(4591,46,14,169,'M','5','7',42),(4592,46,14,161,'4','1','1',42),(4593,46,14,161,'2','1','2',42),(4594,46,14,161,'2','1','3',42),(4595,46,14,161,'1','1','4',42),(4596,46,14,161,'1','1','5',42),(4597,46,14,161,'M','1','6',42),(4598,46,14,161,'M','1','7',42),(4599,46,14,161,'2','2','1',42),(4600,46,14,161,'1','2','2',42),(4601,46,14,161,'M','2','3',42),(4602,46,14,161,'M','2','4',42),(4603,46,14,161,'M','2','5',42),(4604,46,14,161,'M','2','6',42),(4605,46,14,161,'M','2','7',42),(4606,46,14,161,'3','3','1',42),(4607,46,14,161,'1','3','2',42),(4608,46,14,161,'1','3','3',42),(4609,46,14,161,'M','3','4',42),(4610,46,14,161,'M','3','5',42),(4611,46,14,161,'M','3','6',42),(4612,46,14,161,'M','3','7',42),(4613,46,14,161,'5','4','1',42),(4614,46,14,161,'3','4','2',42),(4615,46,14,161,'M','4','3',42),(4616,46,14,161,'M','4','4',42),(4617,46,14,161,'M','4','5',42),(4618,46,14,161,'M','4','6',42),(4619,46,14,161,'M','4','7',42),(4620,46,14,161,'3','5','1',42),(4621,46,14,161,'M','5','2',42),(4622,46,14,161,'M','5','3',42),(4623,46,14,161,'M','5','4',42),(4624,46,14,161,'M','5','5',42),(4625,46,14,161,'M','5','6',42),(4626,46,14,161,'M','5','7',42),(4627,46,14,185,'2','1','1',42),(4628,46,14,185,'M','1','2',42),(4629,46,14,185,'M','1','3',42),(4630,46,14,185,'M','1','4',42),(4631,46,14,185,'M','1','5',42),(4632,46,14,185,'M','1','6',42),(4633,46,14,185,'M','1','7',42),(4634,46,14,185,'4','2','1',42),(4635,46,14,185,'M','2','2',42),(4636,46,14,185,'M','2','3',42),(4637,46,14,185,'M','2','4',42),(4638,46,14,185,'M','2','5',42),(4639,46,14,185,'M','2','6',42),(4640,46,14,185,'M','2','7',42),(4641,46,14,185,'2','3','1',42),(4642,46,14,185,'2','3','2',42),(4643,46,14,185,'M','3','3',42),(4644,46,14,185,'M','3','4',42),(4645,46,14,185,'M','3','5',42),(4646,46,14,185,'M','3','6',42),(4647,46,14,185,'M','3','7',42),(4649,46,14,185,'4','4','1',42),(4650,46,14,185,'3','4','2',42),(4651,46,14,185,'2','4','3',42),(4652,46,14,185,'M','4','4',42),(4653,46,14,185,'M','4','5',42),(4654,46,14,185,'M','4','6',42),(4655,46,14,185,'M','4','7',42),(4656,46,14,185,'2','5','1',42),(4657,46,14,185,'2','5','2',42),(4658,46,14,185,'M','5','3',42),(4659,46,14,185,'M','5','4',42),(4660,46,14,185,'M','5','5',42),(4661,46,14,185,'M','5','6',42),(4662,46,14,185,'M','5','7',42),(4663,46,14,189,'4','1','1',42),(4664,46,14,189,'2','1','2',42),(4665,46,14,189,'M','1','3',42),(4666,46,14,189,'M','1','4',42),(4667,46,14,189,'M','1','5',42),(4668,46,14,189,'M','1','6',42),(4669,46,14,189,'M','1','7',42),(4670,46,14,189,'2','2','1',42),(4671,46,14,189,'M','2','2',42),(4672,46,14,189,'M','2','3',42),(4674,46,14,189,'M','2','5',42),(4675,46,14,189,'M','2','6',42),(4676,46,14,189,'M','2','7',42),(4677,46,14,189,'M','2','4',42),(4678,46,14,189,'6','3','1',42),(4679,46,14,189,'1','3','2',42),(4680,46,14,189,'M','3','3',42),(4681,46,14,189,'M','3','4',42),(4682,46,14,189,'M','3','5',42),(4683,46,14,189,'M','3','6',42),(4684,46,14,189,'M','3','7',42),(4685,46,14,189,'1','4','1',42),(4686,46,14,189,'M','4','2',42),(4687,46,14,189,'M','4','3',42),(4688,46,14,189,'M','4','4',42),(4689,46,14,189,'M','4','5',42),(4690,46,14,189,'M','4','6',42),(4691,46,14,189,'M','4','7',42),(4692,46,14,189,'M','5','1',42),(4693,46,14,189,'M','5','2',42),(4694,46,14,189,'M','5','3',42),(4695,46,14,189,'M','5','4',42),(4696,46,14,189,'M','5','5',42),(4697,46,14,189,'M','5','6',42),(4698,46,14,189,'M','5','7',42),(4699,46,14,157,'1','1','1',42),(4700,46,14,157,'M','1','2',42),(4701,46,14,157,'M','1','3',42),(4702,46,14,157,'M','1','4',42),(4703,46,14,157,'M','1','5',42),(4704,46,14,157,'M','1','6',42),(4705,46,14,157,'M','1','7',42),(4707,46,14,157,'5','2','1',42),(4708,46,14,157,'4','2','2',42),(4709,46,14,157,'M','2','3',42),(4710,46,14,157,'M','2','4',42),(4711,46,14,157,'M','2','5',42),(4712,46,14,157,'M','2','6',42),(4713,46,14,157,'M','2','7',42),(4714,46,14,157,'2','3','1',42),(4715,46,14,157,'1','3','2',42),(4716,46,14,157,'M','3','3',42),(4717,46,14,157,'M','3','4',42),(4718,46,14,157,'M','3','5',42),(4719,46,14,157,'M','3','6',42),(4720,46,14,157,'M','3','7',42),(4721,46,14,157,'M','4','1',42),(4722,46,14,157,'M','4','2',42),(4723,46,14,157,'M','4','3',42),(4724,46,14,157,'M','4','4',42),(4725,46,14,157,'M','4','5',42),(4726,46,14,157,'M','4','6',42),(4727,46,14,157,'M','4','7',42),(4728,46,14,157,'2','5','1',42),(4729,46,14,157,'M','5','2',42),(4730,46,14,157,'M','5','3',42),(4731,46,14,157,'M','5','4',42),(4732,46,14,157,'M','5','5',42),(4733,46,14,157,'M','5','6',42),(4734,46,14,157,'M','5','7',42),(4735,46,14,190,'M','1','1',42),(4736,46,14,190,'M','1','2',42),(4737,46,14,190,'M','1','3',42),(4738,46,14,190,'M','1','4',42),(4739,46,14,190,'M','1','5',42),(4740,46,14,190,'M','1','6',42),(4741,46,14,190,'M','1','7',42),(4742,46,14,190,'M','2','1',42),(4743,46,14,190,'M','2','2',42),(4744,46,14,190,'M','2','3',42),(4745,46,14,190,'M','2','4',42),(4746,46,14,190,'M','2','5',42),(4747,46,14,190,'M','2','6',42),(4748,46,14,190,'M','2','7',42),(4749,46,14,190,'4','3','1',42),(4750,46,14,190,'M','3','2',42),(4751,46,14,190,'M','3','3',42),(4752,46,14,190,'M','3','4',42),(4753,46,14,190,'M','3','5',42),(4754,46,14,190,'M','3','6',42),(4755,46,14,190,'M','3','7',42),(4756,46,14,190,'4','4','1',42),(4757,46,14,190,'M','4','2',42),(4758,46,14,190,'M','4','3',42),(4759,46,14,190,'M','4','4',42),(4760,46,14,190,'M','4','5',42),(4761,46,14,190,'M','4','6',42),(4762,46,14,190,'M','4','7',42),(4763,46,14,190,'4','5','1',42),(4764,46,14,190,'1','5','2',42),(4765,46,14,190,'M','5','3',42),(4766,46,14,190,'M','5','4',42),(4767,46,14,190,'M','5','5',42),(4768,46,14,190,'M','5','6',42),(4770,46,14,190,'M','5','7',42),(4771,46,14,165,'8','1','1',43),(4772,46,14,165,'8','1','2',43),(4773,46,14,165,'7','1','3',43),(4774,46,14,165,'7','1','4',43),(4775,46,14,165,'4','1','5',43),(4776,46,14,165,'3','1','6',43),(4777,46,14,165,'2','1','7',43),(4778,46,14,165,'2','1','8',43),(4779,46,14,165,'1','1','9',43),(4780,46,14,165,'7','2','1',43),(4781,46,14,165,'6','2','2',43),(4782,46,14,165,'6','2','3',43),(4783,46,14,165,'2','2','4',43),(4784,46,14,165,'1','2','5',43),(4785,46,14,165,'1','2','6',43),(4786,46,14,165,'1','2','7',43),(4787,46,14,165,'1','2','8',43),(4788,46,14,165,'1','2','9',43),(4789,46,14,165,'10','3','1',43),(4790,46,14,165,'8','3','2',43),(4791,46,14,165,'8','3','3',43),(4792,46,14,165,'8','3','4',43),(4793,46,14,165,'6','3','5',43),(4794,46,14,165,'6','3','6',43),(4795,46,14,165,'2','3','7',43),(4796,46,14,165,'2','3','8',43),(4797,46,14,165,'1','3','9',43),(4798,46,14,165,'10','4','1',43),(4799,46,14,165,'9','4','2',43),(4800,46,14,165,'8','4','3',43),(4801,46,14,165,'7','4','4',43),(4802,46,14,165,'6','4','5',43),(4803,46,14,165,'6','4','6',43),(4804,46,14,165,'5','4','7',43),(4805,46,14,165,'4','4','8',43),(4806,46,14,165,'1','4','9',43),(4807,46,14,165,'9','5','1',43),(4808,46,14,165,'8','5','2',43),(4809,46,14,165,'8','5','3',43),(4810,46,14,165,'7','5','4',43),(4811,46,14,165,'7','5','5',43),(4812,46,14,165,'6','5','6',43),(4813,46,14,165,'3','5','7',43),(4814,46,14,165,'1','5','8',43),(4815,46,14,165,'1','5','9',43),(4816,46,14,165,'8','6','1',43),(4817,46,14,165,'7','6','2',43),(4818,46,14,165,'7','6','3',43),(4819,46,14,165,'6','6','4',43),(4820,46,14,165,'4','6','5',43),(4821,46,14,165,'1','6','6',43),(4822,46,14,165,'1','6','7',43),(4823,46,14,165,'1','6','8',43),(4824,46,14,165,'1','6','9',43),(4825,46,14,165,'9','7','1',43),(4826,46,14,165,'9','7','2',43),(4827,46,14,165,'8','7','3',43),(4828,46,14,165,'8','7','4',43),(4829,46,14,165,'7','7','5',43),(4830,46,14,165,'4','7','6',43),(4831,46,14,165,'2','7','7',43),(4832,46,14,165,'1','7','8',43),(4833,46,14,165,'M','7','9',43),(4834,46,14,185,'8','1','1',43),(4835,46,14,185,'8','1','2',43),(4836,46,14,185,'7','1','3',43),(4837,46,14,185,'7','1','4',43),(4838,46,14,185,'7','1','5',43),(4839,46,14,185,'1','1','6',43),(4840,46,14,185,'1','1','7',43),(4841,46,14,185,'M','1','8',43),(4842,46,14,185,'M','1','9',43),(4843,46,14,185,'8','2','1',43),(4844,46,14,185,'7','2','2',43),(4845,46,14,185,'3','2','3',43),(4846,46,14,185,'1','2','4',43),(4847,46,14,185,'1','2','5',43),(4848,46,14,185,'1','2','6',43),(4849,46,14,185,'M','2','7',43),(4850,46,14,185,'M','2','8',43),(4851,46,14,185,'M','2','9',43),(4852,46,14,185,'10','3','1',43),(4853,46,14,185,'8','3','2',43),(4854,46,14,185,'7','3','3',43),(4855,46,14,185,'7','3','4',43),(4857,46,14,185,'1','3','6',43),(4858,46,14,185,'3','3','5',43),(4859,46,14,185,'1','3','7',43),(4860,46,14,185,'M','3','8',43),(4861,46,14,185,'M','3','9',43),(4862,46,14,185,'10','4','1',43),(4863,46,14,185,'9','4','2',43),(4864,46,14,185,'9','4','3',43),(4865,46,14,185,'4','4','4',43),(4866,46,14,185,'1','4','5',43),(4867,46,14,185,'1','4','6',43),(4868,46,14,185,'M','4','7',43),(4869,46,14,185,'M','4','8',43),(4870,46,14,185,'M','4','9',43),(4871,46,14,185,'8','5','1',43),(4872,46,14,185,'8','5','2',43),(4873,46,14,185,'8','5','3',43),(4874,46,14,185,'8','5','4',43),(4875,46,14,185,'7','5','5',43),(4876,46,14,185,'7','5','6',43),(4877,46,14,185,'1','5','7',43),(4878,46,14,185,'M','5','8',43),(4879,46,14,185,'M','5','9',43),(4880,46,14,185,'8','6','1',43),(4881,46,14,185,'7','6','2',43),(4882,46,14,185,'4','6','3',43),(4883,46,14,185,'3','6','4',43),(4884,46,14,185,'2','6','5',43),(4885,46,14,185,'2','6','6',43),(4886,46,14,185,'1','6','7',43),(4887,46,14,185,'M','6','8',43),(4888,46,14,185,'M','6','9',43),(4889,46,14,185,'8','7','1',43),(4890,46,14,185,'6','7','2',43),(4891,46,14,185,'5','7','3',43),(4892,46,14,185,'4','7','4',43),(4893,46,14,185,'4','7','5',43),(4894,46,14,185,'2','7','6',43),(4895,46,14,185,'1','7','7',43),(4896,46,14,185,'1','7','8',43),(4897,46,14,185,'M','7','9',43),(4898,46,14,188,'9','1','1',43),(4899,46,14,188,'7','1','2',43),(4900,46,14,188,'6','1','3',43),(4901,46,14,188,'4','1','4',43),(4902,46,14,188,'3','1','5',43),(4903,46,14,188,'3','1','6',43),(4904,46,14,188,'1','1','7',43),(4905,46,14,188,'M','1','8',43),(4906,46,14,188,'M','1','9',43),(4907,46,14,188,'10','2','1',43),(4908,46,14,188,'8','2','2',43),(4909,46,14,188,'7','2','3',43),(4910,46,14,188,'4','2','4',43),(4911,46,14,188,'4','2','5',43),(4912,46,14,188,'4','2','6',43),(4913,46,14,188,'1','2','7',43),(4914,46,14,188,'1','2','8',43),(4915,46,14,188,'M','2','9',43),(4916,46,14,188,'8','3','1',43),(4918,46,14,188,'3','3','3',43),(4919,46,14,188,'2','3','4',43),(4920,46,14,188,'1','3','5',43),(4921,46,14,188,'1','3','6',43),(4922,46,14,188,'4','3','2',43),(4923,46,14,188,'1','3','7',43),(4925,46,14,188,'M','3','9',43),(4926,46,14,188,'M','3','8',43),(4927,46,14,188,'8','4','1',43),(4928,46,14,188,'8','4','2',43),(4929,46,14,188,'7','4','3',43),(4930,46,14,188,'4','4','4',43),(4931,46,14,188,'4','4','5',43),(4932,46,14,188,'3','4','6',43),(4933,46,14,188,'1','4','7',43),(4934,46,14,188,'M','4','8',43),(4935,46,14,188,'M','4','9',43),(4936,46,14,188,'9','5','1',43),(4937,46,14,188,'8','5','2',43),(4938,46,14,188,'7','5','3',43),(4939,46,14,188,'6','5','4',43),(4940,46,14,188,'4','5','5',43),(4941,46,14,188,'4','5','6',43),(4942,46,14,188,'2','5','7',43),(4943,46,14,188,'1','5','8',43),(4944,46,14,188,'M','5','9',43),(4945,46,14,188,'8','6','1',43),(4946,46,14,188,'3','6','2',43),(4947,46,14,188,'1','6','3',43),(4948,46,14,188,'1','6','4',43),(4949,46,14,188,'1','6','5',43),(4950,46,14,188,'M','6','6',43),(4951,46,14,188,'M','6','7',43),(4952,46,14,188,'M','6','8',43),(4953,46,14,188,'M','6','9',43),(4954,46,14,188,'5','7','1',43),(4955,46,14,188,'5','7','2',43),(4956,46,14,188,'3','7','3',43),(4957,46,14,188,'2','7','4',43),(4958,46,14,188,'1','7','5',43),(4959,46,14,188,'1','7','6',43),(4960,46,14,188,'1','7','7',43),(4961,46,14,188,'M','7','8',43),(4962,46,14,188,'M','7','9',43),(4963,46,14,157,'9','1','1',43),(4964,46,14,157,'8','1','2',43),(4965,46,14,157,'6','1','3',43),(4966,46,14,157,'3','1','4',43),(4967,46,14,157,'3','1','5',43),(4968,46,14,157,'3','1','6',43),(4969,46,14,157,'1','1','7',43),(4970,46,14,157,'1','1','8',43),(4971,46,14,157,'1','1','9',43),(4973,46,14,157,'9','2','1',43),(4974,46,14,157,'4','2','2',43),(4975,46,14,157,'1','2','3',43),(4976,46,14,157,'1','2','4',43),(4977,46,14,157,'1','2','5',43),(4978,46,14,157,'1','2','6',43),(4979,46,14,157,'1','2','7',43),(4980,46,14,157,'1','2','8',43),(4981,46,14,157,'M','2','9',43),(4982,46,14,157,'8','3','1',43),(4983,46,14,157,'6','3','2',43),(4984,46,14,157,'6','3','3',43),(4985,46,14,157,'2','3','4',43),(4986,46,14,157,'1','3','5',43),(4987,46,14,157,'1','3','6',43),(4988,46,14,157,'1','3','7',43),(4989,46,14,157,'1','3','8',43),(4990,46,14,157,'1','3','9',43),(4991,46,14,157,'8','4','1',43),(4992,46,14,157,'6','4','2',43),(4993,46,14,157,'6','4','3',43),(4994,46,14,157,'6','4','4',43),(4995,46,14,157,'5','4','5',43),(4996,46,14,157,'3','4','6',43),(4998,46,14,157,'1','4','7',43),(4999,46,14,157,'1','4','8',43),(5000,46,14,157,'1','4','9',43),(5001,46,14,157,'10','5','1',43),(5002,46,14,157,'8','5','2',43),(5003,46,14,157,'6','5','3',43),(5004,46,14,157,'5','5','4',43),(5005,46,14,157,'5','5','5',43),(5006,46,14,157,'4','5','6',43),(5007,46,14,157,'1','5','7',43),(5008,46,14,157,'1','5','8',43),(5009,46,14,157,'M','5','9',43),(5010,46,14,157,'9','6','1',43),(5011,46,14,157,'6','6','2',43),(5012,46,14,157,'5','6','3',43),(5013,46,14,157,'1','6','4',43),(5014,46,14,157,'1','6','5',43),(5015,46,14,157,'1','6','6',43),(5016,46,14,157,'M','6','7',43),(5017,46,14,157,'M','6','8',43),(5018,46,14,157,'M','6','9',43),(5019,46,14,157,'4','7','1',43),(5020,46,14,157,'3','7','2',43),(5021,46,14,157,'3','7','3',43),(5022,46,14,157,'3','7','4',43),(5023,46,14,157,'2','7','5',43),(5024,46,14,157,'1','7','6',43),(5025,46,14,157,'1','7','7',43),(5026,46,14,157,'1','7','8',43),(5027,46,14,157,'M','7','9',43),(5028,46,14,187,'7','1','1',43),(5029,46,14,187,'7','1','2',43),(5030,46,14,187,'2','1','3',43),(5031,46,14,187,'1','1','4',43),(5032,46,14,187,'M','1','5',43),(5033,46,14,187,'M','1','6',43),(5034,46,14,187,'M','1','7',43),(5035,46,14,187,'M','1','8',43),(5036,46,14,187,'M','1','9',43),(5037,46,14,187,'8','2','1',43),(5038,46,14,187,'1','2','2',43),(5039,46,14,187,'1','2','3',43),(5040,46,14,187,'M','2','4',43),(5041,46,14,187,'M','2','5',43),(5042,46,14,187,'M','2','6',43),(5043,46,14,187,'M','2','7',43),(5044,46,14,187,'M','2','8',43),(5045,46,14,187,'M','2','9',43),(5046,46,14,187,'3','3','1',43),(5047,46,14,187,'2','3','2',43),(5048,46,14,187,'1','3','3',43),(5049,46,14,187,'M','3','4',43),(5050,46,14,187,'M','3','5',43),(5051,46,14,187,'M','3','6',43),(5052,46,14,187,'M','3','7',43),(5053,46,14,187,'M','3','8',43),(5054,46,14,187,'M','3','9',43),(5055,46,14,187,'9','4','1',43),(5056,46,14,187,'8','4','2',43),(5057,46,14,187,'7','4','3',43),(5058,46,14,187,'6','4','4',43),(5059,46,14,187,'3','4','5',43),(5060,46,14,187,'3','4','6',43),(5061,46,14,187,'2','4','7',43),(5062,46,14,187,'M','4','8',43),(5063,46,14,187,'M','4','9',43),(5064,46,14,187,'9','5','1',43),(5065,46,14,187,'2','5','2',43),(5066,46,14,187,'1','5','3',43),(5067,46,14,187,'M','5','4',43),(5068,46,14,187,'M','5','5',43),(5069,46,14,187,'M','5','6',43),(5070,46,14,187,'M','5','7',43),(5071,46,14,187,'M','5','8',43),(5073,46,14,187,'7','6','2',43),(5074,46,14,187,'6','6','3',43),(5075,46,14,187,'2','6','4',43),(5076,46,14,187,'2','6','5',43),(5077,46,14,187,'1','6','6',43),(5078,46,14,187,'M','6','7',43),(5079,46,14,187,'M','6','8',43),(5080,46,14,187,'M','6','9',43),(5081,46,14,187,'7','7','1',43),(5082,46,14,187,'5','7','2',43),(5083,46,14,187,'1','7','3',43),(5084,46,14,187,'M','7','4',43),(5085,46,14,187,'M','7','5',43),(5086,46,14,187,'M','7','6',43),(5087,46,14,187,'M','7','7',43),(5088,48,14,196,'2','1','1',44),(5089,48,14,196,'2','1','2',44),(5090,48,14,196,'2','1','3',44),(5091,48,14,196,'1','1','4',44),(5092,48,14,196,'M','1','5',44),(5093,48,14,196,'M','1','6',44),(5094,48,14,196,'M','1','7',44),(5095,48,14,196,'2','2','1',44),(5096,48,14,196,'2','2','2',44),(5097,48,14,196,'2','2','3',44),(5098,48,14,196,'1','2','4',44),(5099,48,14,196,'1','2','5',44),(5100,48,14,196,'M','2','6',44),(5101,48,14,196,'M','2','7',44),(5102,48,14,196,'2','3','1',44),(5105,48,14,196,'1','3','4',44),(5106,48,14,196,'M','3','5',44),(5107,48,14,196,'M','3','6',44),(5108,48,14,196,'M','3','7',44),(5109,48,14,196,'2','3','2',44),(5110,48,14,196,'2','4','1',44),(5111,48,14,196,'2','4','2',44),(5112,48,14,196,'1','4','3',44),(5113,48,14,196,'M','4','4',44),(5114,48,14,196,'M','4','5',44),(5115,48,14,196,'M','4','6',44),(5116,48,14,196,'M','4','7',44),(5117,48,14,196,'2','5','1',44),(5118,48,14,196,'2','5','2',44),(5119,48,14,196,'2','5','3',44),(5120,48,14,196,'1','5','4',44),(5121,48,14,196,'1','5','5',44),(5122,48,14,196,'1','5','6',44),(5123,48,14,196,'1','5','7',44),(5124,48,14,196,'2','6','1',44),(5125,48,14,196,'2','6','2',44),(5126,48,14,196,'1','6','3',44),(5127,48,14,196,'M','6','4',44),(5128,48,14,196,'M','6','5',44),(5129,48,14,196,'M','6','6',44),(5130,48,14,196,'M','6','7',44),(5131,48,14,196,'2','7','1',44),(5132,48,14,196,'2','7','2',44),(5133,48,14,196,'2','7','3',44),(5134,48,14,196,'1','7','4',44),(5135,48,14,196,'1','7','5',44),(5136,48,14,196,'1','7','6',44),(5137,48,14,196,'M','7','7',44),(5138,48,14,195,'2','1','1',44),(5139,48,14,195,'1','1','2',44),(5140,48,14,195,'1','1','3',44),(5141,48,14,195,'M','1','4',44),(5142,48,14,195,'M','1','5',44),(5143,48,14,195,'M','1','6',44),(5144,48,14,195,'M','1','7',44),(5145,48,14,195,'2','2','1',44),(5146,48,14,195,'2','2','2',44),(5147,48,14,195,'M','2','3',44),(5148,48,14,195,'M','2','4',44),(5149,48,14,195,'M','2','5',44),(5150,48,14,195,'M','2','6',44),(5151,48,14,195,'M','2','7',44),(5152,48,14,195,'1','3','1',44),(5153,48,14,195,'M','3','2',44),(5154,48,14,195,'M','3','3',44),(5155,48,14,195,'M','3','4',44),(5156,48,14,195,'M','3','5',44),(5157,48,14,195,'M','3','6',44),(5158,48,14,195,'M','3','7',44),(5159,48,14,195,'2','4','1',44),(5160,48,14,195,'1','4','2',44),(5161,48,14,195,'M','4','3',44),(5162,48,14,195,'M','4','4',44),(5163,48,14,195,'M','4','5',44),(5164,48,14,195,'M','4','6',44),(5165,48,14,195,'M','4','7',44),(5166,48,14,195,'1','5','1',44),(5167,48,14,195,'1','5','2',44),(5168,48,14,195,'M','5','3',44),(5169,48,14,195,'M','5','4',44),(5170,48,14,195,'M','5','5',44),(5171,48,14,195,'M','5','6',44),(5172,48,14,195,'M','5','7',44),(5173,48,14,195,'2','6','1',44),(5174,48,14,195,'1','6','2',44),(5175,48,14,195,'M','6','3',44),(5176,48,14,195,'M','6','4',44),(5177,48,14,195,'M','6','5',44),(5178,48,14,195,'M','6','6',44),(5179,48,14,195,'M','6','7',44),(5180,48,14,195,'M','7','1',44),(5181,48,14,195,'M','7','2',44),(5182,48,14,195,'M','7','3',44),(5183,48,14,195,'M','7','4',44),(5184,48,14,195,'M','7','5',44),(5185,48,14,195,'M','7','6',44),(5186,48,14,195,'M','7','7',44),(5187,48,14,197,'2','1','1',44),(5188,48,14,197,'1','1','2',44),(5189,48,14,197,'M','1','3',44),(5190,48,14,197,'M','1','4',44),(5191,48,14,197,'M','1','5',44),(5192,48,14,197,'M','1','6',44),(5193,48,14,197,'M','1','7',44),(5195,48,14,197,'2','2','2',44),(5196,48,14,197,'1','2','3',44),(5198,48,14,197,'2','2','1',44),(5199,48,14,197,'M','2','4',44),(5200,48,14,197,'M','2','5',44),(5201,48,14,197,'M','2','6',44),(5202,48,14,197,'M','2','7',44),(5203,48,14,197,'1','3','1',44),(5204,48,14,197,'1','4','1',44),(5205,48,14,197,'1','5','1',44),(5206,48,14,197,'1','5','2',44),(5207,48,14,197,'1','6','1',44),(5208,48,14,197,'1','6','2',44),(5209,48,14,197,'1','6','3',44),(5210,48,14,197,'1','7','1',44),(5211,48,14,197,'M','7','2',44),(5212,48,14,197,'M','7','3',44),(5213,48,14,197,'M','7','4',44),(5214,48,14,197,'M','7','5',44),(5215,48,14,197,'M','7','6',44),(5216,48,14,197,'M','7','7',44),(5217,48,14,197,'M','3','2',44),(5218,48,14,197,'M','3','3',44),(5219,48,14,197,'M','3','4',44),(5220,48,14,197,'M','3','5',44),(5221,48,14,197,'M','3','6',44),(5222,48,14,197,'M','3','7',44),(5223,48,14,197,'M','4','2',44),(5224,48,14,197,'M','4','3',44),(5225,48,14,197,'M','4','4',44),(5226,48,14,197,'M','4','5',44),(5227,48,14,197,'M','4','6',44),(5228,48,14,197,'M','4','7',44),(5229,48,14,197,'M','5','3',44),(5230,48,14,197,'M','5','4',44),(5231,48,14,197,'M','5','5',44),(5232,48,14,197,'M','5','6',44),(5233,48,14,197,'M','5','7',44),(5234,48,14,197,'M','6','4',44),(5235,48,14,197,'M','6','5',44),(5236,48,14,197,'M','6','6',44),(5237,48,14,197,'M','6','7',44),(5238,48,14,198,'1','1','1',44),(5239,48,14,198,'M','1','2',44),(5240,48,14,198,'M','1','3',44),(5241,48,14,198,'M','1','4',44),(5242,48,14,198,'M','1','5',44),(5243,48,14,198,'M','1','6',44),(5244,48,14,198,'M','1','7',44),(5245,48,14,198,'2','2','1',44),(5246,48,14,198,'1','2','2',44),(5247,48,14,198,'M','2','3',44),(5248,48,14,198,'M','2','4',44),(5249,48,14,198,'M','2','5',44),(5250,48,14,198,'M','2','6',44),(5251,48,14,198,'M','2','7',44),(5252,48,14,198,'2','3','1',44),(5253,48,14,198,'1','3','2',44),(5254,48,14,198,'M','3','3',44),(5255,48,14,198,'M','3','4',44),(5256,48,14,198,'M','3','5',44),(5257,48,14,198,'M','3','6',44),(5258,48,14,198,'M','3','7',44),(5259,48,14,198,'1','4','1',44),(5260,48,14,198,'1','4','2',44),(5261,48,14,198,'M','4','3',44),(5262,48,14,198,'M','4','4',44),(5263,48,14,198,'M','4','5',44),(5264,48,14,198,'M','4','6',44),(5265,48,14,198,'M','4','7',44),(5266,48,14,198,'2','5','1',44),(5267,48,14,198,'M','5','2',44),(5268,48,14,198,'M','5','3',44),(5269,48,14,198,'M','5','4',44),(5270,48,14,198,'M','5','5',44),(5271,48,14,198,'M','5','6',44),(5272,48,14,198,'M','5','7',44),(5273,48,14,198,'1','6','1',44),(5275,48,14,198,'M','6','2',44),(5276,48,14,198,'M','6','3',44),(5277,48,14,198,'M','6','4',44),(5278,48,14,198,'M','6','5',44),(5279,48,14,198,'M','6','6',44),(5280,48,14,198,'M','6','7',44),(5281,48,14,198,'1','7','1',44),(5282,48,14,198,'M','7','2',44),(5283,48,14,198,'M','7','3',44),(5284,48,14,198,'M','7','4',44),(5285,48,14,198,'M','7','5',44),(5286,48,14,198,'M','7','6',44),(5287,48,14,198,'M','7','7',44),(5288,48,14,199,'2','1','1',44),(5289,48,14,199,'1','1','2',44),(5290,48,14,199,'1','1','3',44),(5291,48,14,199,'M','1','4',44),(5292,48,14,199,'M','1','5',44),(5293,48,14,199,'M','1','6',44),(5294,48,14,199,'M','1','7',44),(5295,48,14,199,'2','2','1',44),(5296,48,14,199,'2','2','2',44),(5297,48,14,199,'M','2','3',44),(5298,48,14,199,'M','2','4',44),(5299,48,14,199,'M','2','5',44),(5300,48,14,199,'M','2','6',44),(5301,48,14,199,'M','2','7',44),(5302,48,14,200,'1','1','1',44),(5303,48,14,200,'M','1','2',44),(5304,48,14,200,'M','1','3',44),(5305,48,14,200,'M','1','4',44),(5306,48,14,200,'M','1','5',44),(5307,48,14,200,'M','1','6',44),(5308,48,14,200,'M','1','7',44),(5309,48,14,200,'2','2','1',44),(5310,48,14,200,'1','2','2',44),(5311,48,14,200,'1','2','3',44),(5312,48,14,200,'M','2','4',44),(5313,48,14,200,'M','2','5',44),(5314,48,14,200,'M','2','6',44),(5315,48,14,200,'M','2','7',44),(5316,48,14,200,'1','3','1',44),(5317,48,14,200,'1','3','2',44),(5318,48,14,200,'M','3','3',44),(5319,48,14,200,'M','3','4',44),(5320,48,14,200,'M','3','5',44),(5321,48,14,200,'M','3','6',44),(5322,48,14,200,'M','3','7',44),(5323,48,14,200,'2','4','1',44),(5324,48,14,200,'2','4','2',44),(5325,48,14,200,'M','4','3',44),(5326,48,14,200,'M','4','4',44),(5327,48,14,200,'M','4','5',44),(5328,48,14,200,'M','4','6',44),(5329,48,14,200,'M','4','7',44),(5330,48,14,200,'2','5','1',44),(5331,48,14,200,'2','5','2',44),(5332,48,14,200,'1','5','3',44),(5333,48,14,200,'1','5','4',44),(5334,48,14,200,'M','5','5',44),(5335,48,14,200,'M','5','6',44),(5336,48,14,200,'M','5','7',44),(5337,48,14,200,'2','6','1',44),(5338,48,14,200,'1','6','2',44),(5339,48,14,200,'1','6','3',44),(5340,48,14,200,'M','6','4',44),(5341,48,14,200,'M','6','5',44),(5342,48,14,200,'M','6','6',44),(5343,48,14,200,'M','6','7',44),(5344,48,14,200,'1','7','1',44),(5345,48,14,200,'1','7','2',44),(5346,48,14,200,'M','7','3',44),(5347,48,14,200,'M','7','4',44),(5348,48,14,200,'M','7','5',44),(5349,48,14,200,'M','7','6',44),(5350,48,14,200,'M','7','7',44),(5351,48,14,196,'1','3','3',44),(5352,46,14,187,'9','6','1',43),(5353,47,14,166,'1','1','1',45),(5354,47,14,166,'1','1','2',45),(5355,47,14,166,'1','1','3',45),(5356,47,14,166,'1','1','4',45),(5357,47,14,166,'M','1','5',45),(5358,47,14,166,'M','1','6',45),(5359,47,14,166,'M','1','7',45),(5360,47,14,166,'M','1','8',45),(5361,47,14,166,'M','1','9',45),(5362,47,14,203,'1','1','1',45),(5363,47,14,203,'1','1','2',45),(5364,47,14,203,'1','1','3',45),(5365,47,14,203,'M','1','4',45),(5366,47,14,203,'M','1','5',45),(5367,47,14,203,'M','1','6',45),(5368,47,14,203,'M','1','7',45),(5369,47,14,203,'M','1','8',45),(5370,47,14,203,'M','1','9',45),(5371,47,14,158,'1','1','1',45),(5372,47,14,158,'1','1','2',45),(5373,47,14,158,'1','1','3',45),(5374,47,14,158,'M','1','4',45),(5375,47,14,158,'M','1','5',45),(5376,47,14,158,'M','1','6',45),(5377,47,14,158,'M','1','7',45),(5378,47,14,158,'M','1','8',45),(5379,47,14,158,'M','1','9',45),(5380,47,14,158,'M','2','1',45),(5381,47,14,158,'M','2','2',45),(5382,47,14,158,'M','2','3',45),(5383,47,14,158,'M','2','4',45),(5385,47,14,158,'M','2','6',45),(5386,47,14,158,'M','2','7',45),(5387,47,14,158,'M','2','8',45),(5388,47,14,158,'M','2','9',45),(5389,47,14,166,'1','2','1',45),(5390,47,14,166,'1','2','2',45),(5391,47,14,166,'1','2','3',45),(5392,47,14,166,'1','2','4',45),(5393,47,14,166,'M','2','5',45),(5394,47,14,166,'M','2','6',45),(5395,47,14,166,'M','2','7',45),(5396,47,14,166,'M','2','8',45),(5397,47,14,166,'M','2','9',45),(5398,47,14,203,'1','2','1',45),(5399,47,14,203,'1','2','2',45),(5400,47,14,203,'1','2','3',45),(5401,47,14,203,'1','2','4',45),(5403,47,14,203,'M','2','5',45),(5404,47,14,203,'M','2','6',45),(5405,47,14,203,'M','2','7',45),(5406,47,14,203,'M','2','8',45),(5407,47,14,203,'M','2','9',45),(5408,47,14,207,'1','1','1',45),(5409,47,14,207,'M','1','2',45),(5410,47,14,207,'M','1','3',45),(5411,47,14,207,'M','1','4',45),(5412,47,14,207,'M','1','5',45),(5413,47,14,207,'M','1','6',45),(5414,47,14,207,'M','1','7',45),(5415,47,14,207,'M','1','8',45),(5416,47,14,207,'M','1','9',45),(5417,13,11,210,'10','1','1',46),(5418,13,11,210,'10','1','2',46),(5419,13,11,210,'10','1','3',46),(5420,13,11,210,'10','1','4',46),(5421,13,11,210,'10','1','5',46),(5422,13,11,210,'7','1','6',46),(5423,13,11,210,'10','2','1',46),(5424,13,11,210,'10','2','2',46),(5425,13,11,210,'10','2','3',46),(5426,13,11,210,'10','2','4',46),(5427,13,11,210,'10','2','5',46),(5428,13,11,210,'6','2','6',46),(5429,13,11,210,'10','3','1',46),(5430,13,11,210,'10','3','2',46),(5431,13,11,210,'10','3','3',46),(5432,13,11,210,'10','3','4',46),(5433,13,11,210,'10','3','5',46),(5434,13,11,210,'9','3','6',46),(5435,13,11,210,'10','4','1',46),(5436,13,11,210,'10','4','2',46),(5437,13,11,210,'10','4','3',46),(5438,13,11,210,'10','4','4',46),(5439,13,11,210,'10','4','5',46),(5440,13,11,210,'8','4','6',46),(5441,13,11,210,'10','5','1',46),(5442,13,11,210,'10','5','2',46),(5443,13,11,210,'10','5','3',46),(5444,13,11,210,'10','5','4',46),(5445,13,11,210,'10','5','5',46),(5446,13,11,210,'9','5','6',46),(5447,13,11,210,'10','6','1',46),(5448,13,11,210,'10','6','2',46),(5449,13,11,210,'10','6','3',46),(5450,13,11,210,'10','6','4',46),(5451,13,11,210,'10','6','5',46),(5452,13,11,210,'9','6','6',46),(5453,13,11,38,'10','1','1',46),(5454,13,11,38,'10','1','2',46),(5455,13,11,38,'10','1','3',46),(5456,13,11,38,'10','1','4',46),(5457,13,11,38,'10','1','5',46),(5458,13,11,38,'7','1','6',46),(5459,13,11,38,'10','2','1',46),(5460,13,11,38,'10','2','2',46),(5461,13,11,38,'10','2','3',46),(5462,13,11,38,'10','2','4',46),(5463,13,11,38,'10','2','5',46),(5464,13,11,38,'2','2','6',46),(5465,13,11,38,'10','3','1',46),(5466,13,11,38,'10','3','2',46),(5467,13,11,38,'10','3','3',46),(5468,13,11,38,'10','3','4',46),(5469,13,11,38,'3','3','5',46),(5470,13,11,38,'2','3','6',46),(5471,13,11,38,'10','4','1',46),(5472,13,11,38,'10','4','2',46),(5473,13,11,38,'10','4','3',46),(5474,13,11,38,'10','4','4',46),(5475,13,11,38,'10','4','5',46),(5476,13,11,38,'1','4','6',46),(5477,13,11,38,'10','5','1',46),(5478,13,11,38,'10','5','2',46),(5479,13,11,38,'10','5','3',46),(5480,13,11,38,'10','5','4',46),(5481,13,11,38,'10','5','5',46),(5482,13,11,38,'1','5','6',46),(5483,13,11,38,'10','6','1',46),(5484,13,11,38,'10','6','2',46),(5485,13,11,38,'10','6','3',46),(5486,13,11,38,'10','6','4',46),(5487,13,11,38,'10','6','5',46),(5488,13,11,38,'2','6','6',46),(5489,13,11,26,'10','1','1',46),(5490,13,11,26,'10','1','2',46),(5491,13,11,26,'10','1','3',46),(5492,13,11,26,'10','1','4',46),(5493,13,11,26,'10','1','5',46),(5494,13,11,26,'2','1','6',46),(5495,13,11,26,'10','2','1',46),(5496,13,11,26,'10','2','2',46),(5497,13,11,26,'10','2','3',46),(5498,13,11,26,'10','2','4',46),(5499,13,11,26,'10','2','5',46),(5500,13,11,26,'M','2','6',46),(5501,13,11,26,'10','3','1',46),(5502,13,11,26,'10','3','2',46),(5503,13,11,26,'10','3','3',46),(5504,13,11,26,'10','3','4',46),(5505,13,11,26,'10','3','5',46),(5506,13,11,26,'1','3','6',46),(5507,13,11,26,'10','4','1',46),(5508,13,11,26,'10','4','2',46),(5509,13,11,26,'10','4','3',46),(5510,13,11,26,'10','4','4',46),(5511,13,11,26,'2','4','5',46),(5512,13,11,26,'2','4','6',46),(5513,13,11,26,'10','5','1',46),(5514,13,11,26,'10','5','2',46),(5515,13,11,26,'10','5','3',46),(5516,13,11,26,'10','5','4',46),(5517,13,11,26,'10','5','5',46),(5518,13,11,26,'7','5','6',46),(5519,13,11,26,'10','6','1',46),(5520,13,11,26,'10','6','2',46),(5521,13,11,26,'10','6','3',46),(5522,13,11,26,'10','6','4',46),(5523,13,11,26,'10','6','5',46),(5524,13,11,26,'1','6','6',46),(5525,13,11,29,'10','1','1',46),(5526,13,11,29,'10','1','2',46),(5527,13,11,29,'10','1','3',46),(5528,13,11,29,'10','1','4',46),(5529,13,11,29,'5','1','5',46),(5530,13,11,29,'5','1','6',46),(5531,13,11,29,'10','2','1',46),(5532,13,11,29,'10','2','2',46),(5533,13,11,29,'10','2','3',46),(5534,13,11,29,'10','2','4',46),(5535,13,11,29,'4','2','5',46),(5536,13,11,29,'4','2','6',46),(5537,13,11,29,'10','3','1',46),(5538,13,11,29,'10','3','2',46),(5539,13,11,29,'10','3','3',46),(5540,13,11,29,'10','3','4',46),(5541,13,11,29,'6','3','5',46),(5542,13,11,29,'4','3','6',46),(5543,13,11,29,'10','4','1',46),(5544,13,11,29,'10','4','2',46),(5545,13,11,29,'10','4','3',46),(5546,13,11,29,'10','4','4',46),(5547,13,11,29,'7','4','5',46),(5548,13,11,29,'3','4','6',46),(5549,13,11,29,'10','5','1',46),(5550,13,11,29,'10','5','2',46),(5551,13,11,29,'10','5','3',46),(5552,13,11,29,'10','5','4',46),(5553,13,11,29,'2','5','5',46),(5554,13,11,29,'2','5','6',46),(5555,13,11,29,'10','6','1',46),(5556,13,11,29,'10','6','2',46),(5557,13,11,29,'10','6','3',46),(5558,13,11,29,'10','6','4',46),(5559,13,11,29,'1','6','5',46),(5560,13,11,29,'1','6','6',46),(5561,13,11,36,'10','1','1',46),(5562,13,11,36,'10','1','2',46),(5563,13,11,36,'10','1','3',46),(5564,13,11,36,'10','1','4',46),(5565,13,11,36,'5','1','5',46),(5566,13,11,36,'4','1','6',46),(5567,13,11,36,'10','2','1',46),(5568,13,11,36,'10','2','2',46),(5569,13,11,36,'10','2','3',46),(5570,13,11,36,'10','2','4',46),(5571,13,11,36,'4','2','5',46),(5572,13,11,36,'3','2','6',46),(5573,13,11,36,'10','3','1',46),(5574,13,11,36,'10','3','2',46),(5575,13,11,36,'10','3','3',46),(5576,13,11,36,'10','3','4',46),(5577,13,11,36,'3','3','5',46),(5578,13,11,36,'1','3','6',46),(5579,13,11,36,'10','4','1',46),(5580,13,11,36,'10','4','2',46),(5581,13,11,36,'10','4','3',46),(5582,13,11,36,'10','4','4',46),(5583,13,11,36,'6','4','5',46),(5584,13,11,36,'2','4','6',46),(5585,13,11,36,'10','5','1',46),(5586,13,11,36,'10','5','2',46),(5587,13,11,36,'10','5','3',46),(5588,13,11,36,'10','5','4',46),(5589,13,11,36,'5','5','5',46),(5590,13,11,36,'2','5','6',46),(5591,13,11,36,'10','6','1',46),(5592,13,11,36,'10','6','2',46),(5593,13,11,36,'10','6','3',46),(5594,13,11,36,'10','6','4',46),(5595,13,11,36,'4','6','5',46),(5596,13,11,36,'2','6','6',46),(5597,13,11,25,'10','1','1',46),(5598,13,11,25,'10','1','2',46),(5599,13,11,25,'5','1','3',46),(5600,13,11,25,'4','1','4',46),(5601,13,11,25,'1','1','5',46),(5602,13,11,25,'1','1','6',46),(5603,13,11,25,'10','2','1',46),(5604,13,11,25,'10','2','2',46),(5605,13,11,25,'10','2','3',46),(5606,13,11,25,'10','2','4',46),(5607,13,11,25,'2','2','5',46),(5608,13,11,25,'2','2','6',46),(5609,13,11,25,'10','3','1',46),(5610,13,11,25,'10','3','2',46),(5611,13,11,25,'10','3','3',46),(5612,13,11,25,'10','3','4',46),(5613,13,11,25,'3','3','5',46),(5614,13,11,25,'3','3','6',46),(5615,13,11,25,'10','4','1',46),(5616,13,11,25,'10','4','2',46),(5617,13,11,25,'10','4','3',46),(5618,13,11,25,'10','4','4',46),(5619,13,11,25,'10','4','5',46),(5620,13,11,25,'1','4','6',46),(5621,13,11,25,'10','5','1',46),(5622,13,11,25,'10','5','2',46),(5623,13,11,25,'10','5','3',46),(5624,13,11,25,'10','5','4',46),(5625,13,11,25,'10','5','5',46),(5626,13,11,25,'1','5','6',46),(5627,13,11,25,'10','6','1',46),(5628,13,11,25,'10','6','2',46),(5629,13,11,25,'10','6','3',46),(5630,13,11,25,'10','6','4',46),(5631,13,11,25,'10','6','5',46),(5632,13,11,25,'1','6','6',46),(5633,13,11,24,'10','1','1',46),(5634,13,11,24,'10','1','2',46),(5635,13,11,24,'8','1','3',46),(5636,13,11,24,'5','1','4',46),(5637,13,11,24,'1','1','6',46),(5638,13,11,24,'4','1','5',46),(5639,13,11,24,'10','2','2',46),(5640,13,11,24,'10','2','3',46),(5641,13,11,24,'10','2','4',46),(5642,13,11,24,'4','2','5',46),(5643,13,11,24,'2','2','6',46),(5644,13,11,24,'10','3','1',46),(5645,13,11,24,'10','3','2',46),(5646,13,11,24,'10','3','3',46),(5647,13,11,24,'10','3','4',46),(5648,13,11,24,'3','3','5',46),(5649,13,11,24,'2','3','6',46),(5650,13,11,24,'10','4','1',46),(5651,13,11,24,'10','4','2',46),(5652,13,11,24,'10','4','3',46),(5653,13,11,24,'10','4','4',46),(5654,13,11,24,'5','4','5',46),(5655,13,11,24,'5','4','6',46),(5656,13,11,24,'10','5','1',46),(5657,13,11,24,'10','5','2',46),(5658,13,11,24,'10','5','3',46),(5660,13,11,24,'5','5','4',46),(5661,13,11,24,'1','5','5',46),(5662,13,11,24,'1','5','6',46),(5664,13,11,24,'10','6','1',46),(5665,13,11,24,'10','6','2',46),(5666,13,11,24,'10','6','3',46),(5667,13,11,24,'10','6','5',46),(5668,13,11,24,'4','6','6',46),(5669,13,11,212,'10','1','3',46),(5670,13,11,212,'10','1','4',46),(5671,13,11,212,'6','1','5',46),(5672,13,11,212,'10','1','2',46),(5673,13,11,212,'4','1','6',46),(5674,13,11,212,'10','2','1',46),(5675,13,11,212,'10','1','1',46),(5676,13,11,212,'10','2','2',46),(5677,13,11,212,'2','2','6',46),(5678,13,11,212,'10','3','1',46),(5679,13,11,212,'10','3','2',46),(5680,13,11,212,'4','3','3',46),(5681,13,11,212,'3','3','4',46),(5682,13,11,212,'2','3','5',46),(5683,13,11,212,'1','3','6',46),(5684,13,11,212,'10','4','1',46),(5685,13,11,212,'10','4','2',46),(5686,13,11,212,'10','4','3',46),(5687,13,11,212,'10','4','4',46),(5688,13,11,212,'2','4','5',46),(5689,13,11,212,'2','4','6',46),(5690,13,11,212,'10','5','1',46),(5691,13,11,212,'10','5','2',46),(5692,13,11,212,'10','5','3',46),(5693,13,11,212,'10','5','4',46),(5694,13,11,212,'5','5','5',46),(5695,13,11,212,'5','5','6',46),(5696,13,11,212,'10','6','1',46),(5697,13,11,212,'10','6','2',46),(5698,13,11,212,'10','6','3',46),(5699,13,11,212,'5','6','4',46),(5700,13,11,212,'3','6','5',46),(5702,13,11,212,'3','6','6',46),(5703,13,11,35,'10','1','1',46),(5704,13,11,35,'10','1','2',46),(5705,13,11,35,'10','1','3',46),(5706,13,11,35,'5','1','4',46),(5707,13,11,35,'5','1','5',46),(5708,13,11,35,'5','1','6',46),(5709,13,11,35,'10','2','1',46),(5710,13,11,35,'10','2','2',46),(5711,13,11,35,'8','2','3',46),(5712,13,11,35,'5','2','4',46),(5713,13,11,35,'3','2','5',46),(5714,13,11,35,'2','2','6',46),(5715,13,11,35,'10','3','1',46),(5716,13,11,35,'10','3','2',46),(5717,13,11,35,'10','3','3',46),(5718,13,11,35,'10','3','4',46),(5719,13,11,35,'5','3','5',46),(5720,13,11,35,'4','3','6',46),(5721,13,11,35,'10','4','1',46),(5722,13,11,35,'10','4','2',46),(5723,13,11,35,'10','4','3',46),(5724,13,11,35,'10','4','4',46),(5725,13,11,35,'3','4','5',46),(5726,13,11,35,'3','4','6',46),(5727,13,11,35,'10','5','1',46),(5728,13,11,35,'10','5','2',46),(5729,13,11,35,'10','5','3',46),(5730,13,11,35,'10','5','4',46),(5731,13,11,35,'1','5','5',46),(5732,13,11,35,'1','5','6',46),(5733,13,11,35,'10','6','1',46),(5734,13,11,35,'10','6','4',46),(5735,13,11,35,'3','6','5',46),(5736,13,11,35,'2','6','6',46),(5737,13,11,35,'10','6','3',46),(5739,13,11,27,'10','1','1',46),(5740,13,11,27,'10','1','2',46),(5741,13,11,27,'10','1','3',46),(5742,13,11,27,'10','1','4',46),(5743,13,11,27,'4','1','5',46),(5744,13,11,27,'3','1','6',46),(5745,13,11,27,'10','2','1',46),(5746,13,11,27,'10','2','2',46),(5747,13,11,27,'10','2','3',46),(5748,13,11,27,'3','2','4',46),(5749,13,11,27,'3','2','5',46),(5750,13,11,27,'1','2','6',46),(5751,13,11,27,'10','3','1',46),(5752,13,11,27,'10','3','2',46),(5753,13,11,27,'10','3','3',46),(5754,13,11,27,'5','3','4',46),(5755,13,11,27,'2','3','5',46),(5756,13,11,27,'2','3','6',46),(5757,13,11,27,'10','4','1',46),(5758,13,11,27,'10','4','2',46),(5759,13,11,27,'10','4','3',46),(5760,13,11,27,'10','4','4',46),(5761,13,11,27,'3','4','5',46),(5762,13,11,27,'1','4','6',46),(5763,13,11,27,'10','5','1',46),(5764,13,11,27,'10','5','2',46),(5765,13,11,27,'10','5','3',46),(5766,13,11,27,'4','5','4',46),(5767,13,11,27,'4','5','5',46),(5768,13,11,27,'2','5','6',46),(5769,13,11,27,'10','6','1',46),(5770,13,11,27,'10','6','2',46),(5771,13,11,27,'4','6','3',46),(5772,13,11,27,'3','6','4',46),(5773,13,11,27,'1','6','5',46),(5774,13,11,27,'1','6','6',46),(5775,13,11,32,'10','1','1',46),(5776,13,11,32,'10','1','2',46),(5777,13,11,32,'10','1','3',46),(5778,13,11,32,'7','1','4',46),(5779,13,11,32,'2','1','5',46),(5780,13,11,32,'2','1','6',46),(5781,13,11,32,'10','2','1',46),(5782,13,11,32,'10','2','2',46),(5783,13,11,32,'5','2','3',46),(5784,13,11,32,'5','2','4',46),(5785,13,11,32,'5','2','5',46),(5786,13,11,32,'3','2','6',46),(5787,13,11,32,'10','3','1',46),(5788,13,11,32,'10','3','2',46),(5789,13,11,32,'5','3','3',46),(5790,13,11,32,'5','3','4',46),(5791,13,11,32,'1','3','5',46),(5792,13,11,32,'1','3','6',46),(5793,13,11,32,'10','4','1',46),(5794,13,11,32,'10','4','2',46),(5795,13,11,32,'10','4','3',46),(5796,13,11,32,'4','4','4',46),(5797,13,11,32,'2','4','5',46),(5798,13,11,32,'1','4','6',46),(5799,13,11,32,'10','5','1',46),(5800,13,11,32,'10','5','2',46),(5801,13,11,32,'10','5','3',46),(5802,13,11,32,'4','5','4',46),(5803,13,11,32,'2','5','5',46),(5804,13,11,32,'1','5','6',46),(5805,13,11,32,'10','6','1',46),(5806,13,11,32,'10','6','2',46),(5807,13,11,32,'10','6','3',46),(5808,13,11,32,'10','6','4',46),(5809,13,11,32,'3','6','5',46),(5810,13,11,32,'2','6','6',46),(5811,13,11,33,'M','1','1',46),(5812,13,11,33,'M','1','2',46),(5813,13,11,33,'M','1','3',46),(5814,13,11,33,'M','1','4',46),(5815,13,11,33,'M','1','5',46),(5816,13,11,33,'M','1','6',46),(5817,13,11,33,'M','2','1',46),(5818,13,11,33,'M','2','2',46),(5819,13,11,33,'M','2','3',46),(5820,13,11,33,'M','2','4',46),(5821,13,11,33,'M','2','5',46),(5822,13,11,33,'M','2','6',46),(5823,13,11,33,'10','3','1',46),(5824,13,11,33,'10','3','2',46),(5825,13,11,33,'10','3','3',46),(5826,13,11,33,'10','3','4',46),(5827,13,11,33,'10','3','5',46),(5828,13,11,33,'3','3','6',46),(5829,13,11,33,'10','4','1',46),(5830,13,11,33,'10','4','2',46),(5831,13,11,33,'10','4','3',46),(5832,13,11,33,'10','4','4',46),(5833,13,11,33,'10','4','5',46),(5834,13,11,33,'M','4','6',46),(5835,13,11,33,'10','5','1',46),(5836,13,11,33,'10','5','2',46),(5837,13,11,33,'10','5','3',46),(5838,13,11,33,'10','5','4',46),(5839,13,11,33,'10','5','5',46),(5840,13,11,33,'6','5','6',46),(5841,13,11,33,'10','6','1',46),(5842,13,11,33,'10','6','2',46),(5843,13,11,33,'10','6','3',46),(5844,13,11,33,'10','6','4',46),(5845,13,11,33,'10','6','5',46),(5846,13,11,33,'2','6','6',46),(5847,13,11,34,'5','1','1',46),(5848,13,11,34,'5','1','2',46),(5849,13,11,34,'5','1','3',46),(5850,13,11,34,'5','1','4',46),(5851,13,11,34,'3','1','5',46),(5852,13,11,34,'2','1','6',46),(5853,13,11,34,'10','2','1',46),(5854,13,11,34,'5','2','2',46),(5855,13,11,34,'5','2','3',46),(5856,13,11,34,'5','2','4',46),(5857,13,11,34,'5','2','5',46),(5858,13,11,34,'2','2','6',46),(5859,13,11,34,'5','3','1',46),(5860,13,11,34,'5','3','2',46),(5861,13,11,34,'5','3','3',46),(5862,13,11,34,'5','3','4',46),(5863,13,11,34,'5','3','5',46),(5864,13,11,34,'1','3','6',46),(5865,13,11,34,'10','4','2',46),(5866,13,11,34,'10','4','1',46),(5867,13,11,34,'10','4','3',46),(5868,13,11,34,'3','4','4',46),(5869,13,11,34,'2','4','5',46),(5870,13,11,34,'2','4','6',46),(5871,13,11,34,'5','5','3',46),(5872,13,11,34,'5','5','5',46),(5873,13,11,34,'4','5','6',46),(5874,13,11,34,'5','5','4',46),(5875,13,11,34,'5','5','2',46),(5876,13,11,37,'3','1','1',46),(5877,13,11,37,'3','1','2',46),(5878,13,11,37,'3','1','3',46),(5879,13,11,37,'3','1','4',46),(5880,13,11,37,'3','1','5',46),(5881,13,11,37,'1','1','6',46),(5882,13,11,37,'1','2','2',46),(5883,13,11,37,'1','2','1',46),(5884,13,11,37,'1','2','3',46),(5885,13,11,37,'1','2','4',46),(5886,13,11,37,'1','2','5',46),(5887,13,11,37,'1','2','6',46),(5888,13,11,37,'10','3','1',46),(5889,13,11,37,'10','3','2',46),(5890,13,11,37,'10','3','3',46),(5891,13,11,37,'10','3','4',46),(5892,13,11,37,'4','3','5',46),(5893,13,11,37,'1','3','6',46),(5894,13,11,37,'10','4','2',46),(5895,13,11,37,'10','4','1',46),(5896,13,11,37,'10','4','3',46),(5897,13,11,37,'10','4','4',46),(5898,13,11,37,'1','4','5',46),(5899,13,11,37,'1','4','6',46),(5900,13,11,37,'10','5','1',46),(5901,13,11,37,'10','5','2',46),(5902,13,11,37,'10','5','3',46),(5903,13,11,37,'3','5','4',46),(5904,13,11,37,'1','5','5',46),(5905,13,11,37,'1','5','6',46),(5906,13,11,37,'10','6','1',46),(5907,13,11,37,'10','6','2',46),(5908,13,11,37,'10','6','3',46),(5909,13,11,37,'10','6','4',46),(5910,13,11,37,'2','6','5',46),(5911,13,11,37,'1','6','6',46),(5912,13,11,28,'10','1','1',46),(5913,13,11,28,'9','1','2',46),(5914,13,11,28,'M','1','3',46),(5915,13,11,28,'M','1','4',46),(5916,13,11,28,'M','1','5',46),(5917,13,11,28,'M','1','6',46),(5918,13,11,28,'10','2','1',46),(5919,13,11,28,'10','2','2',46),(5920,13,11,28,'1','2','3',46),(5921,13,11,28,'M','2','4',46),(5922,13,11,28,'M','2','5',46),(5923,13,11,28,'M','2','6',46),(5924,13,11,28,'10','3','1',46),(5925,13,11,28,'10','3','2',46),(5926,13,11,28,'3','3','3',46),(5927,13,11,28,'M','3','4',46),(5928,13,11,28,'M','3','5',46),(5929,13,11,28,'M','3','6',46),(5930,13,11,28,'10','4','1',46),(5931,13,11,28,'10','4','2',46),(5932,13,11,28,'10','4','3',46),(5933,13,11,28,'2','4','4',46),(5934,13,11,28,'M','4','5',46),(5935,13,11,28,'M','4','6',46),(5936,13,11,28,'10','5','1',46),(5937,13,11,28,'10','5','2',46),(5938,13,11,28,'10','5','3',46),(5939,13,11,28,'10','5','4',46),(5940,13,11,28,'2','5','5',46),(5941,13,11,28,'2','5','6',46),(5942,13,11,28,'10','6','1',46),(5943,13,11,28,'10','6','2',46),(5944,13,11,28,'10','6','3',46),(5945,13,11,28,'9','6','4',46),(5946,13,11,28,'M','6','5',46),(5947,13,11,28,'M','6','6',46),(5948,13,11,30,'M','1','1',46),(5949,13,11,30,'M','1','2',46),(5950,13,11,30,'M','1','3',46),(5951,13,11,30,'M','1','4',46),(5952,13,11,30,'M','1','5',46),(5953,13,11,30,'M','1','6',46),(5954,13,11,30,'M','2','1',46),(5955,13,11,30,'M','2','2',46),(5956,13,11,30,'M','2','3',46),(5957,13,11,30,'M','2','4',46),(5958,13,11,30,'M','2','5',46),(5959,13,11,30,'M','2','6',46),(5960,13,11,30,'M','3','1',46),(5961,13,11,30,'M','3','2',46),(5962,13,11,30,'M','3','3',46),(5963,13,11,30,'M','3','4',46),(5964,13,11,30,'M','3','5',46),(5965,13,11,30,'M','3','6',46),(5966,13,11,30,'M','4','1',46),(5967,13,11,30,'M','4','2',46),(5968,13,11,30,'M','4','3',46),(5969,13,11,30,'M','4','4',46),(5970,13,11,30,'M','4','5',46),(5971,13,11,30,'M','4','6',46),(5972,13,11,30,'M','5','1',46),(5973,13,11,30,'M','5','2',46),(5974,13,11,30,'M','5','3',46),(5975,13,11,30,'M','5','4',46),(5976,13,11,30,'M','5','5',46),(5977,13,11,30,'M','5','6',46),(5978,13,11,30,'M','6','1',46),(5979,13,11,30,'M','6','2',46),(5980,13,11,30,'M','6','3',46),(5981,13,11,30,'M','6','4',46),(5982,13,11,30,'M','6','5',46),(5983,13,11,30,'M','6','6',46),(5984,13,11,24,'10','2','1',46),(5985,13,11,24,'10','6','4',46),(5986,13,11,212,'10','2','3',46),(5987,13,11,212,'10','2','4',46),(5988,13,11,212,'9','2','5',46),(5989,13,11,35,'10','6','2',46),(5990,13,11,34,'5','5','1',46),(5991,13,11,34,'10','6','1',46),(5992,13,11,34,'10','6','2',46),(5993,13,11,34,'10','6','3',46),(5994,13,11,34,'10','6','4',46),(5995,13,11,34,'1','6','5',46),(5996,13,11,34,'1','6','6',46),(5997,49,11,213,'10','1','1',48),(5998,49,11,213,'10','1','2',48),(5999,49,11,213,'10','1','3',48),(6000,49,11,213,'10','1','4',48),(6001,49,11,213,'10','1','5',48),(6002,49,11,213,'5','1','6',48),(6003,49,11,213,'10','2','1',48),(6004,49,11,213,'10','2','2',48),(6005,49,11,213,'10','2','3',48),(6006,49,11,213,'10','2','4',48),(6007,49,11,213,'10','2','5',48),(6008,49,11,213,'7','2','6',48),(6009,49,11,213,'10','3','1',48),(6010,49,11,213,'10','3','2',48),(6011,49,11,213,'10','3','3',48),(6012,49,11,213,'10','3','4',48),(6013,49,11,213,'10','3','5',48),(6014,49,11,213,'8','3','6',48),(6015,49,11,213,'10','4','1',48),(6016,49,11,213,'10','4','2',48),(6017,49,11,213,'10','4','3',48),(6018,49,11,213,'10','4','4',48),(6019,49,11,213,'10','4','5',48),(6020,49,11,213,'8','4','6',48),(6021,49,11,213,'10','5','1',48),(6022,49,11,213,'10','5','2',48),(6023,49,11,213,'10','5','3',48),(6024,49,11,213,'10','5','4',48),(6025,49,11,213,'10','5','5',48),(6026,49,11,213,'5','5','6',48),(6027,49,11,213,'10','6','1',48),(6028,49,11,213,'10','6','3',48),(6029,49,11,213,'10','6','4',48),(6030,49,11,213,'10','6','5',48),(6031,49,11,213,'7','6','6',48),(6032,49,11,213,'10','6','2',48),(6033,49,11,214,'10','1','1',48),(6034,49,11,214,'10','1','2',48),(6035,49,11,214,'10','1','3',48),(6036,49,11,214,'10','1','4',48),(6037,49,11,214,'10','1','5',48),(6038,49,11,214,'5','1','6',48),(6039,49,11,214,'10','2','1',48),(6040,49,11,214,'10','2','2',48),(6041,49,11,214,'10','2','3',48),(6042,49,11,214,'10','2','4',48),(6043,49,11,214,'10','2','5',48),(6044,49,11,214,'5','2','6',48),(6045,49,11,214,'10','3','1',48),(6046,49,11,214,'10','3','2',48),(6047,49,11,214,'10','3','3',48),(6048,49,11,214,'10','3','4',48),(6049,49,11,214,'10','3','5',48),(6051,49,11,214,'10','4','1',48),(6052,49,11,214,'10','4','2',48),(6053,49,11,214,'10','4','3',48),(6054,49,11,214,'10','4','4',48),(6055,49,11,214,'10','4','5',48),(6057,49,11,214,'10','5','1',48),(6058,49,11,214,'10','5','2',48),(6059,49,11,214,'10','5','3',48),(6060,49,11,214,'10','5','4',48),(6061,49,11,214,'10','5','5',48),(6062,49,11,214,'6','5','6',48),(6063,49,11,214,'10','6','1',48),(6064,49,11,214,'10','6','2',48),(6065,49,11,214,'10','6','3',48),(6066,49,11,214,'10','6','4',48),(6067,49,11,214,'10','6','5',48),(6068,49,11,214,'6','6','6',48),(6069,49,11,214,'5','3','6',48),(6070,49,11,214,'4','4','6',48),(6071,49,11,215,'10','1','1',48),(6072,49,11,215,'10','1','2',48),(6073,49,11,215,'10','1','3',48),(6074,49,11,215,'10','1','4',48),(6075,49,11,215,'10','1','5',48),(6076,49,11,215,'1','1','6',48),(6077,49,11,215,'10','2','1',48),(6078,49,11,215,'10','2','2',48),(6079,49,11,215,'10','2','3',48),(6080,49,11,215,'10','2','4',48),(6081,49,11,215,'10','2','5',48),(6082,49,11,215,'4','2','6',48),(6083,49,11,215,'10','3','1',48),(6084,49,11,215,'10','3','2',48),(6085,49,11,215,'10','3','3',48),(6086,49,11,215,'10','3','4',48),(6087,49,11,215,'10','3','5',48),(6088,49,11,215,'1','3','6',48),(6089,49,11,215,'10','4','1',48),(6090,49,11,215,'10','4','2',48),(6091,49,11,215,'10','4','3',48),(6092,49,11,215,'10','4','4',48),(6093,49,11,215,'10','4','5',48),(6094,49,11,215,'5','4','6',48),(6095,49,11,215,'10','5','1',48),(6096,49,11,215,'10','5','2',48),(6097,49,11,215,'10','5','3',48),(6098,49,11,215,'10','5','4',48),(6099,49,11,215,'10','5','5',48),(6100,49,11,215,'5','5','6',48),(6101,49,11,215,'10','6','1',48),(6102,49,11,215,'10','6','2',48),(6103,49,11,215,'10','6','3',48),(6104,49,11,215,'10','6','4',48),(6105,49,11,215,'10','6','5',48),(6106,49,11,215,'6','6','6',48),(6107,49,11,216,'10','1','1',48),(6108,49,11,216,'10','1','2',48),(6109,49,11,216,'10','1','3',48),(6110,49,11,216,'10','1','4',48),(6111,49,11,216,'10','1','5',48),(6112,49,11,216,'7','1','6',48),(6113,49,11,216,'10','2','1',48),(6114,49,11,216,'10','2','2',48),(6115,49,11,216,'10','2','3',48),(6116,49,11,216,'10','2','4',48),(6117,49,11,216,'10','2','5',48),(6118,49,11,216,'4','2','6',48),(6119,49,11,216,'10','3','1',48),(6120,49,11,216,'10','3','2',48),(6121,49,11,216,'10','3','3',48),(6122,49,11,216,'10','3','4',48),(6123,49,11,216,'10','3','5',48),(6124,49,11,216,'5','3','6',48),(6125,49,11,216,'10','4','1',48),(6126,49,11,216,'10','4','2',48),(6127,49,11,216,'10','4','3',48),(6128,49,11,216,'10','4','4',48),(6129,49,11,216,'10','4','5',48),(6130,49,11,216,'6','4','6',48),(6131,49,11,216,'10','5','1',48),(6132,49,11,216,'10','5','2',48),(6133,49,11,216,'10','5','3',48),(6134,49,11,216,'10','5','4',48),(6135,49,11,216,'8','5','5',48),(6136,49,11,216,'10','6','1',48),(6137,49,11,216,'10','6','2',48),(6138,49,11,216,'10','6','3',48),(6139,49,11,216,'10','6','4',48),(6140,49,11,216,'10','6','5',48),(6141,49,11,217,'10','1','1',48),(6142,49,11,217,'10','1','2',48),(6143,49,11,217,'10','1','3',48),(6144,49,11,217,'10','1','4',48),(6145,49,11,217,'10','1','5',48),(6146,49,11,217,'2','1','6',48),(6147,49,11,217,'10','2','1',48),(6148,49,11,217,'10','2','2',48),(6149,49,11,217,'10','2','3',48),(6150,49,11,217,'10','2','4',48),(6151,49,11,217,'7','2','5',48),(6152,49,11,217,'10','3','1',48),(6153,49,11,217,'10','3','2',48),(6154,49,11,217,'10','3','4',48),(6155,49,11,217,'10','3','3',48),(6156,49,11,217,'10','3','5',48),(6157,49,11,217,'3','3','6',48),(6158,49,11,217,'10','4','1',48),(6159,49,11,217,'10','4','2',48),(6160,49,11,217,'10','4','3',48),(6161,49,11,217,'10','4','4',48),(6162,49,11,217,'10','4','5',48),(6163,49,11,217,'4','4','6',48),(6164,49,11,217,'10','5','1',48),(6165,49,11,217,'10','5','2',48),(6166,49,11,217,'10','5','3',48),(6167,49,11,217,'10','5','4',48),(6168,49,11,217,'10','5','5',48),(6170,49,11,217,'10','6','3',48),(6171,49,11,217,'10','6','4',48),(6172,49,11,217,'10','6','5',48),(6173,49,11,217,'6','6','6',48),(6174,49,11,217,'10','6','1',48),(6175,49,11,217,'10','6','2',48),(6176,49,11,218,'10','1','1',48),(6177,49,11,218,'10','1','2',48),(6178,49,11,218,'10','1','3',48),(6179,49,11,218,'10','1','4',48),(6180,49,11,218,'10','1','5',48),(6181,49,11,218,'2','1','6',48),(6182,49,11,218,'10','2','1',48),(6183,49,11,218,'10','2','2',48),(6184,49,11,218,'10','2','3',48),(6185,49,11,218,'10','2','4',48),(6186,49,11,218,'5','2','5',48),(6187,49,11,218,'10','3','1',48),(6188,49,11,218,'10','3','2',48),(6189,49,11,218,'10','3','3',48),(6190,49,11,218,'10','3','4',48),(6191,49,11,218,'10','3','5',48),(6192,49,11,218,'3','3','6',48),(6193,49,11,218,'10','4','1',48),(6194,49,11,218,'10','4','2',48),(6195,49,11,218,'10','4','3',48),(6196,49,11,218,'10','4','4',48),(6197,49,11,218,'10','4','5',48),(6198,49,11,218,'7','4','6',48),(6199,49,11,218,'10','5','1',48),(6200,49,11,218,'10','5','2',48),(6201,49,11,218,'10','5','3',48),(6202,49,11,218,'10','5','4',48),(6203,49,11,218,'8','5','5',48),(6204,49,11,218,'10','6','1',48),(6205,49,11,218,'10','6','2',48),(6206,49,11,218,'10','6','3',48),(6207,49,11,218,'5','6','4',48),(6208,49,11,219,'10','1','1',48),(6209,49,11,219,'10','1','2',48),(6210,49,11,219,'10','1','3',48),(6211,49,11,219,'10','1','4',48),(6212,49,11,219,'10','1','5',48),(6213,49,11,219,'1','1','6',48),(6214,49,11,219,'10','2','1',48),(6215,49,11,219,'10','2','2',48),(6216,49,11,219,'10','2','3',48),(6217,49,11,219,'10','2','4',48),(6218,49,11,219,'10','2','5',48),(6219,49,11,219,'5','2','6',48),(6220,49,11,219,'10','3','1',48),(6221,49,11,219,'10','3','2',48),(6222,49,11,219,'10','3','3',48),(6223,49,11,219,'10','3','4',48),(6224,49,11,219,'9','3','5',48),(6225,49,11,219,'10','4','1',48),(6226,49,11,219,'10','4','2',48),(6227,49,11,219,'10','4','3',48),(6228,49,11,219,'10','4','4',48),(6229,49,11,219,'9','4','5',48),(6230,49,11,219,'10','5','1',48),(6231,49,11,219,'10','5','2',48),(6232,49,11,219,'10','5','3',48),(6233,49,11,219,'9','5','4',48),(6234,49,11,219,'10','6','1',48),(6235,49,11,219,'10','6','2',48),(6236,49,11,219,'10','6','3',48),(6237,49,11,219,'10','6','4',48),(6238,49,11,219,'7','6','5',48),(6239,49,11,220,'10','1','1',48),(6240,49,11,220,'10','1','2',48),(6241,49,11,220,'10','1','3',48),(6242,49,11,220,'10','1','4',48),(6243,49,11,220,'1','2','1',48),(6244,49,11,220,'10','2','2',48),(6245,49,11,220,'10','2','3',48),(6246,49,11,220,'10','2','4',48),(6247,49,11,220,'3','2','5',48),(6248,49,11,220,'10','3','1',48),(6249,49,11,220,'10','3','2',48),(6250,49,11,220,'10','3','3',48),(6251,49,11,220,'10','3','4',48),(6252,49,11,220,'10','3','5',48),(6253,49,11,220,'5','3','6',48),(6254,49,11,220,'10','4','1',48),(6255,49,11,220,'10','4','2',48),(6256,49,11,220,'10','4','3',48),(6257,49,11,220,'10','4','4',48),(6258,49,11,220,'8','4','5',48),(6259,49,11,220,'10','5','1',48),(6260,49,11,220,'10','5','2',48),(6261,49,11,220,'10','5','3',48),(6262,49,11,220,'10','5','4',48),(6263,49,11,220,'5','5','5',48),(6264,49,11,220,'10','6','1',48),(6265,49,11,220,'10','6','2',48),(6266,49,11,220,'10','6','3',48),(6267,49,11,220,'10','6','4',48),(6268,49,11,220,'10','6','5',48),(6269,49,11,221,'10','1','1',48),(6270,49,11,221,'10','1','2',48),(6271,49,11,221,'10','1','3',48),(6272,49,11,221,'10','1','4',48),(6273,49,11,221,'10','2','1',48),(6274,49,11,221,'10','2','2',48),(6275,49,11,221,'10','2','4',48),(6276,49,11,221,'4','2','5',48),(6277,49,11,221,'10','2','3',48),(6278,49,11,221,'10','3','1',48),(6279,49,11,221,'10','3','2',48),(6280,49,11,221,'10','3','3',48),(6281,49,11,221,'5','3','4',48),(6282,49,11,221,'10','4','1',48),(6283,49,11,221,'10','4','2',48),(6284,49,11,221,'10','4','3',48),(6285,49,11,221,'10','4','4',48),(6286,49,11,221,'5','4','5',48),(6287,49,11,221,'10','5','1',48),(6288,49,11,221,'10','5','2',48),(6289,49,11,221,'10','5','3',48),(6290,49,11,221,'2','5','4',48),(6291,49,11,221,'10','6','1',48),(6292,49,11,221,'10','6','2',48),(6293,49,11,221,'10','6','3',48),(6294,49,11,221,'10','6','4',48),(6295,49,11,221,'10','6','5',48),(6296,49,11,221,'3','6','6',48),(6297,49,11,222,'10','1','1',48),(6298,49,11,222,'10','1','2',48),(6299,49,11,222,'4','1','3',48),(6300,49,11,222,'10','2','1',48),(6301,49,11,222,'10','2','2',48),(6302,49,11,222,'10','2','3',48),(6303,49,11,222,'10','2','4',48),(6304,49,11,222,'2','2','5',48),(6305,49,11,222,'10','3','1',48),(6306,49,11,222,'10','3','2',48),(6307,49,11,222,'10','3','3',48),(6308,49,11,222,'10','3','4',48),(6309,49,11,222,'8','3','5',48),(6310,49,11,222,'10','4','1',48),(6311,49,11,222,'10','4','2',48),(6312,49,11,222,'10','4','3',48),(6313,49,11,222,'8','4','4',48),(6314,49,11,222,'10','5','1',48),(6315,49,11,222,'10','5','2',48),(6316,49,11,222,'10','5','3',48),(6317,49,11,222,'10','5','4',48),(6318,49,11,222,'10','5','5',48),(6319,49,11,222,'1','5','6',48),(6320,49,11,222,'10','6','1',48),(6321,49,11,222,'10','6','2',48),(6322,49,11,222,'10','6','3',48),(6323,49,11,222,'4','6','5',48),(6324,49,11,222,'10','6','4',48),(6326,49,11,224,'10','1','1',48),(6327,49,11,224,'10','2','1',48),(6328,49,11,224,'10','2','2',48),(6329,49,11,224,'10','2','3',48),(6330,49,11,224,'6','2','4',48),(6331,49,11,224,'10','3','1',48),(6332,49,11,224,'10','3','2',48),(6333,49,11,224,'10','3','3',48),(6334,49,11,224,'1','3','4',48),(6335,49,11,224,'10','4','1',48),(6336,49,11,224,'10','4','2',48),(6337,49,11,224,'6','4','3',48),(6338,49,11,224,'10','5','1',48),(6339,49,11,224,'10','5','2',48),(6340,49,11,224,'7','5','3',48),(6341,49,11,224,'10','6','1',48),(6342,49,11,224,'10','6','2',48),(6343,49,11,224,'10','6','3',48),(6344,49,11,224,'9','6','4',48),(6345,49,11,48,'10','1','2',48),(6346,49,11,48,'10','1','1',48),(6347,49,11,48,'10','1','3',48),(6348,49,11,48,'9','1','4',48),(6349,49,11,48,'10','2','1',48),(6350,49,11,48,'10','2','2',48),(6351,49,11,48,'7','2','4',48),(6352,49,11,48,'10','2','3',48),(6353,49,11,48,'10','3','1',48),(6354,49,11,48,'9','3','2',48),(6355,49,11,48,'10','4','1',48),(6356,49,11,48,'10','4','2',48),(6357,49,11,48,'10','4','3',48),(6358,49,11,48,'5','4','4',48),(6359,49,11,48,'10','5','1',48),(6360,49,11,48,'10','5','2',48),(6361,49,11,48,'2','5','3',48),(6362,49,11,48,'10','6','1',48),(6365,49,11,48,'8','6','2',48),(6366,49,11,39,'10','1','1',48),(6367,49,11,39,'10','1','2',48),(6368,49,11,39,'10','2','1',48),(6369,49,11,39,'10','2','2',48),(6370,49,11,39,'10','2','3',48),(6371,49,11,39,'3','2','4',48),(6372,49,11,39,'10','3','1',48),(6373,49,11,39,'10','3','2',48),(6374,49,11,39,'1','3','3',48),(6375,49,11,39,'10','4','1',48),(6376,49,11,39,'4','4','2',48),(6377,49,11,39,'10','5','2',48),(6378,49,11,39,'10','5','1',48),(6379,49,11,39,'10','6','1',48),(6380,49,11,39,'10','6','2',48),(6381,49,11,39,'7','6','3',48),(6382,49,11,227,'10','1','1',48),(6383,49,11,227,'10','1','2',48),(6384,49,11,227,'10','1','3',48),(6385,49,11,227,'4','1','4',48),(6386,49,11,227,'10','2','1',48),(6387,49,11,227,'10','2','2',48),(6388,49,11,227,'9','2','3',48),(6389,49,11,227,'10','3','1',48),(6390,49,11,227,'10','3','2',48),(6391,49,11,227,'10','3','3',48),(6392,49,11,227,'1','3','4',48),(6393,49,11,227,'10','4','1',48),(6394,49,11,227,'10','4','2',48),(6395,49,11,227,'10','4','3',48),(6396,49,11,227,'9','4','4',48),(6397,49,11,228,'10','4','1',48),(6398,49,11,228,'10','4','2',48),(6399,49,11,228,'2','4','3',48),(6400,49,11,228,'10','5','1',48),(6401,49,11,228,'10','5','2',48),(6402,49,11,228,'10','5','3',48),(6403,49,11,228,'4','5','4',48),(6404,49,11,228,'10','6','1',48),(6405,49,11,228,'10','6','2',48),(6406,49,11,228,'10','6','3',48),(6407,49,11,228,'10','6','4',48),(6408,49,11,228,'1','6','5',48),(6409,10,11,229,'10','1','1',49),(6410,10,11,229,'10','1','2',49),(6411,10,11,229,'10','1','3',49),(6412,10,11,229,'10','1','4',49),(6413,10,11,229,'10','1','5',49),(6414,10,11,229,'10','1','6',49),(6415,10,11,229,'10','1','7',49),(6416,10,11,229,'10','1','8',49),(6417,10,11,229,'5','1','9',49),(6418,10,11,229,'10','2','1',49),(6419,10,11,229,'10','2','2',49),(6420,10,11,229,'10','2','3',49),(6421,10,11,229,'10','2','4',49),(6422,10,11,229,'10','2','5',49),(6423,10,11,229,'10','2','6',49),(6424,10,11,229,'10','2','7',49),(6425,10,11,229,'10','2','8',49),(6426,10,11,229,'4','2','9',49),(6427,10,11,229,'10','3','2',49),(6428,10,11,229,'10','3','1',49),(6429,10,11,229,'10','3','3',49),(6430,10,11,229,'10','3','4',49),(6431,10,11,229,'10','3','5',49),(6432,10,11,229,'10','3','6',49),(6433,10,11,229,'10','3','7',49),(6434,10,11,229,'10','3','8',49),(6435,10,11,229,'5','3','9',49),(6436,10,11,229,'10','4','1',49),(6437,10,11,229,'10','4','2',49),(6438,10,11,229,'10','4','3',49),(6439,10,11,229,'10','4','4',49),(6440,10,11,229,'10','4','5',49),(6441,10,11,229,'10','4','6',49),(6442,10,11,229,'10','4','7',49),(6443,10,11,229,'10','4','8',49),(6444,10,11,229,'9','4','9',49),(6445,10,11,229,'10','5','1',49),(6446,10,11,229,'10','5','2',49),(6447,10,11,229,'10','5','3',49),(6448,10,11,229,'10','5','4',49),(6449,10,11,229,'10','5','5',49),(6450,10,11,229,'10','5','6',49),(6451,10,11,229,'10','5','7',49),(6452,10,11,229,'10','5','8',49),(6453,10,11,229,'7','5','9',49),(6454,10,11,229,'10','6','1',49),(6455,10,11,229,'10','6','3',49),(6456,10,11,229,'10','6','4',49),(6457,10,11,229,'10','6','6',49),(6458,10,11,229,'10','6','7',49),(6459,10,11,229,'10','6','8',49),(6460,10,11,229,'6','6','9',49),(6461,10,11,229,'10','6','2',49),(6462,10,11,229,'10','6','5',49),(6463,10,11,229,'10','7','1',49),(6464,10,11,229,'10','7','2',49),(6465,10,11,229,'10','7','3',49),(6466,10,11,229,'10','7','4',49),(6467,10,11,229,'10','7','5',49),(6468,10,11,229,'10','7','6',49),(6469,10,11,229,'10','7','7',49),(6470,10,11,229,'10','7','8',49),(6471,10,11,229,'5','7','9',49),(6472,10,11,230,'10','1','1',49),(6473,10,11,230,'10','1','2',49),(6474,10,11,230,'10','1','3',49),(6475,10,11,230,'10','1','4',49),(6476,10,11,230,'10','1','5',49),(6477,10,11,230,'10','1','6',49),(6478,10,11,230,'10','1','7',49),(6479,10,11,230,'10','1','8',49),(6480,10,11,230,'6','1','9',49),(6481,10,11,230,'10','2','1',49),(6482,10,11,230,'10','2','2',49),(6483,10,11,230,'10','2','3',49),(6484,10,11,230,'10','2','4',49),(6485,10,11,230,'10','2','5',49),(6486,10,11,230,'10','2','6',49),(6487,10,11,230,'10','2','7',49),(6488,10,11,230,'10','2','8',49),(6489,10,11,230,'6','2','9',49),(6490,10,11,230,'10','3','1',49),(6491,10,11,230,'10','3','2',49),(6492,10,11,230,'10','3','3',49),(6493,10,11,230,'10','3','4',49),(6494,10,11,230,'10','3','5',49),(6495,10,11,230,'10','3','6',49),(6496,10,11,230,'10','3','7',49),(6497,10,11,230,'10','3','8',49),(6498,10,11,230,'8','3','9',49),(6499,10,11,230,'10','4','1',49),(6500,10,11,230,'10','4','2',49),(6501,10,11,230,'10','4','3',49),(6502,10,11,230,'10','4','4',49),(6503,10,11,230,'10','4','5',49),(6504,10,11,230,'10','4','6',49),(6505,10,11,230,'10','4','7',49),(6506,10,11,230,'10','4','8',49),(6507,10,11,230,'4','4','9',49),(6508,10,11,230,'10','5','1',49),(6509,10,11,230,'10','5','2',49),(6510,10,11,230,'10','5','3',49),(6511,10,11,230,'10','5','4',49),(6512,10,11,230,'10','5','5',49),(6513,10,11,230,'10','5','6',49),(6514,10,11,230,'10','5','7',49),(6515,10,11,230,'10','5','8',49),(6516,10,11,230,'4','5','9',49),(6517,10,11,230,'10','6','1',49),(6518,10,11,230,'10','6','2',49),(6519,10,11,230,'10','6','3',49),(6520,10,11,230,'10','6','4',49),(6521,10,11,230,'10','6','5',49),(6522,10,11,230,'10','6','6',49),(6523,10,11,230,'10','6','7',49),(6524,10,11,230,'10','6','8',49),(6525,10,11,230,'1','6','9',49),(6526,10,11,230,'10','7','1',49),(6527,10,11,230,'10','7','2',49),(6528,10,11,230,'10','7','3',49),(6529,10,11,230,'10','7','4',49),(6530,10,11,230,'10','7','5',49),(6531,10,11,230,'10','7','6',49),(6532,10,11,230,'10','7','7',49),(6533,10,11,230,'10','7','8',49),(6534,10,11,230,'8','7','9',49),(6535,10,11,231,'10','1','1',49),(6536,10,11,231,'10','1','2',49),(6537,10,11,231,'10','1','3',49),(6538,10,11,231,'10','1','4',49),(6539,10,11,231,'10','1','5',49),(6540,10,11,231,'10','1','6',49),(6541,10,11,231,'10','1','7',49),(6542,10,11,231,'10','1','8',49),(6543,10,11,231,'2','1','9',49),(6544,10,11,231,'10','2','1',49),(6545,10,11,231,'10','2','2',49),(6546,10,11,231,'10','2','3',49),(6547,10,11,231,'10','2','4',49),(6548,10,11,231,'10','2','5',49),(6549,10,11,231,'10','2','6',49),(6550,10,11,231,'10','2','7',49),(6551,10,11,231,'10','2','8',49),(6552,10,11,231,'5','2','9',49),(6553,10,11,231,'10','3','1',49),(6554,10,11,231,'10','3','2',49),(6555,10,11,231,'10','3','4',49),(6556,10,11,231,'10','3','6',49),(6557,10,11,231,'10','3','7',49),(6558,10,11,231,'6','3','9',49),(6559,10,11,231,'10','3','3',49),(6560,10,11,231,'10','3','5',49),(6561,10,11,231,'10','3','8',49),(6562,10,11,231,'10','4','1',49),(6563,10,11,231,'10','4','2',49),(6564,10,11,231,'10','4','3',49),(6565,10,11,231,'10','4','4',49),(6566,10,11,231,'10','4','5',49),(6567,10,11,231,'10','4','6',49),(6568,10,11,231,'10','4','7',49),(6569,10,11,231,'10','4','8',49),(6570,10,11,231,'5','4','9',49),(6571,10,11,231,'10','5','1',49),(6572,10,11,231,'10','5','2',49),(6573,10,11,231,'10','5','3',49),(6574,10,11,231,'10','5','4',49),(6575,10,11,231,'10','5','5',49),(6576,10,11,231,'10','5','6',49),(6577,10,11,231,'10','5','7',49),(6578,10,11,231,'10','5','8',49),(6579,10,11,231,'7','5','9',49),(6580,10,11,231,'10','6','1',49),(6581,10,11,231,'10','6','2',49),(6582,10,11,231,'10','6','3',49),(6583,10,11,231,'10','6','4',49),(6584,10,11,231,'10','6','5',49),(6585,10,11,231,'10','6','6',49),(6586,10,11,231,'10','6','7',49),(6587,10,11,231,'10','6','8',49),(6588,10,11,231,'5','6','9',49),(6589,10,11,231,'10','7','1',49),(6590,10,11,231,'10','7','2',49),(6591,10,11,231,'10','7','3',49),(6592,10,11,231,'10','7','4',49),(6593,10,11,231,'10','7','5',49),(6594,10,11,231,'10','7','6',49),(6595,10,11,231,'10','7','7',49),(6596,10,11,231,'10','7','8',49),(6597,10,11,231,'6','7','9',49),(6598,10,11,232,'10','1','1',49),(6599,10,11,232,'10','1','2',49),(6600,10,11,232,'10','1','3',49),(6601,10,11,232,'10','1','4',49),(6602,10,11,232,'10','1','5',49),(6603,10,11,232,'10','1','6',49),(6604,10,11,232,'10','1','7',49),(6605,10,11,232,'10','1','8',49),(6606,10,11,232,'2','1','9',49),(6607,10,11,232,'10','2','1',49),(6608,10,11,232,'10','2','2',49),(6609,10,11,232,'10','2','3',49),(6610,10,11,232,'10','2','4',49),(6611,10,11,232,'10','2','5',49),(6612,10,11,232,'10','2','6',49),(6613,10,11,232,'10','2','7',49),(6614,10,11,232,'10','2','8',49),(6615,10,11,232,'7','2','9',49),(6616,10,11,232,'10','3','1',49),(6617,10,11,232,'10','3','2',49),(6618,10,11,232,'10','3','3',49),(6619,10,11,232,'10','3','4',49),(6620,10,11,232,'10','3','5',49),(6621,10,11,232,'10','3','6',49),(6622,10,11,232,'10','3','7',49),(6623,10,11,232,'10','3','8',49),(6624,10,11,232,'3','3','9',49),(6625,10,11,232,'10','4','1',49),(6626,10,11,232,'10','4','2',49),(6627,10,11,232,'10','4','3',49),(6628,10,11,232,'10','4','4',49),(6629,10,11,232,'10','4','5',49),(6630,10,11,232,'10','4','6',49),(6631,10,11,232,'10','4','7',49),(6632,10,11,232,'10','4','8',49),(6634,10,11,232,'4','4','9',49),(6635,10,11,232,'10','5','1',49),(6636,10,11,232,'10','5','2',49),(6637,10,11,232,'10','5','3',49),(6638,10,11,232,'10','5','4',49),(6639,10,11,232,'10','5','5',49),(6640,10,11,232,'10','5','6',49),(6641,10,11,232,'10','5','7',49),(6642,10,11,232,'10','5','8',49),(6643,10,11,232,'2','5','9',49),(6644,10,11,232,'10','6','1',49),(6645,10,11,232,'10','6','2',49),(6646,10,11,232,'10','6','3',49),(6647,10,11,232,'10','6','4',49),(6648,10,11,232,'10','6','5',49),(6649,10,11,232,'10','6','6',49),(6650,10,11,232,'10','6','7',49),(6651,10,11,232,'10','6','8',49),(6652,10,11,232,'6','6','9',49),(6653,10,11,232,'10','7','1',49),(6654,10,11,232,'10','7','2',49),(6655,10,11,232,'10','7','3',49),(6656,10,11,232,'10','7','4',49),(6657,10,11,232,'10','7','5',49),(6658,10,11,232,'10','7','6',49),(6659,10,11,232,'10','7','7',49),(6660,10,11,232,'10','7','8',49),(6662,10,11,232,'5','7','9',49),(6663,10,11,233,'10','1','1',49),(6664,10,11,233,'10','1','2',49),(6665,10,11,233,'10','1','3',49),(6666,10,11,233,'10','1','4',49),(6667,10,11,233,'10','1','5',49),(6668,10,11,233,'10','1','6',49),(6669,10,11,233,'10','1','7',49),(6670,10,11,233,'10','1','8',49),(6671,10,11,233,'7','1','9',49),(6672,10,11,233,'10','2','1',49),(6673,10,11,233,'10','2','2',49),(6674,10,11,233,'10','2','3',49),(6675,10,11,233,'10','2','4',49),(6676,10,11,233,'10','2','6',49),(6677,10,11,233,'10','2','7',49),(6678,10,11,233,'10','2','8',49),(6679,10,11,233,'1','2','9',49),(6680,10,11,233,'10','2','5',49),(6681,10,11,233,'10','3','1',49),(6682,10,11,233,'10','3','2',49),(6683,10,11,233,'10','3','3',49),(6684,10,11,233,'10','3','4',49),(6685,10,11,233,'10','3','5',49),(6686,10,11,233,'10','3','6',49),(6687,10,11,233,'10','3','7',49),(6688,10,11,233,'10','3','8',49),(6689,10,11,233,'3','3','9',49),(6690,10,11,233,'10','4','1',49),(6691,10,11,233,'10','4','2',49),(6692,10,11,233,'10','4','3',49),(6693,10,11,233,'10','4','4',49),(6694,10,11,233,'10','4','5',49),(6695,10,11,233,'10','4','6',49),(6696,10,11,233,'10','4','7',49),(6697,10,11,233,'10','4','8',49),(6698,10,11,233,'3','4','9',49),(6699,10,11,233,'10','5','1',49),(6700,10,11,233,'10','5','2',49),(6701,10,11,233,'10','5','3',49),(6702,10,11,233,'10','5','4',49),(6703,10,11,233,'10','5','5',49),(6704,10,11,233,'10','5','6',49),(6705,10,11,233,'10','5','7',49),(6706,10,11,233,'10','5','8',49),(6707,10,11,233,'5','5','9',49),(6708,10,11,233,'10','6','1',49),(6709,10,11,233,'10','6','2',49),(6710,10,11,233,'10','6','3',49),(6711,10,11,233,'10','6','4',49),(6712,10,11,233,'10','6','5',49),(6713,10,11,233,'10','6','6',49),(6714,10,11,233,'10','6','7',49),(6715,10,11,233,'10','6','8',49),(6716,10,11,233,'2','6','9',49),(6717,10,11,233,'10','7','1',49),(6718,10,11,233,'10','7','2',49),(6719,10,11,233,'10','7','3',49),(6720,10,11,233,'10','7','4',49),(6721,10,11,233,'10','7','5',49),(6722,10,11,233,'10','7','6',49),(6723,10,11,233,'10','7','7',49),(6724,10,11,233,'10','7','8',49),(6725,10,11,233,'7','7','9',49),(6726,10,11,234,'10','1','1',49),(6727,10,11,234,'10','1','2',49),(6728,10,11,234,'10','1','3',49),(6729,10,11,234,'10','1','4',49),(6730,10,11,234,'10','1','5',49),(6731,10,11,234,'10','1','6',49),(6732,10,11,234,'10','1','7',49),(6733,10,11,234,'10','1','8',49),(6734,10,11,234,'7','1','9',49),(6735,10,11,234,'10','2','1',49),(6736,10,11,234,'10','2','2',49),(6737,10,11,234,'10','2','3',49),(6738,10,11,234,'10','2','4',49),(6739,10,11,234,'10','2','5',49),(6740,10,11,234,'10','2','6',49),(6741,10,11,234,'10','2','7',49),(6742,10,11,234,'10','2','8',49),(6743,10,11,234,'2','2','9',49),(6744,10,11,234,'10','3','1',49),(6745,10,11,234,'10','3','2',49),(6746,10,11,234,'10','3','3',49),(6747,10,11,234,'10','3','4',49),(6748,10,11,234,'10','3','5',49),(6749,10,11,234,'10','3','6',49),(6750,10,11,234,'10','3','7',49),(6751,10,11,234,'10','3','8',49),(6752,10,11,234,'2','3','9',49),(6753,10,11,234,'10','4','1',49),(6754,10,11,234,'10','4','2',49),(6755,10,11,234,'10','4','3',49),(6756,10,11,234,'10','4','4',49),(6757,10,11,234,'10','4','5',49),(6758,10,11,234,'10','4','6',49),(6759,10,11,234,'10','4','7',49),(6760,10,11,234,'10','4','8',49),(6761,10,11,234,'3','4','9',49),(6762,10,11,234,'10','5','1',49),(6763,10,11,234,'10','5','2',49),(6764,10,11,234,'10','5','3',49),(6765,10,11,234,'10','5','4',49),(6766,10,11,234,'10','5','5',49),(6767,10,11,234,'10','5','6',49),(6768,10,11,234,'10','5','7',49),(6769,10,11,234,'10','5','8',49),(6770,10,11,234,'1','5','9',49),(6771,10,11,234,'10','6','1',49),(6772,10,11,234,'10','6','2',49),(6773,10,11,234,'10','6','3',49),(6774,10,11,234,'10','6','4',49),(6775,10,11,234,'10','6','5',49),(6776,10,11,234,'10','6','6',49),(6777,10,11,234,'10','6','7',49),(6778,10,11,234,'10','6','8',49),(6779,10,11,234,'4','6','9',49),(6780,10,11,234,'10','7','1',49),(6781,10,11,234,'10','7','2',49),(6782,10,11,234,'10','7','3',49),(6783,10,11,234,'10','7','4',49),(6784,10,11,234,'10','7','5',49),(6785,10,11,234,'10','7','6',49),(6786,10,11,234,'10','7','7',49),(6787,10,11,234,'10','7','8',49),(6788,10,11,234,'5','7','9',49),(6789,10,11,236,'10','1','1',49),(6790,10,11,236,'10','1','2',49),(6791,10,11,236,'10','1','3',49),(6792,10,11,236,'10','1','4',49),(6793,10,11,236,'10','1','5',49),(6794,10,11,236,'10','1','6',49),(6795,10,11,236,'10','1','7',49),(6796,10,11,236,'10','1','8',49),(6797,10,11,236,'3','1','9',49),(6798,10,11,236,'10','2','1',49),(6799,10,11,236,'10','2','2',49),(6800,10,11,236,'10','2','3',49),(6801,10,11,236,'10','2','4',49),(6802,10,11,236,'10','2','5',49),(6803,10,11,236,'10','2','6',49),(6804,10,11,236,'10','2','7',49),(6805,10,11,236,'10','2','8',49),(6806,10,11,236,'3','2','9',49),(6807,10,11,236,'10','3','1',49),(6808,10,11,236,'10','3','2',49),(6809,10,11,236,'10','3','3',49),(6810,10,11,236,'10','3','4',49),(6811,10,11,236,'10','3','5',49),(6812,10,11,236,'10','3','6',49),(6813,10,11,236,'10','3','7',49),(6814,10,11,236,'10','3','8',49),(6815,10,11,236,'4','3','9',49),(6816,10,11,236,'10','4','1',49),(6817,10,11,236,'10','4','2',49),(6818,10,11,236,'10','4','3',49),(6819,10,11,236,'10','4','4',49),(6820,10,11,236,'10','4','5',49),(6821,10,11,236,'10','4','6',49),(6822,10,11,236,'10','4','7',49),(6823,10,11,236,'10','4','8',49),(6824,10,11,236,'2','4','9',49),(6825,10,11,236,'10','5','1',49),(6826,10,11,236,'10','5','2',49),(6827,10,11,236,'10','5','3',49),(6828,10,11,236,'10','5','4',49),(6829,10,11,236,'10','5','5',49),(6830,10,11,236,'10','5','6',49),(6831,10,11,236,'10','5','7',49),(6832,10,11,236,'9','5','8',49),(6833,10,11,236,'M','5','9',49),(6834,10,11,236,'10','6','1',49),(6835,10,11,236,'10','6','2',49),(6836,10,11,236,'10','6','3',49),(6837,10,11,236,'10','6','4',49),(6838,10,11,236,'10','6','5',49),(6839,10,11,236,'10','6','6',49),(6840,10,11,236,'10','6','7',49),(6841,10,11,236,'9','6','8',49),(6842,10,11,236,'M','6','9',49),(6843,10,11,236,'10','7','1',49),(6844,10,11,236,'10','7','2',49),(6845,10,11,236,'10','7','3',49),(6846,10,11,236,'10','7','4',49),(6847,10,11,236,'10','7','5',49),(6848,10,11,236,'10','7','6',49),(6849,10,11,236,'10','7','7',49),(6850,10,11,236,'10','7','8',49),(6851,10,11,236,'6','7','9',49),(6852,10,11,235,'10','1','1',49),(6853,10,11,235,'10','1','2',49),(6854,10,11,235,'10','1','3',49),(6855,10,11,235,'10','1','4',49),(6856,10,11,235,'10','1','5',49),(6857,10,11,235,'10','1','7',49),(6858,10,11,235,'10','1','6',49),(6859,10,11,235,'1','1','8',49),(6860,10,11,235,'M','1','9',49),(6861,10,11,235,'10','2','1',49),(6862,10,11,235,'10','2','2',49),(6863,10,11,235,'10','2','3',49),(6864,10,11,235,'10','2','4',49),(6865,10,11,235,'10','2','5',49),(6866,10,11,235,'10','2','6',49),(6867,10,11,235,'10','2','7',49),(6868,10,11,235,'10','2','8',49),(6869,10,11,235,'1','2','9',49),(6870,10,11,235,'10','3','1',49),(6871,10,11,235,'10','3','2',49),(6872,10,11,235,'10','3','3',49),(6873,10,11,235,'10','3','4',49),(6874,10,11,235,'10','3','5',49),(6875,10,11,235,'10','3','6',49),(6876,10,11,235,'10','3','7',49),(6877,10,11,235,'10','3','8',49),(6878,10,11,235,'5','3','9',49),(6879,10,11,235,'10','4','1',49),(6880,10,11,235,'10','4','2',49),(6881,10,11,235,'10','4','3',49),(6882,10,11,235,'10','4','4',49),(6883,10,11,235,'10','4','5',49),(6884,10,11,235,'10','4','6',49),(6885,10,11,235,'10','4','7',49),(6886,10,11,235,'10','4','8',49),(6888,10,11,235,'4','4','9',49),(6889,10,11,235,'10','5','1',49),(6890,10,11,235,'10','5','2',49),(6891,10,11,235,'10','5','3',49),(6892,10,11,235,'7','5','9',49),(6893,10,11,235,'10','6','1',49),(6894,10,11,235,'4','6','9',49),(6895,10,11,235,'1','7','9',49),(6896,10,11,235,'10','5','4',49),(6897,10,11,235,'10','5','5',49),(6898,10,11,235,'10','5','6',49),(6899,10,11,235,'10','5','7',49),(6900,10,11,235,'10','5','8',49),(6901,10,11,235,'10','6','2',49),(6902,10,11,235,'10','6','3',49),(6903,10,11,235,'10','6','4',49),(6904,10,11,235,'10','6','5',49),(6905,10,11,235,'10','6','6',49),(6906,10,11,235,'10','6','7',49),(6907,10,11,235,'10','6','8',49),(6908,10,11,235,'10','7','1',49),(6909,10,11,235,'10','7','2',49),(6910,10,11,235,'10','7','3',49),(6911,10,11,235,'10','7','4',49),(6912,10,11,235,'10','7','5',49),(6913,10,11,235,'10','7','6',49),(6914,10,11,235,'10','7','7',49),(6915,10,11,235,'10','7','8',49),(6916,10,11,237,'2','1','9',49),(6918,10,11,237,'5','2','8',49),(6919,10,11,237,'M','2','9',49),(6920,10,11,237,'8','3','9',49),(6921,10,11,237,'3','4','9',49),(6922,10,11,237,'M','5','9',49),(6923,10,11,237,'M','6','9',49),(6924,10,11,237,'4','7','9',49),(6925,10,11,237,'10','1','1',49),(6926,10,11,237,'10','1','2',49),(6927,10,11,237,'10','1','3',49),(6928,10,11,237,'10','1','4',49),(6929,10,11,237,'10','1','5',49),(6930,10,11,237,'10','1','6',49),(6931,10,11,237,'10','1','7',49),(6932,10,11,237,'10','1','8',49),(6933,10,11,237,'10','2','1',49),(6934,10,11,237,'10','2','2',49),(6935,10,11,237,'10','2','3',49),(6936,10,11,237,'10','2','4',49),(6937,10,11,237,'10','2','5',49),(6938,10,11,237,'10','2','6',49),(6939,10,11,237,'10','2','7',49),(6940,10,11,237,'10','3','1',49),(6941,10,11,237,'10','3','2',49),(6942,10,11,237,'10','3','3',49),(6943,10,11,237,'10','3','4',49),(6944,10,11,237,'10','3','5',49),(6945,10,11,237,'10','3','6',49),(6946,10,11,237,'10','3','7',49),(6947,10,11,237,'10','3','8',49),(6948,10,11,237,'10','4','1',49),(6949,10,11,237,'10','4','2',49),(6950,10,11,237,'10','4','3',49),(6951,10,11,237,'10','4','4',49),(6952,10,11,237,'10','4','5',49),(6953,10,11,237,'10','4','6',49),(6954,10,11,237,'10','4','7',49),(6955,10,11,237,'10','4','8',49),(6956,10,11,237,'10','5','1',49),(6957,10,11,237,'10','5','2',49),(6958,10,11,237,'10','5','3',49),(6959,10,11,237,'10','5','4',49),(6960,10,11,237,'10','5','5',49),(6961,10,11,237,'10','5','6',49),(6962,10,11,237,'10','5','7',49),(6963,10,11,237,'10','5','8',49),(6964,10,11,237,'10','6','1',49),(6965,10,11,237,'10','6','2',49),(6966,10,11,237,'10','6','3',49),(6967,10,11,237,'10','6','4',49),(6968,10,11,237,'10','6','5',49),(6969,10,11,237,'10','6','6',49),(6970,10,11,237,'10','6','7',49),(6971,10,11,237,'10','6','8',49),(6972,10,11,237,'10','7','1',49),(6973,10,11,237,'10','7','2',49),(6974,10,11,237,'10','7','3',49),(6975,10,11,237,'10','7','4',49),(6976,10,11,237,'10','7','5',49),(6977,10,11,237,'10','7','6',49),(6978,10,11,237,'10','7','7',49),(6979,10,11,237,'10','7','8',49),(6980,10,11,238,'2','1','9',49),(6981,10,11,238,'5','2','9',49),(6982,10,11,238,'M','3','9',49),(6983,10,11,238,'M','4','9',49),(6984,10,11,238,'7','5','8',49),(6985,10,11,238,'M','5','9',49),(6986,10,11,238,'5','6','9',49),(6987,10,11,238,'M','7','9',49),(6988,10,11,238,'5','7','8',49),(6989,10,11,238,'10','1','1',49),(6990,10,11,238,'10','1','2',49),(6991,10,11,238,'10','1','3',49),(6992,10,11,238,'10','1','4',49),(6993,10,11,238,'10','1','5',49),(6994,10,11,238,'10','1','6',49),(6995,10,11,238,'10','1','7',49),(6996,10,11,238,'10','1','8',49),(6997,10,11,238,'10','2','1',49),(6998,10,11,238,'10','2','2',49),(6999,10,11,238,'10','2','3',49),(7000,10,11,238,'10','2','4',49),(7001,10,11,238,'10','2','5',49),(7002,10,11,238,'10','2','6',49),(7003,10,11,238,'10','2','7',49),(7004,10,11,238,'10','2','8',49),(7005,10,11,238,'10','3','1',49),(7006,10,11,238,'10','3','2',49),(7007,10,11,238,'10','3','3',49),(7008,10,11,238,'10','3','4',49),(7009,10,11,238,'10','3','5',49),(7010,10,11,238,'10','3','6',49),(7011,10,11,238,'10','3','7',49),(7012,10,11,238,'10','3','8',49),(7013,10,11,238,'10','4','1',49),(7014,10,11,238,'10','4','2',49),(7015,10,11,238,'10','4','3',49),(7016,10,11,238,'10','4','4',49),(7017,10,11,238,'10','4','5',49),(7018,10,11,238,'10','4','6',49),(7019,10,11,238,'10','4','7',49),(7020,10,11,238,'10','4','8',49),(7021,10,11,238,'10','5','1',49),(7022,10,11,238,'10','5','2',49),(7023,10,11,238,'10','5','3',49),(7024,10,11,238,'10','5','4',49),(7025,10,11,238,'10','5','5',49),(7026,10,11,238,'10','5','6',49),(7027,10,11,238,'10','5','7',49),(7028,10,11,238,'10','6','1',49),(7029,10,11,238,'10','6','2',49),(7030,10,11,238,'10','6','3',49),(7031,10,11,238,'10','6','4',49),(7032,10,11,238,'10','6','5',49),(7033,10,11,238,'10','6','6',49),(7034,10,11,238,'10','6','7',49),(7035,10,11,238,'10','6','8',49),(7036,10,11,238,'10','7','1',49),(7037,10,11,238,'10','7','2',49),(7038,10,11,238,'10','7','3',49),(7039,10,11,238,'10','7','4',49),(7040,10,11,238,'10','7','5',49),(7041,10,11,238,'10','7','6',49),(7042,10,11,238,'10','7','7',49),(7043,10,11,239,'2','1','9',49),(7044,10,11,239,'M','2','9',49),(7045,10,11,239,'M','3','9',49),(7046,10,11,239,'5','3','8',49),(7047,10,11,239,'5','4','9',49),(7048,10,11,239,'1','5','9',49),(7049,10,11,239,'9','6','8',49),(7050,10,11,239,'7','7','8',49),(7051,10,11,239,'M','6','9',49),(7052,10,11,239,'M','7','9',49),(7053,10,11,239,'10','1','1',49),(7054,10,11,239,'10','1','2',49),(7055,10,11,239,'10','1','3',49),(7056,10,11,239,'10','1','4',49),(7057,10,11,239,'10','1','5',49),(7058,10,11,239,'10','1','6',49),(7059,10,11,239,'10','1','7',49),(7060,10,11,239,'10','1','8',49),(7061,10,11,239,'10','2','1',49),(7062,10,11,239,'10','2','2',49),(7063,10,11,239,'10','2','3',49),(7064,10,11,239,'10','2','4',49),(7065,10,11,239,'10','2','5',49),(7066,10,11,239,'10','2','6',49),(7067,10,11,239,'10','2','7',49),(7068,10,11,239,'10','2','8',49),(7069,10,11,239,'10','3','1',49),(7070,10,11,239,'10','3','2',49),(7071,10,11,239,'10','3','3',49),(7072,10,11,239,'10','3','4',49),(7073,10,11,239,'10','3','5',49),(7074,10,11,239,'10','3','6',49),(7075,10,11,239,'10','3','7',49),(7076,10,11,239,'10','4','1',49),(7077,10,11,239,'10','4','2',49),(7078,10,11,239,'10','4','3',49),(7079,10,11,239,'10','4','4',49),(7080,10,11,239,'10','4','5',49),(7081,10,11,239,'10','4','6',49),(7082,10,11,239,'10','4','7',49),(7083,10,11,239,'10','4','8',49),(7084,10,11,239,'10','5','1',49),(7085,10,11,239,'10','5','2',49),(7086,10,11,239,'10','5','3',49),(7087,10,11,239,'10','5','4',49),(7088,10,11,239,'10','5','5',49),(7089,10,11,239,'10','5','6',49),(7090,10,11,239,'10','5','7',49),(7091,10,11,239,'10','5','8',49),(7092,10,11,239,'10','6','1',49),(7093,10,11,239,'10','6','2',49),(7094,10,11,239,'10','6','3',49),(7095,10,11,239,'10','6','4',49),(7096,10,11,239,'10','6','5',49),(7097,10,11,239,'10','6','6',49),(7098,10,11,239,'10','6','7',49),(7099,10,11,239,'10','7','1',49),(7100,10,11,239,'10','7','2',49),(7101,10,11,239,'10','7','3',49),(7102,10,11,239,'10','7','4',49),(7103,10,11,239,'10','7','5',49),(7104,10,11,239,'10','7','6',49),(7105,10,11,239,'10','7','7',49),(7108,10,11,240,'2','1','9',49),(7110,10,11,240,'M','2','9',49),(7111,10,11,240,'M','3','9',49),(7113,10,11,240,'2','4','9',49),(7114,10,11,240,'M','5','9',49),(7115,10,11,240,'6','2','8',49),(7116,10,11,240,'8','3','8',49),(7117,10,11,240,'9','5','8',49),(7118,10,11,240,'2','6','9',49),(7119,10,11,240,'9','7','8',49),(7120,10,11,240,'M','7','9',49),(7121,10,11,240,'10','1','1',49),(7122,10,11,240,'10','1','2',49),(7123,10,11,240,'10','1','3',49),(7124,10,11,240,'10','1','4',49),(7125,10,11,240,'10','1','5',49),(7126,10,11,240,'10','1','6',49),(7127,10,11,240,'10','1','7',49),(7128,10,11,240,'10','1','8',49),(7129,10,11,240,'10','2','1',49),(7130,10,11,240,'10','2','2',49),(7131,10,11,240,'10','2','3',49),(7132,10,11,240,'10','2','4',49),(7133,10,11,240,'10','2','5',49),(7134,10,11,240,'10','2','6',49),(7135,10,11,240,'10','2','7',49),(7136,10,11,240,'10','3','1',49),(7137,10,11,240,'10','3','2',49),(7138,10,11,240,'10','3','3',49),(7139,10,11,240,'10','3','4',49),(7140,10,11,240,'10','3','5',49),(7141,10,11,240,'10','3','6',49),(7142,10,11,240,'10','3','7',49),(7143,10,11,240,'10','4','1',49),(7144,10,11,240,'10','4','2',49),(7145,10,11,240,'10','4','3',49),(7146,10,11,240,'10','4','4',49),(7147,10,11,240,'10','4','5',49),(7148,10,11,240,'10','4','6',49),(7149,10,11,240,'10','4','7',49),(7150,10,11,240,'10','4','8',49),(7151,10,11,240,'10','5','1',49),(7152,10,11,240,'10','5','2',49),(7153,10,11,240,'10','5','3',49),(7154,10,11,240,'10','5','4',49),(7155,10,11,240,'10','5','5',49),(7156,10,11,240,'10','5','6',49),(7157,10,11,240,'10','5','7',49),(7158,10,11,240,'10','6','1',49),(7159,10,11,240,'10','6','2',49),(7160,10,11,240,'10','6','3',49),(7161,10,11,240,'10','6','4',49),(7162,10,11,240,'10','6','5',49),(7163,10,11,240,'10','6','6',49),(7164,10,11,240,'10','6','7',49),(7165,10,11,240,'10','6','8',49),(7166,10,11,240,'10','7','1',49),(7167,10,11,240,'10','7','2',49),(7168,10,11,240,'10','7','3',49),(7169,10,11,240,'10','7','4',49),(7170,10,11,240,'10','7','5',49),(7171,10,11,240,'10','7','6',49),(7172,10,11,240,'10','7','7',49),(7173,11,11,286,'10','1','1',50),(7176,11,11,286,'10','1','4',50),(7177,11,11,286,'10','1','5',50),(7178,11,11,286,'10','1','6',50),(7179,11,11,286,'10','1','7',50),(7180,11,11,286,'10','1','8',50),(7181,11,11,286,'4','1','9',50),(7182,11,11,286,'10','1','2',50),(7183,11,11,286,'10','1','3',50),(7184,11,11,286,'10','2','1',50),(7185,11,11,286,'10','2','2',50),(7186,11,11,286,'10','2','3',50),(7187,11,11,286,'10','2','4',50),(7188,11,11,286,'10','2','5',50),(7189,11,11,286,'10','2','6',50),(7190,11,11,286,'10','2','7',50),(7191,11,11,286,'10','2','8',50),(7192,11,11,286,'2','2','9',50),(7193,10,11,241,'10','1','1',49),(7194,10,11,241,'10','1','2',49),(7195,10,11,241,'10','1','3',49),(7196,10,11,241,'10','1','4',49),(7197,10,11,241,'10','1','5',49),(7198,10,11,241,'10','1','6',49),(7199,10,11,241,'10','1','7',49),(7200,11,11,286,'10','3','2',50),(7201,10,11,241,'10','1','8',49),(7202,11,11,286,'10','3','3',50),(7203,10,11,241,'3','1','9',49),(7204,11,11,286,'10','3','4',50),(7205,11,11,286,'10','3','5',50),(7206,11,11,286,'10','3','6',50),(7207,11,11,286,'10','3','7',50),(7208,11,11,286,'10','3','8',50),(7209,11,11,286,'4','3','9',50),(7210,11,11,286,'10','3','1',50),(7212,11,11,286,'10','4','1',50),(7213,10,11,241,'10','2','1',49),(7214,10,11,241,'10','2','2',49),(7215,11,11,286,'10','4','2',50),(7216,10,11,241,'10','2','3',49),(7217,10,11,241,'10','2','4',49),(7218,10,11,241,'10','2','5',49),(7219,10,11,241,'10','2','6',49),(7220,10,11,241,'10','2','7',49),(7221,10,11,241,'8','2','8',49),(7222,10,11,241,'10','3','1',49),(7223,10,11,241,'10','3','2',49),(7224,11,11,286,'10','4','3',50),(7225,10,11,241,'10','3','3',49),(7226,10,11,241,'10','3','4',49),(7227,11,11,286,'10','4','4',50),(7228,10,11,241,'10','3','5',49),(7229,10,11,241,'10','3','6',49),(7230,10,11,241,'10','3','7',49),(7232,10,11,241,'10','3','8',49),(7233,10,11,241,'2','3','9',49),(7234,11,11,286,'10','4','5',50),(7235,11,11,286,'10','4','6',50),(7236,11,11,286,'10','4','7',50),(7237,11,11,286,'10','4','8',50),(7238,10,11,241,'10','4','1',49),(7239,10,11,241,'10','4','2',49),(7240,10,11,241,'10','4','3',49),(7241,10,11,241,'10','4','4',49),(7242,10,11,241,'10','4','5',49),(7243,10,11,241,'10','4','6',49),(7244,10,11,241,'10','4','7',49),(7245,11,11,286,'5','4','9',50),(7246,10,11,241,'8','4','8',49),(7247,11,11,286,'10','5','1',50),(7248,10,11,241,'10','5','1',49),(7249,10,11,241,'10','5','2',49),(7250,10,11,241,'10','5','3',49),(7251,10,11,241,'10','5','4',49),(7252,10,11,241,'10','5','5',49),(7253,10,11,241,'10','5','6',49),(7254,11,11,286,'10','5','2',50),(7255,10,11,241,'10','5','7',49),(7256,11,11,286,'10','5','3',50),(7257,10,11,241,'7','5','8',49),(7258,11,11,286,'10','5','4',50),(7259,11,11,286,'10','5','5',50),(7260,11,11,286,'10','5','6',50),(7261,11,11,286,'10','5','7',50),(7262,10,11,241,'10','6','1',49),(7263,10,11,241,'10','6','2',49),(7264,10,11,241,'10','6','3',49),(7265,10,11,241,'10','6','4',49),(7266,10,11,241,'10','6','5',49),(7267,10,11,241,'10','6','6',49),(7268,10,11,241,'10','6','7',49),(7269,10,11,241,'8','6','8',49),(7270,10,11,241,'10','7','1',49),(7271,10,11,241,'10','7','2',49),(7272,10,11,241,'10','7','3',49),(7273,10,11,241,'10','7','4',49),(7274,10,11,241,'10','7','5',49),(7275,10,11,241,'10','7','6',49),(7276,10,11,241,'10','7','7',49),(7277,10,11,241,'8','7','8',49),(7278,11,11,286,'10','5','8',50),(7279,11,11,286,'5','5','9',50),(7280,11,11,286,'10','6','1',50),(7281,11,11,286,'10','6','2',50),(7282,11,11,286,'10','6','3',50),(7283,11,11,286,'10','6','4',50),(7284,11,11,286,'10','6','5',50),(7285,11,11,286,'10','6','6',50),(7286,11,11,286,'10','6','7',50),(7287,11,11,286,'10','6','8',50),(7290,11,11,286,'10','7','2',50),(7291,11,11,286,'10','7','3',50),(7292,11,11,286,'10','7','4',50),(7293,11,11,286,'10','7','5',50),(7294,11,11,286,'10','7','6',50),(7295,11,11,286,'10','7','7',50),(7296,11,11,286,'10','7','8',50),(7298,11,11,286,'10','7','1',50),(7299,11,11,286,'7','6','9',50),(7300,11,11,286,'6','7','9',50),(7301,11,11,287,'10','1','1',50),(7302,11,11,287,'10','1','2',50),(7303,11,11,287,'10','1','3',50),(7304,11,11,287,'10','1','4',50),(7305,11,11,287,'10','1','5',50),(7306,11,11,287,'10','1','6',50),(7307,11,11,287,'10','1','7',50),(7308,11,11,287,'10','1','8',50),(7310,11,11,287,'10','2','1',50),(7311,11,11,287,'10','2','2',50),(7312,11,11,287,'10','2','3',50),(7313,11,11,287,'10','2','4',50),(7314,11,11,287,'10','2','5',50),(7315,11,11,287,'10','2','6',50),(7316,11,11,287,'10','2','7',50),(7317,11,11,287,'10','2','8',50),(7319,11,11,287,'10','3','1',50),(7320,11,11,287,'10','3','2',50),(7321,11,11,287,'10','3','3',50),(7322,11,11,287,'10','3','4',50),(7323,11,11,287,'10','3','5',50),(7324,11,11,287,'10','3','6',50),(7325,11,11,287,'10','3','7',50),(7326,11,11,287,'10','3','8',50),(7328,11,11,287,'10','4','1',50),(7329,11,11,287,'10','4','2',50),(7330,11,11,287,'10','4','3',50),(7331,11,11,287,'10','4','4',50),(7332,11,11,287,'10','4','5',50),(7333,11,11,287,'10','4','6',50),(7334,11,11,287,'10','4','7',50),(7335,11,11,287,'10','4','8',50),(7337,11,11,287,'10','5','1',50),(7338,11,11,287,'10','5','2',50),(7339,11,11,287,'10','5','3',50),(7340,11,11,287,'10','5','4',50),(7341,11,11,287,'10','5','5',50),(7342,11,11,287,'10','5','6',50),(7343,11,11,287,'10','5','7',50),(7344,11,11,287,'10','5','8',50),(7346,11,11,287,'10','6','1',50),(7347,11,11,287,'10','6','2',50),(7348,11,11,287,'10','6','3',50),(7349,11,11,287,'10','6','4',50),(7350,11,11,287,'10','6','5',50),(7351,11,11,287,'10','6','6',50),(7352,11,11,287,'10','6','7',50),(7353,11,11,287,'10','6','8',50),(7355,11,11,287,'10','7','1',50),(7356,11,11,287,'10','7','2',50),(7357,11,11,287,'10','7','3',50),(7358,11,11,287,'10','7','4',50),(7359,11,11,287,'10','7','5',50),(7360,11,11,287,'10','7','6',50),(7361,11,11,287,'10','7','7',50),(7362,11,11,287,'10','7','8',50),(7363,11,11,287,'3','1','9',50),(7364,11,11,287,'5','2','9',50),(7365,11,11,287,'2','3','9',50),(7366,11,11,287,'6','4','9',50),(7367,11,11,287,'6','5','9',50),(7369,11,11,287,'3','6','9',50),(7370,11,11,287,'4','7','9',50),(7371,11,11,288,'10','1','1',50),(7372,11,11,288,'10','1','2',50),(7373,11,11,288,'10','1','3',50),(7374,11,11,288,'10','1','4',50),(7375,11,11,288,'10','1','5',50),(7376,11,11,288,'10','1','6',50),(7377,11,11,288,'10','1','7',50),(7378,11,11,288,'10','1','8',50),(7380,11,11,288,'10','2','1',50),(7381,11,11,288,'10','2','2',50),(7382,11,11,288,'10','2','3',50),(7383,11,11,288,'10','2','4',50),(7384,11,11,288,'10','2','5',50),(7385,11,11,288,'10','2','6',50),(7386,11,11,288,'10','2','7',50),(7387,11,11,288,'10','2','8',50),(7388,11,11,288,'1','2','9',50),(7389,11,11,288,'10','3','1',50),(7390,11,11,288,'10','3','2',50),(7391,11,11,288,'10','3','3',50),(7392,11,11,288,'10','3','4',50),(7393,11,11,288,'10','3','5',50),(7394,11,11,288,'10','3','6',50),(7395,11,11,288,'10','3','7',50),(7396,11,11,288,'10','3','8',50),(7397,11,11,288,'1','3','9',50),(7398,11,11,288,'10','4','1',50),(7399,11,11,288,'10','4','2',50),(7400,11,11,288,'10','4','3',50),(7401,11,11,288,'10','4','4',50),(7402,11,11,288,'10','4','5',50),(7403,11,11,288,'10','4','6',50),(7404,11,11,288,'10','4','7',50),(7405,11,11,288,'10','4','8',50),(7407,11,11,288,'10','5','1',50),(7408,11,11,288,'10','5','2',50),(7409,11,11,288,'10','5','3',50),(7410,11,11,288,'10','5','4',50),(7411,11,11,288,'10','5','5',50),(7412,11,11,288,'10','5','6',50),(7413,11,11,288,'10','5','7',50),(7414,11,11,288,'10','5','8',50),(7416,11,11,288,'10','6','1',50),(7417,11,11,288,'10','6','2',50),(7418,11,11,288,'10','6','3',50),(7419,11,11,288,'10','6','4',50),(7420,11,11,288,'10','6','5',50),(7421,11,11,288,'10','6','6',50),(7422,11,11,288,'10','6','7',50),(7423,11,11,288,'10','6','8',50),(7425,11,11,288,'10','7','1',50),(7426,11,11,288,'10','7','2',50),(7427,11,11,288,'10','7','3',50),(7428,11,11,288,'10','7','4',50),(7429,11,11,288,'10','7','5',50),(7430,11,11,288,'10','7','6',50),(7431,11,11,288,'10','7','7',50),(7432,11,11,288,'10','7','8',50),(7434,11,11,288,'3','1','9',50),(7435,11,11,288,'4','4','9',50),(7436,11,11,288,'5','5','9',50),(7437,11,11,288,'5','6','9',50),(7438,11,11,288,'3','7','9',50),(7439,11,11,289,'m','1','1',50),(7440,11,11,289,'10','1','2',50),(7441,11,11,289,'10','1','3',50),(7442,11,11,289,'10','1','4',50),(7443,11,11,289,'10','1','5',50),(7444,11,11,289,'10','1','6',50),(7445,11,11,289,'10','1','7',50),(7446,11,11,289,'10','1','8',50),(7447,11,11,289,'10','1','9',50),(7448,11,11,289,'10','2','1',50),(7449,11,11,289,'10','2','2',50),(7450,11,11,289,'10','2','3',50),(7451,11,11,289,'10','2','4',50),(7452,11,11,289,'10','2','5',50),(7453,11,11,289,'10','2','6',50),(7454,11,11,289,'10','2','7',50),(7455,11,11,289,'10','2','8',50),(7457,11,11,289,'10','3','1',50),(7458,11,11,289,'10','3','2',50),(7459,11,11,289,'10','3','3',50),(7460,11,11,289,'10','3','4',50),(7461,11,11,289,'10','3','5',50),(7462,11,11,289,'10','3','6',50),(7463,11,11,289,'10','3','7',50),(7464,11,11,289,'10','3','8',50),(7466,11,11,289,'10','4','1',50),(7467,11,11,289,'10','4','2',50),(7468,11,11,289,'10','4','3',50),(7469,11,11,289,'10','4','4',50),(7470,11,11,289,'10','4','5',50),(7471,11,11,289,'10','4','6',50),(7472,11,11,289,'10','4','7',50),(7473,11,11,289,'10','4','8',50),(7475,11,11,289,'10','5','1',50),(7476,11,11,289,'10','5','2',50),(7477,11,11,289,'10','5','3',50),(7478,11,11,289,'10','5','4',50),(7479,11,11,289,'10','5','5',50),(7480,11,11,289,'10','5','6',50),(7481,11,11,289,'10','5','7',50),(7482,11,11,289,'10','5','8',50),(7484,11,11,289,'10','6','1',50),(7485,11,11,289,'10','6','2',50),(7486,11,11,289,'10','6','3',50),(7487,11,11,289,'10','6','4',50),(7488,11,11,289,'10','6','5',50),(7489,11,11,289,'10','6','6',50),(7490,11,11,289,'10','6','7',50),(7491,11,11,289,'10','6','8',50),(7493,11,11,289,'10','7','1',50),(7494,11,11,289,'10','7','2',50),(7495,11,11,289,'10','7','3',50),(7496,11,11,289,'10','7','4',50),(7497,11,11,289,'10','7','5',50),(7498,11,11,289,'10','7','6',50),(7499,11,11,289,'10','7','7',50),(7500,11,11,289,'10','7','8',50),(7505,11,11,289,'1','2','9',50),(7506,11,11,289,'5','3','9',50),(7507,11,11,289,'5','4','9',50),(7508,11,11,289,'5','5','9',50),(7509,11,11,289,'1','6','9',50),(7510,11,11,289,'2','7','9',50),(7512,11,11,290,'10','1','1',50),(7513,11,11,290,'10','1','2',50),(7514,11,11,290,'10','1','3',50),(7515,11,11,290,'10','1','4',50),(7516,11,11,290,'10','1','5',50),(7517,11,11,290,'10','1','6',50),(7518,11,11,290,'10','1','7',50),(7519,11,11,290,'10','1','8',50),(7521,11,11,290,'10','2','1',50),(7522,11,11,290,'10','2','2',50),(7523,11,11,290,'10','2','3',50),(7524,11,11,290,'10','2','4',50),(7525,11,11,290,'10','2','5',50),(7526,11,11,290,'10','2','6',50),(7527,11,11,290,'10','2','7',50),(7528,11,11,290,'10','2','8',50),(7530,11,11,290,'10','3','1',50),(7531,11,11,290,'10','3','2',50),(7532,11,11,290,'10','3','3',50),(7533,11,11,290,'10','3','4',50),(7534,11,11,290,'10','3','5',50),(7535,11,11,290,'10','3','6',50),(7536,11,11,290,'10','3','7',50),(7537,11,11,290,'10','3','8',50),(7539,11,11,290,'10','4','1',50),(7540,11,11,290,'10','4','2',50),(7541,11,11,290,'10','4','3',50),(7542,11,11,290,'10','4','4',50),(7543,11,11,290,'10','4','5',50),(7544,11,11,290,'10','4','6',50),(7545,11,11,290,'10','4','7',50),(7546,11,11,290,'10','4','8',50),(7548,11,11,290,'10','5','1',50),(7549,11,11,290,'10','5','2',50),(7550,11,11,290,'10','5','3',50),(7551,11,11,290,'10','5','4',50),(7552,11,11,290,'10','5','5',50),(7553,11,11,290,'10','5','6',50),(7554,11,11,290,'10','5','7',50),(7555,11,11,290,'10','5','8',50),(7556,11,11,290,'1','5','9',50),(7559,11,11,290,'10','6','3',50),(7560,11,11,290,'10','6','4',50),(7561,11,11,290,'10','6','5',50),(7562,11,11,290,'10','6','6',50),(7563,11,11,290,'10','6','7',50),(7564,11,11,290,'10','6','8',50),(7565,11,11,290,'10','6','9',50),(7566,11,11,290,'10','7','1',50),(7567,11,11,290,'10','7','2',50),(7568,11,11,290,'10','7','3',50),(7569,11,11,290,'10','7','4',50),(7570,11,11,290,'10','7','5',50),(7571,11,11,290,'10','7','6',50),(7572,11,11,290,'10','7','7',50),(7573,11,11,290,'10','7','8',50),(7575,11,11,290,'4','1','9',50),(7576,11,11,290,'2','2','9',50),(7577,11,11,290,'4','3','9',50),(7578,11,11,290,'7','4','9',50),(7579,11,11,290,'m','6','1',50),(7580,11,11,290,'3','6','2',50),(7581,11,11,290,'2','7','9',50),(7582,11,11,293,'10','1','1',50),(7583,11,11,293,'10','1','2',50),(7584,11,11,293,'10','1','3',50),(7585,11,11,293,'10','1','4',50),(7586,11,11,293,'10','1','5',50),(7587,11,11,293,'10','1','6',50),(7588,11,11,293,'10','1','7',50),(7589,11,11,293,'10','1','8',50),(7591,11,11,293,'10','2','1',50),(7592,11,11,293,'10','2','2',50),(7593,11,11,293,'10','2','3',50),(7594,11,11,293,'10','2','4',50),(7595,11,11,293,'10','2','5',50),(7596,11,11,293,'10','2','6',50),(7597,11,11,293,'10','2','7',50),(7598,11,11,293,'9','2','8',50),(7602,11,11,293,'10','3','3',50),(7603,11,11,293,'10','3','4',50),(7604,11,11,293,'10','3','5',50),(7605,11,11,293,'10','3','6',50),(7606,11,11,293,'10','3','7',50),(7608,11,11,293,'5','3','9',50),(7609,11,11,293,'10','4','1',50),(7610,11,11,293,'10','4','2',50),(7611,11,11,293,'10','4','3',50),(7612,11,11,293,'10','4','4',50),(7613,11,11,293,'10','4','5',50),(7614,11,11,293,'10','4','6',50),(7615,11,11,293,'10','4','7',50),(7616,11,11,293,'8','4','8',50),(7620,11,11,293,'10','5','3',50),(7621,11,11,293,'10','5','4',50),(7622,11,11,293,'10','5','5',50),(7623,11,11,293,'10','5','6',50),(7624,11,11,293,'10','5','7',50),(7625,11,11,293,'10','5','8',50),(7627,11,11,293,'10','6','1',50),(7628,11,11,293,'10','6','2',50),(7629,11,11,293,'10','6','3',50),(7630,11,11,293,'10','6','4',50),(7631,11,11,293,'10','6','5',50),(7632,11,11,293,'10','6','6',50),(7633,11,11,293,'10','6','7',50),(7634,11,11,293,'2','6','8',50),(7636,11,11,293,'10','7','1',50),(7637,11,11,293,'10','7','2',50),(7638,11,11,293,'10','7','3',50),(7639,11,11,293,'10','7','4',50),(7640,11,11,293,'10','7','5',50),(7641,11,11,293,'10','7','6',50),(7642,11,11,293,'10','7','7',50),(7643,11,11,293,'10','7','8',50),(7645,11,11,293,'7','1','9',50),(7646,11,11,293,'M','2','9',50),(7649,11,11,293,'3','7','9',50),(7650,11,11,292,'10','1','1',50),(7651,11,11,292,'10','1','2',50),(7652,11,11,292,'10','1','3',50),(7653,11,11,292,'10','1','4',50),(7654,11,11,292,'10','1','5',50),(7655,11,11,292,'10','1','6',50),(7656,11,11,292,'10','1','7',50),(7657,11,11,292,'10','1','8',50),(7660,11,11,292,'10','2','2',50),(7661,11,11,292,'10','2','3',50),(7662,11,11,292,'10','2','4',50),(7663,11,11,292,'10','2','5',50),(7664,11,11,292,'10','2','6',50),(7665,11,11,292,'10','2','7',50),(7666,11,11,292,'10','2','8',50),(7667,11,11,292,'10','2','9',50),(7668,11,11,292,'10','3','1',50),(7669,11,11,292,'10','3','2',50),(7670,11,11,292,'10','3','3',50),(7671,11,11,292,'10','3','4',50),(7672,11,11,292,'10','3','5',50),(7673,11,11,292,'10','3','6',50),(7674,11,11,292,'10','3','7',50),(7675,11,11,292,'10','3','8',50),(7676,11,11,292,'4','3','9',50),(7677,11,11,292,'m','4','1',50),(7678,11,11,292,'7','4','2',50),(7679,11,11,292,'10','4','3',50),(7680,11,11,292,'10','4','4',50),(7681,11,11,292,'10','4','5',50),(7682,11,11,292,'10','4','6',50),(7683,11,11,292,'10','4','7',50),(7684,11,11,292,'10','4','8',50),(7685,11,11,292,'10','4','9',50),(7686,11,11,292,'m','5','1',50),(7687,11,11,292,'9','5','2',50),(7688,11,11,292,'10','5','3',50),(7689,11,11,292,'10','5','4',50),(7690,11,11,292,'10','5','5',50),(7691,11,11,292,'10','5','6',50),(7692,11,11,292,'10','5','7',50),(7693,11,11,292,'10','5','8',50),(7694,11,11,292,'10','5','9',50),(7695,11,11,292,'m','6','1',50),(7696,11,11,292,'10','6','2',50),(7697,11,11,292,'10','6','3',50),(7698,11,11,292,'10','6','4',50),(7699,11,11,292,'10','6','5',50),(7700,11,11,292,'10','6','6',50),(7701,11,11,292,'10','6','7',50),(7702,11,11,292,'10','6','8',50),(7703,11,11,292,'10','6','9',50),(7704,11,11,292,'10','7','1',50),(7705,11,11,292,'10','7','2',50),(7706,11,11,292,'10','7','3',50),(7707,11,11,292,'10','7','4',50),(7708,11,11,292,'10','7','5',50),(7709,11,11,292,'10','7','6',50),(7710,11,11,292,'10','7','7',50),(7711,11,11,292,'10','7','8',50),(7718,11,11,292,'6','1','9',50),(7719,11,11,292,'4','7','9',50),(7720,10,11,242,'10','1','2',49),(7721,10,11,242,'10','1','1',49),(7722,10,11,242,'10','1','3',49),(7723,10,11,242,'10','1','4',49),(7724,10,11,242,'10','1','5',49),(7725,10,11,242,'10','1','6',49),(7726,10,11,242,'10','1','7',49),(7727,10,11,242,'9','1','8',49),(7728,10,11,242,'10','2','1',49),(7729,10,11,242,'10','2','2',49),(7730,10,11,242,'10','2','3',49),(7731,10,11,242,'10','2','4',49),(7732,10,11,242,'10','2','5',49),(7733,10,11,242,'10','2','6',49),(7734,10,11,242,'10','2','7',49),(7735,10,11,242,'10','2','8',49),(7736,10,11,242,'2','2','9',49),(7737,10,11,242,'10','3','2',49),(7738,10,11,242,'10','3','1',49),(7739,10,11,242,'10','3','3',49),(7740,10,11,242,'10','3','4',49),(7741,10,11,242,'10','3','5',49),(7742,10,11,242,'10','3','6',49),(7743,10,11,242,'10','3','7',49),(7744,10,11,242,'7','3','8',49),(7745,10,11,242,'10','4','1',49),(7746,10,11,242,'10','4','2',49),(7747,10,11,242,'10','4','3',49),(7748,10,11,242,'10','4','4',49),(7749,10,11,242,'10','4','5',49),(7750,10,11,242,'10','4','6',49),(7751,10,11,242,'10','4','7',49),(7752,10,11,242,'7','4','8',49),(7753,10,11,242,'10','5','1',49),(7754,10,11,242,'10','5','2',49),(7755,10,11,242,'10','5','3',49),(7756,10,11,242,'10','5','4',49),(7757,10,11,242,'10','5','5',49),(7758,10,11,242,'10','5','6',49),(7759,10,11,242,'10','5','7',49),(7760,10,11,242,'3','5','8',49),(7761,10,11,242,'10','6','2',49),(7762,10,11,242,'10','6','1',49),(7763,10,11,242,'10','6','3',49),(7764,10,11,242,'10','6','4',49),(7765,10,11,242,'10','6','5',49),(7766,10,11,242,'10','6','6',49),(7767,10,11,242,'10','6','7',49),(7768,10,11,242,'10','6','8',49),(7769,10,11,242,'1','6','9',49),(7770,10,11,242,'10','7','1',49),(7771,10,11,242,'10','7','2',49),(7772,10,11,242,'10','7','3',49),(7773,10,11,242,'10','7','4',49),(7774,10,11,242,'10','7','5',49),(7775,10,11,242,'10','7','6',49),(7776,10,11,242,'10','7','7',49),(7777,10,11,242,'10','7','8',49),(7778,10,11,242,'1','7','9',49),(7779,10,11,243,'10','1','1',49),(7780,10,11,243,'10','1','2',49),(7781,10,11,243,'10','1','3',49),(7782,10,11,243,'10','1','4',49),(7783,10,11,243,'10','1','5',49),(7784,10,11,243,'10','1','6',49),(7785,10,11,243,'10','1','7',49),(7786,10,11,243,'8','1','8',49),(7787,10,11,243,'10','2','1',49),(7788,10,11,243,'10','2','2',49),(7789,10,11,243,'10','2','3',49),(7790,10,11,243,'10','2','4',49),(7791,10,11,243,'10','2','5',49),(7792,10,11,243,'10','2','6',49),(7793,10,11,243,'10','2','7',49),(7794,10,11,243,'6','2','8',49),(7795,10,11,243,'10','3','1',49),(7796,10,11,243,'10','3','2',49),(7797,10,11,243,'10','3','3',49),(7798,10,11,243,'10','3','4',49),(7799,10,11,243,'10','3','5',49),(7800,10,11,243,'10','3','6',49),(7801,10,11,243,'10','3','7',49),(7802,10,11,243,'6','3','8',49),(7803,10,11,243,'10','4','1',49),(7804,10,11,243,'10','4','2',49),(7805,10,11,243,'10','4','3',49),(7806,10,11,243,'10','4','4',49),(7807,10,11,243,'10','4','5',49),(7808,10,11,243,'10','4','6',49),(7809,10,11,243,'10','4','7',49),(7810,10,11,243,'7','4','8',49),(7811,10,11,243,'10','5','1',49),(7812,10,11,243,'10','5','2',49),(7813,10,11,243,'10','5','3',49),(7814,10,11,243,'10','5','4',49),(7815,10,11,243,'10','5','5',49),(7816,10,11,243,'10','5','6',49),(7817,10,11,243,'10','5','8',49),(7818,10,11,243,'10','5','7',49),(7819,10,11,243,'10','6','1',49),(7820,10,11,243,'10','6','2',49),(7821,10,11,243,'10','6','3',49),(7822,10,11,243,'10','6','4',49),(7823,10,11,243,'10','6','5',49),(7824,10,11,243,'10','6','6',49),(7825,10,11,243,'10','6','7',49),(7827,10,11,243,'7','6','8',49),(7828,10,11,243,'10','7','1',49),(7829,10,11,243,'10','7','2',49),(7830,10,11,243,'10','7','3',49),(7831,10,11,243,'10','7','4',49),(7832,10,11,243,'10','7','5',49),(7833,10,11,243,'10','7','6',49),(7834,10,11,243,'10','7','7',49),(7835,10,11,243,'10','7','8',49),(7836,10,11,244,'10','1','1',49),(7837,10,11,244,'10','1','2',49),(7838,10,11,244,'10','1','3',49),(7839,10,11,244,'10','1','4',49),(7840,10,11,244,'10','1','5',49),(7841,10,11,244,'10','1','6',49),(7842,10,11,244,'10','1','7',49),(7843,10,11,244,'8','1','8',49),(7844,10,11,244,'10','2','1',49),(7845,10,11,244,'10','2','2',49),(7846,10,11,244,'10','2','3',49),(7847,10,11,244,'10','2','4',49),(7848,10,11,244,'10','2','5',49),(7849,10,11,244,'10','2','6',49),(7850,10,11,244,'10','2','7',49),(7851,10,11,244,'3','2','8',49),(7852,10,11,244,'10','3','1',49),(7853,10,11,244,'10','3','2',49),(7854,10,11,244,'10','3','3',49),(7855,10,11,244,'10','3','4',49),(7856,10,11,244,'10','3','5',49),(7857,10,11,244,'10','3','6',49),(7858,10,11,244,'10','3','7',49),(7859,10,11,244,'8','3','8',49),(7860,10,11,244,'10','4','1',49),(7861,10,11,244,'10','4','2',49),(7862,10,11,244,'10','4','3',49),(7863,10,11,244,'10','4','4',49),(7864,10,11,244,'10','4','5',49),(7865,10,11,244,'10','4','6',49),(7866,10,11,244,'10','4','7',49),(7867,10,11,244,'4','4','8',49),(7868,10,11,244,'10','5','2',49),(7869,10,11,244,'10','5','3',49),(7870,10,11,244,'10','5','4',49),(7871,10,11,244,'10','5','5',49),(7872,10,11,244,'10','5','6',49),(7873,10,11,244,'10','5','7',49),(7874,10,11,244,'10','5','8',49),(7875,10,11,244,'10','6','1',49),(7876,10,11,244,'10','6','2',49),(7877,10,11,244,'10','6','3',49),(7878,10,11,244,'10','6','4',49),(7879,10,11,244,'10','6','5',49),(7880,10,11,244,'10','6','6',49),(7881,10,11,244,'10','6','7',49),(7882,10,11,244,'8','6','8',49),(7883,10,11,244,'10','7','1',49),(7884,10,11,244,'10','7','2',49),(7885,10,11,244,'10','7','3',49),(7886,10,11,244,'10','7','4',49),(7887,10,11,244,'10','7','6',49),(7888,10,11,244,'6','7','8',49),(7889,10,11,244,'10','7','7',49),(7890,10,11,244,'10','7','5',49),(7891,10,11,245,'10','1','2',49),(7892,10,11,245,'10','1','1',49),(7893,10,11,245,'10','1','3',49),(7894,10,11,245,'10','1','4',49),(7895,10,11,245,'10','1','5',49),(7896,10,11,245,'10','1','6',49),(7897,10,11,245,'10','1','7',49),(7898,10,11,245,'3','1','8',49),(7899,10,11,245,'10','2','1',49),(7900,10,11,245,'10','2','2',49),(7901,10,11,245,'10','2','3',49),(7902,10,11,245,'10','2','4',49),(7903,10,11,245,'10','2','6',49),(7904,10,11,245,'10','2','7',49),(7905,10,11,245,'4','2','8',49),(7906,10,11,245,'10','2','5',49),(7907,10,11,245,'10','3','1',49),(7908,10,11,245,'10','3','2',49),(7909,10,11,245,'10','3','3',49),(7910,10,11,245,'10','3','4',49),(7911,10,11,245,'10','3','5',49),(7912,10,11,245,'10','3','6',49),(7913,10,11,245,'10','3','7',49),(7914,10,11,245,'1','3','8',49),(7915,10,11,245,'10','4','1',49),(7916,10,11,245,'10','4','2',49),(7917,10,11,245,'10','4','3',49),(7918,10,11,245,'10','4','4',49),(7919,10,11,245,'10','4','5',49),(7920,10,11,245,'10','4','6',49),(7921,10,11,245,'10','4','7',49),(7922,10,11,245,'10','4','8',49),(7923,10,11,245,'4','4','9',49),(7924,10,11,245,'10','5','1',49),(7925,10,11,245,'10','5','2',49),(7926,10,11,245,'10','5','3',49),(7927,10,11,245,'10','5','4',49),(7929,10,11,245,'10','5','6',49),(7930,10,11,245,'10','5','7',49),(7931,10,11,245,'7','5','8',49),(7932,10,11,245,'10','5','5',49),(7933,10,11,245,'10','6','1',49),(7934,10,11,245,'10','6','2',49),(7935,10,11,245,'10','6','3',49),(7936,10,11,245,'10','6','4',49),(7937,10,11,245,'10','6','6',49),(7938,10,11,245,'10','6','7',49),(7939,10,11,245,'8','6','8',49),(7940,10,11,245,'10','6','5',49),(7941,10,11,245,'10','7','1',49),(7942,10,11,245,'10','7','2',49),(7943,10,11,245,'10','7','3',49),(7944,10,11,245,'10','7','4',49),(7945,10,11,245,'10','7','5',49),(7946,10,11,245,'10','7','6',49),(7947,10,11,245,'10','7','7',49),(7948,10,11,245,'5','7','8',49),(7949,10,11,246,'10','1','2',49),(7950,10,11,246,'10','1','1',49),(7951,10,11,246,'10','1','3',49),(7952,10,11,246,'10','1','4',49),(7953,10,11,246,'10','1','5',49),(7954,10,11,246,'10','1','6',49),(7955,10,11,246,'10','1','7',49),(7956,10,11,246,'4','1','8',49),(7957,10,11,246,'10','2','1',49),(7958,10,11,246,'10','2','2',49),(7959,10,11,246,'10','2','3',49),(7960,10,11,246,'10','2','4',49),(7961,10,11,246,'10','2','5',49),(7962,10,11,246,'10','2','6',49),(7963,10,11,246,'10','2','7',49),(7965,10,11,246,'4','2','8',49),(7966,10,11,246,'10','3','1',49),(7967,10,11,246,'10','3','2',49),(7968,10,11,246,'10','3','3',49),(7969,10,11,246,'10','3','4',49),(7970,10,11,246,'10','3','5',49),(7971,10,11,246,'10','3','6',49),(7972,10,11,246,'10','3','7',49),(7973,10,11,246,'2','3','8',49),(7974,10,11,246,'10','4','1',49),(7975,10,11,246,'10','4','2',49),(7976,10,11,246,'10','4','3',49),(7977,10,11,246,'10','4','4',49),(7978,10,11,246,'10','4','5',49),(7979,10,11,246,'10','4','6',49),(7980,10,11,246,'10','4','7',49),(7981,10,11,246,'6','4','8',49),(7982,10,11,246,'10','5','1',49),(7983,10,11,246,'10','5','2',49),(7984,10,11,246,'10','5','3',49),(7985,10,11,246,'10','5','4',49),(7986,10,11,246,'10','5','5',49),(7987,10,11,246,'10','5','6',49),(7988,10,11,246,'9','5','7',49),(7989,10,11,246,'10','6','1',49),(7990,10,11,246,'10','6','2',49),(7991,10,11,246,'10','6','3',49),(7992,10,11,246,'10','6','4',49),(7993,10,11,246,'10','6','5',49),(7994,10,11,246,'10','6','6',49),(7995,10,11,246,'10','6','7',49),(7996,10,11,246,'10','6','8',49),(7997,10,11,246,'5','6','9',49),(7999,10,11,246,'10','7','1',49),(8000,10,11,246,'10','7','2',49),(8001,10,11,246,'10','7','3',49),(8002,10,11,246,'10','7','4',49),(8003,10,11,246,'10','7','5',49),(8004,10,11,246,'10','7','6',49),(8005,10,11,246,'10','7','7',49),(8006,10,11,246,'4','7','8',49),(8007,10,11,247,'10','1','1',49),(8008,10,11,247,'10','1','2',49),(8009,10,11,247,'10','1','3',49),(8010,10,11,247,'10','1','4',49),(8011,10,11,247,'10','1','5',49),(8012,10,11,247,'10','1','6',49),(8013,10,11,247,'8','1','7',49),(8014,10,11,247,'10','2','1',49),(8015,10,11,247,'10','2','2',49),(8016,10,11,247,'10','2','3',49),(8017,10,11,247,'10','2','4',49),(8018,10,11,247,'10','2','5',49),(8019,10,11,247,'10','2','6',49),(8020,10,11,247,'10','2','7',49),(8021,10,11,247,'9','2','8',49),(8022,10,11,247,'10','3','1',49),(8023,10,11,247,'10','3','2',49),(8024,10,11,247,'10','3','3',49),(8025,10,11,247,'10','3','4',49),(8026,10,11,247,'10','3','5',49),(8027,10,11,247,'10','3','6',49),(8028,10,11,247,'10','3','7',49),(8030,10,11,247,'10','4','1',49),(8031,10,11,247,'10','4','2',49),(8032,10,11,247,'10','4','3',49),(8033,10,11,247,'10','4','4',49),(8034,10,11,247,'10','4','5',49),(8035,10,11,247,'10','4','6',49),(8036,10,11,247,'10','4','7',49),(8038,10,11,247,'10','5','1',49),(8039,10,11,247,'10','5','2',49),(8040,10,11,247,'10','5','3',49),(8041,10,11,247,'10','5','4',49),(8042,10,11,247,'10','5','5',49),(8043,10,11,247,'10','5','6',49),(8044,10,11,247,'10','5','7',49),(8045,10,11,247,'6','5','8',49),(8046,10,11,247,'10','6','1',49),(8047,10,11,247,'10','6','2',49),(8048,10,11,247,'10','6','3',49),(8049,10,11,247,'10','6','4',49),(8050,10,11,247,'10','6','5',49),(8051,10,11,247,'10','6','6',49),(8052,10,11,247,'10','6','7',49),(8054,10,11,247,'5','3','8',49),(8055,10,11,247,'4','4','8',49),(8056,10,11,247,'9','6','8',49),(8057,10,11,247,'10','7','1',49),(8058,10,11,247,'10','7','2',49),(8059,10,11,247,'10','7','3',49),(8060,10,11,247,'10','7','4',49),(8061,10,11,247,'10','7','5',49),(8062,10,11,247,'10','7','6',49),(8063,10,11,247,'10','7','7',49),(8064,10,11,248,'10','1','2',49),(8065,10,11,248,'10','1','1',49),(8066,10,11,248,'10','1','3',49),(8067,10,11,248,'10','1','4',49),(8068,10,11,248,'10','1','5',49),(8069,10,11,248,'10','1','6',49),(8070,10,11,248,'10','1','7',49),(8071,10,11,248,'6','1','8',49),(8072,10,11,248,'10','2','1',49),(8073,10,11,248,'10','2','2',49),(8074,10,11,248,'10','2','3',49),(8075,10,11,248,'10','2','4',49),(8076,10,11,248,'10','2','5',49),(8077,10,11,248,'10','2','6',49),(8078,10,11,248,'10','2','7',49),(8079,10,11,248,'4','2','8',49),(8080,10,11,248,'10','3','1',49),(8081,10,11,248,'10','3','2',49),(8082,10,11,248,'10','3','3',49),(8083,10,11,248,'10','3','4',49),(8084,10,11,248,'10','3','5',49),(8085,10,11,248,'10','3','6',49),(8086,10,11,248,'10','3','7',49),(8087,10,11,248,'3','3','8',49),(8088,10,11,248,'10','4','1',49),(8089,10,11,248,'10','4','2',49),(8090,10,11,248,'10','4','3',49),(8091,10,11,248,'10','4','4',49),(8092,10,11,248,'10','4','5',49),(8093,10,11,248,'10','4','6',49),(8094,10,11,248,'10','4','7',49),(8095,10,11,248,'5','4','8',49),(8096,10,11,248,'10','5','1',49),(8097,10,11,248,'10','5','2',49),(8098,10,11,248,'10','5','3',49),(8099,10,11,248,'10','5','4',49),(8100,10,11,248,'10','5','5',49),(8101,10,11,248,'10','5','6',49),(8102,10,11,248,'10','5','7',49),(8103,10,11,248,'6','5','8',49),(8104,10,11,248,'10','6','1',49),(8105,10,11,248,'10','6','2',49),(8106,10,11,248,'10','6','3',49),(8107,10,11,248,'10','6','4',49),(8108,10,11,248,'10','6','5',49),(8109,10,11,248,'10','6','6',49),(8110,10,11,248,'10','6','7',49),(8111,10,11,248,'3','6','8',49),(8112,10,11,248,'10','7','1',49),(8113,10,11,248,'10','7','2',49),(8114,10,11,248,'10','7','3',49),(8115,10,11,248,'10','7','4',49),(8116,10,11,248,'10','7','5',49),(8117,10,11,248,'10','7','6',49),(8118,10,11,248,'10','7','7',49),(8119,10,11,248,'3','7','8',49),(8120,10,11,249,'10','1','1',49),(8121,10,11,249,'10','1','2',49),(8122,10,11,249,'10','1','3',49),(8123,10,11,249,'10','1','4',49),(8124,10,11,249,'10','1','5',49),(8125,10,11,249,'10','1','6',49),(8126,10,11,249,'10','1','7',49),(8127,10,11,249,'3','1','8',49),(8128,10,11,249,'10','2','1',49),(8129,10,11,249,'10','2','2',49),(8130,10,11,249,'10','2','3',49),(8131,10,11,249,'10','2','4',49),(8132,10,11,249,'10','2','5',49),(8133,10,11,249,'10','2','6',49),(8134,10,11,249,'10','2','7',49),(8135,10,11,249,'10','3','1',49),(8136,10,11,249,'10','3','2',49),(8137,10,11,249,'10','3','3',49),(8138,10,11,249,'10','3','4',49),(8139,10,11,249,'10','3','5',49),(8140,10,11,249,'10','3','6',49),(8141,10,11,249,'10','3','7',49),(8142,10,11,249,'6','3','8',49),(8143,10,11,249,'10','4','1',49),(8144,10,11,249,'10','4','2',49),(8145,10,11,249,'10','4','3',49),(8146,10,11,249,'10','4','4',49),(8147,10,11,249,'10','4','5',49),(8148,10,11,249,'10','4','6',49),(8149,10,11,249,'10','4','7',49),(8150,10,11,249,'7','4','8',49),(8151,10,11,249,'10','5','1',49),(8152,10,11,249,'10','5','2',49),(8153,10,11,249,'10','5','3',49),(8154,10,11,249,'10','5','4',49),(8155,10,11,249,'10','5','5',49),(8156,10,11,249,'10','5','6',49),(8157,10,11,249,'10','5','7',49),(8158,10,11,249,'4','5','8',49),(8159,10,11,249,'10','6','1',49),(8160,10,11,249,'10','6','2',49),(8161,10,11,249,'10','6','3',49),(8162,10,11,249,'10','6','4',49),(8163,10,11,249,'10','6','5',49),(8164,10,11,249,'10','6','6',49),(8165,10,11,249,'10','6','7',49),(8166,10,11,249,'3','6','8',49),(8167,10,11,249,'10','7','1',49),(8168,10,11,249,'10','7','2',49),(8169,10,11,249,'10','7','3',49),(8170,10,11,249,'10','7','4',49),(8171,10,11,249,'10','7','5',49),(8172,10,11,249,'10','7','6',49),(8173,10,11,249,'10','7','7',49),(8174,10,11,249,'7','7','8',49),(8175,2,11,530,'10','1','1',51),(8176,2,11,530,'10','1','2',51),(8177,2,11,530,'10','1','3',51),(8178,2,11,530,'10','1','4',51),(8179,2,11,530,'10','1','5',51),(8180,2,11,530,'10','1','6',51),(8181,2,11,530,'10','1','7',51),(8182,2,11,530,'3','1','8',51),(8183,2,11,530,'M','1','9',51),(8184,2,11,530,'10','2','1',51),(8185,2,11,530,'10','2','2',51),(8186,2,11,530,'10','2','3',51),(8187,2,11,530,'10','2','4',51),(8188,2,11,530,'10','2','5',51),(8189,2,11,530,'10','2','6',51),(8190,2,11,530,'10','2','7',51),(8191,2,11,530,'10','2','8',51),(8192,2,11,530,'2','2','9',51),(8193,2,11,530,'10','3','1',51),(8194,2,11,530,'10','3','2',51),(8195,2,11,530,'10','3','3',51),(8196,2,11,530,'10','3','4',51),(8197,2,11,530,'10','3','5',51),(8198,2,11,530,'10','3','6',51),(8200,2,11,530,'9','3','8',51),(8201,2,11,530,'M','3','9',51),(8202,2,11,530,'10','3','7',51),(8203,2,11,530,'10','4','1',51),(8204,2,11,530,'10','4','2',51),(8205,2,11,530,'10','4','3',51),(8206,2,11,530,'10','4','4',51),(8207,2,11,530,'10','4','5',51),(8208,2,11,530,'10','4','6',51),(8209,2,11,530,'10','4','7',51),(8210,2,11,530,'7','4','8',51),(8211,2,11,530,'M','4','9',51),(8212,2,11,530,'10','5','1',51),(8213,2,11,530,'10','5','2',51),(8214,2,11,530,'10','5','3',51),(8215,2,11,530,'10','5','4',51),(8216,2,11,530,'10','5','5',51),(8217,2,11,530,'10','5','6',51),(8218,2,11,530,'10','5','7',51),(8219,2,11,530,'6','5','8',51),(8220,2,11,530,'M','5','9',51),(8221,2,11,530,'10','6','1',51),(8222,2,11,530,'10','6','2',51),(8223,2,11,530,'10','6','3',51),(8224,2,11,530,'10','6','4',51),(8225,2,11,530,'10','6','5',51),(8226,2,11,530,'9','6','6',51),(8227,2,11,530,'M','6','7',51),(8228,2,11,530,'M','6','8',51),(8229,2,11,530,'M','6','9',51),(8230,2,11,530,'10','7','1',51),(8231,2,11,530,'10','7','2',51),(8232,2,11,530,'10','7','3',51),(8233,2,11,530,'10','7','4',51),(8234,2,11,530,'10','7','5',51),(8235,2,11,530,'10','7','6',51),(8236,2,11,530,'10','7','7',51),(8237,2,11,530,'5','7','8',51),(8238,2,11,530,'M','7','9',51),(8239,2,11,532,'10','1','1',51),(8240,2,11,532,'10','1','2',51),(8241,2,11,532,'10','1','3',51),(8242,2,11,532,'10','1','4',51),(8243,2,11,532,'10','1','5',51),(8244,2,11,532,'10','1','6',51),(8245,2,11,532,'2','1','7',51),(8246,2,11,532,'M','1','8',51),(8247,2,11,532,'M','1','9',51),(8248,2,11,532,'10','2','1',51),(8249,2,11,532,'10','2','2',51),(8250,2,11,532,'10','2','3',51),(8251,2,11,532,'10','2','4',51),(8252,2,11,532,'10','2','5',51),(8253,2,11,532,'10','2','6',51),(8254,2,11,532,'8','2','7',51),(8255,2,11,532,'M','2','8',51),(8256,2,11,532,'M','2','9',51),(8257,2,11,532,'10','3','1',51),(8258,2,11,532,'10','3','2',51),(8259,2,11,532,'10','3','3',51),(8260,2,11,532,'10','3','4',51),(8261,2,11,532,'10','3','5',51),(8262,2,11,532,'10','3','6',51),(8263,2,11,532,'4','3','7',51),(8264,2,11,532,'M','3','8',51),(8265,2,11,532,'M','3','9',51),(8266,2,11,532,'10','4','1',51),(8267,2,11,532,'10','4','2',51),(8268,2,11,532,'10','4','3',51),(8269,2,11,532,'10','4','4',51),(8270,2,11,532,'10','4','5',51),(8271,2,11,532,'10','4','6',51),(8272,2,11,532,'10','4','7',51),(8273,2,11,532,'2','4','8',51),(8274,2,11,532,'M','4','9',51),(8275,2,11,532,'10','5','1',51),(8276,2,11,532,'10','5','2',51),(8277,2,11,532,'10','5','3',51),(8278,2,11,532,'10','5','4',51),(8279,2,11,532,'10','5','5',51),(8280,2,11,532,'10','5','6',51),(8281,2,11,532,'10','5','7',51),(8282,2,11,532,'2','5','8',51),(8284,2,11,532,'M','5','9',51),(8285,2,11,532,'10','6','1',51),(8286,2,11,532,'10','6','2',51),(8287,2,11,532,'10','6','3',51),(8288,2,11,532,'10','6','4',51),(8289,2,11,532,'10','6','5',51),(8290,2,11,532,'10','6','6',51),(8291,2,11,532,'2','6','7',51),(8292,2,11,532,'M','6','8',51),(8293,2,11,532,'M','6','9',51),(8294,2,11,532,'10','7','1',51),(8295,2,11,532,'10','7','2',51),(8296,2,11,532,'10','7','3',51),(8297,2,11,532,'10','7','4',51),(8298,2,11,532,'10','7','5',51),(8299,2,11,532,'9','7','6',51),(8300,2,11,532,'M','7','7',51),(8301,2,11,532,'M','7','8',51),(8302,2,11,532,'M','7','9',51),(8303,2,11,16,'10','1','1',51),(8304,2,11,16,'10','1','2',51),(8305,2,11,16,'10','1','3',51),(8306,2,11,16,'10','1','4',51),(8307,2,11,16,'10','1','5',51),(8308,2,11,16,'10','1','6',51),(8309,2,11,16,'5','1','7',51),(8310,2,11,16,'M','1','8',51),(8311,2,11,16,'M','1','9',51),(8312,2,11,16,'10','2','1',51),(8313,2,11,16,'10','2','2',51),(8314,2,11,16,'10','2','3',51),(8315,2,11,16,'10','2','4',51),(8316,2,11,16,'10','2','5',51),(8317,2,11,16,'6','2','6',51),(8318,2,11,16,'M','2','7',51),(8319,2,11,16,'M','2','8',51),(8320,2,11,16,'M','2','9',51),(8321,2,11,16,'10','3','1',51),(8322,2,11,16,'10','3','2',51),(8323,2,11,16,'10','3','3',51),(8324,2,11,16,'10','3','4',51),(8325,2,11,16,'10','3','5',51),(8326,2,11,16,'10','3','6',51),(8327,2,11,16,'9','3','7',51),(8328,2,11,16,'M','3','8',51),(8329,2,11,16,'M','3','9',51),(8330,2,11,16,'10','4','1',51),(8331,2,11,16,'10','4','2',51),(8332,2,11,16,'10','4','3',51),(8333,2,11,16,'10','4','4',51),(8334,2,11,16,'10','4','5',51),(8335,2,11,16,'10','4','6',51),(8336,2,11,16,'5','4','7',51),(8337,2,11,16,'M','4','8',51),(8338,2,11,16,'M','4','9',51),(8339,2,11,16,'10','5','1',51),(8340,2,11,16,'10','5','2',51),(8341,2,11,16,'10','5','3',51),(8342,2,11,16,'10','5','4',51),(8343,2,11,16,'10','5','5',51),(8344,2,11,16,'3','5','6',51),(8345,2,11,16,'M','5','7',51),(8346,2,11,16,'M','5','8',51),(8347,2,11,16,'M','5','9',51),(8348,2,11,16,'10','6','1',51),(8349,2,11,16,'10','6','2',51),(8350,2,11,16,'10','6','3',51),(8351,2,11,16,'10','6','4',51),(8352,2,11,16,'10','6','5',51),(8353,2,11,16,'1','6','8',51),(8354,2,11,16,'M','6','9',51),(8355,2,11,16,'10','6','6',51),(8356,2,11,16,'10','6','7',51),(8357,2,11,16,'10','7','1',51),(8358,2,11,16,'10','7','2',51),(8359,2,11,16,'10','7','3',51),(8360,2,11,16,'10','7','4',51),(8361,2,11,16,'9','7','5',51),(8362,2,11,16,'M','7','6',51),(8363,2,11,16,'M','7','7',51),(8364,2,11,16,'M','7','8',51),(8365,2,11,16,'M','7','9',51),(8366,2,11,23,'10','1','1',51),(8367,2,11,23,'10','1','2',51),(8368,2,11,23,'10','1','3',51),(8369,2,11,23,'10','1','4',51),(8370,2,11,23,'10','1','5',51),(8371,2,11,23,'10','1','6',51),(8372,2,11,23,'3','1','7',51),(8373,2,11,23,'M','1','8',51),(8374,2,11,23,'M','1','9',51),(8375,2,11,23,'10','2','1',51),(8376,2,11,23,'10','2','2',51),(8377,2,11,23,'10','2','3',51),(8378,2,11,23,'10','2','4',51),(8379,2,11,23,'10','2','5',51),(8380,2,11,23,'9','2','6',51),(8381,2,11,23,'M','2','7',51),(8382,2,11,23,'M','2','8',51),(8383,2,11,23,'M','2','9',51),(8384,2,11,23,'10','3','1',51),(8385,2,11,23,'10','3','2',51),(8386,2,11,23,'10','3','3',51),(8387,2,11,23,'10','3','4',51),(8388,2,11,23,'10','3','5',51),(8389,2,11,23,'10','3','6',51),(8390,2,11,23,'1','3','7',51),(8391,2,11,23,'M','3','8',51),(8392,2,11,23,'M','3','9',51),(8393,2,11,23,'10','4','1',51),(8394,2,11,23,'10','4','2',51),(8395,2,11,23,'10','4','3',51),(8396,2,11,23,'10','4','4',51),(8397,2,11,23,'10','4','5',51),(8398,2,11,23,'10','4','6',51),(8399,2,11,23,'1','4','7',51),(8400,2,11,23,'M','4','8',51),(8401,2,11,23,'M','4','9',51),(8402,2,11,23,'10','5','1',51),(8403,2,11,23,'10','5','2',51),(8404,2,11,23,'10','5','3',51),(8405,2,11,23,'10','5','4',51),(8406,2,11,23,'10','5','5',51),(8407,2,11,23,'9','5','6',51),(8408,2,11,23,'M','5','7',51),(8409,2,11,23,'M','5','8',51),(8410,2,11,23,'M','5','9',51),(8411,2,11,23,'10','6','2',51),(8412,2,11,23,'10','6','3',51),(8413,2,11,23,'10','6','1',51),(8414,2,11,23,'10','6','5',51),(8415,2,11,23,'10','6','4',51),(8416,2,11,23,'7','6','6',51),(8417,2,11,23,'M','6','7',51),(8418,2,11,23,'M','6','8',51),(8419,2,11,23,'M','6','9',51),(8420,2,11,23,'10','7','1',51),(8421,2,11,23,'10','7','2',51),(8422,2,11,23,'10','7','3',51),(8423,2,11,23,'10','7','4',51),(8424,2,11,23,'10','7','5',51),(8425,2,11,23,'10','7','6',51),(8426,2,11,23,'5','7','7',51),(8427,2,11,23,'M','7','8',51),(8428,2,11,23,'M','7','9',51),(8429,2,11,22,'10','1','1',51),(8430,2,11,22,'10','1','2',51),(8431,2,11,22,'10','1','3',51),(8432,2,11,22,'10','1','4',51),(8433,2,11,22,'M','1','5',51),(8434,2,11,22,'M','1','6',51),(8435,2,11,22,'M','1','7',51),(8436,2,11,22,'M','1','8',51),(8437,2,11,22,'M','1','9',51),(8438,2,11,22,'10','2','1',51),(8439,2,11,22,'10','2','2',51),(8440,2,11,22,'10','2','3',51),(8441,2,11,22,'10','2','4',51),(8444,2,11,22,'10','2','5',51),(8445,2,11,22,'10','2','6',51),(8446,2,11,22,'9','2','7',51),(8447,2,11,22,'M','2','8',51),(8448,2,11,22,'M','2','9',51),(8449,2,11,22,'10','3','1',51),(8450,2,11,22,'10','3','2',51),(8451,2,11,22,'10','3','3',51),(8452,2,11,22,'10','3','4',51),(8453,2,11,22,'7','3','5',51),(8454,2,11,22,'M','3','6',51),(8455,2,11,22,'M','3','7',51),(8456,2,11,22,'M','3','8',51),(8457,2,11,22,'M','3','9',51),(8458,2,11,22,'10','4','1',51),(8459,2,11,22,'10','4','2',51),(8460,2,11,22,'10','4','3',51),(8461,2,11,22,'10','4','4',51),(8462,2,11,22,'10','4','5',51),(8463,2,11,22,'10','4','6',51),(8464,2,11,22,'5','4','7',51),(8465,2,11,22,'M','4','8',51),(8466,2,11,22,'M','4','9',51),(8467,2,11,22,'10','5','1',51),(8468,2,11,22,'10','5','2',51),(8469,2,11,22,'10','5','3',51),(8470,2,11,22,'10','5','4',51),(8471,2,11,22,'10','5','5',51),(8472,2,11,22,'10','5','6',51),(8473,2,11,22,'10','5','7',51),(8474,2,11,22,'2','5','8',51),(8475,2,11,22,'M','5','9',51),(8476,2,11,22,'10','6','1',51),(8477,2,11,22,'10','6','2',51),(8478,2,11,22,'10','6','3',51),(8479,2,11,22,'10','6','4',51),(8480,2,11,22,'10','6','5',51),(8481,2,11,22,'9','6','6',51),(8482,2,11,22,'M','6','7',51),(8483,2,11,22,'M','6','8',51),(8484,2,11,22,'M','6','9',51),(8485,2,11,22,'10','7','1',51),(8486,2,11,22,'10','7','2',51),(8487,2,11,22,'10','7','3',51),(8488,2,11,22,'10','7','4',51),(8489,2,11,22,'10','7','5',51),(8490,2,11,22,'10','7','6',51),(8491,2,11,22,'M','7','7',51),(8492,2,11,22,'M','7','8',51),(8493,2,11,22,'M','7','9',51),(8494,2,11,535,'10','1','1',51),(8495,2,11,535,'10','1','2',51),(8496,2,11,535,'10','1','3',51),(8497,2,11,535,'10','1','4',51),(8498,2,11,535,'10','1','5',51),(8499,2,11,535,'10','1','6',51),(8500,2,11,535,'10','1','7',51),(8501,2,11,535,'5','1','8',51),(8502,2,11,535,'M','1','9',51),(8503,2,11,535,'10','2','1',51),(8504,2,11,535,'10','2','2',51),(8505,2,11,535,'10','2','3',51),(8506,2,11,535,'10','2','4',51),(8507,2,11,535,'10','2','5',51),(8508,2,11,535,'M','2','6',51),(8509,2,11,535,'M','2','7',51),(8510,2,11,535,'M','2','8',51),(8511,2,11,535,'M','2','9',51),(8512,2,11,535,'10','3','1',51),(8513,2,11,535,'10','3','2',51),(8514,2,11,535,'10','3','3',51),(8515,2,11,535,'10','3','4',51),(8516,2,11,535,'9','3','5',51),(8517,2,11,535,'M','3','6',51),(8518,2,11,535,'M','3','7',51),(8519,2,11,535,'M','3','8',51),(8520,2,11,535,'M','3','9',51),(8521,2,11,535,'10','4','1',51),(8522,2,11,535,'10','4','2',51),(8523,2,11,535,'10','4','3',51),(8524,2,11,535,'10','4','4',51),(8525,2,11,535,'10','4','5',51),(8526,2,11,535,'7','4','6',51),(8527,2,11,535,'M','4','7',51),(8528,2,11,535,'M','4','8',51),(8529,2,11,535,'M','4','9',51),(8530,2,11,535,'10','5','1',51),(8531,2,11,535,'10','5','2',51),(8532,2,11,535,'10','5','3',51),(8533,2,11,535,'10','5','4',51),(8534,2,11,535,'10','5','5',51),(8535,2,11,535,'3','5','6',51),(8536,2,11,535,'M','5','7',51),(8537,2,11,535,'M','5','8',51),(8538,2,11,535,'M','5','9',51),(8539,2,11,535,'10','6','1',51),(8540,2,11,535,'10','6','2',51),(8541,2,11,535,'10','6','3',51),(8542,2,11,535,'10','6','4',51),(8543,2,11,535,'10','6','5',51),(8544,2,11,535,'1','6','6',51),(8545,2,11,535,'M','6','7',51),(8546,2,11,535,'M','6','8',51),(8547,2,11,535,'M','6','9',51),(8548,2,11,535,'10','7','1',51),(8549,2,11,535,'10','7','2',51),(8550,2,11,535,'10','7','3',51),(8551,2,11,535,'10','7','4',51),(8552,2,11,535,'10','7','5',51),(8553,2,11,535,'10','7','6',51),(8554,2,11,535,'7','7','7',51),(8555,2,11,535,'M','7','8',51),(8556,2,11,535,'M','7','9',51),(8557,2,11,538,'10','1','1',51),(8558,2,11,538,'10','1','2',51),(8560,2,11,538,'4','1','4',51),(8561,2,11,538,'M','1','5',51),(8562,2,11,538,'M','1','6',51),(8563,2,11,538,'M','1','7',51),(8564,2,11,538,'M','1','8',51),(8565,2,11,538,'M','1','9',51),(8566,2,11,538,'10','2','1',51),(8567,2,11,538,'10','2','2',51),(8568,2,11,538,'10','2','3',51),(8569,2,11,538,'10','2','4',51),(8570,2,11,538,'10','2','5',51),(8571,2,11,538,'1','2','6',51),(8572,2,11,538,'M','2','7',51),(8573,2,11,538,'M','2','8',51),(8574,2,11,538,'M','2','9',51),(8575,2,11,538,'10','3','1',51),(8576,2,11,538,'10','3','2',51),(8577,2,11,538,'10','3','3',51),(8578,2,11,538,'10','3','4',51),(8579,2,11,538,'10','3','5',51),(8580,2,11,538,'10','3','6',51),(8581,2,11,538,'3','3','7',51),(8582,2,11,538,'M','3','8',51),(8583,2,11,538,'M','3','9',51),(8584,2,11,538,'10','4','1',51),(8585,2,11,538,'10','4','2',51),(8586,2,11,538,'10','4','3',51),(8587,2,11,538,'10','4','4',51),(8588,2,11,538,'10','4','5',51),(8589,2,11,538,'10','4','6',51),(8590,2,11,538,'6','4','7',51),(8591,2,11,538,'M','4','8',51),(8592,2,11,538,'M','4','9',51),(8593,2,11,538,'10','5','1',51),(8594,2,11,538,'10','5','2',51),(8595,2,11,538,'10','5','3',51),(8596,2,11,538,'10','5','4',51),(8597,2,11,538,'10','5','5',51),(8598,2,11,538,'4','5','6',51),(8599,2,11,538,'M','5','7',51),(8600,2,11,538,'M','5','8',51),(8601,2,11,538,'M','5','9',51),(8602,2,11,538,'10','6','1',51),(8603,2,11,538,'10','6','2',51),(8604,2,11,538,'10','6','3',51),(8605,2,11,538,'10','6','4',51),(8606,2,11,538,'10','6','5',51),(8607,2,11,538,'10','6','6',51),(8608,2,11,538,'10','6','7',51),(8609,2,11,538,'1','6','8',51),(8610,2,11,538,'M','6','9',51),(8611,2,11,538,'10','7','1',51),(8612,2,11,538,'10','7','2',51),(8613,2,11,538,'10','7','3',51),(8614,2,11,538,'10','7','4',51),(8615,2,11,538,'10','7','5',51),(8616,2,11,538,'10','7','6',51),(8617,2,11,538,'3','7','7',51),(8618,2,11,538,'M','7','8',51),(8619,2,11,538,'M','7','9',51),(8620,2,11,538,'10','1','3',51),(8621,2,11,15,'10','1','1',51),(8622,2,11,15,'10','1','2',51),(8623,2,11,15,'10','1','3',51),(8624,2,11,15,'10','1','4',51),(8625,2,11,15,'10','1','5',51),(8626,2,11,15,'2','1','6',51),(8627,2,11,15,'M','1','7',51),(8628,2,11,15,'M','1','8',51),(8629,2,11,15,'M','1','9',51),(8630,2,11,15,'10','2','1',51),(8631,2,11,15,'10','2','2',51),(8632,2,11,15,'10','2','3',51),(8633,2,11,15,'6','2','4',51),(8634,2,11,15,'M','2','5',51),(8635,2,11,15,'M','2','6',51),(8636,2,11,15,'M','2','7',51),(8637,2,11,15,'M','2','8',51),(8638,2,11,15,'M','2','9',51),(8639,2,11,15,'10','3','1',51),(8640,2,11,15,'10','3','2',51),(8641,2,11,15,'10','3','3',51),(8642,2,11,15,'10','3','4',51),(8643,2,11,15,'10','3','5',51),(8644,2,11,15,'10','3','6',51),(8645,2,11,15,'9','3','7',51),(8646,2,11,15,'M','3','8',51),(8647,2,11,15,'M','3','9',51),(8648,2,11,15,'10','4','1',51),(8649,2,11,15,'10','4','2',51),(8650,2,11,15,'10','4','3',51),(8651,2,11,15,'10','4','4',51),(8652,2,11,15,'M','4','5',51),(8653,2,11,15,'M','4','6',51),(8654,2,11,15,'M','4','7',51),(8655,2,11,15,'M','4','8',51),(8656,2,11,15,'M','4','9',51),(8657,2,11,15,'10','5','1',51),(8658,2,11,15,'10','5','2',51),(8659,2,11,15,'10','5','3',51),(8660,2,11,15,'10','5','4',51),(8661,2,11,15,'10','5','5',51),(8662,2,11,15,'9','5','6',51),(8663,2,11,15,'M','5','7',51),(8664,2,11,15,'M','5','8',51),(8665,2,11,15,'M','5','9',51),(8666,2,11,15,'10','6','1',51),(8667,2,11,15,'10','6','2',51),(8668,2,11,15,'10','6','3',51),(8669,2,11,15,'10','6','4',51),(8670,2,11,15,'10','6','5',51),(8671,2,11,15,'10','6','6',51),(8672,2,11,15,'7','6','7',51),(8673,2,11,15,'M','6','8',51),(8674,2,11,15,'M','6','9',51),(8675,2,11,15,'10','7','1',51),(8676,2,11,15,'10','7','2',51),(8677,2,11,15,'10','7','3',51),(8678,2,11,15,'10','7','4',51),(8679,2,11,15,'7','7','5',51),(8680,2,11,15,'M','7','6',51),(8681,2,11,15,'M','7','7',51),(8682,2,11,15,'M','7','8',51),(8683,2,11,15,'M','7','9',51),(8684,2,11,21,'10','1','1',51),(8685,2,11,21,'10','1','2',51),(8686,2,11,21,'10','1','3',51),(8687,2,11,21,'10','1','4',51),(8688,2,11,21,'5','1','5',51),(8689,2,11,21,'M','1','6',51),(8690,2,11,21,'M','1','7',51),(8691,2,11,21,'M','1','8',51),(8692,2,11,21,'M','1','9',51),(8693,2,11,21,'10','2','1',51),(8694,2,11,21,'10','2','2',51),(8695,2,11,21,'10','2','3',51),(8696,2,11,21,'9','2','4',51),(8697,2,11,21,'M','2','5',51),(8698,2,11,21,'M','2','6',51),(8699,2,11,21,'M','2','7',51),(8700,2,11,21,'M','2','8',51),(8701,2,11,21,'M','2','9',51),(8702,2,11,21,'10','3','1',51),(8703,2,11,21,'10','3','2',51),(8704,2,11,21,'10','3','3',51),(8705,2,11,21,'10','3','4',51),(8706,2,11,21,'10','3','5',51),(8707,2,11,21,'10','3','6',51),(8708,2,11,21,'M','3','7',51),(8709,2,11,21,'M','3','8',51),(8710,2,11,21,'M','3','9',51),(8711,2,11,21,'10','4','1',51),(8712,2,11,21,'10','4','2',51),(8713,2,11,21,'10','4','3',51),(8714,2,11,21,'10','4','4',51),(8715,2,11,21,'10','4','5',51),(8716,2,11,21,'7','4','6',51),(8717,2,11,21,'M','4','7',51),(8718,2,11,21,'M','4','8',51),(8719,2,11,21,'M','4','9',51),(8720,2,11,21,'10','5','1',51),(8721,2,11,21,'10','5','2',51),(8722,2,11,21,'10','5','3',51),(8723,2,11,21,'10','5','4',51),(8724,2,11,21,'10','5','5',51),(8725,2,11,21,'8','5','6',51),(8726,2,11,21,'M','5','7',51),(8727,2,11,21,'M','5','8',51),(8728,2,11,21,'M','5','9',51),(8729,2,11,21,'10','6','1',51),(8730,2,11,21,'10','6','2',51),(8731,2,11,21,'10','6','3',51),(8732,2,11,21,'10','6','4',51),(8733,2,11,21,'7','6','5',51),(8734,2,11,21,'M','6','6',51),(8735,2,11,21,'M','6','7',51),(8736,2,11,21,'M','6','8',51),(8737,2,11,21,'M','6','9',51),(8738,2,11,21,'10','7','1',51),(8739,2,11,21,'10','7','2',51),(8740,2,11,21,'10','7','3',51),(8741,2,11,21,'10','7','4',51),(8742,2,11,21,'10','7','5',51),(8743,2,11,21,'1','7','6',51),(8744,2,11,21,'M','7','7',51),(8745,2,11,21,'M','7','8',51),(8746,2,11,21,'M','7','9',51),(8747,2,11,20,'10','1','1',51),(8748,2,11,20,'10','1','2',51),(8749,2,11,20,'10','1','3',51),(8750,2,11,20,'10','1','4',51),(8751,2,11,20,'10','1','5',51),(8752,2,11,20,'1','1','6',51),(8753,2,11,20,'M','1','7',51),(8754,2,11,20,'M','1','8',51),(8755,2,11,20,'M','1','9',51),(8756,2,11,20,'10','2','1',51),(8757,2,11,20,'10','2','2',51),(8758,2,11,20,'10','2','3',51),(8759,2,11,20,'10','2','4',51),(8760,2,11,20,'8','2','5',51),(8761,2,11,20,'M','2','6',51),(8762,2,11,20,'M','2','7',51),(8763,2,11,20,'M','2','8',51),(8764,2,11,20,'M','2','9',51),(8765,2,11,20,'10','3','1',51),(8766,2,11,20,'10','3','2',51),(8767,2,11,20,'7','3','3',51),(8768,2,11,20,'M','3','4',51),(8769,2,11,20,'M','3','5',51),(8770,2,11,20,'M','3','6',51),(8771,2,11,20,'M','3','7',51),(8772,2,11,20,'M','3','8',51),(8773,2,11,20,'M','3','9',51),(8774,2,11,20,'10','4','1',51),(8775,2,11,20,'10','4','2',51),(8776,2,11,20,'3','4','3',51),(8777,2,11,20,'M','4','4',51),(8778,2,11,20,'M','4','5',51),(8779,2,11,20,'M','4','6',51),(8780,2,11,20,'M','4','7',51),(8781,2,11,20,'M','4','8',51),(8782,2,11,20,'M','4','9',51),(8783,2,11,20,'10','5','1',51),(8784,2,11,20,'10','5','2',51),(8785,2,11,20,'10','5','3',51),(8786,2,11,20,'1','5','4',51),(8787,2,11,20,'M','5','5',51),(8788,2,11,20,'M','5','6',51),(8789,2,11,20,'M','5','7',51),(8790,2,11,20,'M','5','8',51),(8791,2,11,20,'M','5','9',51),(8792,2,11,20,'10','6','1',51),(8793,2,11,20,'10','6','2',51),(8794,2,11,20,'10','6','3',51),(8795,2,11,20,'10','6','4',51),(8796,2,11,20,'3','6','5',51),(8797,2,11,20,'M','6','6',51),(8798,2,11,20,'M','6','7',51),(8799,2,11,20,'M','6','8',51),(8800,2,11,20,'M','6','9',51),(8801,2,11,20,'10','7','1',51),(8802,2,11,20,'10','7','2',51),(8803,2,11,20,'10','7','3',51),(8804,2,11,20,'4','7','4',51),(8805,2,11,20,'M','7','5',51),(8806,2,11,20,'M','7','6',51),(8807,2,11,20,'M','7','7',51),(8808,2,11,20,'M','7','8',51),(8809,2,11,20,'M','7','9',51),(8810,10,11,250,'10','1','1',49),(8811,10,11,250,'10','1','2',49),(8812,10,11,250,'10','1','3',49),(8813,10,11,250,'10','1','4',49),(8814,10,11,250,'10','1','5',49),(8815,10,11,250,'10','1','6',49),(8816,10,11,250,'10','1','7',49),(8817,10,11,250,'1','1','8',49),(8818,10,11,250,'10','2','1',49),(8819,10,11,250,'10','2','2',49),(8820,10,11,250,'10','2','3',49),(8821,10,11,250,'10','2','4',49),(8822,10,11,250,'10','2','5',49),(8823,10,11,250,'10','2','6',49),(8824,10,11,250,'10','2','7',49),(8825,10,11,250,'7','2','8',49),(8826,10,11,250,'10','3','1',49),(8827,10,11,250,'10','3','2',49),(8828,10,11,250,'10','3','3',49),(8829,10,11,250,'10','3','4',49),(8830,10,11,250,'10','3','5',49),(8831,10,11,250,'10','3','6',49),(8832,10,11,250,'10','3','7',49),(8833,10,11,250,'1','3','8',49),(8834,11,11,291,'10','1','1',50),(8835,11,11,291,'10','1','2',50),(8836,11,11,291,'10','1','3',50),(8837,11,11,291,'10','1','4',50),(8838,11,11,291,'10','1','5',50),(8839,11,11,291,'10','1','6',50),(8840,11,11,291,'10','1','7',50),(8841,11,11,291,'10','1','8',50),(8842,11,11,291,'2','1','9',50),(8843,11,11,291,'10','2','1',50),(8844,11,11,291,'10','2','2',50),(8845,11,11,291,'10','2','3',50),(8846,11,11,291,'10','2','4',50),(8847,11,11,291,'10','2','5',50),(8848,11,11,291,'10','2','6',50),(8849,11,11,291,'10','2','7',50),(8850,11,11,291,'10','2','8',50),(8851,11,11,291,'3','2','9',50),(8852,11,11,291,'10','3','1',50),(8853,11,11,291,'10','3','2',50),(8854,11,11,291,'10','3','3',50),(8855,11,11,291,'10','3','4',50),(8856,11,11,291,'10','3','5',50),(8857,11,11,291,'10','3','6',50),(8858,11,11,291,'10','3','7',50),(8859,11,11,291,'5','3','8',50),(8860,11,11,291,'5','3','9',50),(8861,11,11,291,'10','4','1',50),(8862,11,11,291,'10','4','2',50),(8863,11,11,291,'10','4','3',50),(8864,11,11,291,'10','4','4',50),(8865,11,11,291,'10','4','5',50),(8866,11,11,291,'10','4','6',50),(8867,11,11,291,'10','4','7',50),(8868,11,11,291,'10','4','8',50),(8869,11,11,291,'1','4','9',50),(8870,11,11,291,'10','5','1',50),(8871,11,11,291,'10','5','2',50),(8872,11,11,291,'10','5','3',50),(8873,11,11,291,'10','5','4',50),(8874,11,11,291,'10','5','5',50),(8875,11,11,291,'10','5','6',50),(8876,11,11,291,'10','5','7',50),(8877,11,11,291,'8','5','8',50),(8878,11,11,291,'1','5','9',50),(8879,11,11,291,'10','6','1',50),(8880,11,11,291,'10','6','2',50),(8881,11,11,291,'10','6','3',50),(8882,11,11,291,'10','6','4',50),(8883,11,11,291,'10','6','7',50),(8884,11,11,291,'10','6','5',50),(8885,11,11,291,'10','6','6',50),(8886,11,11,291,'10','6','8',50),(8887,11,11,291,'4','6','9',50),(8888,11,11,291,'10','7','1',50),(8889,11,11,291,'10','7','2',50),(8890,11,11,291,'10','7','3',50),(8891,11,11,291,'10','7','4',50),(8892,11,11,291,'10','7','5',50),(8893,11,11,291,'10','7','6',50),(8894,11,11,291,'10','7','7',50),(8895,11,11,291,'10','7','8',50),(8896,11,11,291,'3','7','9',50),(8897,11,11,293,'10','3','1',50),(8898,11,11,293,'10','3','2',50),(8899,6,11,553,'10','1','2',52),(8900,6,11,553,'10','1','1',52),(8901,6,11,553,'10','1','3',52),(8902,6,11,553,'10','1','4',52),(8903,6,11,553,'10','1','5',52),(8904,6,11,553,'10','1','6',52),(8905,6,11,553,'10','1','7',52),(8906,6,11,553,'6','1','8',52),(8907,6,11,553,'10','2','1',52),(8908,6,11,553,'10','2','2',52),(8909,6,11,553,'10','2','3',52),(8910,6,11,553,'10','2','4',52),(8911,6,11,553,'10','2','5',52),(8912,6,11,553,'10','2','6',52),(8913,6,11,553,'10','2','7',52),(8915,6,11,553,'8','2','8',52),(8916,6,11,553,'10','3','1',52),(8917,6,11,553,'10','3','2',52),(8918,6,11,553,'10','3','3',52),(8919,6,11,553,'10','3','4',52),(8920,6,11,553,'10','3','5',52),(8921,6,11,553,'10','3','6',52),(8922,6,11,553,'10','3','7',52),(8923,6,11,553,'9','3','8',52),(8924,6,11,553,'10','4','1',52),(8925,6,11,553,'10','4','2',52),(8926,6,11,553,'10','4','3',52),(8927,6,11,553,'10','4','4',52),(8928,6,11,553,'10','4','5',52),(8929,6,11,553,'10','4','6',52),(8930,6,11,553,'10','4','7',52),(8931,6,11,553,'9','4','8',52),(8932,6,11,553,'10','5','1',52),(8933,6,11,553,'10','5','2',52),(8934,6,11,553,'10','5','3',52),(8935,6,11,553,'10','5','4',52),(8936,6,11,553,'10','5','5',52),(8937,6,11,553,'10','5','6',52),(8938,6,11,553,'10','5','7',52),(8939,6,11,553,'1','5','8',52),(8940,6,11,553,'10','6','1',52),(8941,6,11,553,'10','6','2',52),(8942,6,11,553,'10','6','3',52),(8943,6,11,553,'10','6','4',52),(8944,6,11,553,'10','6','5',52),(8945,6,11,553,'10','6','6',52),(8946,6,11,553,'10','6','7',52),(8947,6,11,553,'4','6','8',52),(8948,6,11,553,'10','7','1',52),(8949,6,11,553,'10','7','2',52),(8950,6,11,553,'10','7','3',52),(8951,6,11,553,'10','7','4',52),(8952,6,11,553,'10','7','6',52),(8953,6,11,553,'10','7','7',52),(8954,6,11,553,'2','7','8',52),(8955,6,11,553,'10','7','5',52),(8956,6,11,566,'10','1','1',52),(8957,6,11,566,'10','1','2',52),(8958,6,11,566,'10','1','3',52),(8959,6,11,566,'10','1','4',52),(8960,6,11,566,'10','1','5',52),(8961,6,11,566,'10','1','6',52),(8962,6,11,566,'5','1','7',52),(8963,6,11,566,'4','1','8',52),(8965,6,11,566,'10','2','1',52),(8966,6,11,566,'10','2','2',52),(8967,6,11,566,'10','2','3',52),(8968,6,11,566,'10','2','4',52),(8969,6,11,566,'10','2','5',52),(8970,6,11,566,'10','2','6',52),(8971,6,11,566,'10','2','7',52),(8972,6,11,566,'7','2','8',52),(8973,6,11,566,'10','3','1',52),(8974,6,11,566,'10','3','2',52),(8975,6,11,566,'10','3','3',52),(8976,6,11,566,'10','3','4',52),(8977,6,11,566,'10','3','5',52),(8978,6,11,566,'10','3','6',52),(8979,6,11,566,'10','3','7',52),(8980,6,11,566,'2','3','8',52),(8981,6,11,566,'10','4','1',52),(8982,6,11,566,'10','4','2',52),(8983,6,11,566,'10','4','3',52),(8984,6,11,566,'10','4','4',52),(8985,6,11,566,'10','4','5',52),(8986,6,11,566,'10','4','6',52),(8987,6,11,566,'4','4','7',52),(8988,6,11,566,'3','4','8',52),(8989,6,11,566,'10','5','1',52),(8990,6,11,566,'10','5','2',52),(8991,6,11,566,'10','5','3',52),(8992,6,11,566,'10','5','4',52),(8993,6,11,566,'10','5','5',52),(8994,6,11,566,'10','5','6',52),(8995,6,11,566,'10','5','7',52),(8996,6,11,566,'5','5','8',52),(8997,6,11,566,'10','6','1',52),(8998,6,11,566,'10','6','2',52),(8999,6,11,566,'10','6','3',52),(9000,6,11,566,'10','6','4',52),(9001,6,11,566,'10','6','5',52),(9002,6,11,566,'10','6','6',52),(9003,6,11,566,'10','6','7',52),(9005,6,11,566,'10','7','1',52),(9006,6,11,566,'10','7','2',52),(9007,6,11,566,'3','6','8',52),(9008,6,11,566,'10','7','3',52),(9009,6,11,566,'10','7','4',52),(9010,6,11,566,'10','7','5',52),(9011,6,11,566,'10','7','6',52),(9012,6,11,566,'10','7','7',52),(9013,6,11,566,'7','7','8',52),(9014,6,11,567,'10','1','1',52),(9015,6,11,567,'10','1','2',52),(9016,6,11,567,'10','1','3',52),(9017,6,11,567,'10','1','4',52),(9018,6,11,567,'10','1','5',52),(9019,6,11,567,'10','1','6',52),(9020,6,11,567,'2','1','7',52),(9021,6,11,567,'2','1','8',52),(9022,6,11,567,'10','2','1',52),(9023,6,11,567,'10','2','2',52),(9024,6,11,567,'10','2','3',52),(9025,6,11,567,'10','2','4',52),(9026,6,11,567,'10','2','5',52),(9027,6,11,567,'10','2','6',52),(9028,6,11,567,'10','2','7',52),(9029,6,11,567,'3','2','8',52),(9030,6,11,567,'10','3','1',52),(9031,6,11,567,'10','3','2',52),(9032,6,11,567,'10','3','3',52),(9033,6,11,567,'10','3','4',52),(9034,6,11,567,'10','3','5',52),(9035,6,11,567,'10','3','6',52),(9036,6,11,567,'10','3','7',52),(9037,6,11,567,'7','3','8',52),(9038,6,11,567,'10','4','1',52),(9039,6,11,567,'10','4','2',52),(9040,6,11,567,'10','4','3',52),(9041,6,11,567,'10','4','4',52),(9042,6,11,567,'10','4','5',52),(9043,6,11,567,'10','4','6',52),(9044,6,11,567,'10','4','7',52),(9045,6,11,567,'7','4','8',52),(9046,6,11,567,'10','5','1',52),(9047,6,11,567,'10','5','2',52),(9048,6,11,567,'10','5','3',52),(9049,6,11,567,'10','5','4',52),(9050,6,11,567,'10','5','5',52),(9051,6,11,567,'10','5','6',52),(9052,6,11,567,'3','5','7',52),(9054,6,11,567,'10','6','1',52),(9055,6,11,567,'10','6','2',52),(9056,6,11,567,'10','6','3',52),(9057,6,11,567,'4','5','8',52),(9058,6,11,567,'10','6','4',52),(9059,6,11,567,'10','6','5',52),(9060,6,11,567,'10','6','6',52),(9061,6,11,567,'2','6','7',52),(9062,6,11,567,'1','6','8',52),(9063,6,11,567,'10','7','2',52),(9064,6,11,567,'10','7','3',52),(9065,6,11,567,'10','7','4',52),(9066,6,11,567,'10','7','5',52),(9067,6,11,567,'10','7','6',52),(9068,6,11,567,'10','7','7',52),(9069,6,11,567,'10','7','1',52),(9070,6,11,567,'8','7','8',52),(9071,6,11,572,'10','1','1',52),(9072,6,11,572,'10','1','2',52),(9073,6,11,572,'10','1','3',52),(9074,6,11,572,'10','1','4',52),(9075,6,11,572,'10','1','5',52),(9076,6,11,572,'10','1','6',52),(9077,6,11,572,'4','1','7',52),(9078,6,11,572,'4','1','8',52),(9079,6,11,572,'10','2','1',52),(9080,6,11,572,'10','2','2',52),(9081,6,11,572,'10','2','3',52),(9082,6,11,572,'10','2','4',52),(9083,6,11,572,'10','2','5',52),(9084,6,11,572,'10','2','6',52),(9085,6,11,572,'3','2','7',52),(9086,6,11,572,'2','2','8',52),(9087,6,11,572,'10','3','1',52),(9088,6,11,572,'10','3','2',52),(9089,6,11,572,'10','3','3',52),(9090,6,11,572,'10','3','4',52),(9091,6,11,572,'10','3','5',52),(9092,6,11,572,'10','3','6',52),(9093,6,11,572,'10','3','7',52),(9094,6,11,572,'7','3','8',52),(9095,6,11,572,'10','4','1',52),(9096,6,11,572,'10','4','2',52),(9097,6,11,572,'10','4','3',52),(9098,6,11,572,'10','4','4',52),(9099,6,11,572,'10','4','5',52),(9100,6,11,572,'10','4','6',52),(9101,6,11,572,'10','4','7',52),(9102,6,11,572,'4','4','8',52),(9103,6,11,572,'10','5','1',52),(9104,6,11,572,'10','5','2',52),(9105,6,11,572,'10','5','3',52),(9106,6,11,572,'10','5','4',52),(9107,6,11,572,'10','5','5',52),(9108,6,11,572,'10','5','6',52),(9109,6,11,572,'2','5','7',52),(9110,6,11,572,'3','5','8',52),(9111,6,11,572,'10','6','1',52),(9112,6,11,572,'10','6','2',52),(9113,6,11,572,'10','6','3',52),(9114,6,11,572,'10','6','4',52),(9115,6,11,572,'10','6','5',52),(9116,6,11,572,'10','6','6',52),(9117,6,11,572,'10','6','7',52),(9118,6,11,572,'1','6','8',52),(9119,6,11,572,'10','7','1',52),(9120,6,11,572,'10','7','2',52),(9121,6,11,572,'10','7','3',52),(9122,6,11,572,'10','7','4',52),(9123,6,11,572,'10','7','5',52),(9124,6,11,572,'10','7','6',52),(9125,6,11,572,'10','7','7',52),(9126,6,11,572,'7','7','8',52),(9127,6,11,575,'10','1','1',52),(9128,6,11,575,'10','1','2',52),(9129,6,11,575,'10','1','3',52),(9130,6,11,575,'10','1','4',52),(9131,6,11,575,'10','1','5',52),(9132,6,11,575,'10','1','6',52),(9133,6,11,575,'5','1','7',52),(9134,6,11,575,'5','1','8',52),(9135,6,11,575,'10','2','1',52),(9136,6,11,575,'10','2','2',52),(9137,6,11,575,'10','2','3',52),(9138,6,11,575,'10','2','4',52),(9139,6,11,575,'10','2','5',52),(9142,6,11,575,'5','2','8',52),(9144,6,11,575,'10','2','6',52),(9145,6,11,575,'5','2','7',52),(9146,6,11,575,'10','3','1',52),(9147,6,11,575,'10','3','2',52),(9148,6,11,575,'10','3','3',52),(9149,6,11,575,'10','3','4',52),(9150,6,11,575,'5','3','5',52),(9151,6,11,575,'5','3','6',52),(9152,6,11,575,'5','3','7',52),(9153,6,11,575,'5','3','8',52),(9154,6,11,575,'10','4','1',52),(9155,6,11,575,'10','4','2',52),(9156,6,11,575,'10','4','3',52),(9157,6,11,575,'10','4','4',52),(9158,6,11,575,'10','4','5',52),(9159,6,11,575,'10','4','6',52),(9160,6,11,575,'10','4','7',52),(9161,6,11,575,'1','4','8',52),(9162,6,11,575,'10','5','1',52),(9163,6,11,575,'10','5','2',52),(9164,6,11,575,'10','5','3',52),(9165,6,11,575,'10','5','4',52),(9166,6,11,575,'10','5','5',52),(9167,6,11,575,'10','5','6',52),(9168,6,11,575,'10','5','7',52),(9169,6,11,575,'1','5','8',52),(9170,6,11,575,'10','6','1',52),(9171,6,11,575,'10','6','2',52),(9172,6,11,575,'10','6','3',52),(9173,6,11,575,'10','6','4',52),(9174,6,11,575,'10','6','5',52),(9175,6,11,575,'10','6','6',52),(9176,6,11,575,'10','6','7',52),(9177,6,11,575,'7','6','8',52),(9178,6,11,575,'10','7','1',52),(9179,6,11,575,'10','7','2',52),(9180,6,11,575,'10','7','3',52),(9181,6,11,575,'10','7','4',52),(9182,6,11,575,'10','7','5',52),(9183,6,11,575,'10','7','6',52),(9184,6,11,575,'5','7','7',52),(9185,6,11,575,'4','7','8',52),(9186,6,11,577,'10','1','1',52),(9187,6,11,577,'10','1','2',52),(9188,6,11,577,'10','1','3',52),(9189,6,11,577,'10','1','4',52),(9190,6,11,577,'10','1','5',52),(9191,6,11,577,'10','1','6',52),(9192,6,11,577,'4','1','7',52),(9193,6,11,577,'5','1','8',52),(9194,6,11,577,'10','2','1',52),(9195,6,11,577,'10','2','2',52),(9196,6,11,577,'10','2','3',52),(9197,6,11,577,'10','2','4',52),(9198,6,11,577,'10','2','5',52),(9199,6,11,577,'10','2','6',52),(9200,6,11,577,'5','2','7',52),(9201,6,11,577,'4','2','8',52),(9202,6,11,577,'10','3','1',52),(9203,6,11,577,'10','3','2',52),(9204,6,11,577,'10','3','3',52),(9205,6,11,577,'10','3','4',52),(9206,6,11,577,'5','3','5',52),(9207,6,11,577,'5','3','6',52),(9208,6,11,577,'7','3','7',52),(9209,6,11,577,'5','3','8',52),(9210,6,11,577,'10','4','1',52),(9211,6,11,577,'10','4','2',52),(9212,6,11,577,'10','4','3',52),(9213,6,11,577,'10','4','4',52),(9214,6,11,577,'10','4','5',52),(9215,6,11,577,'10','4','6',52),(9216,6,11,577,'4','4','7',52),(9217,6,11,577,'4','4','8',52),(9218,6,11,577,'10','5','1',52),(9219,6,11,577,'10','5','2',52),(9220,6,11,577,'10','5','3',52),(9221,6,11,577,'10','5','4',52),(9222,6,11,577,'10','5','5',52),(9223,6,11,577,'4','5','6',52),(9224,6,11,577,'5','5','7',52),(9225,6,11,577,'10','5','8',52),(9226,6,11,577,'10','6','1',52),(9227,6,11,577,'10','6','2',52),(9228,6,11,577,'10','6','3',52),(9229,6,11,577,'10','6','4',52),(9230,6,11,577,'5','6','5',52),(9232,6,11,577,'4','6','6',52),(9233,6,11,577,'2','6','7',52),(9234,6,11,577,'1','6','8',52),(9235,6,11,577,'10','7','1',52),(9236,6,11,577,'10','7','2',52),(9237,6,11,577,'10','7','3',52),(9238,6,11,577,'5','7','4',52),(9239,6,11,577,'5','7','5',52),(9240,6,11,577,'4','7','6',52),(9241,6,11,577,'3','7','7',52),(9243,6,11,577,'5','7','8',52),(9244,6,11,578,'10','1','2',52),(9245,6,11,578,'10','1','1',52),(9246,6,11,578,'10','1','3',52),(9247,6,11,578,'10','1','4',52),(9248,6,11,578,'10','1','5',52),(9249,6,11,578,'10','1','6',52),(9250,6,11,578,'5','1','7',52),(9251,6,11,578,'5','1','8',52),(9252,6,11,578,'10','2','1',52),(9253,6,11,578,'10','2','2',52),(9254,6,11,578,'10','2','3',52),(9255,6,11,578,'10','2','4',52),(9256,6,11,578,'10','2','5',52),(9257,6,11,578,'10','2','6',52),(9258,6,11,578,'4','2','7',52),(9259,6,11,578,'4','2','8',52),(9260,6,11,578,'10','3','1',52),(9261,6,11,578,'10','3','2',52),(9262,6,11,578,'10','3','3',52),(9263,6,11,578,'10','3','4',52),(9264,6,11,578,'10','3','5',52),(9265,6,11,578,'10','3','6',52),(9266,6,11,578,'5','3','7',52),(9267,6,11,578,'4','3','8',52),(9268,6,11,578,'10','4','1',52),(9269,6,11,578,'10','4','2',52),(9270,6,11,578,'10','4','3',52),(9271,6,11,578,'10','4','4',52),(9272,6,11,578,'10','4','5',52),(9273,6,11,578,'10','4','6',52),(9274,6,11,578,'4','4','7',52),(9275,6,11,578,'3','4','8',52),(9276,6,11,578,'10','5','1',52),(9277,6,11,578,'10','5','2',52),(9278,6,11,578,'10','5','3',52),(9279,6,11,578,'10','5','4',52),(9280,6,11,578,'5','5','5',52),(9281,6,11,578,'5','5','6',52),(9282,6,11,578,'1','5','7',52),(9283,6,11,578,'1','5','8',52),(9284,6,11,578,'10','6','1',52),(9285,6,11,578,'10','6','2',52),(9286,6,11,578,'10','6','3',52),(9287,6,11,578,'10','6','4',52),(9288,6,11,578,'5','6','5',52),(9289,6,11,578,'5','6','6',52),(9290,6,11,578,'4','6','7',52),(9291,6,11,578,'4','6','8',52),(9292,6,11,578,'10','7','1',52),(9293,6,11,578,'10','7','2',52),(9294,6,11,578,'10','7','3',52),(9295,6,11,578,'10','7','4',52),(9296,6,11,578,'5','7','5',52),(9297,6,11,578,'2','7','6',52),(9298,6,11,578,'2','7','7',52),(9299,6,11,578,'5','7','8',52),(9300,6,11,580,'10','1','1',52),(9301,6,11,580,'10','1','2',52),(9302,6,11,580,'10','1','3',52),(9303,6,11,580,'5','1','4',52),(9304,6,11,580,'5','1','5',52),(9305,6,11,580,'5','1','6',52),(9307,6,11,580,'3','1','7',52),(9308,6,11,580,'2','1','8',52),(9309,6,11,580,'10','2','1',52),(9310,6,11,580,'10','2','2',52),(9311,6,11,580,'10','2','3',52),(9312,6,11,580,'10','2','4',52),(9313,6,11,580,'10','2','5',52),(9314,6,11,580,'5','2','6',52),(9315,6,11,580,'5','2','7',52),(9316,6,11,580,'1','2','8',52),(9317,6,11,580,'10','3','1',52),(9318,6,11,580,'10','3','2',52),(9319,6,11,580,'10','3','3',52),(9320,6,11,580,'10','3','4',52),(9321,6,11,580,'10','3','5',52),(9322,6,11,580,'5','3','6',52),(9323,6,11,580,'5','3','7',52),(9324,6,11,580,'7','3','8',52),(9325,6,11,580,'10','4','1',52),(9326,6,11,580,'10','4','2',52),(9327,6,11,580,'10','4','3',52),(9328,6,11,580,'10','4','4',52),(9329,6,11,580,'5','4','5',52),(9330,6,11,580,'5','4','6',52),(9331,6,11,580,'3','4','7',52),(9332,6,11,580,'3','4','8',52),(9333,6,11,580,'10','5','1',52),(9334,6,11,580,'10','5','2',52),(9335,6,11,580,'10','5','3',52),(9336,6,11,580,'10','5','4',52),(9337,6,11,580,'10','5','5',52),(9338,6,11,580,'10','5','6',52),(9339,6,11,580,'5','5','7',52),(9340,6,11,580,'5','5','8',52),(9341,6,11,580,'10','6','1',52),(9342,6,11,580,'10','6','2',52),(9343,6,11,580,'10','6','3',52),(9344,6,11,580,'10','6','4',52),(9345,6,11,580,'1','6','5',52),(9346,6,11,580,'5','6','6',52),(9347,6,11,580,'10','6','7',52),(9348,6,11,580,'5','6','8',52),(9349,6,11,580,'10','7','1',52),(9350,6,11,580,'10','7','2',52),(9351,6,11,580,'10','7','3',52),(9352,6,11,580,'10','7','4',52),(9353,6,11,580,'10','7','5',52),(9354,6,11,580,'4','7','6',52),(9355,6,11,580,'3','7','7',52),(9356,6,11,580,'10','7','8',52),(9357,6,11,582,'10','1','1',52),(9358,6,11,582,'10','1','2',52),(9359,6,11,582,'10','1','3',52),(9360,6,11,582,'10','1','4',52),(9361,6,11,582,'10','1','5',52),(9362,6,11,582,'5','1','6',52),(9363,6,11,582,'1','1','7',52),(9364,6,11,582,'5','1','8',52),(9365,6,11,582,'10','2','1',52),(9366,6,11,582,'10','2','2',52),(9367,6,11,582,'10','2','3',52),(9368,6,11,582,'10','2','4',52),(9369,6,11,582,'5','2','5',52),(9370,6,11,582,'4','2','6',52),(9371,6,11,582,'5','2','7',52),(9373,6,11,582,'4','2','8',52),(9374,6,11,582,'10','3','1',52),(9375,6,11,582,'10','3','2',52),(9376,6,11,582,'5','3','3',52),(9377,6,11,582,'5','3','4',52),(9378,6,11,582,'5','3','5',52),(9379,6,11,582,'5','3','6',52),(9380,6,11,582,'5','3','7',52),(9381,6,11,582,'10','3','8',52),(9382,6,11,582,'10','4','1',52),(9383,6,11,582,'10','4','2',52),(9384,6,11,582,'10','4','3',52),(9385,6,11,582,'10','4','4',52),(9386,6,11,582,'10','4','5',52),(9387,6,11,582,'4','4','6',52),(9389,6,11,582,'10','4','8',52),(9390,6,11,582,'4','4','7',52),(9391,6,11,582,'10','5','1',52),(9392,6,11,582,'10','5','2',52),(9393,6,11,582,'10','5','3',52),(9394,6,11,582,'10','5','4',52),(9395,6,11,582,'10','5','5',52),(9396,6,11,582,'5','5','6',52),(9397,6,11,582,'5','5','7',52),(9398,6,11,582,'2','5','8',52),(9399,6,11,582,'10','6','1',52),(9400,6,11,582,'10','6','2',52),(9401,6,11,582,'10','6','3',52),(9402,6,11,582,'10','6','4',52),(9403,6,11,582,'10','6','5',52),(9404,6,11,582,'5','6','6',52),(9405,6,11,582,'2','6','7',52),(9406,6,11,582,'5','6','8',52),(9407,6,11,582,'10','7','1',52),(9408,6,11,582,'10','7','2',52),(9409,6,11,582,'10','7','3',52),(9410,6,11,582,'5','7','4',52),(9412,6,11,582,'5','7','6',52),(9413,6,11,582,'5','7','5',52),(9414,6,11,582,'5','7','7',52),(9415,6,11,582,'3','7','8',52),(9416,6,11,584,'10','1','1',52),(9417,6,11,584,'10','1','2',52),(9418,6,11,584,'10','1','3',52),(9419,6,11,584,'10','1','4',52),(9420,6,11,584,'10','1','5',52),(9421,6,11,584,'10','1','6',52),(9422,6,11,584,'3','1','7',52),(9423,6,11,584,'3','1','8',52),(9424,6,11,584,'10','2','1',52),(9425,6,11,584,'10','2','2',52),(9426,6,11,584,'10','2','3',52),(9427,6,11,584,'4','2','5',52),(9428,6,11,584,'5','2','6',52),(9429,6,11,584,'5','2','7',52),(9430,6,11,584,'4','2','8',52),(9431,6,11,584,'10','2','4',52),(9432,6,11,584,'10','3','1',52),(9433,6,11,584,'10','3','2',52),(9434,6,11,584,'10','3','3',52),(9435,6,11,584,'10','3','4',52),(9436,6,11,584,'5','3','5',52),(9437,6,11,584,'5','3','6',52),(9438,6,11,584,'5','3','7',52),(9439,6,11,584,'5','3','8',52),(9440,6,11,584,'10','4','1',52),(9441,6,11,584,'10','4','2',52),(9442,6,11,584,'10','4','3',52),(9443,6,11,584,'5','4','4',52),(9444,6,11,584,'10','4','5',52),(9445,6,11,584,'10','4','6',52),(9446,6,11,584,'5','4','7',52),(9447,6,11,584,'5','4','8',52),(9448,6,11,584,'10','5','1',52),(9449,6,11,584,'10','5','2',52),(9450,6,11,584,'10','5','3',52),(9451,6,11,584,'5','5','4',52),(9452,6,11,584,'5','5','5',52),(9453,6,11,584,'3','5','6',52),(9454,6,11,584,'3','5','7',52),(9455,6,11,584,'3','5','8',52),(9456,6,11,584,'10','6','1',52),(9457,6,11,584,'10','6','2',52),(9458,6,11,584,'10','6','3',52),(9459,6,11,584,'10','6','4',52),(9460,6,11,584,'10','6','5',52),(9461,6,11,584,'5','6','6',52),(9462,6,11,584,'5','6','7',52),(9463,6,11,584,'1','6','8',52),(9464,6,11,584,'10','7','1',52),(9465,6,11,584,'10','7','2',52),(9466,6,11,584,'10','7','3',52),(9467,6,11,584,'10','7','4',52),(9468,6,11,584,'5','7','5',52),(9469,6,11,584,'5','7','6',52),(9470,6,11,584,'2','7','7',52),(9471,6,11,584,'3','7','8',52),(9472,6,11,587,'1','1','1',52),(9473,6,11,587,'10','1','2',52),(9474,6,11,587,'10','1','3',52),(9475,6,11,587,'10','1','4',52),(9476,6,11,587,'5','1','5',52),(9477,6,11,587,'5','1','6',52),(9478,6,11,587,'3','1','7',52),(9479,6,11,587,'3','1','8',52),(9480,6,11,587,'10','2','1',52),(9481,6,11,587,'10','2','2',52),(9482,6,11,587,'5','2','3',52),(9483,6,11,587,'5','2','4',52),(9484,6,11,587,'5','2','5',52),(9485,6,11,587,'5','2','6',52),(9486,6,11,587,'2','2','7',52),(9487,6,11,587,'1','2','8',52),(9488,6,11,587,'10','3','1',52),(9489,6,11,587,'10','3','2',52),(9490,6,11,587,'10','3','3',52),(9491,6,11,587,'10','3','4',52),(9492,6,11,587,'10','3','5',52),(9493,6,11,587,'10','3','6',52),(9494,6,11,587,'10','3','7',52),(9495,6,11,587,'3','3','8',52),(9496,6,11,587,'10','4','1',52),(9497,6,11,587,'10','4','2',52),(9498,6,11,587,'10','4','3',52),(9499,6,11,587,'10','4','4',52),(9501,6,11,587,'5','4','6',52),(9502,6,11,587,'5','4','7',52),(9503,6,11,587,'5','4','5',52),(9504,6,11,587,'5','4','8',52),(9505,6,11,587,'5','5','1',52),(9506,6,11,587,'10','5','2',52),(9507,6,11,587,'10','5','3',52),(9508,6,11,587,'10','5','4',52),(9509,6,11,587,'10','5','5',52),(9510,6,11,587,'10','5','6',52),(9511,6,11,587,'5','5','7',52),(9512,6,11,587,'2','5','8',52),(9513,6,11,587,'10','6','1',52),(9514,6,11,587,'10','6','2',52),(9515,6,11,587,'10','6','3',52),(9516,6,11,587,'10','6','4',52),(9517,6,11,587,'5','6','5',52),(9518,6,11,587,'5','6','6',52),(9519,6,11,587,'4','6','7',52),(9520,6,11,587,'3','6','8',52),(9521,6,11,587,'10','7','1',52),(9522,6,11,587,'10','7','2',52),(9523,6,11,587,'10','7','3',52),(9524,6,11,587,'5','7','4',52),(9525,6,11,587,'5','7','5',52),(9526,6,11,587,'5','7','6',52),(9527,6,11,587,'5','7','7',52),(9528,6,11,587,'5','7','8',52),(9529,6,11,588,'10','1','2',52),(9530,6,11,588,'10','1','1',52),(9531,6,11,588,'10','1','3',52),(9532,6,11,588,'10','1','4',52),(9533,6,11,588,'10','1','5',52),(9534,6,11,588,'10','1','6',52),(9535,6,11,588,'4','1','7',52),(9536,6,11,588,'3','1','8',52),(9537,6,11,588,'10','2','1',52),(9538,6,11,588,'10','2','2',52),(9539,6,11,588,'10','2','3',52),(9540,6,11,588,'5','2','4',52),(9541,6,11,588,'5','2','5',52),(9542,6,11,588,'5','2','6',52),(9543,6,11,588,'5','2','7',52),(9544,6,11,588,'1','2','8',52),(9545,6,11,588,'10','3','1',52),(9546,6,11,588,'10','3','2',52),(9547,6,11,588,'10','3','3',52),(9548,6,11,588,'6','3','4',52),(9549,6,11,588,'5','3','5',52),(9550,6,11,588,'5','3','6',52),(9551,6,11,588,'5','3','7',52),(9552,6,11,588,'5','3','8',52),(9553,6,11,588,'10','4','1',52),(9554,6,11,588,'10','4','2',52),(9555,6,11,588,'5','4','3',52),(9556,6,11,588,'5','4','4',52),(9557,6,11,588,'5','4','5',52),(9558,6,11,588,'5','4','6',52),(9559,6,11,588,'5','4','7',52),(9560,6,11,588,'5','4','8',52),(9561,6,11,588,'10','5','1',52),(9562,6,11,588,'10','5','2',52),(9563,6,11,588,'10','5','3',52),(9564,6,11,588,'10','5','4',52),(9565,6,11,588,'10','5','5',52),(9566,6,11,588,'5','5','6',52),(9567,6,11,588,'1','5','7',52),(9568,6,11,588,'5','5','8',52),(9569,6,11,588,'10','6','1',52),(9570,6,11,588,'10','6','2',52),(9571,6,11,588,'10','6','3',52),(9572,6,11,588,'5','6','4',52),(9573,6,11,588,'5','6','5',52),(9574,6,11,588,'5','6','6',52),(9575,6,11,588,'2','6','7',52),(9576,6,11,588,'2','6','8',52),(9577,6,11,588,'10','7','1',52),(9578,6,11,588,'10','7','2',52),(9579,6,11,588,'10','7','3',52),(9580,6,11,588,'10','7','4',52),(9581,6,11,588,'10','7','5',52),(9582,6,11,588,'5','7','6',52),(9583,6,11,588,'5','7','7',52),(9584,6,11,588,'4','7','8',52),(9585,6,11,595,'5','1','1',52),(9586,6,11,595,'5','1','2',52),(9587,6,11,595,'4','1','3',52),(9588,6,11,595,'3','1','4',52),(9589,6,11,595,'5','1','5',52),(9590,6,11,595,'3','1','6',52),(9591,6,11,595,'2','1','7',52),(9592,6,11,595,'1','1','8',52),(9593,6,11,595,'10','2','1',52),(9594,6,11,595,'10','2','2',52),(9595,6,11,595,'10','2','3',52),(9596,6,11,595,'10','2','4',52),(9597,6,11,595,'10','2','5',52),(9598,6,11,595,'5','2','6',52),(9599,6,11,595,'5','2','7',52),(9600,6,11,595,'1','2','8',52),(9601,6,11,595,'10','3','1',52),(9602,6,11,595,'5','3','2',52),(9603,6,11,595,'5','3','3',52),(9604,6,11,595,'4','3','4',52),(9605,6,11,595,'4','3','5',52),(9606,6,11,595,'3','3','6',52),(9607,6,11,595,'1','3','7',52),(9608,6,11,595,'1','3','8',52),(9609,6,11,595,'10','4','1',52),(9610,6,11,595,'10','4','2',52),(9611,6,11,595,'10','4','3',52),(9612,6,11,595,'10','4','4',52),(9613,6,11,595,'10','4','5',52),(9614,6,11,595,'5','4','6',52),(9615,6,11,595,'6','4','7',52),(9616,6,11,595,'5','4','8',52),(9617,6,11,595,'10','5','1',52),(9618,6,11,595,'10','5','2',52),(9619,6,11,595,'10','5','3',52),(9620,6,11,595,'10','5','4',52),(9621,6,11,595,'10','5','5',52),(9622,6,11,595,'10','5','6',52),(9623,6,11,595,'10','5','7',52),(9624,6,11,595,'3','5','8',52),(9625,6,11,595,'10','6','1',52),(9626,6,11,595,'10','6','2',52),(9627,6,11,595,'10','6','3',52),(9628,6,11,595,'10','6','4',52),(9629,6,11,595,'10','6','5',52),(9630,6,11,595,'5','6','6',52),(9631,6,11,595,'5','6','7',52),(9632,6,11,595,'8','6','8',52),(9633,6,11,595,'8','7','1',52),(9634,6,11,595,'10','7','2',52),(9635,6,11,595,'10','7','3',52),(9636,6,11,595,'10','7','4',52),(9637,6,11,595,'5','7','5',52),(9638,6,11,595,'10','7','6',52),(9639,6,11,595,'10','7','7',52),(9640,6,11,595,'5','7','8',52),(9641,6,11,597,'10','1','2',52),(9642,6,11,597,'10','1','1',52),(9643,6,11,597,'10','1','3',52),(9644,6,11,597,'10','1','4',52),(9645,6,11,597,'5','1','5',52),(9646,6,11,597,'5','1','6',52),(9647,6,11,597,'4','1','7',52),(9648,6,11,597,'4','1','8',52),(9649,6,11,597,'10','2','1',52),(9650,6,11,597,'10','2','2',52),(9651,6,11,597,'5','2','3',52),(9652,6,11,597,'5','2','4',52),(9653,6,11,597,'10','2','5',52),(9654,6,11,597,'10','2','6',52),(9655,6,11,597,'3','2','7',52),(9656,6,11,597,'3','2','8',52),(9657,6,11,597,'10','3','1',52),(9658,6,11,597,'10','3','2',52),(9659,6,11,597,'10','3','3',52),(9660,6,11,597,'10','3','4',52),(9661,6,11,597,'4','3','5',52),(9662,6,11,597,'5','3','6',52),(9663,6,11,597,'3','3','7',52),(9664,6,11,597,'5','3','8',52),(9665,6,11,597,'10','4','1',52),(9666,6,11,597,'10','4','2',52),(9667,6,11,597,'10','4','3',52),(9668,6,11,597,'6','4','5',52),(9669,6,11,597,'10','4','4',52),(9670,6,11,597,'5','4','6',52),(9671,6,11,597,'3','4','7',52),(9672,6,11,597,'5','4','8',52),(9673,6,11,597,'10','5','1',52),(9674,6,11,597,'10','5','2',52),(9675,6,11,597,'10','5','3',52),(9676,6,11,597,'10','5','4',52),(9677,6,11,597,'10','5','5',52),(9678,6,11,597,'10','5','6',52),(9679,6,11,597,'2','5','7',52),(9680,6,11,597,'2','5','8',52),(9681,6,11,597,'10','6','1',52),(9682,6,11,597,'10','6','2',52),(9683,6,11,597,'5','6','3',52),(9684,6,11,597,'5','6','5',52),(9685,6,11,597,'5','6','6',52),(9686,6,11,597,'2','6','7',52),(9687,6,11,597,'1','6','8',52),(9688,6,11,597,'10','7','1',52),(9689,6,11,597,'10','7','2',52),(9690,6,11,597,'10','7','3',52),(9691,6,11,597,'5','7','4',52),(9692,6,11,597,'5','7','5',52),(9693,6,11,597,'5','7','6',52),(9694,6,11,597,'3','7','7',52),(9695,6,11,597,'5','7','8',52),(9696,6,11,599,'3','1','1',52),(9699,6,11,599,'5','1','4',52),(9700,6,11,599,'7','1','5',52),(9701,6,11,599,'2','1','6',52),(9702,6,11,599,'1','1','7',52),(9703,6,11,599,'2','1','2',52),(9704,6,11,599,'3','1','3',52),(9705,6,11,599,'5','1','8',52),(9706,6,11,599,'10','2','1',52),(9707,6,11,599,'10','2','2',52),(9708,6,11,599,'10','2','3',52),(9709,6,11,599,'10','2','4',52),(9710,6,11,599,'10','2','5',52),(9711,6,11,599,'5','2','6',52),(9712,6,11,599,'6','2','7',52),(9713,6,11,599,'5','2','8',52),(9714,6,11,599,'10','3','1',52),(9715,6,11,599,'10','3','2',52),(9716,6,11,599,'5','3','3',52),(9717,6,11,599,'5','3','4',52),(9718,6,11,599,'5','3','5',52),(9719,6,11,599,'3','3','6',52),(9720,6,11,599,'3','3','7',52),(9721,6,11,599,'5','3','8',52),(9722,6,11,599,'10','4','1',52),(9723,6,11,599,'10','4','2',52),(9724,6,11,599,'10','4','3',52),(9725,6,11,599,'5','4','4',52),(9726,6,11,599,'5','4','5',52),(9727,6,11,599,'5','4','6',52),(9728,6,11,599,'5','4','7',52),(9729,6,11,599,'1','4','8',52),(9730,6,11,599,'10','5','1',52),(9731,6,11,599,'10','5','2',52),(9732,6,11,599,'10','5','3',52),(9733,6,11,599,'5','5','4',52),(9734,6,11,599,'5','5','5',52),(9735,6,11,599,'5','5','6',52),(9737,6,11,599,'5','5','8',52),(9738,6,11,599,'8','5','7',52),(9739,6,11,599,'10','6','2',52),(9740,6,11,599,'10','6','3',52),(9741,6,11,599,'10','6','4',52),(9742,6,11,599,'10','6','5',52),(9743,6,11,599,'5','6','6',52),(9744,6,11,599,'5','6','7',52),(9745,6,11,599,'3','6','8',52),(9746,6,11,599,'10','7','1',52),(9747,6,11,599,'10','7','2',52),(9749,6,11,599,'5','7','3',52),(9750,6,11,599,'5','7','4',52),(9752,6,11,599,'10','7','6',52),(9753,6,11,599,'10','7','7',52),(9754,6,11,599,'2','7','8',52),(9755,6,11,599,'10','7','5',52),(9756,6,11,600,'10','1','1',52),(9757,6,11,600,'10','1','2',52),(9758,6,11,600,'10','1','3',52),(9759,6,11,600,'10','1','4',52),(9760,6,11,600,'10','1','5',52),(9761,6,11,600,'10','1','6',52),(9762,6,11,600,'5','1','7',52),(9763,6,11,600,'5','1','8',52),(9764,6,11,600,'10','2','1',52),(9765,6,11,600,'5','2','2',52),(9766,6,11,600,'5','2','3',52),(9767,6,11,600,'4','2','4',52),(9768,6,11,600,'2','2','5',52),(9769,6,11,600,'3','2','6',52),(9770,6,11,600,'1','2','7',52),(9771,6,11,600,'3','2','8',52),(9772,6,11,600,'10','3','1',52),(9773,6,11,600,'10','3','2',52),(9774,6,11,600,'5','3','3',52),(9775,6,11,600,'4','3','4',52),(9776,6,11,600,'6','3','5',52),(9777,6,11,600,'7','3','6',52),(9778,6,11,600,'2','3','7',52),(9779,6,11,600,'2','3','8',52),(9780,6,11,600,'4','4','1',52),(9781,6,11,600,'6','4','2',52),(9782,6,11,600,'5','4','3',52),(9783,6,11,600,'7','4','4',52),(9784,6,11,600,'10','4','5',52),(9785,6,11,600,'2','4','7',52),(9786,6,11,600,'10','4','8',52),(9787,6,11,600,'2','4','6',52),(9788,6,11,600,'10','5','1',52),(9789,6,11,600,'4','5','2',52),(9790,6,11,600,'2','5','3',52),(9791,6,11,600,'5','5','4',52),(9792,6,11,600,'3','5','5',52),(9793,6,11,600,'5','5','6',52),(9794,6,11,600,'2','5','7',52),(9795,6,11,600,'1','5','8',52),(9796,6,11,600,'10','6','1',52),(9797,6,11,600,'10','6','2',52),(9798,6,11,600,'10','6','3',52),(9799,6,11,600,'10','6','4',52),(9800,6,11,600,'10','6','5',52),(9801,6,11,600,'5','6','6',52),(9802,6,11,600,'5','6','7',52),(9803,6,11,600,'3','6','8',52),(9804,6,11,600,'10','7','1',52),(9805,6,11,600,'10','7','2',52),(9806,6,11,600,'10','7','3',52),(9807,6,11,600,'5','7','4',52),(9808,6,11,600,'5','7','5',52),(9809,6,11,600,'5','7','6',52),(9810,6,11,600,'5','7','7',52),(9811,6,11,600,'5','7','8',52),(9812,6,11,601,'10','1','1',52),(9813,6,11,601,'3','1','2',52),(9814,6,11,601,'2','1','3',52),(9815,6,11,601,'6','1','4',52),(9816,6,11,601,'8','1','5',52),(9817,6,11,601,'2','1','6',52),(9818,6,11,601,'1','1','7',52),(9819,6,11,601,'2','1','8',52),(9820,6,11,601,'10','2','2',52),(9821,6,11,601,'10','2','3',52),(9822,6,11,601,'10','2','4',52),(9823,6,11,601,'5','2','5',52),(9824,6,11,601,'5','2','6',52),(9825,6,11,601,'4','2','7',52),(9826,6,11,601,'4','2','8',52),(9827,6,11,601,'10','3','1',52),(9828,6,11,601,'2','3','2',52),(9829,6,11,601,'9','3','3',52),(9830,6,11,601,'4','3','4',52),(9831,6,11,601,'5','3','5',52),(9832,6,11,601,'2','3','6',52),(9833,6,11,601,'1','3','7',52),(9834,6,11,601,'4','3','8',52),(9835,6,11,601,'10','4','1',52),(9836,6,11,601,'5','4','2',52),(9837,6,11,601,'5','4','3',52),(9838,6,11,601,'10','4','4',52),(9839,6,11,601,'5','4','5',52),(9840,6,11,601,'5','4','6',52),(9841,6,11,601,'3','4','7',52),(9842,6,11,601,'10','4','8',52),(9843,6,11,601,'6','5','1',52),(9844,6,11,601,'9','5','2',52),(9845,6,11,601,'2','5','3',52),(9846,6,11,601,'10','5','4',52),(9847,6,11,601,'2','5','5',52),(9848,6,11,601,'1','5','6',52),(9849,6,11,601,'3','5','7',52),(9850,6,11,601,'1','5','8',52),(9851,6,11,601,'10','6','1',52),(9852,6,11,601,'10','6','2',52),(9853,6,11,601,'10','6','3',52),(9854,6,11,601,'10','6','4',52),(9855,6,11,601,'10','6','5',52),(9856,6,11,601,'5','6','6',52),(9857,6,11,601,'4','6','7',52),(9858,6,11,601,'1','6','8',52),(9859,6,11,601,'4','7','1',52),(9860,6,11,601,'5','7','2',52),(9861,6,11,601,'10','7','3',52),(9862,6,11,601,'10','7','4',52),(9863,6,11,601,'3','7','5',52),(9864,6,11,601,'5','7','6',52),(9865,6,11,601,'10','7','7',52),(9866,6,11,601,'10','7','8',52),(9867,10,11,250,'10','4','1',49),(9868,10,11,250,'10','4','2',49),(9869,10,11,250,'10','4','3',49),(9870,10,11,250,'10','4','4',49),(9871,10,11,250,'10','4','5',49),(9872,10,11,250,'10','4','6',49),(9873,10,11,250,'10','4','7',49),(9874,10,11,250,'9','4','8',49),(9875,10,11,250,'10','5','1',49),(9876,10,11,250,'10','5','2',49),(9877,10,11,250,'10','5','3',49),(9878,10,11,250,'10','5','4',49),(9879,10,11,250,'10','5','5',49),(9880,10,11,250,'10','5','6',49),(9881,10,11,250,'10','5','7',49),(9882,10,11,250,'3','5','8',49),(9883,10,11,250,'10','6','1',49),(9884,10,11,250,'10','6','2',49),(9885,10,11,250,'10','6','3',49),(9886,10,11,250,'10','6','4',49),(9887,10,11,250,'10','6','6',49),(9889,10,11,250,'9','6','7',49),(9890,10,11,250,'10','6','5',49),(9891,10,11,250,'10','7','1',49),(9892,10,11,250,'10','7','2',49),(9893,10,11,250,'10','7','3',49),(9894,10,11,250,'10','7','4',49),(9895,10,11,250,'10','7','5',49),(9896,10,11,250,'10','7','6',49),(9897,10,11,250,'10','7','7',49),(9898,10,11,250,'7','7','8',49),(9899,10,11,251,'10','1','1',49),(9900,10,11,251,'10','1','2',49),(9901,10,11,251,'10','1','3',49),(9902,10,11,251,'10','1','4',49),(9903,10,11,251,'10','1','5',49),(9904,10,11,251,'10','1','6',49),(9905,10,11,251,'9','1','7',49),(9906,10,11,251,'10','2','1',49),(9907,10,11,251,'10','2','2',49),(9908,10,11,251,'10','2','3',49),(9909,10,11,251,'10','2','4',49),(9910,10,11,251,'10','2','5',49),(9911,10,11,251,'10','2','6',49),(9912,10,11,251,'10','2','7',49),(9913,10,11,251,'9','2','8',49),(9914,10,11,251,'10','3','1',49),(9915,10,11,251,'10','3','2',49),(9916,10,11,251,'10','3','3',49),(9917,10,11,251,'10','3','4',49),(9918,10,11,251,'10','3','5',49),(9919,10,11,251,'10','3','6',49),(9920,10,11,251,'10','3','7',49),(9921,10,11,251,'5','3','8',49),(9922,10,11,251,'10','4','1',49),(9923,10,11,251,'10','4','2',49),(9924,10,11,251,'10','4','3',49),(9925,10,11,251,'10','4','4',49),(9926,10,11,251,'10','4','5',49),(9927,10,11,251,'10','4','6',49),(9928,10,11,251,'10','4','7',49),(9929,10,11,251,'1','4','9',49),(9930,10,11,251,'10','4','8',49),(9931,10,11,251,'10','5','1',49),(9932,10,11,251,'10','5','2',49),(9933,10,11,251,'10','5','3',49),(9934,10,11,251,'10','5','4',49),(9935,10,11,251,'10','5','5',49),(9936,10,11,251,'10','5','6',49),(9937,10,11,251,'10','5','7',49),(9938,10,11,251,'10','6','1',49),(9939,10,11,251,'10','6','2',49),(9940,10,11,251,'10','6','3',49),(9941,10,11,251,'10','6','4',49),(9942,10,11,251,'10','6','5',49),(9943,10,11,251,'10','6','6',49),(9944,10,11,251,'10','6','7',49),(9945,10,11,251,'6','6','8',49),(9946,10,11,251,'10','7','1',49),(9947,10,11,251,'10','7','2',49),(9948,10,11,251,'10','7','3',49),(9949,10,11,251,'10','7','4',49),(9950,10,11,251,'10','7','5',49),(9951,10,11,251,'10','7','6',49),(9952,10,11,251,'6','7','7',49),(9953,10,11,252,'10','1','1',49),(9954,10,11,252,'10','1','2',49),(9955,10,11,252,'10','1','3',49),(9956,10,11,252,'10','1','4',49),(9957,10,11,252,'10','1','5',49),(9958,10,11,252,'10','1','6',49),(9959,10,11,252,'10','1','7',49),(9960,10,11,252,'6','1','8',49),(9961,10,11,252,'10','2','1',49),(9962,10,11,252,'10','2','2',49),(9963,10,11,252,'10','2','3',49),(9964,10,11,252,'10','2','4',49),(9965,10,11,252,'10','2','5',49),(9966,10,11,252,'10','2','7',49),(9967,10,11,252,'8','2','8',49),(9968,10,11,252,'10','2','6',49),(9969,10,11,252,'10','3','1',49),(9970,10,11,252,'10','3','2',49),(9971,10,11,252,'10','3','3',49),(9972,10,11,252,'10','3','4',49),(9973,10,11,252,'10','3','5',49),(9974,10,11,252,'10','3','6',49),(9975,10,11,252,'10','3','7',49),(9976,10,11,252,'1','3','8',49),(9977,5,11,394,'10','1','1',54),(9978,5,11,394,'10','1','2',54),(9979,5,11,394,'10','1','3',54),(9980,10,11,252,'10','4','1',49),(9981,5,11,394,'10','1','4',54),(9982,5,11,394,'10','1','5',54),(9983,10,11,252,'10','4','2',49),(9984,5,11,394,'10','1','6',54),(9985,10,11,252,'10','4','3',49),(9986,5,11,394,'10','1','7',54),(9987,10,11,252,'10','4','4',49),(9988,10,11,252,'10','4','5',49),(9989,5,11,394,'10','1','8',54),(9990,10,11,252,'10','4','6',49),(9991,5,11,394,'7','1','9',54),(9992,10,11,252,'10','4','7',49),(9993,5,11,394,'10','2','1',54),(9994,5,11,394,'10','2','2',54),(9995,10,11,252,'2','4','8',49),(9996,5,11,394,'10','2','3',54),(9997,5,11,394,'10','2','4',54),(9998,5,11,394,'10','2','5',54),(9999,10,11,252,'10','5','1',49),(10000,5,11,394,'10','2','6',54),(10001,10,11,252,'10','5','2',49),(10002,5,11,394,'10','2','7',54),(10003,10,11,252,'10','5','3',49),(10004,10,11,252,'10','5','4',49),(10005,5,11,394,'6','2','9',54),(10006,10,11,252,'10','5','5',49),(10007,10,11,252,'10','5','6',49),(10008,5,11,394,'10','2','8',54),(10009,10,11,252,'10','5','7',49),(10010,5,11,394,'10','3','1',54),(10011,10,11,252,'3','5','8',49),(10012,5,11,394,'10','3','2',54),(10013,5,11,394,'10','3','3',54),(10014,10,11,252,'10','6','1',49),(10015,5,11,394,'10','3','4',54),(10016,10,11,252,'10','6','2',49),(10017,5,11,394,'10','3','5',54),(10018,10,11,252,'10','6','3',49),(10019,5,11,394,'10','3','6',54),(10020,10,11,252,'10','6','4',49),(10021,5,11,394,'10','3','7',54),(10022,10,11,252,'10','6','5',49),(10023,5,11,394,'10','3','8',54),(10024,5,11,394,'3','3','9',54),(10025,5,11,394,'10','4','1',54),(10026,5,11,394,'10','4','2',54),(10027,10,11,252,'10','6','6',49),(10028,5,11,394,'10','4','3',54),(10029,5,11,394,'10','4','4',54),(10030,10,11,252,'10','6','7',49),(10031,5,11,394,'10','4','5',54),(10032,10,11,252,'1','6','8',49),(10033,5,11,394,'10','4','6',54),(10034,5,11,394,'10','4','7',54),(10035,5,11,394,'5','4','9',54),(10036,5,11,394,'10','4','8',54),(10037,5,11,394,'10','5','1',54),(10038,5,11,394,'10','5','2',54),(10039,5,11,394,'10','5','3',54),(10040,5,11,394,'10','5','4',54),(10041,10,11,252,'10','7','1',49),(10042,5,11,394,'10','5','5',54),(10043,10,11,252,'10','7','2',49),(10044,5,11,394,'10','5','6',54),(10045,10,11,252,'10','7','3',49),(10046,5,11,394,'10','5','7',54),(10047,10,11,252,'10','7','4',49),(10048,5,11,394,'10','5','8',54),(10049,10,11,252,'10','7','5',49),(10050,5,11,394,'6','5','9',54),(10051,10,11,252,'10','7','6',49),(10052,10,11,252,'10','7','7',49),(10053,5,11,394,'10','6','1',54),(10054,5,11,394,'10','6','2',54),(10055,5,11,394,'10','6','3',54),(10056,5,11,394,'10','6','4',54),(10057,5,11,394,'10','6','5',54),(10058,5,11,394,'10','6','6',54),(10059,5,11,394,'10','6','7',54),(10060,5,11,394,'10','6','8',54),(10061,5,11,394,'6','6','9',54),(10062,5,11,394,'10','7','1',54),(10063,5,11,394,'10','7','2',54),(10064,10,11,252,'4','7','8',49),(10065,5,11,394,'10','7','3',54),(10066,5,11,394,'10','7','4',54),(10067,5,11,394,'10','7','5',54),(10068,5,11,394,'10','7','6',54),(10069,5,11,394,'10','7','7',54),(10070,5,11,394,'10','7','8',54),(10071,5,11,394,'9','7','9',54),(10072,5,11,397,'10','1','1',54),(10073,5,11,397,'10','1','2',54),(10074,5,11,397,'10','1','3',54),(10075,5,11,397,'10','1','4',54),(10076,5,11,397,'10','1','5',54),(10077,5,11,397,'10','1','6',54),(10078,5,11,397,'10','1','7',54),(10079,5,11,397,'10','1','8',54),(10080,5,11,397,'4','1','9',54),(10081,5,11,397,'10','2','1',54),(10082,5,11,397,'10','2','2',54),(10083,5,11,397,'10','2','3',54),(10084,5,11,397,'10','2','4',54),(10085,5,11,397,'10','2','5',54),(10086,5,11,397,'10','2','6',54),(10087,5,11,397,'10','2','7',54),(10088,5,11,397,'10','2','8',54),(10089,5,11,397,'4','2','9',54),(10090,5,11,397,'10','3','1',54),(10091,5,11,397,'10','3','2',54),(10092,5,11,397,'10','3','3',54),(10093,5,11,397,'10','3','4',54),(10094,5,11,397,'10','3','5',54),(10095,5,11,397,'10','3','6',54),(10096,5,11,397,'10','3','7',54),(10097,5,11,397,'10','3','8',54),(10098,5,11,397,'5','3','9',54),(10099,5,11,397,'10','4','1',54),(10100,5,11,397,'10','4','2',54),(10101,5,11,397,'10','4','3',54),(10102,5,11,397,'10','4','4',54),(10103,5,11,397,'10','4','5',54),(10104,5,11,397,'10','4','6',54),(10105,5,11,397,'10','4','7',54),(10106,5,11,397,'10','4','8',54),(10107,5,11,397,'4','4','9',54),(10108,5,11,397,'10','5','1',54),(10109,5,11,397,'10','5','2',54),(10110,5,11,397,'10','5','3',54),(10111,5,11,397,'10','5','4',54),(10112,5,11,397,'10','5','5',54),(10113,5,11,397,'10','5','6',54),(10114,5,11,397,'10','5','7',54),(10115,5,11,397,'10','5','8',54),(10116,5,11,397,'8','5','9',54),(10117,5,11,397,'10','6','1',54),(10118,5,11,397,'10','6','2',54),(10119,5,11,397,'10','6','3',54),(10120,5,11,397,'10','6','4',54),(10121,5,11,397,'10','6','5',54),(10122,5,11,397,'10','6','6',54),(10123,5,11,397,'10','6','7',54),(10124,5,11,397,'10','6','8',54),(10125,5,11,397,'5','6','9',54),(10126,5,11,397,'10','7','1',54),(10127,5,11,397,'10','7','2',54),(10128,5,11,397,'10','7','3',54),(10129,5,11,397,'10','7','4',54),(10130,5,11,397,'10','7','5',54),(10131,5,11,397,'10','7','6',54),(10132,5,11,397,'10','7','7',54),(10133,5,11,397,'10','7','8',54),(10134,5,11,397,'4','7','9',54),(10135,10,11,253,'10','1','1',49),(10136,10,11,253,'10','1','2',49),(10137,10,11,253,'10','1','3',49),(10138,10,11,253,'10','1','4',49),(10139,10,11,253,'10','1','5',49),(10140,10,11,253,'10','1','6',49),(10141,10,11,253,'10','1','7',49),(10142,10,11,253,'4','1','8',49),(10143,5,11,398,'10','1','1',54),(10144,5,11,398,'10','1','2',54),(10145,5,11,398,'10','1','3',54),(10146,10,11,253,'10','2','1',49),(10147,5,11,398,'10','1','4',54),(10148,10,11,253,'10','2','2',49),(10149,5,11,398,'10','1','5',54),(10150,10,11,253,'10','2','3',49),(10151,5,11,398,'10','1','6',54),(10152,10,11,253,'10','2','4',49),(10153,5,11,398,'10','1','7',54),(10154,10,11,253,'10','2','5',49),(10155,5,11,398,'10','1','8',54),(10156,5,11,398,'3','1','9',54),(10157,10,11,253,'10','2','6',49),(10158,10,11,253,'10','2','7',49),(10159,5,11,398,'10','2','1',54),(10160,5,11,398,'10','2','2',54),(10161,10,11,253,'3','2','8',49),(10162,5,11,398,'10','2','3',54),(10163,5,11,398,'10','2','4',54),(10164,5,11,398,'10','2','5',54),(10165,5,11,398,'10','2','6',54),(10166,10,11,253,'10','3','1',49),(10167,5,11,398,'10','2','7',54),(10168,5,11,398,'10','2','8',54),(10169,5,11,398,'7','2','9',54),(10170,10,11,253,'10','3','2',49),(10171,5,11,398,'10','3','1',54),(10172,10,11,253,'10','3','3',49),(10173,5,11,398,'10','3','2',54),(10174,10,11,253,'10','3','4',49),(10175,5,11,398,'10','3','3',54),(10176,5,11,398,'10','3','4',54),(10177,10,11,253,'10','3','5',49),(10178,5,11,398,'10','3','5',54),(10179,10,11,253,'10','3','6',49),(10180,5,11,398,'10','3','6',54),(10181,5,11,398,'10','3','7',54),(10182,5,11,398,'10','3','8',54),(10183,5,11,398,'3','3','9',54),(10184,5,11,398,'10','4','1',54),(10185,5,11,398,'10','4','2',54),(10186,10,11,253,'10','4','1',49),(10187,5,11,398,'10','4','3',54),(10188,5,11,398,'10','4','4',54),(10189,10,11,253,'10','4','2',49),(10190,5,11,398,'10','4','5',54),(10191,10,11,253,'10','4','3',49),(10192,5,11,398,'10','4','6',54),(10193,10,11,253,'10','4','4',49),(10194,5,11,398,'10','4','7',54),(10195,10,11,253,'10','4','5',49),(10196,5,11,398,'10','4','8',54),(10197,10,11,253,'10','4','6',49),(10198,5,11,398,'5','4','9',54),(10200,5,11,398,'10','5','1',54),(10201,5,11,398,'10','5','2',54),(10203,5,11,398,'10','5','3',54),(10204,5,11,398,'10','5','4',54),(10205,5,11,398,'10','5','5',54),(10206,5,11,398,'10','5','6',54),(10207,5,11,398,'10','5','7',54),(10208,5,11,398,'10','5','8',54),(10209,5,11,398,'3','5','9',54),(10210,5,11,398,'10','6','1',54),(10211,5,11,398,'10','6','2',54),(10212,5,11,398,'10','6','3',54),(10213,5,11,398,'10','6','4',54),(10214,5,11,398,'10','6','5',54),(10215,5,11,398,'10','6','6',54),(10216,5,11,398,'10','6','7',54),(10217,5,11,398,'10','6','8',54),(10218,5,11,398,'1','6','9',54),(10219,5,11,398,'10','7','1',54),(10220,10,11,253,'10','3','7',49),(10221,5,11,398,'10','7','2',54),(10222,5,11,398,'10','7','3',54),(10223,5,11,398,'10','7','4',54),(10224,10,11,253,'3','3','8',49),(10225,5,11,398,'10','7','5',54),(10226,5,11,398,'10','7','6',54),(10227,5,11,398,'10','7','7',54),(10228,5,11,398,'10','7','8',54),(10229,5,11,398,'6','7','9',54),(10230,10,11,253,'10','5','1',49),(10231,10,11,253,'10','5','2',49),(10232,10,11,253,'10','5','3',49),(10233,10,11,253,'10','5','4',49),(10234,10,11,253,'10','5','5',49),(10235,10,11,253,'10','5','6',49),(10236,10,11,253,'10','5','7',49),(10237,10,11,253,'4','5','8',49),(10238,10,11,253,'10','6','1',49),(10239,10,11,253,'10','6','2',49),(10240,10,11,253,'10','6','3',49),(10241,10,11,253,'10','6','4',49),(10242,10,11,253,'10','6','5',49),(10243,10,11,253,'10','6','6',49),(10244,10,11,253,'10','6','7',49),(10245,10,11,253,'10','6','8',49),(10246,10,11,253,'2','6','9',49),(10247,10,11,253,'10','7','1',49),(10248,10,11,253,'10','7','2',49),(10249,10,11,253,'10','7','3',49),(10250,10,11,253,'10','7','4',49),(10251,10,11,253,'10','7','5',49),(10252,10,11,253,'10','7','6',49),(10253,10,11,253,'10','7','7',49),(10254,10,11,253,'9','7','8',49),(10255,5,11,400,'10','1','1',54),(10256,5,11,400,'10','1','3',54),(10257,5,11,400,'10','1','2',54),(10258,5,11,400,'10','1','4',54),(10259,5,11,400,'10','1','5',54),(10260,5,11,400,'10','1','6',54),(10261,5,11,400,'10','1','7',54),(10262,5,11,400,'10','1','8',54),(10263,5,11,400,'3','1','9',54),(10264,5,11,400,'10','2','1',54),(10265,5,11,400,'10','2','2',54),(10266,5,11,400,'10','2','3',54),(10267,5,11,400,'10','2','4',54),(10268,5,11,400,'10','2','5',54),(10269,5,11,400,'10','2','6',54),(10270,5,11,400,'10','2','7',54),(10271,5,11,400,'10','2','8',54),(10272,5,11,400,'4','2','9',54),(10273,5,11,400,'10','3','1',54),(10274,5,11,400,'10','3','2',54),(10275,5,11,400,'10','3','3',54),(10276,5,11,400,'10','3','4',54),(10277,5,11,400,'10','3','5',54),(10278,5,11,400,'10','3','6',54),(10279,5,11,400,'10','3','7',54),(10280,5,11,400,'10','3','8',54),(10281,5,11,400,'2','3','9',54),(10282,5,11,400,'10','4','1',54),(10283,5,11,400,'10','4','2',54),(10284,5,11,400,'10','4','3',54),(10285,5,11,400,'10','4','4',54),(10286,5,11,400,'10','4','5',54),(10287,5,11,400,'10','4','6',54),(10288,5,11,400,'10','4','7',54),(10289,5,11,400,'10','4','8',54),(10290,5,11,400,'4','4','9',54),(10291,5,11,400,'10','5','1',54),(10292,5,11,400,'10','5','2',54),(10293,5,11,400,'10','5','3',54),(10294,5,11,400,'10','5','4',54),(10295,5,11,400,'10','5','5',54),(10296,5,11,400,'10','5','6',54),(10297,5,11,400,'10','5','7',54),(10298,5,11,400,'10','5','8',54),(10299,5,11,400,'7','5','9',54),(10300,5,11,400,'10','6','1',54),(10301,5,11,400,'10','6','2',54),(10302,5,11,400,'10','6','3',54),(10303,5,11,400,'10','6','4',54),(10304,5,11,400,'10','6','5',54),(10305,5,11,400,'10','6','6',54),(10306,5,11,400,'10','6','7',54),(10307,5,11,400,'10','6','8',54),(10308,5,11,400,'4','6','9',54),(10309,5,11,400,'10','7','1',54),(10310,5,11,400,'10','7','2',54),(10311,5,11,400,'10','7','3',54),(10312,5,11,400,'10','7','4',54),(10313,5,11,400,'10','7','5',54),(10314,5,11,400,'10','7','6',54),(10315,5,11,400,'10','7','7',54),(10316,5,11,400,'10','7','8',54),(10317,5,11,400,'2','7','9',54),(10318,5,11,402,'10','1','1',54),(10319,5,11,402,'10','1','2',54),(10320,5,11,402,'10','1','3',54),(10321,5,11,402,'10','1','4',54),(10322,5,11,402,'10','1','5',54),(10323,5,11,402,'10','1','6',54),(10324,5,11,402,'10','1','7',54),(10325,5,11,402,'10','1','8',54),(10326,5,11,402,'M','1','9',54),(10327,10,11,254,'10','1','1',49),(10328,5,11,402,'10','2','1',54),(10329,10,11,254,'10','1','2',49),(10330,5,11,402,'10','2','2',54),(10331,10,11,254,'10','1','3',49),(10332,5,11,402,'10','2','3',54),(10333,10,11,254,'10','1','4',49),(10334,5,11,402,'10','2','4',54),(10335,10,11,254,'10','1','5',49),(10336,5,11,402,'10','2','5',54),(10337,10,11,254,'10','1','6',49),(10339,10,11,254,'10','1','7',49),(10340,10,11,254,'3','1','8',49),(10341,5,11,402,'10','2','6',54),(10342,10,11,254,'10','2','1',49),(10343,10,11,254,'10','2','2',49),(10344,5,11,402,'10','2','7',54),(10345,10,11,254,'10','2','3',49),(10346,10,11,254,'10','2','4',49),(10347,10,11,254,'10','2','5',49),(10348,10,11,254,'10','2','6',49),(10349,10,11,254,'10','2','7',49),(10350,10,11,254,'5','2','8',49),(10351,5,11,402,'10','2','8',54),(10352,10,11,254,'10','3','1',49),(10353,5,11,402,'4','2','9',54),(10354,5,11,402,'10','3','1',54),(10355,10,11,254,'10','3','2',49),(10356,5,11,402,'10','3','2',54),(10357,10,11,254,'10','3','3',49),(10358,5,11,402,'10','3','3',54),(10359,10,11,254,'10','3','4',49),(10360,5,11,402,'10','3','4',54),(10361,10,11,254,'10','3','5',49),(10362,5,11,402,'10','3','5',54),(10363,10,11,254,'10','3','6',49),(10364,5,11,402,'10','3','6',54),(10365,5,11,402,'10','3','7',54),(10366,10,11,254,'1','3','8',49),(10367,5,11,402,'10','3','8',54),(10368,5,11,402,'6','3','9',54),(10369,5,11,402,'10','4','1',54),(10370,5,11,402,'10','4','2',54),(10371,5,11,402,'10','4','3',54),(10372,10,11,254,'10','3','7',49),(10373,5,11,402,'10','4','4',54),(10374,5,11,402,'10','4','5',54),(10375,5,11,402,'10','4','6',54),(10376,5,11,402,'10','4','7',54),(10377,5,11,402,'10','4','8',54),(10378,5,11,402,'4','4','9',54),(10379,5,11,402,'10','5','1',54),(10380,5,11,402,'10','5','2',54),(10381,5,11,402,'10','5','3',54),(10382,5,11,402,'10','5','4',54),(10383,5,11,402,'10','5','5',54),(10384,5,11,402,'10','5','6',54),(10385,10,11,254,'10','4','1',49),(10386,5,11,402,'10','5','7',54),(10387,10,11,254,'10','4','2',49),(10388,10,11,254,'10','4','3',49),(10389,10,11,254,'10','4','4',49),(10390,10,11,254,'10','4','5',49),(10391,5,11,402,'10','5','8',54),(10392,10,11,254,'10','4','6',49),(10393,5,11,402,'M','5','9',54),(10394,10,11,254,'10','4','7',49),(10395,5,11,402,'10','6','1',54),(10396,10,11,254,'1','4','8',49),(10397,5,11,402,'10','6','2',54),(10398,5,11,402,'10','6','3',54),(10399,5,11,402,'10','6','4',54),(10400,10,11,254,'10','5','1',49),(10401,5,11,402,'10','6','5',54),(10402,10,11,254,'10','5','2',49),(10403,5,11,402,'10','6','6',54),(10404,10,11,254,'10','5','3',49),(10405,5,11,402,'10','6','7',54),(10406,10,11,254,'10','5','4',49),(10407,5,11,402,'10','6','8',54),(10408,10,11,254,'10','5','5',49),(10409,5,11,402,'6','6','9',54),(10410,10,11,254,'10','5','6',49),(10411,5,11,402,'10','7','1',54),(10412,10,11,254,'10','5','7',49),(10413,5,11,402,'10','7','2',54),(10414,5,11,402,'10','7','3',54),(10415,5,11,402,'10','7','4',54),(10416,10,11,254,'10','6','1',49),(10417,5,11,402,'10','7','5',54),(10418,5,11,402,'10','7','6',54),(10419,10,11,254,'10','6','2',49),(10420,5,11,402,'10','7','7',54),(10421,10,11,254,'10','6','3',49),(10422,10,11,254,'10','6','4',49),(10423,5,11,402,'10','7','8',54),(10424,10,11,254,'10','6','5',49),(10425,5,11,402,'5','7','9',54),(10426,10,11,254,'10','6','6',49),(10427,10,11,254,'10','6','7',49),(10428,10,11,254,'10','7','1',49),(10429,10,11,254,'10','7','2',49),(10430,10,11,254,'10','7','3',49),(10431,10,11,254,'10','7','4',49),(10432,10,11,254,'10','7','5',49),(10433,10,11,254,'10','7','6',49),(10434,10,11,254,'10','7','7',49),(10435,10,11,254,'2','5','8',49),(10436,10,11,254,'6','6','8',49),(10437,10,11,254,'6','7','8',49),(10438,5,11,403,'10','1','1',54),(10439,5,11,403,'10','1','2',54),(10440,5,11,403,'10','1','3',54),(10441,5,11,403,'10','1','4',54),(10442,5,11,403,'10','1','5',54),(10443,5,11,403,'10','1','6',54),(10444,5,11,403,'10','1','7',54),(10445,5,11,403,'10','1','8',54),(10446,5,11,403,'5','1','9',54),(10447,5,11,403,'10','2','1',54),(10448,5,11,403,'10','2','2',54),(10449,5,11,403,'10','2','3',54),(10450,5,11,403,'10','2','4',54),(10451,5,11,403,'10','2','5',54),(10452,5,11,403,'10','2','6',54),(10453,5,11,403,'10','2','7',54),(10454,5,11,403,'10','2','8',54),(10455,5,11,403,'4','2','9',54),(10456,10,11,255,'10','1','1',49),(10457,10,11,255,'10','1','2',49),(10458,10,11,255,'10','1','3',49),(10459,10,11,255,'10','1','4',49),(10460,10,11,255,'10','1','5',49),(10461,10,11,255,'10','1','6',49),(10462,10,11,255,'10','1','7',49),(10463,10,11,255,'2','1','8',49),(10464,10,11,255,'10','2','1',49),(10465,10,11,255,'10','2','2',49),(10466,10,11,255,'10','2','3',49),(10467,10,11,255,'10','2','4',49),(10468,10,11,255,'10','2','5',49),(10469,10,11,255,'10','2','6',49),(10470,10,11,255,'10','2','7',49),(10471,10,11,255,'3','2','8',49),(10472,10,11,255,'10','3','1',49),(10473,10,11,255,'10','3','2',49),(10474,10,11,255,'10','3','3',49),(10475,10,11,255,'10','3','4',49),(10476,10,11,255,'10','3','5',49),(10477,10,11,255,'10','3','6',49),(10478,10,11,255,'10','3','7',49),(10479,10,11,255,'1','3','8',49),(10480,10,11,255,'10','4','1',49),(10481,10,11,255,'10','4','2',49),(10482,10,11,255,'10','4','3',49),(10483,10,11,255,'10','4','4',49),(10484,10,11,255,'10','4','5',49),(10485,10,11,255,'10','4','6',49),(10486,10,11,255,'10','4','7',49),(10487,10,11,255,'2','4','8',49),(10488,10,11,255,'10','5','1',49),(10489,10,11,255,'10','5','2',49),(10490,10,11,255,'10','5','3',49),(10491,10,11,255,'10','5','4',49),(10492,10,11,255,'10','5','5',49),(10493,10,11,255,'10','5','6',49),(10494,10,11,255,'10','5','7',49),(10495,10,11,255,'5','5','8',49),(10496,10,11,255,'10','6','1',49),(10497,10,11,255,'10','6','2',49),(10498,10,11,255,'10','6','3',49),(10499,10,11,255,'10','6','4',49),(10500,10,11,255,'10','6','5',49),(10501,10,11,255,'10','6','6',49),(10502,10,11,255,'10','6','7',49),(10503,10,11,255,'7','6','8',49),(10504,10,11,255,'10','7','1',49),(10505,10,11,255,'10','7','2',49),(10506,10,11,255,'10','7','3',49),(10507,10,11,255,'10','7','4',49),(10508,10,11,255,'10','7','5',49),(10509,10,11,255,'10','7','6',49),(10510,10,11,255,'10','7','7',49),(10512,10,11,255,'2','7','8',49),(10513,10,11,256,'10','1','1',49),(10514,10,11,256,'10','1','2',49),(10515,10,11,256,'10','1','3',49),(10516,10,11,256,'10','1','4',49),(10517,10,11,256,'10','1','5',49),(10518,10,11,256,'10','1','6',49),(10519,10,11,256,'10','1','7',49),(10520,10,11,256,'1','1','8',49),(10521,10,11,256,'10','2','2',49),(10522,10,11,256,'10','2','1',49),(10523,10,11,256,'10','2','3',49),(10524,10,11,256,'10','2','4',49),(10525,10,11,256,'10','2','5',49),(10526,10,11,256,'10','2','6',49),(10527,10,11,256,'10','2','7',49),(10528,10,11,256,'4','2','8',49),(10529,10,11,256,'10','3','1',49),(10530,10,11,256,'10','3','2',49),(10531,10,11,256,'10','3','3',49),(10532,10,11,256,'10','3','4',49),(10533,10,11,256,'10','3','5',49),(10534,10,11,256,'10','3','6',49),(10535,10,11,256,'10','3','7',49),(10536,10,11,256,'5','3','8',49),(10537,10,11,256,'10','4','1',49),(10538,10,11,256,'10','4','2',49),(10539,10,11,256,'10','4','3',49),(10540,10,11,256,'10','4','4',49),(10541,10,11,256,'10','4','5',49),(10542,10,11,256,'10','4','6',49),(10543,10,11,256,'10','4','7',49),(10544,10,11,256,'10','5','1',49),(10545,10,11,256,'10','5','2',49),(10546,10,11,256,'10','5','3',49),(10547,10,11,256,'10','5','4',49),(10548,10,11,256,'10','5','5',49),(10549,10,11,256,'10','5','6',49),(10550,10,11,256,'10','5','7',49),(10551,10,11,256,'3','5','8',49),(10552,10,11,256,'10','6','1',49),(10553,10,11,256,'10','6','2',49),(10554,10,11,256,'10','6','3',49),(10555,10,11,256,'10','6','4',49),(10556,10,11,256,'10','6','5',49),(10557,10,11,256,'10','6','6',49),(10558,10,11,256,'10','6','7',49),(10559,10,11,256,'3','6','8',49),(10560,10,11,256,'10','7','1',49),(10561,10,11,256,'10','7','2',49),(10562,10,11,256,'10','7','3',49),(10563,10,11,256,'10','7','4',49),(10564,10,11,256,'10','7','5',49),(10565,10,11,256,'10','7','6',49),(10566,10,11,256,'8','7','7',49),(10567,10,11,257,'10','1','1',49),(10568,10,11,257,'10','1','2',49),(10569,10,11,257,'10','1','3',49),(10570,10,11,257,'10','1','4',49),(10571,10,11,257,'10','1','5',49),(10572,5,11,403,'10','3','1',54),(10573,10,11,257,'10','1','6',49),(10574,5,11,403,'10','3','2',54),(10575,5,11,403,'10','3','3',54),(10576,10,11,257,'1','1','7',49),(10577,5,11,403,'10','3','4',54),(10578,5,11,403,'10','3','5',54),(10579,5,11,403,'10','3','6',54),(10580,5,11,403,'10','3','7',54),(10581,10,11,257,'10','2','1',49),(10582,5,11,403,'10','3','8',54),(10583,10,11,257,'10','2','2',49),(10584,5,11,403,'4','3','9',54),(10585,10,11,257,'10','2','3',49),(10586,10,11,257,'10','2','4',49),(10587,5,11,403,'10','4','1',54),(10588,10,11,257,'10','2','5',49),(10589,5,11,403,'10','4','2',54),(10590,10,11,257,'10','2','6',49),(10591,5,11,403,'10','4','3',54),(10592,5,11,403,'10','4','4',54),(10593,5,11,403,'10','4','5',54),(10594,5,11,403,'10','4','6',54),(10595,10,11,257,'10','2','8',49),(10596,5,11,403,'10','4','7',54),(10597,5,11,403,'10','4','8',54),(10598,5,11,403,'2','4','9',54),(10599,5,11,403,'10','5','1',54),(10600,5,11,403,'10','5','2',54),(10601,10,11,257,'10','2','7',49),(10602,5,11,403,'10','5','3',54),(10603,5,11,403,'10','5','4',54),(10604,5,11,403,'10','5','5',54),(10605,5,11,403,'10','5','6',54),(10606,10,11,257,'10','3','1',49),(10607,5,11,403,'10','5','7',54),(10608,5,11,403,'10','5','8',54),(10609,10,11,257,'10','3','2',49),(10610,5,11,403,'6','5','9',54),(10611,10,11,257,'10','3','3',49),(10612,5,11,403,'10','6','1',54),(10613,10,11,257,'10','3','4',49),(10614,5,11,403,'10','6','2',54),(10615,10,11,257,'10','3','5',49),(10616,5,11,403,'10','6','3',54),(10617,10,11,257,'10','3','6',49),(10618,5,11,403,'10','6','4',54),(10619,5,11,403,'10','6','5',54),(10620,10,11,257,'7','3','7',49),(10621,5,11,403,'10','6','6',54),(10622,5,11,403,'10','6','7',54),(10623,5,11,403,'9','6','8',54),(10624,10,11,257,'10','4','1',49),(10625,10,11,257,'10','4','2',49),(10626,10,11,257,'10','4','3',49),(10627,10,11,257,'10','4','4',49),(10628,10,11,257,'10','4','5',49),(10629,10,11,257,'10','4','6',49),(10631,10,11,257,'10','5','1',49),(10632,10,11,257,'10','5','2',49),(10633,10,11,257,'10','5','3',49),(10634,10,11,257,'10','5','4',49),(10635,10,11,257,'10','5','5',49),(10636,10,11,257,'10','5','6',49),(10637,10,11,257,'10','5','7',49),(10638,10,11,257,'4','5','8',49),(10639,10,11,257,'10','6','1',49),(10640,10,11,257,'10','6','2',49),(10641,10,11,257,'10','6','3',49),(10642,10,11,257,'10','6','4',49),(10643,10,11,257,'10','6','5',49),(10644,10,11,257,'10','6','6',49),(10645,5,11,403,'M','6','9',54),(10646,10,11,257,'10','6','7',49),(10647,10,11,257,'3','6','8',49),(10648,10,11,257,'10','7','1',49),(10649,10,11,257,'10','7','2',49),(10650,10,11,257,'10','7','3',49),(10651,5,11,403,'10','7','1',54),(10652,10,11,257,'10','7','4',49),(10653,5,11,403,'10','7','2',54),(10654,10,11,257,'10','7','5',49),(10655,5,11,403,'10','7','3',54),(10656,10,11,257,'10','7','6',49),(10657,10,11,257,'10','7','7',49),(10658,10,11,257,'10','7','8',49),(10659,10,11,257,'4','7','9',49),(10660,5,11,403,'10','7','4',54),(10661,5,11,403,'10','7','5',54),(10662,5,11,403,'10','7','6',54),(10663,5,11,403,'10','7','7',54),(10664,5,11,403,'10','7','8',54),(10665,5,11,403,'2','7','9',54),(10666,5,11,404,'10','1','1',54),(10667,5,11,404,'10','1','2',54),(10668,5,11,404,'10','1','3',54),(10669,5,11,404,'10','1','4',54),(10670,5,11,404,'10','1','5',54),(10671,5,11,404,'10','1','6',54),(10672,5,11,404,'10','1','7',54),(10673,5,11,404,'10','1','8',54),(10674,5,11,404,'1','1','9',54),(10675,5,11,404,'10','2','1',54),(10676,5,11,404,'10','2','2',54),(10677,5,11,404,'10','2','3',54),(10678,5,11,404,'10','2','4',54),(10679,5,11,404,'10','2','5',54),(10680,5,11,404,'10','2','6',54),(10681,5,11,404,'10','2','7',54),(10682,5,11,404,'10','2','8',54),(10683,5,11,404,'M','2','9',54),(10684,5,11,404,'10','3','1',54),(10685,5,11,404,'10','3','2',54),(10686,5,11,404,'10','3','3',54),(10687,5,11,404,'10','3','4',54),(10688,5,11,404,'10','3','5',54),(10689,5,11,404,'10','3','6',54),(10690,5,11,404,'10','3','7',54),(10691,5,11,404,'10','3','8',54),(10692,5,11,404,'5','3','9',54),(10693,5,11,404,'10','4','1',54),(10694,5,11,404,'10','4','2',54),(10695,5,11,404,'10','4','3',54),(10696,5,11,404,'10','4','4',54),(10697,5,11,404,'10','4','5',54),(10698,5,11,404,'10','4','6',54),(10699,5,11,404,'10','4','7',54),(10700,5,11,404,'10','4','8',54),(10701,5,11,404,'3','4','9',54),(10702,5,11,404,'10','5','1',54),(10703,5,11,404,'10','5','2',54),(10704,5,11,404,'10','5','3',54),(10705,5,11,404,'10','5','4',54),(10706,5,11,404,'10','5','5',54),(10707,5,11,404,'10','5','6',54),(10708,5,11,404,'10','5','7',54),(10709,5,11,404,'10','5','8',54),(10710,5,11,404,'6','5','9',54),(10711,5,11,404,'10','6','1',54),(10712,5,11,404,'10','6','2',54),(10713,5,11,404,'10','6','3',54),(10714,5,11,404,'10','6','4',54),(10715,5,11,404,'10','6','5',54),(10716,5,11,404,'10','6','6',54),(10717,5,11,404,'10','6','7',54),(10718,5,11,404,'10','6','8',54),(10719,5,11,404,'5','6','9',54),(10720,5,11,404,'10','7','1',54),(10721,5,11,404,'10','7','2',54),(10722,5,11,404,'10','7','3',54),(10723,5,11,404,'10','7','4',54),(10724,5,11,404,'10','7','5',54),(10725,5,11,404,'10','7','6',54),(10726,5,11,404,'10','7','7',54),(10727,5,11,404,'8','7','8',54),(10728,5,11,404,'M','7','9',54),(10729,5,11,405,'10','1','1',54),(10730,5,11,405,'10','1','2',54),(10731,5,11,405,'10','1','3',54),(10732,5,11,405,'10','1','4',54),(10733,5,11,405,'10','1','5',54),(10734,5,11,405,'10','1','6',54),(10735,5,11,405,'10','1','7',54),(10736,5,11,405,'10','1','8',54),(10737,5,11,405,'4','1','9',54),(10738,5,11,405,'10','2','1',54),(10739,5,11,405,'10','2','2',54),(10740,5,11,405,'10','2','3',54),(10741,5,11,405,'10','2','4',54),(10742,5,11,405,'10','2','5',54),(10743,5,11,405,'10','2','6',54),(10744,5,11,405,'10','2','7',54),(10745,5,11,405,'9','2','8',54),(10746,5,11,405,'M','2','9',54),(10747,5,11,405,'10','3','1',54),(10748,5,11,405,'10','3','2',54),(10749,5,11,405,'10','3','3',54),(10750,5,11,405,'10','3','4',54),(10751,5,11,405,'10','3','5',54),(10752,5,11,405,'10','3','6',54),(10753,5,11,405,'10','3','7',54),(10754,5,11,405,'10','3','8',54),(10755,5,11,405,'M','3','9',54),(10756,5,11,405,'10','4','1',54),(10757,5,11,405,'10','4','2',54),(10758,5,11,405,'10','4','3',54),(10759,5,11,405,'10','4','4',54),(10760,5,11,405,'10','4','5',54),(10761,5,11,405,'10','4','6',54),(10762,5,11,405,'10','4','7',54),(10763,5,11,405,'10','4','8',54),(10764,5,11,405,'M','4','9',54),(10765,5,11,405,'10','5','1',54),(10766,5,11,405,'10','5','2',54),(10767,5,11,405,'10','5','3',54),(10768,5,11,405,'10','5','4',54),(10769,5,11,405,'10','5','5',54),(10770,5,11,405,'10','5','6',54),(10771,5,11,405,'10','5','7',54),(10772,5,11,405,'10','5','8',54),(10773,5,11,405,'3','5','9',54),(10774,5,11,405,'10','6','1',54),(10775,5,11,405,'10','6','2',54),(10776,5,11,405,'10','6','3',54),(10777,5,11,405,'10','6','4',54),(10778,5,11,405,'10','6','5',54),(10779,5,11,405,'10','6','6',54),(10780,5,11,405,'10','6','7',54),(10781,5,11,405,'10','6','8',54),(10782,5,11,405,'8','6','9',54),(10783,5,11,405,'10','7','1',54),(10784,5,11,405,'10','7','2',54),(10785,5,11,405,'10','7','3',54),(10786,5,11,405,'10','7','4',54),(10787,5,11,405,'10','7','5',54),(10788,5,11,405,'10','7','6',54),(10789,5,11,405,'10','7','7',54),(10790,5,11,405,'10','7','8',54),(10791,5,11,405,'1','7','9',54),(10792,10,11,258,'10','1','2',49),(10793,10,11,258,'10','1','1',49),(10794,10,11,258,'10','1','3',49),(10795,10,11,258,'10','1','4',49),(10796,10,11,258,'10','1','5',49),(10797,10,11,258,'10','1','6',49),(10798,10,11,258,'10','1','7',49),(10799,10,11,258,'8','1','8',49),(10800,10,11,258,'10','2','1',49),(10801,10,11,258,'10','2','2',49),(10802,10,11,258,'10','2','3',49),(10803,10,11,258,'10','2','4',49),(10804,10,11,258,'10','2','5',49),(10805,10,11,258,'10','2','6',49),(10806,10,11,258,'10','2','7',49),(10807,5,11,406,'10','1','1',54),(10808,5,11,406,'10','1','2',54),(10809,10,11,258,'6','2','8',49),(10810,5,11,406,'10','1','3',54),(10811,5,11,406,'10','1','4',54),(10812,10,11,258,'10','3','1',49),(10813,5,11,406,'10','1','5',54),(10814,10,11,258,'10','3','2',49),(10815,5,11,406,'10','1','6',54),(10816,5,11,406,'10','1','7',54),(10817,10,11,258,'10','3','3',49),(10818,5,11,406,'10','1','8',54),(10819,10,11,258,'10','3','4',49),(10820,10,11,258,'10','3','5',49),(10821,5,11,406,'4','1','9',54),(10822,10,11,258,'10','3','6',49),(10823,10,11,258,'7','3','8',49),(10824,10,11,258,'10','3','7',49),(10825,5,11,406,'10','2','2',54),(10826,5,11,406,'10','2','3',54),(10827,5,11,406,'10','2','4',54),(10828,5,11,406,'10','2','5',54),(10829,5,11,406,'10','2','6',54),(10830,5,11,406,'10','2','7',54),(10831,5,11,406,'8','2','8',54),(10832,5,11,406,'M','2','9',54),(10833,5,11,406,'10','3','1',54),(10834,10,11,258,'10','4','1',49),(10835,5,11,406,'10','3','2',54),(10836,10,11,258,'10','4','2',49),(10837,5,11,406,'10','3','3',54),(10838,10,11,258,'10','4','3',49),(10839,5,11,406,'10','3','4',54),(10840,10,11,258,'10','4','4',49),(10841,5,11,406,'10','3','5',54),(10842,10,11,258,'10','4','5',49),(10843,5,11,406,'10','3','6',54),(10844,10,11,258,'10','4','6',49),(10845,10,11,258,'10','4','7',49),(10846,10,11,258,'6','4','8',49),(10847,10,11,258,'10','5','1',49),(10848,5,11,406,'10','3','7',54),(10849,5,11,406,'10','3','8',54),(10850,10,11,258,'10','5','2',49),(10851,5,11,406,'M','3','9',54),(10852,10,11,258,'10','5','3',49),(10853,5,11,406,'10','4','1',54),(10854,10,11,258,'10','5','4',49),(10855,5,11,406,'10','4','2',54),(10856,10,11,258,'10','5','5',49),(10857,5,11,406,'10','4','3',54),(10858,10,11,258,'10','5','6',49),(10859,5,11,406,'10','4','4',54),(10860,10,11,258,'10','5','7',49),(10861,5,11,406,'10','4','5',54),(10862,10,11,258,'3','5','8',49),(10863,10,11,258,'10','6','1',49),(10864,10,11,258,'10','6','2',49),(10865,10,11,258,'10','6','3',49),(10866,10,11,258,'10','6','4',49),(10867,10,11,258,'10','6','5',49),(10868,10,11,258,'10','6','6',49),(10869,10,11,258,'4','6','7',49),(10870,5,11,406,'10','4','6',54),(10871,5,11,406,'10','4','7',54),(10872,10,11,258,'10','7','1',49),(10873,5,11,406,'10','4','8',54),(10874,5,11,406,'4','4','9',54),(10875,10,11,258,'10','7','2',49),(10876,5,11,406,'10','5','1',54),(10877,10,11,258,'10','7','3',49),(10878,5,11,406,'10','5','2',54),(10879,10,11,258,'10','7','4',49),(10880,5,11,406,'10','5','3',54),(10881,5,11,406,'10','5','4',54),(10882,10,11,258,'10','7','5',49),(10883,5,11,406,'10','5','5',54),(10884,5,11,406,'10','5','6',54),(10885,5,11,406,'10','5','7',54),(10886,5,11,406,'8','5','8',54),(10887,5,11,406,'M','5','9',54),(10888,5,11,406,'10','6','1',54),(10889,5,11,406,'10','6','3',54),(10890,5,11,406,'10','6','2',54),(10891,5,11,406,'10','6','4',54),(10892,5,11,406,'10','6','5',54),(10893,5,11,406,'10','6','6',54),(10894,5,11,406,'10','6','7',54),(10895,5,11,406,'10','6','8',54),(10896,5,11,406,'M','6','9',54),(10897,5,11,406,'10','7','1',54),(10898,5,11,406,'10','7','2',54),(10899,5,11,406,'10','7','3',54),(10900,5,11,406,'10','7','4',54),(10901,5,11,406,'10','7','5',54),(10902,5,11,406,'10','7','6',54),(10903,5,11,406,'10','7','7',54),(10904,5,11,406,'10','7','8',54),(10905,5,11,406,'7','7','9',54),(10906,5,11,408,'10','1','1',54),(10907,5,11,408,'10','1','2',54),(10908,5,11,408,'10','1','3',54),(10909,5,11,408,'10','1','4',54),(10910,5,11,408,'10','1','5',54),(10911,5,11,408,'10','1','6',54),(10912,5,11,408,'10','1','7',54),(10913,5,11,408,'8','1','8',54),(10914,5,11,408,'M','1','9',54),(10915,5,11,408,'10','2','1',54),(10916,5,11,408,'10','2','2',54),(10917,5,11,408,'10','2','3',54),(10918,10,11,259,'10','1','1',49),(10919,5,11,408,'10','2','4',54),(10920,10,11,259,'10','1','2',49),(10921,5,11,408,'10','2','5',54),(10922,10,11,259,'10','1','3',49),(10923,5,11,408,'10','2','6',54),(10924,10,11,259,'10','1','4',49),(10925,5,11,408,'10','2','7',54),(10926,10,11,259,'10','1','5',49),(10927,5,11,408,'10','2','8',54),(10928,10,11,259,'10','1','6',49),(10929,5,11,408,'2','2','9',54),(10930,10,11,259,'10','1','7',49),(10931,10,11,259,'2','1','8',49),(10932,5,11,408,'10','3','1',54),(10933,5,11,408,'10','3','2',54),(10934,10,11,259,'10','2','1',49),(10935,5,11,408,'10','3','3',54),(10936,10,11,259,'10','2','2',49),(10937,5,11,408,'10','3','4',54),(10938,10,11,259,'10','2','3',49),(10939,5,11,408,'10','3','5',54),(10940,10,11,259,'10','2','4',49),(10941,5,11,408,'10','3','6',54),(10942,10,11,259,'10','2','5',49),(10943,5,11,408,'10','3','7',54),(10944,10,11,259,'10','2','6',49),(10945,5,11,408,'10','3','8',54),(10946,5,11,408,'3','3','9',54),(10947,5,11,408,'10','4','1',54),(10948,5,11,408,'10','4','2',54),(10949,5,11,408,'10','4','3',54),(10950,5,11,408,'10','4','4',54),(10951,5,11,408,'10','4','5',54),(10952,10,11,259,'10','2','7',49),(10953,5,11,408,'10','4','6',54),(10954,10,11,259,'9','2','8',49),(10955,5,11,408,'10','4','7',54),(10956,5,11,408,'10','4','8',54),(10957,5,11,408,'M','4','9',54),(10958,10,11,259,'10','3','1',49),(10959,5,11,408,'10','5','1',54),(10960,10,11,259,'10','3','2',49),(10961,5,11,408,'10','5','2',54),(10962,10,11,259,'10','3','3',49),(10963,5,11,408,'10','5','3',54),(10964,10,11,259,'10','3','4',49),(10965,5,11,408,'10','5','4',54),(10966,10,11,259,'10','3','5',49),(10967,5,11,408,'10','5','5',54),(10968,10,11,259,'10','3','6',49),(10969,5,11,408,'10','5','6',54),(10970,5,11,408,'10','5','7',54),(10971,10,11,259,'3','3','7',49),(10972,5,11,408,'10','5','8',54),(10973,5,11,408,'3','5','9',54),(10974,5,11,408,'10','6','1',54),(10975,5,11,408,'10','6','2',54),(10976,5,11,408,'10','6','3',54),(10977,10,11,259,'10','4','1',49),(10978,5,11,408,'10','6','4',54),(10979,10,11,259,'10','4','2',49),(10980,5,11,408,'10','6','5',54),(10981,10,11,259,'10','4','3',49),(10982,5,11,408,'10','6','6',54),(10983,10,11,259,'10','4','4',49),(10984,5,11,408,'10','6','7',54),(10985,10,11,259,'10','4','5',49),(10986,5,11,408,'9','6','8',54),(10987,10,11,259,'10','4','6',49),(10988,5,11,408,'M','6','9',54),(10989,10,11,259,'8','4','7',49),(10990,5,11,408,'10','7','1',54),(10991,5,11,408,'10','7','2',54),(10992,5,11,408,'10','7','3',54),(10993,5,11,408,'10','7','4',54),(10994,5,11,408,'10','7','5',54),(10995,5,11,408,'10','7','6',54),(10996,10,11,259,'10','5','1',49),(10997,5,11,408,'10','7','7',54),(10998,10,11,259,'10','5','2',49),(10999,5,11,408,'10','7','8',54),(11000,5,11,408,'4','7','9',54),(11001,10,11,259,'10','5','3',49),(11002,10,11,259,'10','5','5',49),(11003,10,11,259,'10','5','4',49),(11004,10,11,259,'7','5','6',49),(11005,10,11,259,'10','6','1',49),(11006,10,11,259,'10','6','2',49),(11007,10,11,259,'10','6','3',49),(11008,10,11,259,'10','6','4',49),(11009,10,11,259,'10','6','5',49),(11010,10,11,259,'10','6','6',49),(11011,10,11,259,'10','6','7',49),(11012,10,11,259,'6','6','8',49),(11013,5,11,409,'10','1','1',54),(11014,5,11,409,'10','1','2',54),(11016,5,11,409,'10','1','3',54),(11017,5,11,409,'10','1','4',54),(11018,5,11,409,'10','1','5',54),(11019,5,11,409,'10','1','6',54),(11020,5,11,409,'10','1','7',54),(11021,5,11,409,'10','1','8',54),(11022,10,11,259,'10','7','1',49),(11023,5,11,409,'M','1','9',54),(11024,10,11,259,'10','7','2',49),(11025,5,11,409,'10','2','1',54),(11026,10,11,259,'10','7','3',49),(11027,5,11,409,'10','2','2',54),(11028,10,11,259,'10','7','4',49),(11029,5,11,409,'10','2','3',54),(11030,10,11,259,'10','7','5',49),(11031,5,11,409,'10','2','4',54),(11032,5,11,409,'10','2','5',54),(11034,10,11,259,'10','7','7',49),(11035,10,11,259,'2','7','8',49),(11036,5,11,409,'10','2','7',54),(11037,5,11,409,'10','2','8',54),(11038,5,11,409,'2','2','9',54),(11039,10,11,259,'10','7','6',49),(11040,5,11,409,'10','2','6',54),(11041,5,11,409,'10','3','1',54),(11042,5,11,409,'10','3','2',54),(11043,5,11,409,'10','3','3',54),(11044,5,11,409,'10','3','4',54),(11045,5,11,409,'10','3','5',54),(11046,5,11,409,'10','3','6',54),(11047,5,11,409,'10','3','7',54),(11048,5,11,409,'8','3','8',54),(11049,5,11,409,'M','3','9',54),(11050,5,11,409,'10','4','1',54),(11051,5,11,409,'10','4','2',54),(11052,5,11,409,'10','4','3',54),(11053,5,11,409,'10','4','4',54),(11054,5,11,409,'10','4','5',54),(11055,5,11,409,'10','4','6',54),(11056,5,11,409,'10','4','7',54),(11057,5,11,409,'10','4','8',54),(11058,5,11,409,'4','4','9',54),(11059,5,11,409,'10','5','1',54),(11060,5,11,409,'10','5','2',54),(11061,5,11,409,'10','5','3',54),(11062,5,11,409,'10','5','4',54),(11063,5,11,409,'10','5','5',54),(11064,5,11,409,'10','5','6',54),(11065,5,11,409,'10','5','7',54),(11066,5,11,409,'10','5','8',54),(11067,5,11,409,'1','5','9',54),(11068,5,11,409,'10','6','1',54),(11069,5,11,409,'10','6','2',54),(11070,5,11,409,'10','6','3',54),(11071,5,11,409,'10','6','4',54),(11072,5,11,409,'10','6','5',54),(11073,5,11,409,'10','6','6',54),(11074,5,11,409,'10','6','7',54),(11075,5,11,409,'10','6','8',54),(11076,5,11,409,'2','6','9',54),(11077,5,11,409,'10','7','1',54),(11078,5,11,409,'10','7','2',54),(11079,5,11,409,'10','7','3',54),(11080,5,11,409,'10','7','4',54),(11081,5,11,409,'10','7','5',54),(11082,5,11,409,'10','7','6',54),(11083,5,11,409,'10','7','7',54),(11084,5,11,409,'10','7','8',54),(11085,5,11,409,'3','7','9',54),(11086,5,11,410,'10','1','2',54),(11087,5,11,410,'10','1','1',54),(11088,5,11,410,'10','1','3',54),(11089,5,11,410,'10','1','4',54),(11090,5,11,410,'10','1','5',54),(11091,5,11,410,'10','1','6',54),(11092,5,11,410,'10','1','7',54),(11093,5,11,410,'9','1','8',54),(11094,5,11,410,'M','1','9',54),(11095,5,11,410,'10','2','1',54),(11096,5,11,410,'10','2','2',54),(11097,5,11,410,'10','2','3',54),(11098,5,11,410,'10','2','4',54),(11099,5,11,410,'10','2','5',54),(11100,5,11,410,'10','2','6',54),(11101,5,11,410,'10','2','7',54),(11102,5,11,410,'10','2','8',54),(11103,5,11,410,'4','2','9',54),(11104,5,11,410,'10','3','1',54),(11105,5,11,410,'10','3','2',54),(11106,5,11,410,'10','3','3',54),(11107,5,11,410,'10','3','4',54),(11108,5,11,410,'10','3','5',54),(11109,5,11,410,'10','3','6',54),(11110,5,11,410,'10','3','7',54),(11111,5,11,410,'10','3','8',54),(11112,5,11,410,'4','3','9',54),(11113,5,11,410,'10','4','1',54),(11114,5,11,410,'10','4','2',54),(11115,5,11,410,'10','4','3',54),(11116,5,11,410,'10','4','4',54),(11117,5,11,410,'10','4','5',54),(11118,5,11,410,'10','4','6',54),(11119,5,11,410,'10','4','7',54),(11120,5,11,410,'8','4','8',54),(11121,5,11,410,'M','4','9',54),(11122,5,11,410,'10','5','1',54),(11123,5,11,410,'10','5','2',54),(11124,5,11,410,'10','5','3',54),(11125,5,11,410,'10','5','4',54),(11126,5,11,410,'10','5','5',54),(11127,5,11,410,'10','5','6',54),(11128,5,11,410,'10','5','7',54),(11129,5,11,410,'6','5','8',54),(11130,5,11,410,'M','5','9',54),(11131,5,11,410,'10','6','1',54),(11132,5,11,410,'10','6','2',54),(11133,5,11,410,'10','6','3',54),(11134,5,11,410,'10','6','4',54),(11135,5,11,410,'10','6','5',54),(11136,5,11,410,'10','6','6',54),(11137,5,11,410,'10','6','7',54),(11138,5,11,410,'10','6','8',54),(11139,5,11,410,'6','6','9',54),(11140,5,11,410,'10','7','1',54),(11141,5,11,410,'10','7','2',54),(11142,5,11,410,'10','7','3',54),(11143,5,11,410,'10','7','4',54),(11144,5,11,410,'10','7','5',54),(11145,5,11,410,'10','7','6',54),(11146,5,11,410,'10','7','7',54),(11147,5,11,410,'10','7','8',54),(11148,5,11,410,'2','7','9',54),(11149,5,11,412,'10','1','3',54),(11150,5,11,412,'10','1','2',54),(11151,5,11,412,'10','1','1',54),(11152,5,11,412,'10','1','4',54),(11153,5,11,412,'10','1','5',54),(11154,5,11,412,'10','1','6',54),(11155,5,11,412,'10','1','7',54),(11156,5,11,412,'10','1','8',54),(11157,10,11,260,'10','1','1',49),(11158,5,11,412,'M','1','9',54),(11159,10,11,260,'10','1','2',49),(11160,10,11,260,'10','1','3',49),(11161,5,11,412,'10','2','1',54),(11162,10,11,260,'10','1','4',49),(11163,5,11,412,'10','2','2',54),(11164,5,11,412,'10','2','3',54),(11165,10,11,260,'10','1','5',49),(11166,5,11,412,'10','2','4',54),(11167,10,11,260,'10','1','6',49),(11168,5,11,412,'10','2','5',54),(11169,10,11,260,'10','1','7',49),(11170,5,11,412,'10','2','6',54),(11171,5,11,412,'10','2','7',54),(11172,10,11,260,'1','1','8',49),(11173,5,11,412,'9','2','8',54),(11174,5,11,412,'M','2','9',54),(11175,10,11,260,'10','2','1',49),(11176,5,11,412,'10','3','1',54),(11177,5,11,412,'10','3','2',54),(11178,5,11,412,'10','3','3',54),(11179,5,11,412,'10','3','4',54),(11180,5,11,412,'10','3','5',54),(11181,10,11,260,'10','2','2',49),(11182,5,11,412,'10','3','6',54),(11183,5,11,412,'10','3','7',54),(11184,10,11,260,'10','2','3',49),(11185,5,11,412,'10','3','8',54),(11186,5,11,412,'2','3','9',54),(11187,10,11,260,'10','2','4',49),(11188,5,11,412,'10','4','1',54),(11189,10,11,260,'10','2','5',49),(11190,5,11,412,'10','4','2',54),(11191,10,11,260,'10','2','6',49),(11192,5,11,412,'10','4','3',54),(11193,10,11,260,'10','2','7',49),(11194,5,11,412,'10','4','4',54),(11195,5,11,412,'10','4','5',54),(11197,5,11,412,'10','4','6',54),(11198,5,11,412,'10','4','7',54),(11199,5,11,412,'10','4','8',54),(11200,10,11,260,'10','3','1',49),(11201,5,11,412,'5','4','9',54),(11202,10,11,260,'10','3','2',49),(11203,5,11,412,'10','5','1',54),(11204,10,11,260,'10','3','3',49),(11205,5,11,412,'10','5','2',54),(11206,10,11,260,'10','3','4',49),(11207,5,11,412,'10','5','3',54),(11208,10,11,260,'10','3','5',49),(11209,5,11,412,'10','5','4',54),(11210,5,11,412,'10','5','5',54),(11211,10,11,260,'10','3','6',49),(11212,5,11,412,'10','5','6',54),(11213,10,11,260,'1','3','7',49),(11214,5,11,412,'10','5','7',54),(11215,5,11,412,'10','5','8',54),(11216,5,11,412,'1','5','9',54),(11217,5,11,412,'10','6','1',54),(11218,5,11,412,'10','6','2',54),(11219,5,11,412,'10','6','3',54),(11220,5,11,412,'10','6','4',54),(11221,5,11,412,'10','6','5',54),(11222,5,11,412,'10','6','6',54),(11223,5,11,412,'10','6','7',54),(11224,5,11,412,'5','6','8',54),(11225,5,11,412,'M','6','9',54),(11226,5,11,412,'10','7','1',54),(11227,5,11,412,'10','7','2',54),(11228,5,11,412,'10','7','3',54),(11229,5,11,412,'10','7','4',54),(11230,5,11,412,'10','7','5',54),(11231,5,11,412,'10','7','6',54),(11232,5,11,412,'10','7','7',54),(11233,5,11,412,'10','7','8',54),(11234,10,11,260,'5','2','8',49),(11235,10,11,260,'10','4','2',49),(11236,10,11,260,'10','4','3',49),(11237,10,11,260,'10','4','4',49),(11238,10,11,260,'10','4','5',49),(11239,10,11,260,'10','4','6',49),(11241,10,11,260,'6','4','7',49),(11242,10,11,260,'10','5','1',49),(11243,10,11,260,'10','5','2',49),(11244,10,11,260,'10','5','3',49),(11245,10,11,260,'10','5','4',49),(11246,10,11,260,'10','5','5',49),(11247,10,11,260,'10','5','6',49),(11248,10,11,260,'10','5','7',49),(11249,10,11,260,'10','6','1',49),(11250,10,11,260,'10','6','2',49),(11251,10,11,260,'10','6','3',49),(11252,10,11,260,'10','6','4',49),(11253,10,11,260,'10','6','5',49),(11254,10,11,260,'10','6','6',49),(11255,10,11,260,'10','6','7',49),(11256,10,11,260,'4','6','8',49),(11257,10,11,260,'10','7','1',49),(11258,10,11,260,'10','7','2',49),(11259,10,11,260,'10','7','3',49),(11260,10,11,260,'10','7','4',49),(11261,10,11,260,'10','7','5',49),(11262,10,11,260,'10','7','6',49),(11263,10,11,260,'10','7','7',49),(11264,10,11,261,'10','1','2',49),(11265,10,11,261,'10','1','1',49),(11266,10,11,261,'10','1','3',49),(11267,10,11,261,'10','1','4',49),(11268,10,11,261,'10','1','5',49),(11269,10,11,261,'10','1','6',49),(11270,10,11,261,'10','1','7',49),(11271,10,11,261,'1','1','8',49),(11272,10,11,261,'10','2','1',49),(11273,10,11,261,'10','2','2',49),(11274,10,11,261,'10','2','3',49),(11275,10,11,261,'10','2','4',49),(11276,10,11,261,'10','2','5',49),(11277,10,11,261,'10','2','6',49),(11278,10,11,261,'10','2','7',49),(11279,10,11,261,'1','2','8',49),(11280,10,11,261,'10','3','1',49),(11281,10,11,261,'10','3','2',49),(11282,10,11,261,'10','3','3',49),(11283,10,11,261,'10','3','4',49),(11284,10,11,261,'10','3','5',49),(11285,10,11,261,'10','3','6',49),(11286,10,11,261,'10','3','7',49),(11287,10,11,261,'10','4','1',49),(11288,10,11,261,'10','4','2',49),(11289,10,11,261,'10','4','3',49),(11290,10,11,261,'10','4','4',49),(11291,10,11,261,'10','4','5',49),(11292,10,11,261,'10','4','6',49),(11293,10,11,261,'6','4','7',49),(11294,10,11,261,'10','5','1',49),(11295,10,11,261,'10','5','2',49),(11296,10,11,261,'10','5','3',49),(11297,10,11,261,'10','5','4',49),(11298,10,11,261,'10','5','5',49),(11299,10,11,261,'10','5','6',49),(11300,10,11,261,'6','5','7',49),(11301,10,11,261,'10','6','1',49),(11302,10,11,261,'10','6','2',49),(11303,10,11,261,'10','6','3',49),(11304,10,11,261,'10','6','4',49),(11305,10,11,261,'10','6','5',49),(11306,10,11,261,'10','6','6',49),(11307,10,11,261,'3','6','7',49),(11308,10,11,261,'10','7','1',49),(11309,10,11,261,'10','7','2',49),(11310,10,11,261,'10','7','3',49),(11311,10,11,261,'10','7','4',49),(11312,10,11,261,'10','7','5',49),(11313,10,11,261,'10','7','6',49),(11314,10,11,261,'10','7','7',49),(11315,10,11,261,'9','7','8',49),(11316,10,11,262,'10','1','1',49),(11317,10,11,262,'10','1','2',49),(11318,10,11,262,'10','1','3',49),(11319,10,11,262,'10','1','4',49),(11320,10,11,262,'10','1','5',49),(11321,5,11,413,'10','1','1',54),(11322,10,11,262,'10','2','1',49),(11323,5,11,413,'10','1','2',54),(11324,10,11,262,'10','2','2',49),(11325,5,11,413,'10','1','3',54),(11326,10,11,262,'10','2','3',49),(11327,5,11,413,'10','1','4',54),(11328,10,11,262,'10','2','4',49),(11329,5,11,413,'10','1','5',54),(11330,10,11,262,'10','2','5',49),(11331,5,11,413,'10','1','6',54),(11332,5,11,413,'10','1','7',54),(11333,10,11,262,'10','2','6',49),(11334,5,11,413,'10','1','8',54),(11336,5,11,413,'3','1','9',54),(11337,5,11,413,'10','2','1',54),(11338,5,11,413,'10','2','2',54),(11339,5,11,413,'10','2','3',54),(11340,5,11,413,'10','2','4',54),(11341,5,11,413,'10','2','5',54),(11342,5,11,413,'10','2','6',54),(11343,5,11,413,'10','2','7',54),(11344,10,11,262,'2','2','7',49),(11345,5,11,413,'10','2','8',54),(11346,5,11,413,'2','2','9',54),(11347,10,11,262,'10','3','1',49),(11348,10,11,262,'10','3','2',49),(11349,5,11,413,'10','3','1',54),(11350,5,11,413,'10','3','2',54),(11351,5,11,413,'10','3','3',54),(11352,5,11,413,'10','3','4',54),(11353,5,11,413,'10','3','5',54),(11354,10,11,262,'10','3','3',49),(11356,10,11,262,'10','3','4',49),(11357,5,11,413,'10','3','7',54),(11358,10,11,262,'10','3','5',49),(11359,5,11,413,'10','3','8',54),(11360,10,11,262,'10','3','6',49),(11361,5,11,413,'2','3','9',54),(11362,5,11,413,'10','3','6',54),(11363,10,11,262,'10','3','7',49),(11364,10,11,262,'5','3','8',49),(11365,10,11,262,'10','4','1',49),(11366,5,11,413,'10','4','1',54),(11367,5,11,413,'10','4','2',54),(11368,10,11,262,'10','4','2',49),(11370,10,11,262,'10','4','3',49),(11371,10,11,262,'10','4','4',49),(11372,5,11,413,'10','4','4',54),(11373,5,11,413,'10','4','5',54),(11374,10,11,262,'10','4','5',49),(11375,5,11,413,'10','4','6',54),(11376,10,11,262,'10','4','6',49),(11377,5,11,413,'10','4','7',54),(11378,10,11,262,'10','4','7',49),(11379,5,11,413,'6','4','8',54),(11380,10,11,262,'3','4','8',49),(11381,5,11,413,'M','4','9',54),(11382,5,11,413,'10','4','3',54),(11383,5,11,413,'10','5','1',54),(11384,5,11,413,'10','5','2',54),(11385,5,11,413,'10','5','3',54),(11386,10,11,262,'10','5','1',49),(11387,5,11,413,'10','5','4',54),(11388,10,11,262,'10','5','2',49),(11389,5,11,413,'10','5','5',54),(11390,10,11,262,'10','5','3',49),(11391,5,11,413,'10','5','6',54),(11392,5,11,413,'10','5','7',54),(11393,10,11,262,'10','5','4',49),(11394,10,11,262,'10','5','5',49),(11395,5,11,413,'5','5','8',54),(11396,10,11,262,'10','5','6',49),(11397,10,11,262,'10','5','7',49),(11398,10,11,262,'2','5','8',49),(11399,5,11,413,'M','5','9',54),(11400,10,11,262,'10','6','1',49),(11401,10,11,262,'10','6','2',49),(11402,10,11,262,'10','6','3',49),(11403,5,11,413,'10','6','1',54),(11404,10,11,262,'10','6','4',49),(11405,5,11,413,'10','6','2',54),(11406,10,11,262,'10','6','5',49),(11407,5,11,413,'10','6','3',54),(11408,10,11,262,'10','6','6',49),(11409,5,11,413,'10','6','4',54),(11410,5,11,413,'10','6','5',54),(11411,10,11,262,'10','6','7',49),(11412,5,11,413,'10','6','6',54),(11414,5,11,413,'10','6','7',54),(11415,5,11,413,'10','6','8',54),(11416,5,11,413,'3','6','9',54),(11417,5,11,413,'10','7','1',54),(11418,5,11,413,'10','7','2',54),(11419,10,11,262,'8','6','8',49),(11420,5,11,413,'10','7','3',54),(11422,5,11,413,'10','7','5',54),(11423,10,11,262,'10','7','1',49),(11424,5,11,413,'10','7','6',54),(11425,10,11,262,'10','7','2',49),(11426,5,11,413,'10','7','7',54),(11427,10,11,262,'10','7','3',49),(11428,5,11,413,'10','7','8',54),(11429,10,11,262,'10','7','4',49),(11430,5,11,413,'2','7','9',54),(11431,10,11,262,'10','7','5',49),(11432,10,11,262,'10','7','6',49),(11433,10,11,262,'10','7','7',49),(11434,5,11,413,'10','7','4',54),(11435,10,11,262,'3','7','8',49),(11436,5,11,415,'10','1','1',54),(11437,5,11,415,'10','1','2',54),(11438,5,11,415,'10','1','3',54),(11439,5,11,415,'10','1','4',54),(11440,5,11,415,'10','1','5',54),(11441,5,11,415,'10','1','6',54),(11442,5,11,415,'10','1','7',54),(11443,5,11,415,'6','1','8',54),(11444,5,11,415,'M','1','9',54),(11445,5,11,415,'10','2','1',54),(11446,5,11,415,'10','2','2',54),(11447,5,11,415,'10','2','3',54),(11448,5,11,415,'10','2','4',54),(11449,5,11,415,'10','2','5',54),(11450,5,11,415,'10','2','6',54),(11451,5,11,415,'10','2','7',54),(11452,5,11,415,'4','2','8',54),(11453,5,11,415,'M','2','9',54),(11454,5,11,415,'10','3','1',54),(11455,5,11,415,'10','3','2',54),(11456,5,11,415,'10','3','3',54),(11457,5,11,415,'10','3','4',54),(11458,5,11,415,'10','3','5',54),(11459,5,11,415,'10','3','6',54),(11460,5,11,415,'10','3','7',54),(11461,5,11,415,'9','3','8',54),(11462,5,11,415,'M','3','9',54),(11463,5,11,415,'10','4','1',54),(11464,5,11,415,'10','4','2',54),(11465,5,11,415,'10','4','3',54),(11466,5,11,415,'10','4','4',54),(11467,5,11,415,'10','4','5',54),(11468,5,11,415,'10','4','6',54),(11469,5,11,415,'10','4','7',54),(11470,5,11,415,'10','4','8',54),(11471,5,11,415,'1','4','9',54),(11472,5,11,415,'10','5','1',54),(11473,5,11,415,'10','5','2',54),(11474,5,11,415,'10','5','3',54),(11475,5,11,415,'10','5','4',54),(11476,5,11,415,'10','5','5',54),(11477,5,11,415,'10','5','6',54),(11478,5,11,415,'10','5','7',54),(11479,5,11,415,'10','5','8',54),(11480,5,11,415,'7','5','9',54),(11481,5,11,415,'10','6','1',54),(11482,5,11,415,'10','6','2',54),(11483,5,11,415,'10','6','3',54),(11485,5,11,415,'10','6','5',54),(11486,5,11,415,'10','6','6',54),(11487,5,11,415,'10','6','7',54),(11488,5,11,415,'8','6','8',54),(11489,5,11,415,'M','6','9',54),(11490,5,11,415,'10','6','4',54),(11491,5,11,415,'10','7','1',54),(11492,5,11,415,'10','7','2',54),(11493,5,11,415,'10','7','3',54),(11494,5,11,415,'10','7','4',54),(11495,5,11,415,'10','7','5',54),(11496,5,11,415,'10','7','6',54),(11497,5,11,415,'10','7','7',54),(11498,5,11,415,'10','7','8',54),(11499,5,11,415,'M','7','9',54),(11500,10,11,263,'10','1','1',49),(11501,10,11,263,'10','1','2',49),(11502,10,11,263,'10','1','3',49),(11503,10,11,263,'10','1','4',49),(11504,10,11,263,'10','1','5',49),(11505,10,11,263,'10','1','6',49),(11506,10,11,263,'9','1','7',49),(11507,10,11,263,'10','2','1',49),(11508,5,11,416,'10','1','1',54),(11509,5,11,416,'10','1','2',54),(11510,10,11,263,'10','2','2',49),(11511,5,11,416,'10','1','3',54),(11512,10,11,263,'10','2','3',49),(11513,5,11,416,'10','1','4',54),(11514,10,11,263,'10','2','4',49),(11515,5,11,416,'10','1','5',54),(11516,10,11,263,'10','2','5',49),(11517,5,11,416,'10','1','6',54),(11518,10,11,263,'10','2','6',49),(11519,5,11,416,'10','1','7',54),(11520,5,11,416,'9','1','8',54),(11521,5,11,416,'M','1','9',54),(11522,5,11,416,'10','2','1',54),(11523,5,11,416,'10','2','2',54),(11524,5,11,416,'10','2','3',54),(11525,5,11,416,'10','2','4',54),(11526,5,11,416,'10','2','5',54),(11527,10,11,263,'10','2','7',49),(11528,5,11,416,'10','2','6',54),(11529,5,11,416,'10','2','7',54),(11530,5,11,416,'10','2','8',54),(11531,10,11,263,'10','3','1',49),(11532,5,11,416,'7','2','9',54),(11533,5,11,416,'10','3','1',54),(11534,10,11,263,'10','3','2',49),(11535,5,11,416,'10','3','2',54),(11536,5,11,416,'10','3','3',54),(11537,10,11,263,'10','3','3',49),(11538,5,11,416,'10','3','4',54),(11539,10,11,263,'10','3','4',49),(11540,5,11,416,'10','3','5',54),(11541,5,11,416,'10','3','6',54),(11542,10,11,263,'10','3','5',49),(11543,5,11,416,'10','3','7',54),(11544,10,11,263,'10','3','6',49),(11545,5,11,416,'10','3','8',54),(11546,10,11,263,'10','3','7',49),(11547,5,11,416,'1','3','9',54),(11548,10,11,263,'3','3','8',49),(11549,10,11,263,'10','4','1',49),(11550,10,11,263,'10','4','2',49),(11551,10,11,263,'10','4','3',49),(11552,10,11,263,'10','4','4',49),(11553,5,11,416,'10','4','1',54),(11554,10,11,263,'10','4','5',49),(11555,5,11,416,'10','4','2',54),(11556,10,11,263,'10','4','6',49),(11557,5,11,416,'10','4','3',54),(11558,5,11,416,'10','4','4',54),(11559,10,11,263,'7','4','7',49),(11560,5,11,416,'10','4','5',54),(11561,5,11,416,'10','4','6',54),(11562,5,11,416,'10','4','7',54),(11563,10,11,263,'10','5','1',49),(11564,5,11,416,'3','4','8',54),(11565,10,11,263,'10','5','2',49),(11566,5,11,416,'M','4','9',54),(11567,5,11,416,'10','5','1',54),(11568,5,11,416,'10','5','2',54),(11569,5,11,416,'10','5','3',54),(11570,5,11,416,'10','5','4',54),(11571,5,11,416,'10','5','5',54),(11572,5,11,416,'10','5','6',54),(11573,5,11,416,'10','5','7',54),(11574,5,11,416,'4','5','8',54),(11575,5,11,416,'M','5','9',54),(11576,5,11,416,'10','6','1',54),(11577,5,11,416,'10','6','2',54),(11578,5,11,416,'10','6','3',54),(11579,5,11,416,'10','6','4',54),(11580,5,11,416,'10','6','5',54),(11581,5,11,416,'10','6','6',54),(11582,5,11,416,'10','6','7',54),(11583,5,11,416,'10','6','8',54),(11584,5,11,416,'6','6','9',54),(11585,5,11,416,'10','7','1',54),(11586,5,11,416,'10','7','2',54),(11587,5,11,416,'10','7','3',54),(11588,5,11,416,'10','7','4',54),(11589,5,11,416,'10','7','5',54),(11590,5,11,416,'10','7','6',54),(11591,5,11,416,'10','7','7',54),(11592,5,11,416,'4','7','8',54),(11593,10,11,263,'10','5','4',49),(11594,5,11,416,'m','7','9',54),(11595,10,11,263,'10','5','3',49),(11596,10,11,263,'10','5','5',49),(11597,10,11,263,'10','5','6',49),(11598,10,11,263,'1','5','7',49),(11599,10,11,263,'10','6','1',49),(11600,10,11,263,'10','6','2',49),(11601,10,11,263,'10','6','3',49),(11602,10,11,263,'10','6','4',49),(11603,10,11,263,'10','6','5',49),(11604,10,11,263,'10','6','6',49),(11605,10,11,263,'10','6','7',49),(11606,10,11,263,'7','6','8',49),(11607,10,11,263,'10','7','1',49),(11608,10,11,263,'10','7','2',49),(11609,10,11,263,'10','7','3',49),(11610,10,11,263,'10','7','4',49),(11611,10,11,263,'10','7','5',49),(11612,10,11,263,'10','7','6',49),(11613,5,11,417,'10','1','1',54),(11614,10,11,263,'4','7','7',49),(11615,5,11,417,'10','1','2',54),(11616,5,11,417,'10','1','3',54),(11617,5,11,417,'10','1','4',54),(11618,5,11,417,'10','1','5',54),(11619,5,11,417,'10','1','6',54),(11620,5,11,417,'10','1','7',54),(11621,5,11,417,'10','1','8',54),(11622,5,11,417,'5','1','9',54),(11623,5,11,417,'10','2','1',54),(11624,5,11,417,'10','2','2',54),(11625,5,11,417,'10','2','3',54),(11626,5,11,417,'10','2','4',54),(11627,5,11,417,'10','2','5',54),(11628,5,11,417,'10','2','6',54),(11629,5,11,417,'10','2','7',54),(11630,5,11,417,'8','2','8',54),(11631,5,11,417,'M','2','9',54),(11632,5,11,417,'10','3','1',54),(11633,5,11,417,'10','3','2',54),(11634,5,11,417,'10','3','3',54),(11635,5,11,417,'10','3','4',54),(11636,5,11,417,'10','3','5',54),(11637,5,11,417,'10','3','6',54),(11638,5,11,417,'10','3','7',54),(11639,5,11,417,'9','3','8',54),(11640,5,11,417,'M','3','9',54),(11641,5,11,417,'10','4','1',54),(11642,5,11,417,'10','4','2',54),(11643,5,11,417,'10','4','3',54),(11644,5,11,417,'10','4','4',54),(11645,5,11,417,'10','4','5',54),(11646,5,11,417,'10','4','6',54),(11647,5,11,417,'10','4','7',54),(11648,5,11,417,'10','4','8',54),(11649,5,11,417,'1','4','9',54),(11650,5,11,417,'10','5','1',54),(11651,5,11,417,'10','5','2',54),(11652,5,11,417,'10','5','3',54),(11653,5,11,417,'10','5','4',54),(11654,5,11,417,'10','5','5',54),(11656,5,11,417,'10','5','7',54),(11657,5,11,417,'4','5','8',54),(11658,5,11,417,'M','5','9',54),(11659,5,11,417,'10','5','6',54),(11660,5,11,417,'10','6','1',54),(11661,5,11,417,'10','6','2',54),(11662,5,11,417,'10','6','3',54),(11663,5,11,417,'10','6','4',54),(11664,5,11,417,'10','6','5',54),(11665,5,11,417,'10','6','6',54),(11666,5,11,417,'10','6','7',54),(11667,5,11,417,'7','6','8',54),(11668,10,11,264,'10','1','1',49),(11669,10,11,264,'10','1','2',49),(11670,10,11,264,'10','1','3',49),(11671,10,11,264,'10','1','4',49),(11672,10,11,264,'10','1','5',49),(11673,10,11,264,'10','1','6',49),(11674,10,11,264,'8','1','7',49),(11675,10,11,264,'10','2','1',49),(11676,10,11,264,'10','2','2',49),(11677,10,11,264,'10','2','3',49),(11678,10,11,264,'10','2','4',49),(11679,10,11,264,'10','2','5',49),(11680,10,11,264,'10','2','6',49),(11681,10,11,264,'10','2','7',49),(11682,5,11,417,'M','6','9',54),(11683,5,11,417,'10','7','1',54),(11684,10,11,264,'1','2','8',49),(11685,5,11,417,'10','7','2',54),(11686,5,11,417,'10','7','3',54),(11687,5,11,417,'10','7','4',54),(11688,5,11,417,'10','7','5',54),(11689,5,11,417,'10','7','6',54),(11690,5,11,417,'10','7','7',54),(11691,5,11,417,'9','7','8',54),(11692,10,11,264,'10','3','1',49),(11693,5,11,417,'M','7','9',54),(11694,10,11,264,'10','3','2',49),(11695,10,11,264,'10','3','3',49),(11696,10,11,264,'10','3','4',49),(11697,10,11,264,'10','3','5',49),(11698,10,11,264,'8','3','6',49),(11699,10,11,264,'10','4','1',49),(11700,10,11,264,'10','4','2',49),(11701,10,11,264,'10','4','3',49),(11702,10,11,264,'10','4','4',49),(11703,10,11,264,'10','4','5',49),(11704,10,11,264,'10','4','6',49),(11705,10,11,264,'10','4','7',49),(11706,10,11,264,'1','4','8',49),(11707,10,11,264,'10','5','1',49),(11708,10,11,264,'10','5','2',49),(11709,10,11,264,'10','5','3',49),(11710,10,11,264,'10','5','4',49),(11711,10,11,264,'10','5','5',49),(11712,10,11,264,'10','5','6',49),(11713,10,11,264,'9','5','7',49),(11714,10,11,264,'10','6','1',49),(11715,10,11,264,'10','6','2',49),(11716,10,11,264,'10','6','3',49),(11717,10,11,264,'10','6','4',49),(11718,10,11,264,'10','6','5',49),(11719,10,11,264,'10','6','6',49),(11720,10,11,264,'3','6','7',49),(11721,10,11,264,'10','7','1',49),(11722,10,11,264,'10','7','2',49),(11723,10,11,264,'10','7','3',49),(11724,10,11,264,'10','7','4',49),(11725,10,11,264,'10','7','5',49),(11726,10,11,264,'10','7','6',49),(11727,10,11,264,'10','7','7',49),(11728,10,11,264,'7','7','8',49),(11729,10,11,265,'10','1','2',49),(11730,10,11,265,'10','1','1',49),(11731,10,11,265,'10','1','3',49),(11732,10,11,265,'10','1','4',49),(11733,10,11,265,'10','1','5',49),(11734,10,11,265,'10','1','6',49),(11735,10,11,265,'10','1','7',49),(11736,10,11,265,'2','1','8',49),(11737,10,11,265,'10','2','1',49),(11738,10,11,265,'10','2','2',49),(11739,10,11,265,'10','2','3',49),(11740,10,11,265,'10','2','4',49),(11741,10,11,265,'10','2','5',49),(11742,10,11,265,'10','2','6',49),(11743,10,11,265,'10','2','7',49),(11744,10,11,265,'10','3','1',49),(11745,10,11,265,'10','3','2',49),(11746,10,11,265,'10','3','3',49),(11747,10,11,265,'10','3','4',49),(11748,10,11,265,'10','3','5',49),(11749,10,11,265,'10','3','6',49),(11750,10,11,265,'10','3','7',49),(11751,10,11,265,'4','3','8',49),(11752,10,11,265,'10','4','1',49),(11753,5,11,419,'10','1','1',54),(11754,5,11,419,'10','1','2',54),(11755,5,11,419,'10','1','3',54),(11756,10,11,265,'10','4','2',49),(11757,5,11,419,'10','1','4',54),(11758,10,11,265,'10','4','3',49),(11759,5,11,419,'10','1','5',54),(11760,10,11,265,'10','4','4',49),(11761,5,11,419,'10','1','6',54),(11762,5,11,419,'10','1','7',54),(11763,5,11,419,'10','1','8',54),(11764,10,11,265,'10','4','5',49),(11765,5,11,419,'3','1','9',54),(11766,10,11,265,'10','4','6',49),(11767,10,11,265,'10','4','7',49),(11768,5,11,419,'10','2','1',54),(11769,5,11,419,'10','2','2',54),(11770,5,11,419,'10','2','3',54),(11771,10,11,265,'7','4','8',49),(11772,5,11,419,'10','2','4',54),(11773,5,11,419,'10','2','5',54),(11774,5,11,419,'10','2','6',54),(11775,5,11,419,'10','2','7',54),(11776,5,11,419,'9','2','8',54),(11777,5,11,419,'M','2','9',54),(11778,5,11,419,'10','3','1',54),(11779,5,11,419,'10','3','2',54),(11780,5,11,419,'10','3','3',54),(11781,5,11,419,'10','3','4',54),(11782,5,11,419,'10','3','5',54),(11783,10,11,265,'10','5','1',49),(11784,5,11,419,'10','3','6',54),(11785,5,11,419,'10','3','7',54),(11786,5,11,419,'10','3','8',54),(11787,5,11,419,'3','3','9',54),(11788,10,11,265,'10','5','2',49),(11789,10,11,265,'10','5','3',49),(11790,10,11,265,'10','5','4',49),(11791,10,11,265,'10','5','5',49),(11792,10,11,265,'2','5','6',49),(11793,10,11,265,'10','6','1',49),(11794,10,11,265,'10','6','2',49),(11795,10,11,265,'10','6','3',49),(11796,10,11,265,'10','6','4',49),(11797,10,11,265,'10','6','5',49),(11798,10,11,265,'10','6','6',49),(11800,5,11,419,'10','4','1',54),(11801,5,11,419,'10','4','2',54),(11802,5,11,419,'10','4','3',54),(11803,5,11,419,'10','4','4',54),(11804,5,11,419,'10','4','5',54),(11805,5,11,419,'10','4','6',54),(11806,5,11,419,'10','4','7',54),(11807,5,11,419,'7','4','8',54),(11808,5,11,419,'M','4','9',54),(11809,5,11,419,'10','5','1',54),(11810,5,11,419,'10','5','2',54),(11811,5,11,419,'10','5','3',54),(11812,5,11,419,'10','5','4',54),(11813,5,11,419,'10','5','5',54),(11814,5,11,419,'10','5','6',54),(11815,5,11,419,'10','5','7',54),(11816,5,11,419,'10','5','8',54),(11817,5,11,419,'M','5','9',54),(11818,5,11,419,'10','6','1',54),(11819,5,11,419,'10','6','2',54),(11820,5,11,419,'10','6','3',54),(11821,5,11,419,'10','6','4',54),(11822,5,11,419,'10','6','5',54),(11823,5,11,419,'10','6','6',54),(11824,5,11,419,'10','6','7',54),(11825,5,11,419,'8','6','8',54),(11826,5,11,419,'M','6','9',54),(11827,5,11,419,'10','7','1',54),(11828,5,11,419,'10','7','2',54),(11829,5,11,419,'10','7','3',54),(11830,5,11,419,'10','7','4',54),(11831,5,11,419,'10','7','5',54),(11832,5,11,419,'10','7','6',54),(11833,5,11,419,'10','7','7',54),(11834,5,11,419,'1','7','8',54),(11835,10,11,265,'10','7','1',49),(11836,5,11,419,'M','7','9',54),(11837,10,11,265,'10','7','2',49),(11838,10,11,265,'10','7','3',49),(11839,10,11,265,'10','7','4',49),(11840,10,11,265,'10','7','5',49),(11841,10,11,265,'10','7','6',49),(11842,10,11,265,'10','7','7',49),(11843,10,11,265,'2','7','8',49),(11844,5,11,420,'10','1','1',54),(11845,5,11,420,'10','1','2',54),(11846,5,11,420,'10','1','3',54),(11847,5,11,420,'10','1','4',54),(11848,5,11,420,'10','1','5',54),(11849,5,11,420,'10','1','6',54),(11850,5,11,420,'10','1','7',54),(11851,5,11,420,'5','1','8',54),(11852,5,11,420,'M','1','9',54),(11853,5,11,420,'10','2','1',54),(11854,5,11,420,'10','2','2',54),(11855,5,11,420,'10','2','3',54),(11856,5,11,420,'10','2','4',54),(11857,5,11,420,'10','2','5',54),(11858,5,11,420,'10','2','6',54),(11859,5,11,420,'10','2','7',54),(11860,5,11,420,'10','2','8',54),(11861,5,11,420,'5','2','9',54),(11862,5,11,420,'10','3','1',54),(11863,5,11,420,'10','3','2',54),(11864,5,11,420,'10','3','3',54),(11865,5,11,420,'10','3','4',54),(11866,5,11,420,'10','3','5',54),(11867,5,11,420,'10','3','6',54),(11868,5,11,420,'10','3','7',54),(11869,5,11,420,'6','3','8',54),(11870,5,11,420,'M','3','9',54),(11871,5,11,420,'10','4','1',54),(11872,5,11,420,'10','4','2',54),(11873,5,11,420,'10','4','3',54),(11874,5,11,420,'10','4','4',54),(11875,5,11,420,'10','4','5',54),(11876,5,11,420,'10','4','6',54),(11877,5,11,420,'10','4','7',54),(11878,5,11,420,'6','4','8',54),(11879,5,11,420,'M','4','9',54),(11880,5,11,420,'10','5','1',54),(11881,5,11,420,'10','5','2',54),(11882,5,11,420,'10','5','3',54),(11883,5,11,420,'10','5','4',54),(11884,5,11,420,'10','5','5',54),(11885,5,11,420,'10','5','6',54),(11886,5,11,420,'10','5','7',54),(11887,5,11,420,'10','5','8',54),(11888,5,11,420,'1','5','9',54),(11889,5,11,420,'10','6','1',54),(11890,5,11,420,'10','6','2',54),(11891,5,11,420,'10','6','3',54),(11892,5,11,420,'10','6','4',54),(11893,5,11,420,'10','6','5',54),(11894,5,11,420,'10','6','6',54),(11895,5,11,420,'10','6','7',54),(11896,5,11,420,'8','6','8',54),(11897,5,11,420,'M','6','9',54),(11898,5,11,420,'10','7','1',54),(11899,5,11,420,'10','7','2',54),(11900,5,11,420,'10','7','3',54),(11901,5,11,420,'10','7','4',54),(11902,5,11,420,'10','7','5',54),(11903,5,11,420,'10','7','6',54),(11904,5,11,420,'10','7','7',54),(11905,5,11,420,'9','7','8',54),(11906,5,11,420,'M','7','9',54),(11907,5,11,422,'10','1','1',54),(11908,5,11,422,'10','1','2',54),(11909,5,11,422,'10','1','3',54),(11910,5,11,422,'10','1','4',54),(11911,5,11,422,'10','1','5',54),(11912,5,11,422,'10','1','6',54),(11913,5,11,422,'10','1','7',54),(11914,5,11,422,'8','1','8',54),(11915,5,11,422,'M','1','9',54),(11916,5,11,422,'10','2','1',54),(11917,5,11,422,'10','2','2',54),(11918,5,11,422,'10','2','3',54),(11919,5,11,422,'10','2','4',54),(11920,10,11,266,'10','1','1',49),(11921,10,11,266,'10','1','2',49),(11922,5,11,422,'10','2','5',54),(11923,5,11,422,'10','2','6',54),(11924,10,11,266,'10','1','3',49),(11925,5,11,422,'10','2','7',54),(11926,10,11,266,'10','1','4',49),(11927,5,11,422,'5','2','8',54),(11928,10,11,266,'10','1','5',49),(11929,10,11,266,'10','1','6',49),(11930,5,11,422,'M','2','9',54),(11931,10,11,266,'10','1','7',49),(11932,5,11,422,'10','3','1',54),(11933,10,11,266,'4','1','8',49),(11934,5,11,422,'10','3','2',54),(11935,5,11,422,'10','3','3',54),(11936,5,11,422,'10','3','4',54),(11938,5,11,422,'10','3','5',54),(11939,5,11,422,'10','3','6',54),(11940,5,11,422,'10','3','7',54),(11941,5,11,422,'8','3','8',54),(11942,5,11,422,'M','3','9',54),(11943,5,11,422,'10','4','1',54),(11944,5,11,422,'10','4','2',54),(11945,5,11,422,'10','4','3',54),(11946,5,11,422,'10','4','4',54),(11947,5,11,422,'10','4','5',54),(11948,5,11,422,'10','4','6',54),(11949,10,11,266,'10','2','1',49),(11950,10,11,266,'10','2','2',49),(11951,10,11,266,'10','2','3',49),(11952,10,11,266,'10','2','4',49),(11953,10,11,266,'10','2','5',49),(11954,10,11,266,'10','2','6',49),(11955,10,11,266,'9','2','7',49),(11956,5,11,422,'10','4','7',54),(11957,5,11,422,'6','4','8',54),(11958,5,11,422,'M','4','9',54),(11959,10,11,266,'10','3','1',49),(11960,5,11,422,'10','5','1',54),(11961,10,11,266,'10','3','2',49),(11962,5,11,422,'10','5','2',54),(11963,10,11,266,'10','3','3',49),(11964,5,11,422,'10','5','3',54),(11965,10,11,266,'10','3','4',49),(11966,10,11,266,'10','3','5',49),(11967,5,11,422,'10','5','4',54),(11968,10,11,266,'10','3','6',49),(11969,5,11,422,'10','5','5',54),(11970,5,11,422,'10','5','6',54),(11971,10,11,266,'7','3','7',49),(11972,5,11,422,'10','5','7',54),(11973,5,11,422,'6','5','8',54),(11974,5,11,422,'M','5','9',54),(11975,10,11,266,'10','4','1',49),(11976,10,11,266,'10','4','2',49),(11977,10,11,266,'10','4','3',49),(11978,10,11,266,'10','4','4',49),(11979,10,11,266,'10','4','5',49),(11980,5,11,422,'10','6','1',54),(11981,5,11,422,'10','6','2',54),(11982,10,11,266,'10','4','6',49),(11983,5,11,422,'10','6','3',54),(11984,10,11,266,'2','4','7',49),(11985,5,11,422,'10','6','4',54),(11986,5,11,422,'10','6','5',54),(11987,5,11,422,'10','6','6',54),(11988,5,11,422,'10','6','7',54),(11989,5,11,422,'10','6','8',54),(11990,10,11,266,'10','5','1',49),(11991,5,11,422,'8','6','9',54),(11992,10,11,266,'10','5','2',49),(11993,5,11,422,'10','7','1',54),(11994,5,11,422,'10','7','2',54),(11995,10,11,266,'10','5','3',49),(11996,5,11,422,'10','7','3',54),(11997,10,11,266,'10','5','4',49),(11998,5,11,422,'10','7','4',54),(11999,5,11,422,'10','7','5',54),(12000,10,11,266,'10','5','5',49),(12001,5,11,422,'10','7','6',54),(12002,10,11,266,'9','5','6',49),(12003,5,11,422,'10','7','7',54),(12004,10,11,266,'10','6','1',49),(12005,10,11,266,'10','6','2',49),(12006,10,11,266,'10','6','3',49),(12007,5,11,422,'7','7','8',54),(12008,5,11,422,'M','7','9',54),(12009,10,11,266,'10','6','4',49),(12010,10,11,266,'10','6','5',49),(12011,10,11,266,'10','6','6',49),(12012,10,11,266,'9','6','7',49),(12013,10,11,266,'10','7','2',49),(12014,10,11,266,'10','7','3',49),(12015,10,11,266,'10','7','4',49),(12016,10,11,266,'10','7','5',49),(12017,10,11,266,'10','7','6',49),(12018,10,11,266,'10','7','7',49),(12019,10,11,266,'7','7','8',49),(12020,10,11,266,'10','7','1',49),(12021,10,11,267,'10','1','1',49),(12022,10,11,267,'10','1','2',49),(12023,10,11,267,'10','1','3',49),(12024,10,11,267,'10','1','4',49),(12025,10,11,267,'10','1','5',49),(12026,10,11,267,'6','1','6',49),(12027,10,11,267,'10','2','1',49),(12028,10,11,267,'10','2','2',49),(12029,10,11,267,'10','2','3',49),(12030,10,11,267,'10','2','4',49),(12031,10,11,267,'10','2','5',49),(12032,10,11,267,'10','2','6',49),(12033,10,11,267,'6','2','7',49),(12034,5,11,424,'10','1','1',54),(12035,5,11,424,'10','1','2',54),(12036,5,11,424,'10','1','3',54),(12037,5,11,424,'10','1','4',54),(12038,5,11,424,'10','1','5',54),(12039,10,11,267,'10','3','1',49),(12040,5,11,424,'10','1','6',54),(12041,10,11,267,'10','3','2',49),(12042,5,11,424,'10','1','7',54),(12043,5,11,424,'10','1','8',54),(12044,10,11,267,'10','3','3',49),(12045,5,11,424,'1','1','9',54),(12046,10,11,267,'10','3','4',49),(12047,5,11,424,'10','2','1',54),(12048,10,11,267,'10','3','5',49),(12049,5,11,424,'10','2','2',54),(12050,10,11,267,'10','3','6',49),(12051,5,11,424,'10','2','3',54),(12052,10,11,267,'8','3','7',49),(12053,5,11,424,'10','2','4',54),(12054,5,11,424,'10','2','5',54),(12055,5,11,424,'10','2','6',54),(12056,5,11,424,'10','2','7',54),(12057,10,11,267,'10','4','1',49),(12058,5,11,424,'7','2','8',54),(12059,10,11,267,'10','4','2',49),(12060,10,11,267,'10','4','3',49),(12061,5,11,424,'M','2','9',54),(12062,10,11,267,'10','4','4',49),(12063,5,11,424,'10','3','1',54),(12064,10,11,267,'10','4','5',49),(12065,5,11,424,'10','3','2',54),(12066,10,11,267,'10','4','6',49),(12067,5,11,424,'10','3','3',54),(12068,10,11,267,'10','4','7',49),(12069,5,11,424,'10','3','4',54),(12070,5,11,424,'10','3','5',54),(12071,5,11,424,'10','3','6',54),(12072,10,11,267,'1','4','8',49),(12073,5,11,424,'10','3','7',54),(12074,10,11,267,'10','5','1',49),(12075,5,11,424,'2','3','8',54),(12076,10,11,267,'10','5','2',49),(12077,5,11,424,'M','3','9',54),(12078,10,11,267,'10','5','3',49),(12079,5,11,424,'10','4','1',54),(12080,10,11,267,'10','5','4',49),(12081,5,11,424,'10','4','2',54),(12082,5,11,424,'10','4','3',54),(12083,5,11,424,'10','4','4',54),(12084,10,11,267,'10','5','5',49),(12085,5,11,424,'10','4','5',54),(12086,10,11,267,'10','5','6',49),(12087,5,11,424,'10','4','6',54),(12088,10,11,267,'10','5','7',49),(12089,5,11,424,'10','4','7',54),(12090,5,11,424,'10','4','8',54),(12091,10,11,267,'5','5','8',49),(12092,5,11,424,'4','4','9',54),(12093,5,11,424,'10','5','1',54),(12094,5,11,424,'10','5','2',54),(12095,5,11,424,'10','5','3',54),(12096,5,11,424,'10','5','4',54),(12097,10,11,267,'10','6','1',49),(12098,5,11,424,'10','5','5',54),(12099,10,11,267,'10','6','2',49),(12100,5,11,424,'10','5','6',54),(12101,5,11,424,'10','5','7',54),(12102,10,11,267,'10','6','3',49),(12103,5,11,424,'10','5','8',54),(12104,10,11,267,'10','6','4',49),(12105,5,11,424,'6','5','9',54),(12106,10,11,267,'10','6','5',49),(12107,10,11,267,'10','6','6',49),(12108,5,11,424,'10','6','1',54),(12109,10,11,267,'5','6','7',49),(12110,5,11,424,'10','6','2',54),(12111,5,11,424,'10','6','3',54),(12112,5,11,424,'10','6','4',54),(12113,5,11,424,'10','6','5',54),(12114,5,11,424,'10','6','6',54),(12115,5,11,424,'6','6','7',54),(12116,5,11,424,'M','6','8',54),(12117,5,11,424,'M','6','9',54),(12118,5,11,424,'10','7','1',54),(12119,5,11,424,'10','7','2',54),(12120,5,11,424,'10','7','3',54),(12121,10,11,267,'10','7','1',49),(12122,5,11,424,'10','7','4',54),(12123,10,11,267,'10','7','2',49),(12124,5,11,424,'10','7','5',54),(12125,10,11,267,'10','7','3',49),(12126,5,11,424,'10','7','6',54),(12127,10,11,267,'10','7','4',49),(12128,5,11,424,'10','7','7',54),(12129,5,11,424,'5','7','8',54),(12130,5,11,424,'M','7','9',54),(12131,10,11,267,'10','7','5',49),(12132,10,11,267,'10','7','6',49),(12133,10,11,267,'9','7','7',49),(12135,5,11,427,'10','1','1',54),(12136,5,11,427,'10','1','2',54),(12137,5,11,427,'10','1','3',54),(12138,5,11,427,'10','1','4',54),(12139,5,11,427,'10','1','5',54),(12140,5,11,427,'10','1','6',54),(12141,5,11,427,'10','1','7',54),(12142,5,11,427,'4','1','8',54),(12143,5,11,427,'M','1','9',54),(12144,5,11,427,'10','2','1',54),(12145,5,11,427,'10','2','2',54),(12146,5,11,427,'10','2','3',54),(12147,5,11,427,'10','2','4',54),(12148,10,11,268,'10','1','1',49),(12149,5,11,427,'10','2','5',54),(12150,10,11,268,'10','1','2',49),(12151,5,11,427,'10','2','6',54),(12152,5,11,427,'10','2','7',54),(12153,10,11,268,'10','1','3',49),(12154,5,11,427,'10','2','8',54),(12155,10,11,268,'10','1','4',49),(12156,5,11,427,'1','2','9',54),(12157,10,11,268,'10','1','5',49),(12158,5,11,427,'10','3','1',54),(12159,10,11,268,'10','1','6',49),(12160,5,11,427,'10','3','2',54),(12161,5,11,427,'10','3','3',54),(12162,5,11,427,'10','3','4',54),(12163,5,11,427,'10','3','5',54),(12164,5,11,427,'10','3','6',54),(12165,10,11,268,'10','1','7',49),(12166,5,11,427,'10','3','7',54),(12167,10,11,268,'4','1','8',49),(12168,5,11,427,'7','3','8',54),(12169,5,11,427,'M','3','9',54),(12170,5,11,427,'10','4','1',54),(12171,10,11,268,'10','2','1',49),(12172,5,11,427,'10','4','2',54),(12173,5,11,427,'10','4','3',54),(12174,10,11,268,'10','2','2',49),(12175,5,11,427,'10','4','4',54),(12176,10,11,268,'10','2','3',49),(12177,5,11,427,'10','4','5',54),(12178,5,11,427,'10','4','6',54),(12179,10,11,268,'10','2','4',49),(12180,5,11,427,'10','4','7',54),(12181,10,11,268,'10','2','5',49),(12182,10,11,268,'10','2','6',49),(12183,5,11,427,'7','4','8',54),(12184,10,11,268,'5','2','7',49),(12185,5,11,427,'M','4','9',54),(12186,10,11,268,'10','3','1',49),(12187,5,11,427,'10','5','1',54),(12188,5,11,427,'10','5','2',54),(12189,10,11,268,'10','3','2',49),(12190,5,11,427,'10','5','3',54),(12191,5,11,427,'10','5','4',54),(12192,10,11,268,'10','3','3',49),(12193,5,11,427,'10','5','5',54),(12194,10,11,268,'10','3','4',49),(12195,5,11,427,'10','5','6',54),(12196,10,11,268,'10','3','5',49),(12197,5,11,427,'10','5','7',54),(12198,10,11,268,'10','3','6',49),(12199,5,11,427,'6','5','8',54),(12200,10,11,268,'5','3','7',49),(12201,5,11,427,'M','5','9',54),(12202,5,11,427,'10','6','1',54),(12203,5,11,427,'10','6','2',54),(12204,10,11,268,'10','4','1',49),(12205,5,11,427,'10','6','3',54),(12206,10,11,268,'10','4','2',49),(12207,5,11,427,'10','6','4',54),(12208,10,11,268,'10','4','3',49),(12209,5,11,427,'10','6','5',54),(12210,10,11,268,'10','4','4',49),(12211,5,11,427,'10','6','6',54),(12212,10,11,268,'10','4','5',49),(12213,5,11,427,'10','6','7',54),(12214,10,11,268,'10','4','6',49),(12215,5,11,427,'8','6','8',54),(12216,10,11,268,'10','4','7',49),(12217,5,11,427,'M','6','9',54),(12218,5,11,427,'10','7','1',54),(12220,5,11,427,'10','7','2',54),(12221,5,11,427,'10','7','3',54),(12222,5,11,427,'10','7','4',54),(12223,5,11,427,'10','7','5',54),(12224,5,11,427,'10','7','6',54),(12225,5,11,427,'10','7','7',54),(12226,5,11,427,'8','7','8',54),(12227,5,11,427,'M','7','9',54),(12228,10,11,268,'2','4','8',49),(12229,10,11,268,'10','5','1',49),(12230,10,11,268,'10','5','2',49),(12231,10,11,268,'10','5','3',49),(12232,10,11,268,'10','5','4',49),(12233,10,11,268,'10','5','5',49),(12234,10,11,268,'10','5','6',49),(12235,10,11,268,'10','5','7',49),(12236,10,11,268,'3','5','8',49),(12237,10,11,268,'10','6','1',49),(12238,10,11,268,'10','6','2',49),(12239,10,11,268,'10','6','3',49),(12240,10,11,268,'10','6','4',49),(12241,10,11,268,'10','6','5',49),(12242,10,11,268,'10','6','6',49),(12243,10,11,268,'2','6','7',49),(12244,10,11,268,'10','7','1',49),(12245,10,11,268,'10','7','2',49),(12246,10,11,268,'10','7','3',49),(12247,10,11,268,'10','7','4',49),(12248,10,11,268,'10','7','5',49),(12249,10,11,268,'7','7','6',49),(12250,10,11,269,'10','1','1',49),(12251,10,11,269,'10','1','2',49),(12252,10,11,269,'10','1','3',49),(12253,10,11,269,'10','1','4',49),(12254,10,11,269,'10','1','5',49),(12255,10,11,269,'10','1','6',49),(12256,10,11,269,'10','1','7',49),(12258,10,11,269,'1','1','8',49),(12259,10,11,269,'10','2','1',49),(12260,10,11,269,'10','2','2',49),(12261,10,11,269,'10','2','3',49),(12262,10,11,269,'10','2','4',49),(12263,10,11,269,'10','2','5',49),(12264,10,11,269,'10','2','6',49),(12265,10,11,269,'1','2','7',49),(12266,10,11,269,'10','3','1',49),(12267,10,11,269,'10','3','2',49),(12268,10,11,269,'10','3','3',49),(12269,10,11,269,'10','3','4',49),(12270,10,11,269,'10','3','5',49),(12271,10,11,269,'10','3','6',49),(12272,10,11,269,'9','3','7',49),(12273,10,11,269,'10','4','1',49),(12274,10,11,269,'10','4','2',49),(12275,10,11,269,'10','4','3',49),(12276,10,11,269,'10','4','4',49),(12277,10,11,269,'10','4','5',49),(12278,10,11,269,'10','4','6',49),(12279,10,11,269,'2','4','7',49),(12280,10,11,269,'10','5','1',49),(12281,10,11,269,'10','5','2',49),(12282,10,11,269,'10','5','3',49),(12283,10,11,269,'10','5','4',49),(12284,10,11,269,'10','5','5',49),(12285,10,11,269,'10','5','6',49),(12287,10,11,269,'4','5','7',49),(12288,10,11,269,'10','6','1',49),(12289,10,11,269,'10','6','2',49),(12290,10,11,269,'10','6','3',49),(12291,10,11,269,'10','6','4',49),(12292,10,11,269,'10','6','5',49),(12293,10,11,269,'7','6','6',49),(12294,10,11,269,'10','7','1',49),(12295,10,11,269,'10','7','2',49),(12296,10,11,269,'10','7','3',49),(12297,10,11,269,'10','7','4',49),(12298,10,11,269,'5','7','5',49),(12299,5,11,613,'10','1','2',54),(12300,5,11,613,'10','1','1',54),(12301,5,11,613,'10','1','3',54),(12302,5,11,613,'10','1','4',54),(12303,5,11,613,'10','1','5',54),(12304,5,11,613,'10','1','6',54),(12305,5,11,613,'10','1','7',54),(12306,5,11,613,'6','1','8',54),(12307,5,11,613,'M','1','9',54),(12308,5,11,613,'10','2','1',54),(12309,5,11,613,'10','2','2',54),(12310,5,11,613,'10','2','3',54),(12311,5,11,613,'10','2','4',54),(12312,5,11,613,'10','2','5',54),(12313,5,11,613,'10','2','6',54),(12314,5,11,613,'10','2','7',54),(12315,5,11,613,'10','2','8',54),(12316,5,11,613,'M','2','9',54),(12317,5,11,613,'10','3','1',54),(12318,5,11,613,'10','3','2',54),(12319,5,11,613,'10','3','3',54),(12320,5,11,613,'10','3','4',54),(12321,5,11,613,'10','3','5',54),(12322,5,11,613,'10','3','6',54),(12323,5,11,613,'7','3','7',54),(12324,5,11,613,'M','3','8',54),(12325,5,11,613,'M','3','9',54),(12326,5,11,613,'10','4','1',54),(12327,5,11,613,'10','4','2',54),(12328,5,11,613,'10','4','3',54),(12329,5,11,613,'10','4','4',54),(12330,5,11,613,'10','4','5',54),(12331,5,11,613,'10','4','6',54),(12332,5,11,613,'10','4','7',54),(12333,5,11,613,'10','4','8',54),(12334,5,11,613,'1','4','9',54),(12335,5,11,613,'10','5','1',54),(12336,5,11,613,'10','5','2',54),(12337,5,11,613,'10','5','3',54),(12338,5,11,613,'10','5','4',54),(12339,5,11,613,'10','5','5',54),(12340,5,11,613,'10','5','6',54),(12341,5,11,613,'9','5','7',54),(12342,5,11,613,'M','5','8',54),(12343,5,11,613,'M','5','9',54),(12344,5,11,613,'10','6','1',54),(12345,5,11,613,'10','6','2',54),(12346,5,11,613,'10','6','3',54),(12347,5,11,613,'10','6','4',54),(12348,5,11,613,'10','6','5',54),(12349,5,11,613,'10','6','6',54),(12350,5,11,613,'10','6','7',54),(12351,5,11,613,'10','6','8',54),(12352,5,11,613,'3','6','9',54),(12353,5,11,613,'10','7','1',54),(12354,5,11,613,'10','7','2',54),(12355,5,11,613,'10','7','3',54),(12356,5,11,613,'10','7','4',54),(12357,5,11,613,'10','7','5',54),(12358,5,11,613,'10','7','6',54),(12359,5,11,613,'10','7','7',54),(12360,5,11,613,'10','7','8',54),(12361,5,11,613,'M','7','9',54),(12362,5,11,614,'10','1','1',54),(12363,5,11,614,'10','1','2',54),(12364,5,11,614,'10','1','3',54),(12365,5,11,614,'10','1','4',54),(12366,5,11,614,'10','1','5',54),(12367,5,11,614,'10','1','6',54),(12368,5,11,614,'10','1','7',54),(12369,5,11,614,'4','1','8',54),(12370,5,11,614,'M','1','9',54),(12371,5,11,614,'10','2','1',54),(12372,5,11,614,'10','2','2',54),(12373,5,11,614,'10','2','3',54),(12374,5,11,614,'10','2','4',54),(12375,5,11,614,'10','2','5',54),(12376,5,11,614,'10','2','6',54),(12377,5,11,614,'10','2','7',54),(12378,5,11,614,'3','2','8',54),(12379,5,11,614,'M','2','9',54),(12380,5,11,614,'10','3','1',54),(12381,5,11,614,'10','3','2',54),(12382,5,11,614,'10','3','3',54),(12383,5,11,614,'10','3','4',54),(12384,5,11,614,'10','3','5',54),(12385,5,11,614,'10','3','6',54),(12386,5,11,614,'10','3','7',54),(12387,5,11,614,'6','3','8',54),(12388,5,11,614,'M','3','9',54),(12389,5,11,614,'10','4','1',54),(12390,5,11,614,'10','4','2',54),(12391,5,11,614,'10','4','3',54),(12392,5,11,614,'10','4','4',54),(12393,5,11,614,'10','4','5',54),(12394,5,11,614,'10','4','6',54),(12395,5,11,614,'10','4','7',54),(12396,5,11,614,'10','4','8',54),(12397,5,11,614,'1','4','9',54),(12398,5,11,614,'10','5','1',54),(12399,5,11,614,'10','5','2',54),(12400,5,11,614,'10','5','3',54),(12401,5,11,614,'10','5','4',54),(12402,5,11,614,'10','5','5',54),(12403,5,11,614,'10','5','6',54),(12404,5,11,614,'10','5','7',54),(12405,5,11,614,'8','5','8',54),(12406,5,11,614,'M','5','9',54),(12407,5,11,614,'10','6','1',54),(12408,5,11,614,'10','6','2',54),(12409,5,11,614,'10','6','3',54),(12410,5,11,614,'10','6','4',54),(12411,5,11,614,'10','6','5',54),(12412,5,11,614,'10','6','6',54),(12413,5,11,614,'10','6','7',54),(12414,5,11,614,'9','6','8',54),(12415,5,11,614,'M','6','9',54),(12416,5,11,614,'10','7','1',54),(12417,5,11,614,'10','7','2',54),(12418,5,11,614,'10','7','3',54),(12419,5,11,614,'10','7','4',54),(12420,5,11,614,'10','7','5',54),(12421,5,11,614,'10','7','6',54),(12422,5,11,614,'10','7','7',54),(12423,5,11,614,'5','7','8',54),(12424,5,11,614,'M','7','9',54),(12425,5,11,428,'10','1','1',54),(12426,5,11,428,'10','1','2',54),(12427,5,11,428,'10','1','3',54),(12428,5,11,428,'10','1','4',54),(12429,5,11,428,'10','1','5',54),(12430,5,11,428,'10','1','6',54),(12431,5,11,428,'10','1','7',54),(12432,5,11,428,'7','1','8',54),(12433,5,11,428,'M','1','9',54),(12434,5,11,428,'10','2','1',54),(12435,5,11,428,'10','2','2',54),(12436,5,11,428,'10','2','3',54),(12437,5,11,428,'10','2','4',54),(12438,5,11,428,'10','2','5',54),(12439,5,11,428,'10','2','6',54),(12440,5,11,428,'10','2','7',54),(12441,5,11,428,'10','2','8',54),(12442,5,11,428,'M','2','9',54),(12443,5,11,428,'10','3','1',54),(12444,5,11,428,'10','3','2',54),(12445,5,11,428,'10','3','3',54),(12446,5,11,428,'10','3','4',54),(12447,5,11,428,'10','3','5',54),(12448,5,11,428,'10','3','6',54),(12449,5,11,428,'10','3','7',54),(12450,5,11,428,'10','3','8',54),(12451,5,11,428,'M','3','9',54),(12452,5,11,428,'10','4','1',54),(12453,5,11,428,'10','4','2',54),(12454,5,11,428,'10','4','3',54),(12455,5,11,428,'10','4','4',54),(12456,5,11,428,'10','4','5',54),(12457,5,11,428,'10','4','6',54),(12458,5,11,428,'8','4','7',54),(12459,5,11,428,'M','4','8',54),(12460,5,11,428,'M','4','9',54),(12461,5,11,428,'10','5','1',54),(12462,5,11,428,'10','5','2',54),(12463,5,11,428,'10','5','3',54),(12464,5,11,428,'10','5','4',54),(12465,5,11,428,'10','5','5',54),(12466,5,11,428,'10','5','6',54),(12467,5,11,428,'10','5','7',54),(12468,5,11,428,'10','5','8',54),(12469,5,11,428,'1','5','9',54),(12470,5,11,428,'10','6','1',54),(12471,5,11,428,'10','6','2',54),(12472,5,11,428,'10','6','3',54),(12473,5,11,428,'10','6','4',54),(12474,5,11,428,'10','6','5',54),(12475,5,11,428,'10','6','6',54),(12476,5,11,428,'10','6','7',54),(12477,5,11,428,'10','6','8',54),(12478,5,11,428,'5','6','9',54),(12479,5,11,428,'10','7','1',54),(12480,5,11,428,'10','7','2',54),(12481,5,11,428,'10','7','3',54),(12483,5,11,428,'10','7','5',54),(12484,5,11,428,'10','7','6',54),(12485,5,11,428,'4','7','7',54),(12486,5,11,428,'M','7','8',54),(12487,5,11,428,'M','7','9',54),(12488,5,11,428,'10','7','4',54),(12489,5,11,430,'10','1','2',54),(12490,5,11,430,'10','1','1',54),(12491,5,11,430,'10','1','3',54),(12492,5,11,430,'10','1','4',54),(12493,5,11,430,'10','1','5',54),(12494,5,11,430,'10','1','6',54),(12495,5,11,430,'10','1','7',54),(12496,5,11,430,'10','1','8',54),(12497,5,11,430,'M','1','9',54),(12498,5,11,430,'10','2','1',54),(12499,5,11,430,'10','2','2',54),(12500,5,11,430,'10','2','3',54),(12501,5,11,430,'10','2','4',54),(12502,5,11,430,'10','2','5',54),(12503,5,11,430,'10','2','6',54),(12504,5,11,430,'10','2','7',54),(12505,5,11,430,'7','2','8',54),(12506,5,11,430,'M','2','9',54),(12507,5,11,430,'10','3','1',54),(12508,5,11,430,'10','3','2',54),(12509,5,11,430,'10','3','3',54),(12510,5,11,430,'10','3','4',54),(12511,5,11,430,'10','3','5',54),(12512,5,11,430,'10','3','6',54),(12513,5,11,430,'10','3','7',54),(12514,5,11,430,'9','3','8',54),(12515,5,11,430,'M','3','9',54),(12516,5,11,430,'10','4','1',54),(12517,5,11,430,'10','4','2',54),(12518,5,11,430,'10','4','3',54),(12519,5,11,430,'10','4','4',54),(12520,5,11,430,'10','4','5',54),(12521,5,11,430,'10','4','6',54),(12522,5,11,430,'10','4','7',54),(12523,5,11,430,'8','4','8',54),(12524,5,11,430,'M','4','9',54),(12525,5,11,430,'10','5','1',54),(12526,5,11,430,'10','5','2',54),(12527,5,11,430,'10','5','3',54),(12528,5,11,430,'10','5','4',54),(12529,5,11,430,'10','5','6',54),(12530,5,11,430,'10','5','5',54),(12531,5,11,430,'10','5','7',54),(12532,5,11,430,'4','5','8',54),(12533,5,11,430,'M','5','9',54),(12534,5,11,430,'10','6','1',54),(12535,5,11,430,'10','6','2',54),(12536,5,11,430,'10','6','3',54),(12537,5,11,430,'10','6','4',54),(12538,5,11,430,'10','6','5',54),(12539,5,11,430,'10','6','6',54),(12540,5,11,430,'10','6','7',54),(12541,5,11,430,'4','6','8',54),(12542,5,11,430,'M','6','9',54),(12543,5,11,430,'10','7','1',54),(12544,5,11,430,'10','7','2',54),(12545,5,11,430,'10','7','3',54),(12546,5,11,430,'10','7','4',54),(12547,5,11,430,'10','7','5',54),(12548,5,11,430,'10','7','6',54),(12549,5,11,430,'10','7','7',54),(12550,5,11,430,'3','7','8',54),(12551,5,11,430,'M','7','9',54),(12552,5,11,432,'10','1','1',54),(12553,5,11,432,'10','1','2',54),(12554,5,11,432,'10','1','3',54),(12555,5,11,432,'10','1','4',54),(12556,5,11,432,'10','1','5',54),(12557,5,11,432,'10','1','6',54),(12558,5,11,432,'10','1','7',54),(12559,5,11,432,'7','1','8',54),(12560,5,11,432,'M','1','9',54),(12561,5,11,432,'10','2','1',54),(12562,5,11,432,'10','2','2',54),(12563,5,11,432,'10','2','3',54),(12564,5,11,432,'10','2','4',54),(12565,5,11,432,'10','2','5',54),(12566,5,11,432,'10','2','6',54),(12567,5,11,432,'10','2','7',54),(12568,5,11,432,'8','2','8',54),(12569,5,11,432,'M','2','9',54),(12570,5,11,432,'10','3','1',54),(12571,5,11,432,'10','3','2',54),(12572,5,11,432,'10','3','3',54),(12573,5,11,432,'10','3','4',54),(12574,5,11,432,'10','3','5',54),(12575,5,11,432,'10','3','6',54),(12576,5,11,432,'10','3','7',54),(12577,5,11,432,'4','3','8',54),(12578,5,11,432,'M','3','9',54),(12579,5,11,432,'10','4','1',54),(12580,5,11,432,'10','4','2',54),(12581,5,11,432,'10','4','3',54),(12582,5,11,432,'10','4','4',54),(12583,5,11,432,'10','4','5',54),(12584,5,11,432,'10','4','6',54),(12585,5,11,432,'10','4','7',54),(12586,5,11,432,'7','4','8',54),(12587,5,11,432,'M','4','9',54),(12588,5,11,432,'10','5','1',54),(12589,5,11,432,'10','5','2',54),(12590,5,11,432,'10','5','3',54),(12591,5,11,432,'10','5','4',54),(12592,5,11,432,'10','5','5',54),(12593,5,11,432,'10','5','6',54),(12594,5,11,432,'8','5','7',54),(12595,5,11,432,'M','5','8',54),(12596,5,11,432,'M','5','9',54),(12597,5,11,432,'10','6','1',54),(12598,5,11,432,'10','6','2',54),(12599,5,11,432,'10','6','3',54),(12600,5,11,432,'10','6','4',54),(12601,5,11,432,'10','6','5',54),(12602,5,11,432,'10','6','6',54),(12603,5,11,432,'10','6','7',54),(12604,5,11,432,'10','6','8',54),(12605,5,11,432,'2','6','9',54),(12606,5,11,432,'10','7','1',54),(12607,5,11,432,'10','7','2',54),(12608,5,11,432,'10','7','3',54),(12609,5,11,432,'10','7','4',54),(12610,5,11,432,'10','7','5',54),(12611,5,11,432,'10','7','6',54),(12612,5,11,432,'10','7','7',54),(12613,5,11,432,'9','7','8',54),(12614,5,11,432,'M','7','9',54),(12615,5,11,434,'10','1','1',54),(12616,5,11,434,'10','1','2',54),(12617,5,11,434,'10','1','3',54),(12618,5,11,434,'10','1','4',54),(12619,5,11,434,'10','1','5',54),(12620,5,11,434,'10','1','6',54),(12621,5,11,434,'10','1','7',54),(12622,5,11,434,'6','1','8',54),(12623,5,11,434,'M','1','9',54),(12624,5,11,434,'10','2','1',54),(12625,5,11,434,'10','2','2',54),(12626,5,11,434,'10','2','3',54),(12627,5,11,434,'10','2','4',54),(12628,5,11,434,'10','2','5',54),(12629,5,11,434,'10','2','6',54),(12630,5,11,434,'9','2','7',54),(12631,5,11,434,'M','2','8',54),(12632,5,11,434,'M','2','9',54),(12633,5,11,434,'10','3','1',54),(12634,5,11,434,'10','3','2',54),(12635,5,11,434,'10','3','3',54),(12636,5,11,434,'10','3','4',54),(12637,5,11,434,'10','3','5',54),(12638,5,11,434,'10','3','6',54),(12639,5,11,434,'10','3','7',54),(12640,5,11,434,'2','3','8',54),(12641,5,11,434,'M','3','9',54),(12642,5,11,434,'10','4','1',54),(12643,5,11,434,'10','4','2',54),(12644,5,11,434,'10','4','3',54),(12645,5,11,434,'10','4','4',54),(12646,5,11,434,'10','4','5',54),(12647,5,11,434,'10','4','6',54),(12648,5,11,434,'10','4','7',54),(12649,5,11,434,'9','4','8',54),(12650,5,11,434,'M','4','9',54),(12651,5,11,434,'10','5','1',54),(12652,5,11,434,'10','5','2',54),(12653,5,11,434,'10','5','3',54),(12654,5,11,434,'10','5','4',54),(12655,5,11,434,'10','5','5',54),(12656,5,11,434,'10','5','6',54),(12657,5,11,434,'10','5','7',54),(12658,5,11,434,'9','5','8',54),(12659,5,11,434,'M','5','9',54),(12660,5,11,434,'10','6','1',54),(12661,5,11,434,'10','6','2',54),(12662,5,11,434,'10','6','3',54),(12663,5,11,434,'10','6','4',54),(12664,5,11,434,'10','6','5',54),(12665,5,11,434,'10','6','6',54),(12666,5,11,434,'10','6','7',54),(12667,5,11,434,'7','6','8',54),(12668,5,11,434,'M','6','9',54),(12669,5,11,434,'10','7','1',54),(12670,5,11,434,'10','7','2',54),(12671,5,11,434,'10','7','3',54),(12672,5,11,434,'10','7','4',54),(12673,5,11,434,'10','7','5',54),(12674,5,11,434,'10','7','6',54),(12675,5,11,434,'10','7','7',54),(12676,5,11,434,'10','7','8',54),(12677,5,11,434,'3','7','9',54),(12678,5,11,435,'10','1','2',54),(12679,5,11,435,'10','1','1',54),(12680,5,11,435,'10','1','3',54),(12681,5,11,435,'10','1','4',54),(12682,5,11,435,'10','1','5',54),(12683,5,11,435,'10','1','6',54),(12684,5,11,435,'10','1','7',54),(12685,5,11,435,'7','1','8',54),(12686,5,11,435,'M','1','9',54),(12687,5,11,435,'10','2','1',54),(12688,5,11,435,'10','2','2',54),(12689,5,11,435,'10','2','3',54),(12690,5,11,435,'10','2','4',54),(12691,5,11,435,'10','2','5',54),(12692,5,11,435,'10','2','6',54),(12693,5,11,435,'10','2','7',54),(12694,5,11,435,'4','2','8',54),(12695,5,11,435,'M','2','9',54),(12696,5,11,435,'10','3','1',54),(12697,5,11,435,'10','3','2',54),(12698,5,11,435,'10','3','3',54),(12699,5,11,435,'10','3','4',54),(12700,5,11,435,'10','3','5',54),(12701,5,11,435,'10','3','6',54),(12702,5,11,435,'10','3','7',54),(12703,5,11,435,'9','3','8',54),(12704,5,11,435,'M','3','9',54),(12705,5,11,435,'10','4','1',54),(12706,5,11,435,'10','4','2',54),(12707,5,11,435,'10','4','3',54),(12708,5,11,435,'10','4','4',54),(12709,5,11,435,'10','4','5',54),(12710,5,11,435,'10','4','6',54),(12711,5,11,435,'10','4','7',54),(12712,5,11,435,'6','4','8',54),(12713,5,11,435,'M','4','9',54),(12714,5,11,435,'10','5','1',54),(12715,5,11,435,'10','5','2',54),(12716,5,11,435,'10','5','3',54),(12717,5,11,435,'10','5','4',54),(12718,5,11,435,'10','5','5',54),(12719,5,11,435,'10','5','6',54),(12720,5,11,435,'10','5','7',54),(12721,5,11,435,'6','5','8',54),(12722,5,11,435,'M','5','9',54),(12723,5,11,435,'10','6','1',54),(12724,5,11,435,'10','6','2',54),(12725,5,11,435,'10','6','3',54),(12726,5,11,435,'10','6','4',54),(12727,5,11,435,'10','6','5',54),(12728,5,11,435,'10','6','6',54),(12729,5,11,435,'10','6','7',54),(12730,5,11,435,'5','6','8',54),(12731,5,11,435,'M','6','9',54),(12732,5,11,435,'10','7','1',54),(12733,5,11,435,'10','7','2',54),(12734,5,11,435,'10','7','3',54),(12735,5,11,435,'10','7','4',54),(12736,5,11,435,'10','7','5',54),(12737,5,11,435,'10','7','6',54),(12738,5,11,435,'10','7','7',54),(12739,5,11,435,'6','7','8',54),(12740,5,11,435,'M','7','9',54),(12741,5,11,436,'10','1','2',54),(12742,5,11,436,'10','1','1',54),(12743,5,11,436,'10','1','3',54),(12744,5,11,436,'10','1','4',54),(12745,5,11,436,'10','1','5',54),(12746,5,11,436,'10','1','6',54),(12747,5,11,436,'9','1','7',54),(12748,5,11,436,'M','1','8',54),(12749,5,11,436,'M','1','9',54),(12750,5,11,436,'10','2','1',54),(12751,5,11,436,'10','2','2',54),(12752,5,11,436,'10','2','3',54),(12753,5,11,436,'10','2','4',54),(12754,5,11,436,'10','2','5',54),(12755,5,11,436,'10','2','6',54),(12756,5,11,436,'10','2','7',54),(12757,5,11,436,'9','2','8',54),(12758,5,11,436,'M','2','9',54),(12759,5,11,436,'10','3','1',54),(12760,5,11,436,'10','3','2',54),(12761,5,11,436,'10','3','3',54),(12762,5,11,436,'10','3','4',54),(12763,5,11,436,'10','3','5',54),(12764,5,11,436,'10','3','6',54),(12765,5,11,436,'10','3','7',54),(12766,5,11,436,'9','3','8',54),(12767,5,11,436,'M','3','9',54),(12768,5,11,436,'10','4','1',54),(12769,5,11,436,'10','4','2',54),(12770,5,11,436,'10','4','3',54),(12771,5,11,436,'10','4','4',54),(12772,5,11,436,'10','4','5',54),(12773,5,11,436,'10','4','6',54),(12774,5,11,436,'10','4','7',54),(12775,5,11,436,'5','4','8',54),(12776,5,11,436,'M','4','9',54),(12777,5,11,436,'10','5','1',54),(12778,5,11,436,'10','5','2',54),(12779,5,11,436,'10','5','3',54),(12780,5,11,436,'10','5','4',54),(12781,5,11,436,'10','5','5',54),(12782,5,11,436,'10','5','6',54),(12783,5,11,436,'10','5','7',54),(12784,5,11,436,'9','5','8',54),(12785,5,11,436,'M','5','9',54),(12786,5,11,436,'10','6','1',54),(12787,5,11,436,'10','6','2',54),(12788,5,11,436,'10','6','3',54),(12789,5,11,436,'10','6','4',54),(12790,5,11,436,'10','6','5',54),(12791,5,11,436,'10','6','6',54),(12792,5,11,436,'10','6','7',54),(12793,5,11,436,'7','6','8',54),(12794,5,11,436,'M','6','9',54),(12795,5,11,436,'10','7','1',54),(12796,5,11,436,'10','7','2',54),(12797,5,11,436,'10','7','3',54),(12798,5,11,436,'10','7','4',54),(12799,5,11,436,'10','7','5',54),(12800,5,11,436,'10','7','6',54),(12801,5,11,436,'10','7','7',54),(12802,5,11,436,'5','7','8',54),(12803,5,11,436,'M','7','9',54),(12804,5,11,439,'10','1','2',54),(12805,5,11,439,'10','1','1',54),(12806,5,11,439,'10','1','3',54),(12807,5,11,439,'10','1','4',54),(12808,5,11,439,'10','1','5',54),(12809,5,11,439,'10','1','6',54),(12810,5,11,439,'7','1','7',54),(12811,5,11,439,'M','1','8',54),(12812,5,11,439,'M','1','9',54),(12813,5,11,439,'10','2','1',54),(12814,5,11,439,'10','2','2',54),(12815,5,11,439,'10','2','3',54),(12816,5,11,439,'10','2','4',54),(12817,5,11,439,'10','2','5',54),(12818,5,11,439,'10','2','6',54),(12819,5,11,439,'10','2','7',54),(12820,5,11,439,'6','2','8',54),(12821,5,11,439,'M','2','9',54),(12822,5,11,439,'10','3','1',54),(12823,5,11,439,'10','3','2',54),(12824,5,11,439,'10','3','3',54),(12825,5,11,439,'10','3','4',54),(12826,5,11,439,'10','3','5',54),(12827,5,11,439,'10','3','6',54),(12828,5,11,439,'10','3','7',54),(12829,5,11,439,'10','3','8',54),(12830,5,11,439,'1','3','9',54),(12831,5,11,439,'10','4','1',54),(12832,5,11,439,'10','4','2',54),(12833,5,11,439,'10','4','3',54),(12834,5,11,439,'10','4','4',54),(12835,5,11,439,'10','4','5',54),(12836,5,11,439,'10','4','6',54),(12837,5,11,439,'7','4','7',54),(12838,5,11,439,'M','4','8',54),(12839,5,11,439,'M','4','9',54),(12840,5,11,439,'10','5','1',54),(12841,5,11,439,'10','5','2',54),(12842,5,11,439,'10','5','3',54),(12843,5,11,439,'10','5','4',54),(12844,5,11,439,'10','5','5',54),(12845,5,11,439,'10','5','6',54),(12846,5,11,439,'10','5','7',54),(12847,5,11,439,'10','5','8',54),(12848,5,11,439,'1','5','9',54),(12849,5,11,439,'10','6','1',54),(12850,5,11,439,'10','6','2',54),(12851,5,11,439,'10','6','3',54),(12852,5,11,439,'10','6','4',54),(12853,5,11,439,'10','6','5',54),(12854,5,11,439,'10','6','6',54),(12855,5,11,439,'10','6','7',54),(12856,5,11,439,'5','6','8',54),(12857,5,11,439,'M','6','9',54),(12858,5,11,439,'10','7','1',54),(12859,5,11,439,'10','7','2',54),(12860,5,11,439,'10','7','3',54),(12861,5,11,439,'10','7','4',54),(12862,5,11,439,'10','7','5',54),(12863,5,11,439,'10','7','6',54),(12864,5,11,439,'10','7','7',54),(12865,5,11,439,'10','7','8',54),(12866,5,11,439,'3','7','9',54),(12867,5,11,441,'10','1','1',54),(12868,5,11,441,'10','1','2',54),(12869,5,11,441,'10','1','3',54),(12870,5,11,441,'10','1','4',54),(12871,5,11,441,'10','1','5',54),(12872,5,11,441,'10','1','6',54),(12873,5,11,441,'8','1','7',54),(12874,5,11,441,'M','1','8',54),(12875,5,11,441,'M','1','9',54),(12876,5,11,441,'10','2','1',54),(12877,5,11,441,'10','2','2',54),(12878,5,11,441,'10','2','3',54),(12879,5,11,441,'10','2','4',54),(12880,5,11,441,'10','2','5',54),(12881,5,11,441,'10','2','6',54),(12882,5,11,441,'10','2','7',54),(12883,5,11,441,'7','2','8',54),(12884,5,11,441,'M','2','9',54),(12885,5,11,441,'10','3','1',54),(12886,5,11,441,'10','3','2',54),(12887,5,11,441,'10','3','3',54),(12888,5,11,441,'10','3','4',54),(12889,5,11,441,'10','3','5',54),(12890,5,11,441,'10','3','6',54),(12891,5,11,441,'10','3','7',54),(12892,5,11,441,'M','3','8',54),(12893,5,11,441,'M','3','9',54),(12894,5,11,441,'10','4','1',54),(12895,5,11,441,'10','4','2',54),(12896,5,11,441,'10','4','3',54),(12897,5,11,441,'10','4','4',54),(12898,5,11,441,'10','4','5',54),(12899,5,11,441,'10','4','6',54),(12900,5,11,441,'10','4','7',54),(12901,5,11,441,'3','4','8',54),(12902,5,11,441,'M','4','9',54),(12903,5,11,441,'10','5','1',54),(12904,5,11,441,'10','5','2',54),(12905,5,11,441,'10','5','3',54),(12906,5,11,441,'10','5','4',54),(12907,5,11,441,'10','5','5',54),(12908,5,11,441,'10','5','6',54),(12909,5,11,441,'10','5','7',54),(12910,5,11,441,'9','5','8',54),(12911,5,11,441,'M','5','9',54),(12912,5,11,441,'10','6','1',54),(12913,5,11,441,'10','6','2',54),(12914,5,11,441,'10','6','3',54),(12915,5,11,441,'10','6','4',54),(12916,5,11,441,'10','6','5',54),(12917,5,11,441,'10','6','6',54),(12918,5,11,441,'10','6','7',54),(12919,5,11,441,'M','6','8',54),(12920,5,11,441,'M','6','9',54),(12921,5,11,441,'10','7','1',54),(12922,5,11,441,'10','7','2',54),(12923,5,11,441,'10','7','3',54),(12924,5,11,441,'10','7','4',54),(12925,5,11,441,'10','7','5',54),(12926,5,11,441,'10','7','6',54),(12927,5,11,441,'10','7','7',54),(12928,5,11,441,'9','7','8',54),(12929,5,11,441,'M','7','9',54),(12930,5,11,442,'10','1','1',54),(12931,5,11,442,'10','1','2',54),(12932,5,11,442,'10','1','3',54),(12933,5,11,442,'10','1','4',54),(12934,5,11,442,'10','1','5',54),(12935,5,11,442,'10','1','6',54),(12936,5,11,442,'10','1','7',54),(12937,5,11,442,'4','1','8',54),(12938,5,11,442,'M','1','9',54),(12939,5,11,442,'10','2','1',54),(12940,5,11,442,'10','2','2',54),(12941,5,11,442,'10','2','3',54),(12942,5,11,442,'10','2','4',54),(12943,5,11,442,'10','2','5',54),(12944,5,11,442,'10','2','6',54),(12945,5,11,442,'3','2','7',54),(12946,6,11,602,'5','1','1',52),(12947,5,11,442,'M','2','8',54),(12948,6,11,602,'7','1','2',52),(12949,5,11,442,'M','2','9',54),(12950,6,11,602,'2','1','3',52),(12951,5,11,442,'10','3','1',54),(12952,6,11,602,'8','1','4',52),(12953,5,11,442,'10','3','2',54),(12954,5,11,442,'10','3','3',54),(12955,6,11,602,'5','1','5',52),(12956,5,11,442,'10','3','4',54),(12957,5,11,442,'10','3','5',54),(12958,5,11,442,'10','3','6',54),(12959,6,11,602,'6','1','6',52),(12960,5,11,442,'10','3','7',54),(12961,5,11,442,'4','3','8',54),(12962,5,11,442,'M','3','9',54),(12963,5,11,442,'10','4','1',54),(12964,5,11,442,'10','4','2',54),(12965,5,11,442,'10','4','3',54),(12966,6,11,602,'2','1','7',52),(12967,5,11,442,'10','4','4',54),(12968,5,11,442,'10','4','5',54),(12969,5,11,442,'10','4','6',54),(12970,5,11,442,'8','4','7',54),(12971,6,11,602,'2','1','8',52),(12972,5,11,442,'M','4','8',54),(12973,5,11,442,'M','4','9',54),(12974,5,11,442,'10','5','1',54),(12975,5,11,442,'10','5','2',54),(12976,5,11,442,'10','5','3',54),(12977,5,11,442,'10','5','4',54),(12978,5,11,442,'10','5','5',54),(12979,5,11,442,'10','5','6',54),(12980,5,11,442,'10','5','7',54),(12981,5,11,442,'10','5','8',54),(12982,5,11,442,'M','5','9',54),(12983,6,11,602,'10','2','1',52),(12984,6,11,602,'10','2','2',52),(12985,6,11,602,'10','2','3',52),(12986,6,11,602,'10','2','4',52),(12987,6,11,602,'5','2','5',52),(12988,6,11,602,'5','2','6',52),(12989,5,11,442,'10','6','1',54),(12990,5,11,442,'10','6','2',54),(12991,6,11,602,'5','2','7',52),(12992,5,11,442,'10','6','3',54),(12994,5,11,442,'10','6','4',54),(12995,5,11,442,'10','6','5',54),(12996,5,11,442,'10','6','6',54),(12997,5,11,442,'10','6','7',54),(12998,5,11,442,'9','6','8',54),(12999,5,11,442,'M','6','9',54),(13000,5,11,442,'10','7','1',54),(13001,6,11,602,'4','2','8',52),(13002,5,11,442,'10','7','2',54),(13003,5,11,442,'10','7','3',54),(13004,5,11,442,'10','7','4',54),(13005,5,11,442,'10','7','5',54),(13006,5,11,442,'10','7','6',54),(13007,5,11,442,'10','7','7',54),(13008,5,11,442,'4','7','8',54),(13009,5,11,442,'M','7','9',54),(13010,6,11,602,'3','3','1',52),(13011,6,11,602,'6','3','2',52),(13012,6,11,602,'7','3','3',52),(13014,6,11,602,'4','3','4',52),(13016,6,11,602,'2','3','6',52),(13017,6,11,602,'1','3','7',52),(13018,6,11,602,'4','3','5',52),(13019,6,11,602,'3','3','8',52),(13020,6,11,602,'10','4','1',52),(13021,6,11,602,'10','4','2',52),(13022,6,11,602,'10','4','3',52),(13023,6,11,602,'5','4','4',52),(13024,6,11,602,'5','4','5',52),(13025,6,11,602,'5','4','6',52),(13026,6,11,602,'5','4','7',52),(13027,6,11,602,'5','4','8',52),(13028,6,11,602,'10','5','1',52),(13029,6,11,602,'5','5','2',52),(13030,6,11,602,'7','5','3',52),(13031,6,11,602,'8','5','4',52),(13032,5,11,443,'10','1','1',54),(13033,6,11,602,'2','5','5',52),(13034,5,11,443,'10','1','2',54),(13036,5,11,443,'10','1','3',54),(13037,5,11,443,'10','1','4',54),(13038,5,11,443,'10','1','5',54),(13039,5,11,443,'10','1','6',54),(13040,5,11,443,'10','1','7',54),(13041,5,11,443,'1','1','8',54),(13042,6,11,602,'4','5','6',52),(13043,5,11,443,'M','1','9',54),(13044,6,11,602,'5','5','7',52),(13045,5,11,443,'10','2','1',54),(13046,5,11,443,'10','2','2',54),(13047,5,11,443,'10','2','3',54),(13048,5,11,443,'10','2','4',54),(13049,5,11,443,'10','2','5',54),(13050,6,11,602,'1','5','8',52),(13051,5,11,443,'10','2','6',54),(13052,5,11,443,'10','2','7',54),(13053,5,11,443,'4','2','8',54),(13054,5,11,443,'M','2','9',54),(13055,5,11,443,'10','3','1',54),(13056,5,11,443,'10','3','2',54),(13057,6,11,602,'10','6','1',52),(13058,5,11,443,'10','3','3',54),(13059,5,11,443,'10','3','4',54),(13060,6,11,602,'10','6','2',52),(13061,5,11,443,'10','3','5',54),(13062,5,11,443,'10','3','6',54),(13063,6,11,602,'10','6','3',52),(13064,5,11,443,'10','3','7',54),(13065,5,11,443,'6','3','8',54),(13066,6,11,602,'10','6','4',52),(13067,5,11,443,'M','3','9',54),(13068,5,11,443,'10','4','1',54),(13069,5,11,443,'10','4','2',54),(13070,5,11,443,'10','4','3',54),(13071,5,11,443,'10','4','4',54),(13072,6,11,602,'5','6','5',52),(13073,5,11,443,'10','4','5',54),(13074,6,11,602,'5','6','6',52),(13075,5,11,443,'10','4','6',54),(13076,5,11,443,'10','4','7',54),(13077,6,11,602,'5','6','7',52),(13078,5,11,443,'1','4','8',54),(13079,6,11,602,'2','6','8',52),(13080,5,11,443,'M','4','9',54),(13081,5,11,443,'10','5','1',54),(13082,5,11,443,'10','5','2',54),(13083,6,11,602,'10','7','1',52),(13084,5,11,443,'10','5','3',54),(13085,6,11,602,'10','7','2',52),(13086,5,11,443,'10','5','4',54),(13087,6,11,602,'10','7','3',52),(13088,5,11,443,'10','5','5',54),(13089,6,11,602,'5','7','4',52),(13090,5,11,443,'10','5','6',54),(13091,6,11,602,'5','7','5',52),(13092,5,11,443,'10','5','7',54),(13093,6,11,602,'5','7','6',52),(13094,5,11,443,'6','5','8',54),(13095,5,11,443,'M','5','9',54),(13096,5,11,443,'10','6','1',54),(13097,6,11,602,'5','7','7',52),(13098,6,11,602,'1','7','8',52),(13099,5,11,443,'10','6','2',54),(13100,5,11,443,'10','6','3',54),(13101,5,11,443,'10','6','4',54),(13102,5,11,443,'10','6','5',54),(13103,5,11,443,'10','6','6',54),(13104,5,11,443,'10','6','7',54),(13105,5,11,443,'8','6','8',54),(13106,5,11,443,'M','6','9',54),(13107,5,11,443,'10','7','1',54),(13108,5,11,443,'10','7','2',54),(13109,5,11,443,'10','7','3',54),(13110,5,11,443,'10','7','4',54),(13111,5,11,443,'10','7','5',54),(13112,5,11,443,'10','7','6',54),(13113,5,11,443,'2','7','7',54),(13114,5,11,443,'M','7','8',54),(13115,5,11,443,'M','7','9',54),(13116,6,11,603,'10','1','1',52),(13117,6,11,603,'10','1','2',52),(13118,6,11,603,'5','1','3',52),(13119,6,11,603,'5','1','4',52),(13120,6,11,603,'5','1','5',52),(13121,6,11,603,'5','1','6',52),(13122,6,11,603,'3','1','7',52),(13123,6,11,603,'2','1','8',52),(13124,6,11,603,'5','2','1',52),(13125,6,11,603,'5','2','2',52),(13126,6,11,603,'3','2','3',52),(13127,6,11,603,'2','2','4',52),(13128,6,11,603,'5','2','5',52),(13130,6,11,603,'10','2','6',52),(13131,6,11,603,'10','2','7',52),(13132,6,11,603,'5','2','8',52),(13134,6,11,603,'5','3','1',52),(13135,6,11,603,'3','3','2',52),(13136,6,11,603,'4','3','3',52),(13137,6,11,603,'7','3','4',52),(13138,6,11,603,'9','3','5',52),(13139,6,11,603,'8','3','6',52),(13140,6,11,603,'3','3','7',52),(13141,6,11,603,'1','3','8',52),(13142,6,11,603,'10','4','1',52),(13143,6,11,603,'10','4','2',52),(13144,6,11,603,'5','4','3',52),(13145,6,11,603,'5','4','4',52),(13146,6,11,603,'5','4','5',52),(13147,6,11,603,'5','4','6',52),(13148,6,11,603,'5','4','7',52),(13149,6,11,603,'5','4','8',52),(13150,6,11,603,'7','5','1',52),(13151,6,11,603,'5','5','2',52),(13152,6,11,603,'4','5','3',52),(13153,6,11,603,'6','5','4',52),(13154,6,11,603,'9','5','5',52),(13155,6,11,603,'2','5','6',52),(13156,6,11,603,'5','5','7',52),(13157,6,11,603,'4','5','8',52),(13158,6,11,603,'9','6','1',52),(13159,6,11,603,'2','6','2',52),(13160,6,11,603,'1','6','3',52),(13161,6,11,603,'5','6','4',52),(13162,6,11,603,'6','6','5',52),(13163,6,11,603,'3','6','6',52),(13164,6,11,603,'9','6','7',52),(13165,6,11,603,'10','6','8',52),(13166,6,11,603,'10','7','1',52),(13167,6,11,603,'10','7','2',52),(13168,6,11,603,'10','7','3',52),(13169,6,11,603,'5','7','4',52),(13170,6,11,603,'5','7','5',52),(13171,6,11,603,'5','7','6',52),(13172,6,11,603,'5','7','7',52),(13173,6,11,603,'4','7','8',52),(13174,6,11,604,'10','1','1',52),(13175,6,11,604,'5','1','2',52),(13176,6,11,604,'6','1','3',52),(13178,6,11,604,'7','1','5',52),(13179,6,11,604,'4','1','4',52),(13180,6,11,604,'8','1','6',52),(13181,6,11,604,'4','1','7',52),(13182,6,11,604,'2','1','8',52),(13183,6,11,604,'2','2','1',52),(13184,6,11,604,'5','2','2',52),(13185,6,11,604,'6','2','3',52),(13186,6,11,604,'4','2','4',52),(13187,6,11,604,'7','2','5',52),(13188,6,11,604,'4','2','6',52),(13189,6,11,604,'10','2','7',52),(13190,6,11,604,'8','2','8',52),(13192,6,11,604,'8','3','1',52),(13193,6,11,604,'7','3','2',52),(13194,6,11,604,'4','3','3',52),(13195,6,11,604,'3','3','4',52),(13196,6,11,604,'9','3','5',52),(13197,6,11,604,'2','3','6',52),(13198,6,11,604,'5','3','7',52),(13200,6,11,604,'6','3','8',52),(13201,6,11,604,'6','4','2',52),(13202,6,11,604,'5','4','1',52),(13203,6,11,604,'4','4','3',52),(13204,6,11,604,'10','4','4',52),(13205,6,11,604,'8','4','5',52),(13206,6,11,604,'7','4','6',52),(13207,6,11,604,'2','4','7',52),(13208,6,11,604,'4','4','8',52),(13209,6,11,604,'8','5','1',52),(13210,6,11,604,'6','5','2',52),(13211,6,11,604,'3','5','3',52),(13212,6,11,604,'2','5','4',52),(13213,6,11,604,'3','5','5',52),(13214,6,11,604,'1','5','6',52),(13215,6,11,604,'2','5','7',52),(13216,5,11,444,'10','1','1',54),(13217,5,11,444,'10','1','2',54),(13218,5,11,444,'10','1','3',54),(13219,5,11,444,'10','1','4',54),(13220,6,11,604,'2','5','8',52),(13221,5,11,444,'10','1','5',54),(13222,5,11,444,'10','1','6',54),(13223,5,11,444,'10','1','7',54),(13224,5,11,444,'3','1','8',54),(13225,5,11,444,'M','1','9',54),(13226,5,11,444,'10','2','1',54),(13227,6,11,604,'2','6','1',52),(13228,5,11,444,'10','2','2',54),(13229,5,11,444,'10','2','3',54),(13230,5,11,444,'10','2','4',54),(13231,5,11,444,'10','2','5',54),(13232,5,11,444,'10','2','6',54),(13233,5,11,444,'10','2','7',54),(13234,5,11,444,'3','2','8',54),(13235,5,11,444,'M','2','9',54),(13236,5,11,444,'10','3','1',54),(13237,5,11,444,'10','3','2',54),(13239,5,11,444,'10','3','3',54),(13240,5,11,444,'10','3','4',54),(13241,5,11,444,'10','3','5',54),(13242,5,11,444,'10','3','6',54),(13243,5,11,444,'10','3','7',54),(13244,6,11,604,'7','6','3',52),(13245,5,11,444,'10','3','8',54),(13246,5,11,444,'M','3','9',54),(13247,6,11,604,'5','6','4',52),(13248,5,11,444,'10','4','1',54),(13249,6,11,604,'4','6','5',52),(13251,6,11,604,'6','6','6',52),(13252,5,11,444,'10','4','2',54),(13253,5,11,444,'10','4','3',54),(13254,6,11,604,'9','6','7',52),(13255,5,11,444,'10','4','4',54),(13256,5,11,444,'10','4','5',54),(13257,5,11,444,'10','4','6',54),(13258,5,11,444,'5','4','7',54),(13259,5,11,444,'M','4','8',54),(13260,5,11,444,'M','4','9',54),(13261,5,11,444,'10','5','1',54),(13262,5,11,444,'10','5','2',54),(13263,5,11,444,'10','5','3',54),(13264,5,11,444,'10','5','4',54),(13265,5,11,444,'10','5','5',54),(13266,5,11,444,'10','5','6',54),(13267,5,11,444,'9','5','7',54),(13268,5,11,444,'M','5','8',54),(13269,5,11,444,'M','5','9',54),(13270,6,11,604,'10','6','2',52),(13272,5,11,444,'10','6','1',54),(13273,5,11,444,'10','6','2',54),(13274,5,11,444,'10','6','3',54),(13275,5,11,444,'10','6','4',54),(13276,5,11,444,'10','6','5',54),(13277,5,11,444,'10','6','6',54),(13278,5,11,444,'10','6','7',54),(13279,5,11,444,'5','6','8',54),(13280,5,11,444,'M','6','9',54),(13281,5,11,444,'10','7','1',54),(13282,5,11,444,'10','7','2',54),(13283,5,11,444,'10','7','3',54),(13284,5,11,444,'10','7','4',54),(13285,5,11,444,'10','7','5',54),(13286,5,11,444,'10','7','6',54),(13287,5,11,444,'10','7','7',54),(13288,5,11,444,'3','7','8',54),(13289,5,11,444,'M','7','9',54),(13290,6,11,604,'5','6','8',52),(13291,6,11,604,'4','7','1',52),(13292,6,11,604,'2','7','2',52),(13293,6,11,604,'6','7','3',52),(13294,6,11,604,'8','7','4',52),(13295,6,11,604,'4','7','5',52),(13296,6,11,604,'7','7','6',52),(13298,6,11,604,'2','7','7',52),(13299,6,11,604,'2','7','8',52),(13300,5,11,445,'10','1','1',54),(13301,5,11,445,'10','1','2',54),(13302,5,11,445,'10','1','3',54),(13303,5,11,445,'10','1','4',54),(13304,5,11,445,'10','1','5',54),(13305,5,11,445,'10','1','6',54),(13306,5,11,445,'10','1','7',54),(13307,5,11,445,'6','1','8',54),(13308,5,11,445,'M','1','9',54),(13309,5,11,445,'10','2','1',54),(13310,5,11,445,'10','2','2',54),(13311,5,11,445,'10','2','3',54),(13312,5,11,445,'10','2','4',54),(13313,5,11,445,'10','2','5',54),(13314,5,11,445,'10','2','6',54),(13315,5,11,445,'4','2','7',54),(13316,5,11,445,'M','2','8',54),(13317,5,11,445,'M','2','9',54),(13318,6,11,605,'8','1','1',52),(13319,6,11,605,'5','1','2',52),(13320,6,11,605,'3','1','3',52),(13321,6,11,605,'7','1','4',52),(13322,6,11,605,'9','1','5',52),(13323,6,11,605,'4','1','6',52),(13324,6,11,605,'5','1','7',52),(13325,6,11,605,'6','1','8',52),(13326,6,11,605,'1','2','1',52),(13327,6,11,605,'10','2','2',52),(13328,6,11,605,'10','2','3',52),(13329,6,11,605,'5','2','4',52),(13330,5,11,445,'10','3','1',54),(13331,5,11,445,'10','3','2',54),(13332,5,11,445,'10','3','3',54),(13333,5,11,445,'10','3','4',54),(13334,5,11,445,'10','3','5',54),(13335,5,11,445,'10','3','6',54),(13336,5,11,445,'10','3','7',54),(13337,5,11,445,'4','3','8',54),(13338,6,11,605,'5','2','5',52),(13339,5,11,445,'M','3','9',54),(13340,6,11,605,'5','2','6',52),(13341,5,11,445,'10','4','1',54),(13342,6,11,605,'5','2','7',52),(13343,5,11,445,'10','4','2',54),(13344,6,11,605,'5','2','8',52),(13345,5,11,445,'10','4','3',54),(13346,5,11,445,'10','4','4',54),(13347,5,11,445,'10','4','5',54),(13349,5,11,445,'4','4','7',54),(13350,6,11,605,'9','3','1',52),(13351,6,11,605,'4','3','2',52),(13352,6,11,605,'6','3','3',52),(13353,6,11,605,'3','3','4',52),(13355,6,11,605,'5','3','6',52),(13356,5,11,445,'10','4','6',54),(13357,6,11,605,'2','3','5',52),(13358,5,11,445,'M','4','8',54),(13359,6,11,605,'1','3','7',52),(13360,5,11,445,'M','4','9',54),(13361,6,11,605,'1','3','8',52),(13363,6,11,605,'9','4','2',52),(13364,6,11,605,'3','4','3',52),(13366,5,11,445,'10','5','1',54),(13367,5,11,445,'10','5','2',54),(13369,5,11,445,'10','5','3',54),(13370,5,11,445,'10','5','4',54),(13371,5,11,445,'10','5','5',54),(13372,6,11,605,'5','4','4',52),(13373,5,11,445,'10','5','6',54),(13374,5,11,445,'10','5','7',54),(13375,5,11,445,'3','5','8',54),(13376,5,11,445,'M','5','9',54),(13377,5,11,445,'10','6','1',54),(13378,5,11,445,'10','6','2',54),(13380,5,11,445,'10','6','3',54),(13382,5,11,445,'10','6','4',54),(13383,5,11,445,'10','6','5',54),(13384,5,11,445,'10','6','6',54),(13385,6,11,605,'3','4','8',52),(13386,5,11,445,'10','6','7',54),(13387,5,11,445,'1','6','8',54),(13388,5,11,445,'M','6','9',54),(13389,5,11,445,'10','7','1',54),(13390,5,11,445,'10','7','2',54),(13391,5,11,445,'10','7','3',54),(13392,5,11,445,'10','7','4',54),(13393,5,11,445,'10','7','5',54),(13394,5,11,445,'10','7','6',54),(13395,6,11,605,'8','4','5',52),(13397,6,11,605,'6','4','6',52),(13398,5,11,445,'10','7','7',54),(13399,5,11,445,'5','7','8',54),(13400,5,11,445,'M','7','9',54),(13402,6,11,605,'4','4','1',52),(13403,6,11,605,'8','5','1',52),(13404,6,11,605,'5','5','2',52),(13405,6,11,605,'3','5','3',52),(13406,6,11,605,'7','5','4',52),(13407,6,11,605,'8','5','5',52),(13408,6,11,605,'4','5','6',52),(13409,6,11,605,'5','5','7',52),(13410,6,11,605,'6','5','8',52),(13411,5,11,446,'10','1','1',54),(13412,5,11,446,'10','1','2',54),(13413,5,11,446,'10','1','3',54),(13414,5,11,446,'10','1','4',54),(13415,5,11,446,'10','1','5',54),(13416,6,11,605,'10','6','1',52),(13417,5,11,446,'10','1','6',54),(13418,6,11,605,'10','6','2',52),(13419,5,11,446,'10','1','7',54),(13420,6,11,605,'10','6','3',52),(13421,6,11,605,'4','6','4',52),(13426,5,11,446,'M','1','8',54),(13427,5,11,446,'M','1','9',54),(13428,6,11,605,'M','6','5',52),(13429,6,11,605,'M','6','6',52),(13430,6,11,605,'M','6','7',52),(13431,6,11,605,'M','6','8',52),(13432,6,11,605,'5','7','1',52),(13433,6,11,605,'2','7','2',52),(13434,6,11,605,'3','7','3',52),(13435,6,11,605,'M','7','4',52),(13436,6,11,605,'M','7','5',52),(13437,6,11,605,'M','7','6',52),(13438,6,11,605,'M','7','7',52),(13439,6,11,605,'M','7','8',52),(13440,5,11,446,'10','2','1',54),(13441,5,11,446,'10','2','2',54),(13442,5,11,446,'10','2','3',54),(13443,5,11,446,'10','2','4',54),(13444,5,11,446,'10','2','5',54),(13445,5,11,446,'10','2','6',54),(13446,5,11,446,'7','2','7',54),(13447,5,11,446,'M','2','8',54),(13448,5,11,446,'M','2','9',54),(13449,5,11,446,'10','3','1',54),(13450,5,11,446,'10','3','2',54),(13451,5,11,446,'10','3','3',54),(13452,5,11,446,'10','3','4',54),(13453,5,11,446,'10','3','5',54),(13454,5,11,446,'10','3','6',54),(13455,5,11,446,'10','3','7',54),(13456,5,11,446,'2','3','8',54),(13457,5,11,446,'M','3','9',54),(13458,5,11,446,'10','4','1',54),(13459,5,11,446,'10','4','2',54),(13460,6,11,606,'10','1','1',52),(13461,6,11,606,'10','1','2',52),(13462,5,11,446,'10','4','3',54),(13463,6,11,606,'10','1','3',52),(13464,6,11,606,'8','1','4',52),(13465,6,11,606,'M','1','5',52),(13466,6,11,606,'M','1','6',52),(13467,6,11,606,'M','1','7',52),(13468,6,11,606,'M','1','8',52),(13469,6,11,606,'10','2','1',52),(13470,6,11,606,'10','2','2',52),(13471,6,11,606,'10','2','3',52),(13472,6,11,606,'10','2','4',52),(13473,6,11,606,'10','2','5',52),(13474,6,11,606,'1','2','6',52),(13475,6,11,606,'M','2','7',52),(13476,6,11,606,'M','2','8',52),(13477,6,11,606,'10','3','1',52),(13478,6,11,606,'10','3','2',52),(13479,6,11,606,'10','3','3',52),(13480,6,11,606,'10','3','4',52),(13481,6,11,606,'10','3','5',52),(13482,6,11,606,'M','3','6',52),(13483,6,11,606,'M','3','7',52),(13484,6,11,606,'M','3','8',52),(13485,5,11,446,'10','4','4',54),(13486,5,11,446,'10','4','5',54),(13487,5,11,446,'10','4','6',54),(13488,5,11,446,'7','4','7',54),(13489,5,11,446,'M','4','8',54),(13490,5,11,446,'M','4','9',54),(13491,5,11,446,'10','5','1',54),(13492,5,11,446,'10','5','2',54),(13493,5,11,446,'10','5','3',54),(13494,5,11,446,'10','5','4',54),(13495,5,11,446,'10','5','5',54),(13496,5,11,446,'10','5','6',54),(13497,5,11,446,'10','5','7',54),(13498,5,11,446,'2','5','8',54),(13499,6,11,606,'10','4','1',52),(13500,5,11,446,'M','5','9',54),(13501,6,11,606,'10','4','2',52),(13502,5,11,446,'10','6','1',54),(13503,6,11,606,'10','4','3',52),(13504,6,11,606,'1','4','4',52),(13505,6,11,606,'M','4','5',52),(13506,6,11,606,'M','4','6',52),(13507,6,11,606,'M','4','7',52),(13508,6,11,606,'M','4','8',52),(13509,5,11,446,'10','6','2',54),(13510,5,11,446,'10','6','3',54),(13511,5,11,446,'10','6','4',54),(13512,5,11,446,'10','6','5',54),(13513,5,11,446,'10','6','6',54),(13514,6,11,606,'10','5','1',52),(13515,5,11,446,'10','6','7',54),(13516,6,11,606,'10','5','2',52),(13517,5,11,446,'M','6','8',54),(13518,5,11,446,'M','6','9',54),(13519,6,11,606,'10','5','3',52),(13520,5,11,446,'10','7','1',54),(13521,6,11,606,'3','5','4',52),(13522,5,11,446,'10','7','2',54),(13523,5,11,446,'10','7','3',54),(13524,6,11,606,'M','5','5',52),(13525,5,11,446,'10','7','4',54),(13526,6,11,606,'M','5','6',52),(13527,5,11,446,'10','7','5',54),(13528,6,11,606,'M','5','7',52),(13529,5,11,446,'10','7','6',54),(13530,6,11,606,'M','5','8',52),(13531,5,11,446,'10','7','7',54),(13532,5,11,446,'8','7','8',54),(13533,5,11,446,'M','7','9',54),(13534,6,11,606,'M','6','1',52),(13535,6,11,606,'M','6','2',52),(13536,6,11,606,'M','6','3',52),(13537,6,11,606,'M','6','4',52),(13538,6,11,606,'M','6','5',52),(13539,6,11,606,'M','6','6',52),(13540,6,11,606,'M','6','7',52),(13541,6,11,606,'M','6','8',52),(13542,6,11,606,'M','7','1',52),(13543,6,11,606,'M','7','2',52),(13545,6,11,606,'M','7','4',52),(13546,6,11,606,'M','7','5',52),(13547,6,11,606,'M','7','6',52),(13548,6,11,606,'M','7','7',52),(13549,6,11,606,'M','7','8',52),(13550,6,11,606,'M','7','3',52),(13551,6,11,607,'10','1','1',52),(13552,6,11,607,'10','1','2',52),(13553,6,11,607,'10','1','3',52),(13554,6,11,607,'10','1','4',52),(13555,6,11,607,'10','1','5',52),(13556,6,11,607,'10','1','6',52),(13557,6,11,607,'7','1','7',52),(13558,6,11,607,'M','1','8',52),(13559,6,11,607,'10','2','1',52),(13560,6,11,607,'10','2','2',52),(13561,6,11,607,'10','2','3',52),(13562,6,11,607,'10','2','4',52),(13563,6,11,607,'7','2','5',52),(13564,6,11,607,'M','2','6',52),(13565,6,11,607,'M','2','7',52),(13566,6,11,607,'M','2','8',52),(13567,6,11,607,'10','3','1',52),(13568,6,11,607,'10','3','2',52),(13569,6,11,607,'7','3','3',52),(13570,6,11,607,'M','3','4',52),(13571,6,11,607,'M','3','5',52),(13572,6,11,607,'M','3','6',52),(13573,6,11,607,'M','3','7',52),(13574,6,11,607,'M','3','8',52),(13575,6,11,607,'10','4','1',52),(13576,6,11,607,'10','4','2',52),(13577,6,11,607,'10','4','3',52),(13578,6,11,607,'10','4','4',52),(13579,6,11,607,'10','4','5',52),(13580,6,11,607,'5','4','6',52),(13581,6,11,607,'M','4','7',52),(13582,6,11,607,'M','4','8',52),(13583,5,11,447,'10','1','1',54),(13584,5,11,447,'10','1','2',54),(13585,5,11,447,'10','1','3',54),(13586,5,11,447,'10','1','4',54),(13587,5,11,447,'10','1','5',54),(13588,5,11,447,'10','1','6',54),(13589,5,11,447,'M','1','7',54),(13590,5,11,447,'M','1','8',54),(13591,6,11,607,'M','5','1',52),(13592,5,11,447,'M','1','9',54),(13593,6,11,607,'M','5','2',52),(13594,5,11,447,'10','2','1',54),(13595,6,11,607,'M','5','3',52),(13596,5,11,447,'10','2','2',54),(13597,6,11,607,'M','5','4',52),(13598,5,11,447,'10','2','3',54),(13599,6,11,607,'M','5','5',52),(13600,5,11,447,'10','2','4',54),(13601,6,11,607,'M','5','6',52),(13602,6,11,607,'M','5','7',52),(13603,5,11,447,'10','2','5',54),(13604,5,11,447,'10','2','6',54),(13605,6,11,607,'M','5','8',52),(13606,6,11,607,'M','6','1',52),(13607,5,11,447,'7','2','7',54),(13608,5,11,447,'M','2','8',54),(13609,6,11,607,'M','6','2',52),(13610,5,11,447,'M','2','9',54),(13611,6,11,607,'M','6','3',52),(13612,5,11,447,'10','3','1',54),(13613,6,11,607,'M','6','4',52),(13615,6,11,607,'M','6','5',52),(13616,6,11,607,'M','6','6',52),(13617,6,11,607,'M','6','7',52),(13618,6,11,607,'M','6','8',52),(13619,6,11,607,'M','7','1',52),(13620,6,11,607,'M','7','2',52),(13621,6,11,607,'M','7','3',52),(13622,6,11,607,'M','7','4',52),(13623,6,11,607,'M','7','5',52),(13624,6,11,607,'M','7','6',52),(13626,5,11,447,'10','3','2',54),(13627,5,11,447,'10','3','3',54),(13628,5,11,447,'10','3','4',54),(13629,5,11,447,'10','3','5',54),(13630,5,11,447,'10','3','6',54),(13631,6,11,607,'M','7','7',52),(13632,5,11,447,'5','3','7',54),(13633,6,11,607,'M','7','8',52),(13634,5,11,447,'M','3','8',54),(13635,5,11,447,'M','3','9',54),(13636,5,11,447,'10','4','1',54),(13637,5,11,447,'10','4','2',54),(13638,5,11,447,'10','4','3',54),(13639,5,11,447,'10','4','4',54),(13640,5,11,447,'10','4','5',54),(13641,5,11,447,'10','4','6',54),(13642,5,11,447,'5','4','7',54),(13643,5,11,447,'M','4','8',54),(13644,5,11,447,'M','4','9',54),(13645,5,11,447,'10','5','1',54),(13646,5,11,447,'10','5','2',54),(13647,5,11,447,'10','5','3',54),(13648,5,11,447,'10','5','4',54),(13649,5,11,447,'10','5','5',54),(13650,5,11,447,'10','5','6',54),(13651,5,11,447,'8','5','7',54),(13652,5,11,447,'M','5','8',54),(13653,5,11,447,'M','5','9',54),(13654,5,11,447,'10','6','1',54),(13655,5,11,447,'10','6','2',54),(13656,5,11,447,'10','6','3',54),(13657,5,11,447,'10','6','4',54),(13658,5,11,447,'10','6','5',54),(13659,5,11,447,'10','6','6',54),(13660,6,11,608,'10','1','1',52),(13661,5,11,447,'10','6','7',54),(13662,5,11,447,'10','6','8',54),(13663,6,11,608,'10','1','2',52),(13664,5,11,447,'1','6','9',54),(13665,6,11,608,'8','1','3',52),(13666,6,11,608,'M','1','4',52),(13667,6,11,608,'M','1','5',52),(13668,5,11,447,'10','7','1',54),(13669,6,11,608,'M','1','6',52),(13670,5,11,447,'10','7','2',54),(13671,6,11,608,'M','1','7',52),(13672,5,11,447,'10','7','3',54),(13673,6,11,608,'M','1','8',52),(13674,5,11,447,'10','7','4',54),(13675,6,11,608,'10','2','1',52),(13676,5,11,447,'10','7','5',54),(13677,6,11,608,'10','2','2',52),(13678,5,11,447,'10','7','6',54),(13679,6,11,608,'10','2','3',52),(13680,5,11,447,'10','7','7',54),(13681,6,11,608,'2','2','4',52),(13682,5,11,447,'7','7','8',54),(13683,6,11,608,'M','2','5',52),(13684,5,11,447,'M','7','9',54),(13685,6,11,608,'M','2','6',52),(13686,6,11,608,'M','2','7',52),(13687,6,11,608,'M','2','8',52),(13688,6,11,608,'10','3','1',52),(13689,6,11,608,'10','3','2',52),(13690,6,11,608,'10','3','3',52),(13691,6,11,608,'10','3','4',52),(13692,6,11,608,'1','3','5',52),(13694,6,11,608,'M','3','7',52),(13695,6,11,608,'M','3','8',52),(13696,6,11,608,'M','3','6',52),(13697,6,11,608,'10','4','2',52),(13698,6,11,608,'10','4','1',52),(13699,6,11,608,'2','4','3',52),(13700,6,11,608,'M','4','4',52),(13701,5,11,448,'10','1','1',54),(13702,6,11,608,'M','4','5',52),(13703,5,11,448,'10','1','2',54),(13704,6,11,608,'M','4','6',52),(13705,5,11,448,'10','1','3',54),(13706,5,11,448,'10','1','4',54),(13707,6,11,608,'M','4','7',52),(13708,5,11,448,'10','1','5',54),(13709,6,11,608,'M','4','8',52),(13710,5,11,448,'10','1','6',54),(13711,6,11,608,'10','5','1',52),(13712,5,11,448,'10','1','7',54),(13713,6,11,608,'10','5','2',52),(13714,5,11,448,'4','1','8',54),(13715,6,11,608,'10','5','3',52),(13716,5,11,448,'M','1','9',54),(13717,6,11,608,'2','5','4',52),(13718,6,11,608,'M','5','5',52),(13719,5,11,448,'10','2','1',54),(13721,6,11,608,'M','5','6',52),(13722,6,11,608,'M','5','7',52),(13723,6,11,608,'M','5','8',52),(13724,5,11,448,'10','2','2',54),(13725,5,11,448,'10','2','3',54),(13726,5,11,448,'10','2','4',54),(13727,5,11,448,'10','2','5',54),(13728,5,11,448,'10','2','6',54),(13729,5,11,448,'10','2','7',54),(13730,5,11,448,'8','2','8',54),(13731,5,11,448,'M','2','9',54),(13732,6,11,608,'10','6','1',52),(13733,6,11,608,'3','6','2',52),(13734,5,11,448,'10','3','1',54),(13735,5,11,448,'10','3','2',54),(13736,6,11,608,'M','6','3',52),(13737,5,11,448,'10','3','3',54),(13738,6,11,608,'M','6','4',52),(13739,5,11,448,'10','3','4',54),(13740,6,11,608,'M','6','5',52),(13741,5,11,448,'10','3','5',54),(13742,6,11,608,'M','6','6',52),(13743,6,11,608,'M','6','7',52),(13744,5,11,448,'7','3','6',54),(13745,6,11,608,'M','6','8',52),(13746,5,11,448,'M','3','7',54),(13747,6,11,608,'5','7','1',52),(13748,5,11,448,'M','3','8',54),(13749,6,11,608,'5','7','2',52),(13750,5,11,448,'M','3','9',54),(13751,6,11,608,'5','7','3',52),(13752,5,11,448,'10','4','1',54),(13754,5,11,448,'10','4','2',54),(13755,5,11,448,'10','4','3',54),(13756,5,11,448,'10','4','4',54),(13757,5,11,448,'10','4','5',54),(13758,5,11,448,'10','4','6',54),(13759,6,11,608,'2','7','4',52),(13760,5,11,448,'4','4','7',54),(13761,6,11,608,'M','7','5',52),(13762,5,11,448,'M','4','8',54),(13763,6,11,608,'M','7','6',52),(13764,5,11,448,'M','4','9',54),(13765,6,11,608,'M','7','7',52),(13766,6,11,608,'M','7','8',52),(13767,5,11,448,'10','5','1',54),(13768,5,11,448,'10','5','2',54),(13769,5,11,448,'10','5','3',54),(13770,5,11,448,'10','5','4',54),(13771,5,11,448,'10','5','5',54),(13772,5,11,448,'10','5','6',54),(13773,5,11,448,'10','5','7',54),(13774,5,11,448,'6','5','8',54),(13775,5,11,448,'M','5','9',54),(13776,5,11,448,'10','6','1',54),(13777,6,11,609,'10','1','1',52),(13778,5,11,448,'10','6','2',54),(13779,6,11,609,'10','1','2',52),(13780,5,11,448,'10','6','3',54),(13781,6,11,609,'10','1','3',52),(13782,5,11,448,'10','6','4',54),(13783,6,11,609,'2','1','4',52),(13784,5,11,448,'10','6','5',54),(13785,6,11,609,'M','1','5',52),(13786,5,11,448,'6','6','6',54),(13787,6,11,609,'M','1','6',52),(13788,6,11,609,'M','1','7',52),(13789,6,11,609,'M','1','8',52),(13790,6,11,609,'10','2','1',52),(13791,6,11,609,'10','2','2',52),(13792,5,11,448,'M','6','7',54),(13793,6,11,609,'10','2','3',52),(13794,5,11,448,'M','6','8',54),(13795,6,11,609,'10','2','4',52),(13796,5,11,448,'M','6','9',54),(13797,6,11,609,'M','2','5',52),(13798,6,11,609,'M','2','6',52),(13799,6,11,609,'M','2','7',52),(13800,6,11,609,'M','2','8',52),(13801,5,11,448,'10','7','1',54),(13802,5,11,448,'10','7','2',54),(13803,5,11,448,'10','7','3',54),(13804,5,11,448,'10','7','4',54),(13805,5,11,448,'10','7','5',54),(13806,5,11,448,'10','7','6',54),(13807,5,11,448,'9','7','7',54),(13808,5,11,448,'M','7','8',54),(13809,5,11,448,'M','7','9',54),(13810,6,11,609,'10','3','1',52),(13811,6,11,609,'1','3','2',52),(13812,6,11,609,'M','3','3',52),(13813,6,11,609,'M','3','4',52),(13815,6,11,609,'M','3','6',52),(13816,6,11,609,'M','3','7',52),(13817,6,11,609,'M','3','8',52),(13818,6,11,609,'M','3','5',52),(13819,6,11,609,'10','4','1',52),(13820,6,11,609,'9','4','2',52),(13821,6,11,609,'M','4','3',52),(13822,6,11,609,'M','4','4',52),(13823,6,11,609,'M','4','5',52),(13824,6,11,609,'M','4','6',52),(13825,6,11,609,'M','4','7',52),(13826,6,11,609,'M','4','8',52),(13827,6,11,609,'10','5','1',52),(13828,6,11,609,'10','5','2',52),(13829,6,11,609,'M','5','3',52),(13830,6,11,609,'M','5','4',52),(13831,6,11,609,'M','5','5',52),(13832,6,11,609,'M','5','6',52),(13833,6,11,609,'M','5','7',52),(13834,6,11,609,'M','5','8',52),(13835,6,11,609,'10','6','1',52),(13836,6,11,609,'10','6','2',52),(13837,6,11,609,'6','6','3',52),(13838,6,11,609,'M','6','4',52),(13839,6,11,609,'M','6','5',52),(13840,6,11,609,'M','6','6',52),(13841,6,11,609,'M','6','7',52),(13842,6,11,609,'M','6','8',52),(13843,6,11,609,'10','7','1',52),(13844,6,11,609,'10','7','2',52),(13845,6,11,609,'6','7','3',52),(13846,6,11,609,'M','7','4',52),(13847,6,11,609,'M','7','5',52),(13848,6,11,609,'M','7','6',52),(13849,6,11,609,'M','7','7',52),(13850,6,11,609,'M','7','8',52),(13851,5,11,449,'10','1','1',54),(13852,5,11,449,'10','1','2',54),(13853,5,11,449,'10','1','3',54),(13855,5,11,449,'10','1','4',54),(13856,5,11,449,'10','1','5',54),(13857,5,11,449,'10','1','6',54),(13858,5,11,449,'9','1','7',54),(13859,5,11,449,'M','1','8',54),(13860,5,11,449,'M','1','9',54),(13861,5,11,449,'10','2','1',54),(13862,5,11,449,'10','2','2',54),(13863,5,11,449,'10','2','3',54),(13864,5,11,449,'10','2','4',54),(13865,5,11,449,'10','2','5',54),(13866,5,11,449,'10','2','6',54),(13867,5,11,449,'4','2','7',54),(13868,5,11,449,'M','2','8',54),(13869,5,11,449,'M','2','9',54),(13870,5,11,449,'10','3','1',54),(13871,5,11,449,'10','3','2',54),(13872,5,11,449,'10','3','3',54),(13873,5,11,449,'10','3','4',54),(13874,5,11,449,'10','3','5',54),(13875,5,11,449,'10','3','6',54),(13876,5,11,449,'10','3','7',54),(13877,5,11,449,'M','3','8',54),(13878,5,11,449,'M','3','9',54),(13879,5,11,449,'10','4','1',54),(13880,5,11,449,'10','4','2',54),(13881,5,11,449,'10','4','3',54),(13882,5,11,449,'10','4','4',54),(13883,5,11,449,'10','4','5',54),(13884,5,11,449,'10','4','6',54),(13885,5,11,449,'4','4','7',54),(13886,5,11,449,'M','4','8',54),(13887,5,11,449,'M','4','9',54),(13888,6,11,610,'10','1','2',52),(13889,5,11,449,'10','5','1',54),(13890,6,11,610,'10','1','3',52),(13891,5,11,449,'10','5','2',54),(13892,6,11,610,'10','1','4',52),(13893,5,11,449,'10','5','3',54),(13894,6,11,610,'10','1','5',52),(13895,5,11,449,'10','5','4',54),(13896,6,11,610,'3','1','6',52),(13897,5,11,449,'10','5','5',54),(13898,6,11,610,'M','1','7',52),(13899,5,11,449,'10','5','6',54),(13900,6,11,610,'M','1','8',52),(13901,5,11,449,'M','5','7',54),(13902,5,11,449,'M','5','8',54),(13903,6,11,610,'M','2','1',52),(13904,5,11,449,'M','5','9',54),(13905,6,11,610,'M','2','2',52),(13906,5,11,449,'10','6','1',54),(13907,6,11,610,'M','2','3',52),(13908,5,11,449,'10','6','2',54),(13909,6,11,610,'M','2','4',52),(13910,5,11,449,'10','6','3',54),(13911,6,11,610,'M','2','5',52),(13912,5,11,449,'10','6','4',54),(13913,6,11,610,'M','2','6',52),(13914,5,11,449,'10','6','5',54),(13915,5,11,449,'10','6','6',54),(13916,5,11,449,'10','6','7',54),(13917,5,11,449,'M','6','8',54),(13918,6,11,610,'M','2','7',52),(13919,6,11,610,'M','2','8',52),(13920,5,11,449,'M','6','9',54),(13921,5,11,449,'10','7','1',54),(13922,6,11,610,'10','3','1',52),(13923,5,11,449,'10','7','2',54),(13924,6,11,610,'10','3','2',52),(13925,5,11,449,'10','7','3',54),(13926,6,11,610,'8','3','3',52),(13927,5,11,449,'10','7','4',54),(13928,6,11,610,'M','3','4',52),(13929,5,11,449,'10','7','5',54),(13930,6,11,610,'M','3','5',52),(13931,5,11,449,'10','7','6',54),(13932,6,11,610,'M','3','6',52),(13933,5,11,449,'10','7','7',54),(13934,6,11,610,'M','3','7',52),(13935,5,11,449,'1','7','8',54),(13936,6,11,610,'M','3','8',52),(13937,5,11,449,'M','7','9',54),(13938,6,11,610,'10','4','1',52),(13939,6,11,610,'10','4','2',52),(13940,6,11,610,'3','4','3',52),(13941,6,11,610,'M','4','4',52),(13942,6,11,610,'M','4','5',52),(13943,6,11,610,'M','4','6',52),(13944,6,11,610,'M','4','7',52),(13945,6,11,610,'M','4','8',52),(13946,6,11,610,'9','5','1',52),(13947,6,11,610,'M','5','2',52),(13948,6,11,610,'M','5','3',52),(13949,6,11,610,'M','5','4',52),(13950,6,11,610,'M','5','5',52),(13951,6,11,610,'M','5','6',52),(13952,6,11,610,'M','5','7',52),(13953,6,11,610,'M','5','8',52),(13954,6,11,610,'10','6','1',52),(13955,6,11,610,'2','6','2',52),(13956,6,11,610,'M','6','3',52),(13957,6,11,610,'M','6','4',52),(13958,6,11,610,'M','6','5',52),(13959,6,11,610,'M','6','6',52),(13960,6,11,610,'M','6','7',52),(13961,6,11,610,'M','6','8',52),(13962,6,11,610,'10','7','1',52),(13963,6,11,610,'10','7','2',52),(13964,6,11,610,'2','7','3',52),(13965,6,11,610,'M','7','4',52),(13966,6,11,610,'M','7','5',52),(13967,6,11,610,'M','7','6',52),(13968,6,11,610,'M','7','7',52),(13969,6,11,610,'M','7','8',52),(13970,5,11,450,'10','1','2',54),(13971,5,11,450,'10','1','1',54),(13972,5,11,450,'10','1','3',54),(13973,5,11,450,'10','1','4',54),(13974,5,11,450,'10','1','5',54),(13975,5,11,450,'10','1','6',54),(13976,5,11,450,'4','1','7',54),(13977,5,11,450,'M','1','8',54),(13978,5,11,450,'M','1','9',54),(13979,5,11,450,'10','2','1',54),(13980,5,11,450,'10','2','2',54),(13981,5,11,450,'10','2','3',54),(13982,5,11,450,'10','2','4',54),(13983,5,11,450,'10','2','5',54),(13984,5,11,450,'10','2','6',54),(13985,5,11,450,'9','2','7',54),(13986,5,11,450,'M','2','8',54),(13987,5,11,450,'M','2','9',54),(13988,5,11,450,'10','3','1',54),(13989,5,11,450,'10','3','2',54),(13990,5,11,450,'10','3','3',54),(13991,5,11,450,'10','3','4',54),(13992,5,11,450,'10','3','5',54),(13993,5,11,450,'10','3','6',54),(13994,5,11,450,'10','3','7',54),(13995,5,11,450,'7','3','8',54),(13996,5,11,450,'M','3','9',54),(13997,5,11,450,'10','4','1',54),(13998,5,11,450,'10','4','2',54),(13999,5,11,450,'10','4','3',54),(14000,5,11,450,'10','4','4',54),(14001,5,11,450,'10','4','5',54),(14002,5,11,450,'10','4','6',54),(14003,5,11,450,'10','4','7',54),(14004,5,11,450,'5','4','8',54),(14005,5,11,450,'M','4','9',54),(14006,5,11,450,'10','5','1',54),(14007,5,11,450,'10','5','2',54),(14008,5,11,450,'10','5','3',54),(14009,5,11,450,'10','5','4',54),(14010,5,11,450,'10','5','5',54),(14011,5,11,450,'10','5','6',54),(14012,5,11,450,'1','5','7',54),(14013,5,11,450,'M','5','8',54),(14014,5,11,450,'M','5','9',54),(14015,5,11,450,'10','6','1',54),(14016,5,11,450,'10','6','2',54),(14017,5,11,450,'10','6','3',54),(14018,5,11,450,'10','6','4',54),(14019,5,11,450,'10','6','5',54),(14020,5,11,450,'10','6','6',54),(14021,5,11,450,'5','6','7',54),(14022,5,11,450,'M','6','8',54),(14023,5,11,450,'M','6','9',54),(14024,5,11,450,'10','7','1',54),(14025,5,11,450,'10','7','2',54),(14026,5,11,450,'10','7','3',54),(14027,5,11,450,'10','7','4',54),(14028,5,11,450,'4','7','5',54),(14029,5,11,450,'M','7','6',54),(14030,5,11,450,'M','7','7',54),(14031,5,11,450,'M','7','8',54),(14032,5,11,450,'M','7','9',54),(14033,5,11,451,'10','1','1',54),(14034,5,11,451,'10','1','2',54),(14035,5,11,451,'10','1','3',54),(14036,5,11,451,'10','1','4',54),(14037,5,11,451,'10','1','5',54),(14038,5,11,451,'M','1','6',54),(14039,5,11,451,'M','1','7',54),(14040,5,11,451,'M','1','8',54),(14041,5,11,451,'M','1','9',54),(14042,5,11,451,'10','2','1',54),(14043,5,11,451,'10','2','2',54),(14044,5,11,451,'10','2','3',54),(14045,5,11,451,'10','2','4',54),(14046,5,11,451,'10','2','5',54),(14047,5,11,451,'10','2','6',54),(14048,5,11,451,'5','2','7',54),(14049,5,11,451,'M','2','8',54),(14050,5,11,451,'M','2','9',54),(14051,5,11,451,'10','3','1',54),(14052,5,11,451,'10','3','2',54),(14053,5,11,451,'10','3','3',54),(14054,5,11,451,'10','3','4',54),(14055,5,11,451,'10','3','5',54),(14056,5,11,451,'10','3','6',54),(14057,5,11,451,'10','3','7',54),(14058,5,11,451,'9','3','8',54),(14059,5,11,451,'m','3','9',54),(14060,5,11,451,'10','4','1',54),(14061,5,11,451,'10','4','2',54),(14062,5,11,451,'10','4','3',54),(14063,5,11,451,'10','4','4',54),(14064,5,11,451,'10','4','5',54),(14065,5,11,451,'10','4','6',54),(14066,5,11,451,'10','4','7',54),(14067,5,11,451,'9','4','8',54),(14068,5,11,451,'M','4','9',54),(14069,5,11,451,'10','5','1',54),(14070,5,11,451,'10','5','2',54),(14071,5,11,451,'10','5','3',54),(14072,5,11,451,'10','5','4',54),(14073,5,11,451,'10','5','5',54),(14074,5,11,451,'10','5','6',54),(14075,5,11,451,'2','5','7',54),(14076,5,11,451,'M','5','8',54),(14077,5,11,451,'M','5','9',54),(14078,5,11,451,'10','6','1',54),(14079,5,11,451,'10','6','2',54),(14080,5,11,451,'10','6','3',54),(14081,5,11,451,'10','6','4',54),(14082,5,11,451,'10','6','5',54),(14083,5,11,451,'10','6','6',54),(14084,5,11,451,'7','6','7',54),(14085,5,11,451,'M','6','8',54),(14086,5,11,451,'M','6','9',54),(14087,5,11,451,'10','7','1',54),(14088,5,11,451,'10','7','2',54),(14089,5,11,451,'10','7','3',54),(14090,5,11,451,'10','7','4',54),(14091,5,11,451,'4','7','5',54),(14092,5,11,451,'M','7','6',54),(14093,5,11,451,'M','7','7',54),(14094,5,11,451,'M','7','8',54),(14095,5,11,451,'M','7','9',54),(14096,10,11,270,'10','1','1',49),(14097,10,11,270,'10','1','2',49),(14098,10,11,270,'10','1','3',49),(14099,10,11,270,'10','1','4',49),(14100,10,11,270,'10','1','5',49),(14101,10,11,270,'10','1','6',49),(14102,10,11,270,'4','1','7',49),(14103,10,11,270,'M','1','8',49),(14104,10,11,270,'M','1','9',49),(14105,10,11,270,'10','2','1',49),(14106,10,11,270,'10','2','2',49),(14107,10,11,270,'10','2','3',49),(14108,10,11,270,'10','2','4',49),(14109,10,11,270,'10','2','5',49),(14110,10,11,270,'8','2','6',49),(14111,10,11,270,'M','2','7',49),(14112,10,11,270,'M','2','8',49),(14113,10,11,270,'M','2','9',49),(14114,5,11,452,'10','1','1',54),(14115,5,11,452,'10','1','2',54),(14116,5,11,452,'10','1','3',54),(14117,5,11,452,'10','1','4',54),(14118,5,11,452,'10','1','5',54),(14119,5,11,452,'10','1','6',54),(14120,5,11,452,'8','1','7',54),(14121,10,11,270,'10','3','1',49),(14122,5,11,452,'M','1','8',54),(14123,10,11,270,'10','3','2',49),(14124,5,11,452,'M','1','9',54),(14125,10,11,270,'10','3','3',49),(14126,5,11,452,'10','2','1',54),(14127,5,11,452,'10','2','2',54),(14128,5,11,452,'10','2','3',54),(14129,5,11,452,'10','2','4',54),(14130,5,11,452,'10','2','5',54),(14131,5,11,452,'10','2','6',54),(14132,5,11,452,'4','2','7',54),(14133,5,11,452,'M','2','8',54),(14134,10,11,270,'10','3','5',49),(14135,10,11,270,'10','3','4',49),(14136,5,11,452,'M','2','9',54),(14137,10,11,270,'M','3','8',49),(14138,10,11,270,'7','3','7',49),(14139,10,11,270,'M','3','9',49),(14140,10,11,270,'10','4','1',49),(14141,10,11,270,'10','4','2',49),(14142,10,11,270,'10','4','3',49),(14143,5,11,452,'10','3','1',54),(14144,10,11,270,'10','4','4',49),(14145,5,11,452,'10','3','2',54),(14146,10,11,270,'10','4','5',49),(14147,10,11,270,'5','4','6',49),(14148,5,11,452,'10','3','3',54),(14149,5,11,452,'10','3','4',54),(14151,5,11,452,'10','3','5',54),(14152,5,11,452,'10','3','6',54),(14153,5,11,452,'6','3','7',54),(14154,5,11,452,'M','3','8',54),(14155,10,11,270,'M','4','7',49),(14156,5,11,452,'M','3','9',54),(14157,5,11,452,'10','4','1',54),(14158,10,11,270,'M','4','8',49),(14159,5,11,452,'10','4','2',54),(14160,10,11,270,'M','4','9',49),(14161,5,11,452,'10','4','3',54),(14162,5,11,452,'10','4','4',54),(14163,5,11,452,'10','4','5',54),(14164,5,11,452,'5','4','6',54),(14165,10,11,270,'10','5','1',49),(14166,5,11,452,'M','4','7',54),(14167,10,11,270,'10','5','2',49),(14168,10,11,270,'10','5','3',49),(14169,5,11,452,'M','4','8',54),(14170,5,11,452,'M','4','9',54),(14171,10,11,270,'10','5','4',49),(14172,10,11,270,'10','5','5',49),(14173,10,11,270,'7','5','6',49),(14174,10,11,270,'M','5','7',49),(14175,10,11,270,'M','5','8',49),(14176,5,11,452,'10','5','1',54),(14177,10,11,270,'M','5','9',49),(14178,5,11,452,'10','5','2',54),(14179,10,11,270,'10','6','1',49),(14180,5,11,452,'10','5','3',54),(14181,10,11,270,'10','6','2',49),(14182,5,11,452,'10','5','4',54),(14183,10,11,270,'10','6','3',49),(14184,5,11,452,'10','5','5',54),(14185,10,11,270,'10','6','4',49),(14186,5,11,452,'10','5','6',54),(14187,5,11,452,'2','5','7',54),(14188,10,11,270,'8','6','5',49),(14189,5,11,452,'M','5','8',54),(14190,10,11,270,'M','6','6',49),(14191,5,11,452,'M','5','9',54),(14192,10,11,270,'M','6','7',49),(14193,5,11,452,'10','6','1',54),(14194,10,11,270,'M','6','8',49),(14195,5,11,452,'10','6','2',54),(14196,10,11,270,'M','6','9',49),(14197,5,11,452,'10','6','3',54),(14198,5,11,452,'10','6','4',54),(14199,5,11,452,'10','6','5',54),(14200,5,11,452,'10','6','6',54),(14201,5,11,452,'2','6','7',54),(14202,5,11,452,'M','6','8',54),(14203,5,11,452,'M','6','9',54),(14204,5,11,452,'10','7','1',54),(14205,10,11,270,'10','7','1',49),(14206,5,11,452,'10','7','2',54),(14207,5,11,452,'10','7','3',54),(14208,10,11,270,'10','7','2',49),(14209,5,11,452,'10','7','4',54),(14210,10,11,270,'10','7','3',49),(14211,5,11,452,'10','7','5',54),(14212,10,11,270,'10','7','4',49),(14213,5,11,452,'10','7','6',54),(14214,10,11,270,'10','7','5',49),(14215,5,11,452,'5','7','7',54),(14216,10,11,270,'10','7','6',49),(14217,5,11,452,'M','7','8',54),(14218,10,11,270,'10','7','7',49),(14219,5,11,452,'M','7','9',54),(14220,10,11,270,'5','7','8',49),(14221,10,11,270,'M','7','9',49),(14222,10,11,271,'10','1','1',49),(14223,10,11,271,'10','1','2',49),(14224,10,11,271,'10','1','3',49),(14225,10,11,271,'10','1','4',49),(14226,10,11,271,'10','1','5',49),(14227,10,11,271,'3','1','6',49),(14228,10,11,271,'M','1','7',49),(14229,10,11,271,'M','1','8',49),(14230,10,11,271,'M','1','9',49),(14231,10,11,271,'10','2','1',49),(14232,10,11,271,'10','2','2',49),(14233,10,11,271,'10','2','3',49),(14234,10,11,271,'10','2','4',49),(14235,10,11,271,'10','2','5',49),(14236,10,11,271,'10','2','6',49),(14237,10,11,271,'1','2','7',49),(14238,10,11,271,'M','2','8',49),(14239,10,11,271,'10','2','9',49),(14240,5,11,453,'10','1','1',54),(14241,10,11,271,'10','3','1',49),(14242,5,11,453,'10','1','2',54),(14243,5,11,453,'10','1','3',54),(14244,10,11,271,'10','3','2',49),(14245,5,11,453,'10','1','4',54),(14246,10,11,271,'10','3','3',49),(14247,5,11,453,'10','1','5',54),(14248,10,11,271,'10','3','4',49),(14250,10,11,271,'4','3','5',49),(14252,10,11,271,'M','3','6',49),(14253,10,11,271,'M','3','7',49),(14254,10,11,271,'10','3','8',49),(14255,10,11,271,'10','3','9',49),(14256,10,11,271,'10','4','1',49),(14257,10,11,271,'10','4','2',49),(14258,10,11,271,'10','4','3',49),(14259,10,11,271,'10','4','4',49),(14260,5,11,453,'6','1','6',54),(14261,10,11,271,'5','4','5',49),(14262,10,11,271,'M','4','6',49),(14263,10,11,271,'M','4','7',49),(14264,5,11,453,'M','1','7',54),(14265,10,11,271,'M','4','8',49),(14266,5,11,453,'M','1','8',54),(14267,10,11,271,'M','4','9',49),(14268,5,11,453,'M','1','9',54),(14269,5,11,453,'10','2','1',54),(14270,5,11,453,'10','2','2',54),(14271,5,11,453,'10','2','3',54),(14272,5,11,453,'10','2','4',54),(14273,5,11,453,'10','2','5',54),(14274,5,11,453,'2','2','6',54),(14275,5,11,453,'M','2','7',54),(14276,5,11,453,'M','2','8',54),(14277,5,11,453,'M','2','9',54),(14278,10,11,271,'10','5','1',49),(14279,10,11,271,'10','5','2',49),(14280,10,11,271,'10','5','3',49),(14281,10,11,271,'10','5','4',49),(14282,10,11,271,'10','5','5',49),(14283,10,11,271,'10','5','6',49),(14284,10,11,271,'1','5','7',49),(14285,10,11,271,'M','5','8',49),(14286,10,11,271,'M','5','9',49),(14287,10,11,271,'10','6','1',49),(14288,10,11,271,'10','6','2',49),(14289,10,11,271,'10','6','3',49),(14290,10,11,271,'10','6','4',49),(14291,10,11,271,'10','6','5',49),(14292,10,11,271,'8','6','6',49),(14293,10,11,271,'M','6','7',49),(14294,10,11,271,'M','6','8',49),(14295,10,11,271,'M','6','9',49),(14296,10,11,271,'10','7','1',49),(14297,10,11,271,'10','7','2',49),(14298,10,11,271,'10','7','3',49),(14299,10,11,271,'10','7','4',49),(14300,10,11,271,'10','7','5',49),(14301,10,11,271,'10','7','6',49),(14302,10,11,271,'5','7','7',49),(14303,10,11,271,'M','7','8',49),(14304,10,11,271,'M','7','9',49),(14305,10,11,272,'10','1','1',49),(14306,10,11,272,'10','1','2',49),(14307,10,11,272,'10','1','3',49),(14308,10,11,272,'10','1','4',49),(14309,10,11,272,'10','1','5',49),(14310,10,11,272,'7','1','6',49),(14311,10,11,272,'M','1','7',49),(14312,10,11,272,'M','1','8',49),(14313,10,11,272,'M','1','9',49),(14314,10,11,272,'10','2','1',49),(14315,10,11,272,'10','2','2',49),(14316,10,11,272,'10','2','3',49),(14317,10,11,272,'10','2','4',49),(14318,10,11,272,'10','2','5',49),(14319,10,11,272,'5','2','6',49),(14320,10,11,272,'M','2','7',49),(14321,10,11,272,'M','2','8',49),(14322,10,11,272,'M','2','9',49),(14323,10,11,272,'10','3','1',49),(14324,10,11,272,'10','3','2',49),(14325,10,11,272,'10','3','3',49),(14326,10,11,272,'10','3','4',49),(14327,10,11,272,'10','3','5',49),(14328,10,11,272,'10','3','6',49),(14329,10,11,272,'10','3','7',49),(14330,10,11,272,'M','3','8',49),(14331,10,11,272,'M','3','9',49),(14332,10,11,272,'10','4','1',49),(14333,10,11,272,'10','4','2',49),(14334,10,11,272,'10','4','3',49),(14335,10,11,272,'10','4','4',49),(14336,10,11,272,'10','4','5',49),(14337,10,11,272,'10','4','6',49),(14338,10,11,272,'3','4','7',49),(14339,10,11,272,'M','4','8',49),(14340,10,11,272,'M','4','9',49),(14341,10,11,272,'10','5','1',49),(14343,10,11,272,'10','5','3',49),(14344,10,11,272,'10','5','4',49),(14345,10,11,272,'10','5','2',49),(14346,10,11,272,'2','5','5',49),(14347,10,11,272,'M','5','6',49),(14348,10,11,272,'M','5','7',49),(14349,10,11,272,'M','5','8',49),(14350,10,11,272,'M','5','9',49),(14351,10,11,272,'10','6','1',49),(14352,10,11,272,'10','6','2',49),(14353,10,11,272,'10','6','3',49),(14354,10,11,272,'10','6','4',49),(14355,10,11,272,'10','6','5',49),(14356,10,11,272,'10','6','6',49),(14357,10,11,272,'2','6','7',49),(14358,10,11,272,'M','6','8',49),(14359,10,11,272,'M','6','9',49),(14360,5,11,453,'10','3','1',54),(14361,10,11,272,'10','7','1',49),(14362,5,11,453,'10','3','2',54),(14363,5,11,453,'10','3','3',54),(14364,10,11,272,'10','7','2',49),(14365,10,11,272,'10','7','3',49),(14366,5,11,453,'10','3','4',54),(14367,10,11,272,'10','7','4',49),(14368,5,11,453,'9','3','5',54),(14369,10,11,272,'10','7','5',49),(14370,5,11,453,'M','3','6',54),(14371,10,11,272,'10','7','6',49),(14372,5,11,453,'M','3','7',54),(14373,10,11,272,'4','7','7',49),(14374,5,11,453,'M','3','8',54),(14375,10,11,272,'M','7','8',49),(14376,5,11,453,'M','3','9',54),(14377,10,11,272,'M','7','9',49),(14378,5,11,453,'10','4','1',54),(14379,5,11,453,'10','4','2',54),(14380,5,11,453,'10','4','3',54),(14381,5,11,453,'10','4','4',54),(14382,5,11,453,'10','4','5',54),(14383,5,11,453,'10','4','6',54),(14384,5,11,453,'10','4','7',54),(14385,5,11,453,'10','4','8',54),(14386,5,11,453,'M','4','9',54),(14387,5,11,453,'10','5','1',54),(14388,5,11,453,'10','5','2',54),(14389,5,11,453,'10','5','3',54),(14390,5,11,453,'10','5','4',54),(14391,5,11,453,'10','5','5',54),(14392,5,11,453,'8','5','6',54),(14393,5,11,453,'M','5','7',54),(14394,5,11,453,'M','5','8',54),(14395,5,11,453,'M','5','9',54),(14396,5,11,453,'10','6','1',54),(14397,5,11,453,'10','6','2',54),(14398,5,11,453,'10','6','3',54),(14399,5,11,453,'10','6','4',54),(14400,5,11,453,'10','6','5',54),(14401,5,11,453,'9','6','6',54),(14402,5,11,453,'M','6','7',54),(14403,5,11,453,'M','6','8',54),(14404,5,11,453,'M','6','9',54),(14405,5,11,453,'10','7','1',54),(14406,5,11,453,'10','7','2',54),(14407,5,11,453,'10','7','3',54),(14408,5,11,453,'10','7','4',54),(14409,5,11,453,'10','7','5',54),(14410,5,11,453,'10','7','6',54),(14411,5,11,453,'10','7','7',54),(14412,5,11,453,'9','7','8',54),(14413,5,11,453,'M','7','9',54),(14414,10,11,275,'10','1','1',49),(14415,10,11,275,'10','1','2',49),(14416,10,11,275,'10','1','3',49),(14417,10,11,275,'10','1','4',49),(14418,10,11,275,'10','1','5',49),(14419,10,11,275,'5','1','6',49),(14420,10,11,275,'M','1','7',49),(14421,10,11,275,'M','1','8',49),(14422,10,11,275,'M','1','9',49),(14423,10,11,275,'10','2','1',49),(14424,10,11,275,'10','2','2',49),(14425,10,11,275,'10','2','3',49),(14426,10,11,275,'10','2','4',49),(14427,10,11,275,'10','2','5',49),(14428,10,11,275,'5','2','6',49),(14429,10,11,275,'M','2','7',49),(14430,10,11,275,'M','2','8',49),(14431,10,11,275,'M','2','9',49),(14432,10,11,275,'10','3','1',49),(14433,10,11,275,'10','3','2',49),(14434,10,11,275,'10','3','3',49),(14435,10,11,275,'10','3','4',49),(14436,10,11,275,'10','3','5',49),(14437,10,11,275,'10','3','6',49),(14438,10,11,275,'5','3','7',49),(14439,10,11,275,'M','3','8',49),(14440,10,11,275,'M','3','9',49),(14441,10,11,275,'10','4','1',49),(14442,10,11,275,'10','4','2',49),(14443,5,11,454,'10','1','1',54),(14444,10,11,275,'10','4','3',49),(14445,5,11,454,'10','1','2',54),(14446,10,11,275,'10','4','4',49),(14447,5,11,454,'10','1','3',54),(14448,10,11,275,'10','4','5',49),(14449,5,11,454,'10','1','4',54),(14451,5,11,454,'10','1','5',54),(14453,10,11,275,'10','4','6',49),(14454,5,11,454,'9','1','6',54),(14455,10,11,275,'6','4','7',49),(14456,5,11,454,'M','1','7',54),(14457,10,11,275,'M','4','8',49),(14458,5,11,454,'M','1','8',54),(14459,10,11,275,'M','4','9',49),(14460,5,11,454,'M','1','9',54),(14461,10,11,275,'10','5','1',49),(14462,5,11,454,'10','2','1',54),(14463,5,11,454,'10','2','2',54),(14464,10,11,275,'10','5','2',49),(14465,5,11,454,'10','2','3',54),(14466,10,11,275,'10','5','3',49),(14467,5,11,454,'10','2','4',54),(14468,10,11,275,'10','5','4',49),(14469,5,11,454,'10','2','5',54),(14470,10,11,275,'10','5','5',49),(14471,5,11,454,'10','2','6',54),(14472,10,11,275,'9','5','6',49),(14473,5,11,454,'10','2','7',54),(14474,10,11,275,'M','5','7',49),(14475,5,11,454,'M','2','8',54),(14476,10,11,275,'M','5','8',49),(14477,5,11,454,'M','2','9',54),(14478,10,11,275,'M','5','9',49),(14479,5,11,454,'10','3','1',54),(14480,5,11,454,'10','3','2',54),(14481,5,11,454,'10','3','3',54),(14482,5,11,454,'10','3','4',54),(14483,10,11,275,'10','6','1',49),(14484,5,11,454,'10','3','5',54),(14485,10,11,275,'10','6','2',49),(14486,10,11,275,'10','6','3',49),(14487,5,11,454,'10','3','6',54),(14488,10,11,275,'10','6','4',49),(14489,5,11,454,'4','3','7',54),(14490,10,11,275,'9','6','5',49),(14491,5,11,454,'M','3','8',54),(14492,10,11,275,'M','6','6',49),(14493,5,11,454,'M','3','9',54),(14494,10,11,275,'M','6','7',49),(14495,5,11,454,'10','4','1',54),(14496,5,11,454,'10','4','2',54),(14497,10,11,275,'M','6','8',49),(14498,5,11,454,'10','4','3',54),(14499,10,11,275,'M','6','9',49),(14500,5,11,454,'10','4','4',54),(14501,10,11,275,'10','7','1',49),(14502,5,11,454,'10','4','5',54),(14503,10,11,275,'10','7','2',49),(14504,5,11,454,'10','4','6',54),(14505,10,11,275,'10','7','3',49),(14506,10,11,275,'10','7','4',49),(14507,5,11,454,'M','4','7',54),(14508,10,11,275,'10','7','5',49),(14509,5,11,454,'M','4','8',54),(14510,10,11,275,'9','7','6',49),(14511,5,11,454,'M','4','9',54),(14512,10,11,275,'M','7','7',49),(14513,10,11,275,'M','7','8',49),(14514,10,11,275,'M','7','9',49),(14515,5,11,454,'10','5','1',54),(14516,5,11,454,'10','5','2',54),(14517,5,11,454,'10','5','3',54),(14518,5,11,454,'10','5','4',54),(14519,5,11,454,'10','5','5',54),(14520,5,11,454,'6','5','6',54),(14521,5,11,454,'M','5','7',54),(14522,5,11,454,'M','5','8',54),(14523,5,11,454,'M','5','9',54),(14524,5,11,454,'10','6','1',54),(14525,5,11,454,'10','6','2',54),(14526,5,11,454,'10','6','3',54),(14527,5,11,454,'10','6','4',54),(14528,5,11,454,'10','6','5',54),(14529,5,11,454,'8','6','6',54),(14530,5,11,454,'M','6','7',54),(14531,5,11,454,'M','6','8',54),(14532,5,11,454,'M','6','9',54),(14533,5,11,454,'10','7','1',54),(14534,5,11,454,'10','7','2',54),(14535,5,11,454,'10','7','3',54),(14536,5,11,454,'10','7','4',54),(14537,5,11,454,'10','7','5',54),(14538,5,11,454,'9','7','6',54),(14539,5,11,454,'M','7','7',54),(14540,5,11,454,'M','7','8',54),(14541,5,11,454,'M','7','9',54),(14542,5,11,455,'10','1','1',54),(14543,5,11,455,'10','1','2',54),(14544,5,11,455,'10','1','3',54),(14545,5,11,455,'10','1','4',54),(14546,5,11,455,'10','1','5',54),(14547,5,11,455,'3','1','6',54),(14548,10,11,276,'10','1','1',49),(14549,10,11,276,'10','1','2',49),(14550,5,11,455,'M','1','7',54),(14551,10,11,276,'10','1','3',49),(14552,5,11,455,'M','1','8',54),(14553,10,11,276,'10','1','4',49),(14554,5,11,455,'M','1','9',54),(14555,10,11,276,'10','1','5',49),(14556,5,11,455,'10','2','1',54),(14557,10,11,276,'10','1','6',49),(14558,5,11,455,'10','2','2',54),(14559,10,11,276,'10','1','7',49),(14560,5,11,455,'10','2','3',54),(14561,10,11,276,'1','1','8',49),(14562,5,11,455,'10','2','4',54),(14563,5,11,455,'10','2','5',54),(14564,10,11,276,'M','1','9',49),(14565,5,11,455,'4','2','6',54),(14566,5,11,455,'M','2','7',54),(14567,10,11,276,'10','2','1',49),(14568,5,11,455,'M','2','8',54),(14569,10,11,276,'10','2','2',49),(14570,5,11,455,'M','2','9',54),(14571,10,11,276,'10','2','3',49),(14572,10,11,276,'10','2','4',49),(14573,10,11,276,'10','2','5',49),(14574,10,11,276,'10','2','6',49),(14575,5,11,455,'10','3','1',54),(14576,5,11,455,'10','3','2',54),(14577,5,11,455,'10','3','3',54),(14578,5,11,455,'10','3','4',54),(14579,5,11,455,'6','3','5',54),(14580,5,11,455,'M','3','6',54),(14581,5,11,455,'M','3','7',54),(14582,5,11,455,'M','3','8',54),(14583,10,11,276,'4','2','7',49),(14584,5,11,455,'M','3','9',54),(14585,10,11,276,'M','2','8',49),(14586,10,11,276,'M','2','9',49),(14587,5,11,455,'10','4','1',54),(14588,5,11,455,'10','4','2',54),(14589,10,11,276,'10','3','1',49),(14590,5,11,455,'10','4','3',54),(14591,10,11,276,'10','3','2',49),(14592,5,11,455,'10','4','4',54),(14593,10,11,276,'10','3','3',49),(14594,5,11,455,'10','4','5',54),(14595,5,11,455,'10','4','6',54),(14596,5,11,455,'6','4','7',54),(14597,10,11,276,'10','3','4',49),(14598,5,11,455,'M','4','8',54),(14599,10,11,276,'10','3','5',49),(14600,5,11,455,'M','4','9',54),(14601,10,11,276,'10','3','6',49),(14603,5,11,455,'10','5','1',54),(14604,10,11,276,'4','3','7',49),(14605,5,11,455,'10','5','2',54),(14606,10,11,276,'M','3','8',49),(14607,5,11,455,'10','5','3',54),(14608,10,11,276,'M','3','9',49),(14609,5,11,455,'10','5','4',54),(14610,5,11,455,'10','5','5',54),(14611,5,11,455,'10','5','6',54),(14612,5,11,455,'6','5','7',54),(14613,5,11,455,'M','5','8',54),(14614,5,11,455,'M','5','9',54),(14615,5,11,455,'10','6','1',54),(14616,5,11,455,'10','6','2',54),(14617,5,11,455,'10','6','3',54),(14618,5,11,455,'10','6','4',54),(14619,10,11,276,'10','4','1',49),(14620,5,11,455,'10','6','5',54),(14621,10,11,276,'10','4','2',49),(14622,5,11,455,'10','6','6',54),(14623,10,11,276,'10','4','3',49),(14624,5,11,455,'10','6','7',54),(14625,10,11,276,'10','4','4',49),(14626,5,11,455,'10','6','8',54),(14627,10,11,276,'10','4','5',49),(14628,5,11,455,'M','6','9',54),(14629,10,11,276,'10','4','6',49),(14630,10,11,276,'3','4','7',49),(14631,10,11,276,'M','4','8',49),(14632,5,11,455,'10','7','1',54),(14633,10,11,276,'M','4','9',49),(14634,5,11,455,'10','7','2',54),(14635,5,11,455,'10','7','3',54),(14636,10,11,276,'10','5','1',49),(14637,5,11,455,'10','7','4',54),(14638,10,11,276,'10','5','2',49),(14639,5,11,455,'10','7','5',54),(14640,10,11,276,'10','5','3',49),(14641,5,11,455,'M','7','6',54),(14642,10,11,276,'10','5','4',49),(14643,5,11,455,'M','7','7',54),(14644,10,11,276,'3','5','5',49),(14646,10,11,276,'M','5','6',49),(14647,10,11,276,'M','5','7',49),(14648,10,11,276,'M','5','8',49),(14649,5,11,455,'M','7','8',54),(14650,10,11,276,'M','5','9',49),(14651,5,11,455,'M','7','9',54),(14652,10,11,276,'10','6','1',49),(14653,10,11,276,'10','6','2',49),(14654,10,11,276,'10','6','3',49),(14655,10,11,276,'10','6','4',49),(14656,10,11,276,'6','6','5',49),(14657,10,11,276,'M','6','6',49),(14658,10,11,276,'M','6','7',49),(14659,10,11,276,'M','6','8',49),(14660,10,11,276,'M','6','9',49),(14661,10,11,276,'10','7','1',49),(14662,10,11,276,'10','7','2',49),(14663,10,11,276,'10','7','3',49),(14664,10,11,276,'10','7','4',49),(14665,10,11,276,'10','7','5',49),(14666,10,11,276,'2','7','6',49),(14667,10,11,276,'M','7','7',49),(14668,10,11,276,'M','7','8',49),(14669,10,11,276,'M','7','9',49),(14670,5,11,456,'10','1','1',54),(14671,5,11,456,'10','1','2',54),(14672,5,11,456,'10','1','3',54),(14673,5,11,456,'10','1','4',54),(14674,5,11,456,'10','1','5',54),(14675,5,11,456,'6','1','6',54),(14676,5,11,456,'M','1','7',54),(14677,5,11,456,'M','1','8',54),(14678,5,11,456,'M','1','9',54),(14679,5,11,456,'10','2','1',54),(14680,5,11,456,'10','2','2',54),(14681,5,11,456,'10','2','3',54),(14682,5,11,456,'10','2','4',54),(14683,5,11,456,'10','2','5',54),(14684,5,11,456,'10','2','6',54),(14685,5,11,456,'10','2','7',54),(14686,5,11,456,'5','2','8',54),(14687,5,11,456,'M','2','9',54),(14688,5,11,456,'10','3','1',54),(14689,5,11,456,'10','3','2',54),(14690,5,11,456,'10','3','3',54),(14691,5,11,456,'10','3','4',54),(14692,5,11,456,'10','3','5',54),(14693,10,11,277,'10','1','1',49),(14694,5,11,456,'3','3','6',54),(14695,10,11,277,'10','1','2',49),(14696,5,11,456,'M','3','7',54),(14697,10,11,277,'10','1','3',49),(14698,5,11,456,'M','3','8',54),(14699,5,11,456,'M','3','9',54),(14700,10,11,277,'10','1','4',49),(14701,10,11,277,'10','1','5',49),(14702,5,11,456,'10','4','1',54),(14703,10,11,277,'1','1','6',49),(14704,5,11,456,'10','4','2',54),(14705,10,11,277,'M','1','7',49),(14706,5,11,456,'10','4','3',54),(14707,10,11,277,'M','1','8',49),(14708,5,11,456,'10','4','4',54),(14709,10,11,277,'M','1','9',49),(14710,5,11,456,'10','4','5',54),(14711,5,11,456,'10','4','6',54),(14712,10,11,277,'10','2','1',49),(14713,5,11,456,'3','4','7',54),(14714,10,11,277,'10','2','2',49),(14715,5,11,456,'M','4','8',54),(14716,5,11,456,'M','4','9',54),(14717,10,11,277,'10','2','3',49),(14718,10,11,277,'10','2','4',49),(14719,5,11,456,'10','5','1',54),(14720,10,11,277,'2','2','5',49),(14721,5,11,456,'10','5','2',54),(14722,10,11,277,'M','2','6',49),(14723,10,11,277,'M','2','7',49),(14724,10,11,277,'M','2','8',49),(14725,10,11,277,'M','2','9',49),(14726,10,11,277,'10','3','1',49),(14727,10,11,277,'10','3','2',49),(14728,10,11,277,'10','3','3',49),(14729,10,11,277,'10','3','4',49),(14730,10,11,277,'10','3','5',49),(14731,10,11,277,'10','3','6',49),(14732,10,11,277,'4','3','7',49),(14733,10,11,277,'M','3','8',49),(14734,5,11,456,'10','5','3',54),(14735,5,11,456,'10','5','4',54),(14736,10,11,277,'M','3','9',49),(14737,5,11,456,'10','5','5',54),(14738,5,11,456,'7','5','6',54),(14739,5,11,456,'M','5','7',54),(14740,5,11,456,'M','5','8',54),(14741,5,11,456,'M','5','9',54),(14742,5,11,456,'10','6','1',54),(14743,5,11,456,'10','6','2',54),(14744,5,11,456,'10','6','3',54),(14745,5,11,456,'10','6','4',54),(14746,5,11,456,'10','6','5',54),(14747,5,11,456,'10','6','6',54),(14748,5,11,456,'4','6','7',54),(14749,5,11,456,'M','6','8',54),(14750,5,11,456,'M','6','9',54),(14751,10,11,277,'10','4','1',49),(14752,10,11,277,'10','4','2',49),(14753,10,11,277,'10','4','3',49),(14754,10,11,277,'10','4','4',49),(14755,10,11,277,'10','4','5',49),(14756,5,11,456,'10','7','1',54),(14757,10,11,277,'7','4','6',49),(14758,5,11,456,'10','7','2',54),(14759,10,11,277,'M','4','7',49),(14760,5,11,456,'10','7','3',54),(14761,10,11,277,'M','4','8',49),(14762,5,11,456,'8','7','4',54),(14763,10,11,277,'M','4','9',49),(14764,5,11,456,'M','7','5',54),(14765,5,11,456,'M','7','6',54),(14766,10,11,277,'10','5','1',49),(14767,5,11,456,'M','7','7',54),(14768,10,11,277,'10','5','2',49),(14769,5,11,456,'M','7','8',54),(14770,10,11,277,'10','5','3',49),(14771,5,11,456,'M','7','9',54),(14772,10,11,277,'10','5','4',49),(14773,10,11,277,'10','5','5',49),(14774,10,11,277,'10','5','6',49),(14775,10,11,277,'7','5','7',49),(14776,10,11,277,'M','5','8',49),(14777,10,11,277,'M','5','9',49),(14778,10,11,277,'10','6','1',49),(14779,10,11,277,'10','6','2',49),(14780,10,11,277,'10','6','3',49),(14781,10,11,277,'10','6','4',49),(14782,10,11,277,'3','6','5',49),(14783,10,11,277,'M','6','6',49),(14784,10,11,277,'M','6','7',49),(14785,10,11,277,'M','6','8',49),(14786,10,11,277,'M','6','9',49),(14787,10,11,277,'10','7','1',49),(14788,10,11,277,'10','7','2',49),(14789,10,11,277,'10','7','3',49),(14790,10,11,277,'9','7','4',49),(14791,10,11,277,'M','7','5',49),(14792,10,11,277,'M','7','6',49),(14793,10,11,277,'M','7','7',49),(14794,10,11,277,'M','7','8',49),(14795,5,11,457,'10','1','1',54),(14796,10,11,277,'M','7','9',49),(14797,5,11,457,'10','1','2',54),(14798,5,11,457,'10','1','3',54),(14799,5,11,457,'10','1','4',54),(14800,5,11,457,'10','1','5',54),(14801,5,11,457,'4','1','6',54),(14802,5,11,457,'M','1','7',54),(14803,5,11,457,'M','1','8',54),(14804,5,11,457,'M','1','9',54),(14805,5,11,457,'10','2','1',54),(14806,5,11,457,'10','2','2',54),(14807,5,11,457,'10','2','3',54),(14808,5,11,457,'3','2','4',54),(14809,5,11,457,'M','2','5',54),(14810,5,11,457,'M','2','6',54),(14811,5,11,457,'M','2','7',54),(14812,5,11,457,'M','2','8',54),(14813,5,11,457,'M','2','9',54),(14814,5,11,457,'10','3','1',54),(14815,5,11,457,'10','3','2',54),(14816,5,11,457,'10','3','3',54),(14817,5,11,457,'10','3','4',54),(14818,5,11,457,'10','3','5',54),(14819,5,11,457,'10','3','6',54),(14820,5,11,457,'8','3','7',54),(14821,5,11,457,'M','3','8',54),(14822,5,11,457,'M','3','9',54),(14823,5,11,457,'10','4','1',54),(14824,5,11,457,'10','4','2',54),(14825,5,11,457,'10','4','3',54),(14826,5,11,457,'10','4','4',54),(14827,5,11,457,'9','4','5',54),(14828,5,11,457,'M','4','6',54),(14829,5,11,457,'M','4','7',54),(14830,5,11,457,'M','4','8',54),(14831,5,11,457,'M','4','9',54),(14832,5,11,457,'10','5','1',54),(14833,5,11,457,'10','5','2',54),(14834,5,11,457,'10','5','3',54),(14835,5,11,457,'10','5','4',54),(14836,5,11,457,'10','5','5',54),(14837,5,11,457,'10','5','6',54),(14838,5,11,457,'10','5','7',54),(14839,5,11,457,'1','5','8',54),(14840,5,11,457,'M','5','9',54),(14841,10,11,278,'10','1','1',49),(14842,5,11,457,'10','6','1',54),(14843,10,11,278,'10','1','2',49),(14844,5,11,457,'10','6','2',54),(14845,10,11,278,'10','1','3',49),(14846,5,11,457,'10','6','3',54),(14847,10,11,278,'10','1','4',49),(14848,5,11,457,'10','6','4',54),(14849,10,11,278,'10','1','5',49),(14850,5,11,457,'10','6','5',54),(14851,10,11,278,'10','1','6',49),(14852,10,11,278,'10','1','7',49),(14853,5,11,457,'8','6','6',54),(14854,10,11,278,'2','1','8',49),(14855,5,11,457,'M','6','7',54),(14856,10,11,278,'M','1','9',49),(14857,5,11,457,'M','6','8',54),(14858,5,11,457,'M','6','9',54),(14859,10,11,278,'10','2','1',49),(14860,10,11,278,'10','2','2',49),(14861,10,11,278,'10','2','3',49),(14862,5,11,457,'10','7','1',54),(14863,5,11,457,'10','7','2',54),(14864,10,11,278,'5','2','4',49),(14865,5,11,457,'10','7','3',54),(14866,5,11,457,'10','7','4',54),(14867,5,11,457,'10','7','5',54),(14868,5,11,457,'10','7','6',54),(14869,5,11,457,'3','7','7',54),(14870,5,11,457,'M','7','8',54),(14871,10,11,278,'M','2','5',49),(14872,5,11,457,'M','7','9',54),(14873,10,11,278,'M','2','6',49),(14874,10,11,278,'M','2','7',49),(14875,10,11,278,'M','2','8',49),(14876,10,11,278,'M','2','9',49),(14877,10,11,278,'10','3','1',49),(14878,10,11,278,'10','3','2',49),(14879,10,11,278,'10','3','3',49),(14880,10,11,278,'5','3','4',49),(14881,10,11,278,'M','3','5',49),(14882,10,11,278,'M','3','6',49),(14883,10,11,278,'M','3','7',49),(14884,10,11,278,'M','3','8',49),(14885,10,11,278,'M','3','9',49),(14886,10,11,278,'10','4','1',49),(14887,10,11,278,'10','4','2',49),(14888,10,11,278,'10','4','3',49),(14889,10,11,278,'10','4','4',49),(14890,10,11,278,'10','4','5',49),(14891,10,11,278,'10','4','6',49),(14892,10,11,278,'1','4','7',49),(14893,10,11,278,'M','4','8',49),(14894,10,11,278,'M','4','9',49),(14895,10,11,278,'10','5','1',49),(14896,10,11,278,'10','5','2',49),(14897,10,11,278,'10','5','3',49),(14898,10,11,278,'10','5','4',49),(14899,10,11,278,'7','5','5',49),(14900,10,11,278,'M','5','6',49),(14901,10,11,278,'M','5','7',49),(14902,10,11,278,'M','5','8',49),(14903,10,11,278,'M','5','9',49),(14904,5,11,458,'10','1','1',54),(14905,10,11,278,'10','6','1',49),(14906,5,11,458,'10','1','2',54),(14907,10,11,278,'10','6','2',49),(14908,5,11,458,'10','1','3',54),(14909,10,11,278,'10','6','3',49),(14910,5,11,458,'10','1','4',54),(14911,10,11,278,'10','6','4',49),(14912,5,11,458,'10','1','5',54),(14913,10,11,278,'10','6','5',49),(14914,5,11,458,'10','1','6',54),(14915,10,11,278,'M','6','6',49),(14916,5,11,458,'6','1','7',54),(14917,10,11,278,'M','6','7',49),(14918,5,11,458,'M','1','8',54),(14919,10,11,278,'M','6','8',49),(14920,5,11,458,'M','1','9',54),(14921,10,11,278,'M','6','9',49),(14922,5,11,458,'10','2','1',54),(14923,5,11,458,'10','2','2',54),(14924,5,11,458,'10','2','3',54),(14925,5,11,458,'10','2','4',54),(14926,5,11,458,'10','2','5',54),(14927,5,11,458,'10','2','6',54),(14928,5,11,458,'10','2','7',54),(14929,5,11,458,'M','2','8',54),(14930,5,11,458,'M','2','9',54),(14931,10,11,278,'10','7','1',49),(14932,10,11,278,'10','7','2',49),(14933,10,11,278,'10','7','3',49),(14934,5,11,458,'10','3','1',54),(14935,10,11,278,'10','7','4',49),(14936,5,11,458,'10','3','2',54),(14937,10,11,278,'10','7','5',49),(14938,5,11,458,'10','3','3',54),(14939,5,11,458,'10','3','4',54),(14940,10,11,278,'9','7','6',49),(14941,10,11,278,'M','7','7',49),(14942,10,11,278,'M','7','8',49),(14943,5,11,458,'7','3','5',54),(14944,10,11,278,'M','7','9',49),(14945,5,11,458,'M','3','6',54),(14946,5,11,458,'M','3','7',54),(14947,5,11,458,'M','3','8',54),(14948,5,11,458,'M','3','9',54),(14949,5,11,458,'10','4','1',54),(14950,5,11,458,'10','4','2',54),(14951,5,11,458,'10','4','3',54),(14952,5,11,458,'10','4','4',54),(14953,5,11,458,'10','4','5',54),(14954,5,11,458,'2','4','6',54),(14955,5,11,458,'M','4','7',54),(14956,5,11,458,'M','4','8',54),(14957,5,11,458,'M','4','9',54),(14958,5,11,458,'10','5','1',54),(14959,5,11,458,'10','5','2',54),(14960,5,11,458,'10','5','3',54),(14961,5,11,458,'10','5','4',54),(14962,5,11,458,'4','5','5',54),(14963,5,11,458,'M','5','6',54),(14964,5,11,458,'M','5','7',54),(14965,5,11,458,'M','5','8',54),(14966,5,11,458,'M','5','9',54),(14968,5,11,458,'10','6','1',54),(14969,5,11,458,'10','6','2',54),(14970,5,11,458,'10','6','3',54),(14971,5,11,458,'6','6','4',54),(14972,5,11,458,'M','6','5',54),(14973,5,11,458,'M','6','6',54),(14974,5,11,458,'M','6','7',54),(14975,5,11,458,'M','6','8',54),(14976,5,11,458,'M','6','9',54),(14977,5,11,458,'10','7','1',54),(14978,5,11,458,'10','7','2',54),(14979,5,11,458,'10','7','3',54),(14980,5,11,458,'10','7','4',54),(14981,5,11,458,'10','7','5',54),(14982,5,11,458,'7','7','6',54),(14983,5,11,458,'M','7','7',54),(14984,5,11,458,'M','7','8',54),(14985,5,11,458,'M','7','9',54),(14986,10,11,279,'10','1','1',49),(14987,10,11,279,'10','1','2',49),(14988,10,11,279,'10','1','3',49),(14989,10,11,279,'2','1','4',49),(14990,10,11,279,'M','1','5',49),(14991,10,11,279,'M','1','6',49),(14992,10,11,279,'M','1','7',49),(14993,10,11,279,'M','1','8',49),(14994,10,11,279,'M','1','9',49),(14995,10,11,279,'10','2','1',49),(14996,10,11,279,'10','2','2',49),(14997,10,11,279,'10','2','3',49),(14998,10,11,279,'10','2','4',49),(14999,10,11,279,'10','2','5',49),(15000,10,11,279,'10','2','6',49),(15001,10,11,279,'10','2','7',49),(15002,10,11,279,'5','2','8',49),(15003,10,11,279,'M','2','9',49),(15004,10,11,279,'10','3','1',49),(15005,10,11,279,'10','3','2',49),(15006,10,11,279,'10','3','3',49),(15007,10,11,279,'10','3','4',49),(15009,10,11,279,'M','3','6',49),(15011,10,11,279,'M','3','8',49),(15012,10,11,279,'M','3','9',49),(15013,10,11,279,'8','3','5',49),(15014,5,11,459,'7','1','1',54),(15015,5,11,459,'M','1','2',54),(15016,5,11,459,'M','1','3',54),(15017,5,11,459,'M','1','4',54),(15018,5,11,459,'M','1','5',54),(15019,5,11,459,'M','1','6',54),(15020,5,11,459,'M','1','7',54),(15021,5,11,459,'M','1','8',54),(15022,5,11,459,'M','1','9',54),(15023,5,11,459,'10','2','1',54),(15024,5,11,459,'10','2','2',54),(15025,5,11,459,'10','2','3',54),(15026,5,11,459,'10','2','4',54),(15027,5,11,459,'10','2','5',54),(15028,5,11,459,'10','2','6',54),(15029,5,11,459,'M','2','7',54),(15030,5,11,459,'M','2','8',54),(15031,5,11,459,'M','2','9',54),(15032,10,11,279,'M','3','7',49),(15033,5,11,459,'10','3','1',54),(15034,5,11,459,'10','3','2',54),(15035,10,11,279,'10','4','1',49),(15036,5,11,459,'10','3','3',54),(15037,10,11,279,'10','4','2',49),(15038,5,11,459,'7','3','4',54),(15039,10,11,279,'10','4','3',49),(15040,5,11,459,'M','3','5',54),(15041,10,11,279,'10','4','4',49),(15042,5,11,459,'M','3','6',54),(15043,10,11,279,'M','4','5',49),(15044,5,11,459,'M','3','7',54),(15045,10,11,279,'M','4','6',49),(15046,5,11,459,'M','3','8',54),(15047,10,11,279,'M','4','7',49),(15048,10,11,279,'M','4','8',49),(15049,5,11,459,'M','3','9',54),(15050,10,11,279,'M','4','9',49),(15051,5,11,459,'10','4','1',54),(15052,5,11,459,'10','4','2',54),(15053,5,11,459,'10','4','3',54),(15054,5,11,459,'10','4','4',54),(15055,10,11,279,'10','5','1',49),(15056,5,11,459,'4','4','5',54),(15057,10,11,279,'10','5','2',49),(15058,5,11,459,'M','4','6',54),(15059,10,11,279,'10','5','3',49),(15060,5,11,459,'M','4','7',54),(15061,10,11,279,'10','5','4',49),(15062,5,11,459,'M','4','8',54),(15063,5,11,459,'M','4','9',54),(15064,10,11,279,'4','5','5',49),(15065,10,11,279,'M','5','6',49),(15066,5,11,459,'10','5','1',54),(15067,10,11,279,'M','5','7',49),(15068,5,11,459,'10','5','2',54),(15069,10,11,279,'M','5','8',49),(15070,5,11,459,'10','5','3',54),(15071,10,11,279,'M','5','9',49),(15072,5,11,459,'10','5','4',54),(15073,10,11,279,'10','6','1',49),(15074,5,11,459,'10','5','5',54),(15075,10,11,279,'10','6','2',49),(15076,5,11,459,'M','5','6',54),(15077,10,11,279,'10','6','3',49),(15078,5,11,459,'M','5','7',54),(15079,10,11,279,'10','6','4',49),(15080,5,11,459,'M','5','8',54),(15081,10,11,279,'10','6','5',49),(15082,5,11,459,'M','5','9',54),(15083,10,11,279,'10','6','6',49),(15084,5,11,459,'10','6','1',54),(15085,10,11,279,'M','6','7',49),(15086,5,11,459,'10','6','2',54),(15087,10,11,279,'M','6','8',49),(15088,5,11,459,'10','6','3',54),(15089,10,11,279,'M','6','9',49),(15090,5,11,459,'5','6','4',54),(15091,5,11,459,'M','6','5',54),(15092,5,11,459,'M','6','6',54),(15093,5,11,459,'M','6','7',54),(15094,5,11,459,'M','6','8',54),(15095,5,11,459,'M','6','9',54),(15096,10,11,279,'10','7','1',49),(15097,10,11,279,'10','7','2',49),(15098,5,11,459,'10','7','1',54),(15099,10,11,279,'10','7','3',49),(15100,5,11,459,'10','7','2',54),(15101,10,11,279,'10','7','4',49),(15102,5,11,459,'10','7','3',54),(15103,10,11,279,'10','7','5',49),(15104,5,11,459,'10','7','4',54),(15105,10,11,279,'7','7','6',49),(15106,10,11,279,'M','7','7',49),(15107,5,11,459,'7','7','5',54),(15108,10,11,279,'M','7','8',49),(15109,10,11,279,'M','7','9',49),(15110,5,11,459,'M','7','6',54),(15111,5,11,459,'M','7','7',54),(15112,5,11,459,'M','7','8',54),(15113,5,11,459,'M','7','9',54),(15114,10,11,280,'10','1','1',49),(15115,10,11,280,'10','1','2',49),(15116,10,11,280,'10','1','3',49),(15117,10,11,280,'10','1','4',49),(15118,10,11,280,'10','1','5',49),(15119,10,11,280,'10','1','6',49),(15120,10,11,280,'M','1','7',49),(15121,10,11,280,'M','1','8',49),(15122,10,11,280,'M','1','9',49),(15123,10,11,280,'M','2','1',49),(15124,10,11,280,'M','2','2',49),(15125,10,11,280,'M','2','3',49),(15126,10,11,280,'M','2','4',49),(15127,10,11,280,'M','2','5',49),(15128,10,11,280,'M','2','6',49),(15129,10,11,280,'M','2','7',49),(15130,10,11,280,'M','2','8',49),(15131,10,11,280,'M','2','9',49),(15132,10,11,280,'10','3','1',49),(15133,10,11,280,'10','3','2',49),(15134,10,11,280,'10','3','3',49),(15135,10,11,280,'10','3','4',49),(15136,10,11,280,'10','3','5',49),(15137,10,11,280,'7','3','6',49),(15139,10,11,280,'M','3','7',49),(15140,10,11,280,'M','3','8',49),(15141,10,11,280,'M','3','9',49),(15142,10,11,280,'10','4','1',49),(15143,10,11,280,'10','4','2',49),(15144,10,11,280,'10','4','3',49),(15145,10,11,280,'10','4','4',49),(15146,10,11,280,'10','4','5',49),(15147,10,11,280,'9','4','6',49),(15148,10,11,280,'M','4','7',49),(15149,10,11,280,'M','4','8',49),(15150,10,11,280,'M','4','9',49),(15151,10,11,280,'10','5','1',49),(15152,10,11,280,'10','5','2',49),(15153,10,11,280,'10','5','3',49),(15154,10,11,280,'10','5','4',49),(15155,10,11,280,'10','5','5',49),(15156,10,11,280,'5','5','6',49),(15157,10,11,280,'M','5','7',49),(15158,10,11,280,'M','5','8',49),(15159,10,11,280,'M','5','9',49),(15160,10,11,280,'10','6','1',49),(15161,10,11,280,'10','6','2',49),(15162,10,11,280,'10','6','3',49),(15163,10,11,280,'10','6','4',49),(15164,10,11,280,'8','6','5',49),(15165,10,11,280,'M','6','6',49),(15166,10,11,280,'M','6','7',49),(15167,10,11,280,'M','6','8',49),(15168,10,11,280,'M','6','9',49),(15169,10,11,280,'10','7','1',49),(15170,10,11,280,'10','7','2',49),(15171,10,11,280,'10','7','3',49),(15172,10,11,280,'10','7','4',49),(15173,10,11,280,'10','7','5',49),(15174,10,11,280,'10','7','6',49),(15175,10,11,280,'3','7','7',49),(15176,10,11,280,'M','7','8',49),(15177,10,11,280,'M','7','9',49),(15178,10,11,281,'10','1','1',49),(15179,10,11,281,'10','1','2',49),(15180,10,11,281,'10','1','3',49),(15181,10,11,281,'6','1','4',49),(15182,10,11,281,'M','1','5',49),(15183,10,11,281,'M','1','6',49),(15184,10,11,281,'M','1','7',49),(15185,10,11,281,'M','1','8',49),(15186,10,11,281,'M','1','9',49),(15187,10,11,281,'10','2','1',49),(15188,10,11,281,'10','2','2',49),(15189,10,11,281,'10','2','3',49),(15191,10,11,281,'10','2','4',49),(15192,10,11,281,'2','2','5',49),(15193,10,11,281,'M','2','6',49),(15194,10,11,281,'M','2','7',49),(15196,10,11,281,'M','2','8',49),(15197,10,11,281,'M','2','9',49),(15198,10,11,281,'10','3','1',49),(15199,10,11,281,'10','3','2',49),(15200,10,11,281,'10','3','3',49),(15201,10,11,281,'10','3','4',49),(15202,10,11,281,'10','3','5',49),(15203,10,11,281,'3','3','6',49),(15204,10,11,281,'M','3','7',49),(15205,10,11,281,'M','3','8',49),(15206,10,11,281,'M','3','9',49),(15207,10,11,281,'10','4','1',49),(15208,10,11,281,'10','4','2',49),(15209,10,11,281,'10','4','3',49),(15210,10,11,281,'10','4','4',49),(15211,10,11,281,'10','4','5',49),(15212,10,11,281,'2','4','6',49),(15213,10,11,281,'M','4','7',49),(15214,10,11,281,'M','4','8',49),(15215,10,11,281,'M','4','9',49),(15216,10,11,281,'10','5','1',49),(15217,10,11,281,'10','5','2',49),(15218,10,11,281,'10','5','3',49),(15219,10,11,281,'10','5','4',49),(15220,10,11,281,'8','5','5',49),(15221,10,11,281,'M','5','6',49),(15222,10,11,281,'M','5','7',49),(15223,10,11,281,'M','5','8',49),(15224,10,11,281,'M','5','9',49),(15225,10,11,281,'10','6','1',49),(15226,10,11,281,'10','6','2',49),(15227,10,11,281,'10','6','3',49),(15228,10,11,281,'10','6','4',49),(15229,10,11,281,'10','6','5',49),(15231,10,11,281,'M','6','7',49),(15232,10,11,281,'M','6','8',49),(15233,10,11,281,'M','6','9',49),(15234,10,11,281,'6','6','6',49),(15235,10,11,281,'10','7','1',49),(15236,10,11,281,'10','7','2',49),(15237,10,11,281,'10','7','3',49),(15238,10,11,281,'10','7','4',49),(15239,10,11,281,'10','7','5',49),(15240,10,11,281,'1','7','6',49),(15241,10,11,281,'M','7','7',49),(15242,10,11,281,'M','7','8',49),(15243,10,11,281,'M','7','9',49),(15244,10,11,282,'10','1','1',49),(15245,10,11,282,'10','1','2',49),(15246,10,11,282,'10','1','3',49),(15247,4,11,294,'10','1','1',53),(15248,10,11,282,'10','1','4',49),(15249,4,11,294,'10','1','2',53),(15250,10,11,282,'10','1','5',49),(15251,4,11,294,'10','1','3',53),(15252,10,11,282,'10','1','6',49),(15253,4,11,294,'10','1','4',53),(15254,10,11,282,'6','1','7',49),(15255,4,11,294,'10','1','5',53),(15256,10,11,282,'M','1','8',49),(15257,4,11,294,'10','1','6',53),(15258,10,11,282,'M','1','9',49),(15259,4,11,294,'10','1','7',53),(15260,10,11,282,'10','2','1',49),(15261,4,11,294,'10','1','8',53),(15262,10,11,282,'10','2','2',49),(15263,4,11,294,'7','1','9',53),(15264,10,11,282,'10','2','3',49),(15265,4,11,294,'10','2','1',53),(15266,10,11,282,'10','2','4',49),(15267,4,11,294,'10','2','2',53),(15268,10,11,282,'10','2','5',49),(15269,4,11,294,'10','2','3',53),(15270,10,11,282,'10','2','6',49),(15271,4,11,294,'10','2','4',53),(15272,10,11,282,'6','2','7',49),(15273,4,11,294,'10','2','5',53),(15274,10,11,282,'M','2','8',49),(15275,4,11,294,'10','2','6',53),(15276,10,11,282,'M','2','9',49),(15277,4,11,294,'10','2','7',53),(15278,4,11,294,'10','2','8',53),(15279,4,11,294,'6','2','9',53),(15280,4,11,294,'10','3','1',53),(15281,4,11,294,'10','3','2',53),(15282,4,11,294,'10','3','3',53),(15283,4,11,294,'10','3','4',53),(15284,4,11,294,'10','3','5',53),(15285,4,11,294,'10','3','6',53),(15286,4,11,294,'10','3','7',53),(15287,4,11,294,'10','3','8',53),(15288,10,11,282,'10','3','1',49),(15289,4,11,294,'6','3','9',53),(15290,10,11,282,'10','3','2',49),(15291,4,11,294,'10','4','1',53),(15292,10,11,282,'10','3','3',49),(15293,4,11,294,'10','4','2',53),(15294,10,11,282,'10','3','4',49),(15295,10,11,282,'M','3','5',49),(15296,4,11,294,'10','4','3',53),(15297,4,11,294,'10','4','4',53),(15298,10,11,282,'M','3','6',49),(15299,4,11,294,'10','4','5',53),(15300,10,11,282,'M','3','7',49),(15302,10,11,282,'M','3','8',49),(15303,10,11,282,'M','3','9',49),(15304,10,11,282,'10','4','1',49),(15305,10,11,282,'10','4','2',49),(15306,10,11,282,'10','4','3',49),(15307,4,11,294,'10','4','6',53),(15308,10,11,282,'2','4','4',49),(15309,4,11,294,'10','4','7',53),(15310,10,11,282,'M','4','5',49),(15311,4,11,294,'10','4','8',53),(15312,10,11,282,'M','4','6',49),(15313,4,11,294,'6','4','9',53),(15314,10,11,282,'M','4','7',49),(15315,10,11,282,'M','4','8',49),(15316,10,11,282,'M','4','9',49),(15317,4,11,294,'10','5','1',53),(15318,4,11,294,'10','5','2',53),(15319,4,11,294,'10','5','3',53),(15320,4,11,294,'10','5','4',53),(15321,4,11,294,'10','5','5',53),(15322,4,11,294,'10','5','6',53),(15323,10,11,282,'10','5','1',49),(15324,4,11,294,'10','5','7',53),(15325,10,11,282,'10','5','2',49),(15326,4,11,294,'10','5','8',53),(15327,10,11,282,'10','5','3',49),(15328,4,11,294,'3','5','9',53),(15329,10,11,282,'3','5','4',49),(15330,4,11,294,'10','6','1',53),(15331,4,11,294,'10','6','2',53),(15332,10,11,282,'M','5','5',49),(15333,4,11,294,'10','6','3',53),(15334,10,11,282,'M','5','6',49),(15335,4,11,294,'10','6','4',53),(15336,10,11,282,'M','5','7',49),(15337,4,11,294,'10','6','5',53),(15338,10,11,282,'M','5','8',49),(15339,4,11,294,'10','6','6',53),(15340,10,11,282,'M','5','9',49),(15341,4,11,294,'10','6','7',53),(15342,10,11,282,'10','6','1',49),(15343,4,11,294,'10','6','8',53),(15344,10,11,282,'10','6','2',49),(15345,4,11,294,'6','6','9',53),(15346,10,11,282,'10','6','3',49),(15347,4,11,294,'10','7','1',53),(15349,4,11,294,'10','7','2',53),(15350,4,11,294,'10','7','3',53),(15351,4,11,294,'10','7','4',53),(15352,4,11,294,'10','7','5',53),(15353,10,11,282,'10','6','4',49),(15354,4,11,294,'10','7','6',53),(15355,4,11,294,'10','7','7',53),(15356,10,11,282,'5','6','5',49),(15357,10,11,282,'M','6','6',49),(15358,4,11,294,'10','7','8',53),(15359,10,11,282,'M','6','7',49),(15360,10,11,282,'M','6','8',49),(15361,10,11,282,'M','6','9',49),(15362,4,11,294,'9','7','9',53),(15363,10,11,282,'10','7','1',49),(15364,10,11,282,'10','7','2',49),(15365,10,11,282,'10','7','3',49),(15366,10,11,282,'10','7','4',49),(15367,10,11,282,'4','7','5',49),(15369,10,11,282,'M','7','7',49),(15370,10,11,282,'M','7','8',49),(15371,10,11,282,'M','7','9',49),(15372,10,11,282,'M','7','6',49),(15373,4,11,65,'10','1','1',53),(15374,4,11,65,'10','1','2',53),(15375,4,11,65,'10','1','3',53),(15376,4,11,65,'10','1','4',53),(15377,4,11,65,'10','1','5',53),(15378,4,11,65,'10','1','6',53),(15379,4,11,65,'10','1','7',53),(15380,4,11,65,'10','1','8',53),(15381,4,11,65,'6','1','9',53),(15382,4,11,65,'10','2','1',53),(15384,4,11,65,'10','2','2',53),(15385,4,11,65,'10','2','3',53),(15386,4,11,65,'10','2','4',53),(15387,4,11,65,'10','2','5',53),(15388,4,11,65,'10','2','6',53),(15389,4,11,65,'10','2','7',53),(15390,4,11,65,'10','2','8',53),(15391,4,11,65,'5','2','9',53),(15392,4,11,65,'10','3','1',53),(15393,4,11,65,'10','3','2',53),(15394,4,11,65,'10','3','3',53),(15395,4,11,65,'10','3','4',53),(15396,4,11,65,'10','3','5',53),(15397,4,11,65,'10','3','6',53),(15398,4,11,65,'10','3','7',53),(15399,4,11,65,'10','3','8',53),(15400,10,11,283,'10','1','1',49),(15401,4,11,65,'6','3','9',53),(15402,10,11,283,'10','1','2',49),(15403,10,11,283,'10','1','3',49),(15404,4,11,65,'10','4','1',53),(15405,4,11,65,'10','4','2',53),(15406,10,11,283,'10','1','4',49),(15407,4,11,65,'10','4','3',53),(15408,10,11,283,'10','1','5',49),(15409,4,11,65,'10','4','4',53),(15410,10,11,283,'10','1','6',49),(15411,4,11,65,'10','4','5',53),(15412,10,11,283,'1','1','7',49),(15413,4,11,65,'10','4','6',53),(15414,10,11,283,'M','1','8',49),(15415,4,11,65,'10','4','7',53),(15416,10,11,283,'M','1','9',49),(15417,4,11,65,'10','4','8',53),(15418,10,11,283,'10','2','1',49),(15419,4,11,65,'4','4','9',53),(15420,10,11,283,'10','2','2',49),(15421,10,11,283,'10','2','3',49),(15422,4,11,65,'10','5','1',53),(15423,4,11,65,'10','5','2',53),(15424,10,11,283,'10','2','4',49),(15425,4,11,65,'10','5','3',53),(15426,4,11,65,'10','5','4',53),(15427,10,11,283,'10','2','5',49),(15428,4,11,65,'10','5','5',53),(15429,10,11,283,'2','2','6',49),(15430,4,11,65,'10','5','6',53),(15431,10,11,283,'M','2','7',49),(15432,4,11,65,'10','5','7',53),(15433,10,11,283,'M','2','8',49),(15434,4,11,65,'10','5','8',53),(15435,10,11,283,'M','2','9',49),(15436,4,11,65,'5','5','9',53),(15437,4,11,65,'10','6','1',53),(15438,4,11,65,'10','6','2',53),(15439,4,11,65,'10','6','3',53),(15440,4,11,65,'10','6','4',53),(15441,4,11,65,'10','6','5',53),(15442,4,11,65,'10','6','6',53),(15443,4,11,65,'10','6','7',53),(15444,4,11,65,'10','6','8',53),(15445,4,11,65,'6','6','9',53),(15446,10,11,283,'10','3','1',49),(15447,10,11,283,'10','3','2',49),(15448,4,11,65,'10','7','1',53),(15449,10,11,283,'10','3','3',49),(15450,4,11,65,'10','7','2',53),(15451,4,11,65,'10','7','3',53),(15452,10,11,283,'10','3','4',49),(15453,4,11,65,'10','7','4',53),(15454,10,11,283,'10','3','5',49),(15455,4,11,65,'10','7','5',53),(15456,10,11,283,'10','3','6',49),(15457,4,11,65,'10','7','6',53),(15458,10,11,283,'1','3','7',49),(15459,4,11,65,'10','7','7',53),(15460,10,11,283,'M','3','8',49),(15461,4,11,65,'10','7','8',53),(15462,10,11,283,'M','3','9',49),(15463,10,11,283,'10','4','1',49),(15464,4,11,65,'6','7','9',53),(15465,10,11,283,'10','4','2',49),(15466,10,11,283,'10','4','3',49),(15467,10,11,283,'6','4','4',49),(15468,10,11,283,'M','4','5',49),(15469,10,11,283,'M','4','6',49),(15470,10,11,283,'M','4','7',49),(15471,10,11,283,'M','4','8',49),(15472,10,11,283,'M','4','9',49),(15473,10,11,283,'10','5','1',49),(15474,10,11,283,'10','5','2',49),(15475,10,11,283,'10','5','3',49),(15476,10,11,283,'5','5','4',49),(15477,10,11,283,'M','5','5',49),(15478,10,11,283,'M','5','6',49),(15479,10,11,283,'M','5','7',49),(15480,10,11,283,'M','5','8',49),(15481,10,11,283,'M','5','9',49),(15482,4,11,56,'10','1','1',53),(15483,4,11,56,'10','1','2',53),(15484,4,11,56,'10','1','3',53),(15485,4,11,56,'10','1','4',53),(15486,4,11,56,'10','1','5',53),(15487,10,11,283,'10','6','1',49),(15488,4,11,56,'10','1','6',53),(15489,10,11,283,'10','6','2',49),(15490,4,11,56,'10','1','7',53),(15491,10,11,283,'2','6','3',49),(15492,4,11,56,'6','1','8',53),(15493,10,11,283,'M','6','4',49),(15494,10,11,283,'M','6','5',49),(15495,4,11,56,'M','1','9',53),(15496,10,11,283,'M','6','6',49),(15497,4,11,56,'10','2','1',53),(15498,10,11,283,'M','6','7',49),(15499,4,11,56,'10','2','2',53),(15500,10,11,283,'M','6','8',49),(15501,4,11,56,'10','2','3',53),(15502,10,11,283,'M','6','9',49),(15503,4,11,56,'10','2','4',53),(15504,10,11,283,'10','7','1',49),(15505,4,11,56,'10','2','5',53),(15506,4,11,56,'10','2','6',53),(15507,10,11,283,'10','7','2',49),(15508,4,11,56,'10','2','7',53),(15509,10,11,283,'10','7','3',49),(15510,4,11,56,'10','2','8',53),(15511,10,11,283,'10','7','4',49),(15512,4,11,56,'4','2','9',53),(15513,10,11,283,'M','7','5',49),(15514,4,11,56,'10','3','1',53),(15515,10,11,283,'M','7','6',49),(15516,4,11,56,'10','3','2',53),(15517,4,11,56,'10','3','3',53),(15518,10,11,283,'M','7','7',49),(15519,4,11,56,'10','3','4',53),(15520,10,11,283,'M','7','8',49),(15521,10,11,283,'M','7','9',49),(15522,4,11,56,'10','3','5',53),(15523,4,11,56,'10','3','6',53),(15524,4,11,56,'10','3','7',53),(15525,4,11,56,'10','3','8',53),(15526,4,11,56,'7','3','9',53),(15527,4,11,56,'10','4','1',53),(15528,4,11,56,'10','4','2',53),(15529,4,11,56,'10','4','3',53),(15530,4,11,56,'10','4','4',53),(15531,4,11,56,'10','4','5',53),(15532,4,11,56,'10','4','6',53),(15533,4,11,56,'10','4','7',53),(15534,4,11,56,'10','4','8',53),(15535,4,11,56,'8','4','9',53),(15536,4,11,56,'10','5','1',53),(15537,4,11,56,'10','5','2',53),(15538,4,11,56,'10','5','3',53),(15539,4,11,56,'10','5','4',53),(15540,4,11,56,'10','5','5',53),(15541,4,11,56,'10','5','6',53),(15542,4,11,56,'10','5','7',53),(15543,4,11,56,'10','5','8',53),(15544,4,11,56,'8','5','9',53),(15545,10,11,284,'10','1','1',49),(15546,10,11,284,'10','1','2',49),(15547,10,11,284,'10','1','3',49),(15548,10,11,284,'10','1','4',49),(15549,10,11,284,'10','1','5',49),(15550,10,11,284,'8','1','6',49),(15551,4,11,56,'10','6','1',53),(15552,4,11,56,'10','6','2',53),(15553,10,11,284,'M','1','7',49),(15554,10,11,284,'M','1','8',49),(15555,4,11,56,'10','6','3',53),(15556,4,11,56,'10','6','4',53),(15557,10,11,284,'M','1','9',49),(15558,10,11,284,'10','2','1',49),(15559,4,11,56,'10','6','5',53),(15560,4,11,56,'10','6','6',53),(15561,10,11,284,'10','2','2',49),(15562,4,11,56,'10','6','7',53),(15563,10,11,284,'10','2','3',49),(15564,4,11,56,'10','6','8',53),(15565,10,11,284,'10','2','4',49),(15566,10,11,284,'10','2','5',49),(15567,10,11,284,'9','2','6',49),(15568,4,11,56,'7','6','9',53),(15569,10,11,284,'M','2','7',49),(15570,10,11,284,'M','2','8',49),(15571,10,11,284,'M','2','9',49),(15572,10,11,284,'10','3','1',49),(15573,10,11,284,'10','3','2',49),(15574,10,11,284,'10','3','3',49),(15577,4,11,56,'10','7','1',53),(15578,10,11,284,'9','3','4',49),(15579,4,11,56,'10','7','2',53),(15580,4,11,56,'10','7','3',53),(15581,4,11,56,'10','7','4',53),(15582,10,11,284,'M','3','5',49),(15583,4,11,56,'10','7','5',53),(15584,10,11,284,'M','3','6',49),(15585,4,11,56,'10','7','6',53),(15586,10,11,284,'M','3','7',49),(15587,4,11,56,'10','7','7',53),(15588,10,11,284,'M','3','8',49),(15589,4,11,56,'10','7','8',53),(15590,10,11,284,'M','3','9',49),(15591,10,11,284,'10','4','1',49),(15592,4,11,56,'7','7','9',53),(15593,10,11,284,'10','4','2',49),(15594,10,11,284,'10','4','3',49),(15595,10,11,284,'10','4','4',49),(15596,10,11,284,'M','4','5',49),(15597,10,11,284,'M','4','6',49),(15598,10,11,284,'M','4','7',49),(15599,10,11,284,'M','4','8',49),(15600,10,11,284,'M','4','9',49),(15601,10,11,284,'10','5','1',49),(15602,10,11,284,'10','5','2',49),(15603,10,11,284,'10','5','3',49),(15604,10,11,284,'4','5','4',49),(15605,10,11,284,'M','5','5',49),(15606,10,11,284,'M','5','6',49),(15607,10,11,284,'M','5','7',49),(15608,10,11,284,'M','5','8',49),(15609,10,11,284,'M','5','9',49),(15610,10,11,284,'10','6','1',49),(15611,10,11,284,'10','6','2',49),(15612,4,11,63,'10','1','1',53),(15613,10,11,284,'10','6','3',49),(15614,4,11,63,'10','1','2',53),(15615,10,11,284,'M','6','4',49),(15616,4,11,63,'10','1','3',53),(15617,10,11,284,'M','6','5',49),(15618,4,11,63,'10','1','4',53),(15619,10,11,284,'M','6','6',49),(15620,4,11,63,'10','1','5',53),(15621,10,11,284,'M','6','7',49),(15622,4,11,63,'10','1','6',53),(15623,10,11,284,'M','6','8',49),(15624,4,11,63,'10','1','7',53),(15625,10,11,284,'M','6','9',49),(15626,4,11,63,'10','1','8',53),(15627,10,11,284,'10','7','1',49),(15628,4,11,63,'4','1','9',53),(15629,10,11,284,'10','7','2',49),(15630,4,11,63,'10','2','1',53),(15632,4,11,63,'10','2','2',53),(15633,10,11,284,'3','7','4',49),(15634,4,11,63,'10','2','3',53),(15635,10,11,284,'M','7','5',49),(15636,4,11,63,'10','2','4',53),(15637,10,11,284,'M','7','6',49),(15638,4,11,63,'10','2','5',53),(15639,10,11,284,'M','7','7',49),(15640,4,11,63,'10','2','6',53),(15641,10,11,284,'M','7','8',49),(15642,4,11,63,'10','2','7',53),(15643,10,11,284,'M','7','9',49),(15644,4,11,63,'9','2','8',53),(15645,4,11,63,'M','2','9',53),(15646,4,11,63,'10','3','1',53),(15647,4,11,63,'10','3','2',53),(15648,4,11,63,'10','3','3',53),(15649,4,11,63,'10','3','4',53),(15650,4,11,63,'10','3','5',53),(15651,4,11,63,'10','3','6',53),(15652,4,11,63,'10','3','7',53),(15653,4,11,63,'10','3','8',53),(15654,4,11,63,'4','3','9',53),(15655,4,11,63,'10','4','1',53),(15656,4,11,63,'10','4','2',53),(15657,4,11,63,'10','4','3',53),(15658,4,11,63,'10','4','4',53),(15659,4,11,63,'10','4','5',53),(15660,4,11,63,'10','4','6',53),(15661,4,11,63,'10','4','7',53),(15662,4,11,63,'10','4','8',53),(15663,4,11,63,'3','4','9',53),(15664,10,11,284,'M','7','3',49),(15665,4,11,63,'10','5','1',53),(15666,4,11,63,'10','5','2',53),(15667,4,11,63,'10','5','3',53),(15668,4,11,63,'10','5','4',53),(15669,4,11,63,'10','5','5',53),(15670,4,11,63,'10','5','6',53),(15671,4,11,63,'10','5','7',53),(15672,4,11,63,'10','5','8',53),(15673,4,11,63,'4','5','9',53),(15674,4,11,63,'10','6','1',53),(15675,4,11,63,'10','6','2',53),(15676,4,11,63,'10','6','3',53),(15677,4,11,63,'10','6','4',53),(15679,4,11,63,'10','6','5',53),(15680,4,11,63,'10','6','6',53),(15681,4,11,63,'10','6','7',53),(15682,4,11,63,'10','6','8',53),(15683,4,11,63,'2','6','9',53),(15684,4,11,63,'10','7','1',53),(15685,4,11,63,'10','7','2',53),(15686,4,11,63,'10','7','3',53),(15687,4,11,63,'10','7','4',53),(15688,4,11,63,'10','7','5',53),(15689,4,11,63,'10','7','6',53),(15690,4,11,63,'10','7','7',53),(15691,4,11,63,'10','7','8',53),(15692,4,11,63,'6','7','9',53),(15693,10,11,285,'10','1','1',49),(15694,10,11,285,'5','1','2',49),(15695,10,11,285,'M','1','3',49),(15696,10,11,285,'M','1','4',49),(15697,10,11,285,'M','1','5',49),(15698,10,11,285,'M','1','6',49),(15699,10,11,285,'M','1','7',49),(15700,10,11,285,'M','1','8',49),(15701,10,11,285,'M','1','9',49),(15702,10,11,285,'10','2','1',49),(15703,10,11,285,'7','2','2',49),(15704,10,11,285,'M','2','3',49),(15705,10,11,285,'M','2','4',49),(15706,10,11,285,'M','2','5',49),(15707,10,11,285,'M','2','6',49),(15708,10,11,285,'M','2','7',49),(15709,10,11,285,'M','2','8',49),(15710,10,11,285,'M','2','9',49),(15711,10,11,285,'10','3','1',49),(15712,10,11,285,'10','3','2',49),(15713,10,11,285,'9','3','3',49),(15714,10,11,285,'M','3','4',49),(15715,10,11,285,'M','3','5',49),(15716,10,11,285,'M','3','6',49),(15717,10,11,285,'M','3','7',49),(15718,10,11,285,'M','3','8',49),(15719,10,11,285,'M','3','9',49),(15720,4,11,320,'10','1','1',53),(15721,4,11,320,'10','1','2',53),(15722,10,11,285,'10','4','1',49),(15723,4,11,320,'10','1','3',53),(15724,10,11,285,'10','4','2',49),(15725,4,11,320,'10','1','4',53),(15726,10,11,285,'8','4','3',49),(15727,4,11,320,'10','1','5',53),(15728,10,11,285,'M','4','4',49),(15729,4,11,320,'10','1','6',53),(15730,10,11,285,'M','4','5',49),(15731,4,11,320,'10','1','7',53),(15732,10,11,285,'M','4','6',49),(15733,4,11,320,'10','1','8',53),(15734,10,11,285,'M','4','7',49),(15735,4,11,320,'5','1','9',53),(15736,10,11,285,'M','4','8',49),(15737,4,11,320,'10','2','1',53),(15738,10,11,285,'M','4','9',49),(15739,4,11,320,'10','2','2',53),(15740,4,11,320,'10','2','3',53),(15741,10,11,285,'10','5','1',49),(15742,4,11,320,'10','2','4',53),(15743,10,11,285,'10','5','2',49),(15744,4,11,320,'10','2','5',53),(15746,4,11,320,'10','2','6',53),(15748,4,11,320,'10','2','7',53),(15749,4,11,320,'8','2','8',53),(15750,4,11,320,'M','2','9',53),(15751,4,11,320,'10','3','1',53),(15752,4,11,320,'10','3','2',53),(15753,4,11,320,'10','3','3',53),(15754,4,11,320,'10','3','4',53),(15755,4,11,320,'10','3','5',53),(15756,4,11,320,'10','3','6',53),(15757,4,11,320,'10','3','7',53),(15758,4,11,320,'10','3','8',53),(15759,4,11,320,'7','3','9',53),(15760,4,11,320,'10','4','1',53),(15761,4,11,320,'10','4','2',53),(15762,4,11,320,'10','4','3',53),(15763,4,11,320,'10','4','4',53),(15764,4,11,320,'10','4','5',53),(15765,4,11,320,'10','4','6',53),(15766,4,11,320,'10','4','7',53),(15767,4,11,320,'10','4','8',53),(15768,4,11,320,'4','4','9',53),(15769,4,11,320,'10','5','1',53),(15770,4,11,320,'10','5','2',53),(15771,4,11,320,'10','5','3',53),(15772,4,11,320,'10','5','4',53),(15774,4,11,320,'10','5','5',53),(15775,4,11,320,'10','5','6',53),(15776,4,11,320,'10','5','7',53),(15777,4,11,320,'6','5','8',53),(15778,10,11,285,'10','5','3',49),(15779,10,11,285,'10','5','4',49),(15780,10,11,285,'6','5','5',49),(15781,10,11,285,'M','5','6',49),(15782,10,11,285,'M','5','7',49),(15783,10,11,285,'M','5','8',49),(15784,10,11,285,'M','5','9',49),(15785,4,11,320,'m','5','9',53),(15786,10,11,285,'10','6','1',49),(15787,10,11,285,'10','6','2',49),(15788,10,11,285,'10','6','3',49),(15789,10,11,285,'10','6','4',49),(15790,4,11,320,'10','6','1',53),(15791,10,11,285,'2','6','5',49),(15792,4,11,320,'10','6','2',53),(15793,10,11,285,'M','6','6',49),(15794,4,11,320,'10','6','3',53),(15795,10,11,285,'M','6','7',49),(15796,4,11,320,'10','6','4',53),(15797,10,11,285,'M','6','8',49),(15798,4,11,320,'10','6','5',53),(15799,10,11,285,'M','6','9',49),(15800,4,11,320,'10','6','6',53),(15801,10,11,285,'10','7','1',49),(15802,4,11,320,'10','6','7',53),(15803,10,11,285,'10','7','2',49),(15804,4,11,320,'10','6','8',53),(15805,10,11,285,'10','7','3',49),(15806,10,11,285,'10','7','4',49),(15807,10,11,285,'2','7','5',49),(15808,10,11,285,'M','7','6',49),(15809,10,11,285,'M','7','7',49),(15810,10,11,285,'M','7','8',49),(15811,10,11,285,'M','7','9',49),(15812,4,11,320,'5','6','9',53),(15813,4,11,320,'10','7','1',53),(15814,4,11,320,'10','7','2',53),(15815,4,11,320,'10','7','3',53),(15816,4,11,320,'10','7','4',53),(15817,4,11,320,'10','7','5',53),(15818,4,11,320,'10','7','6',53),(15819,4,11,320,'10','7','7',53),(15820,4,11,320,'9','7','8',53),(15821,4,11,320,'M','7','9',53),(15822,4,11,321,'10','1','2',53),(15823,4,11,321,'10','1','1',53),(15824,4,11,321,'10','1','3',53),(15825,4,11,321,'10','1','4',53),(15826,4,11,321,'10','1','5',53),(15827,4,11,321,'10','1','6',53),(15828,4,11,321,'10','1','7',53),(15829,4,11,321,'10','1','8',53),(15830,4,11,321,'3','1','9',53),(15831,4,11,321,'10','2','1',53),(15832,4,11,321,'10','2','2',53),(15833,4,11,321,'10','2','3',53),(15834,4,11,321,'10','2','4',53),(15835,4,11,321,'10','2','5',53),(15836,4,11,321,'10','2','6',53),(15837,4,11,321,'10','2','7',53),(15838,4,11,321,'10','2','8',53),(15839,4,11,321,'3','2','9',53),(15840,4,11,321,'10','3','1',53),(15841,4,11,321,'10','3','2',53),(15842,4,11,321,'10','3','3',53),(15843,4,11,321,'10','3','4',53),(15844,4,11,321,'10','3','5',53),(15845,4,11,321,'10','3','6',53),(15846,4,11,321,'10','3','7',53),(15847,4,11,321,'1','3','8',53),(15848,4,11,321,'M','3','9',53),(15849,4,11,321,'10','4','1',53),(15850,4,11,321,'10','4','2',53),(15851,4,11,321,'10','4','3',53),(15852,4,11,321,'10','4','4',53),(15853,4,11,321,'10','4','5',53),(15854,4,11,321,'10','4','6',53),(15855,4,11,321,'10','4','7',53),(15856,4,11,321,'10','4','8',53),(15857,4,11,321,'5','4','9',53),(15858,4,11,321,'10','5','1',53),(15859,4,11,321,'10','5','2',53),(15860,4,11,321,'10','5','3',53),(15861,4,11,321,'10','5','4',53),(15862,4,11,321,'10','5','5',53),(15863,4,11,321,'10','5','6',53),(15864,4,11,321,'10','5','7',53),(15865,4,11,321,'10','5','8',53),(15866,4,11,321,'7','5','9',53),(15867,4,11,321,'10','6','1',53),(15868,4,11,321,'10','6','2',53),(15869,4,11,321,'10','6','3',53),(15870,4,11,321,'10','6','4',53),(15871,4,11,321,'10','6','5',53),(15872,4,11,321,'10','6','6',53),(15873,4,11,321,'10','6','7',53),(15874,4,11,321,'10','6','8',53),(15875,4,11,321,'M','6','9',53),(15876,4,11,321,'10','7','1',53),(15877,4,11,321,'10','7','2',53),(15878,4,11,321,'10','7','3',53),(15879,4,11,321,'10','7','4',53),(15880,4,11,321,'10','7','5',53),(15881,4,11,321,'10','7','6',53),(15882,4,11,321,'10','7','7',53),(15883,4,11,321,'10','7','8',53),(15884,4,11,321,'2','7','9',53),(15885,4,11,54,'10','1','1',53),(15886,4,11,54,'10','1','2',53),(15887,4,11,54,'10','1','3',53),(15888,4,11,54,'10','1','4',53),(15889,4,11,54,'10','1','5',53),(15890,4,11,54,'10','1','6',53),(15891,4,11,54,'10','1','7',53),(15892,4,11,54,'6','1','8',53),(15893,4,11,54,'M','1','9',53),(15894,4,11,54,'10','2','1',53),(15895,4,11,54,'10','2','2',53),(15896,4,11,54,'10','2','3',53),(15897,4,11,54,'10','2','4',53),(15898,4,11,54,'10','2','5',53),(15899,4,11,54,'10','2','6',53),(15900,4,11,54,'10','2','7',53),(15901,4,11,54,'7','2','8',53),(15902,4,11,54,'M','2','9',53),(15903,4,11,54,'10','3','1',53),(15904,4,11,54,'10','3','2',53),(15905,4,11,54,'10','3','3',53),(15906,4,11,54,'10','3','4',53),(15907,4,11,54,'10','3','5',53),(15908,4,11,54,'10','3','6',53),(15909,4,11,54,'10','3','7',53),(15910,4,11,54,'10','3','8',53),(15911,4,11,54,'2','3','9',53),(15912,4,11,54,'10','4','1',53),(15913,4,11,54,'10','4','2',53),(15914,4,11,54,'10','4','3',53),(15915,4,11,54,'10','4','4',53),(15916,4,11,54,'10','4','5',53),(15917,4,11,54,'10','4','6',53),(15918,4,11,54,'10','4','7',53),(15919,4,11,54,'10','4','8',53),(15920,4,11,54,'3','4','9',53),(15921,4,11,54,'10','5','2',53),(15922,4,11,54,'10','5','1',53),(15923,4,11,54,'10','5','3',53),(15924,4,11,54,'10','5','4',53),(15925,4,11,54,'10','5','5',53),(15926,4,11,54,'10','5','6',53),(15927,4,11,54,'10','5','7',53),(15928,4,11,54,'10','5','8',53),(15929,4,11,54,'2','5','9',53),(15930,4,11,54,'10','6','1',53),(15931,4,11,54,'10','6','2',53),(15932,4,11,54,'10','6','3',53),(15933,4,11,54,'10','6','4',53),(15934,4,11,54,'10','6','5',53),(15935,4,11,54,'10','6','6',53),(15936,4,11,54,'10','6','7',53),(15937,4,11,54,'10','6','8',53),(15938,4,11,54,'3','6','9',53),(15939,4,11,54,'10','7','1',53),(15940,4,11,54,'10','7','2',53),(15941,4,11,54,'10','7','3',53),(15942,4,11,54,'10','7','4',53),(15943,4,11,54,'10','7','5',53),(15944,4,11,54,'10','7','6',53),(15945,4,11,54,'10','7','7',53),(15946,4,11,54,'10','7','8',53),(15947,4,11,54,'5','7','9',53),(15948,4,11,55,'10','1','1',53),(15949,4,11,55,'10','1','2',53),(15950,4,11,55,'10','1','3',53),(15951,4,11,55,'10','1','4',53),(15952,4,11,55,'10','1','5',53),(15953,4,11,55,'10','1','6',53),(15954,4,11,55,'10','1','7',53),(15955,4,11,55,'10','1','8',53),(15956,4,11,55,'M','1','9',53),(15957,4,11,55,'10','2','1',53),(15958,4,11,55,'10','2','2',53),(15959,4,11,55,'10','2','3',53),(15960,4,11,55,'10','2','4',53),(15961,4,11,55,'10','2','5',53),(15962,4,11,55,'10','2','6',53),(15963,4,11,55,'10','2','7',53),(15964,4,11,55,'10','2','8',53),(15965,4,11,55,'6','2','9',53),(15966,4,11,55,'10','3','1',53),(15967,4,11,55,'10','3','2',53),(15968,4,11,55,'10','3','3',53),(15969,4,11,55,'10','3','4',53),(15970,4,11,55,'10','3','5',53),(15971,4,11,55,'10','3','6',53),(15972,4,11,55,'10','3','7',53),(15973,4,11,55,'10','3','8',53),(15974,4,11,55,'M','3','9',53),(15975,4,11,55,'10','4','1',53),(15976,4,11,55,'10','4','2',53),(15977,4,11,55,'10','4','3',53),(15978,4,11,55,'10','4','4',53),(15979,4,11,55,'10','4','5',53),(15980,4,11,55,'10','4','6',53),(15981,4,11,55,'10','4','7',53),(15982,4,11,55,'9','4','8',53),(15983,4,11,55,'M','4','9',53),(15984,4,11,55,'10','5','1',53),(15985,4,11,55,'10','5','2',53),(15986,4,11,55,'10','5','3',53),(15987,4,11,55,'10','5','4',53),(15988,4,11,55,'10','5','5',53),(15989,4,11,55,'10','5','6',53),(15990,4,11,55,'10','5','7',53),(15991,4,11,55,'9','5','8',53),(15992,4,11,55,'M','5','9',53),(15993,4,11,55,'10','6','1',53),(15994,4,11,55,'10','6','2',53),(15995,4,11,55,'10','6','3',53),(15996,4,11,55,'10','6','4',53),(15997,4,11,55,'10','6','5',53),(15998,4,11,55,'10','6','6',53),(15999,4,11,55,'10','6','7',53),(16000,4,11,55,'10','6','8',53),(16001,4,11,55,'4','6','9',53),(16002,4,11,55,'10','7','1',53),(16003,4,11,55,'10','7','2',53),(16004,4,11,55,'10','7','3',53),(16005,4,11,55,'10','7','4',53),(16006,4,11,55,'10','7','5',53),(16007,4,11,55,'10','7','6',53),(16008,4,11,55,'10','7','7',53),(16009,4,11,55,'9','7','8',53),(16010,4,11,55,'M','7','9',53),(16011,4,11,57,'10','1','2',53),(16012,4,11,57,'10','1','1',53),(16013,4,11,57,'10','1','3',53),(16014,4,11,57,'10','1','4',53),(16015,4,11,57,'10','1','5',53),(16016,4,11,57,'10','1','6',53),(16017,4,11,57,'10','1','7',53),(16018,4,11,57,'10','1','8',53),(16019,4,11,57,'4','1','9',53),(16020,4,11,57,'10','2','1',53),(16022,4,11,57,'10','2','3',53),(16023,4,11,57,'10','2','4',53),(16024,4,11,57,'10','2','5',53),(16025,4,11,57,'10','2','6',53),(16026,4,11,57,'10','2','7',53),(16027,4,11,57,'10','2','8',53),(16028,4,11,57,'10','2','2',53),(16029,4,11,57,'M','2','9',53),(16030,4,11,57,'10','3','1',53),(16031,4,11,57,'10','3','2',53),(16032,4,11,57,'10','3','3',53),(16033,4,11,57,'10','3','4',53),(16034,4,11,57,'10','3','5',53),(16035,4,11,57,'10','3','6',53),(16036,4,11,57,'10','3','7',53),(16037,4,11,57,'10','3','8',53),(16038,4,11,57,'5','3','9',53),(16039,4,11,57,'10','4','1',53),(16040,4,11,57,'10','4','2',53),(16041,4,11,57,'10','4','3',53),(16042,4,11,57,'10','4','4',53),(16043,4,11,57,'10','4','5',53),(16044,4,11,57,'10','4','6',53),(16045,4,11,57,'10','4','7',53),(16046,4,11,57,'10','4','8',53),(16047,4,11,57,'2','4','9',53),(16048,4,11,57,'10','5','1',53),(16049,4,11,57,'10','5','2',53),(16050,4,11,57,'10','5','3',53),(16051,4,11,57,'10','5','4',53),(16052,4,11,57,'10','5','5',53),(16053,4,11,57,'10','5','6',53),(16054,4,11,57,'10','5','7',53),(16055,4,11,57,'10','5','8',53),(16056,4,11,57,'1','5','9',53),(16057,4,11,57,'10','6','1',53),(16058,4,11,57,'10','6','2',53),(16059,4,11,57,'10','6','3',53),(16060,4,11,57,'10','6','4',53),(16061,4,11,57,'10','6','5',53),(16062,4,11,57,'10','6','6',53),(16063,4,11,57,'10','6','7',53),(16064,4,11,57,'10','6','8',53),(16065,4,11,57,'2','6','9',53),(16066,4,11,57,'10','7','1',53),(16067,4,11,57,'10','7','2',53),(16068,4,11,57,'10','7','3',53),(16069,4,11,57,'10','7','4',53),(16070,4,11,57,'10','7','5',53),(16071,4,11,57,'10','7','6',53),(16072,4,11,57,'10','7','7',53),(16073,4,11,57,'1','7','8',53),(16074,4,11,57,'M','7','9',53),(16075,4,11,322,'10','1','1',53),(16076,4,11,322,'10','1','2',53),(16077,4,11,322,'10','1','3',53),(16078,4,11,322,'10','1','4',53),(16079,4,11,322,'10','1','5',53),(16080,4,11,322,'10','1','6',53),(16081,4,11,322,'10','1','7',53),(16082,4,11,322,'9','1','8',53),(16083,4,11,322,'M','1','9',53),(16084,4,11,322,'10','2','1',53),(16085,4,11,322,'10','2','2',53),(16086,4,11,322,'10','2','3',53),(16087,4,11,322,'10','2','4',53),(16088,4,11,322,'10','2','5',53),(16089,4,11,322,'10','2','6',53),(16090,4,11,322,'10','2','7',53),(16091,4,11,322,'7','2','8',53),(16092,4,11,322,'M','2','9',53),(16093,4,11,322,'10','3','1',53),(16094,4,11,322,'10','3','2',53),(16095,4,11,322,'10','3','3',53),(16096,4,11,322,'10','3','4',53),(16097,4,11,322,'10','3','5',53),(16098,4,11,322,'10','3','6',53),(16099,4,11,322,'10','3','7',53),(16100,4,11,322,'10','3','8',53),(16101,4,11,322,'3','3','9',53),(16102,4,11,322,'10','4','1',53),(16103,4,11,322,'10','4','2',53),(16104,4,11,322,'10','4','3',53),(16105,4,11,322,'10','4','4',53),(16106,4,11,322,'10','4','5',53),(16107,4,11,322,'10','4','6',53),(16108,4,11,322,'10','4','7',53),(16109,4,11,322,'10','4','8',53),(16110,4,11,322,'2','4','9',53),(16111,4,11,322,'10','5','1',53),(16112,4,11,322,'10','5','2',53),(16113,4,11,322,'10','5','3',53),(16114,4,11,322,'10','5','4',53),(16115,4,11,322,'10','5','5',53),(16116,4,11,322,'10','5','6',53),(16117,4,11,322,'10','5','7',53),(16118,4,11,322,'10','5','8',53),(16119,4,11,322,'2','5','9',53),(16120,4,11,322,'10','6','1',53),(16121,4,11,322,'10','6','2',53),(16122,4,11,322,'10','6','3',53),(16123,4,11,322,'10','6','4',53),(16124,4,11,322,'10','6','5',53),(16125,4,11,322,'10','6','6',53),(16126,4,11,322,'10','6','7',53),(16127,4,11,322,'10','6','8',53),(16128,4,11,322,'M','6','9',53),(16129,4,11,322,'10','7','1',53),(16130,4,11,322,'10','7','2',53),(16131,4,11,322,'10','7','3',53),(16132,4,11,322,'10','7','4',53),(16133,4,11,322,'10','7','5',53),(16134,4,11,322,'10','7','6',53),(16135,4,11,322,'10','7','7',53),(16136,4,11,322,'10','7','8',53),(16137,4,11,322,'2','7','9',53),(16138,4,11,66,'10','1','1',53),(16139,4,11,66,'10','1','2',53),(16140,4,11,66,'10','1','3',53),(16141,4,11,66,'10','1','4',53),(16142,4,11,66,'10','1','5',53),(16143,4,11,66,'10','1','6',53),(16144,4,11,66,'10','1','7',53),(16145,4,11,66,'9','1','8',53),(16146,4,11,66,'M','1','9',53),(16147,4,11,66,'10','2','1',53),(16148,4,11,66,'10','2','2',53),(16149,4,11,66,'10','2','3',53),(16150,4,11,66,'10','2','4',53),(16151,4,11,66,'10','2','5',53),(16152,4,11,66,'10','2','6',53),(16153,4,11,66,'10','2','7',53),(16154,4,11,66,'10','2','8',53),(16155,4,11,66,'1','2','9',53),(16156,4,11,66,'10','3','1',53),(16157,4,11,66,'10','3','2',53),(16158,4,11,66,'10','3','3',53),(16159,4,11,66,'10','3','4',53),(16160,4,11,66,'10','3','5',53),(16161,4,11,66,'10','3','6',53),(16162,4,11,66,'10','3','7',53),(16163,4,11,66,'10','3','8',53),(16164,4,11,66,'1','3','9',53),(16165,4,11,66,'10','4','1',53),(16166,4,11,66,'10','4','2',53),(16167,4,11,66,'10','4','3',53),(16168,4,11,66,'10','4','4',53),(16169,4,11,66,'10','4','5',53),(16170,4,11,66,'10','4','6',53),(16171,4,11,66,'10','4','7',53),(16172,4,11,66,'8','4','8',53),(16173,4,11,66,'M','4','9',53),(16174,4,11,66,'10','5','1',53),(16175,4,11,66,'10','5','2',53),(16176,4,11,66,'10','5','3',53),(16177,4,11,66,'10','5','4',53),(16178,4,11,66,'10','5','5',53),(16179,4,11,66,'10','5','6',53),(16180,4,11,66,'10','5','7',53),(16181,4,11,66,'10','5','8',53),(16182,4,11,66,'2','5','9',53),(16183,4,11,66,'10','6','1',53),(16184,4,11,66,'10','6','2',53),(16185,4,11,66,'10','6','3',53),(16186,4,11,66,'10','6','4',53),(16187,4,11,66,'10','6','5',53),(16188,4,11,66,'10','6','6',53),(16189,4,11,66,'10','6','7',53),(16190,4,11,66,'10','6','8',53),(16191,4,11,66,'2','6','9',53),(16192,4,11,66,'10','7','1',53),(16193,4,11,66,'10','7','2',53),(16194,4,11,66,'10','7','3',53),(16195,4,11,66,'10','7','4',53),(16196,4,11,66,'10','7','5',53),(16197,4,11,66,'10','7','6',53),(16198,4,11,66,'10','7','7',53),(16199,4,11,66,'10','7','8',53),(16200,4,11,66,'1','7','9',53),(16201,4,11,323,'10','1','1',53),(16202,4,11,323,'10','1','2',53),(16203,4,11,323,'10','1','3',53),(16204,4,11,323,'10','1','4',53),(16205,4,11,323,'10','1','5',53),(16206,4,11,323,'10','1','6',53),(16207,4,11,323,'10','1','7',53),(16208,4,11,323,'3','1','8',53),(16209,4,11,323,'M','1','9',53),(16210,4,11,323,'10','2','1',53),(16211,4,11,323,'10','2','2',53),(16212,4,11,323,'10','2','3',53),(16213,4,11,323,'10','2','4',53),(16214,4,11,323,'10','2','5',53),(16215,4,11,323,'10','2','6',53),(16216,4,11,323,'10','2','7',53),(16217,4,11,323,'10','2','8',53),(16218,4,11,323,'6','2','9',53),(16219,4,11,323,'10','3','1',53),(16220,4,11,323,'10','3','2',53),(16221,4,11,323,'10','3','3',53),(16222,4,11,323,'10','3','4',53),(16223,4,11,323,'10','3','5',53),(16224,4,11,323,'10','3','6',53),(16225,4,11,323,'10','3','7',53),(16226,4,11,323,'6','3','8',53),(16227,4,11,323,'M','3','9',53),(16228,4,11,323,'10','4','1',53),(16229,4,11,323,'10','4','2',53),(16230,4,11,323,'10','4','3',53),(16231,4,11,323,'10','4','4',53),(16232,4,11,323,'10','4','5',53),(16233,4,11,323,'10','4','6',53),(16234,4,11,323,'10','4','7',53),(16235,4,11,323,'10','4','8',53),(16236,4,11,323,'3','4','9',53),(16237,4,11,323,'10','5','1',53),(16238,4,11,323,'10','5','2',53),(16239,4,11,323,'10','5','3',53),(16240,4,11,323,'10','5','4',53),(16241,4,11,323,'10','5','5',53),(16242,4,11,323,'10','5','6',53),(16243,4,11,323,'10','5','7',53),(16244,4,11,323,'9','5','8',53),(16245,4,11,323,'M','5','9',53),(16246,4,11,323,'10','6','1',53),(16247,4,11,323,'10','6','2',53),(16248,4,11,323,'10','6','3',53),(16249,4,11,323,'10','6','4',53),(16250,4,11,323,'10','6','5',53),(16251,4,11,323,'10','6','6',53),(16252,4,11,323,'10','6','7',53),(16253,4,11,323,'10','6','8',53),(16254,4,11,323,'1','6','9',53),(16255,4,11,323,'10','7','1',53),(16256,4,11,323,'10','7','2',53),(16257,4,11,323,'10','7','3',53),(16258,4,11,323,'10','7','4',53),(16259,4,11,323,'10','7','5',53),(16260,4,11,323,'10','7','6',53),(16261,4,11,323,'10','7','7',53),(16262,4,11,323,'10','7','8',53),(16263,4,11,323,'2','7','9',53),(16264,4,11,68,'10','1','1',53),(16265,4,11,68,'10','1','2',53),(16266,4,11,68,'10','1','3',53),(16267,4,11,68,'10','1','4',53),(16268,4,11,68,'10','1','5',53),(16269,4,11,68,'10','1','6',53),(16270,4,11,68,'10','1','7',53),(16271,4,11,68,'10','1','8',53),(16272,4,11,68,'1','1','9',53),(16273,4,11,68,'10','2','1',53),(16274,4,11,68,'10','2','2',53),(16275,4,11,68,'10','2','3',53),(16276,4,11,68,'10','2','4',53),(16277,4,11,68,'10','2','5',53),(16278,4,11,68,'10','2','6',53),(16279,4,11,68,'10','2','7',53),(16280,4,11,68,'10','2','8',53),(16281,4,11,68,'2','2','9',53),(16282,4,11,68,'10','3','1',53),(16283,4,11,68,'10','3','2',53),(16284,4,11,68,'10','3','3',53),(16285,4,11,68,'10','3','4',53),(16286,4,11,68,'10','3','5',53),(16287,4,11,68,'10','3','6',53),(16288,4,11,68,'10','3','7',53),(16289,4,11,68,'8','3','8',53),(16290,4,11,68,'M','3','9',53),(16291,4,11,68,'10','4','1',53),(16292,4,11,68,'10','4','2',53),(16293,4,11,68,'10','4','3',53),(16294,4,11,68,'10','4','4',53),(16295,4,11,68,'10','4','5',53),(16296,4,11,68,'10','4','6',53),(16297,4,11,68,'10','4','7',53),(16298,4,11,68,'1','4','8',53),(16299,4,11,68,'M','4','9',53),(16300,4,11,68,'10','5','1',53),(16301,4,11,68,'10','5','2',53),(16302,4,11,68,'10','5','3',53),(16303,4,11,68,'10','5','4',53),(16304,4,11,68,'10','5','5',53),(16305,4,11,68,'10','5','6',53),(16306,4,11,68,'10','5','7',53),(16307,4,11,68,'9','5','8',53),(16308,4,11,68,'M','5','9',53),(16309,4,11,68,'10','6','1',53),(16310,4,11,68,'10','6','2',53),(16311,4,11,68,'10','6','3',53),(16312,4,11,68,'10','6','4',53),(16313,4,11,68,'10','6','5',53),(16314,4,11,68,'10','6','6',53),(16315,4,11,68,'10','6','7',53),(16316,4,11,68,'10','6','8',53),(16317,4,11,68,'3','6','9',53),(16318,4,11,68,'10','7','1',53),(16319,4,11,68,'10','7','2',53),(16320,4,11,68,'10','7','3',53),(16321,4,11,68,'10','7','4',53),(16322,4,11,68,'10','7','5',53),(16323,4,11,68,'10','7','6',53),(16324,4,11,68,'10','7','7',53),(16325,4,11,68,'10','7','8',53),(16326,4,11,68,'4','7','9',53),(16327,4,11,324,'10','1','1',53),(16328,4,11,324,'10','1','2',53),(16329,4,11,324,'10','1','3',53),(16330,4,11,324,'10','1','4',53),(16331,4,11,324,'10','1','5',53),(16332,4,11,324,'10','1','6',53),(16333,4,11,324,'10','1','7',53),(16334,4,11,324,'9','1','8',53),(16335,4,11,324,'M','1','9',53),(16336,4,11,324,'10','2','1',53),(16337,4,11,324,'10','2','2',53),(16338,4,11,324,'10','2','3',53),(16339,4,11,324,'10','2','4',53),(16340,4,11,324,'10','2','5',53),(16341,4,11,324,'10','2','6',53),(16342,4,11,324,'7','2','7',53),(16343,4,11,324,'M','2','8',53),(16344,4,11,324,'M','2','9',53),(16345,4,11,324,'10','3','1',53),(16346,4,11,324,'10','3','2',53),(16347,4,11,324,'10','3','3',53),(16348,4,11,324,'10','3','4',53),(16349,4,11,324,'10','3','5',53),(16350,4,11,324,'10','3','6',53),(16351,4,11,324,'10','3','7',53),(16352,4,11,324,'9','3','8',53),(16353,4,11,324,'M','3','9',53),(16354,4,11,324,'10','4','1',53),(16355,4,11,324,'10','4','2',53),(16356,4,11,324,'10','4','3',53),(16357,4,11,324,'10','4','4',53),(16358,4,11,324,'10','4','5',53),(16359,4,11,324,'10','4','6',53),(16360,4,11,324,'10','4','7',53),(16361,4,11,324,'9','4','8',53),(16362,4,11,324,'M','4','9',53),(16363,4,11,324,'10','5','1',53),(16364,4,11,324,'10','5','2',53),(16365,4,11,324,'10','5','3',53),(16366,4,11,324,'10','5','4',53),(16367,4,11,324,'10','5','5',53),(16368,4,11,324,'10','5','6',53),(16369,4,11,324,'10','5','7',53),(16370,4,11,324,'10','5','8',53),(16371,4,11,324,'3','5','9',53),(16372,4,11,324,'10','6','1',53),(16373,4,11,324,'10','6','2',53),(16374,4,11,324,'10','6','3',53),(16375,4,11,324,'10','6','4',53),(16376,4,11,324,'10','6','5',53),(16377,4,11,324,'10','6','6',53),(16378,4,11,324,'10','6','7',53),(16379,4,11,324,'10','6','8',53),(16380,4,11,324,'3','6','9',53),(16381,4,11,324,'10','7','1',53),(16382,4,11,324,'10','7','2',53),(16383,4,11,324,'10','7','3',53),(16384,4,11,324,'10','7','4',53),(16385,4,11,324,'10','7','5',53),(16387,4,11,324,'10','7','6',53),(16388,4,11,324,'10','7','7',53),(16389,4,11,324,'10','7','8',53),(16390,4,11,324,'2','7','9',53),(16391,4,11,332,'10','1','2',53),(16392,4,11,332,'10','1','1',53),(16393,4,11,332,'10','1','3',53),(16394,4,11,332,'10','1','4',53),(16395,4,11,332,'10','1','5',53),(16396,4,11,332,'10','1','6',53),(16397,4,11,332,'10','1','7',53),(16398,4,11,332,'2','1','8',53),(16399,4,11,332,'M','1','9',53),(16400,4,11,332,'10','2','1',53),(16401,4,11,332,'10','2','2',53),(16402,4,11,332,'10','2','3',53),(16403,4,11,332,'10','2','4',53),(16404,4,11,332,'10','2','5',53),(16405,4,11,332,'10','2','6',53),(16406,4,11,332,'10','2','7',53),(16407,4,11,332,'7','2','8',53),(16408,4,11,332,'M','2','9',53),(16409,4,11,332,'10','3','1',53),(16410,4,11,332,'10','3','2',53),(16411,4,11,332,'10','3','3',53),(16412,4,11,332,'10','3','4',53),(16413,4,11,332,'10','3','5',53),(16414,4,11,332,'10','3','6',53),(16415,4,11,332,'10','3','7',53),(16416,4,11,332,'10','3','8',53),(16417,4,11,332,'1','3','9',53),(16418,4,11,332,'10','4','1',53),(16419,4,11,332,'10','4','2',53),(16420,4,11,332,'10','4','3',53),(16421,4,11,332,'10','4','4',53),(16422,4,11,332,'10','4','5',53),(16423,4,11,332,'10','4','6',53),(16424,4,11,332,'10','4','7',53),(16425,4,11,332,'10','4','8',53),(16426,4,11,332,'M','4','9',53),(16427,4,11,332,'10','5','1',53),(16428,4,11,332,'10','5','2',53),(16429,4,11,332,'10','5','3',53),(16430,4,11,332,'10','5','4',53),(16431,4,11,332,'10','5','5',53),(16432,4,11,332,'10','5','6',53),(16433,4,11,332,'10','5','7',53),(16434,4,11,332,'7','5','8',53),(16435,4,11,332,'M','5','9',53),(16436,4,11,332,'10','6','1',53),(16437,4,11,332,'10','6','2',53),(16438,4,11,332,'10','6','3',53),(16439,4,11,332,'10','6','4',53),(16440,4,11,332,'10','6','5',53),(16441,4,11,332,'10','6','6',53),(16442,4,11,332,'10','6','7',53),(16443,4,11,332,'8','6','8',53),(16444,4,11,332,'M','6','9',53),(16445,4,11,332,'10','7','1',53),(16446,4,11,332,'10','7','2',53),(16447,4,11,332,'10','7','3',53),(16448,4,11,332,'10','7','4',53),(16449,4,11,332,'10','7','5',53),(16450,4,11,332,'10','7','6',53),(16451,4,11,332,'10','7','7',53),(16452,4,11,332,'3','7','8',53),(16453,4,11,332,'M','7','9',53),(16454,4,11,335,'10','1','1',53),(16455,4,11,335,'10','1','2',53),(16456,4,11,335,'10','1','3',53),(16457,4,11,335,'10','1','4',53),(16458,4,11,335,'10','1','5',53),(16459,4,11,335,'8','1','6',53),(16460,4,11,335,'M','1','7',53),(16461,4,11,335,'M','1','8',53),(16462,4,11,335,'M','1','9',53),(16463,4,11,335,'10','2','1',53),(16464,4,11,335,'10','2','2',53),(16465,4,11,335,'10','2','3',53),(16466,4,11,335,'10','2','4',53),(16467,4,11,335,'10','2','5',53),(16468,4,11,335,'10','2','6',53),(16469,4,11,335,'10','2','7',53),(16470,4,11,335,'2','2','8',53),(16471,4,11,335,'M','2','9',53),(16472,4,11,335,'10','3','1',53),(16473,4,11,335,'10','3','2',53),(16474,4,11,335,'10','3','3',53),(16475,4,11,335,'10','3','4',53),(16476,4,11,335,'10','3','5',53),(16477,4,11,335,'10','3','6',53),(16478,4,11,335,'10','3','7',53),(16479,4,11,335,'3','3','8',53),(16480,4,11,335,'M','3','9',53),(16481,4,11,335,'10','4','1',53),(16482,4,11,335,'10','4','2',53),(16483,4,11,335,'10','4','3',53),(16484,4,11,335,'10','4','4',53),(16485,4,11,335,'10','4','5',53),(16486,4,11,335,'10','4','6',53),(16487,4,11,335,'10','4','7',53),(16488,4,11,335,'10','4','8',53),(16489,4,11,335,'3','4','9',53),(16490,4,11,335,'10','5','1',53),(16491,4,11,335,'10','5','2',53),(16493,4,11,335,'10','5','4',53),(16494,4,11,335,'10','5','5',53),(16495,4,11,335,'10','5','6',53),(16496,4,11,335,'10','5','7',53),(16497,4,11,335,'10','5','8',53),(16498,4,11,335,'1','5','9',53),(16499,4,11,335,'10','5','3',53),(16500,4,11,335,'10','6','1',53),(16501,4,11,335,'10','6','2',53),(16502,4,11,335,'10','6','3',53),(16503,4,11,335,'10','6','4',53),(16504,4,11,335,'10','6','5',53),(16505,4,11,335,'10','6','6',53),(16506,4,11,335,'10','6','7',53),(16507,4,11,335,'10','6','8',53),(16508,4,11,335,'3','6','9',53),(16509,4,11,335,'10','7','1',53),(16510,4,11,335,'10','7','2',53),(16511,4,11,335,'10','7','3',53),(16512,4,11,335,'10','7','4',53),(16513,4,11,335,'10','7','5',53),(16514,4,11,335,'10','7','6',53),(16515,4,11,335,'10','7','7',53),(16516,4,11,335,'10','7','8',53),(16517,4,11,335,'4','7','9',53),(16518,4,11,340,'10','1','1',53),(16519,4,11,340,'10','1','2',53),(16520,4,11,340,'10','1','3',53),(16521,4,11,340,'10','1','4',53),(16522,4,11,340,'10','1','5',53),(16523,4,11,340,'10','1','6',53),(16524,4,11,340,'10','1','7',53),(16525,4,11,340,'8','1','8',53),(16526,4,11,340,'M','1','9',53),(16527,4,11,340,'10','2','1',53),(16528,4,11,340,'10','2','2',53),(16529,4,11,340,'10','2','3',53),(16530,4,11,340,'10','2','4',53),(16531,4,11,340,'10','2','5',53),(16532,4,11,340,'10','2','6',53),(16533,4,11,340,'10','2','7',53),(16534,4,11,340,'3','2','8',53),(16535,4,11,340,'M','2','9',53),(16536,4,11,340,'10','3','1',53),(16537,4,11,340,'10','3','2',53),(16538,4,11,340,'10','3','3',53),(16539,4,11,340,'10','3','4',53),(16540,4,11,340,'10','3','5',53),(16541,4,11,340,'10','3','6',53),(16542,4,11,340,'10','3','7',53),(16543,4,11,340,'8','3','8',53),(16544,4,11,340,'M','3','9',53),(16545,4,11,340,'10','4','1',53),(16546,4,11,340,'10','4','2',53),(16547,4,11,340,'10','4','3',53),(16548,4,11,340,'10','4','4',53),(16549,4,11,340,'10','4','5',53),(16550,4,11,340,'10','4','6',53),(16551,4,11,340,'10','4','7',53),(16552,4,11,340,'2','4','8',53),(16553,4,11,340,'M','4','9',53),(16554,4,11,340,'10','5','1',53),(16555,4,11,340,'10','5','2',53),(16556,4,11,340,'10','5','3',53),(16557,4,11,340,'10','5','4',53),(16558,4,11,340,'10','5','5',53),(16559,4,11,340,'10','5','6',53),(16560,4,11,340,'10','5','7',53),(16561,4,11,340,'8','5','8',53),(16562,4,11,340,'M','5','9',53),(16563,4,11,340,'10','6','1',53),(16564,4,11,340,'10','6','2',53),(16565,4,11,340,'10','6','3',53),(16566,4,11,340,'10','6','4',53),(16567,4,11,340,'10','6','5',53),(16568,4,11,340,'10','6','6',53),(16569,4,11,340,'10','6','7',53),(16570,4,11,340,'8','6','8',53),(16571,4,11,340,'M','6','9',53),(16572,4,11,340,'10','7','1',53),(16573,4,11,340,'10','7','2',53),(16574,4,11,340,'10','7','3',53),(16575,4,11,340,'10','7','4',53),(16576,4,11,340,'10','7','5',53),(16577,4,11,340,'10','7','6',53),(16578,4,11,340,'10','7','7',53),(16579,4,11,340,'2','7','8',53),(16580,4,11,340,'M','7','9',53),(16581,4,11,343,'10','1','1',53),(16582,4,11,343,'10','1','2',53),(16583,4,11,343,'10','1','3',53),(16584,4,11,343,'10','1','4',53),(16585,4,11,343,'10','1','5',53),(16586,4,11,343,'10','1','6',53),(16587,4,11,343,'10','1','7',53),(16588,4,11,343,'1','1','8',53),(16589,4,11,343,'M','1','9',53),(16590,4,11,343,'10','2','1',53),(16591,4,11,343,'10','2','2',53),(16592,4,11,343,'10','2','3',53),(16593,4,11,343,'10','2','4',53),(16594,4,11,343,'10','2','5',53),(16595,4,11,343,'10','2','6',53),(16596,4,11,343,'10','2','7',53),(16597,4,11,343,'10','2','8',53),(16598,4,11,343,'M','2','9',53),(16599,4,11,343,'10','3','1',53),(16600,4,11,343,'10','3','2',53),(16601,4,11,343,'10','3','3',53),(16602,4,11,343,'10','3','4',53),(16603,4,11,343,'10','3','5',53),(16604,4,11,343,'10','3','6',53),(16605,4,11,343,'10','3','7',53),(16606,4,11,343,'10','3','8',53),(16607,4,11,343,'1','3','9',53),(16608,4,11,343,'10','4','1',53),(16609,4,11,343,'10','4','2',53),(16610,4,11,343,'10','4','3',53),(16611,4,11,343,'10','4','4',53),(16612,4,11,343,'10','4','5',53),(16613,4,11,343,'10','4','6',53),(16614,4,11,343,'10','4','7',53),(16615,4,11,343,'4','4','8',53),(16616,4,11,343,'M','4','9',53),(16617,4,11,343,'10','5','1',53),(16618,4,11,343,'10','5','2',53),(16619,4,11,343,'10','5','3',53),(16620,4,11,343,'10','5','4',53),(16621,4,11,343,'10','5','5',53),(16622,4,11,343,'10','5','6',53),(16623,4,11,343,'10','5','7',53),(16624,4,11,343,'3','5','8',53),(16625,4,11,343,'M','5','9',53),(16626,4,11,343,'10','6','1',53),(16627,4,11,343,'10','6','2',53),(16628,4,11,343,'10','6','3',53),(16629,4,11,343,'10','6','4',53),(16630,4,11,343,'10','6','5',53),(16631,4,11,343,'10','6','6',53),(16632,4,11,343,'10','6','7',53),(16633,4,11,343,'2','6','8',53),(16634,4,11,343,'M','6','9',53),(16635,4,11,343,'10','7','1',53),(16636,4,11,343,'10','7','2',53),(16637,4,11,343,'10','7','3',53),(16638,4,11,343,'10','7','4',53),(16639,4,11,343,'10','7','5',53),(16640,4,11,343,'10','7','6',53),(16641,4,11,343,'10','7','7',53),(16642,4,11,343,'5','7','8',53),(16643,4,11,343,'M','7','9',53),(16644,4,11,345,'10','1','1',53),(16645,4,11,345,'10','1','2',53),(16646,4,11,345,'10','1','3',53),(16647,4,11,345,'10','1','4',53),(16648,4,11,345,'10','1','5',53),(16649,4,11,345,'10','1','6',53),(16650,4,11,345,'9','1','7',53),(16651,4,11,345,'M','1','8',53),(16652,4,11,345,'M','1','9',53),(16653,4,11,345,'10','2','1',53),(16654,4,11,345,'10','2','2',53),(16655,4,11,345,'10','2','3',53),(16656,4,11,345,'10','2','4',53),(16657,4,11,345,'10','2','5',53),(16658,4,11,345,'10','2','6',53),(16659,4,11,345,'8','2','7',53),(16660,4,11,345,'M','2','8',53),(16661,4,11,345,'M','2','9',53),(16662,4,11,345,'10','3','1',53),(16663,4,11,345,'10','3','2',53),(16664,4,11,345,'10','3','3',53),(16665,4,11,345,'10','3','4',53),(16666,4,11,345,'10','3','5',53),(16667,4,11,345,'10','3','6',53),(16668,4,11,345,'10','3','7',53),(16669,4,11,345,'9','3','8',53),(16670,4,11,345,'M','3','9',53),(16671,4,11,345,'10','4','1',53),(16672,4,11,345,'10','4','2',53),(16673,4,11,345,'10','4','3',53),(16674,4,11,345,'10','4','4',53),(16675,4,11,345,'10','4','5',53),(16676,4,11,345,'10','4','6',53),(16677,4,11,345,'8','4','7',53),(16678,4,11,345,'M','4','8',53),(16679,4,11,345,'M','4','9',53),(16680,4,11,345,'10','5','1',53),(16681,4,11,345,'10','5','2',53),(16682,4,11,345,'10','5','3',53),(16683,4,11,345,'10','5','4',53),(16684,4,11,345,'10','5','5',53),(16685,4,11,345,'10','5','6',53),(16686,4,11,345,'10','5','7',53),(16687,4,11,345,'7','5','8',53),(16688,4,11,345,'M','5','9',53),(16689,4,11,345,'10','6','1',53),(16690,4,11,345,'10','6','2',53),(16691,4,11,345,'10','6','3',53),(16692,4,11,345,'10','6','4',53),(16693,4,11,345,'10','6','5',53),(16694,4,11,345,'10','6','6',53),(16695,4,11,345,'10','6','7',53),(16696,4,11,345,'8','6','8',53),(16697,4,11,345,'M','6','9',53),(16698,4,11,345,'10','7','1',53),(16699,4,11,345,'10','7','2',53),(16700,4,11,345,'10','7','3',53),(16701,4,11,345,'10','7','4',53),(16702,4,11,345,'10','7','5',53),(16703,4,11,345,'10','7','6',53),(16704,4,11,345,'10','7','7',53),(16705,4,11,345,'8','7','8',53),(16706,4,11,345,'M','7','9',53),(16707,4,11,64,'10','1','2',53),(16708,4,11,64,'10','1','1',53),(16709,4,11,64,'10','1','3',53),(16710,4,11,64,'10','1','4',53),(16711,4,11,64,'10','1','5',53),(16712,4,11,64,'10','1','6',53),(16713,4,11,64,'7','1','7',53),(16714,4,11,64,'M','1','8',53),(16715,4,11,64,'M','1','9',53),(16716,4,11,64,'10','2','1',53),(16717,4,11,64,'10','2','2',53),(16718,4,11,64,'10','2','3',53),(16719,4,11,64,'10','2','4',53),(16720,4,11,64,'10','2','5',53),(16721,4,11,64,'10','2','6',53),(16722,4,11,64,'10','2','7',53),(16723,4,11,64,'M','2','8',53),(16724,4,11,64,'M','2','9',53),(16725,4,11,64,'10','3','1',53),(16726,4,11,64,'10','3','2',53),(16727,4,11,64,'10','3','3',53),(16728,4,11,64,'10','3','4',53),(16729,4,11,64,'10','3','5',53),(16730,4,11,64,'10','3','6',53),(16731,4,11,64,'10','3','7',53),(16732,4,11,64,'5','3','8',53),(16733,4,11,64,'M','3','9',53),(16734,4,11,64,'10','4','1',53),(16735,4,11,64,'10','4','2',53),(16736,4,11,64,'10','4','3',53),(16737,4,11,64,'10','4','4',53),(16738,4,11,64,'10','4','5',53),(16739,4,11,64,'10','4','6',53),(16740,4,11,64,'10','4','7',53),(16741,4,11,64,'2','4','8',53),(16742,4,11,64,'M','4','9',53),(16743,4,11,64,'10','5','1',53),(16744,4,11,64,'10','5','2',53),(16745,4,11,64,'10','5','3',53),(16746,4,11,64,'10','5','4',53),(16747,4,11,64,'10','5','5',53),(16748,4,11,64,'10','5','6',53),(16749,4,11,64,'10','5','7',53),(16750,4,11,64,'1','5','8',53),(16751,4,11,64,'M','5','9',53),(16752,4,11,64,'10','6','1',53),(16753,4,11,64,'10','6','2',53),(16754,4,11,64,'10','6','3',53),(16755,4,11,64,'10','6','4',53),(16756,4,11,64,'10','6','5',53),(16757,4,11,64,'10','6','6',53),(16758,4,11,64,'10','6','7',53),(16759,4,11,64,'8','6','8',53),(16760,4,11,64,'M','6','9',53),(16761,4,11,64,'10','7','1',53),(16762,4,11,64,'10','7','2',53),(16763,4,11,64,'10','7','3',53),(16764,4,11,64,'10','7','4',53),(16765,4,11,64,'10','7','5',53),(16766,4,11,64,'10','7','6',53),(16767,4,11,64,'10','7','7',53),(16768,4,11,64,'5','7','8',53),(16769,4,11,64,'M','7','9',53),(16770,4,11,358,'10','1','2',53),(16771,4,11,358,'10','1','1',53),(16772,4,11,358,'10','1','3',53),(16773,4,11,358,'10','1','4',53),(16774,4,11,358,'10','1','5',53),(16775,4,11,358,'10','1','6',53),(16776,4,11,358,'10','1','7',53),(16777,4,11,358,'8','1','8',53),(16778,4,11,358,'M','1','9',53),(16779,4,11,358,'10','2','1',53),(16780,4,11,358,'10','2','2',53),(16781,4,11,358,'10','2','3',53),(16782,4,11,358,'10','2','4',53),(16783,4,11,358,'10','2','5',53),(16784,4,11,358,'10','2','6',53),(16785,4,11,358,'10','2','7',53),(16786,4,11,358,'1','2','8',53),(16787,4,11,358,'M','2','9',53),(16788,4,11,358,'10','3','1',53),(16789,4,11,358,'10','3','2',53),(16790,4,11,358,'10','3','3',53),(16791,4,11,358,'10','3','4',53),(16792,4,11,358,'10','3','5',53),(16793,4,11,358,'10','3','6',53),(16794,4,11,358,'10','3','7',53),(16795,4,11,358,'M','3','8',53),(16796,4,11,358,'M','3','9',53),(16797,4,11,358,'10','4','1',53),(16798,4,11,358,'10','4','2',53),(16799,4,11,358,'10','4','3',53),(16800,4,11,358,'10','4','4',53),(16801,4,11,358,'10','4','5',53),(16802,4,11,358,'10','4','6',53),(16803,4,11,358,'10','4','7',53),(16804,4,11,358,'3','4','8',53),(16805,4,11,358,'M','4','9',53),(16806,4,11,358,'10','5','1',53),(16807,4,11,358,'10','5','2',53),(16808,4,11,358,'10','5','3',53),(16809,4,11,358,'10','5','4',53),(16810,4,11,358,'10','5','5',53),(16811,4,11,358,'10','5','6',53),(16812,4,11,358,'10','5','7',53),(16813,4,11,358,'M','5','8',53),(16814,4,11,358,'M','5','9',53),(16815,4,11,358,'10','6','1',53),(16816,4,11,358,'10','6','2',53),(16817,4,11,358,'10','6','3',53),(16818,4,11,358,'10','6','4',53),(16819,4,11,358,'10','6','5',53),(16820,4,11,358,'10','6','6',53),(16821,4,11,358,'10','6','7',53),(16822,4,11,358,'M','6','8',53),(16823,4,11,358,'M','6','9',53),(16824,4,11,358,'10','7','1',53),(16825,4,11,358,'10','7','2',53),(16826,4,11,358,'10','7','3',53),(16827,4,11,358,'10','7','4',53),(16828,4,11,358,'10','7','5',53),(16829,4,11,358,'10','7','6',53),(16830,4,11,358,'10','7','7',53),(16831,4,11,358,'6','7','8',53),(16832,4,11,358,'M','7','9',53),(16833,4,11,360,'10','1','2',53),(16834,4,11,360,'10','1','1',53),(16835,4,11,360,'10','1','3',53),(16836,4,11,360,'10','1','4',53),(16837,4,11,360,'10','1','5',53),(16838,4,11,360,'10','1','6',53),(16839,4,11,360,'10','1','7',53),(16840,4,11,360,'9','1','8',53),(16841,4,11,360,'M','1','9',53),(16842,4,11,360,'10','2','1',53),(16843,4,11,360,'10','2','2',53),(16844,4,11,360,'10','2','3',53),(16845,4,11,360,'10','2','4',53),(16846,4,11,360,'10','2','5',53),(16847,4,11,360,'10','2','6',53),(16848,4,11,360,'10','2','7',53),(16849,4,11,360,'1','2','8',53),(16850,4,11,360,'M','2','9',53),(16851,4,11,360,'10','3','1',53),(16852,4,11,360,'10','3','2',53),(16853,4,11,360,'10','3','3',53),(16854,4,11,360,'10','3','4',53),(16855,4,11,360,'10','3','5',53),(16856,4,11,360,'10','3','6',53),(16857,4,11,360,'10','3','7',53),(16858,4,11,360,'2','3','8',53),(16859,4,11,360,'M','3','9',53),(16860,4,11,360,'10','4','1',53),(16861,4,11,360,'10','4','2',53),(16862,4,11,360,'10','4','3',53),(16863,4,11,360,'10','4','4',53),(16864,4,11,360,'10','4','5',53),(16865,4,11,360,'10','4','6',53),(16866,4,11,360,'10','4','7',53),(16867,4,11,360,'9','4','8',53),(16868,4,11,360,'M','4','9',53),(16869,4,11,360,'10','5','1',53),(16870,4,11,360,'10','5','2',53),(16871,4,11,360,'10','5','3',53),(16872,4,11,360,'10','5','4',53),(16873,4,11,360,'10','5','5',53),(16874,4,11,360,'10','5','6',53),(16875,4,11,360,'4','5','7',53),(16876,4,11,360,'M','5','8',53),(16877,4,11,360,'M','5','9',53),(16878,4,11,360,'10','6','1',53),(16879,4,11,360,'10','6','2',53),(16880,4,11,360,'10','6','3',53),(16881,4,11,360,'10','6','4',53),(16882,4,11,360,'10','6','5',53),(16883,4,11,360,'10','6','6',53),(16884,4,11,360,'9','6','7',53),(16885,4,11,360,'M','6','8',53),(16886,4,11,360,'M','6','9',53),(16887,4,11,360,'10','7','1',53),(16888,4,11,360,'10','7','2',53),(16889,4,11,360,'10','7','3',53),(16890,4,11,360,'10','7','4',53),(16891,4,11,360,'10','7','5',53),(16892,4,11,360,'10','7','6',53),(16893,4,11,360,'9','7','7',53),(16894,4,11,360,'M','7','8',53),(16895,4,11,360,'M','7','9',53),(16896,4,11,59,'10','1','2',53),(16897,4,11,59,'10','1','1',53),(16898,4,11,59,'10','1','3',53),(16899,4,11,59,'10','1','4',53),(16900,4,11,59,'10','1','5',53),(16901,4,11,59,'10','1','6',53),(16902,4,11,59,'10','1','7',53),(16903,4,11,59,'3','1','8',53),(16904,4,11,59,'M','1','9',53),(16905,4,11,59,'10','2','1',53),(16906,4,11,59,'10','2','2',53),(16907,4,11,59,'10','2','3',53),(16908,4,11,59,'10','2','4',53),(16909,4,11,59,'10','2','5',53),(16910,4,11,59,'2','2','6',53),(16911,4,11,59,'M','2','7',53),(16912,4,11,59,'M','2','8',53),(16913,4,11,59,'M','2','9',53),(16914,4,11,59,'10','3','1',53),(16915,4,11,59,'10','3','2',53),(16917,4,11,59,'10','3','4',53),(16918,4,11,59,'10','3','5',53),(16919,4,11,59,'10','3','6',53),(16920,4,11,59,'10','3','7',53),(16921,4,11,59,'5','3','8',53),(16922,4,11,59,'M','3','9',53),(16923,4,11,59,'10','3','3',53),(16924,4,11,59,'10','4','1',53),(16925,4,11,59,'10','4','2',53),(16926,4,11,59,'10','4','3',53),(16927,4,11,59,'10','4','4',53),(16928,4,11,59,'10','4','5',53),(16929,4,11,59,'10','4','6',53),(16930,4,11,59,'9','4','7',53),(16931,4,11,59,'M','4','8',53),(16932,4,11,59,'M','4','9',53),(16933,4,11,59,'10','5','1',53),(16934,4,11,59,'10','5','2',53),(16935,4,11,59,'10','5','3',53),(16936,4,11,59,'10','5','4',53),(16937,4,11,59,'10','5','5',53),(16938,4,11,59,'10','5','6',53),(16939,4,11,59,'10','5','7',53),(16940,4,11,59,'4','5','8',53),(16941,4,11,59,'M','5','9',53),(16943,4,11,59,'10','6','1',53),(16944,4,11,59,'10','6','2',53),(16945,4,11,59,'10','6','3',53),(16946,4,11,59,'10','6','4',53),(16947,4,11,59,'10','6','5',53),(16948,4,11,59,'10','6','6',53),(16949,4,11,59,'10','6','7',53),(16950,4,11,59,'6','6','8',53),(16951,4,11,59,'M','6','9',53),(16952,4,11,59,'10','7','1',53),(16953,4,11,59,'10','7','2',53),(16954,4,11,59,'10','7','3',53),(16955,4,11,59,'10','7','4',53),(16956,4,11,59,'10','7','5',53),(16957,4,11,59,'10','7','6',53),(16958,4,11,59,'10','7','7',53),(16959,4,11,59,'3','7','8',53),(16960,4,11,59,'M','7','9',53),(16961,4,11,364,'10','1','1',53),(16962,4,11,364,'10','1','2',53),(16963,4,11,364,'10','1','3',53),(16964,4,11,364,'10','1','4',53),(16965,4,11,364,'10','1','5',53),(16966,4,11,364,'10','1','6',53),(16967,4,11,364,'7','1','7',53),(16968,4,11,364,'M','1','8',53),(16969,4,11,364,'M','1','9',53),(16970,4,11,364,'10','2','1',53),(16971,4,11,364,'10','2','2',53),(16972,4,11,364,'10','2','3',53),(16973,4,11,364,'10','2','4',53),(16974,4,11,364,'10','2','5',53),(16975,4,11,364,'10','2','6',53),(16976,4,11,364,'10','2','7',53),(16977,4,11,364,'M','2','8',53),(16978,4,11,364,'M','2','9',53),(16979,4,11,364,'10','3','1',53),(16980,4,11,364,'10','3','2',53),(16981,4,11,364,'10','3','3',53),(16982,4,11,364,'10','3','4',53),(16983,4,11,364,'10','3','5',53),(16984,4,11,364,'10','3','6',53),(16985,4,11,364,'2','3','7',53),(16986,4,11,364,'M','3','8',53),(16987,4,11,364,'M','3','9',53),(16988,4,11,364,'10','4','1',53),(16989,4,11,364,'10','4','2',53),(16990,4,11,364,'10','4','3',53),(16991,4,11,364,'10','4','4',53),(16992,4,11,364,'10','4','5',53),(16993,4,11,364,'10','4','6',53),(16994,4,11,364,'4','4','7',53),(16995,4,11,364,'M','4','8',53),(16996,4,11,364,'M','4','9',53),(16997,4,11,364,'10','5','1',53),(16998,4,11,364,'10','5','2',53),(16999,4,11,364,'10','5','3',53),(17000,4,11,364,'10','5','4',53),(17001,4,11,364,'10','5','5',53),(17002,4,11,364,'10','5','6',53),(17003,4,11,364,'10','5','7',53),(17004,4,11,364,'3','5','8',53),(17005,4,11,364,'M','5','9',53),(17006,4,11,364,'10','6','1',53),(17007,4,11,364,'10','6','2',53),(17008,4,11,364,'10','6','3',53),(17009,4,11,364,'10','6','4',53),(17010,4,11,364,'10','6','5',53),(17011,4,11,364,'10','6','6',53),(17012,4,11,364,'10','6','7',53),(17013,4,11,364,'M','6','8',53),(17014,4,11,364,'M','6','9',53),(17015,4,11,364,'10','7','1',53),(17016,4,11,364,'10','7','2',53),(17017,4,11,364,'10','7','3',53),(17018,4,11,364,'10','7','4',53),(17019,4,11,364,'10','7','5',53),(17020,4,11,364,'10','7','6',53),(17021,4,11,364,'10','7','7',53),(17022,4,11,364,'9','7','8',53),(17023,4,11,364,'M','7','9',53),(17024,4,11,367,'10','1','1',53),(17025,4,11,367,'10','1','2',53),(17026,4,11,367,'10','1','3',53),(17027,4,11,367,'10','1','4',53),(17028,4,11,367,'9','1','5',53),(17029,4,11,367,'M','1','6',53),(17030,4,11,367,'M','1','7',53),(17031,4,11,367,'M','1','8',53),(17032,4,11,367,'M','1','9',53),(17033,4,11,367,'10','2','1',53),(17034,4,11,367,'10','2','2',53),(17035,4,11,367,'10','2','3',53),(17036,4,11,367,'10','2','4',53),(17037,4,11,367,'10','2','5',53),(17038,4,11,367,'10','2','6',53),(17039,4,11,367,'10','2','7',53),(17040,4,11,367,'7','2','8',53),(17041,4,11,367,'M','2','9',53),(17042,4,11,367,'10','3','1',53),(17043,4,11,367,'10','3','2',53),(17044,4,11,367,'10','3','3',53),(17045,4,11,367,'10','3','4',53),(17046,4,11,367,'10','3','5',53),(17047,4,11,367,'10','3','6',53),(17048,4,11,367,'5','3','7',53),(17049,4,11,367,'M','3','8',53),(17050,4,11,367,'M','3','9',53),(17051,4,11,367,'10','4','1',53),(17052,4,11,367,'10','4','2',53),(17053,4,11,367,'10','4','3',53),(17054,4,11,367,'10','4','4',53),(17055,4,11,367,'10','4','5',53),(17056,4,11,367,'10','4','6',53),(17057,4,11,367,'7','4','7',53),(17058,4,11,367,'M','4','8',53),(17059,4,11,367,'M','4','9',53),(17060,4,11,367,'10','5','1',53),(17061,4,11,367,'10','5','2',53),(17062,4,11,367,'10','5','3',53),(17063,4,11,367,'10','5','4',53),(17064,4,11,367,'10','5','5',53),(17065,4,11,367,'10','5','6',53),(17066,4,11,367,'7','5','7',53),(17067,4,11,367,'M','5','8',53),(17068,4,11,367,'M','5','9',53),(17069,4,11,367,'10','6','1',53),(17070,4,11,367,'10','6','2',53),(17071,4,11,367,'10','6','3',53),(17072,4,11,367,'10','6','4',53),(17073,4,11,367,'10','6','5',53),(17074,4,11,367,'10','6','6',53),(17075,4,11,367,'9','6','7',53),(17076,4,11,367,'M','6','8',53),(17077,4,11,367,'M','6','9',53),(17078,4,11,367,'10','7','1',53),(17079,4,11,367,'10','7','2',53),(17080,4,11,367,'10','7','3',53),(17081,4,11,367,'10','7','4',53),(17082,4,11,367,'10','7','5',53),(17083,4,11,367,'10','7','6',53),(17084,4,11,367,'10','7','7',53),(17085,4,11,367,'5','7','8',53),(17086,4,11,367,'M','7','9',53),(17087,4,11,62,'10','1','1',53),(17088,4,11,62,'10','1','2',53),(17089,4,11,62,'10','1','3',53),(17090,4,11,62,'10','1','4',53),(17091,4,11,62,'10','1','5',53),(17092,4,11,62,'10','1','6',53),(17093,4,11,62,'3','1','7',53),(17094,4,11,62,'M','1','8',53),(17095,4,11,62,'M','1','9',53),(17096,4,11,62,'10','2','1',53),(17097,4,11,62,'10','2','2',53),(17098,4,11,62,'10','2','3',53),(17099,4,11,62,'10','2','4',53),(17100,4,11,62,'10','2','5',53),(17101,4,11,62,'10','2','6',53),(17102,4,11,62,'10','2','7',53),(17103,4,11,62,'5','2','8',53),(17104,4,11,62,'M','2','9',53),(17105,4,11,62,'10','3','1',53),(17106,4,11,62,'10','3','2',53),(17107,4,11,62,'10','3','3',53),(17108,4,11,62,'10','3','4',53),(17109,4,11,62,'10','3','5',53),(17110,4,11,62,'10','3','6',53),(17111,4,11,62,'2','3','7',53),(17112,4,11,62,'M','3','8',53),(17113,4,11,62,'M','3','9',53),(17114,4,11,62,'10','4','1',53),(17115,4,11,62,'10','4','2',53),(17116,4,11,62,'10','4','3',53),(17117,4,11,62,'10','4','4',53),(17118,4,11,62,'10','4','5',53),(17119,4,11,62,'10','4','6',53),(17120,4,11,62,'9','4','7',53),(17121,4,11,62,'M','4','8',53),(17122,4,11,62,'M','4','9',53),(17123,4,11,62,'10','5','1',53),(17124,4,11,62,'10','5','2',53),(17125,4,11,62,'10','5','3',53),(17126,4,11,62,'10','5','4',53),(17127,4,11,62,'10','5','5',53),(17128,4,11,62,'3','5','6',53),(17129,4,11,62,'M','5','7',53),(17130,4,11,62,'M','5','8',53),(17131,4,11,62,'M','5','9',53),(17132,4,11,62,'10','6','1',53),(17133,4,11,62,'10','6','2',53),(17134,4,11,62,'10','6','3',53),(17135,4,11,62,'10','6','4',53),(17136,4,11,62,'10','6','5',53),(17137,4,11,62,'10','6','6',53),(17138,4,11,62,'6','6','7',53),(17139,4,11,62,'M','6','8',53),(17140,4,11,62,'M','6','9',53),(17141,4,11,62,'10','7','1',53),(17142,4,11,62,'10','7','2',53),(17143,4,11,62,'10','7','3',53),(17144,4,11,62,'10','7','4',53),(17145,4,11,62,'10','7','5',53),(17146,4,11,62,'10','7','6',53),(17147,4,11,62,'4','7','7',53),(17148,4,11,62,'M','7','8',53),(17149,4,11,62,'M','7','9',53),(17150,4,11,58,'10','1','1',53),(17151,4,11,58,'10','1','2',53),(17152,4,11,58,'10','1','3',53),(17153,4,11,58,'10','1','4',53),(17154,4,11,58,'10','1','5',53),(17155,4,11,58,'10','1','6',53),(17156,4,11,58,'10','1','7',53),(17157,4,11,58,'5','1','8',53),(17158,4,11,58,'M','1','9',53),(17159,4,11,58,'10','2','1',53),(17160,4,11,58,'10','2','2',53),(17161,4,11,58,'10','2','3',53),(17162,4,11,58,'10','2','4',53),(17163,4,11,58,'10','2','5',53),(17164,4,11,58,'8','2','6',53),(17165,4,11,58,'M','2','7',53),(17166,4,11,58,'M','2','8',53),(17167,4,11,58,'M','2','9',53),(17168,4,11,58,'10','3','1',53),(17169,4,11,58,'10','3','2',53),(17170,4,11,58,'10','3','3',53),(17171,4,11,58,'10','3','4',53),(17172,4,11,58,'10','3','5',53),(17173,4,11,58,'10','3','6',53),(17174,4,11,58,'10','3','7',53),(17175,4,11,58,'2','3','8',53),(17176,4,11,58,'M','3','9',53),(17177,4,11,58,'10','4','1',53),(17178,4,11,58,'10','4','2',53),(17179,4,11,58,'10','4','3',53),(17180,4,11,58,'10','4','4',53),(17181,4,11,58,'10','4','5',53),(17182,4,11,58,'10','4','6',53),(17183,4,11,58,'2','4','7',53),(17184,4,11,58,'M','4','8',53),(17185,4,11,58,'M','4','9',53),(17186,4,11,58,'10','5','1',53),(17187,4,11,58,'10','5','2',53),(17188,4,11,58,'10','5','3',53),(17189,4,11,58,'10','5','4',53),(17190,4,11,58,'10','5','5',53),(17191,4,11,58,'10','5','6',53),(17192,4,11,58,'9','5','7',53),(17193,4,11,58,'M','5','8',53),(17194,4,11,58,'M','5','9',53),(17195,4,11,58,'10','6','1',53),(17196,4,11,58,'10','6','2',53),(17197,4,11,58,'10','6','3',53),(17198,4,11,58,'10','6','4',53),(17199,4,11,58,'10','6','5',53),(17200,4,11,58,'4','6','6',53),(17201,4,11,58,'M','6','7',53),(17202,4,11,58,'M','6','8',53),(17203,4,11,58,'M','6','9',53),(17204,4,11,58,'10','7','1',53),(17205,4,11,58,'10','7','2',53),(17206,4,11,58,'10','7','3',53),(17207,4,11,58,'10','7','4',53),(17208,4,11,58,'10','7','5',53),(17209,4,11,58,'9','7','6',53),(17210,4,11,58,'M','7','7',53),(17211,4,11,58,'M','7','8',53),(17212,4,11,58,'M','7','9',53),(17213,4,11,371,'10','1','1',53),(17214,4,11,371,'10','1','2',53),(17215,4,11,371,'10','1','3',53),(17216,4,11,371,'10','1','4',53),(17217,4,11,371,'10','1','5',53),(17218,4,11,371,'10','1','6',53),(17219,4,11,371,'2','1','7',53),(17220,4,11,371,'M','1','8',53),(17221,4,11,371,'M','1','9',53),(17222,4,11,371,'10','2','1',53),(17223,4,11,371,'10','2','2',53),(17224,4,11,371,'10','2','3',53),(17225,4,11,371,'10','2','4',53),(17226,4,11,371,'10','2','5',53),(17227,4,11,371,'10','2','6',53),(17228,4,11,371,'1','2','7',53),(17229,4,11,371,'M','2','8',53),(17230,4,11,371,'M','2','9',53),(17231,4,11,371,'10','3','1',53),(17232,4,11,371,'10','3','2',53),(17233,4,11,371,'10','3','3',53),(17234,4,11,371,'10','3','4',53),(17235,4,11,371,'10','3','5',53),(17236,4,11,371,'10','3','6',53),(17237,4,11,371,'M','3','7',53),(17238,4,11,371,'M','3','8',53),(17239,4,11,371,'M','3','9',53),(17240,4,11,371,'10','4','1',53),(17241,4,11,371,'10','4','2',53),(17242,4,11,371,'10','4','3',53),(17243,4,11,371,'10','4','4',53),(17244,4,11,371,'10','4','5',53),(17245,4,11,371,'1','4','6',53),(17246,4,11,371,'M','4','7',53),(17247,4,11,371,'M','4','8',53),(17248,4,11,371,'M','4','9',53),(17249,4,11,371,'10','5','1',53),(17250,4,11,371,'10','5','2',53),(17251,4,11,371,'10','5','3',53),(17252,4,11,371,'10','5','4',53),(17253,4,11,371,'10','5','5',53),(17254,4,11,371,'10','5','6',53),(17255,4,11,371,'4','5','7',53),(17256,4,11,371,'M','5','8',53),(17257,4,11,371,'M','5','9',53),(17258,4,11,371,'10','6','1',53),(17259,4,11,371,'10','6','2',53),(17260,4,11,371,'10','6','3',53),(17261,4,11,371,'10','6','4',53),(17262,4,11,371,'10','6','5',53),(17263,4,11,371,'10','6','6',53),(17264,4,11,371,'10','6','7',53),(17265,4,11,371,'6','6','8',53),(17266,4,11,371,'M','6','9',53),(17267,4,11,371,'10','7','1',53),(17268,4,11,371,'10','7','2',53),(17269,4,11,371,'10','7','3',53),(17270,4,11,371,'10','7','4',53),(17271,4,11,371,'10','7','5',53),(17272,4,11,371,'10','7','6',53),(17273,4,11,371,'10','7','7',53),(17274,4,11,371,'3','7','8',53),(17275,4,11,371,'M','7','9',53),(17276,4,11,60,'10','1','2',53),(17277,4,11,60,'10','1','1',53),(17278,4,11,60,'10','1','3',53),(17279,4,11,60,'10','1','4',53),(17280,4,11,60,'10','1','5',53),(17281,4,11,60,'10','1','6',53),(17282,4,11,60,'10','1','7',53),(17283,4,11,60,'10','1','8',53),(17284,4,11,60,'M','1','9',53),(17285,4,11,60,'10','2','1',53),(17286,4,11,60,'10','2','2',53),(17287,4,11,60,'10','2','3',53),(17288,4,11,60,'10','2','4',53),(17289,4,11,60,'10','2','5',53),(17290,4,11,60,'10','2','6',53),(17291,4,11,60,'7','2','7',53),(17292,4,11,60,'M','2','8',53),(17293,4,11,60,'M','2','9',53),(17294,4,11,60,'10','3','1',53),(17295,4,11,60,'10','3','2',53),(17296,4,11,60,'10','3','3',53),(17297,4,11,60,'10','3','4',53),(17298,4,11,60,'10','3','5',53),(17299,4,11,60,'10','3','6',53),(17300,4,11,60,'2','3','7',53),(17301,4,11,60,'M','3','8',53),(17302,4,11,60,'M','3','9',53),(17303,4,11,60,'10','4','1',53),(17304,4,11,60,'10','4','2',53),(17305,4,11,60,'10','4','3',53),(17306,4,11,60,'10','4','4',53),(17307,4,11,60,'10','4','5',53),(17308,4,11,60,'2','4','6',53),(17309,4,11,60,'M','4','7',53),(17310,4,11,60,'M','4','8',53),(17311,4,11,60,'M','4','9',53),(17312,4,11,60,'10','5','1',53),(17313,4,11,60,'10','5','2',53),(17314,4,11,60,'10','5','3',53),(17315,4,11,60,'10','5','4',53),(17316,4,11,60,'10','5','5',53),(17317,4,11,60,'8','5','6',53),(17318,4,11,60,'M','5','7',53),(17319,4,11,60,'M','5','8',53),(17320,4,11,60,'M','5','9',53),(17321,4,11,60,'10','6','1',53),(17322,4,11,60,'10','6','2',53),(17323,4,11,60,'10','6','3',53),(17324,4,11,60,'10','6','4',53),(17325,4,11,60,'10','6','5',53),(17326,4,11,60,'10','6','6',53),(17327,4,11,60,'10','6','7',53),(17328,4,11,60,'1','6','8',53),(17329,4,11,60,'M','6','9',53),(17330,4,11,60,'10','7','1',53),(17331,4,11,60,'10','7','2',53),(17332,4,11,60,'10','7','3',53),(17333,4,11,60,'10','7','4',53),(17334,4,11,60,'5','7','5',53),(17335,4,11,60,'M','7','6',53),(17336,4,11,60,'M','7','7',53),(17337,4,11,60,'M','7','8',53),(17338,4,11,60,'M','7','9',53),(17339,4,11,373,'10','1','1',53),(17340,4,11,373,'10','1','2',53),(17341,4,11,373,'10','1','3',53),(17342,4,11,373,'10','1','4',53),(17343,4,11,373,'10','1','5',53),(17344,4,11,373,'M','1','6',53),(17345,4,11,373,'M','1','7',53),(17346,4,11,373,'M','1','8',53),(17347,4,11,373,'M','1','9',53),(17348,4,11,373,'10','2','1',53),(17349,4,11,373,'10','2','2',53),(17350,4,11,373,'10','2','3',53),(17351,4,11,373,'10','2','4',53),(17352,4,11,373,'10','2','5',53),(17354,4,11,373,'10','2','6',53),(17355,4,11,373,'4','2','7',53),(17356,4,11,373,'M','2','8',53),(17357,4,11,373,'M','2','9',53),(17358,4,11,373,'10','3','1',53),(17359,4,11,373,'10','3','2',53),(17360,4,11,373,'10','3','3',53),(17361,4,11,373,'10','3','4',53),(17362,4,11,373,'10','3','5',53),(17363,4,11,373,'10','3','6',53),(17364,4,11,373,'10','3','7',53),(17365,4,11,373,'5','3','8',53),(17366,4,11,373,'M','3','9',53),(17367,4,11,373,'10','4','1',53),(17368,4,11,373,'10','4','2',53),(17369,4,11,373,'10','4','3',53),(17370,4,11,373,'10','4','4',53),(17371,4,11,373,'10','4','5',53),(17372,4,11,373,'1','4','6',53),(17373,4,11,373,'M','4','7',53),(17374,4,11,373,'M','4','8',53),(17375,4,11,373,'M','4','9',53),(17376,4,11,373,'10','5','1',53),(17377,4,11,373,'10','5','2',53),(17378,4,11,373,'10','5','3',53),(17379,4,11,373,'10','5','4',53),(17380,4,11,373,'10','5','5',53),(17381,4,11,373,'10','5','6',53),(17382,4,11,373,'5','5','7',53),(17383,4,11,373,'M','5','8',53),(17384,4,11,373,'M','5','9',53),(17385,4,11,373,'10','6','1',53),(17386,4,11,373,'10','6','2',53),(17387,4,11,373,'10','6','3',53),(17388,4,11,373,'10','6','4',53),(17389,4,11,373,'10','6','5',53),(17390,4,11,373,'10','6','6',53),(17391,4,11,373,'1','6','7',53),(17392,4,11,373,'M','6','8',53),(17393,4,11,373,'M','6','9',53),(17394,4,11,373,'10','7','1',53),(17395,4,11,373,'10','7','2',53),(17396,4,11,373,'10','7','3',53),(17397,4,11,373,'10','7','4',53),(17398,4,11,373,'10','7','5',53),(17399,4,11,373,'7','7','6',53),(17400,4,11,373,'M','7','7',53),(17401,4,11,373,'M','7','8',53),(17402,4,11,373,'M','7','9',53),(17403,4,11,375,'10','1','1',53),(17404,4,11,375,'10','1','2',53),(17405,4,11,375,'10','1','3',53),(17406,4,11,375,'10','1','4',53),(17407,4,11,375,'10','1','5',53),(17408,4,11,375,'2','1','6',53),(17409,4,11,375,'M','1','7',53),(17410,4,11,375,'M','1','8',53),(17411,4,11,375,'M','1','9',53),(17412,4,11,375,'10','2','1',53),(17414,4,11,375,'10','2','2',53),(17415,4,11,375,'10','2','3',53),(17416,4,11,375,'10','2','4',53),(17417,4,11,375,'10','2','5',53),(17418,4,11,375,'10','2','6',53),(17419,4,11,375,'2','2','7',53),(17420,4,11,375,'M','2','8',53),(17421,4,11,375,'M','2','9',53),(17422,4,11,375,'10','3','1',53),(17423,4,11,375,'10','3','2',53),(17424,4,11,375,'10','3','3',53),(17425,4,11,375,'10','3','4',53),(17426,4,11,375,'10','3','5',53),(17427,4,11,375,'10','3','6',53),(17428,4,11,375,'5','3','7',53),(17429,4,11,375,'M','3','8',53),(17430,4,11,375,'M','3','9',53),(17431,4,11,375,'10','4','1',53),(17432,4,11,375,'10','4','2',53),(17433,4,11,375,'10','4','3',53),(17434,4,11,375,'10','4','4',53),(17435,4,11,375,'10','4','5',53),(17436,4,11,375,'1','4','6',53),(17437,4,11,375,'M','4','7',53),(17438,4,11,375,'M','4','8',53),(17439,4,11,375,'M','4','9',53),(17440,4,11,375,'10','5','1',53),(17441,4,11,375,'10','5','2',53),(17442,4,11,375,'10','5','3',53),(17443,4,11,375,'10','5','4',53),(17444,4,11,375,'10','5','5',53),(17445,4,11,375,'4','5','6',53),(17446,4,11,375,'M','5','7',53),(17447,4,11,375,'M','5','8',53),(17448,4,11,375,'M','5','9',53),(17449,4,11,375,'10','6','1',53),(17450,4,11,375,'10','6','2',53),(17451,4,11,375,'10','6','3',53),(17452,4,11,375,'10','6','4',53),(17453,4,11,375,'10','6','5',53),(17454,4,11,375,'10','6','6',53),(17455,4,11,375,'10','6','7',53),(17456,4,11,375,'5','6','8',53),(17457,4,11,375,'M','6','9',53),(17458,4,11,375,'10','7','1',53),(17459,4,11,375,'10','7','2',53),(17460,4,11,375,'10','7','3',53),(17461,4,11,375,'10','7','4',53),(17462,4,11,375,'10','7','5',53),(17463,4,11,375,'10','7','6',53),(17464,4,11,375,'M','7','7',53),(17465,4,11,375,'M','7','8',53),(17466,4,11,375,'M','7','9',53),(17467,4,11,379,'10','1','1',53),(17468,4,11,379,'10','1','2',53),(17469,4,11,379,'10','1','3',53),(17470,4,11,379,'10','1','4',53),(17471,4,11,379,'7','1','5',53),(17472,4,11,379,'M','1','6',53),(17473,4,11,379,'M','1','7',53),(17474,4,11,379,'M','1','8',53),(17475,4,11,379,'M','1','9',53),(17477,4,11,379,'10','2','2',53),(17478,4,11,379,'10','2','3',53),(17479,4,11,379,'10','2','4',53),(17480,4,11,379,'10','2','5',53),(17481,4,11,379,'10','2','6',53),(17482,4,11,379,'2','2','7',53),(17483,4,11,379,'M','2','8',53),(17484,4,11,379,'M','2','9',53),(17485,4,11,379,'10','2','1',53),(17486,4,11,379,'10','3','1',53),(17487,4,11,379,'10','3','2',53),(17488,4,11,379,'10','3','3',53),(17489,4,11,379,'10','3','4',53),(17490,4,11,379,'10','3','5',53),(17491,4,11,379,'10','3','6',53),(17492,4,11,379,'5','3','7',53),(17493,4,11,379,'M','3','8',53),(17494,4,11,379,'M','3','9',53),(17495,4,11,379,'10','4','1',53),(17496,4,11,379,'10','4','2',53),(17497,4,11,379,'10','4','3',53),(17498,4,11,379,'10','4','4',53),(17499,4,11,379,'10','4','5',53),(17500,4,11,379,'1','4','6',53),(17501,4,11,379,'M','4','7',53),(17502,4,11,379,'M','4','8',53),(17503,4,11,379,'M','4','9',53),(17504,4,11,379,'10','5','1',53),(17505,4,11,379,'10','5','2',53),(17506,4,11,379,'10','5','3',53),(17507,4,11,379,'10','5','4',53),(17508,4,11,379,'10','5','5',53),(17509,4,11,379,'4','5','6',53),(17510,4,11,379,'M','5','7',53),(17511,4,11,379,'M','5','8',53),(17512,4,11,379,'M','5','9',53),(17513,4,11,379,'10','6','1',53),(17514,4,11,379,'10','6','2',53),(17515,4,11,379,'10','6','3',53),(17516,4,11,379,'10','6','4',53),(17517,4,11,379,'10','6','5',53),(17518,4,11,379,'10','6','6',53),(17519,4,11,379,'10','6','7',53),(17520,4,11,379,'5','6','8',53),(17521,4,11,379,'M','6','9',53),(17522,4,11,379,'10','7','1',53),(17523,4,11,379,'10','7','2',53),(17524,4,11,379,'10','7','3',53),(17525,4,11,379,'10','7','4',53),(17526,4,11,379,'10','7','5',53),(17527,4,11,379,'10','7','6',53),(17528,4,11,379,'M','7','7',53),(17529,4,11,379,'M','7','8',53),(17530,4,11,379,'M','7','9',53),(17531,4,11,381,'10','1','1',53),(17532,4,11,381,'10','1','2',53),(17533,4,11,381,'10','1','3',53),(17534,4,11,381,'10','1','4',53),(17535,4,11,381,'10','1','5',53),(17536,4,11,381,'10','1','6',53),(17537,4,11,381,'M','1','7',53),(17538,4,11,381,'M','1','8',53),(17539,4,11,381,'M','1','9',53),(17540,4,11,381,'10','2','1',53),(17541,4,11,381,'10','2','2',53),(17542,4,11,381,'10','2','3',53),(17543,4,11,381,'10','2','4',53),(17544,4,11,381,'10','2','5',53),(17545,4,11,381,'7','2','6',53),(17546,4,11,381,'M','2','7',53),(17547,4,11,381,'M','2','8',53),(17548,4,11,381,'M','2','9',53),(17549,4,11,381,'10','3','1',53),(17550,4,11,381,'10','3','2',53),(17551,4,11,381,'10','3','3',53),(17552,4,11,381,'10','3','4',53),(17553,4,11,381,'1','3','5',53),(17554,4,11,381,'M','3','6',53),(17555,4,11,381,'M','3','7',53),(17556,4,11,381,'M','3','8',53),(17557,4,11,381,'M','3','9',53),(17558,4,11,381,'10','4','1',53),(17559,4,11,381,'10','4','2',53),(17560,4,11,381,'10','4','3',53),(17561,4,11,381,'10','4','4',53),(17562,4,11,381,'10','4','5',53),(17563,4,11,381,'10','4','6',53),(17564,4,11,381,'4','4','7',53),(17565,4,11,381,'M','4','8',53),(17566,4,11,381,'M','4','9',53),(17567,4,11,381,'10','5','1',53),(17568,4,11,381,'10','5','2',53),(17569,4,11,381,'10','5','3',53),(17570,4,11,381,'10','5','4',53),(17571,4,11,381,'10','5','5',53),(17572,4,11,381,'8','5','6',53),(17573,4,11,381,'M','5','7',53),(17574,4,11,381,'M','5','8',53),(17575,4,11,381,'M','5','9',53),(17576,4,11,381,'10','6','1',53),(17577,4,11,381,'10','6','2',53),(17578,4,11,381,'10','6','3',53),(17579,4,11,381,'10','6','4',53),(17580,4,11,381,'10','6','5',53),(17581,4,11,381,'3','6','6',53),(17582,4,11,381,'M','6','7',53),(17583,4,11,381,'M','6','8',53),(17584,4,11,381,'M','6','9',53),(17585,4,11,381,'10','7','1',53),(17586,4,11,381,'10','7','2',53),(17587,4,11,381,'10','7','3',53),(17588,4,11,381,'10','7','4',53),(17589,4,11,381,'10','7','5',53),(17590,4,11,381,'6','7','6',53),(17591,4,11,381,'M','7','7',53),(17592,4,11,381,'M','7','8',53),(17593,4,11,381,'M','7','9',53),(17594,4,11,382,'10','1','1',53),(17595,4,11,382,'10','1','2',53),(17596,4,11,382,'10','1','3',53),(17597,4,11,382,'10','1','4',53),(17598,4,11,382,'10','1','5',53),(17599,4,11,382,'10','1','6',53),(17600,4,11,382,'6','1','7',53),(17601,4,11,382,'M','1','8',53),(17602,4,11,382,'M','1','9',53),(17603,4,11,382,'10','2','1',53),(17604,4,11,382,'10','2','2',53),(17605,4,11,382,'10','2','3',53),(17606,4,11,382,'10','2','4',53),(17607,4,11,382,'10','2','5',53),(17608,4,11,382,'5','2','6',53),(17609,4,11,382,'M','2','7',53),(17610,4,11,382,'M','2','8',53),(17611,4,11,382,'M','2','9',53),(17612,4,11,382,'10','3','1',53),(17613,4,11,382,'10','3','2',53),(17614,4,11,382,'10','3','3',53),(17615,4,11,382,'4','3','4',53),(17617,4,11,382,'M','3','5',53),(17618,4,11,382,'M','3','6',53),(17619,4,11,382,'M','3','7',53),(17620,4,11,382,'M','3','8',53),(17621,4,11,382,'M','3','9',53),(17622,4,11,382,'10','4','1',53),(17623,4,11,382,'10','4','2',53),(17625,4,11,382,'10','4','3',53),(17626,4,11,382,'10','4','4',53),(17627,4,11,382,'2','4','5',53),(17628,4,11,382,'M','4','6',53),(17629,4,11,382,'M','4','7',53),(17630,4,11,382,'M','4','8',53),(17631,4,11,382,'M','4','9',53),(17632,4,11,382,'10','5','1',53),(17633,4,11,382,'10','5','2',53),(17634,4,11,382,'10','5','3',53),(17635,4,11,382,'10','5','4',53),(17636,4,11,382,'10','5','5',53),(17637,4,11,382,'6','5','6',53),(17638,4,11,382,'M','5','7',53),(17639,4,11,382,'M','5','8',53),(17640,4,11,382,'M','5','9',53),(17641,4,11,382,'10','6','1',53),(17642,4,11,382,'10','6','2',53),(17643,4,11,382,'10','6','3',53),(17644,4,11,382,'4','6','4',53),(17645,4,11,382,'M','6','5',53),(17646,4,11,382,'M','6','6',53),(17647,4,11,382,'M','6','7',53),(17648,4,11,382,'M','6','8',53),(17649,4,11,382,'M','6','9',53),(17650,4,11,382,'10','7','1',53),(17651,4,11,382,'10','7','2',53),(17652,4,11,382,'10','7','3',53),(17653,4,11,382,'10','7','4',53),(17654,4,11,382,'10','7','5',53),(17655,4,11,382,'10','7','6',53),(17657,4,11,382,'6','7','7',53),(17658,4,11,382,'M','7','8',53),(17659,4,11,382,'M','7','9',53),(17660,4,11,383,'10','1','1',53),(17661,4,11,383,'10','1','2',53),(17662,4,11,383,'10','1','3',53),(17663,4,11,383,'10','1','4',53),(17664,4,11,383,'1','1','5',53),(17665,4,11,383,'M','1','6',53),(17666,4,11,383,'M','1','7',53),(17667,4,11,383,'M','1','8',53),(17668,4,11,383,'M','1','9',53),(17669,4,11,383,'10','2','1',53),(17670,4,11,383,'10','2','2',53),(17671,4,11,383,'10','2','3',53),(17672,4,11,383,'10','2','4',53),(17673,4,11,383,'10','2','5',53),(17674,4,11,383,'10','2','6',53),(17675,4,11,383,'10','2','7',53),(17676,4,11,383,'M','2','8',53),(17677,4,11,383,'M','2','9',53),(17678,4,11,383,'10','3','1',53),(17679,4,11,383,'10','3','2',53),(17680,4,11,383,'9','3','3',53),(17681,4,11,383,'M','3','4',53),(17682,4,11,383,'M','3','5',53),(17683,4,11,383,'M','3','6',53),(17684,4,11,383,'M','3','7',53),(17685,4,11,383,'M','3','8',53),(17686,4,11,383,'M','3','9',53),(17687,4,11,383,'10','4','1',53),(17688,4,11,383,'10','4','2',53),(17689,4,11,383,'10','4','3',53),(17690,4,11,383,'10','4','4',53),(17691,4,11,383,'8','4','5',53),(17692,4,11,383,'M','4','6',53),(17693,4,11,383,'M','4','7',53),(17695,4,11,383,'M','4','8',53),(17696,4,11,383,'M','4','9',53),(17697,4,11,383,'10','5','1',53),(17698,4,11,383,'10','5','2',53),(17699,4,11,383,'10','5','3',53),(17700,4,11,383,'10','5','4',53),(17701,4,11,383,'9','5','5',53),(17702,4,11,383,'M','5','6',53),(17703,4,11,383,'M','5','7',53),(17704,4,11,383,'M','5','8',53),(17705,4,11,383,'M','5','9',53),(17706,4,11,383,'10','6','1',53),(17707,4,11,383,'10','6','2',53),(17708,4,11,383,'10','6','3',53),(17709,4,11,383,'10','6','4',53),(17710,4,11,383,'10','6','5',53),(17711,4,11,383,'8','6','6',53),(17712,4,11,383,'M','6','7',53),(17713,4,11,383,'M','6','8',53),(17714,4,11,383,'M','6','9',53),(17715,4,11,383,'10','7','1',53),(17716,4,11,383,'10','7','2',53),(17717,4,11,383,'10','7','3',53),(17718,4,11,383,'10','7','4',53),(17719,4,11,383,'10','7','5',53),(17720,4,11,383,'5','7','6',53),(17721,4,11,383,'M','7','7',53),(17722,4,11,383,'M','7','8',53),(17723,4,11,383,'M','7','9',53),(17724,4,11,384,'10','1','1',53),(17725,4,11,384,'10','1','2',53),(17726,4,11,384,'10','1','3',53),(17727,4,11,384,'10','1','4',53),(17728,4,11,384,'10','1','5',53),(17729,4,11,384,'3','1','6',53),(17730,4,11,384,'M','1','7',53),(17731,4,11,384,'M','1','8',53),(17732,4,11,384,'M','1','9',53),(17733,4,11,384,'10','2','1',53),(17734,4,11,384,'10','2','2',53),(17735,4,11,384,'10','2','3',53),(17736,4,11,384,'10','2','4',53),(17737,4,11,384,'9','2','5',53),(17738,4,11,384,'M','2','6',53),(17739,4,11,384,'M','2','7',53),(17740,4,11,384,'M','2','8',53),(17741,4,11,384,'M','2','9',53),(17742,4,11,384,'10','3','1',53),(17743,4,11,384,'10','3','2',53),(17744,4,11,384,'10','3','3',53),(17745,4,11,384,'10','3','4',53),(17746,4,11,384,'6','3','5',53),(17747,4,11,384,'M','3','6',53),(17748,4,11,384,'M','3','7',53),(17749,4,11,384,'M','3','8',53),(17750,4,11,384,'M','3','9',53),(17751,4,11,384,'10','4','1',53),(17752,4,11,384,'10','4','2',53),(17753,4,11,384,'10','4','3',53),(17754,4,11,384,'10','4','4',53),(17755,4,11,384,'2','4','5',53),(17756,4,11,384,'M','4','6',53),(17757,4,11,384,'M','4','7',53),(17758,4,11,384,'M','4','8',53),(17759,4,11,384,'M','4','9',53),(17760,4,11,384,'10','5','1',53),(17761,4,11,384,'10','5','2',53),(17762,4,11,384,'10','5','3',53),(17763,4,11,384,'10','5','4',53),(17764,4,11,384,'5','5','5',53),(17765,4,11,384,'M','5','6',53),(17766,4,11,384,'M','5','7',53),(17767,4,11,384,'M','5','8',53),(17768,4,11,384,'M','5','9',53),(17769,4,11,384,'10','6','1',53),(17770,4,11,384,'10','6','2',53),(17771,4,11,384,'10','6','3',53),(17772,4,11,384,'10','6','4',53),(17773,4,11,384,'10','6','5',53),(17774,4,11,384,'10','6','6',53),(17775,4,11,384,'M','6','7',53),(17776,4,11,384,'M','6','8',53),(17777,4,11,384,'M','6','9',53),(17778,4,11,384,'10','7','1',53),(17779,4,11,384,'10','7','2',53),(17780,4,11,384,'10','7','3',53),(17781,4,11,384,'10','7','4',53),(17782,4,11,384,'5','7','5',53),(17783,4,11,384,'M','7','6',53),(17784,4,11,384,'M','7','7',53),(17785,4,11,384,'M','7','8',53),(17786,4,11,384,'M','7','9',53),(17787,4,11,385,'10','1','1',53),(17788,4,11,385,'10','1','2',53),(17789,4,11,385,'10','1','3',53),(17790,4,11,385,'10','1','4',53),(17791,4,11,385,'7','1','5',53),(17792,4,11,385,'M','1','6',53),(17793,4,11,385,'M','1','7',53),(17794,4,11,385,'M','1','8',53),(17795,4,11,385,'M','1','9',53),(17796,4,11,385,'10','2','1',53),(17797,4,11,385,'10','2','2',53),(17798,4,11,385,'10','2','3',53),(17799,4,11,385,'10','2','4',53),(17800,4,11,385,'10','2','5',53),(17801,4,11,385,'6','2','6',53),(17802,4,11,385,'M','2','7',53),(17803,4,11,385,'M','2','8',53),(17804,4,11,385,'M','2','9',53),(17805,4,11,385,'10','3','1',53),(17806,4,11,385,'10','3','2',53),(17807,4,11,385,'10','3','3',53),(17808,4,11,385,'10','3','4',53),(17809,4,11,385,'10','3','5',53),(17810,4,11,385,'7','3','6',53),(17811,4,11,385,'M','3','7',53),(17812,4,11,385,'M','3','8',53),(17813,4,11,385,'M','3','9',53),(17814,4,11,385,'10','4','1',53),(17815,4,11,385,'10','4','2',53),(17816,4,11,385,'10','4','3',53),(17817,4,11,385,'4','4','4',53),(17818,4,11,385,'M','4','5',53),(17819,4,11,385,'M','4','6',53),(17820,4,11,385,'M','4','7',53),(17821,4,11,385,'M','4','8',53),(17822,4,11,385,'M','4','9',53),(17823,4,11,385,'10','5','1',53),(17824,4,11,385,'10','5','2',53),(17825,4,11,385,'10','5','3',53),(17826,4,11,385,'10','5','4',53),(17827,4,11,385,'10','5','5',53),(17828,4,11,385,'2','5','6',53),(17829,4,11,385,'M','5','7',53),(17830,4,11,385,'M','5','8',53),(17831,4,11,385,'M','5','9',53),(17832,4,11,385,'10','6','1',53),(17833,4,11,385,'10','6','2',53),(17834,4,11,385,'10','6','3',53),(17835,4,11,385,'10','6','4',53),(17836,4,11,385,'1','6','5',53),(17837,4,11,385,'M','6','6',53),(17838,4,11,385,'M','6','7',53),(17839,4,11,385,'M','6','8',53),(17840,4,11,385,'M','6','9',53),(17841,4,11,385,'10','7','1',53),(17842,4,11,385,'10','7','2',53),(17843,4,11,385,'10','7','3',53),(17844,4,11,385,'10','7','4',53),(17845,4,11,385,'3','7','5',53),(17846,4,11,385,'M','7','6',53),(17847,4,11,385,'M','7','7',53),(17848,4,11,385,'M','7','8',53),(17849,4,11,385,'M','7','9',53),(17850,4,11,67,'10','1','1',53),(17851,4,11,67,'10','1','2',53),(17852,4,11,67,'10','1','3',53),(17853,4,11,67,'5','1','4',53),(17854,4,11,67,'M','1','5',53),(17855,4,11,67,'M','1','6',53),(17856,4,11,67,'M','1','7',53),(17857,4,11,67,'M','1','8',53),(17858,4,11,67,'M','1','9',53),(17859,4,11,67,'10','2','1',53),(17860,4,11,67,'10','2','2',53),(17861,4,11,67,'10','2','3',53),(17862,4,11,67,'10','2','4',53),(17863,4,11,67,'2','2','5',53),(17864,4,11,67,'M','2','6',53),(17865,4,11,67,'M','2','7',53),(17866,4,11,67,'M','2','8',53),(17867,4,11,67,'M','2','9',53),(17868,4,11,67,'10','3','1',53),(17869,4,11,67,'10','3','2',53),(17870,4,11,67,'10','3','3',53),(17871,4,11,67,'10','3','4',53),(17872,4,11,67,'8','3','5',53),(17873,4,11,67,'M','3','6',53),(17874,4,11,67,'M','3','7',53),(17875,4,11,67,'M','3','8',53),(17876,4,11,67,'M','3','9',53),(17877,4,11,67,'10','4','1',53),(17878,4,11,67,'10','4','2',53),(17879,4,11,67,'10','4','3',53),(17880,4,11,67,'10','4','4',53),(17881,4,11,67,'6','4','5',53),(17882,4,11,67,'M','4','6',53),(17883,4,11,67,'M','4','7',53),(17884,4,11,67,'M','4','8',53),(17885,4,11,67,'M','4','9',53),(17886,4,11,67,'10','5','1',53),(17887,4,11,67,'10','5','2',53),(17888,4,11,67,'10','5','3',53),(17889,4,11,67,'10','5','4',53),(17890,4,11,67,'4','5','5',53),(17891,4,11,67,'M','5','6',53),(17892,4,11,67,'M','5','7',53),(17893,4,11,67,'M','5','8',53),(17894,4,11,67,'M','5','9',53),(17895,4,11,67,'10','6','1',53),(17896,4,11,67,'10','6','2',53),(17897,4,11,67,'10','6','3',53),(17898,4,11,67,'10','6','4',53),(17899,4,11,67,'6','6','5',53),(17900,4,11,67,'M','6','6',53),(17901,4,11,67,'M','6','7',53),(17902,4,11,67,'M','6','8',53),(17903,4,11,67,'M','6','9',53),(17904,4,11,67,'10','7','1',53),(17905,4,11,67,'10','7','2',53),(17906,4,11,67,'10','7','3',53),(17907,4,11,67,'10','7','4',53),(17908,4,11,67,'10','7','5',53),(17909,4,11,67,'10','7','6',53),(17910,4,11,67,'8','7','7',53),(17911,4,11,67,'M','7','8',53),(17912,4,11,67,'M','7','9',53),(17913,4,11,386,'10','1','1',53),(17914,4,11,386,'10','1','2',53),(17915,4,11,386,'10','1','3',53),(17916,4,11,386,'10','1','4',53),(17917,4,11,386,'5','1','5',53),(17918,4,11,386,'M','1','6',53),(17919,4,11,386,'M','1','7',53),(17920,4,11,386,'M','1','8',53),(17921,4,11,386,'M','1','9',53),(17922,4,11,386,'10','2','1',53),(17923,4,11,386,'10','2','2',53),(17924,4,11,386,'10','2','3',53),(17925,4,11,386,'10','2','4',53),(17926,4,11,386,'10','2','5',53),(17927,4,11,386,'4','2','6',53),(17928,4,11,386,'M','2','7',53),(17929,4,11,386,'M','2','8',53),(17930,4,11,386,'M','2','9',53),(17931,4,11,386,'10','3','1',53),(17932,4,11,386,'10','3','2',53),(17933,4,11,386,'10','3','3',53),(17934,4,11,386,'4','3','4',53),(17935,4,11,386,'M','3','5',53),(17936,4,11,386,'M','3','6',53),(17937,4,11,386,'M','3','7',53),(17938,4,11,386,'M','3','8',53),(17939,4,11,386,'M','3','9',53),(17940,4,11,386,'10','4','2',53),(17941,4,11,386,'10','4','3',53),(17942,4,11,386,'10','4','4',53),(17943,4,11,386,'8','4','5',53),(17944,4,11,386,'M','4','6',53),(17945,4,11,386,'M','4','7',53),(17946,4,11,386,'M','4','8',53),(17947,4,11,386,'M','4','9',53),(17948,4,11,386,'10','5','1',53),(17949,4,11,386,'10','5','2',53),(17950,4,11,386,'10','5','3',53),(17951,4,11,386,'10','5','4',53),(17952,4,11,386,'8','5','5',53),(17953,4,11,386,'M','5','6',53),(17954,4,11,386,'M','5','7',53),(17955,4,11,386,'M','5','8',53),(17956,4,11,386,'M','5','9',53),(17957,4,11,386,'10','6','1',53),(17958,4,11,386,'10','6','2',53),(17959,4,11,386,'10','6','3',53),(17960,4,11,386,'10','6','4',53),(17961,4,11,386,'M','6','5',53),(17962,4,11,386,'M','6','6',53),(17963,4,11,386,'M','6','7',53),(17964,4,11,386,'M','6','8',53),(17965,4,11,386,'M','6','9',53),(17966,4,11,386,'10','7','1',53),(17967,4,11,386,'10','7','2',53),(17968,4,11,386,'10','7','3',53),(17969,4,11,386,'10','7','4',53),(17970,4,11,386,'9','7','5',53),(17971,4,11,386,'M','7','6',53),(17972,4,11,386,'M','7','7',53),(17973,4,11,386,'M','7','8',53),(17974,4,11,386,'M','7','9',53),(17975,4,11,387,'10','1','1',53),(17976,4,11,387,'10','1','2',53),(17977,4,11,387,'10','1','3',53),(17978,4,11,387,'10','1','4',53),(17979,4,11,387,'10','1','5',53),(17980,4,11,387,'M','1','6',53),(17981,4,11,387,'M','1','7',53),(17982,4,11,387,'M','1','8',53),(17983,4,11,387,'M','1','9',53),(17984,4,11,387,'10','2','1',53),(17985,4,11,387,'10','2','2',53),(17986,4,11,387,'10','2','3',53),(17987,4,11,387,'10','2','4',53),(17988,4,11,387,'7','2','5',53),(17989,4,11,387,'M','2','6',53),(17990,4,11,387,'M','2','7',53),(17991,4,11,387,'M','2','8',53),(17992,4,11,387,'M','2','9',53),(17993,4,11,387,'10','3','1',53),(17994,4,11,387,'10','3','2',53),(17995,4,11,387,'10','3','3',53),(17996,4,11,387,'10','3','4',53),(17997,4,11,387,'10','3','5',53),(17998,4,11,387,'1','3','6',53),(17999,4,11,387,'M','3','7',53),(18000,4,11,387,'M','3','8',53),(18001,4,11,387,'M','3','9',53),(18002,4,11,387,'10','4','1',53),(18003,4,11,387,'10','4','2',53),(18004,4,11,387,'10','4','3',53),(18005,4,11,387,'10','4','4',53),(18006,4,11,387,'10','4','5',53),(18007,4,11,387,'M','4','6',53),(18008,4,11,387,'M','4','7',53),(18009,4,11,387,'M','4','8',53),(18010,4,11,387,'M','4','9',53),(18011,4,11,387,'10','5','1',53),(18012,4,11,387,'10','5','2',53),(18013,4,11,387,'10','5','3',53),(18014,4,11,387,'9','5','4',53),(18015,4,11,387,'M','5','5',53),(18016,4,11,387,'M','5','6',53),(18017,4,11,387,'M','5','7',53),(18018,4,11,387,'M','5','8',53),(18019,4,11,387,'M','5','9',53),(18020,4,11,387,'10','6','1',53),(18021,4,11,387,'10','6','2',53),(18022,4,11,387,'10','6','3',53),(18023,4,11,387,'4','6','4',53),(18024,4,11,387,'M','6','5',53),(18025,4,11,387,'M','6','6',53),(18026,4,11,387,'M','6','7',53),(18027,4,11,387,'M','6','8',53),(18028,4,11,387,'M','6','9',53),(18029,4,11,387,'10','7','1',53),(18030,4,11,387,'10','7','2',53),(18031,4,11,387,'10','7','3',53),(18032,4,11,387,'10','7','4',53),(18033,4,11,387,'6','7','5',53),(18034,4,11,387,'M','7','6',53),(18035,4,11,387,'M','7','7',53),(18036,4,11,387,'M','7','8',53),(18037,4,11,387,'M','7','9',53),(18038,4,11,388,'10','1','1',53),(18039,4,11,388,'10','1','2',53),(18040,4,11,388,'10','1','3',53),(18041,4,11,388,'10','1','4',53),(18042,4,11,388,'1','1','5',53),(18043,4,11,388,'M','1','6',53),(18044,4,11,388,'M','1','7',53),(18045,4,11,388,'M','1','8',53),(18046,4,11,388,'M','1','9',53),(18047,4,11,388,'10','2','1',53),(18048,4,11,388,'10','2','2',53),(18049,4,11,388,'10','2','3',53),(18050,4,11,388,'10','2','4',53),(18051,4,11,388,'10','2','5',53),(18052,4,11,388,'5','2','6',53),(18053,4,11,388,'M','2','7',53),(18054,4,11,388,'M','2','8',53),(18055,4,11,388,'M','2','9',53),(18056,4,11,388,'10','3','1',53),(18057,4,11,388,'10','3','2',53),(18058,4,11,388,'10','3','3',53),(18059,4,11,388,'M','3','4',53),(18060,4,11,388,'M','3','5',53),(18061,4,11,388,'M','3','6',53),(18062,4,11,388,'M','3','7',53),(18063,4,11,388,'M','3','8',53),(18064,4,11,388,'M','3','9',53),(18065,4,11,388,'10','4','1',53),(18066,4,11,388,'10','4','2',53),(18067,4,11,388,'10','4','3',53),(18068,4,11,388,'10','4','4',53),(18069,4,11,388,'2','4','5',53),(18070,4,11,388,'M','4','6',53),(18071,4,11,388,'M','4','7',53),(18072,4,11,388,'M','4','8',53),(18073,4,11,388,'M','4','9',53),(18074,4,11,388,'10','5','1',53),(18075,4,11,388,'10','5','2',53),(18076,4,11,388,'10','5','3',53),(18077,4,11,388,'5','5','4',53),(18078,4,11,388,'M','5','5',53),(18079,4,11,388,'M','5','6',53),(18080,4,11,388,'M','5','7',53),(18081,4,11,388,'M','5','8',53),(18082,4,11,388,'M','5','9',53),(18083,4,11,388,'10','6','1',53),(18084,4,11,388,'10','6','2',53),(18085,4,11,388,'10','6','3',53),(18086,4,11,388,'8','6','4',53),(18087,4,11,388,'M','6','5',53),(18088,4,11,388,'M','6','6',53),(18089,4,11,388,'M','6','7',53),(18090,4,11,388,'M','6','8',53),(18091,4,11,388,'M','6','9',53),(18092,4,11,388,'10','7','1',53),(18093,4,11,388,'10','7','2',53),(18094,4,11,388,'10','7','3',53),(18095,4,11,388,'M','7','4',53),(18096,4,11,388,'M','7','5',53),(18097,4,11,388,'M','7','6',53),(18098,4,11,388,'M','7','7',53),(18099,4,11,388,'M','7','8',53),(18100,4,11,388,'M','7','9',53),(18101,8,11,460,'10','1','1',55),(18102,8,11,460,'10','1','2',55),(18103,8,11,460,'10','1','3',55),(18104,8,11,460,'10','1','4',55),(18105,8,11,460,'10','1','5',55),(18106,8,11,460,'10','1','6',55),(18107,8,11,460,'10','1','7',55),(18108,8,11,460,'10','1','8',55),(18109,8,11,460,'3','1','9',55),(18110,8,11,460,'10','2','1',55),(18111,8,11,460,'10','2','2',55),(18112,8,11,460,'10','2','3',55),(18113,8,11,460,'10','2','4',55),(18114,8,11,460,'10','2','5',55),(18115,8,11,460,'10','2','6',55),(18116,8,11,460,'10','2','7',55),(18117,8,11,460,'10','2','8',55),(18118,8,11,460,'1','2','9',55),(18119,8,11,460,'10','3','1',55),(18120,8,11,460,'10','3','2',55),(18121,8,11,460,'10','3','3',55),(18122,8,11,460,'10','3','4',55),(18123,8,11,460,'10','3','5',55),(18124,8,11,460,'10','3','6',55),(18125,8,11,460,'10','3','7',55),(18126,8,11,460,'10','3','8',55),(18127,8,11,460,'6','3','9',55),(18128,8,11,460,'10','4','1',55),(18130,8,11,460,'10','4','3',55),(18131,8,11,460,'10','4','2',55),(18132,8,11,460,'10','4','4',55),(18133,8,11,460,'10','4','5',55),(18134,8,11,460,'10','4','6',55),(18135,8,11,460,'10','4','7',55),(18136,8,11,460,'10','4','8',55),(18137,8,11,460,'5','4','9',55),(18138,8,11,460,'10','5','1',55),(18139,8,11,460,'10','5','2',55),(18140,8,11,460,'10','5','3',55),(18141,8,11,460,'10','5','4',55),(18142,8,11,460,'10','5','5',55),(18143,8,11,460,'10','5','6',55),(18144,8,11,460,'10','5','7',55),(18145,8,11,460,'10','5','8',55),(18146,8,11,460,'4','5','9',55),(18147,8,11,460,'10','6','1',55),(18148,8,11,460,'10','6','2',55),(18149,8,11,460,'10','6','3',55),(18150,8,11,460,'10','6','4',55),(18151,8,11,460,'10','6','5',55),(18152,8,11,460,'10','6','6',55),(18153,8,11,460,'10','6','7',55),(18154,8,11,460,'10','6','8',55),(18155,8,11,460,'3','6','9',55),(18156,8,11,460,'10','7','1',55),(18157,8,11,460,'10','7','2',55),(18158,8,11,460,'10','7','3',55),(18159,8,11,460,'10','7','4',55),(18160,8,11,460,'10','7','5',55),(18161,8,11,460,'10','7','6',55),(18162,8,11,460,'10','7','7',55),(18163,8,11,460,'10','7','8',55),(18164,8,11,460,'3','7','9',55),(18165,8,11,461,'10','1','1',55),(18166,8,11,461,'10','1','2',55),(18167,8,11,461,'10','1','3',55),(18168,8,11,461,'10','1','4',55),(18169,8,11,461,'10','1','5',55),(18170,8,11,461,'10','1','6',55),(18171,8,11,461,'10','1','7',55),(18172,8,11,461,'10','1','8',55),(18173,8,11,461,'m','1','9',55),(18174,8,11,461,'10','2','1',55),(18175,8,11,461,'10','2','2',55),(18176,8,11,461,'10','2','3',55),(18178,8,11,461,'10','2','4',55),(18179,8,11,461,'10','2','5',55),(18180,8,11,461,'10','2','6',55),(18181,8,11,461,'10','2','7',55),(18182,8,11,461,'10','2','8',55),(18183,8,11,461,'5','2','9',55),(18184,8,11,461,'10','3','1',55),(18185,8,11,461,'10','3','2',55),(18186,8,11,461,'10','3','3',55),(18187,8,11,461,'10','3','4',55),(18189,8,11,461,'10','3','6',55),(18191,8,11,461,'10','3','5',55),(18192,8,11,461,'7','3','8',55),(18193,8,11,461,'10','3','7',55),(18194,8,11,461,'M','3','9',55),(18195,8,11,461,'10','4','1',55),(18196,8,11,461,'10','4','2',55),(18197,8,11,461,'10','4','3',55),(18198,8,11,461,'10','4','4',55),(18199,8,11,461,'10','4','5',55),(18200,8,11,461,'10','4','6',55),(18201,8,11,461,'10','4','7',55),(18202,8,11,461,'10','4','8',55),(18203,8,11,461,'2','4','9',55),(18204,8,11,461,'10','5','1',55),(18205,8,11,461,'10','5','2',55),(18206,8,11,461,'10','5','3',55),(18207,8,11,461,'10','5','4',55),(18208,8,11,461,'10','5','5',55),(18209,8,11,461,'10','5','6',55),(18210,8,11,461,'10','5','7',55),(18211,8,11,461,'10','5','8',55),(18212,8,11,461,'2','5','9',55),(18213,8,11,461,'10','6','1',55),(18214,8,11,461,'10','6','2',55),(18215,8,11,461,'10','6','3',55),(18216,8,11,461,'10','6','4',55),(18217,8,11,461,'10','6','5',55),(18218,8,11,461,'10','6','6',55),(18219,8,11,461,'10','6','7',55),(18220,8,11,461,'10','6','8',55),(18221,8,11,461,'2','6','9',55),(18222,8,11,461,'10','7','1',55),(18223,8,11,461,'10','7','2',55),(18224,8,11,461,'10','7','3',55),(18225,8,11,461,'10','7','4',55),(18226,8,11,461,'10','7','5',55),(18227,8,11,461,'10','7','6',55),(18228,8,11,461,'10','7','7',55),(18229,8,11,461,'10','7','8',55),(18230,8,11,461,'5','7','9',55),(18231,8,11,462,'10','1','1',55),(18232,8,11,462,'10','1','2',55),(18233,8,11,462,'10','1','3',55),(18234,8,11,462,'10','1','4',55),(18235,8,11,462,'10','1','5',55),(18236,8,11,462,'10','1','6',55),(18237,8,11,462,'10','1','7',55),(18238,8,11,462,'10','1','8',55),(18239,8,11,462,'3','1','9',55),(18240,8,11,462,'10','2','1',55),(18241,8,11,462,'10','2','2',55),(18242,8,11,462,'10','2','3',55),(18243,8,11,462,'10','2','4',55),(18244,8,11,462,'10','2','5',55),(18245,8,11,462,'10','2','6',55),(18246,8,11,462,'10','2','7',55),(18247,8,11,462,'7','2','8',55),(18248,8,11,462,'M','2','9',55),(18249,8,11,462,'10','3','1',55),(18250,8,11,462,'10','3','2',55),(18252,8,11,462,'10','3','4',55),(18253,8,11,462,'10','3','5',55),(18254,8,11,462,'10','3','6',55),(18255,8,11,462,'10','3','7',55),(18256,8,11,462,'10','3','8',55),(18257,8,11,462,'2','3','9',55),(18258,8,11,462,'10','4','1',55),(18259,8,11,462,'10','4','2',55),(18260,8,11,462,'10','4','3',55),(18261,8,11,462,'10','4','4',55),(18262,8,11,462,'10','4','5',55),(18263,8,11,462,'10','4','6',55),(18264,8,11,462,'10','4','7',55),(18265,8,11,462,'9','4','8',55),(18266,8,11,462,'M','4','9',55),(18267,8,11,462,'10','3','3',55),(18268,8,11,462,'10','5','1',55),(18269,8,11,462,'10','5','2',55),(18270,8,11,462,'10','5','3',55),(18271,8,11,462,'10','5','4',55),(18272,8,11,462,'10','5','5',55),(18273,8,11,462,'10','5','6',55),(18274,8,11,462,'10','5','7',55),(18275,8,11,462,'10','5','8',55),(18276,8,11,462,'1','5','9',55),(18277,8,11,462,'10','6','1',55),(18278,8,11,462,'10','6','2',55),(18279,8,11,462,'10','6','3',55),(18280,8,11,462,'10','6','4',55),(18281,8,11,462,'10','6','5',55),(18282,8,11,462,'10','6','6',55),(18283,8,11,462,'10','6','7',55),(18284,8,11,462,'10','6','8',55),(18285,8,11,462,'2','6','9',55),(18286,8,11,462,'10','7','1',55),(18287,8,11,462,'10','7','2',55),(18289,8,11,462,'10','7','3',55),(18290,8,11,462,'10','7','4',55),(18291,8,11,462,'10','7','5',55),(18292,8,11,462,'10','7','6',55),(18293,8,11,462,'10','7','7',55),(18294,8,11,462,'10','7','8',55),(18295,8,11,462,'6','7','9',55),(18296,8,11,463,'10','1','1',55),(18297,8,11,463,'10','1','2',55),(18298,8,11,463,'10','1','3',55),(18299,8,11,463,'10','1','4',55),(18300,8,11,463,'10','1','5',55),(18301,8,11,463,'10','1','6',55),(18302,8,11,463,'10','1','7',55),(18303,8,11,463,'10','1','8',55),(18304,8,11,463,'3','1','9',55),(18305,8,11,463,'10','2','1',55),(18306,8,11,463,'10','2','2',55),(18307,8,11,463,'10','2','3',55),(18308,8,11,463,'10','2','4',55),(18309,8,11,463,'10','2','5',55),(18310,8,11,463,'10','2','6',55),(18311,8,11,463,'10','2','7',55),(18312,8,11,463,'10','2','8',55),(18313,8,11,463,'5','2','9',55),(18314,8,11,463,'10','3','1',55),(18315,8,11,463,'10','3','2',55),(18316,8,11,463,'10','3','3',55),(18318,8,11,463,'10','3','5',55),(18319,8,11,463,'10','3','4',55),(18320,8,11,463,'10','3','6',55),(18321,8,11,463,'10','3','7',55),(18322,8,11,463,'9','3','8',55),(18323,8,11,463,'M','3','9',55),(18324,8,11,463,'10','4','1',55),(18325,8,11,463,'10','4','2',55),(18326,8,11,463,'10','4','3',55),(18328,8,11,463,'10','4','4',55),(18329,8,11,463,'10','4','5',55),(18330,8,11,463,'10','4','6',55),(18331,8,11,463,'10','4','7',55),(18332,8,11,463,'6','4','8',55),(18333,8,11,463,'M','4','9',55),(18334,8,11,463,'10','5','1',55),(18335,8,11,463,'10','5','2',55),(18336,8,11,463,'10','5','3',55),(18337,8,11,463,'10','5','4',55),(18338,8,11,463,'10','5','5',55),(18339,8,11,463,'10','5','6',55),(18340,8,11,463,'10','5','7',55),(18341,8,11,463,'10','5','8',55),(18342,8,11,463,'5','5','9',55),(18343,8,11,463,'10','6','1',55),(18344,8,11,463,'10','6','2',55),(18345,8,11,463,'10','6','3',55),(18346,8,11,463,'10','6','4',55),(18347,8,11,463,'10','6','5',55),(18348,8,11,463,'10','6','6',55),(18349,8,11,463,'10','6','7',55),(18350,8,11,463,'8','6','8',55),(18351,8,11,463,'M','6','9',55),(18352,8,11,463,'10','7','1',55),(18353,8,11,463,'10','7','2',55),(18354,8,11,463,'10','7','3',55),(18355,8,11,463,'10','7','4',55),(18356,8,11,463,'10','7','5',55),(18357,8,11,463,'10','7','6',55),(18358,8,11,463,'10','7','7',55),(18359,8,11,463,'10','7','8',55),(18360,8,11,463,'4','7','9',55),(18361,8,11,464,'10','1','1',55),(18362,8,11,464,'10','1','2',55),(18363,8,11,464,'10','1','3',55),(18364,8,11,464,'10','1','4',55),(18365,8,11,464,'10','1','5',55),(18366,8,11,464,'10','1','6',55),(18367,8,11,464,'10','1','7',55),(18368,8,11,464,'10','1','8',55),(18369,8,11,464,'1','1','9',55),(18370,8,11,464,'10','2','1',55),(18371,8,11,464,'10','2','2',55),(18372,8,11,464,'10','2','3',55),(18373,8,11,464,'10','2','4',55),(18374,8,11,464,'10','2','5',55),(18375,8,11,464,'10','2','6',55),(18376,8,11,464,'10','2','7',55),(18377,8,11,464,'6','2','8',55),(18378,8,11,464,'M','2','9',55),(18379,8,11,464,'10','3','1',55),(18380,8,11,464,'10','3','2',55),(18381,8,11,464,'10','3','3',55),(18382,8,11,464,'10','3','4',55),(18383,8,11,464,'10','3','5',55),(18384,8,11,464,'10','3','6',55),(18385,8,11,464,'10','3','7',55),(18386,8,11,464,'10','3','8',55),(18387,8,11,464,'2','3','9',55),(18388,8,11,464,'10','4','1',55),(18389,8,11,464,'10','4','2',55),(18390,8,11,464,'10','4','3',55),(18391,8,11,464,'10','4','4',55),(18392,8,11,464,'10','4','5',55),(18393,8,11,464,'10','4','6',55),(18394,8,11,464,'10','4','7',55),(18395,8,11,464,'9','4','8',55),(18396,8,11,464,'M','4','9',55),(18397,8,11,464,'10','5','1',55),(18398,8,11,464,'10','5','2',55),(18399,8,11,464,'10','5','3',55),(18400,8,11,464,'10','5','4',55),(18401,8,11,464,'10','5','5',55),(18402,8,11,464,'10','5','6',55),(18403,8,11,464,'10','5','7',55),(18404,8,11,464,'9','5','8',55),(18405,8,11,464,'M','5','9',55),(18406,8,11,464,'10','6','1',55),(18407,8,11,464,'10','6','2',55),(18408,8,11,464,'10','6','3',55),(18409,8,11,464,'10','6','4',55),(18410,8,11,464,'10','6','5',55),(18411,8,11,464,'10','6','6',55),(18412,8,11,464,'10','6','7',55),(18413,8,11,464,'9','6','8',55),(18414,8,11,464,'M','6','9',55),(18415,8,11,464,'10','7','1',55),(18416,8,11,464,'10','7','2',55),(18417,8,11,464,'10','7','3',55),(18418,8,11,464,'10','7','4',55),(18419,8,11,464,'10','7','5',55),(18420,8,11,464,'10','7','6',55),(18421,8,11,464,'10','7','7',55),(18422,8,11,464,'8','7','8',55),(18423,8,11,464,'M','7','9',55),(18424,8,11,465,'10','1','1',55),(18425,8,11,465,'10','1','2',55),(18427,8,11,465,'10','1','3',55),(18428,8,11,465,'10','1','4',55),(18429,8,11,465,'10','1','5',55),(18430,8,11,465,'10','1','6',55),(18431,8,11,465,'10','1','7',55),(18432,8,11,465,'10','1','8',55),(18433,8,11,465,'M','1','9',55),(18434,8,11,465,'10','2','1',55),(18435,8,11,465,'10','2','2',55),(18436,8,11,465,'10','2','3',55),(18437,8,11,465,'10','2','4',55),(18438,8,11,465,'10','2','5',55),(18439,8,11,465,'10','2','6',55),(18440,8,11,465,'10','2','7',55),(18441,8,11,465,'10','2','8',55),(18442,8,11,465,'1','2','9',55),(18443,8,11,465,'10','3','1',55),(18444,8,11,465,'10','3','2',55),(18445,8,11,465,'10','3','3',55),(18446,8,11,465,'10','3','4',55),(18447,8,11,465,'10','3','5',55),(18448,8,11,465,'10','3','6',55),(18449,8,11,465,'5','3','7',55),(18450,8,11,465,'M','3','8',55),(18451,8,11,465,'M','3','9',55),(18452,8,11,465,'10','4','1',55),(18453,8,11,465,'10','4','2',55),(18454,8,11,465,'10','4','3',55),(18455,8,11,465,'10','4','4',55),(18456,8,11,465,'10','4','5',55),(18457,8,11,465,'10','4','6',55),(18458,8,11,465,'10','4','7',55),(18459,8,11,465,'10','4','8',55),(18460,8,11,465,'3','4','9',55),(18461,8,11,465,'10','5','1',55),(18462,8,11,465,'10','5','2',55),(18463,8,11,465,'10','5','3',55),(18465,8,11,465,'10','5','5',55),(18466,8,11,465,'10','5','6',55),(18467,8,11,465,'10','5','7',55),(18468,8,11,465,'10','5','8',55),(18469,8,11,465,'1','5','9',55),(18470,8,11,465,'10','5','4',55),(18471,8,11,465,'10','6','1',55),(18472,8,11,465,'10','6','2',55),(18473,8,11,465,'10','6','3',55),(18474,8,11,465,'10','6','4',55),(18475,8,11,465,'10','6','5',55),(18476,8,11,465,'10','6','6',55),(18477,8,11,465,'10','6','7',55),(18478,8,11,465,'10','6','8',55),(18479,8,11,465,'M','6','9',55),(18480,8,11,465,'10','7','1',55),(18481,8,11,465,'10','7','2',55),(18482,8,11,465,'10','7','3',55),(18483,8,11,465,'10','7','4',55),(18484,8,11,465,'10','7','5',55),(18485,8,11,465,'10','7','6',55),(18486,8,11,465,'10','7','7',55),(18487,8,11,465,'10','7','8',55),(18488,8,11,465,'M','7','9',55),(18489,8,11,466,'10','1','1',55),(18490,8,11,466,'10','1','2',55),(18491,8,11,466,'10','1','3',55),(18492,8,11,466,'10','1','4',55),(18493,8,11,466,'10','1','5',55),(18494,8,11,466,'10','1','6',55),(18495,8,11,466,'10','1','7',55),(18496,8,11,466,'4','1','8',55),(18497,8,11,466,'M','1','9',55),(18498,8,11,466,'10','2','1',55),(18499,8,11,466,'10','2','2',55),(18500,8,11,466,'10','2','3',55),(18501,8,11,466,'10','2','4',55),(18502,8,11,466,'10','2','5',55),(18503,8,11,466,'10','2','6',55),(18504,8,11,466,'10','2','7',55),(18505,8,11,466,'5','2','8',55),(18506,8,11,466,'M','2','9',55),(18507,8,11,466,'10','3','1',55),(18508,8,11,466,'10','3','2',55),(18509,8,11,466,'10','3','3',55),(18510,8,11,466,'10','3','4',55),(18511,8,11,466,'10','3','5',55),(18512,8,11,466,'10','3','6',55),(18513,8,11,466,'10','3','7',55),(18514,8,11,466,'6','3','8',55),(18515,8,11,466,'M','3','9',55),(18516,8,11,466,'10','4','1',55),(18517,8,11,466,'10','4','2',55),(18518,8,11,466,'10','4','3',55),(18519,8,11,466,'10','4','4',55),(18520,8,11,466,'10','4','5',55),(18521,8,11,466,'10','4','6',55),(18522,8,11,466,'10','4','7',55),(18523,8,11,466,'6','4','8',55),(18524,8,11,466,'M','4','9',55),(18525,8,11,466,'10','5','1',55),(18526,8,11,466,'10','5','2',55),(18527,8,11,466,'10','5','3',55),(18528,8,11,466,'10','5','4',55),(18529,8,11,466,'10','5','5',55),(18530,8,11,466,'10','5','6',55),(18531,8,11,466,'10','5','7',55),(18532,8,11,466,'10','5','8',55),(18533,8,11,466,'4','5','9',55),(18534,8,11,466,'10','6','1',55),(18535,8,11,466,'10','6','2',55),(18536,8,11,466,'10','6','3',55),(18537,8,11,466,'10','6','4',55),(18538,8,11,466,'10','6','5',55),(18539,8,11,466,'10','6','6',55),(18540,8,11,466,'10','6','7',55),(18541,8,11,466,'10','6','8',55),(18542,8,11,466,'3','6','9',55),(18543,8,11,466,'10','7','1',55),(18544,8,11,466,'10','7','2',55),(18545,8,11,466,'10','7','3',55),(18546,8,11,466,'10','7','4',55),(18547,8,11,466,'10','7','5',55),(18548,8,11,466,'10','7','6',55),(18549,8,11,466,'10','7','7',55),(18550,8,11,466,'10','7','8',55),(18551,8,11,466,'M','7','9',55),(18552,8,11,467,'10','1','1',55),(18553,8,11,467,'10','1','2',55),(18554,8,11,467,'10','1','3',55),(18555,8,11,467,'10','1','4',55),(18556,8,11,467,'10','1','5',55),(18557,8,11,467,'10','1','6',55),(18558,8,11,467,'10','1','7',55),(18559,8,11,467,'10','1','8',55),(18560,8,11,467,'5','1','9',55),(18561,8,11,467,'10','2','1',55),(18562,8,11,467,'10','2','2',55),(18563,8,11,467,'10','2','3',55),(18564,8,11,467,'10','2','4',55),(18565,8,11,467,'10','2','5',55),(18566,8,11,467,'10','2','6',55),(18567,8,11,467,'10','2','7',55),(18568,8,11,467,'10','2','8',55),(18569,8,11,467,'M','2','9',55),(18570,8,11,467,'10','3','1',55),(18571,8,11,467,'10','3','2',55),(18572,8,11,467,'10','3','3',55),(18573,8,11,467,'10','3','4',55),(18575,8,11,467,'10','3','6',55),(18576,8,11,467,'10','3','7',55),(18577,8,11,467,'1','3','8',55),(18578,8,11,467,'M','3','9',55),(18579,8,11,467,'10','3','5',55),(18580,8,11,467,'10','4','1',55),(18581,8,11,467,'10','4','2',55),(18582,8,11,467,'10','4','3',55),(18583,8,11,467,'10','4','4',55),(18584,8,11,467,'10','4','5',55),(18585,8,11,467,'10','4','6',55),(18586,8,11,467,'10','4','7',55),(18587,8,11,467,'10','4','8',55),(18588,8,11,467,'M','4','9',55),(18589,8,11,467,'10','5','1',55),(18590,8,11,467,'10','5','2',55),(18591,8,11,467,'10','5','3',55),(18592,8,11,467,'10','5','4',55),(18593,8,11,467,'10','5','5',55),(18594,8,11,467,'10','5','6',55),(18595,8,11,467,'10','5','7',55),(18596,8,11,467,'2','5','8',55),(18597,8,11,467,'M','5','9',55),(18598,8,11,467,'10','6','1',55),(18599,8,11,467,'10','6','2',55),(18600,8,11,467,'10','6','3',55),(18601,8,11,467,'10','6','4',55),(18602,8,11,467,'10','6','5',55),(18603,8,11,467,'10','6','6',55),(18604,8,11,467,'10','6','7',55),(18605,8,11,467,'7','6','8',55),(18606,8,11,467,'M','6','9',55),(18607,8,11,467,'10','7','1',55),(18608,8,11,467,'10','7','2',55),(18609,8,11,467,'10','7','3',55),(18610,8,11,467,'10','7','4',55),(18611,8,11,467,'10','7','5',55),(18612,8,11,467,'10','7','6',55),(18613,8,11,467,'10','7','7',55),(18614,8,11,467,'8','7','8',55),(18615,8,11,467,'M','7','9',55),(18616,8,11,468,'10','1','1',55),(18618,8,11,468,'10','1','3',55),(18619,8,11,468,'10','1','2',55),(18620,8,11,468,'10','1','4',55),(18621,8,11,468,'10','1','5',55),(18622,8,11,468,'10','1','6',55),(18623,8,11,468,'10','1','7',55),(18624,8,11,468,'5','1','8',55),(18625,8,11,468,'M','1','9',55),(18626,8,11,468,'10','2','1',55),(18627,8,11,468,'10','2','2',55),(18628,8,11,468,'10','2','3',55),(18629,8,11,468,'10','2','4',55),(18630,8,11,468,'10','2','5',55),(18631,8,11,468,'10','2','6',55),(18632,8,11,468,'10','2','7',55),(18633,8,11,468,'4','2','8',55),(18634,8,11,468,'M','2','9',55),(18635,8,11,468,'10','3','1',55),(18636,8,11,468,'10','3','2',55),(18637,8,11,468,'10','3','3',55),(18638,8,11,468,'10','3','4',55),(18640,8,11,468,'10','3','6',55),(18641,8,11,468,'10','3','7',55),(18642,8,11,468,'10','3','8',55),(18643,8,11,468,'M','3','9',55),(18644,8,11,468,'10','3','5',55),(18645,8,11,468,'10','4','1',55),(18646,8,11,468,'10','4','2',55),(18647,8,11,468,'10','4','3',55),(18648,8,11,468,'10','4','4',55),(18649,8,11,468,'10','4','5',55),(18650,8,11,468,'10','4','6',55),(18651,8,11,468,'10','4','7',55),(18652,8,11,468,'4','4','8',55),(18653,8,11,468,'M','4','9',55),(18654,8,11,468,'10','5','1',55),(18655,8,11,468,'10','5','2',55),(18656,8,11,468,'10','5','3',55),(18657,8,11,468,'10','5','4',55),(18658,8,11,468,'10','5','5',55),(18659,8,11,468,'10','5','6',55),(18660,8,11,468,'10','5','7',55),(18661,8,11,468,'10','5','8',55),(18662,8,11,468,'1','5','9',55),(18663,8,11,468,'10','6','1',55),(18664,8,11,468,'10','6','2',55),(18665,8,11,468,'10','6','3',55),(18666,8,11,468,'10','6','4',55),(18667,8,11,468,'10','6','5',55),(18668,8,11,468,'10','6','6',55),(18669,8,11,468,'10','6','7',55),(18670,8,11,468,'8','6','8',55),(18671,8,11,468,'M','6','9',55),(18672,8,11,468,'10','7','1',55),(18673,8,11,468,'10','7','2',55),(18674,8,11,468,'10','7','3',55),(18675,8,11,468,'10','7','4',55),(18676,8,11,468,'10','7','5',55),(18677,8,11,468,'10','7','6',55),(18678,8,11,468,'10','7','7',55),(18679,8,11,468,'3','7','8',55),(18680,8,11,468,'M','7','9',55),(18681,8,11,470,'10','1','1',55),(18682,8,11,470,'10','1','2',55),(18683,8,11,470,'10','1','3',55),(18684,8,11,470,'10','1','4',55),(18685,8,11,470,'10','1','5',55),(18686,8,11,470,'10','1','6',55),(18687,8,11,470,'10','1','7',55),(18688,8,11,470,'10','1','8',55),(18689,8,11,470,'2','1','9',55),(18690,8,11,470,'10','2','1',55),(18691,8,11,470,'10','2','2',55),(18692,8,11,470,'10','2','3',55),(18693,8,11,470,'10','2','4',55),(18694,8,11,470,'10','2','5',55),(18695,8,11,470,'10','2','6',55),(18696,8,11,470,'10','2','7',55),(18697,8,11,470,'M','2','8',55),(18698,8,11,470,'M','2','9',55),(18699,8,11,470,'10','3','1',55),(18700,8,11,470,'10','3','2',55),(18701,8,11,470,'10','3','3',55),(18702,8,11,470,'10','3','4',55),(18703,8,11,470,'10','3','5',55),(18704,8,11,470,'10','3','6',55),(18705,8,11,470,'10','3','7',55),(18706,8,11,470,'6','3','8',55),(18707,8,11,470,'M','3','9',55),(18708,8,11,470,'10','4','1',55),(18709,8,11,470,'10','4','2',55),(18710,8,11,470,'10','4','3',55),(18711,8,11,470,'10','4','4',55),(18712,8,11,470,'10','4','5',55),(18713,8,11,470,'10','4','6',55),(18714,8,11,470,'10','4','7',55),(18715,8,11,470,'2','4','8',55),(18716,8,11,470,'M','4','9',55),(18717,8,11,470,'10','5','1',55),(18718,8,11,470,'10','5','2',55),(18719,8,11,470,'10','5','3',55),(18720,8,11,470,'10','5','4',55),(18721,8,11,470,'10','5','5',55),(18722,8,11,470,'10','5','6',55),(18723,8,11,470,'10','5','7',55),(18724,8,11,470,'3','5','8',55),(18725,8,11,470,'M','5','9',55),(18726,8,11,470,'10','6','1',55),(18727,8,11,470,'10','6','2',55),(18728,8,11,470,'10','6','3',55),(18729,8,11,470,'10','6','4',55),(18730,8,11,470,'10','6','5',55),(18731,8,11,470,'10','6','6',55),(18732,8,11,470,'10','6','7',55),(18733,8,11,470,'7','6','8',55),(18734,8,11,470,'M','6','9',55),(18735,8,11,470,'10','7','1',55),(18736,8,11,470,'10','7','2',55),(18737,8,11,470,'10','7','3',55),(18738,8,11,470,'10','7','4',55),(18739,8,11,470,'10','7','5',55),(18740,8,11,470,'10','7','6',55),(18741,8,11,470,'10','7','7',55),(18742,8,11,470,'10','7','8',55),(18743,8,11,470,'M','7','9',55),(18744,8,11,471,'10','1','1',55),(18745,8,11,471,'10','1','2',55),(18746,8,11,471,'10','1','3',55),(18747,8,11,471,'10','1','4',55),(18748,8,11,471,'10','1','5',55),(18749,8,11,471,'10','1','6',55),(18750,8,11,471,'10','1','7',55),(18751,8,11,471,'9','1','8',55),(18752,8,11,471,'M','1','9',55),(18753,8,11,471,'10','2','1',55),(18754,8,11,471,'10','2','2',55),(18755,8,11,471,'10','2','3',55),(18757,8,11,471,'10','2','5',55),(18758,8,11,471,'10','2','6',55),(18759,8,11,471,'10','2','7',55),(18760,8,11,471,'4','2','8',55),(18761,8,11,471,'M','2','9',55),(18762,8,11,471,'10','3','1',55),(18763,8,11,471,'10','3','2',55),(18764,8,11,471,'10','3','3',55),(18765,8,11,471,'10','3','4',55),(18766,8,11,471,'10','2','4',55),(18767,8,11,471,'10','3','5',55),(18768,8,11,471,'10','3','6',55),(18769,8,11,471,'10','3','7',55),(18770,8,11,471,'4','3','8',55),(18771,8,11,471,'M','3','9',55),(18772,8,11,471,'10','4','1',55),(18773,8,11,471,'10','4','2',55),(18774,8,11,471,'10','4','3',55),(18775,8,11,471,'10','4','4',55),(18776,8,11,471,'10','4','5',55),(18777,8,11,471,'10','4','6',55),(18778,8,11,471,'10','4','7',55),(18779,8,11,471,'4','4','8',55),(18780,8,11,471,'M','4','9',55),(18781,8,11,471,'10','5','1',55),(18782,8,11,471,'10','5','2',55),(18783,8,11,471,'10','5','3',55),(18784,8,11,471,'10','5','4',55),(18785,8,11,471,'10','5','5',55),(18786,8,11,471,'10','5','6',55),(18787,8,11,471,'10','5','7',55),(18788,8,11,471,'8','5','8',55),(18789,8,11,471,'M','5','9',55),(18790,8,11,471,'10','6','1',55),(18791,8,11,471,'10','6','2',55),(18792,8,11,471,'10','6','3',55),(18793,8,11,471,'10','6','4',55),(18794,8,11,471,'10','6','5',55),(18795,8,11,471,'10','6','6',55),(18796,8,11,471,'8','6','7',55),(18797,8,11,471,'M','6','8',55),(18798,8,11,471,'M','6','9',55),(18799,8,11,471,'10','7','1',55),(18800,8,11,471,'10','7','2',55),(18801,8,11,471,'10','7','3',55),(18802,8,11,471,'10','7','4',55),(18803,8,11,471,'10','7','5',55),(18804,8,11,471,'10','7','6',55),(18805,8,11,471,'10','7','7',55),(18806,8,11,471,'10','7','8',55),(18807,8,11,471,'2','7','9',55),(18808,8,11,472,'10','1','1',55),(18809,8,11,472,'10','1','2',55),(18810,8,11,472,'10','1','3',55),(18811,8,11,472,'10','1','4',55),(18812,8,11,472,'10','1','5',55),(18813,8,11,472,'10','1','6',55),(18814,8,11,472,'5','1','7',55),(18815,8,11,472,'M','1','8',55),(18816,8,11,472,'M','1','9',55),(18817,8,11,472,'10','2','1',55),(18818,8,11,472,'10','2','2',55),(18819,8,11,472,'10','2','3',55),(18820,8,11,472,'10','2','4',55),(18821,8,11,472,'10','2','5',55),(18822,8,11,472,'10','2','6',55),(18823,8,11,472,'10','2','7',55),(18824,8,11,472,'9','2','8',55),(18825,8,11,472,'M','2','9',55),(18826,8,11,472,'10','3','1',55),(18827,8,11,472,'10','3','2',55),(18828,8,11,472,'10','3','3',55),(18829,8,11,472,'10','3','4',55),(18830,8,11,472,'10','3','5',55),(18831,8,11,472,'10','3','6',55),(18832,8,11,472,'10','3','7',55),(18833,8,11,472,'10','3','8',55),(18834,8,11,472,'M','3','9',55),(18835,8,11,472,'10','4','1',55),(18836,8,11,472,'10','4','2',55),(18837,8,11,472,'10','4','3',55),(18838,8,11,472,'10','4','4',55),(18839,8,11,472,'10','4','5',55),(18840,8,11,472,'10','4','6',55),(18841,8,11,472,'10','4','7',55),(18842,8,11,472,'6','4','8',55),(18843,8,11,472,'M','4','9',55),(18844,8,11,472,'10','5','1',55),(18845,8,11,472,'10','5','2',55),(18846,8,11,472,'10','5','3',55),(18847,8,11,472,'10','5','4',55),(18848,8,11,472,'10','5','5',55),(18849,8,11,472,'10','5','6',55),(18850,8,11,472,'10','5','7',55),(18851,8,11,472,'9','5','8',55),(18852,8,11,472,'M','5','9',55),(18853,8,11,472,'10','6','1',55),(18854,8,11,472,'10','6','2',55),(18855,8,11,472,'10','6','3',55),(18856,8,11,472,'10','6','4',55),(18857,8,11,472,'10','6','5',55),(18858,8,11,472,'10','6','6',55),(18859,8,11,472,'10','6','7',55),(18860,8,11,472,'8','6','8',55),(18861,8,11,472,'M','6','9',55),(18862,8,11,472,'10','7','1',55),(18863,8,11,472,'10','7','2',55),(18864,8,11,472,'10','7','3',55),(18865,8,11,472,'10','7','4',55),(18866,8,11,472,'10','7','5',55),(18867,8,11,472,'10','7','6',55),(18868,8,11,472,'7','7','7',55),(18869,8,11,472,'M','7','8',55),(18870,8,11,472,'M','7','9',55),(18871,8,11,474,'10','1','2',55),(18872,8,11,474,'10','1','1',55),(18873,8,11,474,'10','1','3',55),(18874,8,11,474,'10','1','4',55),(18875,8,11,474,'10','1','5',55),(18876,8,11,474,'10','1','6',55),(18877,8,11,474,'9','1','7',55),(18878,8,11,474,'M','1','8',55),(18879,8,11,474,'M','1','9',55),(18881,8,11,474,'10','2','2',55),(18882,8,11,474,'10','2','1',55),(18883,8,11,474,'10','2','3',55),(18884,8,11,474,'10','2','4',55),(18885,8,11,474,'10','2','5',55),(18886,8,11,474,'10','2','6',55),(18887,8,11,474,'10','2','7',55),(18888,8,11,474,'8','2','8',55),(18889,8,11,474,'M','2','9',55),(18890,8,11,474,'10','3','1',55),(18891,8,11,474,'10','3','2',55),(18892,8,11,474,'10','3','3',55),(18893,8,11,474,'10','3','4',55),(18894,8,11,474,'10','3','5',55),(18895,8,11,474,'10','3','6',55),(18896,8,11,474,'10','3','7',55),(18897,8,11,474,'5','3','8',55),(18898,8,11,474,'M','3','9',55),(18899,8,11,474,'10','4','1',55),(18900,8,11,474,'10','4','2',55),(18901,8,11,474,'10','4','3',55),(18902,8,11,474,'10','4','4',55),(18903,8,11,474,'10','4','5',55),(18904,8,11,474,'10','4','6',55),(18905,8,11,474,'10','4','7',55),(18906,8,11,474,'5','4','8',55),(18907,8,11,474,'M','4','9',55),(18908,8,11,474,'10','5','1',55),(18909,8,11,474,'10','5','2',55),(18910,8,11,474,'10','5','3',55),(18911,8,11,474,'10','5','4',55),(18912,8,11,474,'10','5','5',55),(18913,8,11,474,'10','5','6',55),(18914,8,11,474,'10','5','7',55),(18915,8,11,474,'M','5','8',55),(18916,8,11,474,'M','5','9',55),(18917,8,11,474,'10','6','1',55),(18918,8,11,474,'10','6','2',55),(18919,8,11,474,'10','6','3',55),(18920,8,11,474,'10','6','4',55),(18921,8,11,474,'10','6','5',55),(18922,8,11,474,'10','6','6',55),(18923,8,11,474,'9','6','7',55),(18924,8,11,474,'M','6','8',55),(18925,8,11,474,'M','6','9',55),(18926,8,11,474,'10','7','1',55),(18927,8,11,474,'10','7','2',55),(18928,8,11,474,'10','7','3',55),(18929,8,11,474,'10','7','4',55),(18931,8,11,474,'10','7','6',55),(18932,8,11,474,'10','7','7',55),(18933,8,11,474,'5','7','8',55),(18934,8,11,474,'M','7','9',55),(18935,8,11,474,'10','7','5',55),(18936,8,11,475,'10','1','1',55),(18937,8,11,475,'10','1','2',55),(18938,8,11,475,'10','1','3',55),(18940,8,11,475,'10','1','4',55),(18941,8,11,475,'10','1','5',55),(18942,8,11,475,'10','1','6',55),(18943,8,11,475,'7','1','7',55),(18944,8,11,475,'M','1','8',55),(18945,8,11,475,'M','1','9',55),(18946,8,11,475,'10','2','1',55),(18947,8,11,475,'10','2','2',55),(18948,8,11,475,'10','2','3',55),(18949,8,11,475,'10','2','4',55),(18950,8,11,475,'10','2','5',55),(18951,8,11,475,'10','2','6',55),(18952,8,11,475,'10','2','7',55),(18953,8,11,475,'2','2','8',55),(18954,8,11,475,'M','2','9',55),(18955,8,11,475,'10','3','1',55),(18956,8,11,475,'10','3','2',55),(18957,8,11,475,'10','3','3',55),(18959,8,11,475,'10','3','5',55),(18960,8,11,475,'10','3','6',55),(18961,8,11,475,'10','3','7',55),(18962,8,11,475,'9','3','8',55),(18963,8,11,475,'M','3','9',55),(18964,8,11,475,'10','3','4',55),(18965,8,11,475,'10','4','1',55),(18966,8,11,475,'10','4','2',55),(18967,8,11,475,'10','4','3',55),(18968,8,11,475,'10','4','4',55),(18969,8,11,475,'10','4','5',55),(18970,8,11,475,'10','4','6',55),(18971,8,11,475,'10','4','7',55),(18972,8,11,475,'6','4','8',55),(18973,8,11,475,'M','4','9',55),(18974,8,11,475,'10','5','1',55),(18975,8,11,475,'10','5','2',55),(18976,8,11,475,'10','5','3',55),(18977,8,11,475,'10','5','4',55),(18978,8,11,475,'10','5','5',55),(18979,8,11,475,'10','5','6',55),(18980,8,11,475,'10','5','7',55),(18981,8,11,475,'4','5','8',55),(18982,8,11,475,'M','5','9',55),(18983,8,11,475,'10','6','1',55),(18984,8,11,475,'10','6','2',55),(18985,8,11,475,'10','6','3',55),(18986,8,11,475,'10','6','4',55),(18987,8,11,475,'10','6','5',55),(18988,8,11,475,'10','6','6',55),(18989,8,11,475,'10','6','7',55),(18990,8,11,475,'4','6','8',55),(18991,8,11,475,'M','6','9',55),(18992,8,11,475,'10','7','1',55),(18993,8,11,475,'10','7','2',55),(18994,8,11,475,'10','7','3',55),(18996,8,11,475,'10','7','5',55),(18997,8,11,475,'10','7','6',55),(18998,8,11,475,'8','7','7',55),(19000,8,11,475,'10','7','4',55),(19001,8,11,475,'M','7','8',55),(19002,8,11,475,'M','7','9',55),(19003,8,11,477,'10','1','1',55),(19004,8,11,477,'10','1','2',55),(19005,8,11,477,'10','1','3',55),(19006,8,11,477,'10','1','4',55),(19007,8,11,477,'10','1','5',55),(19008,8,11,477,'10','1','6',55),(19009,8,11,477,'10','1','7',55),(19010,8,11,477,'1','1','8',55),(19011,8,11,477,'M','1','9',55),(19012,8,11,477,'10','2','1',55),(19013,8,11,477,'10','2','2',55),(19014,8,11,477,'10','2','3',55),(19015,8,11,477,'10','2','4',55),(19016,8,11,477,'10','2','5',55),(19017,8,11,477,'10','2','6',55),(19018,8,11,477,'10','2','7',55),(19019,8,11,477,'5','2','8',55),(19020,8,11,477,'M','2','9',55),(19021,8,11,477,'10','3','1',55),(19022,8,11,477,'10','3','2',55),(19023,8,11,477,'10','3','3',55),(19024,8,11,477,'10','3','4',55),(19025,8,11,477,'10','3','5',55),(19026,8,11,477,'10','3','6',55),(19027,8,11,477,'9','3','7',55),(19028,8,11,477,'M','3','8',55),(19029,8,11,477,'M','3','9',55),(19030,8,11,477,'10','4','1',55),(19031,8,11,477,'10','4','2',55),(19032,8,11,477,'10','4','3',55),(19033,8,11,477,'10','4','4',55),(19034,8,11,477,'10','4','5',55),(19035,8,11,477,'10','4','6',55),(19036,8,11,477,'10','4','7',55),(19037,8,11,477,'8','4','8',55),(19038,8,11,477,'M','4','9',55),(19039,8,11,477,'10','5','1',55),(19040,8,11,477,'10','5','2',55),(19041,8,11,477,'10','5','3',55),(19042,8,11,477,'10','5','4',55),(19043,8,11,477,'10','5','5',55),(19044,8,11,477,'10','5','6',55),(19045,8,11,477,'10','5','7',55),(19046,8,11,477,'5','5','8',55),(19047,8,11,477,'M','5','9',55),(19048,8,11,477,'10','6','1',55),(19049,8,11,477,'10','6','2',55),(19050,8,11,477,'10','6','3',55),(19051,8,11,477,'10','6','4',55),(19052,8,11,477,'10','6','5',55),(19053,8,11,477,'10','6','6',55),(19054,8,11,477,'10','6','7',55),(19055,8,11,477,'9','6','8',55),(19056,8,11,477,'M','6','9',55),(19057,8,11,477,'10','7','1',55),(19058,8,11,477,'10','7','2',55),(19059,8,11,477,'10','7','3',55),(19060,8,11,477,'10','7','4',55),(19061,8,11,477,'10','7','5',55),(19062,8,11,477,'10','7','6',55),(19063,8,11,477,'M','7','7',55),(19064,8,11,477,'M','7','8',55),(19065,8,11,477,'M','7','9',55),(19066,8,11,478,'10','1','1',55),(19067,8,11,478,'10','1','2',55),(19068,8,11,478,'10','1','3',55),(19069,8,11,478,'10','1','4',55),(19070,8,11,478,'10','1','5',55),(19071,8,11,478,'9','1','6',55),(19074,8,11,478,'M','1','7',55),(19075,8,11,478,'M','1','8',55),(19076,8,11,478,'M','1','9',55),(19077,8,11,478,'10','2','1',55),(19078,8,11,478,'10','2','2',55),(19079,8,11,478,'10','2','3',55),(19080,8,11,478,'10','2','4',55),(19081,8,11,478,'10','2','5',55),(19083,8,11,478,'10','2','6',55),(19084,8,11,478,'4','2','7',55),(19086,8,11,478,'M','2','8',55),(19087,8,11,478,'M','2','9',55),(19088,8,11,478,'10','3','1',55),(19089,8,11,478,'10','3','2',55),(19090,8,11,478,'10','3','3',55),(19091,8,11,478,'10','3','4',55),(19092,8,11,478,'10','3','5',55),(19093,8,11,478,'8','3','6',55),(19094,8,11,478,'M','3','7',55),(19095,8,11,478,'M','3','8',55),(19096,8,11,478,'M','3','9',55),(19097,8,11,478,'10','4','1',55),(19098,8,11,478,'10','4','2',55),(19099,8,11,478,'10','4','3',55),(19100,8,11,478,'10','4','4',55),(19101,8,11,478,'10','4','5',55),(19102,8,11,478,'10','4','6',55),(19103,8,11,478,'10','4','7',55),(19104,8,11,478,'6','4','8',55),(19105,8,11,478,'M','4','9',55),(19106,8,11,478,'10','5','1',55),(19107,8,11,478,'10','5','2',55),(19108,8,11,478,'10','5','3',55),(19109,8,11,478,'10','5','4',55),(19110,8,11,478,'10','5','5',55),(19111,8,11,478,'10','5','6',55),(19112,8,11,478,'10','5','7',55),(19113,8,11,478,'10','5','8',55),(19114,8,11,478,'6','5','9',55),(19115,8,11,478,'10','6','1',55),(19116,8,11,478,'10','6','2',55),(19117,8,11,478,'10','6','3',55),(19119,8,11,478,'10','6','5',55),(19120,8,11,478,'10','6','6',55),(19121,8,11,478,'10','6','7',55),(19122,8,11,478,'10','6','8',55),(19123,8,11,478,'5','6','9',55),(19124,8,11,478,'10','7','1',55),(19125,8,11,478,'10','7','2',55),(19126,8,11,478,'10','7','3',55),(19127,8,11,478,'10','7','4',55),(19128,8,11,478,'10','7','5',55),(19129,8,11,478,'10','7','6',55),(19130,8,11,478,'10','7','7',55),(19131,8,11,478,'9','7','8',55),(19132,8,11,478,'M','7','9',55),(19133,8,11,478,'10','6','4',55),(19134,7,11,549,'10','1','1',56),(19135,7,11,549,'10','1','2',56),(19136,7,11,549,'10','1','3',56),(19137,7,11,549,'10','1','4',56),(19138,7,11,549,'10','1','5',56),(19139,7,11,549,'10','1','6',56),(19140,7,11,549,'10','1','7',56),(19141,7,11,549,'7','1','8',56),(19142,7,11,549,'10','2','1',56),(19143,7,11,549,'10','2','2',56),(19144,7,11,549,'10','2','3',56),(19145,7,11,549,'10','2','4',56),(19146,7,11,549,'10','2','5',56),(19147,7,11,549,'10','2','6',56),(19148,7,11,549,'10','2','7',56),(19149,7,11,549,'3','2','8',56),(19150,7,11,549,'10','3','1',56),(19151,7,11,549,'10','3','2',56),(19152,7,11,549,'10','3','3',56),(19153,7,11,549,'10','3','4',56),(19154,7,11,549,'10','3','5',56),(19155,7,11,549,'10','3','6',56),(19156,7,11,549,'10','3','7',56),(19157,7,11,549,'8','3','8',56),(19158,7,11,549,'10','4','1',56),(19159,7,11,549,'10','4','2',56),(19160,7,11,549,'10','4','3',56),(19161,7,11,549,'10','4','4',56),(19162,7,11,549,'10','4','5',56),(19163,7,11,549,'10','4','6',56),(19164,7,11,549,'10','4','7',56),(19165,7,11,549,'4','4','8',56),(19166,7,11,549,'10','5','1',56),(19167,7,11,549,'10','5','2',56),(19168,7,11,549,'10','5','3',56),(19169,7,11,549,'10','5','4',56),(19170,7,11,549,'10','5','5',56),(19171,7,11,549,'10','5','6',56),(19172,7,11,549,'10','5','7',56),(19173,7,11,549,'6','5','8',56),(19174,7,11,549,'10','6','1',56),(19175,7,11,549,'10','6','2',56),(19176,7,11,549,'10','6','3',56),(19178,7,11,549,'10','6','5',56),(19179,7,11,549,'10','6','6',56),(19180,7,11,549,'10','6','7',56),(19181,7,11,549,'9','6','8',56),(19182,7,11,549,'10','7','1',56),(19183,7,11,549,'10','7','2',56),(19184,7,11,549,'10','7','3',56),(19185,7,11,549,'10','7','4',56),(19186,7,11,549,'10','7','5',56),(19188,7,11,549,'10','7','7',56),(19189,7,11,549,'3','7','8',56),(19190,7,11,549,'10','6','4',56),(19191,7,11,549,'10','7','6',56),(19192,7,11,550,'10','1','1',56),(19193,7,11,550,'10','1','2',56),(19194,7,11,550,'10','1','3',56),(19195,7,11,550,'10','1','4',56),(19196,7,11,550,'10','1','5',56),(19197,7,11,550,'10','1','6',56),(19198,7,11,550,'9','1','7',56),(19199,7,11,550,'M','1','8',56),(19200,7,11,550,'10','2','1',56),(19201,7,11,550,'10','2','2',56),(19202,7,11,550,'10','2','3',56),(19203,7,11,550,'10','2','4',56),(19204,7,11,550,'10','2','5',56),(19205,7,11,550,'10','2','6',56),(19206,7,11,550,'10','2','7',56),(19207,7,11,550,'1','2','8',56),(19208,7,11,550,'10','3','1',56),(19209,7,11,550,'10','3','2',56),(19210,7,11,550,'10','3','3',56),(19211,7,11,550,'10','3','4',56),(19212,7,11,550,'10','3','5',56),(19213,7,11,550,'10','3','6',56),(19214,7,11,550,'10','3','7',56),(19215,7,11,550,'5','3','8',56),(19216,7,11,550,'10','4','1',56),(19217,7,11,550,'10','4','2',56),(19218,7,11,550,'10','4','3',56),(19219,7,11,550,'10','4','4',56),(19220,7,11,550,'10','4','5',56),(19221,7,11,550,'10','4','6',56),(19222,7,11,550,'10','4','7',56),(19223,7,11,550,'4','4','8',56),(19224,7,11,550,'10','5','1',56),(19225,7,11,550,'10','5','2',56),(19226,7,11,550,'10','5','3',56),(19228,7,11,550,'10','5','5',56),(19229,7,11,550,'10','5','6',56),(19230,7,11,550,'10','5','7',56),(19231,7,11,550,'4','5','8',56),(19232,7,11,550,'10','5','4',56),(19233,7,11,550,'10','6','1',56),(19234,7,11,550,'10','6','2',56),(19235,7,11,550,'10','6','3',56),(19236,7,11,550,'10','6','4',56),(19237,7,11,550,'10','6','5',56),(19238,7,11,550,'10','6','6',56),(19239,7,11,550,'6','6','7',56),(19240,7,11,550,'M','6','8',56),(19241,7,11,550,'10','7','1',56),(19242,7,11,550,'10','7','2',56),(19243,7,11,550,'10','7','3',56),(19244,7,11,550,'10','7','4',56),(19245,7,11,550,'10','7','5',56),(19246,7,11,550,'10','7','6',56),(19247,7,11,550,'10','7','7',56),(19248,7,11,550,'4','7','8',56),(19249,7,11,552,'10','1','1',56),(19250,7,11,552,'10','1','2',56),(19251,7,11,552,'10','1','3',56),(19253,7,11,552,'10','1','4',56),(19254,7,11,552,'10','1','5',56),(19255,7,11,552,'10','1','6',56),(19256,7,11,552,'10','1','7',56),(19257,7,11,552,'1','1','8',56),(19258,7,11,552,'10','2','1',56),(19259,7,11,552,'10','2','2',56),(19260,7,11,552,'10','2','3',56),(19261,7,11,552,'10','2','4',56),(19262,7,11,552,'10','2','5',56),(19263,7,11,552,'10','2','6',56),(19264,7,11,552,'9','2','7',56),(19265,7,11,552,'M','2','8',56),(19266,7,11,552,'10','3','1',56),(19267,7,11,552,'10','3','2',56),(19268,7,11,552,'10','3','3',56),(19269,7,11,552,'10','3','4',56),(19270,7,11,552,'10','3','5',56),(19271,7,11,552,'10','3','6',56),(19272,7,11,552,'7','3','7',56),(19273,7,11,552,'M','3','8',56),(19274,7,11,552,'10','4','1',56),(19275,7,11,552,'10','4','2',56),(19276,7,11,552,'10','4','3',56),(19277,7,11,552,'10','4','4',56),(19278,7,11,552,'10','4','5',56),(19279,7,11,552,'10','4','6',56),(19280,7,11,552,'10','4','7',56),(19281,7,11,552,'8','4','8',56),(19282,7,11,552,'10','5','1',56),(19283,7,11,552,'10','5','2',56),(19284,7,11,552,'10','5','3',56),(19285,7,11,552,'10','5','4',56),(19286,7,11,552,'10','5','5',56),(19287,7,11,552,'10','5','6',56),(19288,7,11,552,'4','5','7',56),(19289,7,11,552,'M','5','8',56),(19290,7,11,552,'10','6','1',56),(19291,7,11,552,'10','6','2',56),(19292,7,11,552,'10','6','3',56),(19293,7,11,552,'10','6','4',56),(19294,7,11,552,'10','6','5',56),(19295,7,11,552,'10','6','6',56),(19296,7,11,552,'10','6','7',56),(19297,7,11,552,'5','6','8',56),(19298,7,11,552,'10','7','1',56),(19299,7,11,552,'10','7','2',56),(19300,7,11,552,'10','7','3',56),(19301,7,11,552,'10','7','4',56),(19302,7,11,552,'10','7','5',56),(19303,7,11,552,'10','7','6',56),(19304,7,11,552,'9','7','7',56),(19305,7,11,552,'M','7','8',56),(19306,7,11,554,'10','1','1',56),(19307,7,11,554,'10','1','2',56),(19309,7,11,554,'10','1','4',56),(19310,7,11,554,'10','1','5',56),(19311,7,11,554,'10','1','6',56),(19312,7,11,554,'2','1','7',56),(19313,7,11,554,'M','1','8',56),(19314,7,11,554,'10','1','3',56),(19315,7,11,554,'10','2','1',56),(19316,7,11,554,'10','2','2',56),(19317,7,11,554,'10','2','3',56),(19318,7,11,554,'10','2','4',56),(19319,7,11,554,'10','2','5',56),(19320,7,11,554,'10','2','6',56),(19321,7,11,554,'10','2','7',56),(19322,7,11,554,'1','2','8',56),(19323,7,11,554,'10','3','1',56),(19324,7,11,554,'10','3','2',56),(19325,7,11,554,'10','3','3',56),(19326,7,11,554,'10','3','4',56),(19327,7,11,554,'10','3','5',56),(19328,7,11,554,'10','3','6',56),(19329,7,11,554,'7','3','7',56),(19330,7,11,554,'M','3','8',56),(19331,7,11,554,'10','4','1',56),(19332,7,11,554,'10','4','2',56),(19333,7,11,554,'10','4','3',56),(19334,7,11,554,'10','4','4',56),(19335,7,11,554,'10','4','5',56),(19336,7,11,554,'4','4','6',56),(19337,7,11,554,'M','4','7',56),(19338,7,11,554,'M','4','8',56),(19339,7,11,554,'10','5','1',56),(19340,7,11,554,'10','5','2',56),(19341,7,11,554,'10','5','3',56),(19342,7,11,554,'10','5','4',56),(19343,7,11,554,'10','5','5',56),(19344,7,11,554,'10','5','6',56),(19345,7,11,554,'6','5','7',56),(19346,7,11,554,'M','5','8',56),(19347,7,11,554,'10','6','1',56),(19348,7,11,554,'10','6','2',56),(19349,7,11,554,'10','6','3',56),(19350,7,11,554,'10','6','4',56),(19351,7,11,554,'10','6','5',56),(19352,7,11,554,'10','6','6',56),(19353,7,11,554,'10','6','7',56),(19354,7,11,554,'8','6','8',56),(19355,7,11,554,'10','7','1',56),(19356,7,11,554,'10','7','2',56),(19357,7,11,554,'10','7','3',56),(19358,7,11,554,'10','7','4',56),(19359,7,11,554,'10','7','5',56),(19360,7,11,554,'10','7','6',56),(19361,7,11,554,'3','7','7',56),(19362,7,11,554,'M','7','8',56),(19363,7,11,555,'10','1','1',56),(19364,7,11,555,'10','1','2',56),(19365,7,11,555,'10','1','3',56),(19366,7,11,555,'10','1','4',56),(19367,7,11,555,'10','1','5',56),(19368,7,11,555,'10','1','6',56),(19369,7,11,555,'2','1','7',56),(19370,7,11,555,'M','1','8',56),(19371,7,11,555,'10','2','1',56),(19372,7,11,555,'10','2','2',56),(19373,7,11,555,'10','2','3',56),(19374,7,11,555,'10','2','4',56),(19375,7,11,555,'10','2','5',56),(19376,7,11,555,'10','2','6',56),(19377,7,11,555,'3','2','7',56),(19378,7,11,555,'M','2','8',56),(19379,7,11,555,'10','3','1',56),(19380,7,11,555,'10','3','2',56),(19381,7,11,555,'10','3','3',56),(19382,7,11,555,'10','3','4',56),(19383,7,11,555,'10','3','5',56),(19384,7,11,555,'1','3','6',56),(19385,7,11,555,'M','3','7',56),(19386,7,11,555,'M','3','8',56),(19387,7,11,555,'10','4','1',56),(19388,7,11,555,'10','4','2',56),(19389,7,11,555,'10','4','3',56),(19390,7,11,555,'10','4','4',56),(19391,7,11,555,'10','4','5',56),(19392,7,11,555,'10','4','6',56),(19393,7,11,555,'10','4','7',56),(19394,7,11,555,'2','4','8',56),(19395,7,11,555,'10','5','1',56),(19396,7,11,555,'10','5','2',56),(19397,7,11,555,'10','5','3',56),(19398,7,11,555,'10','5','4',56),(19399,7,11,555,'10','5','5',56),(19400,7,11,555,'10','5','6',56),(19401,7,11,555,'5','5','7',56),(19402,7,11,555,'M','5','8',56),(19403,7,11,555,'10','6','1',56),(19404,7,11,555,'10','6','2',56),(19405,7,11,555,'10','6','3',56),(19406,7,11,555,'10','6','4',56),(19407,7,11,555,'10','6','5',56),(19408,7,11,555,'10','6','6',56),(19409,7,11,555,'4','6','7',56),(19410,7,11,555,'M','6','8',56),(19411,7,11,555,'10','7','1',56),(19412,7,11,555,'10','7','2',56),(19413,7,11,555,'10','7','3',56),(19414,7,11,555,'10','7','4',56),(19415,7,11,555,'4','7','5',56),(19417,7,11,555,'M','7','6',56),(19418,7,11,555,'M','7','7',56),(19419,7,11,555,'M','7','8',56),(19420,7,11,558,'10','1','1',56),(19421,7,11,558,'10','1','2',56),(19422,7,11,558,'10','1','3',56),(19423,7,11,558,'10','1','4',56),(19424,7,11,558,'10','1','5',56),(19425,7,11,558,'10','1','6',56),(19426,7,11,558,'3','1','7',56),(19427,7,11,558,'M','1','8',56),(19428,7,11,558,'10','2','1',56),(19429,7,11,558,'10','2','2',56),(19430,7,11,558,'10','2','3',56),(19431,7,11,558,'10','2','4',56),(19432,7,11,558,'10','2','5',56),(19433,7,11,558,'8','2','6',56),(19434,7,11,558,'M','2','7',56),(19435,7,11,558,'M','2','8',56),(19436,7,11,558,'10','3','1',56),(19437,7,11,558,'10','3','2',56),(19438,7,11,558,'10','3','3',56),(19439,7,11,558,'10','3','4',56),(19440,7,11,558,'6','3','5',56),(19441,7,11,558,'M','3','6',56),(19442,7,11,558,'M','3','7',56),(19443,7,11,558,'M','3','8',56),(19444,7,11,558,'10','4','1',56),(19445,7,11,558,'10','4','2',56),(19446,7,11,558,'10','4','3',56),(19447,7,11,558,'10','4','4',56),(19448,7,11,558,'M','4','5',56),(19449,7,11,558,'M','4','6',56),(19450,7,11,558,'M','4','7',56),(19451,7,11,558,'M','4','8',56),(19452,7,11,558,'10','5','1',56),(19453,7,11,558,'10','5','2',56),(19454,7,11,558,'10','5','3',56),(19455,7,11,558,'10','5','4',56),(19456,7,11,558,'10','5','5',56),(19457,7,11,558,'10','5','6',56),(19458,7,11,558,'5','5','7',56),(19459,7,11,558,'M','5','8',56),(19460,7,11,558,'10','6','1',56),(19461,7,11,558,'10','6','2',56),(19462,7,11,558,'10','6','3',56),(19463,7,11,558,'10','6','4',56),(19464,7,11,558,'7','6','5',56),(19465,7,11,558,'M','6','6',56),(19466,7,11,558,'M','6','7',56),(19467,7,11,558,'M','6','8',56),(19468,7,11,558,'10','7','1',56),(19469,7,11,558,'10','7','2',56),(19470,7,11,558,'10','7','3',56),(19471,7,11,558,'10','7','4',56),(19472,7,11,558,'10','7','5',56),(19473,7,11,558,'10','7','6',56),(19474,7,11,558,'6','7','7',56),(19475,7,11,558,'M','7','8',56),(19476,7,11,559,'10','1','1',56),(19477,7,11,559,'10','1','2',56),(19478,7,11,559,'10','1','3',56),(19479,7,11,559,'10','1','4',56),(19480,7,11,559,'10','1','5',56),(19481,7,11,559,'10','1','6',56),(19482,7,11,559,'4','1','7',56),(19483,7,11,559,'M','1','8',56),(19484,7,11,559,'10','2','1',56),(19485,7,11,559,'10','2','2',56),(19486,7,11,559,'10','2','3',56),(19487,7,11,559,'10','2','4',56),(19488,7,11,559,'10','2','5',56),(19489,7,11,559,'M','2','6',56),(19490,7,11,559,'M','2','7',56),(19491,7,11,559,'M','2','8',56),(19492,7,11,559,'10','3','1',56),(19493,7,11,559,'10','3','2',56),(19494,7,11,559,'10','3','3',56),(19495,7,11,559,'10','3','4',56),(19496,7,11,559,'10','3','5',56),(19497,7,11,559,'10','3','6',56),(19498,7,11,559,'8','3','7',56),(19499,7,11,559,'M','3','8',56),(19500,7,11,559,'10','4','1',56),(19501,7,11,559,'10','4','2',56),(19502,7,11,559,'10','4','3',56),(19503,7,11,559,'10','4','4',56),(19504,7,11,559,'10','4','5',56),(19505,7,11,559,'M','4','6',56),(19506,7,11,559,'M','4','7',56),(19507,7,11,559,'M','4','8',56),(19508,7,11,559,'10','5','1',56),(19509,7,11,559,'10','5','2',56),(19510,7,11,559,'10','5','3',56),(19511,7,11,559,'3','5','4',56),(19512,7,11,559,'M','5','5',56),(19513,7,11,559,'M','5','6',56),(19514,7,11,559,'M','5','7',56),(19515,7,11,559,'M','5','8',56),(19516,7,11,559,'10','6','1',56),(19517,7,11,559,'10','6','2',56),(19518,7,11,559,'10','6','3',56),(19519,7,11,559,'10','6','4',56),(19520,7,11,559,'10','6','5',56),(19521,7,11,559,'4','6','6',56),(19522,7,11,559,'M','6','7',56),(19523,7,11,559,'M','6','8',56),(19524,7,11,559,'10','7','1',56),(19525,7,11,559,'10','7','2',56),(19526,7,11,559,'10','7','3',56),(19527,7,11,559,'10','7','4',56),(19528,7,11,559,'10','7','5',56),(19529,7,11,559,'10','7','6',56),(19530,7,11,559,'5','7','7',56),(19531,7,11,559,'M','7','8',56),(19532,7,11,560,'10','1','1',56),(19533,7,11,560,'10','1','2',56),(19534,7,11,560,'10','1','3',56),(19535,7,11,560,'10','1','4',56),(19536,7,11,560,'10','1','5',56),(19537,7,11,560,'10','1','6',56),(19538,7,11,560,'M','1','7',56),(19539,7,11,560,'M','1','8',56),(19540,7,11,560,'10','2','1',56),(19541,7,11,560,'10','2','2',56),(19542,7,11,560,'10','2','3',56),(19543,7,11,560,'10','2','4',56),(19544,7,11,560,'10','2','5',56),(19545,7,11,560,'10','2','6',56),(19546,7,11,560,'5','2','7',56),(19547,7,11,560,'M','2','8',56),(19548,7,11,560,'10','3','1',56),(19549,7,11,560,'10','3','2',56),(19550,7,11,560,'10','3','3',56),(19551,7,11,560,'10','3','4',56),(19553,7,11,560,'2','3','5',56),(19554,7,11,560,'M','3','6',56),(19555,7,11,560,'M','3','7',56),(19556,7,11,560,'M','3','8',56),(19557,7,11,560,'10','4','1',56),(19558,7,11,560,'10','4','2',56),(19559,7,11,560,'10','4','3',56),(19560,7,11,560,'10','4','4',56),(19561,7,11,560,'4','4','5',56),(19562,7,11,560,'M','4','6',56),(19563,7,11,560,'M','4','7',56),(19564,7,11,560,'M','4','8',56),(19565,7,11,560,'10','5','1',56),(19566,7,11,560,'10','5','2',56),(19567,7,11,560,'10','5','3',56),(19568,7,11,560,'10','5','4',56),(19569,7,11,560,'10','5','5',56),(19570,7,11,560,'9','5','6',56),(19571,7,11,560,'M','5','7',56),(19572,7,11,560,'M','5','8',56),(19573,7,11,560,'10','6','1',56),(19574,7,11,560,'10','6','2',56),(19575,7,11,560,'10','6','3',56),(19576,7,11,560,'10','6','4',56),(19577,7,11,560,'10','6','5',56),(19578,7,11,560,'10','6','6',56),(19579,7,11,560,'4','6','7',56),(19580,7,11,560,'M','6','8',56),(19581,7,11,560,'10','7','1',56),(19582,7,11,560,'10','7','2',56),(19583,7,11,560,'10','7','3',56),(19584,7,11,560,'10','7','4',56),(19585,7,11,560,'9','7','5',56),(19586,7,11,560,'M','7','6',56),(19587,7,11,560,'M','7','7',56),(19588,7,11,560,'M','7','8',56),(19589,7,11,556,'10','1','1',56),(19590,7,11,556,'10','1','2',56),(19591,7,11,556,'10','1','3',56),(19592,7,11,556,'10','1','4',56),(19593,7,11,556,'2','1','5',56),(19594,7,11,556,'M','1','6',56),(19595,7,11,556,'M','1','7',56),(19596,7,11,556,'M','1','8',56),(19597,7,11,556,'10','2','1',56),(19598,7,11,556,'10','2','2',56),(19599,7,11,556,'10','2','3',56),(19600,7,11,556,'3','2','4',56),(19601,7,11,556,'M','2','5',56),(19602,7,11,556,'M','2','6',56),(19603,7,11,556,'M','2','7',56),(19604,7,11,556,'M','2','8',56),(19605,7,11,556,'10','3','1',56),(19606,7,11,556,'10','3','2',56),(19607,7,11,556,'10','3','3',56),(19608,7,11,556,'10','3','4',56),(19609,7,11,556,'10','3','5',56),(19610,7,11,556,'10','3','6',56),(19611,7,11,556,'3','3','7',56),(19612,7,11,556,'M','3','8',56),(19613,7,11,556,'10','4','1',56),(19614,7,11,556,'10','4','2',56),(19615,7,11,556,'10','4','3',56),(19616,7,11,556,'10','4','4',56),(19617,7,11,556,'10','4','5',56),(19618,7,11,556,'10','4','6',56),(19619,7,11,556,'8','4','7',56),(19620,7,11,556,'M','4','8',56),(19621,7,11,556,'10','5','1',56),(19622,7,11,556,'10','5','2',56),(19623,7,11,556,'10','5','3',56),(19624,7,11,556,'10','5','4',56),(19625,7,11,556,'10','5','5',56),(19626,7,11,556,'4','5','6',56),(19627,7,11,556,'M','5','7',56),(19628,7,11,556,'10','5','8',56),(19629,7,11,556,'10','6','1',56),(19630,7,11,556,'10','6','2',56),(19631,7,11,556,'10','6','3',56),(19632,7,11,556,'10','6','4',56),(19633,7,11,556,'10','6','5',56),(19634,7,11,556,'10','6','6',56),(19635,7,11,556,'M','6','7',56),(19636,7,11,556,'M','6','8',56),(19637,7,11,556,'10','7','1',56),(19638,7,11,556,'10','7','2',56),(19639,7,11,556,'10','7','3',56),(19640,7,11,556,'10','7','4',56),(19641,7,11,556,'10','7','5',56),(19642,7,11,556,'10','7','6',56),(19643,7,11,556,'2','7','7',56),(19644,7,11,556,'M','7','8',56),(19645,7,11,561,'10','1','1',56),(19646,7,11,561,'10','1','2',56),(19647,7,11,561,'10','1','3',56),(19648,7,11,561,'10','1','4',56),(19649,7,11,561,'10','1','5',56),(19650,7,11,561,'10','1','6',56),(19651,7,11,561,'1','1','7',56),(19652,7,11,561,'M','1','8',56),(19653,7,11,561,'10','2','1',56),(19654,7,11,561,'10','2','2',56),(19655,7,11,561,'10','2','3',56),(19656,7,11,561,'10','2','4',56),(19657,7,11,561,'8','2','5',56),(19658,7,11,561,'M','2','6',56),(19659,7,11,561,'M','2','7',56),(19660,7,11,561,'M','2','8',56),(19661,7,11,561,'10','3','1',56),(19662,7,11,561,'10','3','2',56),(19663,7,11,561,'10','3','3',56),(19664,7,11,561,'10','3','4',56),(19665,7,11,561,'10','3','5',56),(19666,7,11,561,'M','3','6',56),(19667,7,11,561,'M','3','7',56),(19668,7,11,561,'M','3','8',56),(19669,7,11,561,'10','4','1',56),(19670,7,11,561,'10','4','2',56),(19671,7,11,561,'10','4','3',56),(19672,7,11,561,'10','4','4',56),(19673,7,11,561,'10','4','5',56),(19674,7,11,561,'10','4','6',56),(19675,7,11,561,'6','4','7',56),(19676,7,11,561,'M','4','8',56),(19677,7,11,561,'10','5','1',56),(19678,7,11,561,'10','5','2',56),(19679,7,11,561,'10','5','3',56),(19680,7,11,561,'6','5','4',56),(19681,7,11,561,'M','5','5',56),(19682,7,11,561,'M','5','6',56),(19683,7,11,561,'M','5','7',56),(19684,7,11,561,'M','5','8',56),(19685,7,11,561,'10','6','1',56),(19686,7,11,561,'10','6','2',56),(19687,7,11,561,'10','6','3',56),(19688,7,11,561,'10','6','4',56),(19689,7,11,561,'10','6','5',56),(19690,7,11,561,'3','6','6',56),(19691,7,11,561,'M','6','7',56),(19692,7,11,561,'M','6','8',56),(19693,7,11,561,'10','7','1',56),(19694,7,11,561,'10','7','2',56),(19695,7,11,561,'10','7','3',56),(19696,7,11,561,'10','7','4',56),(19697,7,11,561,'8','7','5',56),(19698,7,11,561,'M','7','6',56),(19699,7,11,561,'M','7','7',56),(19700,7,11,561,'M','7','8',56),(19701,7,11,562,'10','1','1',56),(19702,7,11,562,'10','1','2',56),(19703,7,11,562,'10','1','3',56),(19704,7,11,562,'10','1','4',56),(19705,7,11,562,'10','1','5',56),(19706,7,11,562,'10','1','6',56),(19707,7,11,562,'M','1','7',56),(19708,7,11,562,'M','1','8',56),(19709,7,11,562,'10','2','1',56),(19710,7,11,562,'10','2','2',56),(19711,7,11,562,'10','2','3',56),(19712,7,11,562,'8','2','4',56),(19713,7,11,562,'M','2','5',56),(19714,7,11,562,'M','2','6',56),(19715,7,11,562,'M','2','7',56),(19716,7,11,562,'M','2','8',56),(19717,7,11,562,'10','3','1',56),(19718,7,11,562,'10','3','2',56),(19719,7,11,562,'10','3','3',56),(19720,7,11,562,'6','3','4',56),(19721,7,11,562,'M','3','5',56),(19722,7,11,562,'M','3','6',56),(19723,7,11,562,'M','3','7',56),(19724,7,11,562,'M','3','8',56),(19725,7,11,562,'10','4','1',56),(19726,7,11,562,'10','4','2',56),(19727,7,11,562,'10','4','3',56),(19728,7,11,562,'7','4','4',56),(19729,7,11,562,'M','4','5',56),(19730,7,11,562,'M','4','6',56),(19731,7,11,562,'M','4','7',56),(19732,7,11,562,'M','4','8',56),(19733,7,11,562,'10','5','1',56),(19734,7,11,562,'10','5','2',56),(19735,7,11,562,'10','5','3',56),(19736,7,11,562,'10','5','4',56),(19737,7,11,562,'10','5','5',56),(19738,7,11,562,'10','5','6',56),(19739,7,11,562,'7','5','7',56),(19740,7,11,562,'M','5','8',56),(19741,7,11,562,'10','6','1',56),(19742,7,11,562,'10','6','2',56),(19743,7,11,562,'10','6','3',56),(19744,7,11,562,'10','6','4',56),(19745,7,11,562,'10','6','5',56),(19746,7,11,562,'3','6','6',56),(19747,7,11,562,'M','6','7',56),(19748,7,11,562,'M','6','8',56),(19749,7,11,562,'10','7','1',56),(19750,7,11,562,'10','7','2',56),(19751,7,11,562,'10','7','3',56),(19752,7,11,562,'10','7','4',56),(19753,7,11,562,'10','7','5',56),(19754,7,11,562,'10','7','6',56),(19755,7,11,562,'8','7','7',56),(19756,7,11,562,'M','7','8',56),(19757,7,11,563,'10','1','1',56),(19758,7,11,563,'10','1','2',56),(19759,7,11,563,'7','1','3',56),(19760,7,11,563,'M','1','4',56),(19761,7,11,563,'M','1','5',56),(19762,7,11,563,'M','1','6',56),(19763,7,11,563,'M','1','7',56),(19764,7,11,563,'M','1','8',56),(19765,7,11,563,'10','2','1',56),(19766,7,11,563,'10','2','2',56),(19767,7,11,563,'10','2','3',56),(19769,7,11,563,'10','2','5',56),(19770,7,11,563,'10','2','6',56),(19771,7,11,563,'3','2','7',56),(19772,7,11,563,'M','2','8',56),(19773,7,11,563,'10','2','4',56),(19774,7,11,563,'10','3','1',56),(19775,7,11,563,'10','3','2',56),(19776,7,11,563,'10','3','3',56),(19777,7,11,563,'10','3','4',56),(19778,7,11,563,'6','3','5',56),(19779,7,11,563,'M','3','6',56),(19780,7,11,563,'M','3','7',56),(19781,7,11,563,'M','3','8',56),(19782,7,11,563,'10','4','1',56),(19783,7,11,563,'10','4','2',56),(19784,7,11,563,'10','4','3',56),(19785,7,11,563,'10','4','4',56),(19786,7,11,563,'10','4','5',56),(19787,7,11,563,'9','4','6',56),(19788,7,11,563,'M','4','7',56),(19789,7,11,563,'M','4','8',56),(19790,7,11,563,'10','5','1',56),(19791,7,11,563,'10','5','2',56),(19792,7,11,563,'10','5','3',56),(19793,7,11,563,'10','5','4',56),(19794,7,11,563,'10','5','5',56),(19795,7,11,563,'4','5','6',56),(19796,7,11,563,'M','5','7',56),(19797,7,11,563,'M','5','8',56),(19798,7,11,563,'10','6','1',56),(19799,7,11,563,'10','6','2',56),(19800,7,11,563,'10','6','3',56),(19801,7,11,563,'10','6','4',56),(19802,7,11,563,'10','6','5',56),(19803,7,11,563,'6','6','6',56),(19804,7,11,563,'M','6','7',56),(19805,7,11,563,'M','6','8',56),(19806,7,11,563,'10','7','1',56),(19807,7,11,563,'10','7','2',56),(19808,7,11,563,'10','7','3',56),(19809,7,11,563,'10','7','4',56),(19810,7,11,563,'4','7','5',56),(19811,7,11,563,'4','7','6',56),(19812,7,11,563,'M','7','7',56),(19813,7,11,563,'M','7','8',56),(19814,7,11,564,'10','1','1',56),(19815,7,11,564,'10','1','2',56),(19816,7,11,564,'10','1','3',56),(19817,7,11,564,'10','1','4',56),(19818,7,11,564,'7','1','5',56),(19819,7,11,564,'M','1','6',56),(19820,7,11,564,'M','1','7',56),(19821,7,11,564,'M','1','8',56),(19822,7,11,564,'10','2','1',56),(19823,7,11,564,'10','2','2',56),(19824,7,11,564,'10','2','3',56),(19825,7,11,564,'10','2','4',56),(19826,7,11,564,'10','2','5',56),(19827,7,11,564,'3','2','6',56),(19828,7,11,564,'M','2','7',56),(19829,7,11,564,'M','2','8',56),(19830,7,11,564,'10','3','1',56),(19831,7,11,564,'10','3','2',56),(19832,7,11,564,'10','3','3',56),(19833,7,11,564,'10','3','4',56),(19834,7,11,564,'10','3','5',56),(19835,7,11,564,'10','3','6',56),(19836,7,11,564,'M','3','7',56),(19837,7,11,564,'M','3','8',56),(19838,7,11,564,'10','4','1',56),(19839,7,11,564,'10','4','2',56),(19840,7,11,564,'10','4','3',56),(19841,7,11,564,'10','4','4',56),(19842,7,11,564,'10','4','5',56),(19843,7,11,564,'9','4','6',56),(19844,7,11,564,'M','4','7',56),(19845,7,11,564,'M','4','8',56),(19846,7,11,564,'10','5','1',56),(19847,7,11,564,'10','5','2',56),(19848,7,11,564,'10','5','3',56),(19849,7,11,564,'10','5','4',56),(19850,7,11,564,'10','5','5',56),(19851,7,11,564,'1','5','6',56),(19852,7,11,564,'M','5','7',56),(19853,7,11,564,'M','5','8',56),(19854,7,11,564,'10','6','1',56),(19855,7,11,564,'10','6','2',56),(19856,7,11,564,'10','6','3',56),(19857,7,11,564,'10','6','4',56),(19858,7,11,564,'3','6','5',56),(19859,7,11,564,'M','6','6',56),(19860,7,11,564,'M','6','7',56),(19861,7,11,564,'M','6','8',56),(19862,7,11,564,'10','7','1',56),(19863,7,11,564,'10','7','2',56),(19864,7,11,564,'10','7','3',56),(19865,7,11,564,'8','7','4',56),(19866,7,11,564,'M','7','5',56),(19867,7,11,564,'M','7','6',56),(19868,7,11,564,'M','7','7',56),(19869,7,11,564,'M','7','8',56),(19870,7,11,565,'10','1','1',56),(19871,7,11,565,'10','1','2',56),(19872,7,11,565,'10','1','3',56),(19873,7,11,565,'10','1','4',56),(19874,7,11,565,'6','1','5',56),(19875,7,11,565,'M','1','6',56),(19876,7,11,565,'M','1','7',56),(19877,7,11,565,'M','1','8',56),(19878,7,11,565,'10','2','1',56),(19879,7,11,565,'10','2','2',56),(19880,7,11,565,'10','2','3',56),(19881,7,11,565,'10','2','4',56),(19882,7,11,565,'10','2','5',56),(19883,7,11,565,'3','2','6',56),(19884,7,11,565,'M','2','7',56),(19885,7,11,565,'M','2','8',56),(19886,7,11,565,'10','3','1',56),(19887,7,11,565,'10','3','2',56),(19888,7,11,565,'10','3','3',56),(19889,7,11,565,'10','3','4',56),(19890,7,11,565,'10','3','5',56),(19891,7,11,565,'2','3','6',56),(19892,7,11,565,'M','3','7',56),(19893,7,11,565,'M','3','8',56),(19894,7,11,565,'10','4','1',56),(19895,7,11,565,'10','4','2',56),(19896,7,11,565,'10','4','3',56),(19897,7,11,565,'7','4','4',56),(19898,7,11,565,'M','4','5',56),(19899,7,11,565,'M','4','6',56),(19900,7,11,565,'M','4','7',56),(19901,7,11,565,'M','4','8',56),(19902,7,11,565,'10','5','1',56),(19903,7,11,565,'10','5','2',56),(19904,7,11,565,'10','5','3',56),(19905,7,11,565,'10','5','4',56),(19906,7,11,565,'10','5','5',56),(19907,7,11,565,'2','5','6',56),(19908,7,11,565,'M','5','7',56),(19909,7,11,565,'M','5','8',56),(19910,7,11,565,'10','6','1',56),(19911,7,11,565,'10','6','2',56),(19912,7,11,565,'10','6','3',56),(19913,7,11,565,'10','6','4',56),(19914,7,11,565,'7','6','5',56),(19915,7,11,565,'M','6','6',56),(19916,7,11,565,'M','6','7',56),(19917,7,11,565,'M','6','8',56),(19918,7,11,565,'10','7','1',56),(19919,7,11,565,'10','7','2',56),(19920,7,11,565,'10','7','3',56),(19921,7,11,565,'10','7','4',56),(19922,7,11,565,'10','7','5',56),(19923,7,11,565,'7','7','6',56),(19924,7,11,565,'M','7','7',56),(19925,7,11,565,'M','7','8',56),(19926,7,11,569,'10','1','1',56),(19927,7,11,569,'10','1','2',56),(19928,7,11,569,'10','1','3',56),(19930,7,11,569,'10','1','4',56),(19931,7,11,569,'10','1','5',56),(19932,7,11,569,'2','1','6',56),(19933,7,11,569,'M','1','7',56),(19934,7,11,569,'M','1','8',56),(19935,7,11,569,'10','2','1',56),(19936,7,11,569,'10','2','2',56),(19937,7,11,569,'10','2','3',56),(19938,7,11,569,'10','2','4',56),(19939,7,11,569,'7','2','5',56),(19940,7,11,569,'M','2','6',56),(19941,7,11,569,'M','2','7',56),(19942,7,11,569,'M','2','8',56),(19943,7,11,569,'10','3','1',56),(19944,7,11,569,'10','3','2',56),(19945,7,11,569,'10','3','3',56),(19946,7,11,569,'10','3','4',56),(19947,7,11,569,'10','3','5',56),(19948,7,11,569,'4','3','6',56),(19949,7,11,569,'M','3','7',56),(19950,7,11,569,'M','3','8',56),(19951,7,11,569,'10','4','1',56),(19952,7,11,569,'10','4','2',56),(19953,7,11,569,'10','4','3',56),(19954,7,11,569,'10','4','4',56),(19955,7,11,569,'10','4','5',56),(19956,7,11,569,'6','4','6',56),(19957,7,11,569,'M','4','7',56),(19958,7,11,569,'M','4','8',56),(19959,7,11,569,'10','5','1',56),(19960,7,11,569,'10','5','2',56),(19961,7,11,569,'10','5','3',56),(19962,7,11,569,'3','5','4',56),(19963,7,11,569,'M','5','5',56),(19964,7,11,569,'M','5','6',56),(19965,7,11,569,'M','5','7',56),(19966,7,11,569,'M','5','8',56),(19967,7,11,569,'10','6','1',56),(19968,7,11,569,'10','6','2',56),(19969,7,11,569,'7','6','3',56),(19970,7,11,569,'M','6','4',56),(19971,7,11,569,'M','6','5',56),(19972,7,11,569,'M','6','6',56),(19973,7,11,569,'M','6','7',56),(19974,7,11,569,'M','6','8',56),(19975,7,11,569,'10','7','1',56),(19976,7,11,569,'10','7','2',56),(19977,7,11,569,'10','7','3',56),(19978,7,11,569,'10','7','4',56),(19979,7,11,569,'10','7','5',56),(19980,7,11,569,'2','7','6',56),(19981,7,11,569,'M','7','7',56),(19982,7,11,569,'M','7','8',56),(19983,7,11,557,'10','1','1',56),(19984,7,11,557,'10','1','2',56),(19985,7,11,557,'10','1','3',56),(19986,7,11,557,'10','1','4',56),(19987,7,11,557,'10','1','5',56),(19988,7,11,557,'9','1','6',56),(19990,7,11,557,'M','1','7',56),(19991,7,11,557,'M','1','8',56),(19992,7,11,557,'10','2','1',56),(19993,7,11,557,'10','2','2',56),(19994,7,11,557,'10','2','3',56),(19995,7,11,557,'10','2','4',56),(19996,7,11,557,'10','2','5',56),(19997,7,11,557,'10','2','6',56),(19998,7,11,557,'1','2','7',56),(19999,7,11,557,'M','2','8',56),(20000,7,11,557,'10','3','1',56),(20001,7,11,557,'10','3','2',56),(20002,7,11,557,'10','3','3',56),(20003,7,11,557,'10','3','4',56),(20005,7,11,557,'M','3','6',56),(20006,7,11,557,'M','3','7',56),(20007,7,11,557,'M','3','8',56),(20008,7,11,557,'10','3','5',56),(20009,7,11,557,'10','4','1',56),(20010,7,11,557,'10','4','2',56),(20011,7,11,557,'10','4','3',56),(20012,7,11,557,'10','4','4',56),(20013,7,11,557,'4','4','5',56),(20014,7,11,557,'M','4','6',56),(20015,7,11,557,'M','4','7',56),(20016,7,11,557,'M','4','8',56),(20017,7,11,557,'10','5','1',56),(20018,7,11,557,'10','5','2',56),(20019,7,11,557,'10','5','3',56),(20020,7,11,557,'10','5','4',56),(20021,7,11,557,'2','5','5',56),(20022,7,11,557,'M','5','6',56),(20023,7,11,557,'M','5','7',56),(20024,7,11,557,'M','5','8',56),(20025,7,11,557,'10','6','1',56),(20026,7,11,557,'10','6','2',56),(20027,7,11,557,'10','6','3',56),(20028,7,11,557,'10','6','4',56),(20029,7,11,557,'10','6','5',56),(20030,7,11,557,'10','6','6',56),(20031,7,11,557,'3','6','7',56),(20032,7,11,557,'M','6','8',56),(20033,7,11,557,'10','7','1',56),(20034,7,11,557,'10','7','2',56),(20035,7,11,557,'10','7','3',56),(20036,7,11,557,'10','7','4',56),(20037,7,11,557,'10','7','5',56),(20038,7,11,557,'10','7','6',56),(20039,7,11,557,'8','7','7',56),(20040,7,11,557,'M','7','8',56),(20041,7,11,570,'10','1','1',56),(20042,7,11,570,'10','1','2',56),(20043,7,11,570,'10','1','3',56),(20044,7,11,570,'7','1','4',56),(20045,7,11,570,'M','1','5',56),(20046,7,11,570,'M','1','6',56),(20047,7,11,570,'M','1','7',56),(20048,7,11,570,'M','1','8',56),(20049,7,11,570,'10','2','1',56),(20050,7,11,570,'10','2','2',56),(20051,7,11,570,'10','2','3',56),(20052,7,11,570,'7','2','4',56),(20053,7,11,570,'M','2','5',56),(20054,7,11,570,'M','2','6',56),(20055,7,11,570,'M','2','7',56),(20056,7,11,570,'M','2','8',56),(20057,7,11,570,'10','3','1',56),(20058,7,11,570,'10','3','2',56),(20059,7,11,570,'10','3','3',56),(20060,7,11,570,'4','3','4',56),(20061,7,11,570,'M','3','5',56),(20062,7,11,570,'M','3','6',56),(20063,7,11,570,'M','3','7',56),(20064,7,11,570,'M','3','8',56),(20065,7,11,570,'10','4','1',56),(20066,7,11,570,'10','4','2',56),(20067,7,11,570,'10','4','3',56),(20068,7,11,570,'10','4','4',56),(20069,7,11,570,'9','4','5',56),(20070,7,11,570,'M','4','6',56),(20071,7,11,570,'M','4','7',56),(20072,7,11,570,'M','4','8',56),(20073,7,11,570,'10','5','1',56),(20074,7,11,570,'10','5','2',56),(20075,7,11,570,'10','5','3',56),(20076,7,11,570,'10','5','4',56),(20077,7,11,570,'10','5','5',56),(20078,7,11,570,'6','5','6',56),(20079,7,11,570,'M','5','7',56),(20080,7,11,570,'M','5','8',56),(20081,7,11,570,'10','6','1',56),(20082,7,11,570,'10','6','2',56),(20083,7,11,570,'10','6','3',56),(20084,7,11,570,'10','6','4',56),(20085,7,11,570,'10','6','5',56),(20086,7,11,570,'10','6','6',56),(20087,7,11,570,'M','6','7',56),(20088,7,11,570,'M','6','8',56),(20089,7,11,570,'10','7','1',56),(20090,7,11,570,'10','7','2',56),(20091,7,11,570,'10','7','3',56),(20092,7,11,570,'10','7','4',56),(20093,7,11,570,'2','7','5',56),(20094,7,11,570,'M','7','6',56),(20095,7,11,570,'M','7','7',56),(20096,7,11,570,'M','7','8',56),(20097,7,11,568,'10','1','1',56),(20098,7,11,568,'10','1','2',56),(20099,7,11,568,'10','1','3',56),(20100,7,11,568,'2','1','4',56),(20101,7,11,568,'M','1','5',56),(20102,7,11,568,'M','1','6',56),(20103,7,11,568,'M','1','7',56),(20104,7,11,568,'M','1','8',56),(20105,7,11,568,'10','2','1',56),(20106,7,11,568,'10','2','2',56),(20107,7,11,568,'10','2','3',56),(20108,7,11,568,'10','2','4',56),(20109,7,11,568,'10','2','5',56),(20110,7,11,568,'10','2','6',56),(20111,7,11,568,'7','2','7',56),(20112,7,11,568,'M','2','8',56),(20113,7,11,568,'10','3','1',56),(20114,7,11,568,'10','3','2',56),(20115,7,11,568,'10','3','3',56),(20116,7,11,568,'10','3','4',56),(20117,7,11,568,'5','3','5',56),(20118,7,11,568,'M','3','6',56),(20119,7,11,568,'M','3','7',56),(20120,7,11,568,'M','3','8',56),(20121,7,11,568,'10','4','1',56),(20122,7,11,568,'10','4','2',56),(20123,7,11,568,'10','4','3',56),(20124,7,11,568,'10','4','4',56),(20125,7,11,568,'1','4','5',56),(20126,7,11,568,'M','4','6',56),(20127,7,11,568,'M','4','7',56),(20128,7,11,568,'M','4','8',56),(20129,7,11,568,'10','5','1',56),(20130,7,11,568,'10','5','2',56),(20131,7,11,568,'9','5','3',56),(20132,7,11,568,'M','5','4',56),(20133,7,11,568,'M','5','5',56),(20134,7,11,568,'M','5','6',56),(20135,7,11,568,'M','5','7',56),(20136,7,11,568,'M','5','8',56),(20137,7,11,568,'10','6','1',56),(20138,7,11,568,'10','6','2',56),(20139,7,11,568,'10','6','3',56),(20140,7,11,568,'10','6','4',56),(20141,7,11,568,'7','6','5',56),(20142,7,11,568,'M','6','6',56),(20143,7,11,568,'M','6','7',56),(20144,7,11,568,'M','6','8',56),(20145,7,11,568,'10','7','1',56),(20146,7,11,568,'10','7','2',56),(20147,7,11,568,'10','7','3',56),(20148,7,11,568,'10','7','4',56),(20149,7,11,568,'1','7','5',56),(20150,7,11,568,'M','7','6',56),(20151,7,11,568,'M','7','7',56),(20152,7,11,568,'M','7','8',56),(20153,7,11,571,'10','1','1',56),(20154,7,11,571,'10','1','2',56),(20155,7,11,571,'10','1','3',56),(20156,7,11,571,'10','1','4',56),(20157,7,11,571,'6','1','5',56),(20158,7,11,571,'M','1','6',56),(20159,7,11,571,'M','1','7',56),(20160,7,11,571,'M','1','8',56),(20161,7,11,571,'10','2','1',56),(20162,7,11,571,'10','2','2',56),(20163,7,11,571,'10','2','3',56),(20164,7,11,571,'4','2','4',56),(20165,7,11,571,'M','2','5',56),(20166,7,11,571,'M','2','6',56),(20167,7,11,571,'M','2','7',56),(20168,7,11,571,'M','2','8',56),(20169,7,11,571,'10','3','1',56),(20170,7,11,571,'10','3','2',56),(20171,7,11,571,'10','3','3',56),(20173,7,11,571,'10','3','4',56),(20174,7,11,571,'4','3','5',56),(20175,7,11,571,'M','3','6',56),(20176,7,11,571,'M','3','7',56),(20177,7,11,571,'M','3','8',56),(20178,7,11,571,'10','4','1',56),(20179,7,11,571,'10','4','2',56),(20180,7,11,571,'10','4','3',56),(20181,7,11,571,'10','4','4',56),(20182,7,11,571,'2','4','5',56),(20183,7,11,571,'M','4','6',56),(20184,7,11,571,'M','4','7',56),(20185,7,11,571,'M','4','8',56),(20186,7,11,571,'10','5','1',56),(20187,7,11,571,'10','5','2',56),(20188,7,11,571,'10','5','3',56),(20189,7,11,571,'10','5','4',56),(20190,7,11,571,'10','5','5',56),(20191,7,11,571,'1','5','6',56),(20192,7,11,571,'M','5','7',56),(20193,7,11,571,'M','5','8',56),(20194,7,11,571,'10','6','1',56),(20195,7,11,571,'10','6','2',56),(20196,7,11,571,'10','6','3',56),(20197,7,11,571,'1','6','4',56),(20198,7,11,571,'M','6','5',56),(20199,7,11,571,'M','6','6',56),(20200,7,11,571,'M','6','7',56),(20201,7,11,571,'M','6','8',56),(20202,7,11,571,'M','7','1',56),(20203,7,11,571,'10','7','4',56),(20204,7,11,571,'10','7','2',56),(20205,7,11,571,'10','7','5',56),(20206,7,11,571,'10','7','3',56),(20208,7,11,571,'1','7','7',56),(20209,7,11,571,'10','7','6',56),(20210,7,11,571,'m','7','8',56),(20211,7,11,573,'10','1','1',56),(20212,7,11,573,'10','1','2',56),(20213,7,11,573,'10','1','3',56),(20214,7,11,573,'10','1','4',56),(20215,7,11,573,'10','1','5',56),(20216,7,11,573,'M','1','6',56),(20217,7,11,573,'M','1','7',56),(20218,7,11,573,'M','1','8',56),(20219,7,11,573,'10','2','1',56),(20220,7,11,573,'10','2','2',56),(20221,7,11,573,'10','2','3',56),(20222,7,11,573,'10','2','4',56),(20223,7,11,573,'10','2','5',56),(20224,7,11,573,'6','2','6',56),(20225,7,11,573,'M','2','7',56),(20226,7,11,573,'M','2','8',56),(20227,7,11,573,'10','3','1',56),(20228,7,11,573,'10','3','2',56),(20229,7,11,573,'5','3','3',56),(20230,7,11,573,'M','3','4',56),(20231,7,11,573,'M','3','5',56),(20232,7,11,573,'M','3','6',56),(20233,7,11,573,'M','3','7',56),(20234,7,11,573,'M','3','8',56),(20235,7,11,573,'10','4','1',56),(20236,7,11,573,'10','4','2',56),(20237,7,11,573,'10','4','3',56),(20238,7,11,573,'10','4','4',56),(20240,7,11,573,'M','4','6',56),(20242,7,11,573,'M','4','8',56),(20243,7,11,573,'M','4','7',56),(20244,7,11,573,'6','4','5',56),(20245,7,11,573,'10','5','1',56),(20246,7,11,573,'10','5','2',56),(20247,7,11,573,'10','5','3',56),(20248,7,11,573,'2','5','4',56),(20249,7,11,573,'M','5','5',56),(20250,7,11,573,'M','5','6',56),(20251,7,11,573,'M','5','7',56),(20252,7,11,573,'M','5','8',56),(20253,7,11,573,'10','6','1',56),(20254,7,11,573,'10','6','2',56),(20255,7,11,573,'10','6','3',56),(20256,7,11,573,'7','6','4',56),(20257,7,11,573,'M','6','5',56),(20258,7,11,573,'M','6','6',56),(20259,7,11,573,'M','6','7',56),(20260,7,11,573,'M','6','8',56),(20261,7,11,573,'10','7','1',56),(20262,7,11,573,'10','7','2',56),(20263,7,11,573,'10','7','3',56),(20264,7,11,573,'10','7','4',56),(20265,7,11,573,'10','7','5',56),(20266,7,11,573,'1','7','6',56),(20267,7,11,573,'M','7','7',56),(20268,7,11,573,'M','7','8',56),(20269,7,11,574,'10','1','2',56),(20270,7,11,574,'10','1','1',56),(20271,7,11,574,'10','1','3',56),(20272,7,11,574,'10','1','4',56),(20273,7,11,574,'10','1','5',56),(20274,7,11,574,'6','1','6',56),(20275,7,11,574,'M','1','7',56),(20276,7,11,574,'M','1','8',56),(20277,7,11,574,'10','2','1',56),(20278,7,11,574,'10','2','2',56),(20279,7,11,574,'10','2','3',56),(20281,7,11,574,'M','2','5',56),(20282,7,11,574,'M','2','6',56),(20283,7,11,574,'M','2','7',56),(20284,7,11,574,'M','2','8',56),(20285,7,11,574,'8','2','4',56),(20286,7,11,574,'10','3','1',56),(20287,7,11,574,'10','3','2',56),(20288,7,11,574,'10','3','3',56),(20289,7,11,574,'10','3','4',56),(20290,7,11,574,'10','3','5',56),(20291,7,11,574,'M','3','6',56),(20292,7,11,574,'M','3','7',56),(20293,7,11,574,'M','3','8',56),(20294,7,11,574,'10','4','1',56),(20295,7,11,574,'10','4','2',56),(20296,7,11,574,'10','4','3',56),(20297,7,11,574,'10','4','4',56),(20298,7,11,574,'3','4','5',56),(20299,7,11,574,'M','4','6',56),(20300,7,11,574,'M','4','7',56),(20301,7,11,574,'M','4','8',56),(20302,7,11,574,'10','5','1',56),(20303,7,11,574,'10','5','2',56),(20304,7,11,574,'3','5','3',56),(20305,7,11,574,'M','5','4',56),(20306,7,11,574,'M','5','5',56),(20307,7,11,574,'M','5','6',56),(20308,7,11,574,'M','5','7',56),(20309,7,11,574,'M','5','8',56),(20310,7,11,574,'10','6','1',56),(20311,7,11,574,'10','6','2',56),(20312,7,11,574,'10','6','3',56),(20313,7,11,574,'10','6','4',56),(20314,7,11,574,'M','6','5',56),(20315,7,11,574,'M','6','6',56),(20316,7,11,574,'M','6','7',56),(20317,7,11,574,'M','6','8',56),(20318,7,11,574,'10','7','1',56),(20319,7,11,574,'10','7','2',56),(20320,7,11,574,'10','7','3',56),(20321,7,11,574,'10','7','4',56),(20322,7,11,574,'6','7','5',56),(20323,7,11,574,'M','7','6',56),(20324,7,11,574,'M','7','7',56),(20325,7,11,574,'M','7','8',56),(20326,7,11,576,'10','1','1',56),(20327,7,11,576,'10','1','2',56),(20328,7,11,576,'10','1','3',56),(20329,7,11,576,'10','1','4',56),(20330,7,11,576,'9','1','5',56),(20331,7,11,576,'M','1','6',56),(20332,7,11,576,'M','1','7',56),(20333,7,11,576,'M','1','8',56),(20334,7,11,576,'10','2','1',56),(20335,7,11,576,'10','2','2',56),(20336,7,11,576,'10','2','3',56),(20337,7,11,576,'10','2','4',56),(20338,7,11,576,'4','2','5',56),(20339,7,11,576,'M','2','6',56),(20340,7,11,576,'M','2','7',56),(20341,7,11,576,'M','2','8',56),(20342,7,11,576,'10','3','1',56),(20343,7,11,576,'10','3','2',56),(20344,7,11,576,'10','3','3',56),(20345,7,11,576,'10','3','4',56),(20346,7,11,576,'10','3','5',56),(20347,7,11,576,'5','3','6',56),(20348,7,11,576,'M','3','7',56),(20349,7,11,576,'M','3','8',56),(20350,7,11,576,'10','4','1',56),(20351,7,11,576,'10','4','2',56),(20352,7,11,576,'1','4','3',56),(20353,7,11,576,'M','4','4',56),(20354,7,11,576,'M','4','5',56),(20355,7,11,576,'M','4','6',56),(20356,7,11,576,'M','4','7',56),(20357,7,11,576,'M','4','8',56),(20358,7,11,576,'10','5','1',56),(20359,7,11,576,'10','5','2',56),(20360,7,11,576,'10','5','3',56),(20361,7,11,576,'2','5','4',56),(20362,7,11,576,'M','5','5',56),(20363,7,11,576,'M','5','6',56),(20364,7,11,576,'M','5','7',56),(20365,7,11,576,'M','5','8',56),(20366,7,11,576,'10','6','1',56),(20367,7,11,576,'10','6','2',56),(20368,7,11,576,'10','6','3',56),(20369,7,11,576,'10','6','4',56),(20370,7,11,576,'2','6','5',56),(20371,7,11,576,'M','6','6',56),(20372,7,11,576,'M','6','7',56),(20373,7,11,576,'M','6','8',56),(20374,7,11,576,'10','7','1',56),(20375,7,11,576,'10','7','2',56),(20376,7,11,576,'10','7','3',56),(20377,7,11,576,'10','7','4',56),(20378,7,11,576,'8','7','5',56),(20380,7,11,576,'M','7','7',56),(20381,7,11,576,'M','7','8',56),(20382,7,11,576,'M','7','6',56),(20383,7,11,579,'10','1','1',56),(20384,7,11,579,'10','1','2',56),(20385,7,11,579,'10','1','3',56),(20386,7,11,579,'10','1','4',56),(20387,7,11,579,'10','1','5',56),(20388,7,11,579,'8','1','6',56),(20389,7,11,579,'M','1','7',56),(20390,7,11,579,'M','1','8',56),(20391,7,11,579,'10','2','1',56),(20392,7,11,579,'10','2','2',56),(20393,7,11,579,'10','2','3',56),(20394,7,11,579,'10','2','4',56),(20395,7,11,579,'8','2','5',56),(20396,7,11,579,'M','2','6',56),(20397,7,11,579,'M','2','7',56),(20398,7,11,579,'M','2','8',56),(20399,7,11,579,'10','3','1',56),(20400,7,11,579,'10','3','2',56),(20401,7,11,579,'10','3','3',56),(20402,7,11,579,'10','3','4',56),(20403,7,11,579,'10','3','5',56),(20404,7,11,579,'7','3','6',56),(20405,7,11,579,'M','3','7',56),(20406,7,11,579,'M','3','8',56),(20407,7,11,579,'10','4','1',56),(20408,7,11,579,'10','4','2',56),(20409,7,11,579,'10','4','3',56),(20410,7,11,579,'10','4','4',56),(20411,7,11,579,'5','4','5',56),(20412,7,11,579,'M','4','6',56),(20413,7,11,579,'M','4','7',56),(20414,7,11,579,'M','4','8',56),(20415,7,11,579,'10','5','1',56),(20416,7,11,579,'10','5','2',56),(20417,7,11,579,'8','5','3',56),(20418,7,11,579,'M','5','4',56),(20419,7,11,579,'M','5','5',56),(20420,7,11,579,'M','5','6',56),(20421,7,11,579,'M','5','7',56),(20422,7,11,579,'M','5','8',56),(20423,7,11,579,'10','6','1',56),(20424,7,11,579,'4','6','2',56),(20425,7,11,579,'M','6','3',56),(20426,7,11,579,'M','6','4',56),(20427,7,11,579,'M','6','5',56),(20428,7,11,579,'M','6','6',56),(20429,7,11,579,'M','6','7',56),(20430,7,11,579,'M','6','8',56),(20431,7,11,579,'10','7','1',56),(20432,7,11,579,'10','7','2',56),(20433,7,11,579,'10','7','3',56),(20434,7,11,579,'7','7','4',56),(20435,7,11,579,'M','7','5',56),(20436,7,11,579,'M','7','6',56),(20437,7,11,579,'M','7','7',56),(20438,7,11,579,'M','7','8',56),(20439,7,11,581,'10','1','1',56),(20440,7,11,581,'10','1','2',56),(20441,7,11,581,'10','1','3',56),(20442,7,11,581,'10','1','4',56),(20443,7,11,581,'1','1','5',56),(20444,7,11,581,'M','1','6',56),(20445,7,11,581,'M','1','7',56),(20446,7,11,581,'M','1','8',56),(20447,7,11,581,'10','2','1',56),(20448,7,11,581,'8','2','2',56),(20449,7,11,581,'M','2','3',56),(20450,7,11,581,'M','2','4',56),(20451,7,11,581,'M','2','5',56),(20452,7,11,581,'M','2','6',56),(20453,7,11,581,'M','2','7',56),(20454,7,11,581,'M','2','8',56),(20455,7,11,581,'10','3','1',56),(20456,7,11,581,'10','3','2',56),(20457,7,11,581,'10','3','3',56),(20458,7,11,581,'4','3','4',56),(20459,7,11,581,'M','3','5',56),(20460,7,11,581,'M','3','6',56),(20461,7,11,581,'M','3','7',56),(20462,7,11,581,'M','3','8',56),(20463,7,11,581,'10','4','1',56),(20464,7,11,581,'10','4','2',56),(20465,7,11,581,'9','4','3',56),(20466,7,11,581,'M','4','4',56),(20467,7,11,581,'M','4','5',56),(20468,7,11,581,'M','4','6',56),(20469,7,11,581,'M','4','7',56),(20470,7,11,581,'M','4','8',56),(20471,7,11,581,'10','5','1',56),(20472,7,11,581,'10','5','2',56),(20473,7,11,581,'10','5','3',56),(20474,7,11,581,'10','5','4',56),(20475,7,11,581,'4','5','5',56),(20476,7,11,581,'M','5','6',56),(20477,7,11,581,'M','5','7',56),(20478,7,11,581,'M','5','8',56),(20479,7,11,581,'10','6','1',56),(20480,7,11,581,'10','6','2',56),(20481,7,11,581,'10','6','3',56),(20482,7,11,581,'10','6','4',56),(20483,7,11,581,'10','6','5',56),(20484,7,11,581,'4','6','6',56),(20485,7,11,581,'M','6','7',56),(20486,7,11,581,'M','6','8',56),(20487,7,11,581,'10','7','1',56),(20488,7,11,581,'10','7','2',56),(20489,7,11,581,'10','7','3',56),(20490,7,11,581,'10','7','4',56),(20491,7,11,581,'6','7','5',56),(20492,7,11,581,'M','7','6',56),(20493,7,11,581,'M','7','7',56),(20494,7,11,581,'M','7','8',56),(20495,7,11,583,'10','1','1',56),(20496,7,11,583,'2','1','2',56),(20497,7,11,583,'M','1','3',56),(20498,7,11,583,'M','1','4',56),(20499,7,11,583,'M','1','5',56),(20500,7,11,583,'M','1','6',56),(20501,7,11,583,'M','1','7',56),(20502,7,11,583,'M','1','8',56),(20503,7,11,583,'10','2','1',56),(20504,7,11,583,'10','2','2',56),(20505,7,11,583,'10','2','3',56),(20506,7,11,583,'10','2','4',56),(20507,7,11,583,'6','2','5',56),(20508,7,11,583,'M','2','6',56),(20509,7,11,583,'M','2','7',56),(20510,7,11,583,'M','2','8',56),(20511,7,11,583,'10','3','1',56),(20512,7,11,583,'10','3','2',56),(20513,7,11,583,'10','3','3',56),(20514,7,11,583,'2','3','4',56),(20515,7,11,583,'M','3','5',56),(20516,7,11,583,'M','3','6',56),(20517,7,11,583,'M','3','7',56),(20518,7,11,583,'M','3','8',56),(20519,7,11,583,'10','4','1',56),(20520,7,11,583,'10','4','2',56),(20521,7,11,583,'10','4','3',56),(20522,7,11,583,'10','4','4',56),(20523,7,11,583,'4','4','5',56),(20524,7,11,583,'M','4','6',56),(20525,7,11,583,'M','4','7',56),(20526,7,11,583,'M','4','8',56),(20527,7,11,583,'10','5','1',56),(20528,7,11,583,'10','5','2',56),(20529,7,11,583,'10','5','3',56),(20530,7,11,583,'4','5','4',56),(20531,7,11,583,'M','5','5',56),(20532,7,11,583,'M','5','6',56),(20533,7,11,583,'M','5','7',56),(20534,7,11,583,'M','5','8',56),(20535,7,11,583,'10','6','1',56),(20536,7,11,583,'10','6','2',56),(20537,7,11,583,'10','6','3',56),(20538,7,11,583,'10','6','4',56),(20539,7,11,583,'1','6','5',56),(20540,7,11,583,'M','6','6',56),(20541,7,11,583,'M','6','7',56),(20542,7,11,583,'M','6','8',56),(20543,7,11,583,'10','7','1',56),(20545,7,11,583,'10','7','2',56),(20546,7,11,583,'8','7','3',56),(20547,7,11,583,'M','7','4',56),(20548,7,11,583,'M','7','5',56),(20549,7,11,583,'M','7','6',56),(20550,7,11,583,'M','7','7',56),(20551,7,11,583,'M','7','8',56),(20552,7,11,585,'10','1','1',56),(20553,7,11,585,'10','1','2',56),(20554,7,11,585,'7','1','3',56),(20555,7,11,585,'M','1','4',56),(20556,7,11,585,'M','1','5',56),(20557,7,11,585,'M','1','6',56),(20558,7,11,585,'M','1','7',56),(20559,7,11,585,'M','1','8',56),(20560,7,11,585,'10','2','1',56),(20562,7,11,585,'10','2','3',56),(20564,7,11,585,'10','2','5',56),(20565,7,11,585,'M','2','6',56),(20566,7,11,585,'M','2','7',56),(20567,7,11,585,'M','2','8',56),(20568,7,11,585,'10','2','2',56),(20569,7,11,585,'10','2','4',56),(20570,7,11,585,'10','3','1',56),(20571,7,11,585,'8','3','2',56),(20572,7,11,585,'M','3','3',56),(20573,7,11,585,'M','3','4',56),(20574,7,11,585,'M','3','5',56),(20575,7,11,585,'M','3','6',56),(20576,7,11,585,'M','3','7',56),(20577,7,11,585,'M','3','8',56),(20578,7,11,585,'10','4','1',56),(20579,7,11,585,'10','4','2',56),(20580,7,11,585,'10','4','3',56),(20581,7,11,585,'10','4','4',56),(20582,7,11,585,'10','4','5',56),(20583,7,11,585,'M','4','6',56),(20584,7,11,585,'M','4','7',56),(20585,7,11,585,'M','4','8',56),(20586,7,11,585,'10','5','1',56),(20587,7,11,585,'10','5','2',56),(20588,7,11,585,'M','5','3',56),(20589,7,11,585,'M','5','4',56),(20590,7,11,585,'M','5','5',56),(20591,7,11,585,'M','5','6',56),(20592,7,11,585,'M','5','7',56),(20593,7,11,585,'M','5','8',56),(20594,7,11,585,'10','6','2',56),(20595,7,11,585,'9','6','3',56),(20596,7,11,585,'M','6','4',56),(20597,7,11,585,'M','6','5',56),(20598,7,11,585,'M','6','6',56),(20600,7,11,585,'M','6','8',56),(20601,7,11,585,'M','6','7',56),(20602,7,11,585,'10','7','1',56),(20603,7,11,585,'10','7','2',56),(20604,7,11,585,'10','7','3',56),(20605,7,11,585,'10','7','4',56),(20606,7,11,585,'1','7','5',56),(20607,7,11,585,'M','7','6',56),(20608,7,11,585,'M','7','7',56),(20609,7,11,585,'M','7','8',56),(20611,7,11,586,'10','1','2',56),(20612,7,11,586,'6','1','3',56),(20613,7,11,586,'M','1','4',56),(20614,7,11,586,'M','1','5',56),(20615,7,11,586,'M','1','6',56),(20616,7,11,586,'M','1','7',56),(20617,7,11,586,'M','1','8',56),(20618,7,11,586,'10','1','1',56),(20619,7,11,586,'10','2','1',56),(20620,7,11,586,'10','2','2',56),(20621,7,11,586,'10','2','3',56),(20622,7,11,586,'4','2','4',56),(20623,7,11,586,'M','2','5',56),(20624,7,11,586,'M','2','6',56),(20625,7,11,586,'M','2','7',56),(20626,7,11,586,'M','2','8',56),(20627,7,11,586,'10','3','1',56),(20628,7,11,586,'10','3','2',56),(20629,7,11,586,'10','3','3',56),(20630,7,11,586,'10','3','4',56),(20631,7,11,586,'2','3','5',56),(20632,7,11,586,'M','3','6',56),(20633,7,11,586,'M','3','7',56),(20634,7,11,586,'M','3','8',56),(20635,7,11,586,'10','4','1',56),(20636,7,11,586,'9','4','2',56),(20637,7,11,586,'M','4','3',56),(20638,7,11,586,'M','4','4',56),(20639,7,11,586,'M','4','5',56),(20640,7,11,586,'M','4','6',56),(20641,7,11,586,'M','4','7',56),(20642,7,11,586,'M','4','8',56),(20643,7,11,586,'10','5','1',56),(20644,7,11,586,'10','5','2',56),(20645,7,11,586,'2','5','3',56),(20646,7,11,586,'M','5','4',56),(20647,7,11,586,'M','5','5',56),(20648,7,11,586,'M','5','6',56),(20649,7,11,586,'M','5','7',56),(20650,7,11,586,'M','5','8',56),(20651,7,11,586,'10','6','1',56),(20652,7,11,586,'10','6','2',56),(20653,7,11,586,'10','6','3',56),(20654,7,11,586,'10','6','4',56),(20655,7,11,586,'10','6','5',56),(20656,7,11,586,'5','6','6',56),(20657,7,11,586,'M','6','7',56),(20658,7,11,586,'M','6','8',56),(20659,7,11,586,'10','7','1',56),(20660,7,11,586,'10','7','2',56),(20661,7,11,586,'10','7','3',56),(20662,7,11,586,'1','7','4',56),(20663,7,11,586,'M','7','5',56),(20664,7,11,586,'M','7','6',56),(20665,7,11,586,'M','7','7',56),(20666,7,11,586,'M','7','8',56),(20667,7,11,589,'10','1','1',56),(20668,7,11,589,'10','1','2',56),(20669,7,11,589,'10','1','3',56),(20670,7,11,589,'7','1','4',56),(20671,7,11,589,'M','1','5',56),(20672,7,11,589,'M','1','6',56),(20673,7,11,589,'M','1','7',56),(20674,7,11,589,'M','1','8',56),(20675,7,11,589,'10','2','1',56),(20676,7,11,589,'10','2','2',56),(20677,7,11,589,'M','2','3',56),(20678,7,11,589,'M','2','4',56),(20679,7,11,589,'M','2','5',56),(20680,7,11,589,'M','2','6',56),(20681,7,11,589,'M','2','7',56),(20682,7,11,589,'M','2','8',56),(20683,7,11,589,'10','3','1',56),(20684,7,11,589,'4','3','2',56),(20685,7,11,589,'M','3','3',56),(20686,7,11,589,'M','3','4',56),(20687,7,11,589,'M','3','5',56),(20688,7,11,589,'M','3','6',56),(20690,7,11,589,'M','3','8',56),(20691,7,11,589,'M','3','7',56),(20692,7,11,589,'10','4','1',56),(20693,7,11,589,'9','4','2',56),(20694,7,11,589,'M','4','3',56),(20695,7,11,589,'M','4','4',56),(20696,7,11,589,'M','4','5',56),(20697,7,11,589,'M','4','6',56),(20698,7,11,589,'M','4','7',56),(20699,7,11,589,'M','4','8',56),(20700,7,11,589,'10','5','1',56),(20701,7,11,589,'10','5','2',56),(20702,7,11,589,'10','5','3',56),(20703,7,11,589,'10','5','4',56),(20704,7,11,589,'M','5','5',56),(20705,7,11,589,'M','5','6',56),(20706,7,11,589,'M','5','7',56),(20707,7,11,589,'M','5','8',56),(20708,7,11,589,'10','6','1',56),(20709,7,11,589,'10','6','2',56),(20710,7,11,589,'10','6','3',56),(20711,7,11,589,'1','6','4',56),(20712,7,11,589,'M','6','5',56),(20713,7,11,589,'M','6','6',56),(20714,7,11,589,'M','6','7',56),(20715,7,11,589,'M','6','8',56),(20716,7,11,589,'10','7','1',56),(20717,7,11,589,'10','7','2',56),(20718,7,11,589,'10','7','3',56),(20719,7,11,589,'2','7','4',56),(20720,7,11,589,'M','7','5',56),(20721,7,11,589,'M','7','6',56),(20722,7,11,589,'M','7','7',56),(20723,7,11,589,'M','7','8',56),(20724,7,11,590,'10','1','1',56),(20725,7,11,590,'8','1','2',56),(20726,7,11,590,'M','1','3',56),(20727,7,11,590,'M','1','4',56),(20728,7,11,590,'M','1','5',56),(20729,7,11,590,'M','1','6',56),(20730,7,11,590,'M','1','7',56),(20731,7,11,590,'M','1','8',56),(20732,7,11,590,'10','2','1',56),(20733,7,11,590,'10','2','2',56),(20734,7,11,590,'10','2','3',56),(20735,7,11,590,'10','2','4',56),(20736,7,11,590,'5','2','5',56),(20737,7,11,590,'M','2','6',56),(20738,7,11,590,'M','2','7',56),(20739,7,11,590,'M','2','8',56),(20740,7,11,590,'10','3','1',56),(20741,7,11,590,'5','3','2',56),(20742,7,11,590,'M','3','3',56),(20743,7,11,590,'M','3','4',56),(20744,7,11,590,'M','3','5',56),(20745,7,11,590,'M','3','6',56),(20746,7,11,590,'M','3','7',56),(20747,7,11,590,'M','3','8',56),(20748,7,11,590,'10','4','1',56),(20749,7,11,590,'10','4','2',56),(20750,7,11,590,'M','4','3',56),(20751,7,11,590,'M','4','4',56),(20752,7,11,590,'M','4','5',56),(20753,7,11,590,'M','4','6',56),(20754,7,11,590,'M','4','7',56),(20755,7,11,590,'M','4','8',56),(20756,7,11,590,'10','5','1',56),(20757,7,11,590,'10','5','2',56),(20758,7,11,590,'3','5','3',56),(20759,7,11,590,'M','5','4',56),(20760,7,11,590,'M','5','5',56),(20761,7,11,590,'M','5','6',56),(20762,7,11,590,'M','5','7',56),(20763,7,11,590,'M','5','8',56),(20764,7,11,590,'10','6','1',56),(20765,7,11,590,'10','6','2',56),(20766,7,11,590,'4','6','3',56),(20767,7,11,590,'M','6','4',56),(20768,7,11,590,'M','6','5',56),(20769,7,11,590,'M','6','6',56),(20770,7,11,590,'M','6','7',56),(20771,7,11,590,'M','6','8',56),(20772,7,11,590,'10','7','1',56),(20773,7,11,590,'10','7','2',56),(20774,7,11,590,'10','7','3',56),(20775,7,11,590,'M','7','4',56),(20776,7,11,590,'M','7','5',56),(20777,7,11,590,'M','7','6',56),(20778,7,11,590,'M','7','7',56),(20779,7,11,590,'M','7','8',56),(20780,7,11,338,'10','1','1',56),(20781,7,11,338,'4','1','2',56),(20782,7,11,338,'M','1','3',56),(20783,7,11,338,'M','1','4',56),(20784,7,11,338,'M','1','5',56),(20785,7,11,338,'M','1','6',56),(20786,7,11,338,'M','1','7',56),(20787,7,11,338,'M','1','8',56),(20788,7,11,338,'10','2','1',56),(20789,7,11,338,'10','2','2',56),(20790,7,11,338,'10','2','3',56),(20791,7,11,338,'M','2','4',56),(20792,7,11,338,'M','2','5',56),(20793,7,11,338,'M','2','6',56),(20794,7,11,338,'M','2','7',56),(20795,7,11,338,'M','2','8',56),(20796,7,11,338,'10','3','1',56),(20797,7,11,338,'10','3','2',56),(20798,7,11,338,'4','3','3',56),(20799,7,11,338,'M','3','4',56),(20800,7,11,338,'M','3','5',56),(20801,7,11,338,'M','3','6',56),(20802,7,11,338,'M','3','7',56),(20803,7,11,338,'M','3','8',56),(20804,7,11,338,'10','4','1',56),(20805,7,11,338,'10','4','2',56),(20806,7,11,338,'3','4','3',56),(20807,7,11,338,'M','4','4',56),(20808,7,11,338,'M','4','5',56),(20809,7,11,338,'M','4','6',56),(20810,7,11,338,'M','4','7',56),(20811,7,11,338,'M','4','8',56),(20812,7,11,338,'10','5','1',56),(20813,7,11,338,'10','5','2',56),(20814,7,11,338,'6','5','3',56),(20815,7,11,338,'M','5','4',56),(20816,7,11,338,'M','5','5',56),(20817,7,11,338,'M','5','6',56),(20818,7,11,338,'M','5','7',56),(20819,7,11,338,'M','5','8',56),(20820,7,11,338,'10','6','1',56),(20821,7,11,338,'8','6','2',56),(20822,7,11,338,'M','6','3',56),(20823,7,11,338,'M','6','4',56),(20824,7,11,338,'M','6','5',56),(20825,7,11,338,'M','6','6',56),(20826,7,11,338,'M','6','7',56),(20827,7,11,338,'M','6','8',56),(20828,7,11,338,'10','7','1',56),(20829,7,11,338,'8','7','2',56),(20830,7,11,338,'M','7','3',56),(20831,7,11,338,'M','7','4',56),(20832,7,11,338,'M','7','5',56),(20833,7,11,338,'M','7','6',56),(20834,7,11,338,'M','7','7',56),(20835,7,11,338,'M','7','8',56),(20837,7,11,592,'5','1','1',56),(20838,7,11,592,'M','1','2',56),(20839,7,11,592,'M','1','3',56),(20840,7,11,592,'M','1','4',56),(20841,7,11,592,'M','1','5',56),(20842,7,11,592,'M','1','6',56),(20843,7,11,592,'M','1','7',56),(20844,7,11,592,'M','1','8',56),(20845,7,11,592,'10','2','1',56),(20846,7,11,592,'10','2','2',56),(20847,7,11,592,'7','2','3',56),(20848,7,11,592,'M','2','4',56),(20849,7,11,592,'M','2','5',56),(20850,7,11,592,'M','2','6',56),(20851,7,11,592,'M','2','7',56),(20852,7,11,592,'M','2','8',56),(20853,7,11,592,'10','3','1',56),(20854,7,11,592,'10','3','2',56),(20855,7,11,592,'6','3','3',56),(20856,7,11,592,'M','3','4',56),(20857,7,11,592,'M','3','5',56),(20858,7,11,592,'M','3','6',56),(20859,7,11,592,'M','3','7',56),(20860,7,11,592,'M','3','8',56),(20861,7,11,592,'10','4','1',56),(20862,7,11,592,'8','4','2',56),(20863,7,11,592,'M','4','3',56),(20864,7,11,592,'M','4','4',56),(20865,7,11,592,'M','4','5',56),(20866,7,11,592,'M','4','6',56),(20867,7,11,592,'M','4','7',56),(20868,7,11,592,'M','4','8',56),(20869,7,11,592,'10','5','1',56),(20870,7,11,592,'3','5','2',56),(20871,7,11,592,'M','5','3',56),(20872,7,11,592,'M','5','4',56),(20873,7,11,592,'M','5','5',56),(20874,7,11,592,'M','5','6',56),(20875,7,11,592,'M','5','7',56),(20876,7,11,592,'M','5','8',56),(20877,7,11,592,'10','6','1',56),(20878,7,11,592,'10','6','2',56),(20879,7,11,592,'10','6','3',56),(20880,7,11,592,'5','6','4',56),(20881,7,11,592,'M','6','5',56),(20882,7,11,592,'M','6','6',56),(20883,7,11,592,'M','6','7',56),(20884,7,11,592,'M','6','8',56),(20885,7,11,592,'10','7','1',56),(20886,7,11,592,'10','7','2',56),(20887,7,11,592,'1','7','3',56),(20890,7,11,592,'M','7','4',56),(20891,7,11,592,'M','7','6',56),(20892,7,11,592,'M','7','7',56),(20893,7,11,592,'M','7','5',56),(20894,7,11,592,'M','7','8',56),(20895,7,11,593,'10','1','1',56),(20896,7,11,593,'10','1','2',56),(20897,7,11,593,'10','1','3',56),(20898,7,11,593,'7','1','4',56),(20899,7,11,593,'M','1','5',56),(20900,7,11,593,'M','1','6',56),(20901,7,11,593,'M','1','7',56),(20902,7,11,593,'M','1','8',56),(20903,7,11,593,'7','2','1',56),(20904,7,11,593,'M','2','2',56),(20905,7,11,593,'M','2','3',56),(20906,7,11,593,'M','2','4',56),(20907,7,11,593,'M','2','5',56),(20908,7,11,593,'M','2','6',56),(20909,7,11,593,'M','2','7',56),(20910,7,11,593,'M','2','8',56),(20911,7,11,593,'6','3','1',56),(20912,7,11,593,'M','3','2',56),(20913,7,11,593,'M','3','3',56),(20914,7,11,593,'M','3','4',56),(20915,7,11,593,'M','3','5',56),(20916,7,11,593,'M','3','6',56),(20917,7,11,593,'M','3','7',56),(20918,7,11,593,'M','3','8',56),(20919,7,11,593,'10','4','1',56),(20920,7,11,593,'4','4','2',56),(20921,7,11,593,'M','4','3',56),(20922,7,11,593,'M','4','4',56),(20923,7,11,593,'M','4','5',56),(20924,7,11,593,'M','4','6',56),(20925,7,11,593,'M','4','7',56),(20926,7,11,593,'M','4','8',56),(20927,7,11,593,'10','5','1',56),(20928,7,11,593,'10','5','2',56),(20929,7,11,593,'6','5','3',56),(20930,7,11,593,'M','5','4',56),(20931,7,11,593,'M','5','5',56),(20932,7,11,593,'M','5','6',56),(20933,7,11,593,'M','5','7',56),(20934,7,11,593,'M','5','8',56),(20935,7,11,593,'10','6','1',56),(20936,7,11,593,'10','6','2',56),(20937,7,11,593,'8','6','3',56),(20938,7,11,593,'M','6','4',56),(20939,7,11,593,'M','6','5',56),(20940,7,11,593,'M','6','6',56),(20941,7,11,593,'M','6','7',56),(20942,7,11,593,'M','6','8',56),(20943,7,11,593,'10','7','1',56),(20944,7,11,593,'10','7','2',56),(20945,7,11,593,'4','7','3',56),(20946,7,11,593,'M','7','4',56),(20947,7,11,593,'M','7','5',56),(20948,7,11,593,'M','7','6',56),(20949,7,11,593,'M','7','7',56),(20950,7,11,593,'M','7','8',56),(20951,7,11,594,'M','1','1',56),(20952,7,11,594,'M','1','2',56),(20953,7,11,594,'M','1','3',56),(20954,7,11,594,'M','1','4',56),(20955,7,11,594,'M','1','5',56),(20956,7,11,594,'M','1','6',56),(20957,7,11,594,'M','1','7',56),(20958,7,11,594,'M','1','8',56),(20959,7,11,594,'M','2','1',56),(20960,7,11,594,'M','2','2',56),(20961,7,11,594,'M','2','3',56),(20962,7,11,594,'M','2','4',56),(20963,7,11,594,'M','2','5',56),(20964,7,11,594,'M','2','6',56),(20965,7,11,594,'M','2','7',56),(20966,7,11,594,'M','2','8',56),(20967,7,11,594,'M','3','1',56),(20968,7,11,594,'M','3','2',56),(20969,7,11,594,'M','3','3',56),(20970,7,11,594,'M','3','4',56),(20971,7,11,594,'M','3','5',56),(20972,7,11,594,'M','3','6',56),(20973,7,11,594,'M','3','7',56),(20974,7,11,594,'M','3','8',56),(20975,7,11,594,'M','4','1',56),(20976,7,11,594,'M','4','2',56),(20977,7,11,594,'M','4','3',56),(20978,7,11,594,'M','4','4',56),(20979,7,11,594,'M','4','5',56),(20980,7,11,594,'M','4','6',56),(20981,7,11,594,'M','4','7',56),(20982,7,11,594,'M','4','8',56),(20983,7,11,594,'M','5','1',56),(20984,7,11,594,'M','5','2',56),(20985,7,11,594,'M','5','3',56),(20986,7,11,594,'M','5','4',56),(20987,7,11,594,'M','5','5',56),(20988,7,11,594,'M','5','6',56),(20989,7,11,594,'M','5','7',56),(20990,7,11,594,'M','5','8',56),(20991,7,11,594,'M','6','1',56),(20992,7,11,594,'M','6','2',56),(20993,7,11,594,'M','6','3',56),(20994,7,11,594,'M','6','4',56),(20995,7,11,594,'M','6','5',56),(20996,7,11,594,'M','6','6',56),(20997,7,11,594,'M','6','7',56),(20998,7,11,594,'M','6','8',56),(20999,7,11,594,'M','7','1',56),(21000,7,11,594,'M','7','2',56),(21001,7,11,594,'M','7','3',56),(21002,7,11,594,'M','7','4',56),(21003,7,11,594,'M','7','5',56),(21004,7,11,594,'M','7','6',56),(21005,7,11,594,'M','7','7',56),(21006,7,11,594,'M','7','8',56),(21007,7,11,596,'M','1','1',56),(21008,7,11,596,'M','1','2',56),(21009,7,11,596,'M','1','3',56),(21010,7,11,596,'M','1','4',56),(21011,7,11,596,'M','1','5',56),(21012,7,11,596,'M','1','6',56),(21013,7,11,596,'M','1','7',56),(21014,7,11,596,'M','1','8',56),(21015,7,11,596,'M','2','1',56),(21016,7,11,596,'M','2','2',56),(21017,7,11,596,'M','2','3',56),(21018,7,11,596,'M','2','4',56),(21019,7,11,596,'M','2','5',56),(21020,7,11,596,'M','2','6',56),(21021,7,11,596,'M','2','7',56),(21022,7,11,596,'M','2','8',56),(21023,7,11,596,'M','3','1',56),(21024,7,11,596,'M','3','2',56),(21025,7,11,596,'M','3','3',56),(21026,7,11,596,'M','3','4',56),(21027,7,11,596,'M','3','5',56),(21028,7,11,596,'M','3','6',56),(21029,7,11,596,'M','3','7',56),(21030,7,11,596,'M','3','8',56),(21031,7,11,596,'M','4','1',56),(21032,7,11,596,'M','4','2',56),(21033,7,11,596,'M','4','3',56),(21034,7,11,596,'M','4','4',56),(21035,7,11,596,'M','4','5',56),(21036,7,11,596,'M','4','6',56),(21037,7,11,596,'M','4','7',56),(21038,7,11,596,'M','4','8',56),(21039,7,11,596,'M','5','1',56),(21040,7,11,596,'M','5','2',56),(21041,7,11,596,'M','5','3',56),(21042,7,11,596,'M','5','4',56),(21043,7,11,596,'M','5','5',56),(21044,7,11,596,'M','5','6',56),(21045,7,11,596,'M','5','7',56),(21046,7,11,596,'M','5','8',56),(21047,7,11,596,'M','6','1',56),(21048,7,11,596,'M','6','2',56),(21049,7,11,596,'M','6','3',56),(21050,7,11,596,'M','6','4',56),(21051,7,11,596,'M','6','5',56),(21052,7,11,596,'M','6','6',56),(21053,7,11,596,'M','6','7',56),(21054,7,11,596,'M','6','8',56),(21055,7,11,596,'M','7','1',56),(21056,7,11,596,'M','7','2',56),(21057,7,11,596,'M','7','3',56),(21058,7,11,596,'M','7','4',56),(21059,7,11,596,'M','7','5',56),(21060,7,11,596,'M','7','6',56),(21061,7,11,596,'M','7','7',56),(21062,7,11,596,'M','7','8',56),(21063,11,11,293,'10','3','8',50),(21066,11,11,293,'10','5','1',50),(21067,11,11,293,'M','4','9',50),(21068,11,11,293,'4','5','9',50),(21069,11,11,293,'10','5','2',50),(21070,11,11,295,'10','1','1',50),(21071,11,11,295,'10','1','2',50),(21072,11,11,295,'10','1','3',50),(21073,11,11,295,'10','1','4',50),(21074,11,11,295,'10','1','5',50),(21075,11,11,295,'10','1','6',50),(21076,11,11,295,'10','1','7',50),(21077,11,11,295,'10','1','8',50),(21078,11,11,295,'4','1','9',50),(21079,11,11,295,'10','2','1',50),(21080,11,11,295,'10','2','2',50),(21081,11,11,295,'10','2','3',50),(21082,11,11,295,'10','2','4',50),(21083,11,11,295,'10','2','5',50),(21084,11,11,295,'10','2','6',50),(21085,11,11,295,'10','2','7',50),(21086,11,11,295,'10','2','8',50),(21087,11,11,295,'1','2','9',50),(21088,11,11,295,'10','3','1',50),(21089,11,11,295,'10','3','2',50),(21090,11,11,295,'10','3','3',50),(21091,11,11,295,'10','3','4',50),(21092,11,11,295,'10','3','5',50),(21093,11,11,295,'10','3','6',50),(21094,11,11,295,'10','3','7',50),(21095,11,11,295,'10','3','8',50),(21096,11,11,295,'6','3','9',50),(21097,11,11,295,'10','4','1',50),(21098,11,11,295,'10','4','2',50),(21099,11,11,295,'10','4','3',50),(21100,11,11,295,'10','4','4',50),(21101,11,11,295,'10','4','5',50),(21102,11,11,295,'10','4','6',50),(21103,11,11,295,'10','4','7',50),(21105,11,11,295,'1','4','9',50),(21106,11,11,295,'10','4','8',50),(21107,11,11,295,'10','5','1',50),(21108,11,11,295,'10','5','2',50),(21109,11,11,295,'10','5','3',50),(21110,11,11,295,'10','5','4',50),(21111,11,11,295,'10','5','5',50),(21112,11,11,295,'10','5','6',50),(21113,11,11,295,'8','5','7',50),(21114,11,11,295,'M','5','8',50),(21115,11,11,295,'M','5','9',50),(21116,11,11,295,'10','6','1',50),(21117,11,11,295,'10','6','2',50),(21118,11,11,295,'10','6','3',50),(21119,11,11,295,'10','6','4',50),(21120,11,11,295,'10','6','5',50),(21121,11,11,295,'10','6','6',50),(21122,11,11,295,'10','6','7',50),(21123,11,11,295,'10','6','8',50),(21124,11,11,295,'2','6','9',50),(21125,11,11,295,'10','7','1',50),(21126,11,11,295,'10','7','2',50),(21127,11,11,295,'10','7','3',50),(21128,11,11,295,'10','7','4',50),(21129,11,11,295,'10','7','5',50),(21130,11,11,295,'10','7','6',50),(21131,11,11,295,'10','7','7',50),(21132,11,11,295,'10','7','8',50),(21133,11,11,295,'3','7','9',50),(21134,11,11,296,'10','1','1',50),(21135,11,11,296,'10','1','2',50),(21136,11,11,296,'10','1','3',50),(21137,11,11,296,'10','1','4',50),(21138,11,11,296,'10','1','5',50),(21139,11,11,296,'10','1','6',50),(21140,11,11,296,'10','1','7',50),(21141,11,11,296,'9','1','8',50),(21142,11,11,296,'M','1','9',50),(21143,11,11,296,'10','2','1',50),(21144,11,11,296,'10','2','2',50),(21145,11,11,296,'10','2','3',50),(21146,11,11,296,'10','2','4',50),(21147,11,11,296,'10','2','5',50),(21148,11,11,296,'10','2','6',50),(21149,11,11,296,'10','2','7',50),(21150,11,11,296,'10','2','8',50),(21151,11,11,296,'1','2','9',50),(21152,11,11,296,'10','3','1',50),(21153,11,11,296,'10','3','2',50),(21154,11,11,296,'10','3','3',50),(21155,11,11,296,'10','3','4',50),(21156,11,11,296,'10','3','5',50),(21157,11,11,296,'10','3','6',50),(21158,11,11,296,'10','3','7',50),(21159,11,11,296,'8','3','8',50),(21160,11,11,296,'M','3','9',50),(21161,11,11,296,'10','4','1',50),(21162,11,11,296,'10','4','2',50),(21163,11,11,296,'10','4','3',50),(21164,11,11,296,'10','4','4',50),(21165,11,11,296,'10','4','5',50),(21166,11,11,296,'10','4','6',50),(21167,11,11,296,'10','4','7',50),(21168,11,11,296,'8','4','8',50),(21170,11,11,296,'M','4','9',50),(21171,11,11,296,'10','5','1',50),(21172,11,11,296,'10','5','2',50),(21173,11,11,296,'10','5','3',50),(21174,11,11,296,'10','5','4',50),(21175,11,11,296,'10','5','5',50),(21176,11,11,296,'10','5','6',50),(21177,11,11,296,'10','5','7',50),(21178,11,11,296,'10','5','8',50),(21179,11,11,296,'1','5','9',50),(21180,11,11,296,'10','6','1',50),(21181,11,11,296,'10','6','2',50),(21182,11,11,296,'10','6','3',50),(21183,11,11,296,'10','6','4',50),(21184,11,11,296,'10','6','5',50),(21185,11,11,296,'10','6','6',50),(21186,11,11,296,'10','6','7',50),(21187,11,11,296,'10','6','8',50),(21188,11,11,296,'1','6','9',50),(21189,11,11,296,'10','7','1',50),(21190,11,11,296,'10','7','2',50),(21191,11,11,296,'10','7','3',50),(21192,11,11,296,'10','7','4',50),(21193,11,11,296,'10','7','5',50),(21194,11,11,296,'10','7','6',50),(21195,11,11,296,'10','7','7',50),(21196,11,11,296,'10','7','8',50),(21197,11,11,296,'M','7','9',50),(21198,11,11,297,'10','1','1',50),(21199,11,11,297,'10','1','2',50),(21200,11,11,297,'10','1','3',50),(21201,11,11,297,'10','1','4',50),(21202,11,11,297,'10','1','5',50),(21203,11,11,297,'10','1','6',50),(21204,11,11,297,'10','1','7',50),(21205,11,11,297,'10','1','8',50),(21206,11,11,297,'10','2','1',50),(21207,11,11,297,'1','1','9',50),(21208,11,11,297,'10','2','2',50),(21209,11,11,297,'10','2','3',50),(21210,11,11,297,'10','2','5',50),(21211,11,11,297,'10','2','6',50),(21212,11,11,297,'10','2','7',50),(21213,11,11,297,'10','2','4',50),(21214,11,11,297,'10','2','8',50),(21215,11,11,297,'1','2','9',50),(21216,11,11,297,'10','3','1',50),(21217,11,11,297,'10','3','2',50),(21218,11,11,297,'10','3','3',50),(21219,11,11,297,'10','3','4',50),(21220,11,11,297,'10','3','5',50),(21221,11,11,297,'10','3','6',50),(21222,11,11,297,'10','3','7',50),(21223,11,11,297,'7','3','8',50),(21224,11,11,297,'M','3','9',50),(21225,11,11,297,'10','4','1',50),(21226,11,11,297,'10','4','2',50),(21227,11,11,297,'10','4','3',50),(21229,11,11,297,'10','4','4',50),(21230,11,11,297,'10','4','5',50),(21231,11,11,297,'10','4','6',50),(21232,11,11,297,'10','4','7',50),(21233,11,11,297,'10','4','8',50),(21234,11,11,297,'4','4','9',50),(21235,11,11,297,'10','5','1',50),(21236,11,11,297,'10','5','2',50),(21237,11,11,297,'10','5','3',50),(21238,11,11,297,'10','5','4',50),(21239,11,11,297,'10','5','5',50),(21240,11,11,297,'10','5','6',50),(21241,11,11,297,'10','5','7',50),(21242,11,11,297,'8','5','8',50),(21244,11,11,297,'M','5','9',50),(21245,11,11,297,'10','6','1',50),(21246,11,11,297,'10','6','2',50),(21247,11,11,297,'10','6','3',50),(21248,11,11,297,'10','6','4',50),(21249,11,11,297,'10','6','5',50),(21250,11,11,297,'10','6','6',50),(21251,11,11,297,'10','6','7',50),(21252,11,11,297,'10','6','8',50),(21253,11,11,297,'M','6','9',50),(21254,11,11,297,'10','7','1',50),(21255,11,11,297,'10','7','2',50),(21256,11,11,297,'10','7','3',50),(21257,11,11,297,'10','7','4',50),(21258,11,11,297,'10','7','5',50),(21259,11,11,297,'10','7','6',50),(21260,11,11,297,'10','7','7',50),(21261,11,11,297,'1','7','8',50),(21263,11,11,297,'M','7','9',50),(21264,11,11,298,'10','1','1',50),(21265,11,11,298,'10','1','2',50),(21266,11,11,298,'10','1','3',50),(21267,11,11,298,'10','1','4',50),(21268,11,11,298,'10','1','5',50),(21269,11,11,298,'10','1','6',50),(21270,11,11,298,'10','1','7',50),(21271,11,11,298,'8','1','8',50),(21272,11,11,298,'M','1','9',50),(21273,11,11,298,'10','2','1',50),(21274,11,11,298,'10','2','2',50),(21275,11,11,298,'10','2','3',50),(21276,11,11,298,'10','2','4',50),(21277,11,11,298,'10','2','5',50),(21278,11,11,298,'10','2','6',50),(21279,11,11,298,'10','2','7',50),(21280,11,11,298,'10','2','8',50),(21281,11,11,298,'4','2','9',50),(21282,11,11,298,'10','3','1',50),(21283,11,11,298,'10','3','2',50),(21284,11,11,298,'10','3','3',50),(21285,11,11,298,'10','3','4',50),(21286,11,11,298,'10','3','5',50),(21287,11,11,298,'10','3','6',50),(21288,11,11,298,'10','3','7',50),(21289,11,11,298,'8','3','8',50),(21290,11,11,298,'M','3','9',50),(21292,11,11,298,'10','4','1',50),(21293,11,11,298,'10','4','2',50),(21294,11,11,298,'10','4','3',50),(21295,11,11,298,'10','4','4',50),(21296,11,11,298,'10','4','5',50),(21297,11,11,298,'10','4','6',50),(21298,11,11,298,'10','4','7',50),(21299,11,11,298,'10','4','8',50),(21300,11,11,298,'M','4','9',50),(21301,11,11,298,'10','5','1',50),(21302,11,11,298,'10','5','2',50),(21303,11,11,298,'10','5','3',50),(21304,11,11,298,'10','5','4',50),(21305,11,11,298,'10','5','5',50),(21306,11,11,298,'10','5','6',50),(21307,11,11,298,'10','5','7',50),(21308,11,11,298,'7','5','8',50),(21309,11,11,298,'M','5','9',50),(21310,11,11,298,'10','6','1',50),(21311,11,11,298,'10','6','2',50),(21312,11,11,298,'10','6','3',50),(21313,11,11,298,'10','6','4',50),(21314,11,11,298,'10','6','5',50),(21315,11,11,298,'10','6','6',50),(21316,11,11,298,'10','6','7',50),(21317,11,11,298,'1','6','8',50),(21318,11,11,298,'M','6','9',50),(21319,11,11,298,'10','7','1',50),(21320,11,11,298,'10','7','2',50),(21321,11,11,298,'10','7','3',50),(21322,11,11,298,'10','7','4',50),(21323,11,11,298,'10','7','5',50),(21324,11,11,298,'10','7','6',50),(21325,11,11,298,'10','7','7',50),(21326,11,11,298,'10','7','8',50),(21327,11,11,298,'4','7','9',50),(21328,11,11,299,'10','1','1',50),(21329,11,11,299,'10','1','2',50),(21330,11,11,299,'10','1','3',50),(21331,11,11,299,'10','1','4',50),(21332,11,11,299,'10','1','5',50),(21333,11,11,299,'10','1','6',50),(21334,11,11,299,'10','1','7',50),(21335,11,11,299,'8','1','8',50),(21336,11,11,299,'M','1','9',50),(21337,11,11,299,'10','2','1',50),(21338,11,11,299,'10','2','2',50),(21339,11,11,299,'10','2','3',50),(21340,11,11,299,'10','2','4',50),(21341,11,11,299,'10','2','5',50),(21342,11,11,299,'10','2','6',50),(21343,11,11,299,'10','2','7',50),(21344,11,11,299,'8','2','8',50),(21345,11,11,299,'M','2','9',50),(21346,11,11,299,'10','3','1',50),(21347,11,11,299,'10','3','2',50),(21348,11,11,299,'10','3','3',50),(21349,11,11,299,'10','3','4',50),(21350,11,11,299,'10','3','5',50),(21351,11,11,299,'10','3','6',50),(21352,11,11,299,'10','3','7',50),(21353,11,11,299,'10','3','8',50),(21354,11,11,299,'1','3','9',50),(21355,11,11,299,'10','4','1',50),(21356,11,11,299,'10','4','2',50),(21357,11,11,299,'10','4','3',50),(21358,11,11,299,'10','4','4',50),(21359,11,11,299,'10','4','5',50),(21360,11,11,299,'10','4','6',50),(21361,11,11,299,'10','4','7',50),(21362,11,11,299,'4','4','8',50),(21363,11,11,299,'M','4','9',50),(21364,11,11,299,'10','5','1',50),(21365,11,11,299,'10','5','2',50),(21366,11,11,299,'10','5','3',50),(21367,11,11,299,'10','5','4',50),(21368,11,11,299,'10','5','5',50),(21369,11,11,299,'10','5','6',50),(21370,11,11,299,'10','5','7',50),(21371,11,11,299,'10','5','8',50),(21372,11,11,299,'M','5','9',50),(21373,11,11,299,'10','6','1',50),(21374,11,11,299,'10','6','2',50),(21375,11,11,299,'10','6','3',50),(21376,11,11,299,'10','6','4',50),(21377,11,11,299,'10','6','5',50),(21378,11,11,299,'10','6','6',50),(21379,11,11,299,'10','6','7',50),(21380,11,11,299,'7','6','8',50),(21381,11,11,299,'M','6','9',50),(21382,11,11,299,'10','7','1',50),(21383,11,11,299,'10','7','2',50),(21384,11,11,299,'10','7','3',50),(21385,11,11,299,'10','7','4',50),(21386,11,11,299,'10','7','5',50),(21387,11,11,299,'10','7','6',50),(21388,11,11,299,'10','7','7',50),(21389,11,11,299,'10','7','8',50),(21390,11,11,299,'3','7','9',50),(21391,11,11,300,'10','1','1',50),(21392,11,11,300,'10','1','2',50),(21393,11,11,300,'10','1','3',50),(21394,11,11,300,'10','1','4',50),(21395,11,11,300,'10','1','5',50),(21396,11,11,300,'10','1','6',50),(21397,11,11,300,'10','1','7',50),(21398,11,11,300,'5','1','8',50),(21399,11,11,300,'M','1','9',50),(21400,11,11,300,'10','2','1',50),(21401,11,11,300,'10','2','2',50),(21402,11,11,300,'10','2','3',50),(21403,11,11,300,'10','2','4',50),(21404,11,11,300,'10','2','5',50),(21405,11,11,300,'10','2','6',50),(21406,11,11,300,'10','2','7',50),(21407,11,11,300,'8','2','8',50),(21408,11,11,300,'M','2','9',50),(21410,11,11,300,'10','3','2',50),(21411,11,11,300,'10','3','3',50),(21412,11,11,300,'10','3','4',50),(21413,11,11,300,'10','3','5',50),(21414,11,11,300,'10','3','6',50),(21415,11,11,300,'10','3','7',50),(21416,11,11,300,'7','3','8',50),(21417,11,11,300,'M','3','9',50),(21418,11,11,300,'10','4','1',50),(21419,11,11,300,'10','4','2',50),(21420,11,11,300,'10','4','3',50),(21421,11,11,300,'10','4','4',50),(21422,11,11,300,'10','4','5',50),(21423,11,11,300,'10','4','6',50),(21424,11,11,300,'10','4','7',50),(21425,11,11,300,'9','4','8',50),(21426,11,11,300,'M','4','9',50),(21427,11,11,300,'10','5','1',50),(21428,11,11,300,'10','5','2',50),(21429,11,11,300,'10','5','3',50),(21430,11,11,300,'10','5','4',50),(21431,11,11,300,'10','5','5',50),(21432,11,11,300,'10','5','6',50),(21433,11,11,300,'10','5','7',50),(21434,11,11,300,'10','5','8',50),(21435,11,11,300,'M','5','9',50),(21436,11,11,300,'10','6','1',50),(21437,11,11,300,'10','6','2',50),(21438,11,11,300,'10','6','3',50),(21439,11,11,300,'10','6','4',50),(21440,11,11,300,'10','6','5',50),(21441,11,11,300,'10','6','6',50),(21442,11,11,300,'10','6','7',50),(21443,11,11,300,'9','6','8',50),(21444,11,11,300,'M','6','9',50),(21445,11,11,300,'10','7','1',50),(21446,11,11,300,'10','7','2',50),(21447,11,11,300,'10','7','3',50),(21449,11,11,300,'10','7','4',50),(21450,11,11,300,'10','7','5',50),(21451,11,11,300,'10','7','6',50),(21452,11,11,300,'10','7','7',50),(21453,11,11,300,'9','7','8',50),(21454,11,11,300,'M','7','9',50),(21455,11,11,301,'10','1','1',50),(21456,11,11,301,'10','1','2',50),(21457,11,11,301,'10','1','4',50),(21458,11,11,301,'10','1','3',50),(21459,11,11,301,'10','1','5',50),(21460,11,11,301,'10','1','6',50),(21461,11,11,301,'10','1','7',50),(21462,11,11,301,'4','1','8',50),(21463,11,11,301,'M','1','9',50),(21464,11,11,301,'10','2','1',50),(21465,11,11,301,'10','2','2',50),(21466,11,11,301,'10','2','3',50),(21467,11,11,301,'10','2','4',50),(21468,11,11,301,'10','2','5',50),(21469,11,11,301,'10','2','6',50),(21470,11,11,301,'10','2','7',50),(21471,11,11,301,'10','2','8',50),(21472,11,11,301,'M','2','9',50),(21473,11,11,301,'10','3','1',50),(21474,11,11,301,'10','3','2',50),(21475,11,11,301,'10','3','3',50),(21476,11,11,301,'10','3','4',50),(21477,11,11,301,'10','3','5',50),(21478,11,11,301,'10','3','6',50),(21479,11,11,301,'10','3','7',50),(21480,11,11,301,'4','3','8',50),(21481,11,11,301,'M','3','9',50),(21482,11,11,301,'10','4','1',50),(21483,11,11,301,'10','4','2',50),(21484,11,11,301,'10','4','3',50),(21485,11,11,301,'10','4','4',50),(21486,11,11,301,'10','4','5',50),(21487,11,11,301,'10','4','6',50),(21488,11,11,301,'10','4','7',50),(21489,11,11,301,'9','4','8',50),(21490,11,11,301,'M','4','9',50),(21491,11,11,301,'10','5','1',50),(21492,11,11,301,'10','5','2',50),(21493,11,11,301,'10','5','3',50),(21494,11,11,301,'10','5','4',50),(21495,11,11,301,'10','5','5',50),(21496,11,11,301,'10','5','6',50),(21497,11,11,301,'10','5','7',50),(21498,11,11,301,'8','5','8',50),(21499,11,11,301,'M','5','9',50),(21500,11,11,301,'10','6','1',50),(21501,11,11,301,'10','6','2',50),(21502,11,11,301,'10','6','3',50),(21503,11,11,301,'10','6','4',50),(21504,11,11,301,'10','6','5',50),(21505,11,11,301,'10','6','6',50),(21506,11,11,301,'10','6','7',50),(21507,11,11,301,'10','6','8',50),(21508,11,11,301,'M','6','9',50),(21509,11,11,301,'10','7','1',50),(21510,11,11,301,'10','7','2',50),(21511,11,11,301,'10','7','3',50),(21512,11,11,301,'10','7','4',50),(21513,11,11,301,'10','7','5',50),(21514,11,11,301,'10','7','6',50),(21515,11,11,301,'10','7','7',50),(21516,11,11,301,'10','7','8',50),(21517,11,11,301,'M','7','9',50),(21519,11,11,302,'10','1','1',50),(21520,11,11,302,'10','1','2',50),(21521,11,11,302,'10','1','3',50),(21522,11,11,302,'10','1','4',50),(21523,11,11,302,'10','1','5',50),(21524,11,11,302,'10','1','6',50),(21525,11,11,302,'10','1','7',50),(21526,11,11,302,'7','1','8',50),(21527,11,11,302,'M','1','9',50),(21528,11,11,302,'10','2','1',50),(21529,11,11,302,'10','2','2',50),(21530,11,11,302,'10','2','3',50),(21531,11,11,302,'10','2','4',50),(21532,11,11,302,'10','2','5',50),(21533,11,11,302,'10','2','6',50),(21534,11,11,302,'10','2','7',50),(21535,11,11,302,'10','2','8',50),(21536,11,11,302,'M','2','9',50),(21537,11,11,302,'10','3','1',50),(21538,11,11,302,'10','3','2',50),(21539,11,11,302,'10','3','3',50),(21540,11,11,302,'10','3','4',50),(21541,11,11,302,'10','3','5',50),(21542,11,11,302,'10','3','6',50),(21543,11,11,302,'10','3','7',50),(21544,11,11,302,'9','3','8',50),(21545,11,11,302,'M','3','9',50),(21546,11,11,302,'10','4','1',50),(21547,11,11,302,'10','4','2',50),(21548,11,11,302,'10','4','3',50),(21549,11,11,302,'10','4','4',50),(21550,11,11,302,'10','4','5',50),(21551,11,11,302,'10','4','6',50),(21552,11,11,302,'10','4','7',50),(21553,11,11,302,'10','4','8',50),(21554,11,11,302,'M','4','9',50),(21555,11,11,302,'10','5','1',50),(21556,11,11,302,'10','5','2',50),(21557,11,11,302,'10','5','3',50),(21558,11,11,302,'10','5','4',50),(21559,11,11,302,'10','5','5',50),(21560,11,11,302,'10','5','6',50),(21561,11,11,302,'10','5','7',50),(21562,11,11,302,'9','5','8',50),(21563,11,11,302,'M','5','9',50),(21564,11,11,302,'10','6','1',50),(21565,11,11,302,'10','6','2',50),(21566,11,11,302,'10','6','3',50),(21567,11,11,302,'10','6','4',50),(21568,11,11,302,'10','6','5',50),(21569,11,11,302,'10','6','6',50),(21570,11,11,302,'8','6','7',50),(21571,11,11,302,'M','6','8',50),(21572,11,11,302,'M','6','9',50),(21573,11,11,302,'10','7','1',50),(21574,11,11,302,'10','7','2',50),(21575,11,11,302,'10','7','3',50),(21576,11,11,302,'10','7','4',50),(21577,11,11,302,'10','7','5',50),(21578,11,11,302,'10','7','6',50),(21579,11,11,302,'10','7','7',50),(21580,11,11,302,'10','7','8',50),(21581,11,11,302,'M','7','9',50),(21582,11,11,303,'10','1','1',50),(21583,11,11,303,'10','1','2',50),(21584,11,11,303,'10','1','3',50),(21585,11,11,303,'10','1','4',50),(21586,11,11,303,'10','1','5',50),(21587,11,11,303,'10','1','6',50),(21588,11,11,303,'10','1','7',50),(21589,11,11,303,'6','1','8',50),(21590,11,11,303,'M','1','9',50),(21591,11,11,303,'10','2','1',50),(21592,11,11,303,'10','2','2',50),(21593,11,11,303,'10','2','3',50),(21594,11,11,303,'10','2','4',50),(21595,11,11,303,'10','2','6',50),(21596,11,11,303,'10','2','7',50),(21597,11,11,303,'10','2','5',50),(21598,11,11,303,'M','2','9',50),(21599,11,11,303,'10','3','1',50),(21600,11,11,303,'6','2','8',50),(21601,11,11,303,'10','3','3',50),(21602,11,11,303,'10','3','4',50),(21603,11,11,303,'10','3','2',50),(21604,11,11,303,'10','3','6',50),(21605,11,11,303,'10','3','5',50),(21606,11,11,303,'10','3','7',50),(21607,11,11,303,'10','3','8',50),(21608,11,11,303,'M','3','9',50),(21609,11,11,303,'10','4','1',50),(21610,11,11,303,'10','4','2',50),(21611,11,11,303,'10','4','3',50),(21612,11,11,303,'10','4','4',50),(21613,11,11,303,'10','4','5',50),(21614,11,11,303,'10','4','6',50),(21615,11,11,303,'10','4','7',50),(21616,11,11,303,'8','4','8',50),(21617,11,11,303,'M','4','9',50),(21618,11,11,303,'10','5','1',50),(21619,11,11,303,'10','5','2',50),(21620,11,11,303,'10','5','3',50),(21621,11,11,303,'10','5','4',50),(21622,11,11,303,'10','5','5',50),(21623,11,11,303,'10','5','6',50),(21625,11,11,303,'9','5','8',50),(21626,11,11,303,'M','5','9',50),(21627,11,11,303,'10','5','7',50),(21628,11,11,303,'10','6','1',50),(21629,11,11,303,'10','6','2',50),(21630,11,11,303,'10','6','3',50),(21631,11,11,303,'10','6','4',50),(21632,11,11,303,'10','6','5',50),(21633,11,11,303,'10','6','6',50),(21634,11,11,303,'10','6','7',50),(21635,11,11,303,'7','6','8',50),(21636,11,11,303,'M','6','9',50),(21637,11,11,303,'10','7','1',50),(21638,11,11,303,'10','7','2',50),(21639,11,11,303,'10','7','3',50),(21640,11,11,303,'10','7','4',50),(21641,11,11,303,'10','7','5',50),(21642,11,11,303,'10','7','6',50),(21643,11,11,303,'10','7','7',50),(21644,11,11,303,'6','7','8',50),(21645,11,11,303,'M','7','9',50),(21646,11,11,304,'10','1','1',50),(21647,11,11,304,'10','1','2',50),(21648,11,11,304,'10','1','3',50),(21649,11,11,304,'10','1','4',50),(21650,11,11,304,'10','1','5',50),(21651,11,11,304,'10','1','6',50),(21652,11,11,304,'10','1','7',50),(21653,11,11,304,'6','1','8',50),(21654,11,11,304,'M','1','9',50),(21655,11,11,304,'10','2','1',50),(21656,11,11,304,'10','2','2',50),(21657,11,11,304,'10','2','3',50),(21658,11,11,304,'10','2','4',50),(21659,11,11,304,'10','2','5',50),(21660,11,11,304,'10','2','6',50),(21661,11,11,304,'10','2','7',50),(21662,11,11,304,'7','2','8',50),(21663,11,11,304,'M','2','9',50),(21664,11,11,304,'10','3','1',50),(21665,11,11,304,'10','3','2',50),(21666,11,11,304,'10','3','3',50),(21667,11,11,304,'10','3','4',50),(21668,11,11,304,'10','3','5',50),(21669,11,11,304,'10','3','6',50),(21670,11,11,304,'10','3','7',50),(21671,11,11,304,'5','3','8',50),(21672,11,11,304,'M','3','9',50),(21673,11,11,304,'10','4','1',50),(21674,11,11,304,'10','4','2',50),(21675,11,11,304,'10','4','3',50),(21676,11,11,304,'10','4','4',50),(21677,11,11,304,'10','4','5',50),(21678,11,11,304,'10','4','6',50),(21679,11,11,304,'10','4','7',50),(21680,11,11,304,'7','4','8',50),(21681,11,11,304,'M','4','9',50),(21682,11,11,304,'10','5','1',50),(21683,11,11,304,'10','5','2',50),(21684,11,11,304,'10','5','3',50),(21685,11,11,304,'10','5','4',50),(21686,11,11,304,'10','5','5',50),(21687,11,11,304,'10','5','6',50),(21688,11,11,304,'10','5','7',50),(21689,11,11,304,'4','5','8',50),(21690,11,11,304,'M','5','9',50),(21691,11,11,304,'10','6','1',50),(21692,11,11,304,'10','6','2',50),(21693,11,11,304,'10','6','3',50),(21694,11,11,304,'10','6','4',50),(21695,11,11,304,'10','6','5',50),(21696,11,11,304,'10','6','6',50),(21697,11,11,304,'10','6','7',50),(21698,11,11,304,'10','6','8',50),(21699,11,11,304,'M','6','9',50),(21700,11,11,304,'10','7','1',50),(21701,11,11,304,'10','7','2',50),(21702,11,11,304,'10','7','3',50),(21703,11,11,304,'10','7','4',50),(21704,11,11,304,'10','7','5',50),(21705,11,11,304,'10','7','6',50),(21706,11,11,304,'10','7','7',50),(21707,11,11,304,'10','7','8',50),(21708,11,11,304,'M','7','9',50),(21709,11,11,305,'10','1','1',50),(21710,11,11,305,'10','1','2',50),(21711,11,11,305,'10','1','3',50),(21712,11,11,305,'10','1','4',50),(21713,11,11,305,'10','1','5',50),(21714,11,11,305,'10','1','6',50),(21715,11,11,305,'10','1','7',50),(21716,11,11,305,'5','1','8',50),(21717,11,11,305,'M','1','9',50),(21718,11,11,305,'10','2','1',50),(21719,11,11,305,'10','2','2',50),(21720,11,11,305,'10','2','3',50),(21721,11,11,305,'10','2','4',50),(21722,11,11,305,'10','2','5',50),(21723,11,11,305,'10','2','6',50),(21724,11,11,305,'10','2','7',50),(21725,11,11,305,'7','2','8',50),(21726,11,11,305,'M','2','9',50),(21727,11,11,305,'10','3','1',50),(21728,11,11,305,'10','3','2',50),(21729,11,11,305,'10','3','3',50),(21730,11,11,305,'10','3','4',50),(21731,11,11,305,'10','3','5',50),(21732,11,11,305,'10','3','6',50),(21733,11,11,305,'10','3','7',50),(21734,11,11,305,'10','3','8',50),(21735,11,11,305,'M','3','9',50),(21736,11,11,305,'10','4','1',50),(21737,11,11,305,'10','4','2',50),(21738,11,11,305,'10','4','3',50),(21739,11,11,305,'10','4','4',50),(21740,11,11,305,'10','4','5',50),(21741,11,11,305,'10','4','6',50),(21742,11,11,305,'10','4','7',50),(21743,11,11,305,'10','4','8',50),(21744,11,11,305,'M','4','9',50),(21745,11,11,305,'10','5','1',50),(21746,11,11,305,'10','5','2',50),(21747,11,11,305,'10','5','3',50),(21748,11,11,305,'10','5','4',50),(21749,11,11,305,'10','5','5',50),(21750,11,11,305,'10','5','6',50),(21751,11,11,305,'10','5','7',50),(21752,11,11,305,'8','5','8',50),(21753,11,11,305,'M','5','9',50),(21754,11,11,305,'10','6','1',50),(21755,11,11,305,'10','6','2',50),(21756,11,11,305,'10','6','3',50),(21757,11,11,305,'10','6','4',50),(21758,11,11,305,'10','6','5',50),(21759,11,11,305,'10','6','6',50),(21760,11,11,305,'10','6','7',50),(21761,11,11,305,'6','6','8',50),(21762,11,11,305,'M','6','9',50),(21763,11,11,305,'10','7','1',50),(21764,11,11,305,'10','7','2',50),(21765,11,11,305,'10','7','3',50),(21766,11,11,305,'10','7','4',50),(21767,11,11,305,'10','7','5',50),(21768,11,11,305,'10','7','6',50),(21769,11,11,305,'10','7','7',50),(21770,11,11,305,'2','7','8',50),(21771,11,11,305,'M','7','9',50),(21772,11,11,306,'10','1','1',50),(21773,11,11,306,'10','1','2',50),(21774,11,11,306,'10','1','3',50),(21775,11,11,306,'10','1','4',50),(21776,11,11,306,'10','1','5',50),(21777,11,11,306,'10','1','6',50),(21778,11,11,306,'7','1','7',50),(21779,11,11,306,'M','1','8',50),(21780,11,11,306,'M','1','9',50),(21781,11,11,306,'10','2','1',50),(21782,11,11,306,'10','2','2',50),(21783,11,11,306,'10','2','3',50),(21784,11,11,306,'10','2','4',50),(21785,11,11,306,'10','2','5',50),(21786,11,11,306,'10','2','6',50),(21787,11,11,306,'5','2','8',50),(21788,11,11,306,'10','2','7',50),(21789,11,11,306,'M','2','9',50),(21790,11,11,306,'10','3','1',50),(21791,11,11,306,'10','3','3',50),(21792,11,11,306,'10','3','2',50),(21793,11,11,306,'10','3','5',50),(21794,11,11,306,'10','3','4',50),(21795,11,11,306,'10','3','6',50),(21796,11,11,306,'10','3','7',50),(21797,11,11,306,'10','3','8',50),(21798,11,11,306,'1','3','9',50),(21799,11,11,306,'10','4','1',50),(21800,11,11,306,'10','4','2',50),(21801,11,11,306,'10','4','3',50),(21802,11,11,306,'10','4','4',50),(21803,11,11,306,'10','4','5',50),(21804,11,11,306,'10','4','6',50),(21805,11,11,306,'10','4','7',50),(21806,11,11,306,'10','4','8',50),(21807,11,11,306,'2','4','9',50),(21808,11,11,306,'10','5','1',50),(21809,11,11,306,'10','5','2',50),(21810,11,11,306,'10','5','3',50),(21811,11,11,306,'10','5','4',50),(21812,11,11,306,'10','5','5',50),(21813,11,11,306,'10','5','6',50),(21814,11,11,306,'10','5','7',50),(21815,11,11,306,'5','5','8',50),(21816,11,11,306,'M','5','9',50),(21817,11,11,306,'10','6','1',50),(21818,11,11,306,'10','6','2',50),(21819,11,11,306,'10','6','3',50),(21820,11,11,306,'10','6','4',50),(21821,11,11,306,'10','6','5',50),(21822,11,11,306,'10','6','6',50),(21823,11,11,306,'10','6','7',50),(21824,11,11,306,'8','6','8',50),(21825,11,11,306,'M','6','9',50),(21826,11,11,306,'10','7','1',50),(21827,11,11,306,'10','7','2',50),(21828,11,11,306,'10','7','3',50),(21829,11,11,306,'10','7','4',50),(21830,11,11,306,'10','7','5',50),(21831,11,11,306,'10','7','6',50),(21832,11,11,306,'10','7','7',50),(21833,11,11,306,'8','7','8',50),(21834,11,11,306,'M','7','9',50),(21835,11,11,307,'10','1','1',50),(21836,11,11,307,'10','1','2',50),(21837,11,11,307,'10','1','3',50),(21838,11,11,307,'10','1','5',50),(21839,11,11,307,'10','1','4',50),(21840,11,11,307,'10','1','7',50),(21841,11,11,307,'10','1','6',50),(21842,11,11,307,'M','1','9',50),(21843,11,11,307,'5','1','8',50),(21844,11,11,307,'10','2','1',50),(21845,11,11,307,'10','2','2',50),(21846,11,11,307,'10','2','3',50),(21847,11,11,307,'10','2','4',50),(21848,11,11,307,'10','2','6',50),(21849,11,11,307,'10','2','5',50),(21850,11,11,307,'2','2','8',50),(21851,11,11,307,'10','2','7',50),(21852,11,11,307,'10','3','1',50),(21853,11,11,307,'M','2','9',50),(21854,11,11,307,'10','3','2',50),(21855,11,11,307,'10','3','4',50),(21856,11,11,307,'10','3','3',50),(21857,11,11,307,'10','3','6',50),(21858,11,11,307,'10','3','7',50),(21859,11,11,307,'10','3','5',50),(21860,11,11,307,'10','3','8',50),(21861,11,11,307,'M','3','9',50),(21862,11,11,307,'10','4','1',50),(21863,11,11,307,'10','4','2',50),(21864,11,11,307,'10','4','3',50),(21865,11,11,307,'10','4','4',50),(21866,11,11,307,'10','4','5',50),(21867,11,11,307,'10','4','6',50),(21868,11,11,307,'10','4','7',50),(21869,11,11,307,'6','4','8',50),(21870,11,11,307,'M','4','9',50),(21871,11,11,307,'10','5','1',50),(21872,11,11,307,'10','5','2',50),(21873,11,11,307,'10','5','3',50),(21874,11,11,307,'10','5','4',50),(21875,11,11,307,'10','5','5',50),(21876,11,11,307,'10','5','6',50),(21877,11,11,307,'10','5','7',50),(21878,11,11,307,'4','5','8',50),(21879,11,11,307,'M','5','9',50),(21880,11,11,307,'10','6','1',50),(21881,11,11,307,'10','6','2',50),(21882,11,11,307,'10','6','3',50),(21883,11,11,307,'10','6','4',50),(21884,11,11,307,'10','6','5',50),(21885,11,11,307,'10','6','6',50),(21886,11,11,307,'10','6','7',50),(21887,11,11,307,'6','6','8',50),(21888,11,11,307,'M','6','9',50),(21889,11,11,307,'10','7','1',50),(21890,11,11,307,'10','7','2',50),(21891,11,11,307,'10','7','3',50),(21892,11,11,307,'10','7','4',50),(21893,11,11,307,'10','7','5',50),(21894,11,11,307,'10','7','6',50),(21895,11,11,307,'10','7','7',50),(21896,11,11,307,'8','7','8',50),(21897,11,11,307,'M','7','9',50),(21898,11,11,308,'10','1','1',50),(21899,11,11,308,'10','1','2',50),(21900,11,11,308,'10','1','3',50),(21901,11,11,308,'10','1','4',50),(21902,11,11,308,'10','1','5',50),(21903,11,11,308,'10','1','6',50),(21904,11,11,308,'5','1','8',50),(21905,11,11,308,'10','1','7',50),(21906,11,11,308,'M','1','9',50),(21907,11,11,308,'10','2','1',50),(21908,11,11,308,'10','2','2',50),(21909,11,11,308,'10','2','3',50),(21910,11,11,308,'10','2','4',50),(21911,11,11,308,'10','2','5',50),(21912,11,11,308,'10','2','6',50),(21913,11,11,308,'10','2','7',50),(21914,11,11,308,'3','2','8',50),(21915,11,11,308,'M','2','9',50),(21916,11,11,308,'10','3','1',50),(21917,11,11,308,'10','3','2',50),(21918,11,11,308,'10','3','3',50),(21919,11,11,308,'10','3','4',50),(21920,11,11,308,'10','3','6',50),(21921,11,11,308,'10','3','5',50),(21922,11,11,308,'10','3','7',50),(21923,11,11,308,'9','3','8',50),(21924,11,11,308,'M','3','9',50),(21925,11,11,308,'10','4','1',50),(21926,11,11,308,'10','4','2',50),(21927,11,11,308,'10','4','3',50),(21928,11,11,308,'10','4','4',50),(21929,11,11,308,'10','4','5',50),(21930,11,11,308,'10','4','6',50),(21931,11,11,308,'10','4','7',50),(21932,11,11,308,'10','4','8',50),(21933,11,11,308,'2','4','9',50),(21934,11,11,308,'10','5','1',50),(21935,11,11,308,'10','5','2',50),(21936,11,11,308,'10','5','3',50),(21937,11,11,308,'10','5','4',50),(21938,11,11,308,'10','5','5',50),(21939,11,11,308,'10','5','6',50),(21940,11,11,308,'10','5','7',50),(21942,11,11,308,'6','5','8',50),(21943,11,11,308,'M','5','9',50),(21944,11,11,308,'10','6','1',50),(21945,11,11,308,'10','6','2',50),(21946,11,11,308,'10','6','3',50),(21947,11,11,308,'10','6','4',50),(21948,11,11,308,'10','6','5',50),(21949,11,11,308,'10','6','6',50),(21950,11,11,308,'9','6','7',50),(21951,11,11,308,'M','6','8',50),(21952,11,11,308,'M','6','9',50),(21953,11,11,308,'10','7','1',50),(21954,11,11,308,'10','7','2',50),(21955,11,11,308,'10','7','3',50),(21956,11,11,308,'10','7','4',50),(21957,11,11,308,'10','7','5',50),(21958,11,11,308,'10','7','6',50),(21959,11,11,308,'10','7','7',50),(21960,11,11,308,'7','7','8',50),(21961,11,11,308,'M','7','9',50),(21962,11,11,309,'10','1','1',50),(21963,11,11,309,'10','1','3',50),(21964,11,11,309,'10','1','4',50),(21965,11,11,309,'10','1','5',50),(21966,11,11,309,'10','1','6',50),(21967,11,11,309,'10','1','7',50),(21968,11,11,309,'10','1','2',50),(21969,11,11,309,'M','1','9',50),(21970,11,11,309,'10','2','1',50),(21971,11,11,309,'7','1','8',50),(21972,11,11,309,'10','2','2',50),(21973,11,11,309,'10','2','3',50),(21974,11,11,309,'10','2','5',50),(21975,11,11,309,'10','2','7',50),(21976,11,11,309,'10','2','4',50),(21977,11,11,309,'10','2','6',50),(21978,11,11,309,'6','2','8',50),(21979,11,11,309,'M','2','9',50),(21980,11,11,309,'10','3','1',50),(21981,11,11,309,'10','3','2',50),(21982,11,11,309,'10','3','3',50),(21983,11,11,309,'10','3','4',50),(21984,11,11,309,'10','3','5',50),(21985,11,11,309,'10','3','6',50),(21986,11,11,309,'10','3','7',50),(21987,11,11,309,'3','3','8',50),(21988,11,11,309,'M','3','9',50),(21989,11,11,309,'10','4','1',50),(21990,11,11,309,'10','4','2',50),(21991,11,11,309,'10','4','3',50),(21992,11,11,309,'10','4','5',50),(21993,11,11,309,'10','4','4',50),(21994,11,11,309,'10','4','7',50),(21995,11,11,309,'10','4','6',50),(21996,11,11,309,'M','4','9',50),(21997,11,11,309,'10','4','8',50),(21998,11,11,309,'10','5','1',50),(21999,11,11,309,'10','5','2',50),(22000,11,11,309,'10','5','3',50),(22001,11,11,309,'10','5','4',50),(22003,11,11,309,'10','5','5',50),(22004,11,11,309,'10','5','8',50),(22005,11,11,309,'M','5','9',50),(22006,11,11,309,'10','5','7',50),(22007,11,11,309,'10','5','6',50),(22008,11,11,309,'10','6','1',50),(22009,11,11,309,'10','6','2',50),(22010,11,11,309,'10','6','3',50),(22011,11,11,309,'10','6','4',50),(22012,11,11,309,'10','6','5',50),(22013,11,11,309,'10','6','6',50),(22014,11,11,309,'10','6','7',50),(22015,11,11,309,'3','6','8',50),(22016,11,11,309,'M','6','9',50),(22017,11,11,309,'10','7','1',50),(22018,11,11,309,'10','7','2',50),(22019,11,11,309,'10','7','3',50),(22020,11,11,309,'10','7','4',50),(22021,11,11,309,'10','7','6',50),(22022,11,11,309,'10','7','5',50),(22023,11,11,309,'10','7','7',50),(22024,11,11,309,'M','7','8',50),(22025,11,11,309,'M','7','9',50),(22026,11,11,310,'10','1','1',50),(22027,11,11,310,'10','1','2',50),(22028,11,11,310,'10','1','3',50),(22029,11,11,310,'10','1','4',50),(22030,11,11,310,'10','1','5',50),(22031,11,11,310,'10','1','6',50),(22032,11,11,310,'10','1','7',50),(22033,11,11,310,'4','1','8',50),(22034,11,11,310,'M','1','9',50),(22035,11,11,310,'10','2','1',50),(22036,11,11,310,'10','2','2',50),(22037,11,11,310,'10','2','3',50),(22038,11,11,310,'10','2','4',50),(22039,11,11,310,'10','2','5',50),(22040,11,11,310,'10','2','6',50),(22041,11,11,310,'9','2','7',50),(22042,11,11,310,'M','2','8',50),(22043,11,11,310,'M','2','9',50),(22044,11,11,310,'10','3','1',50),(22045,11,11,310,'10','3','2',50),(22046,11,11,310,'10','3','3',50),(22047,11,11,310,'10','3','4',50),(22048,11,11,310,'10','3','6',50),(22049,11,11,310,'10','3','5',50),(22050,11,11,310,'10','3','7',50),(22051,11,11,310,'M','3','9',50),(22052,11,11,310,'7','3','8',50),(22053,11,11,310,'10','4','1',50),(22054,11,11,310,'10','4','3',50),(22055,11,11,310,'10','4','2',50),(22056,11,11,310,'10','4','5',50),(22057,11,11,310,'10','4','4',50),(22058,11,11,310,'10','4','6',50),(22059,11,11,310,'M','4','9',50),(22060,11,11,310,'8','4','8',50),(22061,11,11,310,'10','4','7',50),(22062,11,11,310,'10','5','1',50),(22063,11,11,310,'10','5','2',50),(22064,11,11,310,'10','5','3',50),(22065,11,11,310,'10','5','4',50),(22066,11,11,310,'10','5','5',50),(22067,11,11,310,'10','5','6',50),(22068,11,11,310,'10','5','7',50),(22069,11,11,310,'10','5','8',50),(22070,11,11,310,'2','5','9',50),(22071,11,11,310,'10','6','1',50),(22072,11,11,310,'10','6','2',50),(22073,11,11,310,'10','6','3',50),(22074,11,11,310,'10','6','4',50),(22075,11,11,310,'10','6','5',50),(22076,11,11,310,'10','6','6',50),(22077,11,11,310,'10','6','7',50),(22078,11,11,310,'6','6','8',50),(22079,11,11,310,'M','6','9',50),(22080,11,11,310,'10','7','1',50),(22081,11,11,310,'10','7','2',50),(22082,11,11,310,'10','7','3',50),(22083,11,11,310,'10','7','4',50),(22084,11,11,310,'10','7','5',50),(22085,11,11,310,'10','7','6',50),(22086,11,11,310,'10','7','7',50),(22087,11,11,310,'3','7','8',50),(22088,11,11,310,'M','7','9',50),(22089,11,11,311,'10','1','1',50),(22090,11,11,311,'10','1','2',50),(22091,11,11,311,'10','1','3',50),(22092,11,11,311,'10','1','4',50),(22093,11,11,311,'10','1','5',50),(22094,11,11,311,'10','1','6',50),(22095,11,11,311,'10','1','7',50),(22096,11,11,311,'2','1','8',50),(22097,11,11,311,'10','2','1',50),(22098,11,11,311,'M','1','9',50),(22099,11,11,311,'10','2','2',50),(22100,11,11,311,'10','2','4',50),(22101,11,11,311,'10','2','5',50),(22102,11,11,311,'10','2','3',50),(22103,11,11,311,'10','2','6',50),(22104,11,11,311,'8','2','8',50),(22105,11,11,311,'10','3','1',50),(22106,11,11,311,'M','2','9',50),(22107,11,11,311,'10','2','7',50),(22108,11,11,311,'10','3','3',50),(22109,11,11,311,'10','3','5',50),(22110,11,11,311,'10','3','6',50),(22111,11,11,311,'10','3','4',50),(22112,11,11,311,'10','3','2',50),(22113,11,11,311,'10','3','7',50),(22114,11,11,311,'5','3','8',50),(22115,11,11,311,'M','3','9',50),(22116,11,11,311,'10','4','1',50),(22117,11,11,311,'10','4','2',50),(22118,11,11,311,'10','4','3',50),(22119,11,11,311,'10','4','4',50),(22120,11,11,311,'10','4','5',50),(22121,11,11,311,'10','4','6',50),(22122,11,11,311,'4','4','7',50),(22123,11,11,311,'M','4','8',50),(22124,11,11,311,'M','4','9',50),(22125,11,11,311,'10','5','1',50),(22126,11,11,311,'10','5','2',50),(22127,11,11,311,'10','5','3',50),(22128,11,11,311,'10','5','4',50),(22129,11,11,311,'10','5','5',50),(22130,11,11,311,'10','5','6',50),(22131,11,11,311,'10','5','7',50),(22132,11,11,311,'10','5','8',50),(22133,11,11,311,'1','5','9',50),(22134,11,11,311,'10','6','1',50),(22135,11,11,311,'10','6','2',50),(22136,11,11,311,'10','6','3',50),(22137,11,11,311,'10','6','4',50),(22138,11,11,311,'10','6','5',50),(22139,11,11,311,'10','6','6',50),(22140,11,11,311,'10','6','7',50),(22141,11,11,311,'9','6','8',50),(22142,11,11,311,'M','6','9',50),(22143,11,11,311,'10','7','1',50),(22144,11,11,311,'10','7','2',50),(22145,11,11,311,'10','7','3',50),(22146,11,11,311,'10','7','4',50),(22147,11,11,311,'10','7','5',50),(22148,11,11,311,'10','7','6',50),(22149,11,11,311,'10','7','7',50),(22150,11,11,311,'9','7','8',50),(22151,11,11,311,'M','7','9',50),(22152,11,11,312,'10','1','1',50),(22153,11,11,312,'10','1','2',50),(22154,11,11,312,'10','1','3',50),(22155,11,11,312,'10','1','4',50),(22156,11,11,312,'10','1','5',50),(22157,11,11,312,'9','1','7',50),(22158,11,11,312,'M','1','8',50),(22159,11,11,312,'M','1','9',50),(22160,11,11,312,'10','1','6',50),(22161,11,11,312,'10','2','1',50),(22162,11,11,312,'10','2','2',50),(22163,11,11,312,'10','2','3',50),(22164,11,11,312,'10','2','4',50),(22165,11,11,312,'10','2','5',50),(22166,11,11,312,'10','2','6',50),(22167,11,11,312,'8','2','8',50),(22168,11,11,312,'10','2','7',50),(22169,11,11,312,'10','3','1',50),(22170,11,11,312,'M','2','9',50),(22171,11,11,312,'10','3','2',50),(22172,11,11,312,'10','3','4',50),(22173,11,11,312,'10','3','3',50),(22174,11,11,312,'10','3','5',50),(22175,11,11,312,'10','3','6',50),(22176,11,11,312,'10','3','7',50),(22177,11,11,312,'5','3','8',50),(22178,11,11,312,'M','3','9',50),(22179,11,11,312,'10','4','1',50),(22180,11,11,312,'10','4','2',50),(22181,11,11,312,'10','4','3',50),(22182,11,11,312,'10','4','4',50),(22183,11,11,312,'10','4','5',50),(22184,11,11,312,'10','4','6',50),(22185,11,11,312,'10','4','7',50),(22186,11,11,312,'10','4','8',50),(22187,11,11,312,'M','4','9',50),(22188,11,11,312,'10','5','1',50),(22189,11,11,312,'10','5','2',50),(22190,11,11,312,'10','5','3',50),(22191,11,11,312,'10','5','4',50),(22192,11,11,312,'10','5','5',50),(22193,11,11,312,'10','5','6',50),(22194,11,11,312,'10','5','7',50),(22195,11,11,312,'3','5','8',50),(22197,11,11,312,'M','5','9',50),(22198,11,11,312,'10','6','1',50),(22199,11,11,312,'10','6','2',50),(22200,11,11,312,'10','6','3',50),(22201,11,11,312,'10','6','4',50),(22202,11,11,312,'10','6','5',50),(22203,11,11,312,'10','6','6',50),(22204,11,11,312,'10','6','7',50),(22205,11,11,312,'1','6','8',50),(22206,11,11,312,'M','6','9',50),(22207,11,11,312,'10','7','1',50),(22208,11,11,312,'10','7','2',50),(22209,11,11,312,'10','7','3',50),(22210,11,11,312,'10','7','4',50),(22211,11,11,312,'10','7','5',50),(22212,11,11,312,'10','7','6',50),(22213,11,11,312,'10','7','7',50),(22214,11,11,312,'10','7','8',50),(22215,11,11,312,'1','7','9',50),(22216,11,11,313,'10','1','1',50),(22217,11,11,313,'10','1','3',50),(22218,11,11,313,'10','1','4',50),(22219,11,11,313,'10','1','2',50),(22220,11,11,313,'10','1','5',50),(22221,11,11,313,'10','1','7',50),(22222,11,11,313,'10','1','6',50),(22223,11,11,313,'1','1','8',50),(22224,11,11,313,'M','1','9',50),(22225,11,11,313,'10','2','1',50),(22226,11,11,313,'10','2','3',50),(22227,11,11,313,'10','2','4',50),(22228,11,11,313,'10','2','5',50),(22229,11,11,313,'10','2','2',50),(22230,11,11,313,'10','2','6',50),(22231,11,11,313,'10','2','7',50),(22232,11,11,313,'2','2','8',50),(22233,11,11,313,'M','2','9',50),(22234,11,11,313,'10','3','1',50),(22235,11,11,313,'10','3','2',50),(22236,11,11,313,'10','3','3',50),(22237,11,11,313,'10','3','4',50),(22238,11,11,313,'10','3','5',50),(22239,11,11,313,'10','3','6',50),(22240,11,11,313,'10','3','7',50),(22241,11,11,313,'8','3','8',50),(22242,11,11,313,'M','3','9',50),(22243,11,11,313,'10','4','1',50),(22244,11,11,313,'10','4','2',50),(22245,11,11,313,'10','4','3',50),(22246,11,11,313,'10','4','4',50),(22247,11,11,313,'10','4','5',50),(22248,11,11,313,'10','4','6',50),(22249,11,11,313,'10','4','7',50),(22250,11,11,313,'1','4','8',50),(22251,11,11,313,'M','4','9',50),(22252,11,11,313,'10','5','1',50),(22253,11,11,313,'10','5','2',50),(22254,11,11,313,'10','5','3',50),(22255,11,11,313,'10','5','4',50),(22256,11,11,313,'10','5','5',50),(22257,11,11,313,'10','5','7',50),(22258,11,11,313,'10','5','8',50),(22259,11,11,313,'10','5','6',50),(22260,11,11,313,'10','6','1',50),(22261,11,11,313,'10','6','2',50),(22262,11,11,313,'1','5','9',50),(22263,11,11,313,'10','6','3',50),(22264,11,11,313,'10','6','4',50),(22265,11,11,313,'10','6','5',50),(22266,11,11,313,'10','6','6',50),(22267,11,11,313,'10','6','7',50),(22268,11,11,313,'5','6','8',50),(22269,11,11,313,'M','6','9',50),(22270,11,11,313,'10','7','1',50),(22271,11,11,313,'10','7','2',50),(22272,11,11,313,'10','7','3',50),(22273,11,11,313,'10','7','4',50),(22274,11,11,313,'10','7','5',50),(22275,11,11,313,'10','7','6',50),(22276,11,11,313,'10','7','7',50),(22277,11,11,313,'7','7','8',50),(22278,11,11,313,'M','7','9',50),(22279,11,11,314,'10','1','1',50),(22280,11,11,314,'10','1','2',50),(22281,11,11,314,'10','1','3',50),(22282,11,11,314,'10','1','4',50),(22283,11,11,314,'10','1','5',50),(22284,11,11,314,'10','1','6',50),(22285,11,11,314,'10','1','7',50),(22286,11,11,314,'5','1','8',50),(22287,11,11,314,'M','1','9',50),(22288,11,11,314,'10','2','1',50),(22289,11,11,314,'10','2','2',50),(22290,11,11,314,'10','2','3',50),(22291,11,11,314,'10','2','4',50),(22292,11,11,314,'10','2','5',50),(22293,11,11,314,'10','2','6',50),(22294,11,11,314,'10','2','7',50),(22295,11,11,314,'3','2','8',50),(22296,11,11,314,'M','2','9',50),(22297,11,11,314,'10','3','1',50),(22298,11,11,314,'10','3','2',50),(22299,11,11,314,'10','3','3',50),(22300,11,11,314,'10','3','4',50),(22301,11,11,314,'10','3','5',50),(22302,11,11,314,'10','3','6',50),(22303,11,11,314,'10','3','7',50),(22304,11,11,314,'6','3','8',50),(22305,11,11,314,'M','3','9',50),(22306,11,11,314,'10','4','1',50),(22307,11,11,314,'10','4','2',50),(22308,11,11,314,'10','4','3',50),(22309,11,11,314,'10','4','4',50),(22310,11,11,314,'10','4','5',50),(22311,11,11,314,'10','4','6',50),(22312,11,11,314,'10','4','7',50),(22313,11,11,314,'5','4','8',50),(22314,11,11,314,'M','4','9',50),(22315,11,11,314,'10','5','1',50),(22316,11,11,314,'10','5','3',50),(22317,11,11,314,'10','5','2',50),(22318,11,11,314,'10','5','5',50),(22319,11,11,314,'10','5','6',50),(22320,11,11,314,'2','5','8',50),(22321,11,11,314,'10','5','7',50),(22322,11,11,314,'10','5','4',50),(22323,11,11,314,'M','5','9',50),(22324,11,11,314,'10','6','2',50),(22325,11,11,314,'10','6','3',50),(22326,11,11,314,'10','6','5',50),(22327,11,11,314,'10','6','1',50),(22328,11,11,314,'10','6','6',50),(22329,11,11,314,'10','6','7',50),(22330,11,11,314,'1','6','8',50),(22331,11,11,314,'M','6','9',50),(22332,11,11,314,'10','6','4',50),(22333,11,11,314,'10','7','1',50),(22334,11,11,314,'10','7','2',50),(22335,11,11,314,'10','7','4',50),(22336,11,11,314,'10','7','3',50),(22337,11,11,314,'10','7','5',50),(22338,11,11,314,'10','7','7',50),(22339,11,11,314,'5','7','8',50),(22340,11,11,314,'M','7','9',50),(22341,11,11,314,'10','7','6',50),(22342,11,11,315,'10','1','1',50),(22343,11,11,315,'10','1','2',50),(22344,11,11,315,'10','1','3',50),(22345,11,11,315,'10','1','4',50),(22346,11,11,315,'10','1','6',50),(22347,11,11,315,'10','1','5',50),(22348,11,11,315,'9','1','7',50),(22349,11,11,315,'M','1','8',50),(22350,11,11,315,'M','1','9',50),(22351,11,11,315,'10','2','1',50),(22352,11,11,315,'10','2','2',50),(22353,11,11,315,'10','2','3',50),(22354,11,11,315,'10','2','4',50),(22355,11,11,315,'10','2','5',50),(22357,11,11,315,'10','2','6',50),(22358,11,11,315,'10','2','7',50),(22359,11,11,315,'2','2','8',50),(22360,11,11,315,'M','2','9',50),(22361,11,11,315,'10','3','1',50),(22362,11,11,315,'10','3','2',50),(22363,11,11,315,'10','3','3',50),(22364,11,11,315,'10','3','4',50),(22365,11,11,315,'10','3','5',50),(22366,11,11,315,'10','3','6',50),(22367,11,11,315,'10','3','7',50),(22368,11,11,315,'4','3','8',50),(22369,11,11,315,'M','3','9',50),(22370,11,11,315,'10','4','1',50),(22371,11,11,315,'10','4','2',50),(22372,11,11,315,'10','4','3',50),(22373,11,11,315,'10','4','4',50),(22374,11,11,315,'10','4','5',50),(22375,11,11,315,'10','4','6',50),(22376,11,11,315,'10','4','7',50),(22377,11,11,315,'2','4','8',50),(22378,11,11,315,'M','4','9',50),(22379,11,11,315,'10','5','1',50),(22380,11,11,315,'10','5','2',50),(22381,11,11,315,'10','5','3',50),(22382,11,11,315,'10','5','4',50),(22383,11,11,315,'10','5','5',50),(22384,11,11,315,'10','5','6',50),(22385,11,11,315,'10','5','7',50),(22386,11,11,315,'4','5','8',50),(22387,11,11,315,'M','5','9',50),(22388,11,11,315,'10','6','1',50),(22389,11,11,315,'10','6','2',50),(22390,11,11,315,'10','6','3',50),(22391,11,11,315,'10','6','4',50),(22392,11,11,315,'10','6','5',50),(22393,11,11,315,'10','6','6',50),(22394,11,11,315,'10','6','7',50),(22395,11,11,315,'4','6','8',50),(22396,11,11,315,'M','6','9',50),(22397,11,11,315,'10','7','1',50),(22398,11,11,315,'10','7','2',50),(22399,11,11,315,'10','7','3',50),(22400,11,11,315,'10','7','4',50),(22401,11,11,315,'10','7','5',50),(22402,11,11,315,'10','7','6',50),(22403,11,11,315,'10','7','7',50),(22404,11,11,315,'10','7','8',50),(22405,11,11,315,'2','7','9',50),(22406,11,11,316,'10','1','1',50),(22407,11,11,316,'10','1','2',50),(22408,11,11,316,'10','1','3',50),(22409,11,11,316,'10','1','4',50),(22410,11,11,316,'10','1','5',50),(22411,11,11,316,'10','1','6',50),(22412,11,11,316,'3','1','8',50),(22413,11,11,316,'10','1','7',50),(22414,11,11,316,'10','2','1',50),(22415,11,11,316,'M','1','9',50),(22416,11,11,316,'10','2','4',50),(22417,11,11,316,'10','2','2',50),(22418,11,11,316,'10','2','3',50),(22419,11,11,316,'10','2','7',50),(22420,11,11,316,'10','2','5',50),(22421,11,11,316,'10','2','6',50),(22422,11,11,316,'9','2','8',50),(22423,11,11,316,'M','2','9',50),(22424,11,11,316,'10','3','1',50),(22425,11,11,316,'10','3','2',50),(22426,11,11,316,'10','3','3',50),(22427,11,11,316,'10','3','4',50),(22428,11,11,316,'10','3','5',50),(22429,11,11,316,'10','3','6',50),(22430,11,11,316,'10','3','7',50),(22431,11,11,316,'6','3','8',50),(22432,11,11,316,'M','3','9',50),(22433,11,11,316,'10','4','1',50),(22434,11,11,316,'10','4','2',50),(22435,11,11,316,'10','4','3',50),(22436,11,11,316,'10','4','4',50),(22437,11,11,316,'10','4','5',50),(22438,11,11,316,'10','4','6',50),(22439,11,11,316,'10','4','7',50),(22440,11,11,316,'5','4','8',50),(22441,11,11,316,'M','4','9',50),(22442,11,11,316,'10','5','1',50),(22443,11,11,316,'10','5','2',50),(22444,11,11,316,'10','5','3',50),(22445,11,11,316,'10','5','5',50),(22446,11,11,316,'10','5','6',50),(22447,11,11,316,'10','5','4',50),(22448,11,11,316,'10','5','7',50),(22450,11,11,316,'3','5','8',50),(22451,11,11,316,'M','5','9',50),(22452,11,11,316,'10','6','1',50),(22453,11,11,316,'10','6','2',50),(22454,11,11,316,'10','6','3',50),(22455,11,11,316,'10','6','4',50),(22456,11,11,316,'10','6','5',50),(22457,11,11,316,'10','6','6',50),(22458,11,11,316,'10','6','7',50),(22459,11,11,316,'3','6','8',50),(22460,11,11,316,'M','6','9',50),(22461,11,11,316,'10','7','1',50),(22462,11,11,316,'10','7','2',50),(22463,11,11,316,'10','7','3',50),(22464,11,11,316,'10','7','4',50),(22465,11,11,316,'10','7','5',50),(22466,11,11,316,'10','7','6',50),(22467,11,11,316,'6','7','7',50),(22468,11,11,316,'M','7','8',50),(22469,11,11,316,'M','7','9',50),(22470,11,11,317,'10','1','1',50),(22471,11,11,317,'10','1','2',50),(22472,11,11,317,'10','1','3',50),(22473,11,11,317,'10','1','4',50),(22474,11,11,317,'10','1','5',50),(22475,11,11,317,'10','1','6',50),(22476,11,11,317,'5','1','8',50),(22477,11,11,317,'10','1','7',50),(22478,11,11,317,'M','1','9',50),(22479,11,11,317,'10','2','1',50),(22480,11,11,317,'10','2','2',50),(22481,11,11,317,'10','2','3',50),(22482,11,11,317,'10','2','4',50),(22483,11,11,317,'10','2','5',50),(22484,11,11,317,'10','2','6',50),(22485,11,11,317,'10','2','7',50),(22486,11,11,317,'3','2','8',50),(22487,11,11,317,'M','2','9',50),(22488,11,11,317,'10','3','1',50),(22489,11,11,317,'10','3','2',50),(22490,11,11,317,'10','3','3',50),(22491,11,11,317,'10','3','4',50),(22492,11,11,317,'10','3','6',50),(22493,11,11,317,'10','3','7',50),(22494,11,11,317,'10','3','5',50),(22495,11,11,317,'M','3','8',50),(22496,11,11,317,'M','3','9',50),(22497,11,11,317,'10','4','1',50),(22498,11,11,317,'10','4','2',50),(22499,11,11,317,'10','4','3',50),(22500,11,11,317,'10','4','4',50),(22501,11,11,317,'10','4','5',50),(22502,11,11,317,'10','4','6',50),(22503,11,11,317,'10','4','7',50),(22504,11,11,317,'1','4','8',50),(22505,11,11,317,'M','4','9',50),(22506,11,11,317,'10','5','1',50),(22507,11,11,317,'10','5','2',50),(22508,11,11,317,'10','5','3',50),(22509,11,11,317,'10','5','4',50),(22510,11,11,317,'10','5','5',50),(22511,11,11,317,'10','5','6',50),(22512,11,11,317,'10','5','7',50),(22513,11,11,317,'5','5','8',50),(22514,11,11,317,'M','5','9',50),(22515,11,11,317,'10','6','1',50),(22516,11,11,317,'10','6','2',50),(22517,11,11,317,'10','6','3',50),(22518,11,11,317,'10','6','4',50),(22519,11,11,317,'10','6','5',50),(22520,11,11,317,'10','6','6',50),(22521,11,11,317,'4','6','8',50),(22522,11,11,317,'10','6','7',50),(22523,11,11,317,'M','6','9',50),(22524,11,11,317,'10','7','1',50),(22525,11,11,317,'10','7','2',50),(22526,11,11,317,'10','7','3',50),(22527,11,11,317,'10','7','4',50),(22528,11,11,317,'10','7','5',50),(22529,11,11,317,'10','7','6',50),(22530,11,11,317,'10','7','7',50),(22531,11,11,317,'6','7','8',50),(22532,11,11,317,'M','7','9',50),(22533,11,11,318,'10','1','1',50),(22534,11,11,318,'10','1','2',50),(22535,11,11,318,'10','1','3',50),(22536,11,11,318,'10','1','4',50),(22537,11,11,318,'10','1','5',50),(22538,11,11,318,'10','1','6',50),(22539,11,11,318,'10','1','7',50),(22540,11,11,318,'3','1','8',50),(22541,11,11,318,'M','1','9',50),(22542,11,11,318,'10','2','1',50),(22543,11,11,318,'10','2','2',50),(22544,11,11,318,'10','2','3',50),(22545,11,11,318,'10','2','4',50),(22546,11,11,318,'10','2','6',50),(22547,11,11,318,'10','2','5',50),(22548,11,11,318,'M','2','8',50),(22549,11,11,318,'M','2','9',50),(22550,11,11,318,'M','2','7',50),(22551,11,11,318,'10','3','1',50),(22552,11,11,318,'10','3','2',50),(22553,11,11,318,'10','3','3',50),(22554,11,11,318,'10','3','4',50),(22555,11,11,318,'10','3','5',50),(22556,11,11,318,'10','3','6',50),(22557,11,11,318,'10','3','7',50),(22558,11,11,318,'7','3','8',50),(22559,11,11,318,'M','3','9',50),(22560,11,11,318,'10','4','1',50),(22561,11,11,318,'10','4','2',50),(22562,11,11,318,'10','4','3',50),(22563,11,11,318,'10','4','4',50),(22564,11,11,318,'10','4','5',50),(22565,11,11,318,'10','4','6',50),(22566,11,11,318,'10','4','7',50),(22567,11,11,318,'3','4','9',50),(22568,11,11,318,'10','4','8',50),(22569,11,11,318,'10','5','1',50),(22570,11,11,318,'10','5','2',50),(22571,11,11,318,'10','5','3',50),(22572,11,11,318,'10','5','4',50),(22573,11,11,318,'10','5','5',50),(22574,11,11,318,'10','5','6',50),(22575,11,11,318,'10','5','7',50),(22576,11,11,318,'7','5','8',50),(22577,11,11,318,'M','5','9',50),(22578,11,11,318,'10','6','1',50),(22579,11,11,318,'10','6','2',50),(22580,11,11,318,'10','6','3',50),(22581,11,11,318,'10','6','4',50),(22582,11,11,318,'10','6','5',50),(22583,11,11,318,'10','6','6',50),(22584,11,11,318,'10','6','7',50),(22586,11,11,318,'M','6','9',50),(22587,11,11,318,'10','7','1',50),(22588,11,11,318,'10','7','2',50),(22589,11,11,318,'4','6','8',50),(22590,11,11,318,'10','7','3',50),(22591,11,11,318,'10','7','4',50),(22592,11,11,318,'10','7','5',50),(22593,11,11,318,'10','7','6',50),(22594,11,11,318,'8','7','7',50),(22595,11,11,318,'M','7','8',50),(22596,11,11,318,'M','7','9',50),(22597,11,11,319,'10','1','1',50),(22598,11,11,319,'10','1','2',50),(22599,11,11,319,'10','1','3',50),(22600,11,11,319,'10','1','4',50),(22601,11,11,319,'10','1','5',50),(22602,11,11,319,'10','1','6',50),(22603,11,11,319,'10','1','7',50),(22604,11,11,319,'4','1','8',50),(22605,11,11,319,'M','1','9',50),(22606,11,11,319,'10','2','1',50),(22607,11,11,319,'10','2','2',50),(22608,11,11,319,'10','2','3',50),(22609,11,11,319,'10','2','4',50),(22610,11,11,319,'10','2','5',50),(22612,11,11,319,'10','2','6',50),(22613,11,11,319,'6','2','7',50),(22614,11,11,319,'M','2','8',50),(22615,11,11,319,'M','2','9',50),(22616,11,11,319,'10','3','1',50),(22617,11,11,319,'10','3','2',50),(22618,11,11,319,'10','3','3',50),(22619,11,11,319,'10','3','4',50),(22620,11,11,319,'10','3','5',50),(22621,11,11,319,'10','3','6',50),(22622,11,11,319,'10','3','7',50),(22623,11,11,319,'2','3','8',50),(22624,11,11,319,'M','3','9',50),(22625,11,11,319,'10','4','1',50),(22626,11,11,319,'10','4','2',50),(22627,11,11,319,'10','4','3',50),(22628,11,11,319,'10','4','4',50),(22629,11,11,319,'10','4','5',50),(22630,11,11,319,'10','4','6',50),(22631,11,11,319,'10','4','7',50),(22632,11,11,319,'10','4','8',50),(22633,11,11,319,'M','4','9',50),(22634,11,11,319,'10','5','1',50),(22635,11,11,319,'10','5','2',50),(22636,11,11,319,'10','5','3',50),(22637,11,11,319,'10','5','4',50),(22638,11,11,319,'10','5','5',50),(22639,11,11,319,'10','5','6',50),(22640,11,11,319,'10','5','7',50),(22641,11,11,319,'2','5','8',50),(22642,11,11,319,'M','5','9',50),(22643,11,11,319,'10','6','1',50),(22644,11,11,319,'10','6','2',50),(22645,11,11,319,'10','6','3',50),(22646,11,11,319,'10','6','4',50),(22647,11,11,319,'10','6','5',50),(22648,11,11,319,'10','6','6',50),(22649,11,11,319,'10','6','7',50),(22650,11,11,319,'6','6','8',50),(22651,11,11,319,'M','6','9',50),(22652,11,11,319,'10','7','1',50),(22653,11,11,319,'10','7','2',50),(22654,11,11,319,'10','7','3',50),(22655,11,11,319,'10','7','4',50),(22656,11,11,319,'10','7','5',50),(22657,11,11,319,'10','7','6',50),(22658,11,11,319,'10','7','7',50),(22659,11,11,319,'1','7','8',50),(22660,11,11,319,'M','7','9',50),(22661,11,11,325,'10','1','1',50),(22662,11,11,325,'10','1','2',50),(22663,11,11,325,'10','1','3',50),(22664,11,11,325,'10','1','4',50),(22665,11,11,325,'10','1','5',50),(22666,11,11,325,'10','1','6',50),(22667,11,11,325,'5','1','7',50),(22668,11,11,325,'M','1','8',50),(22669,11,11,325,'M','1','9',50),(22670,11,11,325,'10','2','1',50),(22671,11,11,325,'10','2','2',50),(22672,11,11,325,'10','2','3',50),(22673,11,11,325,'10','2','5',50),(22674,11,11,325,'10','2','4',50),(22675,11,11,325,'10','2','7',50),(22676,11,11,325,'10','2','6',50),(22677,11,11,325,'7','2','8',50),(22678,11,11,325,'M','2','9',50),(22679,11,11,325,'10','3','1',50),(22680,11,11,325,'10','3','3',50),(22681,11,11,325,'10','3','2',50),(22682,11,11,325,'10','3','4',50),(22683,11,11,325,'10','3','5',50),(22684,11,11,325,'10','3','6',50),(22685,11,11,325,'7','3','7',50),(22686,11,11,325,'M','3','8',50),(22687,11,11,325,'M','3','9',50),(22689,11,11,325,'10','4','2',50),(22690,11,11,325,'10','4','3',50),(22691,11,11,325,'10','4','4',50),(22692,11,11,325,'10','4','5',50),(22693,11,11,325,'10','4','6',50),(22694,11,11,325,'10','4','1',50),(22695,11,11,325,'10','4','7',50),(22696,11,11,325,'2','4','8',50),(22697,11,11,325,'M','4','9',50),(22698,11,11,325,'10','5','1',50),(22699,11,11,325,'10','5','2',50),(22700,11,11,325,'10','5','3',50),(22701,11,11,325,'10','5','4',50),(22702,11,11,325,'10','5','5',50),(22703,11,11,325,'10','5','6',50),(22704,11,11,325,'10','5','7',50),(22705,11,11,325,'10','5','8',50),(22706,11,11,325,'1','5','9',50),(22707,11,11,325,'10','6','1',50),(22708,11,11,325,'10','6','2',50),(22709,11,11,325,'10','6','3',50),(22710,11,11,325,'10','6','4',50),(22711,11,11,325,'10','6','5',50),(22712,11,11,325,'10','6','6',50),(22713,11,11,325,'10','6','7',50),(22714,11,11,325,'1','6','8',50),(22715,11,11,325,'M','6','9',50),(22716,11,11,325,'10','7','1',50),(22717,11,11,325,'10','7','2',50),(22718,11,11,325,'10','7','3',50),(22719,11,11,325,'10','7','4',50),(22720,11,11,325,'10','7','5',50),(22722,11,11,325,'10','7','6',50),(22723,11,11,325,'10','7','7',50),(22724,11,11,325,'2','7','8',50),(22725,11,11,325,'M','7','9',50),(22726,11,11,326,'10','1','1',50),(22727,11,11,326,'10','1','3',50),(22728,11,11,326,'10','1','4',50),(22729,11,11,326,'10','1','2',50),(22730,11,11,326,'8','1','6',50),(22731,11,11,326,'M','1','7',50),(22732,11,11,326,'10','1','5',50),(22733,11,11,326,'M','1','8',50),(22734,11,11,326,'10','2','1',50),(22735,11,11,326,'10','2','2',50),(22736,11,11,326,'M','1','9',50),(22737,11,11,326,'10','2','4',50),(22738,11,11,326,'10','2','3',50),(22739,11,11,326,'10','2','5',50),(22740,11,11,326,'10','2','7',50),(22741,11,11,326,'10','2','6',50),(22742,11,11,326,'M','2','9',50),(22743,11,11,326,'8','2','8',50),(22744,11,11,326,'10','3','1',50),(22745,11,11,326,'10','3','2',50),(22746,11,11,326,'10','3','3',50),(22747,11,11,326,'10','3','4',50),(22748,11,11,326,'10','3','5',50),(22749,11,11,326,'10','3','6',50),(22750,11,11,326,'10','3','7',50),(22751,11,11,326,'4','3','8',50),(22752,11,11,326,'M','3','9',50),(22753,11,11,326,'10','4','1',50),(22754,11,11,326,'10','4','2',50),(22755,11,11,326,'10','4','3',50),(22756,11,11,326,'10','4','4',50),(22757,11,11,326,'10','4','5',50),(22758,11,11,326,'10','4','6',50),(22759,11,11,326,'10','4','7',50),(22760,11,11,326,'4','4','8',50),(22761,11,11,326,'M','4','9',50),(22762,11,11,326,'10','5','1',50),(22763,11,11,326,'10','5','2',50),(22764,11,11,326,'10','5','3',50),(22765,11,11,326,'10','5','4',50),(22766,11,11,326,'10','5','5',50),(22767,11,11,326,'10','5','6',50),(22769,11,11,326,'4','5','7',50),(22770,11,11,326,'M','5','8',50),(22771,11,11,326,'M','5','9',50),(22772,11,11,326,'10','6','1',50),(22773,11,11,326,'10','6','2',50),(22774,11,11,326,'10','6','3',50),(22775,11,11,326,'10','6','4',50),(22776,11,11,326,'10','6','5',50),(22777,11,11,326,'10','6','6',50),(22778,11,11,326,'10','6','7',50),(22779,11,11,326,'6','6','8',50),(22780,11,11,326,'M','6','9',50),(22781,11,11,326,'10','7','1',50),(22782,11,11,326,'10','7','2',50),(22783,11,11,326,'10','7','3',50),(22784,11,11,326,'10','7','4',50),(22785,11,11,326,'10','7','5',50),(22786,11,11,326,'10','7','6',50),(22787,11,11,326,'10','7','7',50),(22788,11,11,326,'M','7','9',50),(22789,11,11,326,'M','7','8',50),(22790,11,11,327,'10','1','1',50),(22791,11,11,327,'10','1','2',50),(22792,11,11,327,'10','1','3',50),(22793,11,11,327,'10','1','4',50),(22794,11,11,327,'10','1','5',50),(22795,11,11,327,'10','1','6',50),(22796,11,11,327,'10','1','7',50),(22797,11,11,327,'M','1','8',50),(22798,11,11,327,'M','1','9',50),(22799,11,11,327,'10','2','1',50),(22800,11,11,327,'10','2','2',50),(22801,11,11,327,'10','2','3',50),(22802,11,11,327,'10','2','4',50),(22803,11,11,327,'10','2','5',50),(22804,11,11,327,'10','2','6',50),(22805,11,11,327,'7','2','7',50),(22806,11,11,327,'M','2','9',50),(22807,11,11,327,'10','3','1',50),(22808,11,11,327,'M','2','8',50),(22809,11,11,327,'10','3','2',50),(22810,11,11,327,'10','3','3',50),(22811,11,11,327,'10','3','4',50),(22812,11,11,327,'10','3','5',50),(22813,11,11,327,'10','3','6',50),(22814,11,11,327,'10','3','7',50),(22815,11,11,327,'1','3','8',50),(22816,11,11,327,'M','3','9',50),(22817,11,11,327,'10','4','1',50),(22818,11,11,327,'10','4','2',50),(22819,11,11,327,'10','4','3',50),(22820,11,11,327,'10','4','4',50),(22821,11,11,327,'10','4','5',50),(22822,11,11,327,'10','4','6',50),(22823,11,11,327,'10','4','7',50),(22824,11,11,327,'6','4','8',50),(22825,11,11,327,'M','4','9',50),(22826,11,11,327,'10','5','1',50),(22827,11,11,327,'10','5','2',50),(22828,11,11,327,'10','5','3',50),(22829,11,11,327,'10','5','4',50),(22830,11,11,327,'10','5','5',50),(22831,11,11,327,'10','5','6',50),(22832,11,11,327,'10','5','7',50),(22833,11,11,327,'3','5','8',50),(22834,11,11,327,'M','5','9',50),(22835,11,11,327,'10','6','1',50),(22836,11,11,327,'10','6','2',50),(22837,11,11,327,'10','6','3',50),(22838,11,11,327,'10','6','4',50),(22839,11,11,327,'10','6','5',50),(22840,11,11,327,'10','6','6',50),(22841,11,11,327,'M','6','7',50),(22842,11,11,327,'M','6','8',50),(22843,11,11,327,'M','6','9',50),(22844,11,11,327,'10','7','1',50),(22845,11,11,327,'10','7','2',50),(22846,11,11,327,'10','7','3',50),(22847,11,11,327,'10','7','4',50),(22848,11,11,327,'10','7','5',50),(22849,11,11,327,'10','7','6',50),(22850,11,11,327,'10','7','7',50),(22851,11,11,327,'5','7','8',50),(22852,11,11,327,'M','7','9',50),(22853,11,11,328,'10','1','1',50),(22854,11,11,328,'10','1','2',50),(22855,11,11,328,'10','1','3',50),(22856,11,11,328,'10','1','5',50),(22857,11,11,328,'10','1','6',50),(22858,11,11,328,'5','1','7',50),(22859,11,11,328,'10','1','4',50),(22860,11,11,328,'M','1','8',50),(22861,11,11,328,'10','2','1',50),(22862,11,11,328,'10','2','2',50),(22863,11,11,328,'M','1','9',50),(22864,11,11,328,'10','2','4',50),(22865,11,11,328,'10','2','5',50),(22866,11,11,328,'10','2','6',50),(22867,11,11,328,'10','2','7',50),(22868,11,11,328,'10','2','3',50),(22869,11,11,328,'10','2','8',50),(22870,11,11,328,'2','2','9',50),(22871,11,11,328,'10','3','1',50),(22872,11,11,328,'10','3','2',50),(22873,11,11,328,'10','3','3',50),(22874,11,11,328,'10','3','4',50),(22875,11,11,328,'10','3','5',50),(22876,11,11,328,'10','3','6',50),(22877,11,11,328,'8','3','7',50),(22878,11,11,328,'M','3','8',50),(22879,11,11,328,'M','3','9',50),(22880,11,11,328,'10','4','1',50),(22881,11,11,328,'10','4','2',50),(22882,11,11,328,'10','4','3',50),(22883,11,11,328,'10','4','4',50),(22884,11,11,328,'10','4','5',50),(22885,11,11,328,'10','4','6',50),(22886,11,11,328,'10','4','7',50),(22887,11,11,328,'1','4','8',50),(22888,11,11,328,'M','4','9',50),(22889,11,11,328,'10','5','1',50),(22890,11,11,328,'10','5','2',50),(22891,11,11,328,'10','5','3',50),(22892,11,11,328,'10','5','4',50),(22893,11,11,328,'10','5','5',50),(22894,11,11,328,'10','5','6',50),(22895,11,11,328,'10','5','7',50),(22896,11,11,328,'4','5','8',50),(22897,11,11,328,'M','5','9',50),(22898,11,11,328,'10','6','1',50),(22899,11,11,328,'10','6','2',50),(22900,11,11,328,'10','6','3',50),(22901,11,11,328,'10','6','4',50),(22902,11,11,328,'10','6','5',50),(22903,11,11,328,'10','6','6',50),(22904,11,11,328,'1','6','7',50),(22905,11,11,328,'M','6','8',50),(22906,11,11,328,'M','6','9',50),(22907,11,11,328,'10','7','1',50),(22908,11,11,328,'10','7','2',50),(22909,11,11,328,'10','7','3',50),(22910,11,11,328,'10','7','4',50),(22911,11,11,328,'10','7','5',50),(22912,11,11,328,'10','7','6',50),(22913,11,11,328,'9','7','7',50),(22915,11,11,328,'M','7','9',50),(22916,11,11,328,'M','7','8',50),(22917,11,11,329,'10','1','1',50),(22918,11,11,329,'10','1','2',50),(22919,11,11,329,'10','1','3',50),(22920,11,11,329,'10','1','4',50),(22921,11,11,329,'10','1','5',50),(22922,11,11,329,'10','1','6',50),(22923,11,11,329,'5','1','7',50),(22924,11,11,329,'M','1','8',50),(22925,11,11,329,'M','1','9',50),(22926,11,11,329,'10','2','1',50),(22927,11,11,329,'10','2','2',50),(22928,11,11,329,'10','2','3',50),(22929,11,11,329,'10','2','4',50),(22930,11,11,329,'10','2','5',50),(22931,11,11,329,'10','2','6',50),(22932,11,11,329,'5','2','7',50),(22933,11,11,329,'M','2','9',50),(22934,11,11,329,'10','3','1',50),(22935,11,11,329,'M','2','8',50),(22936,11,11,329,'10','3','2',50),(22937,11,11,329,'10','3','3',50),(22938,11,11,329,'10','3','4',50),(22939,11,11,329,'10','3','5',50),(22940,11,11,329,'10','3','6',50),(22941,11,11,329,'3','3','7',50),(22942,11,11,329,'M','3','9',50),(22943,11,11,329,'M','3','8',50),(22944,11,11,329,'10','4','1',50),(22945,11,11,329,'10','4','4',50),(22946,11,11,329,'10','4','5',50),(22947,11,11,329,'10','4','2',50),(22948,11,11,329,'10','4','3',50),(22949,11,11,329,'10','4','6',50),(22950,11,11,329,'9','4','7',50),(22951,11,11,329,'M','4','8',50),(22952,11,11,329,'M','4','9',50),(22953,11,11,329,'10','5','1',50),(22954,11,11,329,'10','5','2',50),(22955,11,11,329,'10','5','3',50),(22956,11,11,329,'10','5','4',50),(22957,11,11,329,'10','5','5',50),(22958,11,11,329,'10','5','6',50),(22959,11,11,329,'10','5','7',50),(22960,11,11,329,'7','5','8',50),(22961,11,11,329,'M','5','9',50),(22962,11,11,329,'10','6','1',50),(22963,11,11,329,'10','6','2',50),(22964,11,11,329,'10','6','3',50),(22965,11,11,329,'10','6','4',50),(22966,11,11,329,'10','6','5',50),(22967,11,11,329,'10','6','6',50),(22968,11,11,329,'10','6','7',50),(22969,11,11,329,'3','6','8',50),(22970,11,11,329,'M','6','9',50),(22971,11,11,329,'10','7','1',50),(22972,11,11,329,'10','7','2',50),(22973,11,11,329,'10','7','3',50),(22974,11,11,329,'10','7','4',50),(22975,11,11,329,'10','7','5',50),(22976,11,11,329,'10','7','6',50),(22977,11,11,329,'10','7','7',50),(22978,11,11,329,'8','7','8',50),(22979,11,11,329,'M','7','9',50),(22980,11,11,330,'10','1','1',50),(22981,11,11,330,'10','1','2',50),(22982,11,11,330,'10','1','4',50),(22983,11,11,330,'10','1','3',50),(22984,11,11,330,'10','1','5',50),(22985,11,11,330,'10','1','7',50),(22986,11,11,330,'6','1','8',50),(22987,11,11,330,'10','1','6',50),(22988,11,11,330,'10','2','1',50),(22989,11,11,330,'10','2','2',50),(22990,11,11,330,'10','2','3',50),(22991,11,11,330,'10','2','4',50),(22992,11,11,330,'10','2','5',50),(22993,11,11,330,'10','2','7',50),(22994,11,11,330,'6','2','8',50),(22995,11,11,330,'M','2','9',50),(22996,11,11,330,'M','1','9',50),(22997,11,11,330,'10','2','6',50),(22998,11,11,330,'10','3','1',50),(22999,11,11,330,'10','3','2',50),(23000,11,11,330,'10','3','3',50),(23001,11,11,330,'10','3','6',50),(23002,11,11,330,'10','3','4',50),(23003,11,11,330,'10','3','5',50),(23004,11,11,330,'M','3','7',50),(23005,11,11,330,'M','3','9',50),(23006,11,11,330,'M','3','8',50),(23007,11,11,330,'10','4','1',50),(23008,11,11,330,'10','4','2',50),(23009,11,11,330,'10','4','3',50),(23010,11,11,330,'10','4','4',50),(23011,11,11,330,'10','4','5',50),(23012,11,11,330,'8','4','6',50),(23013,11,11,330,'M','4','7',50),(23014,11,11,330,'M','4','9',50),(23015,11,11,330,'M','4','8',50),(23016,11,11,330,'10','5','1',50),(23017,11,11,330,'10','5','3',50),(23018,11,11,330,'10','5','4',50),(23019,11,11,330,'10','5','2',50),(23020,11,11,330,'10','5','5',50),(23021,11,11,330,'10','5','6',50),(23022,11,11,330,'10','5','7',50),(23023,11,11,330,'M','5','8',50),(23024,11,11,330,'M','5','9',50),(23025,11,11,330,'10','6','1',50),(23026,11,11,330,'10','6','2',50),(23027,11,11,330,'10','6','3',50),(23028,11,11,330,'10','6','4',50),(23029,11,11,330,'10','6','5',50),(23030,11,11,330,'10','6','6',50),(23031,11,11,330,'10','6','7',50),(23032,11,11,330,'7','6','8',50),(23033,11,11,330,'M','6','9',50),(23034,11,11,330,'10','7','1',50),(23035,11,11,330,'10','7','2',50),(23036,11,11,330,'10','7','3',50),(23037,11,11,330,'10','7','4',50),(23038,11,11,330,'10','7','5',50),(23039,11,11,330,'10','7','6',50),(23040,11,11,330,'9','7','7',50),(23041,11,11,330,'M','7','8',50),(23042,11,11,330,'M','7','9',50),(23043,11,11,331,'10','1','1',50),(23044,11,11,331,'10','1','3',50),(23045,11,11,331,'10','1','2',50),(23046,11,11,331,'10','1','5',50),(23047,11,11,331,'10','1','4',50),(23048,11,11,331,'10','1','7',50),(23049,11,11,331,'10','1','6',50),(23050,11,11,331,'3','1','8',50),(23051,11,11,331,'M','1','9',50),(23052,11,11,331,'10','2','1',50),(23053,11,11,331,'10','2','2',50),(23054,11,11,331,'10','2','3',50),(23055,11,11,331,'10','2','4',50),(23056,11,11,331,'10','2','5',50),(23057,11,11,331,'10','2','6',50),(23058,11,11,331,'10','2','7',50),(23059,11,11,331,'6','2','8',50),(23060,11,11,331,'M','2','9',50),(23061,11,11,331,'10','3','2',50),(23062,11,11,331,'10','3','1',50),(23063,11,11,331,'10','3','3',50),(23064,11,11,331,'10','3','4',50),(23065,11,11,331,'10','3','6',50),(23066,11,11,331,'9','3','7',50),(23067,11,11,331,'M','3','9',50),(23068,11,11,331,'10','3','5',50),(23069,11,11,331,'M','3','8',50),(23070,11,11,331,'10','4','1',50),(23071,11,11,331,'10','4','2',50),(23072,11,11,331,'10','4','3',50),(23073,11,11,331,'10','4','4',50),(23074,11,11,331,'10','4','5',50),(23075,11,11,331,'10','4','6',50),(23076,11,11,331,'10','4','7',50),(23077,11,11,331,'1','4','8',50),(23078,11,11,331,'M','4','9',50),(23079,11,11,331,'10','5','1',50),(23080,11,11,331,'10','5','2',50),(23081,11,11,331,'10','5','3',50),(23082,11,11,331,'10','5','4',50),(23083,11,11,331,'10','5','5',50),(23085,11,11,331,'9','5','6',50),(23086,11,11,331,'M','5','7',50),(23087,11,11,331,'M','5','8',50),(23088,11,11,331,'M','5','9',50),(23089,11,11,331,'10','6','1',50),(23090,11,11,331,'10','6','2',50),(23091,11,11,331,'10','6','3',50),(23092,11,11,331,'10','6','4',50),(23093,11,11,331,'10','6','5',50),(23094,11,11,331,'10','6','6',50),(23095,11,11,331,'2','6','7',50),(23096,11,11,331,'M','6','8',50),(23097,11,11,331,'M','6','9',50),(23098,11,11,331,'10','7','1',50),(23099,11,11,331,'10','7','2',50),(23100,11,11,331,'10','7','3',50),(23101,11,11,331,'10','7','4',50),(23102,11,11,331,'10','7','5',50),(23103,11,11,331,'10','7','6',50),(23104,11,11,331,'10','7','7',50),(23105,11,11,331,'4','7','8',50),(23106,11,11,331,'M','7','9',50),(23107,11,11,333,'10','1','1',50),(23108,11,11,333,'10','1','2',50),(23109,11,11,333,'10','1','3',50),(23110,11,11,333,'10','1','4',50),(23111,11,11,333,'10','1','5',50),(23112,11,11,333,'10','1','6',50),(23113,11,11,333,'2','1','8',50),(23114,11,11,333,'10','1','7',50),(23115,11,11,333,'10','2','1',50),(23116,11,11,333,'M','1','9',50),(23117,11,11,333,'10','2','2',50),(23118,11,11,333,'10','2','3',50),(23119,11,11,333,'10','2','4',50),(23120,11,11,333,'10','2','5',50),(23121,11,11,333,'10','2','6',50),(23122,11,11,333,'7','2','7',50),(23123,11,11,333,'M','2','8',50),(23124,11,11,333,'M','2','9',50),(23125,11,11,333,'10','3','1',50),(23126,11,11,333,'10','3','2',50),(23127,11,11,333,'10','3','3',50),(23128,11,11,333,'10','3','4',50),(23129,11,11,333,'10','3','5',50),(23130,11,11,333,'10','3','6',50),(23131,11,11,333,'10','3','7',50),(23132,11,11,333,'2','3','8',50),(23133,11,11,333,'M','3','9',50),(23134,11,11,333,'10','4','1',50),(23135,11,11,333,'10','4','2',50),(23136,11,11,333,'10','4','3',50),(23137,11,11,333,'10','4','4',50),(23138,11,11,333,'10','4','5',50),(23139,11,11,333,'3','4','6',50),(23140,11,11,333,'M','4','7',50),(23141,11,11,333,'M','4','8',50),(23142,11,11,333,'M','4','9',50),(23143,11,11,333,'10','5','2',50),(23144,11,11,333,'10','5','3',50),(23145,11,11,333,'10','5','4',50),(23146,11,11,333,'10','5','5',50),(23147,11,11,333,'10','5','6',50),(23148,11,11,333,'10','5','7',50),(23149,11,11,333,'M','5','8',50),(23150,11,11,333,'M','5','9',50),(23151,11,11,333,'10','6','1',50),(23152,11,11,333,'10','6','2',50),(23153,11,11,333,'10','6','3',50),(23154,11,11,333,'10','6','4',50),(23156,11,11,333,'10','6','6',50),(23157,11,11,333,'10','6','5',50),(23158,11,11,333,'10','6','7',50),(23159,11,11,333,'10','6','8',50),(23160,11,11,333,'1','6','9',50),(23161,11,11,333,'10','7','1',50),(23162,11,11,333,'10','7','2',50),(23163,11,11,333,'10','7','3',50),(23164,11,11,333,'10','7','4',50),(23165,11,11,333,'10','7','5',50),(23166,11,11,333,'10','7','6',50),(23167,11,11,333,'8','7','7',50),(23168,11,11,333,'M','7','8',50),(23169,11,11,333,'M','7','9',50),(23170,11,11,334,'10','1','1',50),(23171,11,11,334,'10','1','2',50),(23172,11,11,334,'10','1','3',50),(23173,11,11,334,'10','1','4',50),(23174,11,11,334,'10','1','5',50),(23175,11,11,334,'2','1','6',50),(23176,11,11,334,'M','1','7',50),(23177,11,11,334,'M','1','8',50),(23178,11,11,334,'M','1','9',50),(23179,11,11,334,'10','2','1',50),(23180,11,11,334,'10','2','2',50),(23181,11,11,334,'10','2','4',50),(23182,11,11,334,'10','2','3',50),(23183,11,11,334,'10','2','6',50),(23184,11,11,334,'10','2','7',50),(23185,11,11,334,'10','2','5',50),(23186,11,11,334,'M','2','9',50),(23187,11,11,334,'2','2','8',50),(23188,11,11,334,'10','3','1',50),(23189,11,11,334,'10','3','2',50),(23190,11,11,334,'10','3','3',50),(23191,11,11,334,'10','3','5',50),(23192,11,11,334,'10','3','4',50),(23193,11,11,334,'10','3','6',50),(23194,11,11,334,'7','3','7',50),(23195,11,11,334,'M','3','9',50),(23196,11,11,334,'10','4','1',50),(23197,11,11,334,'M','3','8',50),(23198,11,11,334,'10','4','3',50),(23199,11,11,334,'10','4','2',50),(23200,11,11,334,'10','4','5',50),(23201,11,11,334,'10','4','4',50),(23202,11,11,334,'10','4','6',50),(23203,11,11,334,'10','4','7',50),(23204,11,11,334,'4','4','8',50),(23205,11,11,334,'M','4','9',50),(23206,11,11,334,'10','5','1',50),(23207,11,11,334,'10','5','2',50),(23208,11,11,334,'10','5','3',50),(23209,11,11,334,'10','5','4',50),(23210,11,11,334,'10','5','5',50),(23211,11,11,334,'10','5','6',50),(23212,11,11,334,'10','5','7',50),(23213,11,11,334,'9','5','8',50),(23214,11,11,334,'M','5','9',50),(23215,11,11,334,'10','6','1',50),(23216,11,11,334,'10','6','2',50),(23217,11,11,334,'10','6','3',50),(23218,11,11,334,'10','6','4',50),(23219,11,11,334,'10','6','5',50),(23220,11,11,334,'10','6','6',50),(23221,11,11,334,'10','6','7',50),(23222,11,11,334,'3','6','8',50),(23223,11,11,334,'M','6','9',50),(23225,11,11,334,'10','7','2',50),(23226,11,11,334,'10','7','1',50),(23227,11,11,334,'10','7','3',50),(23228,11,11,334,'10','7','4',50),(23229,11,11,334,'10','7','5',50),(23230,11,11,334,'10','7','6',50),(23231,11,11,334,'3','7','7',50),(23232,11,11,334,'M','7','8',50),(23233,11,11,334,'M','7','9',50),(23234,11,11,336,'10','1','1',50),(23235,11,11,336,'10','1','2',50),(23236,11,11,336,'10','1','3',50),(23237,11,11,336,'10','1','4',50),(23238,11,11,336,'10','1','5',50),(23239,11,11,336,'10','1','6',50),(23240,11,11,336,'10','1','7',50),(23241,11,11,336,'9','1','8',50),(23242,11,11,336,'M','1','9',50),(23243,11,11,336,'10','2','1',50),(23244,11,11,336,'10','2','2',50),(23245,11,11,336,'10','2','3',50),(23246,11,11,336,'10','2','4',50),(23247,11,11,336,'10','2','5',50),(23248,11,11,336,'7','2','6',50),(23249,11,11,336,'M','2','7',50),(23250,11,11,336,'M','2','8',50),(23251,11,11,336,'M','2','9',50),(23252,11,11,336,'10','3','1',50),(23253,11,11,336,'10','3','2',50),(23254,11,11,336,'10','3','3',50),(23255,11,11,336,'10','3','4',50),(23256,11,11,336,'10','3','5',50),(23257,11,11,336,'10','3','6',50),(23258,11,11,336,'8','3','7',50),(23259,11,11,336,'M','3','8',50),(23260,11,11,336,'M','3','9',50),(23261,11,11,336,'10','4','1',50),(23262,11,11,336,'10','4','2',50),(23263,11,11,336,'10','4','3',50),(23264,11,11,336,'10','4','4',50),(23265,11,11,336,'10','4','5',50),(23266,11,11,336,'10','4','6',50),(23267,11,11,336,'8','4','7',50),(23268,11,11,336,'M','4','8',50),(23269,11,11,336,'10','5','1',50),(23270,11,11,336,'10','5','2',50),(23271,11,11,336,'M','4','9',50),(23272,11,11,336,'10','5','3',50),(23273,11,11,336,'10','5','4',50),(23274,11,11,336,'10','5','6',50),(23275,11,11,336,'10','5','5',50),(23276,11,11,336,'10','5','7',50),(23277,11,11,336,'1','5','8',50),(23278,11,11,336,'M','5','9',50),(23279,11,11,336,'10','6','1',50),(23280,11,11,336,'10','6','2',50),(23281,11,11,336,'10','6','3',50),(23282,11,11,336,'10','6','4',50),(23283,11,11,336,'10','6','5',50),(23284,11,11,336,'10','6','6',50),(23285,11,11,336,'10','6','7',50),(23286,11,11,336,'1','6','8',50),(23287,11,11,336,'M','6','9',50),(23288,11,11,336,'10','7','1',50),(23289,11,11,336,'10','7','2',50),(23290,11,11,336,'10','7','3',50),(23291,11,11,336,'10','7','4',50),(23293,11,11,336,'10','7','5',50),(23294,11,11,336,'10','7','6',50),(23295,11,11,336,'6','7','7',50),(23296,11,11,336,'M','7','8',50),(23297,11,11,336,'M','7','9',50),(23298,11,11,337,'10','1','1',50),(23299,11,11,337,'10','1','2',50),(23300,11,11,337,'10','1','3',50),(23301,11,11,337,'10','1','4',50),(23302,11,11,337,'10','1','5',50),(23303,11,11,337,'10','1','6',50),(23304,11,11,337,'2','1','7',50),(23305,11,11,337,'M','1','8',50),(23306,11,11,337,'M','1','9',50),(23307,11,11,337,'10','2','1',50),(23308,11,11,337,'10','2','2',50),(23309,11,11,337,'10','2','3',50),(23310,11,11,337,'10','2','4',50),(23311,11,11,337,'10','2','5',50),(23312,11,11,337,'10','2','6',50),(23313,11,11,337,'1','2','7',50),(23314,11,11,337,'M','2','9',50),(23315,11,11,337,'M','2','8',50),(23316,11,11,337,'10','3','1',50),(23317,11,11,337,'10','3','2',50),(23318,11,11,337,'10','3','3',50),(23319,11,11,337,'10','3','4',50),(23320,11,11,337,'10','3','5',50),(23321,11,11,337,'10','3','6',50),(23322,11,11,337,'10','3','7',50),(23323,11,11,337,'3','3','8',50),(23324,11,11,337,'M','3','9',50),(23325,11,11,337,'10','4','1',50),(23326,11,11,337,'10','4','2',50),(23327,11,11,337,'10','4','3',50),(23328,11,11,337,'10','4','4',50),(23329,11,11,337,'10','4','5',50),(23330,11,11,337,'3','4','6',50),(23331,11,11,337,'M','4','7',50),(23332,11,11,337,'M','4','8',50),(23333,11,11,337,'M','4','9',50),(23334,11,11,337,'10','5','1',50),(23335,11,11,337,'10','5','2',50),(23336,11,11,337,'10','5','3',50),(23337,11,11,337,'10','5','4',50),(23338,11,11,337,'10','5','5',50),(23339,11,11,337,'10','5','6',50),(23340,11,11,337,'10','5','7',50),(23341,11,11,337,'4','5','8',50),(23342,11,11,337,'M','5','9',50),(23343,11,11,337,'10','6','1',50),(23344,11,11,337,'10','6','2',50),(23345,11,11,337,'10','6','4',50),(23346,11,11,337,'10','6','3',50),(23347,11,11,337,'10','6','6',50),(23348,11,11,337,'10','6','5',50),(23349,11,11,337,'10','6','7',50),(23350,11,11,337,'M','6','9',50),(23351,11,11,337,'10','7','1',50),(23352,11,11,337,'10','7','3',50),(23353,11,11,337,'10','7','2',50),(23354,11,11,337,'10','7','5',50),(23355,11,11,337,'10','7','4',50),(23356,11,11,337,'10','7','7',50),(23357,11,11,337,'10','7','6',50),(23358,11,11,337,'7','6','8',50),(23359,11,11,337,'M','7','9',50),(23360,11,11,337,'M','7','8',50),(23361,11,11,338,'10','1','1',50),(23362,11,11,338,'10','1','2',50),(23363,11,11,338,'10','1','3',50),(23364,11,11,338,'10','1','4',50),(23365,11,11,338,'10','1','5',50),(23366,11,11,338,'5','1','6',50),(23367,11,11,338,'M','1','7',50),(23368,11,11,338,'M','1','8',50),(23369,11,11,338,'M','1','9',50),(23370,11,11,338,'10','2','1',50),(23371,11,11,338,'10','2','2',50),(23372,11,11,338,'10','2','3',50),(23373,11,11,338,'10','2','4',50),(23374,11,11,338,'10','2','6',50),(23375,11,11,338,'10','2','7',50),(23376,11,11,338,'10','2','5',50),(23377,11,11,338,'M','2','9',50),(23378,11,11,338,'3','2','8',50),(23379,11,11,338,'10','3','1',50),(23380,11,11,338,'10','3','2',50),(23381,11,11,338,'10','3','3',50),(23382,11,11,338,'10','3','5',50),(23383,11,11,338,'10','3','6',50),(23384,11,11,338,'10','3','4',50),(23385,11,11,338,'M','3','8',50),(23386,11,11,338,'M','3','9',50),(23387,11,11,338,'10','4','1',50),(23388,11,11,338,'10','4','2',50),(23389,11,11,338,'10','4','4',50),(23390,11,11,338,'10','4','5',50),(23391,11,11,338,'10','4','6',50),(23392,11,11,338,'4','3','7',50),(23393,11,11,338,'10','4','3',50),(23394,11,11,338,'10','4','7',50),(23395,11,11,338,'M','4','8',50),(23396,11,11,338,'M','4','9',50),(23397,11,11,338,'10','5','1',50),(23398,11,11,338,'10','5','2',50),(23399,11,11,338,'10','5','3',50),(23400,11,11,338,'10','5','4',50),(23401,11,11,338,'10','5','5',50),(23402,11,11,338,'10','5','6',50),(23403,11,11,338,'10','5','7',50),(23404,11,11,338,'3','5','8',50),(23405,11,11,338,'M','5','9',50),(23406,11,11,338,'10','6','1',50),(23407,11,11,338,'10','6','2',50),(23408,11,11,338,'10','6','3',50),(23409,11,11,338,'10','6','5',50),(23410,11,11,338,'10','6','4',50),(23411,11,11,338,'10','6','6',50),(23412,11,11,338,'M','6','8',50),(23413,11,11,338,'7','6','7',50),(23414,11,11,338,'M','6','9',50),(23415,11,11,338,'10','7','1',50),(23416,11,11,338,'10','7','2',50),(23417,11,11,338,'10','7','3',50),(23418,11,11,338,'10','7','4',50),(23419,11,11,338,'10','7','5',50),(23420,11,11,338,'10','7','6',50),(23421,11,11,338,'7','7','7',50),(23422,11,11,338,'M','7','9',50),(23423,11,11,338,'M','7','8',50),(23424,11,11,339,'10','1','1',50),(23425,11,11,339,'10','1','2',50),(23426,11,11,339,'10','1','3',50),(23427,11,11,339,'10','1','4',50),(23428,11,11,339,'10','1','5',50),(23429,11,11,339,'10','1','6',50),(23430,11,11,339,'7','1','7',50),(23431,11,11,339,'M','1','8',50),(23432,11,11,339,'M','1','9',50),(23433,11,11,339,'10','2','1',50),(23434,11,11,339,'10','2','2',50),(23435,11,11,339,'10','2','3',50),(23436,11,11,339,'10','2','4',50),(23437,11,11,339,'10','2','5',50),(23438,11,11,339,'10','2','6',50),(23439,11,11,339,'10','2','7',50),(23440,11,11,339,'6','2','8',50),(23441,11,11,339,'M','2','9',50),(23442,11,11,339,'10','3','2',50),(23443,11,11,339,'10','3','1',50),(23444,11,11,339,'10','3','4',50),(23445,11,11,339,'10','3','5',50),(23446,11,11,339,'10','3','6',50),(23447,11,11,339,'10','3','7',50),(23448,11,11,339,'M','3','9',50),(23449,11,11,339,'10','3','3',50),(23450,11,11,339,'4','3','8',50),(23451,11,11,339,'10','4','2',50),(23452,11,11,339,'10','4','3',50),(23453,11,11,339,'10','4','1',50),(23454,11,11,339,'10','4','4',50),(23455,11,11,339,'10','4','5',50),(23456,11,11,339,'M','4','8',50),(23457,11,11,339,'1','4','7',50),(23458,11,11,339,'M','4','9',50),(23459,11,11,339,'10','4','6',50),(23460,11,11,339,'10','5','2',50),(23461,11,11,339,'10','5','3',50),(23462,11,11,339,'10','5','5',50),(23463,11,11,339,'10','5','4',50),(23464,11,11,339,'10','5','1',50),(23465,11,11,339,'10','5','7',50),(23466,11,11,339,'M','5','9',50),(23467,11,11,339,'4','5','8',50),(23468,11,11,339,'10','6','1',50),(23469,11,11,339,'10','5','6',50),(23470,11,11,339,'10','6','2',50),(23471,11,11,339,'10','6','4',50),(23472,11,11,339,'10','6','5',50),(23473,11,11,339,'10','6','3',50),(23474,11,11,339,'M','6','7',50),(23475,11,11,339,'M','6','8',50),(23476,11,11,339,'3','6','6',50),(23477,11,11,339,'M','6','9',50),(23478,11,11,339,'10','7','2',50),(23479,11,11,339,'10','7','3',50),(23480,11,11,339,'10','7','1',50),(23481,11,11,339,'10','7','5',50),(23482,11,11,339,'10','7','4',50),(23483,11,11,339,'M','7','8',50),(23484,11,11,339,'M','7','9',50),(23485,11,11,339,'9','7','6',50),(23486,11,11,339,'M','7','7',50),(23487,38,11,389,'10','1','1',57),(23488,38,11,389,'10','1','2',57),(23489,38,11,389,'10','1','3',57),(23490,38,11,389,'10','1','4',57),(23491,38,11,389,'10','1','5',57),(23492,38,11,389,'10','1','6',57),(23493,38,11,389,'10','1','7',57),(23494,38,11,389,'10','1','8',57),(23495,38,11,389,'2','1','9',57),(23496,38,11,389,'10','2','1',57),(23497,38,11,389,'10','2','2',57),(23498,38,11,389,'10','2','3',57),(23499,38,11,389,'10','2','4',57),(23500,38,11,389,'10','2','5',57),(23501,38,11,389,'10','2','6',57),(23502,38,11,389,'10','2','7',57),(23503,38,11,389,'10','2','8',57),(23504,38,11,389,'3','2','9',57),(23505,38,11,389,'10','3','1',57),(23506,38,11,389,'10','3','2',57),(23507,38,11,389,'10','3','3',57),(23508,38,11,389,'10','3','4',57),(23509,38,11,389,'10','3','5',57),(23510,38,11,389,'10','3','6',57),(23511,38,11,389,'10','3','7',57),(23512,38,11,389,'10','3','8',57),(23513,38,11,389,'3','3','9',57),(23514,38,11,389,'10','4','1',57),(23515,38,11,389,'10','4','2',57),(23516,38,11,389,'10','4','3',57),(23517,38,11,389,'10','4','4',57),(23518,38,11,389,'10','4','5',57),(23519,38,11,389,'10','4','6',57),(23521,38,11,389,'10','4','8',57),(23522,38,11,389,'10','4','7',57),(23523,38,11,389,'3','4','9',57),(23524,38,11,389,'10','5','1',57),(23525,38,11,389,'10','5','2',57),(23526,38,11,389,'10','5','3',57),(23527,38,11,389,'10','5','4',57),(23528,38,11,389,'10','5','5',57),(23529,38,11,389,'10','5','6',57),(23530,38,11,389,'10','5','7',57),(23531,38,11,389,'10','5','8',57),(23532,38,11,389,'6','5','9',57),(23533,38,11,389,'10','6','1',57),(23534,38,11,389,'10','6','2',57),(23535,38,11,389,'10','6','3',57),(23536,38,11,389,'10','6','4',57),(23537,38,11,389,'10','6','5',57),(23538,38,11,389,'10','6','6',57),(23539,38,11,389,'10','6','7',57),(23540,38,11,389,'10','6','8',57),(23541,38,11,389,'3','6','9',57),(23542,38,11,389,'10','7','1',57),(23543,38,11,389,'10','7','2',57),(23544,38,11,389,'10','7','3',57),(23545,38,11,389,'10','7','4',57),(23546,38,11,389,'10','7','5',57),(23547,38,11,389,'10','7','6',57),(23548,38,11,389,'10','7','7',57),(23549,38,11,389,'10','7','8',57),(23550,38,11,389,'2','7','9',57),(23551,38,11,390,'10','1','1',57),(23552,38,11,390,'10','1','2',57),(23553,38,11,390,'10','1','3',57),(23554,38,11,390,'10','1','4',57),(23555,38,11,390,'10','1','5',57),(23556,38,11,390,'10','1','6',57),(23557,38,11,390,'10','1','7',57),(23558,38,11,390,'9','1','8',57),(23559,38,11,390,'M','1','9',57),(23560,38,11,390,'10','2','1',57),(23561,38,11,390,'10','2','2',57),(23562,38,11,390,'10','2','3',57),(23563,38,11,390,'10','2','4',57),(23564,38,11,390,'10','2','5',57),(23565,38,11,390,'10','2','6',57),(23566,38,11,390,'10','2','7',57),(23567,38,11,390,'8','2','8',57),(23568,38,11,390,'M','2','9',57),(23569,38,11,390,'10','3','1',57),(23570,38,11,390,'10','3','2',57),(23571,38,11,390,'10','3','3',57),(23572,38,11,390,'10','3','4',57),(23573,38,11,390,'10','3','5',57),(23574,38,11,390,'10','3','6',57),(23575,38,11,390,'10','3','7',57),(23576,38,11,390,'10','3','8',57),(23577,38,11,390,'M','3','9',57),(23578,38,11,390,'10','4','1',57),(23579,38,11,390,'10','4','2',57),(23580,38,11,390,'10','4','3',57),(23581,38,11,390,'10','4','4',57),(23582,38,11,390,'10','4','5',57),(23583,38,11,390,'10','4','6',57),(23584,38,11,390,'10','4','7',57),(23585,38,11,390,'7','4','8',57),(23586,38,11,390,'M','4','9',57),(23587,38,11,390,'10','5','1',57),(23588,38,11,390,'10','5','2',57),(23589,38,11,390,'10','5','3',57),(23590,38,11,390,'10','5','4',57),(23591,38,11,390,'10','5','5',57),(23592,38,11,390,'10','5','6',57),(23593,38,11,390,'10','5','7',57),(23594,38,11,390,'10','5','8',57),(23595,38,11,390,'2','5','9',57),(23596,38,11,390,'10','6','1',57),(23597,38,11,390,'10','6','2',57),(23598,38,11,390,'10','6','3',57),(23599,38,11,390,'10','6','4',57),(23600,38,11,390,'10','6','5',57),(23601,38,11,390,'10','6','6',57),(23602,38,11,390,'10','6','7',57),(23603,38,11,390,'10','6','8',57),(23604,38,11,390,'3','6','9',57),(23605,38,11,390,'10','7','1',57),(23606,38,11,390,'10','7','2',57),(23607,38,11,390,'10','7','3',57),(23608,38,11,390,'10','7','4',57),(23609,38,11,390,'10','7','5',57),(23610,38,11,390,'10','7','6',57),(23611,38,11,390,'10','7','7',57),(23612,38,11,390,'10','7','8',57),(23613,38,11,390,'2','7','9',57),(23614,38,11,391,'10','1','1',57),(23615,38,11,391,'10','1','2',57),(23616,38,11,391,'10','1','3',57),(23617,38,11,391,'10','1','4',57),(23618,38,11,391,'10','1','5',57),(23619,38,11,391,'10','1','6',57),(23620,38,11,391,'10','1','7',57),(23621,38,11,391,'9','1','8',57),(23622,38,11,391,'M','1','9',57),(23623,38,11,391,'10','2','1',57),(23624,38,11,391,'10','2','2',57),(23625,38,11,391,'10','2','3',57),(23626,38,11,391,'10','2','4',57),(23627,38,11,391,'10','2','5',57),(23628,38,11,391,'10','2','6',57),(23629,38,11,391,'10','2','7',57),(23630,38,11,391,'9','2','8',57),(23631,38,11,391,'M','2','9',57),(23632,38,11,391,'10','3','1',57),(23633,38,11,391,'10','3','2',57),(23634,38,11,391,'10','3','3',57),(23635,38,11,391,'10','3','4',57),(23636,38,11,391,'10','3','5',57),(23637,38,11,391,'10','3','6',57),(23638,38,11,391,'10','3','7',57),(23639,38,11,391,'6','3','8',57),(23640,38,11,391,'M','3','9',57),(23641,38,11,391,'10','4','1',57),(23642,38,11,391,'10','4','2',57),(23643,38,11,391,'10','4','3',57),(23644,38,11,391,'10','4','4',57),(23645,38,11,391,'10','4','5',57),(23646,38,11,391,'10','4','6',57),(23647,38,11,391,'10','4','7',57),(23648,38,11,391,'8','4','8',57),(23649,38,11,391,'M','4','9',57),(23650,38,11,391,'10','5','1',57),(23651,38,11,391,'10','5','2',57),(23652,38,11,391,'10','5','3',57),(23653,38,11,391,'10','5','4',57),(23654,38,11,391,'10','5','5',57),(23655,38,11,391,'10','5','6',57),(23656,38,11,391,'10','5','7',57),(23657,38,11,391,'7','5','8',57),(23658,38,11,391,'M','5','9',57),(23659,38,11,391,'10','6','1',57),(23660,38,11,391,'10','6','2',57),(23661,38,11,391,'10','6','3',57),(23662,38,11,391,'10','6','4',57),(23663,38,11,391,'10','6','5',57),(23664,38,11,391,'10','6','6',57),(23665,38,11,391,'10','6','7',57),(23666,38,11,391,'10','6','8',57),(23667,38,11,391,'1','6','9',57),(23668,38,11,391,'10','7','1',57),(23669,38,11,391,'10','7','2',57),(23670,38,11,391,'10','7','3',57),(23671,38,11,391,'10','7','4',57),(23672,38,11,391,'10','7','5',57),(23673,38,11,391,'10','7','6',57),(23674,38,11,391,'10','7','7',57),(23675,38,11,391,'7','7','8',57),(23676,38,11,391,'M','7','9',57),(23677,38,11,392,'10','1','1',57),(23678,38,11,392,'10','1','2',57),(23679,38,11,392,'10','1','3',57),(23680,38,11,392,'10','1','4',57),(23681,38,11,392,'10','1','5',57),(23682,38,11,392,'10','1','6',57),(23683,38,11,392,'10','1','7',57),(23684,38,11,392,'2','1','8',57),(23685,38,11,392,'M','1','9',57),(23686,38,11,392,'10','2','1',57),(23687,38,11,392,'10','2','2',57),(23688,38,11,392,'10','2','3',57),(23689,38,11,392,'10','2','4',57),(23690,38,11,392,'10','2','5',57),(23691,38,11,392,'10','2','6',57),(23692,38,11,392,'10','2','7',57),(23693,38,11,392,'3','2','8',57),(23694,38,11,392,'M','2','9',57),(23695,38,11,392,'10','3','1',57),(23696,38,11,392,'10','3','2',57),(23697,38,11,392,'10','3','3',57),(23698,38,11,392,'10','3','4',57),(23699,38,11,392,'10','3','5',57),(23700,38,11,392,'10','3','6',57),(23701,38,11,392,'10','3','7',57),(23702,38,11,392,'8','3','8',57),(23703,38,11,392,'M','3','9',57),(23704,38,11,392,'10','4','1',57),(23705,38,11,392,'10','4','2',57),(23706,38,11,392,'10','4','3',57),(23707,38,11,392,'10','4','4',57),(23708,38,11,392,'10','4','5',57),(23709,38,11,392,'10','4','6',57),(23710,38,11,392,'10','4','7',57),(23711,38,11,392,'9','4','8',57),(23712,38,11,392,'M','4','9',57),(23713,38,11,392,'10','5','1',57),(23714,38,11,392,'10','5','2',57),(23715,38,11,392,'10','5','3',57),(23716,38,11,392,'10','5','4',57),(23717,38,11,392,'10','5','5',57),(23718,38,11,392,'10','5','6',57),(23719,38,11,392,'10','5','7',57),(23720,38,11,392,'10','5','8',57),(23721,38,11,392,'2','5','9',57),(23722,38,11,392,'10','6','1',57),(23723,38,11,392,'10','6','2',57),(23724,38,11,392,'10','6','3',57),(23725,38,11,392,'10','6','4',57),(23726,38,11,392,'10','6','5',57),(23727,38,11,392,'10','6','6',57),(23728,38,11,392,'10','6','7',57),(23729,38,11,392,'10','6','8',57),(23730,38,11,392,'M','6','9',57),(23731,38,11,392,'10','7','1',57),(23732,38,11,392,'10','7','2',57),(23733,38,11,392,'10','7','3',57),(23734,38,11,392,'10','7','4',57),(23735,38,11,392,'10','7','5',57),(23736,38,11,392,'10','7','6',57),(23737,38,11,392,'10','7','7',57),(23738,38,11,392,'7','7','8',57),(23739,38,11,392,'M','7','9',57),(23740,38,11,393,'10','1','1',57),(23741,38,11,393,'10','1','2',57),(23742,38,11,393,'10','1','3',57),(23743,38,11,393,'10','1','5',57),(23744,38,11,393,'10','1','6',57),(23745,38,11,393,'10','1','4',57),(23746,38,11,393,'M','1','8',57),(23747,38,11,393,'8','1','7',57),(23748,38,11,393,'M','1','9',57),(23749,38,11,393,'10','2','1',57),(23750,38,11,393,'10','2','2',57),(23751,38,11,393,'10','2','3',57),(23752,38,11,393,'10','2','4',57),(23753,38,11,393,'10','2','5',57),(23754,38,11,393,'10','2','6',57),(23755,38,11,393,'10','2','7',57),(23756,38,11,393,'7','2','8',57),(23757,38,11,393,'M','2','9',57),(23758,38,11,393,'10','3','1',57),(23759,38,11,393,'10','3','2',57),(23760,38,11,393,'10','3','3',57),(23761,38,11,393,'10','3','4',57),(23762,38,11,393,'10','3','5',57),(23763,38,11,393,'10','3','6',57),(23764,38,11,393,'10','3','7',57),(23765,38,11,393,'10','3','8',57),(23766,38,11,393,'M','3','9',57),(23767,38,11,393,'10','4','1',57),(23768,38,11,393,'10','4','2',57),(23769,38,11,393,'10','4','3',57),(23770,38,11,393,'10','4','4',57),(23771,38,11,393,'10','4','5',57),(23772,38,11,393,'10','4','6',57),(23773,38,11,393,'10','4','7',57),(23774,38,11,393,'6','4','8',57),(23775,38,11,393,'M','4','9',57),(23776,38,11,393,'10','5','1',57),(23777,38,11,393,'10','5','2',57),(23778,38,11,393,'10','5','3',57),(23779,38,11,393,'10','5','4',57),(23780,38,11,393,'10','5','5',57),(23781,38,11,393,'10','5','6',57),(23782,38,11,393,'10','5','7',57),(23783,38,11,393,'8','5','8',57),(23784,38,11,393,'M','5','9',57),(23785,38,11,393,'10','6','1',57),(23786,38,11,393,'10','6','2',57),(23787,38,11,393,'10','6','3',57),(23788,38,11,393,'10','6','4',57),(23789,38,11,393,'10','6','5',57),(23790,38,11,393,'10','6','6',57),(23791,38,11,393,'10','6','7',57),(23792,38,11,393,'5','6','8',57),(23793,38,11,393,'M','6','9',57),(23794,11,11,341,'10','1','1',50),(23795,38,11,393,'10','7','1',57),(23796,38,11,393,'10','7','2',57),(23797,38,11,393,'10','7','3',57),(23798,38,11,393,'10','7','4',57),(23799,38,11,393,'10','7','5',57),(23800,38,11,393,'10','7','6',57),(23801,38,11,393,'10','7','7',57),(23802,38,11,393,'10','7','8',57),(23803,38,11,393,'M','7','9',57),(23804,11,11,341,'10','1','2',50),(23805,11,11,341,'10','1','3',50),(23806,11,11,341,'10','1','4',50),(23807,11,11,341,'10','1','5',50),(23808,11,11,341,'7','1','6',50),(23809,11,11,341,'M','1','7',50),(23810,11,11,341,'M','1','8',50),(23811,11,11,341,'M','1','9',50),(23812,11,11,341,'10','2','1',50),(23813,11,11,341,'10','2','2',50),(23814,11,11,341,'10','2','3',50),(23815,11,11,341,'10','2','4',50),(23816,11,11,341,'10','2','5',50),(23817,11,11,341,'10','2','6',50),(23818,11,11,341,'10','2','7',50),(23819,11,11,341,'4','2','8',50),(23820,11,11,341,'M','2','9',50),(23821,11,11,341,'10','3','1',50),(23822,11,11,341,'10','3','2',50),(23823,11,11,341,'10','3','3',50),(23824,11,11,341,'10','3','4',50),(23825,11,11,341,'10','3','5',50),(23826,11,11,341,'10','3','6',50),(23827,11,11,341,'M','3','7',50),(23828,11,11,341,'M','3','8',50),(23829,11,11,341,'M','3','9',50),(23831,11,11,341,'10','4','2',50),(23832,11,11,341,'10','4','1',50),(23833,11,11,341,'10','4','3',50),(23834,11,11,341,'10','4','4',50),(23835,11,11,341,'10','4','5',50),(23836,11,11,341,'10','4','6',50),(23837,11,11,341,'10','4','7',50),(23838,11,11,341,'2','4','8',50),(23839,11,11,341,'M','4','9',50),(23840,11,11,341,'10','5','1',50),(23841,11,11,341,'10','5','2',50),(23842,11,11,341,'10','5','3',50),(23843,11,11,341,'10','5','4',50),(23844,11,11,341,'10','5','5',50),(23845,11,11,341,'10','5','6',50),(23846,11,11,341,'6','5','7',50),(23847,11,11,341,'M','5','8',50),(23848,11,11,341,'M','5','9',50),(23849,11,11,341,'10','6','1',50),(23850,11,11,341,'10','6','2',50),(23851,11,11,341,'10','6','3',50),(23852,11,11,341,'10','6','4',50),(23853,11,11,341,'10','6','5',50),(23854,11,11,341,'10','6','6',50),(23855,11,11,341,'8','6','7',50),(23856,11,11,341,'M','6','8',50),(23857,11,11,341,'M','6','9',50),(23858,11,11,341,'10','7','1',50),(23859,38,11,395,'10','1','1',57),(23860,11,11,341,'10','7','2',50),(23861,11,11,341,'10','7','3',50),(23862,11,11,341,'10','7','4',50),(23863,11,11,341,'10','7','5',50),(23864,11,11,341,'10','7','6',50),(23865,11,11,341,'5','7','7',50),(23866,11,11,341,'M','7','8',50),(23867,11,11,341,'M','7','9',50),(23868,38,11,395,'10','1','2',57),(23869,38,11,395,'10','1','3',57),(23870,38,11,395,'10','1','4',57),(23871,38,11,395,'10','1','5',57),(23872,38,11,395,'10','1','6',57),(23873,38,11,395,'10','1','7',57),(23874,38,11,395,'6','1','8',57),(23875,38,11,395,'M','1','9',57),(23876,38,11,395,'10','2','1',57),(23877,38,11,395,'10','2','2',57),(23878,38,11,395,'10','2','3',57),(23879,38,11,395,'10','2','4',57),(23880,38,11,395,'10','2','5',57),(23881,38,11,395,'10','2','6',57),(23882,38,11,395,'10','2','7',57),(23883,38,11,395,'7','2','8',57),(23884,38,11,395,'M','2','9',57),(23885,38,11,395,'10','3','1',57),(23886,38,11,395,'10','3','2',57),(23887,38,11,395,'10','3','3',57),(23888,38,11,395,'10','3','4',57),(23889,38,11,395,'10','3','5',57),(23890,38,11,395,'10','3','6',57),(23891,38,11,395,'10','3','7',57),(23892,38,11,395,'9','3','8',57),(23893,38,11,395,'M','3','9',57),(23894,38,11,395,'10','4','1',57),(23895,38,11,395,'10','4','2',57),(23896,38,11,395,'10','4','3',57),(23897,38,11,395,'10','4','4',57),(23898,38,11,395,'10','4','5',57),(23899,38,11,395,'10','4','6',57),(23900,38,11,395,'10','4','7',57),(23901,38,11,395,'2','4','8',57),(23902,38,11,395,'M','4','9',57),(23903,38,11,395,'10','5','1',57),(23904,38,11,395,'10','5','2',57),(23905,38,11,395,'10','5','3',57),(23906,38,11,395,'10','5','4',57),(23907,38,11,395,'10','5','5',57),(23908,38,11,395,'10','5','6',57),(23909,38,11,395,'10','5','7',57),(23910,38,11,395,'10','5','8',57),(23911,38,11,395,'M','5','9',57),(23912,38,11,395,'10','6','1',57),(23913,38,11,395,'10','6','2',57),(23914,38,11,395,'10','6','3',57),(23915,38,11,395,'10','6','4',57),(23916,38,11,395,'10','6','5',57),(23917,38,11,395,'10','6','6',57),(23918,38,11,395,'10','6','7',57),(23919,38,11,395,'4','6','8',57),(23920,38,11,395,'M','6','9',57),(23921,38,11,395,'10','7','1',57),(23922,38,11,395,'10','7','2',57),(23923,38,11,395,'10','7','3',57),(23924,38,11,395,'10','7','4',57),(23925,38,11,395,'10','7','5',57),(23926,38,11,395,'10','7','6',57),(23927,38,11,395,'10','7','7',57),(23928,11,11,342,'10','1','1',50),(23929,11,11,342,'10','1','2',50),(23930,11,11,342,'10','1','3',50),(23931,11,11,342,'10','1','4',50),(23932,11,11,342,'10','1','5',50),(23933,11,11,342,'10','1','6',50),(23934,11,11,342,'10','1','7',50),(23935,11,11,342,'M','1','8',50),(23936,11,11,342,'M','1','9',50),(23937,11,11,342,'10','2','1',50),(23938,11,11,342,'10','2','2',50),(23939,38,11,395,'3','7','8',57),(23940,11,11,342,'10','2','3',50),(23941,38,11,395,'M','7','9',57),(23942,11,11,342,'10','2','4',50),(23943,11,11,342,'10','2','5',50),(23944,11,11,342,'6','2','6',50),(23945,11,11,342,'M','2','7',50),(23946,11,11,342,'M','2','8',50),(23947,11,11,342,'M','2','9',50),(23948,11,11,342,'10','3','1',50),(23949,11,11,342,'10','3','2',50),(23950,11,11,342,'10','3','3',50),(23951,11,11,342,'10','3','4',50),(23952,11,11,342,'10','3','5',50),(23953,11,11,342,'10','3','6',50),(23954,11,11,342,'7','3','7',50),(23955,11,11,342,'M','3','8',50),(23956,11,11,342,'M','3','9',50),(23957,11,11,342,'10','4','1',50),(23958,11,11,342,'10','4','2',50),(23959,11,11,342,'10','4','3',50),(23960,11,11,342,'10','4','5',50),(23961,11,11,342,'10','4','6',50),(23962,11,11,342,'10','4','4',50),(23963,11,11,342,'10','4','7',50),(23964,11,11,342,'1','4','8',50),(23965,11,11,342,'M','4','9',50),(23966,38,11,396,'10','1','1',57),(23967,38,11,396,'10','1','2',57),(23968,38,11,396,'10','1','3',57),(23969,38,11,396,'10','1','4',57),(23970,38,11,396,'10','1','5',57),(23971,38,11,396,'10','1','6',57),(23972,38,11,396,'10','1','7',57),(23973,38,11,396,'5','1','8',57),(23974,38,11,396,'M','1','9',57),(23975,38,11,396,'10','2','1',57),(23976,38,11,396,'10','2','2',57),(23977,38,11,396,'10','2','3',57),(23978,38,11,396,'10','2','4',57),(23979,38,11,396,'10','2','5',57),(23980,38,11,396,'10','2','6',57),(23981,38,11,396,'10','2','7',57),(23982,38,11,396,'10','2','8',57),(23983,11,11,342,'10','5','1',50),(23984,38,11,396,'1','2','9',57),(23985,11,11,342,'10','5','2',50),(23986,38,11,396,'10','3','1',57),(23987,11,11,342,'10','5','3',50),(23988,38,11,396,'10','3','2',57),(23989,11,11,342,'10','5','4',50),(23990,38,11,396,'10','3','3',57),(23991,11,11,342,'10','5','5',50),(23992,11,11,342,'10','5','6',50),(23993,11,11,342,'5','5','7',50),(23994,11,11,342,'M','5','8',50),(23995,11,11,342,'M','5','9',50),(23996,11,11,342,'10','6','1',50),(23997,11,11,342,'10','6','2',50),(23998,11,11,342,'10','6','3',50),(23999,38,11,396,'10','3','4',57),(24000,11,11,342,'10','6','4',50),(24001,38,11,396,'10','3','5',57),(24002,38,11,396,'10','3','6',57),(24003,11,11,342,'10','6','5',50),(24004,38,11,396,'9','3','7',57),(24005,11,11,342,'10','6','6',50),(24006,38,11,396,'M','3','8',57),(24007,11,11,342,'M','6','7',50),(24008,38,11,396,'M','3','9',57),(24009,11,11,342,'M','6','8',50),(24010,11,11,342,'M','6','9',50),(24011,11,11,342,'10','7','1',50),(24012,11,11,342,'10','7','2',50),(24013,11,11,342,'10','7','4',50),(24014,11,11,342,'10','7','3',50),(24015,11,11,342,'10','7','5',50),(24016,11,11,342,'10','7','6',50),(24017,38,11,396,'10','4','1',57),(24018,11,11,342,'2','7','8',50),(24019,38,11,396,'10','4','2',57),(24020,11,11,342,'10','7','7',50),(24021,38,11,396,'10','4','3',57),(24022,11,11,342,'M','7','9',50),(24023,38,11,396,'10','4','4',57),(24024,38,11,396,'10','4','5',57),(24025,38,11,396,'10','4','6',57),(24026,38,11,396,'10','4','7',57),(24027,38,11,396,'2','4','8',57),(24028,38,11,396,'M','4','9',57),(24029,38,11,396,'10','5','1',57),(24030,38,11,396,'10','5','2',57),(24031,38,11,396,'10','5','3',57),(24032,38,11,396,'10','5','4',57),(24033,38,11,396,'10','5','5',57),(24034,38,11,396,'10','5','6',57),(24035,38,11,396,'10','5','7',57),(24036,38,11,396,'7','5','8',57),(24037,38,11,396,'M','5','9',57),(24038,38,11,396,'10','6','1',57),(24039,38,11,396,'10','6','2',57),(24040,38,11,396,'10','6','3',57),(24041,38,11,396,'10','6','4',57),(24042,38,11,396,'10','6','5',57),(24043,38,11,396,'10','6','6',57),(24044,38,11,396,'10','6','7',57),(24045,38,11,396,'7','6','8',57),(24046,38,11,396,'M','6','9',57),(24047,38,11,396,'10','7','1',57),(24048,38,11,396,'10','7','2',57),(24049,38,11,396,'10','7','3',57),(24050,38,11,396,'10','7','4',57),(24051,38,11,396,'10','7','5',57),(24052,38,11,396,'10','7','6',57),(24053,38,11,396,'10','7','7',57),(24054,38,11,396,'9','7','8',57),(24055,38,11,396,'M','7','9',57),(24057,38,11,401,'10','1','1',57),(24058,38,11,401,'10','1','2',57),(24059,38,11,401,'10','1','3',57),(24060,38,11,401,'10','1','4',57),(24061,38,11,401,'10','1','5',57),(24062,38,11,401,'10','1','6',57),(24063,38,11,401,'10','1','7',57),(24064,38,11,401,'3','1','8',57),(24065,38,11,401,'M','1','9',57),(24066,38,11,401,'10','2','1',57),(24067,38,11,401,'10','2','2',57),(24068,38,11,401,'10','2','3',57),(24069,38,11,401,'10','2','4',57),(24070,38,11,401,'10','2','5',57),(24071,38,11,401,'10','2','6',57),(24072,11,11,344,'10','1','1',50),(24073,38,11,401,'10','2','7',57),(24074,11,11,344,'10','1','2',50),(24075,11,11,344,'10','1','4',50),(24076,38,11,401,'10','2','8',57),(24077,11,11,344,'10','1','3',50),(24078,11,11,344,'10','1','5',50),(24079,11,11,344,'10','1','7',50),(24080,11,11,344,'10','1','6',50),(24081,11,11,344,'M','1','9',50),(24082,11,11,344,'1','1','8',50),(24083,11,11,344,'10','2','1',50),(24084,11,11,344,'10','2','3',50),(24085,11,11,344,'10','2','2',50),(24086,11,11,344,'10','2','4',50),(24087,11,11,344,'10','2','5',50),(24088,11,11,344,'10','2','6',50),(24089,11,11,344,'6','2','7',50),(24090,11,11,344,'M','2','8',50),(24091,11,11,344,'M','2','9',50),(24092,11,11,344,'10','3','1',50),(24093,11,11,344,'10','3','2',50),(24094,11,11,344,'10','3','3',50),(24095,11,11,344,'10','3','4',50),(24096,11,11,344,'10','3','5',50),(24097,38,11,401,'M','2','9',57),(24098,38,11,401,'10','3','1',57),(24099,11,11,344,'10','3','6',50),(24100,11,11,344,'3','3','7',50),(24101,11,11,344,'M','3','8',50),(24102,11,11,344,'M','3','9',50),(24103,11,11,344,'10','4','1',50),(24104,11,11,344,'10','4','2',50),(24105,11,11,344,'10','4','3',50),(24106,11,11,344,'10','4','4',50),(24107,11,11,344,'10','4','5',50),(24108,11,11,344,'9','4','6',50),(24109,11,11,344,'M','4','7',50),(24110,11,11,344,'M','4','8',50),(24111,11,11,344,'M','4','9',50),(24112,11,11,344,'10','5','1',50),(24113,11,11,344,'10','5','2',50),(24114,11,11,344,'10','5','3',50),(24115,38,11,401,'10','3','2',57),(24116,11,11,344,'10','5','4',50),(24117,38,11,401,'10','3','3',57),(24118,11,11,344,'10','5','5',50),(24119,38,11,401,'10','3','4',57),(24120,11,11,344,'10','5','6',50),(24121,38,11,401,'10','3','5',57),(24122,11,11,344,'M','5','8',50),(24123,38,11,401,'10','3','6',57),(24124,11,11,344,'M','5','9',50),(24125,11,11,344,'5','5','7',50),(24126,11,11,344,'10','6','1',50),(24127,38,11,401,'5','3','7',57),(24128,38,11,401,'M','3','8',57),(24129,11,11,344,'10','6','2',50),(24130,38,11,401,'M','3','9',57),(24131,11,11,344,'10','6','3',50),(24132,11,11,344,'10','6','4',50),(24133,38,11,401,'10','4','1',57),(24134,11,11,344,'10','6','5',50),(24135,38,11,401,'10','4','2',57),(24136,38,11,401,'10','4','3',57),(24137,11,11,344,'9','6','6',50),(24138,38,11,401,'10','4','4',57),(24139,38,11,401,'10','4','5',57),(24140,11,11,344,'M','6','7',50),(24141,38,11,401,'10','4','6',57),(24142,11,11,344,'M','6','8',50),(24143,38,11,401,'7','4','7',57),(24144,11,11,344,'M','6','9',50),(24146,11,11,344,'10','7','1',50),(24147,11,11,344,'10','7','2',50),(24148,11,11,344,'10','7','3',50),(24149,11,11,344,'10','7','4',50),(24150,11,11,344,'10','7','5',50),(24151,11,11,344,'10','7','6',50),(24152,11,11,344,'9','7','7',50),(24153,11,11,344,'M','7','8',50),(24154,11,11,344,'M','7','9',50),(24155,38,11,401,'M','4','8',57),(24156,38,11,401,'M','4','9',57),(24157,38,11,401,'10','5','1',57),(24158,38,11,401,'10','5','2',57),(24159,38,11,401,'10','5','3',57),(24160,38,11,401,'10','5','4',57),(24161,38,11,401,'10','5','5',57),(24162,38,11,401,'10','5','6',57),(24163,38,11,401,'10','5','7',57),(24164,38,11,401,'6','5','8',57),(24165,38,11,401,'M','5','9',57),(24166,38,11,401,'10','6','1',57),(24167,38,11,401,'10','6','2',57),(24168,38,11,401,'10','6','3',57),(24169,38,11,401,'10','6','4',57),(24170,38,11,401,'10','6','5',57),(24171,38,11,401,'10','6','6',57),(24172,38,11,401,'10','6','7',57),(24173,38,11,401,'9','6','8',57),(24174,38,11,401,'M','6','9',57),(24175,38,11,401,'10','7','1',57),(24176,38,11,401,'10','7','2',57),(24177,38,11,401,'10','7','3',57),(24178,38,11,401,'10','7','4',57),(24179,38,11,401,'10','7','5',57),(24180,38,11,401,'10','7','6',57),(24181,38,11,401,'10','7','7',57),(24182,38,11,401,'10','7','8',57),(24183,38,11,401,'4','7','9',57),(24184,11,11,346,'10','1','1',50),(24185,11,11,346,'10','1','2',50),(24186,11,11,346,'10','1','3',50),(24187,11,11,346,'10','1','4',50),(24188,11,11,346,'10','1','5',50),(24189,11,11,346,'10','1','6',50),(24190,38,11,407,'10','1','1',57),(24191,38,11,407,'10','1','2',57),(24192,11,11,346,'9','1','7',50),(24193,38,11,407,'10','1','3',57),(24194,11,11,346,'M','1','8',50),(24195,38,11,407,'10','1','4',57),(24196,11,11,346,'M','1','9',50),(24197,38,11,407,'10','1','5',57),(24198,11,11,346,'10','2','1',50),(24199,38,11,407,'10','1','6',57),(24200,11,11,346,'10','2','2',50),(24201,38,11,407,'8','1','7',57),(24202,11,11,346,'10','2','3',50),(24203,11,11,346,'10','2','4',50),(24204,11,11,346,'10','2','6',50),(24205,11,11,346,'M','2','7',50),(24206,11,11,346,'10','2','5',50),(24207,11,11,346,'M','2','8',50),(24208,11,11,346,'10','3','1',50),(24209,11,11,346,'10','3','2',50),(24210,38,11,407,'M','1','8',57),(24211,11,11,346,'10','3','4',50),(24212,38,11,407,'M','1','9',57),(24213,11,11,346,'10','3','3',50),(24214,11,11,346,'3','3','6',50),(24215,38,11,407,'10','2','1',57),(24216,38,11,407,'10','2','2',57),(24217,11,11,346,'M','2','9',50),(24218,38,11,407,'10','2','3',57),(24219,11,11,346,'M','3','7',50),(24220,11,11,346,'10','3','5',50),(24221,38,11,407,'10','2','4',57),(24222,11,11,346,'M','3','8',50),(24223,11,11,346,'M','3','9',50),(24224,38,11,407,'10','2','5',57),(24225,38,11,407,'10','2','6',57),(24226,38,11,407,'10','2','7',57),(24227,38,11,407,'10','2','8',57),(24228,38,11,407,'M','2','9',57),(24229,38,11,407,'10','3','1',57),(24230,38,11,407,'10','3','2',57),(24231,38,11,407,'10','3','3',57),(24232,38,11,407,'10','3','4',57),(24233,38,11,407,'10','3','5',57),(24234,38,11,407,'10','3','6',57),(24235,38,11,407,'8','3','7',57),(24236,38,11,407,'M','3','9',57),(24237,38,11,407,'M','3','8',57),(24238,38,11,407,'10','4','1',57),(24239,38,11,407,'10','4','2',57),(24240,38,11,407,'10','4','3',57),(24241,38,11,407,'10','4','4',57),(24242,38,11,407,'10','4','5',57),(24243,38,11,407,'10','4','6',57),(24244,38,11,407,'10','4','7',57),(24245,38,11,407,'10','4','8',57),(24246,38,11,407,'M','4','9',57),(24247,38,11,407,'10','5','1',57),(24248,38,11,407,'10','5','2',57),(24249,38,11,407,'10','5','3',57),(24250,38,11,407,'10','5','4',57),(24251,38,11,407,'10','5','5',57),(24252,38,11,407,'10','5','6',57),(24253,38,11,407,'10','5','7',57),(24254,38,11,407,'8','5','8',57),(24255,38,11,407,'M','5','9',57),(24256,38,11,407,'10','6','1',57),(24257,38,11,407,'10','6','2',57),(24258,38,11,407,'10','6','3',57),(24259,38,11,407,'10','6','4',57),(24260,38,11,407,'10','6','5',57),(24261,38,11,407,'10','6','6',57),(24262,38,11,407,'10','6','7',57),(24263,38,11,407,'4','6','8',57),(24264,38,11,407,'M','6','9',57),(24265,38,11,407,'10','7','1',57),(24266,38,11,407,'10','7','2',57),(24267,38,11,407,'10','7','3',57),(24268,38,11,407,'10','7','4',57),(24269,38,11,407,'10','7','5',57),(24270,38,11,407,'10','7','7',57),(24271,38,11,407,'10','7','6',57),(24272,38,11,407,'7','7','8',57),(24273,38,11,407,'M','7','9',57),(24274,38,11,399,'10','1','2',57),(24275,38,11,399,'10','1','1',57),(24276,38,11,399,'10','1','3',57),(24277,38,11,399,'10','1','5',57),(24278,38,11,399,'10','1','4',57),(24279,38,11,399,'10','1','6',57),(24280,38,11,399,'9','1','7',57),(24281,38,11,399,'M','1','9',57),(24282,38,11,399,'M','1','8',57),(24283,38,11,399,'10','2','1',57),(24284,38,11,399,'10','2','2',57),(24285,38,11,399,'10','2','3',57),(24286,38,11,399,'10','2','4',57),(24287,38,11,399,'10','2','5',57),(24288,38,11,399,'10','2','6',57),(24289,38,11,399,'10','2','7',57),(24290,11,11,346,'10','4','1',50),(24291,38,11,399,'9','2','8',57),(24292,11,11,346,'10','4','2',50),(24293,38,11,399,'M','2','9',57),(24294,11,11,346,'10','4','3',50),(24295,11,11,346,'10','4','4',50),(24296,38,11,399,'10','3','1',57),(24297,11,11,346,'10','4','5',50),(24298,38,11,399,'10','3','2',57),(24299,11,11,346,'10','4','6',50),(24300,38,11,399,'10','3','3',57),(24301,38,11,399,'10','3','4',57),(24302,38,11,399,'10','3','5',57),(24303,11,11,346,'3','4','7',50),(24304,38,11,399,'10','3','6',57),(24305,38,11,399,'10','3','7',57),(24306,11,11,346,'M','4','8',50),(24307,38,11,399,'7','3','8',57),(24308,38,11,399,'M','3','9',57),(24309,11,11,346,'M','4','9',50),(24310,11,11,346,'10','5','1',50),(24311,38,11,399,'10','4','1',57),(24312,38,11,399,'10','4','2',57),(24313,11,11,346,'10','5','2',50),(24314,11,11,346,'10','5','3',50),(24315,38,11,399,'10','4','3',57),(24316,11,11,346,'10','5','4',50),(24317,38,11,399,'10','4','4',57),(24318,38,11,399,'10','4','5',57),(24319,11,11,346,'10','5','5',50),(24320,38,11,399,'10','4','6',57),(24321,11,11,346,'10','5','6',50),(24322,38,11,399,'10','4','7',57),(24323,11,11,346,'10','5','7',50),(24324,38,11,399,'9','4','8',57),(24325,11,11,346,'M','5','8',50),(24326,38,11,399,'M','4','9',57),(24327,11,11,346,'M','5','9',50),(24328,38,11,399,'10','5','1',57),(24329,11,11,346,'10','6','2',50),(24330,38,11,399,'10','5','2',57),(24331,11,11,346,'10','6','3',50),(24332,38,11,399,'10','5','3',57),(24333,11,11,346,'10','6','4',50),(24334,38,11,399,'10','5','4',57),(24335,11,11,346,'10','6','1',50),(24336,38,11,399,'10','5','5',57),(24338,38,11,399,'10','5','6',57),(24339,38,11,399,'10','5','7',57),(24340,11,11,346,'10','6','7',50),(24341,11,11,346,'10','6','6',50),(24342,11,11,346,'10','6','5',50),(24343,11,11,346,'1','6','8',50),(24344,11,11,346,'M','6','9',50),(24345,11,11,346,'10','7','1',50),(24346,11,11,346,'10','7','2',50),(24347,11,11,346,'10','7','3',50),(24348,11,11,346,'10','7','4',50),(24349,11,11,346,'10','7','5',50),(24350,11,11,346,'10','7','6',50),(24351,11,11,346,'M','7','7',50),(24352,11,11,346,'M','7','8',50),(24353,11,11,346,'M','7','9',50),(24354,38,11,399,'5','5','8',57),(24355,38,11,399,'M','5','9',57),(24356,38,11,399,'10','6','1',57),(24357,38,11,399,'10','6','2',57),(24358,38,11,399,'10','6','3',57),(24359,38,11,399,'10','6','4',57),(24360,38,11,399,'10','6','5',57),(24361,38,11,399,'10','6','6',57),(24362,38,11,399,'10','6','7',57),(24363,38,11,399,'7','6','8',57),(24364,38,11,399,'M','6','9',57),(24365,38,11,399,'10','7','1',57),(24366,38,11,399,'10','7','2',57),(24367,38,11,399,'10','7','3',57),(24368,38,11,399,'10','7','4',57),(24369,38,11,399,'10','7','5',57),(24370,38,11,399,'10','7','6',57),(24371,38,11,399,'10','7','7',57),(24372,38,11,399,'3','7','8',57),(24373,38,11,399,'M','7','9',57),(24374,11,11,347,'10','1','1',50),(24375,11,11,347,'10','1','2',50),(24376,11,11,347,'10','1','3',50),(24377,11,11,347,'10','1','4',50),(24378,11,11,347,'5','1','5',50),(24379,11,11,347,'M','1','6',50),(24380,11,11,347,'M','1','7',50),(24381,11,11,347,'M','1','8',50),(24382,11,11,347,'M','1','9',50),(24383,11,11,347,'10','2','2',50),(24384,11,11,347,'10','2','1',50),(24385,11,11,347,'10','2','4',50),(24386,11,11,347,'10','2','5',50),(24387,11,11,347,'10','2','3',50),(24388,11,11,347,'M','2','7',50),(24389,11,11,347,'M','2','9',50),(24390,11,11,347,'10','3','1',50),(24391,11,11,347,'M','2','8',50),(24392,11,11,347,'10','3','2',50),(24393,11,11,347,'M','2','6',50),(24394,11,11,347,'10','3','4',50),(24395,11,11,347,'10','3','5',50),(24396,11,11,347,'5','3','7',50),(24397,11,11,347,'10','3','6',50),(24398,11,11,347,'10','3','3',50),(24399,11,11,347,'M','3','9',50),(24400,11,11,347,'M','3','8',50),(24401,11,11,347,'10','4','1',50),(24402,11,11,347,'10','4','2',50),(24403,11,11,347,'10','4','3',50),(24404,11,11,347,'10','4','5',50),(24405,11,11,347,'10','4','6',50),(24406,11,11,347,'10','4','4',50),(24407,11,11,347,'4','4','8',50),(24408,11,11,347,'10','4','7',50),(24409,11,11,347,'10','5','1',50),(24410,11,11,347,'10','5','2',50),(24411,11,11,347,'10','5','3',50),(24412,11,11,347,'10','5','5',50),(24413,11,11,347,'10','5','6',50),(24414,11,11,347,'M','4','9',50),(24415,11,11,347,'4','5','8',50),(24416,11,11,347,'M','5','9',50),(24417,11,11,347,'10','5','7',50),(24418,11,11,347,'10','6','1',50),(24419,11,11,347,'10','6','2',50),(24420,11,11,347,'10','6','3',50),(24421,11,11,347,'10','6','4',50),(24422,11,11,347,'10','5','4',50),(24423,11,11,347,'10','6','6',50),(24424,11,11,347,'10','7','1',50),(24425,11,11,347,'2','6','8',50),(24426,11,11,347,'10','6','7',50),(24427,11,11,347,'10','7','3',50),(24430,11,11,347,'10','7','6',50),(24431,11,11,347,'10','6','5',50),(24432,11,11,347,'M','6','9',50),(24433,11,11,347,'10','7','2',50),(24434,11,11,347,'10','7','4',50),(24435,11,11,347,'5','7','7',50),(24436,11,11,347,'M','7','9',50),(24437,11,11,347,'M','7','8',50),(24438,38,11,287,'10','1','1',57),(24439,38,11,287,'10','1','2',57),(24440,38,11,287,'10','1','3',57),(24441,38,11,287,'10','1','4',57),(24442,38,11,287,'10','1','5',57),(24443,38,11,287,'10','1','6',57),(24444,38,11,287,'10','1','7',57),(24445,38,11,287,'M','1','8',57),(24446,38,11,287,'M','1','9',57),(24447,38,11,287,'10','2','1',57),(24448,38,11,287,'10','2','2',57),(24449,38,11,287,'10','2','3',57),(24450,38,11,287,'10','2','4',57),(24451,11,11,348,'10','1','1',50),(24452,38,11,287,'10','2','5',57),(24453,11,11,348,'10','1','2',50),(24454,38,11,287,'10','2','6',57),(24455,38,11,287,'10','2','7',57),(24456,11,11,348,'10','1','3',50),(24457,38,11,287,'6','2','8',57),(24458,11,11,348,'10','1','4',50),(24459,11,11,348,'10','1','5',50),(24460,38,11,287,'M','2','9',57),(24461,11,11,348,'10','1','6',50),(24462,38,11,287,'10','3','1',57),(24463,11,11,348,'10','1','7',50),(24464,38,11,287,'10','3','2',57),(24465,11,11,348,'M','1','8',50),(24466,38,11,287,'10','3','3',57),(24467,11,11,348,'M','1','9',50),(24468,38,11,287,'10','3','4',57),(24469,11,11,348,'10','2','2',50),(24470,38,11,287,'10','3','5',57),(24471,11,11,348,'10','2','4',50),(24472,38,11,287,'10','3','6',57),(24473,38,11,287,'10','3','7',57),(24474,11,11,348,'10','2','1',50),(24475,38,11,287,'1','3','8',57),(24476,11,11,348,'10','2','5',50),(24477,38,11,287,'M','3','9',57),(24478,11,11,348,'10','2','3',50),(24479,38,11,287,'10','4','1',57),(24480,11,11,348,'M','2','8',50),(24481,38,11,287,'10','4','2',57),(24482,11,11,348,'1','2','7',50),(24483,38,11,287,'10','4','3',57),(24484,11,11,348,'M','2','9',50),(24485,38,11,287,'10','4','4',57),(24486,11,11,348,'10','2','6',50),(24487,38,11,287,'10','4','5',57),(24488,11,11,348,'10','3','4',50),(24489,38,11,287,'10','4','6',57),(24490,38,11,287,'10','4','7',57),(24491,11,11,348,'10','3','5',50),(24492,38,11,287,'7','4','8',57),(24493,11,11,348,'10','3','2',50),(24494,38,11,287,'M','4','9',57),(24495,11,11,348,'M','3','7',50),(24496,38,11,287,'10','5','1',57),(24497,11,11,348,'10','3','1',50),(24498,38,11,287,'10','5','2',57),(24499,11,11,348,'10','3','3',50),(24500,38,11,287,'10','5','3',57),(24501,11,11,348,'10','4','2',50),(24502,38,11,287,'10','5','4',57),(24503,38,11,287,'10','5','5',57),(24504,11,11,348,'10','4','3',50),(24505,38,11,287,'10','5','6',57),(24506,11,11,348,'M','3','8',50),(24507,38,11,287,'10','5','7',57),(24508,11,11,348,'10','4','6',50),(24509,38,11,287,'5','5','8',57),(24510,11,11,348,'10','4','4',50),(24511,38,11,287,'M','5','9',57),(24512,11,11,348,'M','4','9',50),(24513,38,11,287,'10','6','1',57),(24515,38,11,287,'10','6','2',57),(24516,38,11,287,'10','6','3',57),(24517,11,11,348,'M','3','9',50),(24518,38,11,287,'10','6','4',57),(24519,11,11,348,'10','4','5',50),(24520,38,11,287,'10','6','5',57),(24521,38,11,287,'10','6','6',57),(24522,11,11,348,'10','4','7',50),(24523,38,11,287,'10','6','7',57),(24524,11,11,348,'10','5','3',50),(24525,38,11,287,'8','6','8',57),(24526,38,11,287,'M','6','9',57),(24527,11,11,348,'10','4','1',50),(24528,38,11,287,'10','7','1',57),(24529,11,11,348,'9','5','6',50),(24530,38,11,287,'10','7','2',57),(24531,11,11,348,'10','5','2',50),(24532,38,11,287,'10','7','3',57),(24533,38,11,287,'10','7','4',57),(24534,11,11,348,'10','3','6',50),(24535,38,11,287,'10','7','5',57),(24536,38,11,287,'10','7','6',57),(24537,38,11,287,'10','7','7',57),(24538,11,11,348,'3','4','8',50),(24539,11,11,348,'10','5','4',50),(24540,38,11,287,'7','7','8',57),(24542,38,11,287,'M','7','9',57),(24543,11,11,348,'10','5','5',50),(24544,11,11,348,'M','5','8',50),(24545,11,11,348,'M','5','9',50),(24546,11,11,348,'M','5','7',50),(24547,11,11,348,'10','6','1',50),(24548,11,11,348,'10','6','2',50),(24549,11,11,348,'10','6','3',50),(24550,11,11,348,'10','6','4',50),(24551,11,11,348,'10','6','5',50),(24552,11,11,348,'10','6','6',50),(24553,11,11,348,'M','6','8',50),(24554,11,11,348,'3','6','7',50),(24555,11,11,348,'10','7','1',50),(24556,11,11,348,'M','6','9',50),(24557,11,11,348,'10','7','3',50),(24558,11,11,348,'10','7','4',50),(24559,11,11,348,'10','7','2',50),(24560,11,11,348,'6','7','6',50),(24561,11,11,348,'10','7','5',50),(24562,38,11,418,'10','1','1',57),(24563,38,11,418,'10','1','2',57),(24564,38,11,418,'10','1','3',57),(24565,38,11,418,'10','1','4',57),(24566,11,11,348,'M','7','7',50),(24567,38,11,418,'10','1','5',57),(24568,11,11,348,'M','7','8',50),(24569,38,11,418,'10','1','6',57),(24570,11,11,348,'M','7','9',50),(24571,38,11,418,'9','1','7',57),(24572,38,11,418,'M','1','8',57),(24573,38,11,418,'M','1','9',57),(24574,38,11,418,'10','2','1',57),(24575,38,11,418,'10','2','2',57),(24576,38,11,418,'10','2','3',57),(24577,38,11,418,'10','2','4',57),(24578,38,11,418,'10','2','5',57),(24579,38,11,418,'10','2','6',57),(24580,38,11,418,'9','2','7',57),(24581,38,11,418,'M','2','8',57),(24582,38,11,418,'M','2','9',57),(24583,38,11,418,'10','3','1',57),(24584,38,11,418,'10','3','2',57),(24585,38,11,418,'10','3','3',57),(24586,38,11,418,'10','3','4',57),(24587,38,11,418,'10','3','5',57),(24588,38,11,418,'10','3','6',57),(24589,38,11,418,'10','3','7',57),(24590,38,11,418,'10','3','8',57),(24591,38,11,418,'5','3','9',57),(24592,38,11,418,'10','4','1',57),(24593,38,11,418,'10','4','2',57),(24594,38,11,418,'10','4','3',57),(24595,38,11,418,'10','4','4',57),(24596,38,11,418,'10','4','5',57),(24597,38,11,418,'10','4','6',57),(24598,38,11,418,'10','4','7',57),(24599,38,11,418,'2','4','8',57),(24600,38,11,418,'M','4','9',57),(24601,38,11,418,'10','5','1',57),(24602,38,11,418,'10','5','2',57),(24603,38,11,418,'10','5','3',57),(24604,38,11,418,'10','5','4',57),(24605,38,11,418,'10','6','5',57),(24606,38,11,418,'10','5','5',57),(24607,38,11,418,'10','5','6',57),(24608,38,11,418,'10','5','7',57),(24609,38,11,418,'10','5','8',57),(24610,38,11,418,'2','5','9',57),(24611,38,11,418,'10','6','1',57),(24612,38,11,418,'10','6','2',57),(24613,38,11,418,'10','6','3',57),(24614,38,11,418,'10','6','4',57),(24615,38,11,418,'10','6','6',57),(24616,38,11,418,'4','6','7',57),(24617,38,11,418,'M','6','8',57),(24618,38,11,418,'M','6','9',57),(24619,38,11,418,'10','7','1',57),(24620,38,11,418,'10','7','2',57),(24621,38,11,418,'10','7','3',57),(24622,38,11,418,'10','7','4',57),(24623,38,11,418,'10','7','5',57),(24624,38,11,418,'10','7','6',57),(24625,38,11,418,'10','7','7',57),(24626,38,11,418,'10','7','8',57),(24627,38,11,418,'M','7','9',57),(24628,11,11,349,'10','1','1',50),(24629,11,11,349,'10','1','2',50),(24630,11,11,349,'10','1','3',50),(24631,11,11,349,'10','1','5',50),(24632,11,11,349,'10','1','4',50),(24633,11,11,349,'10','1','6',50),(24634,11,11,349,'10','1','7',50),(24635,11,11,349,'3','1','8',50),(24636,11,11,349,'M','1','9',50),(24637,11,11,349,'10','2','1',50),(24638,11,11,349,'10','2','2',50),(24639,11,11,349,'10','2','3',50),(24640,11,11,349,'10','2','4',50),(24641,11,11,349,'10','2','5',50),(24642,11,11,349,'10','2','6',50),(24643,11,11,349,'1','2','8',50),(24644,11,11,349,'M','2','9',50),(24645,11,11,349,'10','3','1',50),(24646,11,11,349,'10','3','2',50),(24647,11,11,349,'10','2','7',50),(24648,11,11,349,'10','3','5',50),(24649,11,11,349,'10','3','4',50),(24650,11,11,349,'10','3','3',50),(24651,11,11,349,'M','3','7',50),(24652,38,11,414,'10','1','1',57),(24653,11,11,349,'8','3','6',50),(24654,38,11,414,'10','1','2',57),(24655,11,11,349,'10','4','1',50),(24656,38,11,414,'10','1','3',57),(24657,11,11,349,'10','4','2',50),(24658,38,11,414,'10','1','4',57),(24659,38,11,414,'10','1','5',57),(24660,11,11,349,'10','4','3',50),(24661,38,11,414,'10','1','6',57),(24662,11,11,349,'10','4','4',50),(24663,38,11,414,'10','1','7',57),(24664,11,11,349,'M','3','9',50),(24665,38,11,414,'10','1','8',57),(24667,11,11,349,'M','4','6',50),(24668,11,11,349,'M','4','9',50),(24669,11,11,349,'M','4','7',50),(24670,38,11,414,'4','1','9',57),(24671,11,11,349,'10','4','5',50),(24672,38,11,414,'10','2','1',57),(24673,11,11,349,'M','4','8',50),(24674,38,11,414,'10','2','2',57),(24675,11,11,349,'M','3','8',50),(24676,38,11,414,'10','2','3',57),(24677,11,11,349,'10','5','1',50),(24678,11,11,349,'10','5','2',50),(24679,38,11,414,'10','2','4',57),(24680,11,11,349,'10','5','3',50),(24681,38,11,414,'10','2','5',57),(24682,11,11,349,'10','5','4',50),(24683,38,11,414,'10','2','6',57),(24684,11,11,349,'10','5','6',50),(24685,38,11,414,'10','2','7',57),(24686,11,11,349,'10','5','5',50),(24687,38,11,414,'9','2','8',57),(24688,11,11,349,'2','5','7',50),(24689,38,11,414,'M','2','9',57),(24690,38,11,414,'10','3','1',57),(24691,38,11,414,'10','3','2',57),(24692,11,11,349,'M','5','8',50),(24693,38,11,414,'10','3','3',57),(24694,38,11,414,'10','3','4',57),(24695,11,11,349,'M','5','9',50),(24696,38,11,414,'10','3','5',57),(24697,38,11,414,'10','3','6',57),(24698,11,11,349,'10','6','1',50),(24699,38,11,414,'10','3','7',57),(24700,11,11,349,'10','6','2',50),(24701,38,11,414,'2','3','8',57),(24702,11,11,349,'10','6','3',50),(24703,38,11,414,'M','3','9',57),(24704,38,11,414,'10','4','1',57),(24705,11,11,349,'10','6','4',50),(24706,38,11,414,'10','4','2',57),(24707,38,11,414,'10','4','3',57),(24708,38,11,414,'10','4','4',57),(24709,38,11,414,'10','4','5',57),(24710,38,11,414,'10','4','6',57),(24711,38,11,414,'M','4','7',57),(24712,38,11,414,'M','4','8',57),(24713,38,11,414,'M','4','9',57),(24714,11,11,349,'10','6','5',50),(24715,38,11,414,'10','5','1',57),(24716,11,11,349,'10','6','6',50),(24717,38,11,414,'10','5','2',57),(24718,38,11,414,'10','5','3',57),(24719,11,11,349,'M','6','7',50),(24720,38,11,414,'10','5','4',57),(24721,11,11,349,'M','6','8',50),(24722,38,11,414,'10','5','5',57),(24723,11,11,349,'M','6','9',50),(24724,38,11,414,'10','5','6',57),(24725,11,11,349,'10','7','1',50),(24726,38,11,414,'10','5','7',57),(24727,11,11,349,'10','7','2',50),(24728,38,11,414,'2','5','8',57),(24729,38,11,414,'M','5','9',57),(24730,11,11,349,'10','7','3',50),(24731,38,11,414,'10','6','1',57),(24732,38,11,414,'10','6','2',57),(24733,38,11,414,'10','6','3',57),(24734,38,11,414,'10','6','4',57),(24735,38,11,414,'10','6','5',57),(24736,38,11,414,'10','6','6',57),(24737,38,11,414,'10','6','7',57),(24738,38,11,414,'3','6','8',57),(24739,11,11,349,'10','7','4',50),(24740,38,11,414,'M','6','9',57),(24741,11,11,349,'10','7','5',50),(24742,11,11,349,'10','7','6',50),(24743,38,11,414,'10','7','1',57),(24744,38,11,414,'10','7','2',57),(24745,11,11,349,'4','7','7',50),(24746,38,11,414,'10','7','3',57),(24747,11,11,349,'M','7','8',50),(24748,38,11,414,'10','7','4',57),(24749,11,11,349,'M','7','9',50),(24750,38,11,414,'10','7','5',57),(24751,38,11,414,'10','7','6',57),(24752,38,11,414,'10','7','7',57),(24753,38,11,414,'10','7','8',57),(24754,38,11,414,'1','7','9',57),(24755,38,11,421,'10','1','2',57),(24756,38,11,421,'10','1','1',57),(24757,38,11,421,'10','1','3',57),(24758,38,11,421,'10','1','5',57),(24759,38,11,421,'10','1','6',57),(24760,38,11,421,'10','1','4',57),(24761,38,11,421,'10','1','7',57),(24762,38,11,421,'M','1','9',57),(24763,38,11,421,'7','1','8',57),(24764,38,11,421,'10','2','1',57),(24765,38,11,421,'10','2','2',57),(24766,38,11,421,'10','2','3',57),(24767,38,11,421,'10','2','4',57),(24768,38,11,421,'10','2','5',57),(24769,38,11,421,'10','2','6',57),(24770,38,11,421,'10','2','7',57),(24771,38,11,421,'3','2','8',57),(24772,38,11,421,'M','2','9',57),(24773,38,11,421,'10','3','1',57),(24774,38,11,421,'10','3','2',57),(24775,38,11,421,'10','3','3',57),(24776,38,11,421,'10','3','4',57),(24777,38,11,421,'10','3','5',57),(24778,38,11,421,'10','3','6',57),(24779,38,11,421,'5','3','7',57),(24780,38,11,421,'M','3','8',57),(24781,38,11,421,'M','3','9',57),(24782,38,11,421,'10','4','1',57),(24783,38,11,421,'10','4','2',57),(24784,38,11,421,'10','4','3',57),(24785,38,11,421,'10','4','4',57),(24786,38,11,421,'10','4','5',57),(24787,38,11,421,'10','4','6',57),(24788,38,11,421,'10','4','7',57),(24789,38,11,421,'6','4','8',57),(24790,38,11,421,'M','4','9',57),(24791,38,11,421,'10','5','1',57),(24792,38,11,421,'10','5','3',57),(24793,38,11,421,'10','5','2',57),(24794,38,11,421,'10','5','5',57),(24795,38,11,421,'10','5','4',57),(24796,38,11,421,'7','5','8',57),(24797,38,11,421,'10','5','6',57),(24798,38,11,421,'10','5','7',57),(24799,38,11,421,'M','5','9',57),(24800,38,11,421,'10','6','2',57),(24801,38,11,421,'10','6','1',57),(24802,38,11,421,'10','6','4',57),(24803,38,11,421,'10','6','3',57),(24804,38,11,421,'10','6','6',57),(24805,38,11,421,'5','6','7',57),(24806,38,11,421,'10','6','5',57),(24807,38,11,421,'M','6','9',57),(24808,38,11,421,'M','6','8',57),(24809,38,11,421,'10','7','1',57),(24810,38,11,421,'10','7','2',57),(24811,38,11,421,'10','7','3',57),(24812,38,11,421,'10','7','4',57),(24813,38,11,421,'10','7','5',57),(24814,38,11,421,'10','7','6',57),(24815,38,11,421,'10','7','7',57),(24816,38,11,421,'10','7','8',57),(24817,38,11,421,'2','7','9',57),(24818,38,11,291,'10','1','1',57),(24819,38,11,291,'10','1','2',57),(24820,38,11,291,'10','1','3',57),(24821,38,11,291,'10','1','4',57),(24822,38,11,291,'10','1','5',57),(24823,38,11,291,'10','1','6',57),(24824,38,11,291,'10','1','7',57),(24825,38,11,291,'1','1','8',57),(24826,38,11,291,'M','1','9',57),(24827,38,11,291,'10','2','1',57),(24828,38,11,291,'10','2','2',57),(24829,11,11,350,'10','1','1',50),(24830,38,11,291,'10','2','3',57),(24831,38,11,291,'10','2','4',57),(24832,11,11,350,'10','1','2',50),(24833,38,11,291,'10','2','5',57),(24834,11,11,350,'10','1','3',50),(24835,38,11,291,'10','2','6',57),(24836,11,11,350,'10','1','4',50),(24837,38,11,291,'10','2','7',57),(24838,11,11,350,'10','1','5',50),(24839,38,11,291,'2','2','8',57),(24840,11,11,350,'3','1','6',50),(24841,38,11,291,'M','2','9',57),(24842,38,11,291,'10','3','1',57),(24844,38,11,291,'10','3','2',57),(24845,38,11,291,'10','3','3',57),(24846,38,11,291,'10','3','4',57),(24847,38,11,291,'10','3','5',57),(24848,11,11,350,'M','1','7',50),(24849,38,11,291,'10','3','6',57),(24850,11,11,350,'M','1','8',50),(24851,38,11,291,'10','3','7',57),(24852,38,11,291,'9','3','8',57),(24853,11,11,350,'M','1','9',50),(24854,38,11,291,'M','3','9',57),(24855,11,11,350,'10','2','1',50),(24856,38,11,291,'10','4','1',57),(24857,11,11,350,'10','2','2',50),(24858,38,11,291,'10','4','2',57),(24859,11,11,350,'10','2','3',50),(24860,38,11,291,'10','4','3',57),(24861,11,11,350,'10','2','4',50),(24862,38,11,291,'10','4','4',57),(24863,38,11,291,'10','4','5',57),(24864,11,11,350,'10','2','5',50),(24865,38,11,291,'10','4','6',57),(24866,11,11,350,'1','2','6',50),(24867,38,11,291,'10','4','7',57),(24868,11,11,350,'M','2','8',50),(24869,38,11,291,'1','4','8',57),(24870,11,11,350,'M','2','9',50),(24871,38,11,291,'M','4','9',57),(24872,11,11,350,'10','3','1',50),(24873,11,11,350,'10','3','2',50),(24874,11,11,350,'M','2','7',50),(24875,11,11,350,'10','3','4',50),(24876,11,11,350,'10','3','6',50),(24877,38,11,291,'10','5','1',57),(24878,11,11,350,'10','3','5',50),(24879,38,11,291,'10','5','2',57),(24880,11,11,350,'10','3','3',50),(24881,38,11,291,'10','5','3',57),(24882,38,11,291,'10','5','4',57),(24883,38,11,291,'10','5','5',57),(24884,11,11,350,'M','3','7',50),(24885,38,11,291,'10','5','6',57),(24886,11,11,350,'M','3','8',50),(24887,38,11,291,'10','5','7',57),(24888,11,11,350,'M','3','9',50),(24889,38,11,291,'9','5','8',57),(24890,11,11,350,'10','4','1',50),(24891,38,11,291,'M','5','9',57),(24892,11,11,350,'10','4','2',50),(24893,11,11,350,'10','4','3',50),(24894,38,11,291,'10','6','1',57),(24895,38,11,291,'10','6','2',57),(24896,11,11,350,'10','4','4',50),(24897,38,11,291,'10','6','3',57),(24898,11,11,350,'10','4','5',50),(24899,38,11,291,'10','6','4',57),(24900,11,11,350,'10','4','7',50),(24901,38,11,291,'10','6','5',57),(24902,11,11,350,'10','4','6',50),(24903,38,11,291,'10','6','6',57),(24904,11,11,350,'M','4','9',50),(24905,38,11,291,'10','6','7',57),(24906,38,11,291,'1','6','8',57),(24907,11,11,350,'4','4','8',50),(24908,38,11,291,'M','6','9',57),(24909,11,11,350,'10','5','1',50),(24910,11,11,350,'10','5','2',50),(24911,38,11,291,'10','7','1',57),(24912,11,11,350,'10','5','3',50),(24913,38,11,291,'10','7','2',57),(24914,11,11,350,'10','5','6',50),(24915,38,11,291,'10','7','3',57),(24916,11,11,350,'10','5','5',50),(24917,38,11,291,'10','7','4',57),(24918,11,11,350,'M','5','8',50),(24919,38,11,291,'10','7','5',57),(24920,38,11,291,'10','7','6',57),(24921,11,11,350,'M','5','9',50),(24922,38,11,291,'10','7','7',57),(24923,11,11,350,'10','6','2',50),(24924,38,11,291,'2','7','8',57),(24925,11,11,350,'10','6','1',50),(24926,38,11,291,'M','7','9',57),(24927,11,11,350,'10','5','4',50),(24928,11,11,350,'10','6','4',50),(24929,11,11,350,'4','6','6',50),(24930,11,11,350,'10','6','3',50),(24931,11,11,350,'4','5','7',50),(24933,11,11,350,'10','6','5',50),(24937,11,11,350,'M','6','7',50),(24938,11,11,350,'M','6','8',50),(24939,11,11,350,'M','6','9',50),(24940,11,11,350,'10','7','1',50),(24941,11,11,350,'10','7','2',50),(24942,11,11,350,'10','7','3',50),(24943,11,11,350,'10','7','4',50),(24944,11,11,350,'10','7','5',50),(24945,11,11,350,'9','7','6',50),(24946,11,11,350,'M','7','7',50),(24947,11,11,350,'M','7','8',50),(24948,11,11,350,'M','7','9',50),(24949,38,11,426,'10','1','1',57),(24950,38,11,426,'10','1','2',57),(24951,38,11,426,'10','1','3',57),(24952,38,11,426,'10','1','4',57),(24953,38,11,426,'10','1','5',57),(24954,38,11,426,'10','1','6',57),(24955,38,11,426,'10','1','7',57),(24956,38,11,426,'M','1','9',57),(24957,38,11,426,'M','1','8',57),(24958,38,11,426,'10','2','1',57),(24959,38,11,426,'10','2','2',57),(24960,38,11,426,'10','2','3',57),(24961,38,11,426,'10','2','4',57),(24962,38,11,426,'10','2','5',57),(24963,38,11,426,'10','2','6',57),(24964,38,11,426,'10','2','7',57),(24965,38,11,426,'6','2','8',57),(24967,38,11,426,'M','2','9',57),(24968,11,11,351,'10','1','2',50),(24969,38,11,426,'10','3','2',57),(24970,11,11,351,'10','1','3',50),(24971,38,11,426,'10','3','3',57),(24972,11,11,351,'10','1','4',50),(24973,38,11,426,'10','3','4',57),(24974,11,11,351,'10','1','5',50),(24975,38,11,426,'10','3','5',57),(24976,38,11,426,'10','3','1',57),(24977,11,11,351,'10','1','6',50),(24978,38,11,426,'10','3','7',57),(24979,11,11,351,'3','1','7',50),(24980,38,11,426,'10','3','6',57),(24981,11,11,351,'M','1','8',50),(24983,11,11,351,'10','2','1',50),(24984,11,11,351,'M','1','9',50),(24985,11,11,351,'10','2','2',50),(24986,11,11,351,'10','2','3',50),(24987,38,11,426,'9','3','8',57),(24988,11,11,351,'10','2','4',50),(24989,38,11,426,'M','3','9',57),(24990,11,11,351,'7','2','5',50),(24991,11,11,351,'M','2','6',50),(24992,38,11,426,'10','4','1',57),(24993,11,11,351,'M','2','7',50),(24994,38,11,426,'10','4','2',57),(24995,11,11,351,'M','2','8',50),(24996,38,11,426,'10','4','3',57),(24997,11,11,351,'M','2','9',50),(24998,38,11,426,'10','4','4',57),(24999,11,11,351,'10','3','2',50),(25000,38,11,426,'10','4','5',57),(25001,38,11,426,'10','4','6',57),(25002,11,11,351,'10','3','1',50),(25003,38,11,426,'10','4','7',57),(25004,11,11,351,'10','3','4',50),(25005,38,11,426,'4','4','8',57),(25006,11,11,351,'10','3','3',50),(25007,38,11,426,'M','4','9',57),(25008,11,11,351,'10','3','6',50),(25009,38,11,426,'10','5','1',57),(25010,11,11,351,'M','3','7',50),(25011,38,11,426,'10','5','2',57),(25012,11,11,351,'10','3','5',50),(25013,38,11,426,'10','5','3',57),(25014,11,11,351,'M','3','9',50),(25015,38,11,426,'10','5','4',57),(25016,11,11,351,'10','4','1',50),(25017,38,11,426,'10','5','5',57),(25018,11,11,351,'M','3','8',50),(25019,38,11,426,'10','5','6',57),(25020,11,11,351,'10','4','2',50),(25021,38,11,426,'10','5','7',57)